/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-cfu-firmware-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_cfu_offer_component_id_to_string(FuCfuOfferComponentId val)
{
    if (val == FU_CFU_OFFER_COMPONENT_ID_NOT_USED)
        return "not-used";
    if (val == FU_CFU_OFFER_COMPONENT_ID_OFFER_INFORMATION)
        return "offer-information";
    if (val == FU_CFU_OFFER_COMPONENT_ID_OFFER_INFORMATION2)
        return "offer-information2";
    return NULL;
}
/**
 * fu_struct_cfu_payload_ref: (skip):
 **/
FuStructCfuPayload *
fu_struct_cfu_payload_ref(FuStructCfuPayload *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_cfu_payload_unref: (skip):
 **/
void
fu_struct_cfu_payload_unref(FuStructCfuPayload *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCfuPayload refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructCfuPayload *
fu_struct_cfu_payload_new_internal(void)
{
    FuStructCfuPayload *st = g_new0(FuStructCfuPayload, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_cfu_payload_get_addr: (skip):
 **/
guint32
fu_struct_cfu_payload_get_addr(const FuStructCfuPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_payload_get_size: (skip):
 **/
guint8
fu_struct_cfu_payload_get_size(const FuStructCfuPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}

/* setters */
/**
 * fu_struct_cfu_payload_set_addr: (skip):
 **/
void
fu_struct_cfu_payload_set_addr(FuStructCfuPayload *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_payload_set_size: (skip):
 **/
void
fu_struct_cfu_payload_set_size(FuStructCfuPayload *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_cfu_payload_new: (skip):
 **/
FuStructCfuPayload *
fu_struct_cfu_payload_new(void)
{
    FuStructCfuPayload *st = fu_struct_cfu_payload_new_internal();
    st->buf = g_byte_array_sized_new(5);
    fu_byte_array_set_size(st->buf, 5, 0x0);
    return st;
}
/**
 * fu_struct_cfu_payload_to_string: (skip):
 **/
static gchar *
fu_struct_cfu_payload_to_string(const FuStructCfuPayload *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCfuPayload:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  addr: 0x%x\n",
                           (guint) fu_struct_cfu_payload_get_addr(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_cfu_payload_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_cfu_payload_validate_internal(FuStructCfuPayload *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_cfu_payload_parse_internal(FuStructCfuPayload *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_cfu_payload_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_cfu_payload_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_cfu_payload_parse_stream: (skip):
 **/
FuStructCfuPayload *
fu_struct_cfu_payload_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCfuPayload) st = fu_struct_cfu_payload_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 5, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCfuPayload failed read of 0x%x: ", (guint) 5);
        return NULL;
    }
    if (st->buf->len != 5) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCfuPayload requested 0x%x and got 0x%x",
                    (guint) 5,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_cfu_payload_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cfu_offer_ref: (skip):
 **/
FuStructCfuOffer *
fu_struct_cfu_offer_ref(FuStructCfuOffer *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_cfu_offer_unref: (skip):
 **/
void
fu_struct_cfu_offer_unref(FuStructCfuOffer *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCfuOffer refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructCfuOffer *
fu_struct_cfu_offer_new_internal(void)
{
    FuStructCfuOffer *st = g_new0(FuStructCfuOffer, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_cfu_offer_get_segment_number: (skip):
 **/
guint8
fu_struct_cfu_offer_get_segment_number(const FuStructCfuOffer *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_cfu_offer_get_flags1: (skip):
 **/
guint8
fu_struct_cfu_offer_get_flags1(const FuStructCfuOffer *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_cfu_offer_get_component_id: (skip):
 **/
FuCfuOfferComponentId
fu_struct_cfu_offer_get_component_id(const FuStructCfuOffer *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_cfu_offer_get_token: (skip):
 **/
guint8
fu_struct_cfu_offer_get_token(const FuStructCfuOffer *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_cfu_offer_get_version: (skip):
 **/
guint32
fu_struct_cfu_offer_get_version(const FuStructCfuOffer *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_offer_get_compat_variant_mask: (skip):
 **/
guint32
fu_struct_cfu_offer_get_compat_variant_mask(const FuStructCfuOffer *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_offer_get_flags2: (skip):
 **/
guint8
fu_struct_cfu_offer_get_flags2(const FuStructCfuOffer *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[12];
}
/**
 * fu_struct_cfu_offer_get_flags3: (skip):
 **/
guint8
fu_struct_cfu_offer_get_flags3(const FuStructCfuOffer *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[13];
}
/**
 * fu_struct_cfu_offer_get_product_id: (skip):
 **/
guint16
fu_struct_cfu_offer_get_product_id(const FuStructCfuOffer *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 14, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_cfu_offer_set_segment_number: (skip):
 **/
void
fu_struct_cfu_offer_set_segment_number(FuStructCfuOffer *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_cfu_offer_set_flags1: (skip):
 **/
void
fu_struct_cfu_offer_set_flags1(FuStructCfuOffer *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_cfu_offer_set_component_id: (skip):
 **/
void
fu_struct_cfu_offer_set_component_id(FuStructCfuOffer *st, FuCfuOfferComponentId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_cfu_offer_set_token: (skip):
 **/
void
fu_struct_cfu_offer_set_token(FuStructCfuOffer *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_cfu_offer_set_version: (skip):
 **/
void
fu_struct_cfu_offer_set_version(FuStructCfuOffer *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_offer_set_compat_variant_mask: (skip):
 **/
void
fu_struct_cfu_offer_set_compat_variant_mask(FuStructCfuOffer *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_offer_set_flags2: (skip):
 **/
void
fu_struct_cfu_offer_set_flags2(FuStructCfuOffer *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[12] = value;
}
/**
 * fu_struct_cfu_offer_set_flags3: (skip):
 **/
void
fu_struct_cfu_offer_set_flags3(FuStructCfuOffer *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[13] = value;
}
/**
 * fu_struct_cfu_offer_set_product_id: (skip):
 **/
void
fu_struct_cfu_offer_set_product_id(FuStructCfuOffer *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 14, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cfu_offer_new: (skip):
 **/
FuStructCfuOffer *
fu_struct_cfu_offer_new(void)
{
    FuStructCfuOffer *st = fu_struct_cfu_offer_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    return st;
}
/**
 * fu_struct_cfu_offer_to_string: (skip):
 **/
static gchar *
fu_struct_cfu_offer_to_string(const FuStructCfuOffer *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCfuOffer:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  segment_number: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_segment_number(st));
    g_string_append_printf(str, "  flags1: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_flags1(st));
    {
        const gchar *tmp = fu_cfu_offer_component_id_to_string(fu_struct_cfu_offer_get_component_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  component_id: 0x%x [%s]\n", (guint) fu_struct_cfu_offer_get_component_id(st), tmp);
        } else {
            g_string_append_printf(str, "  component_id: 0x%x\n", (guint) fu_struct_cfu_offer_get_component_id(st));
        }
    }
    g_string_append_printf(str, "  token: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_token(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_version(st));
    g_string_append_printf(str, "  compat_variant_mask: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_compat_variant_mask(st));
    g_string_append_printf(str, "  flags2: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_flags2(st));
    g_string_append_printf(str, "  flags3: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_flags3(st));
    g_string_append_printf(str, "  product_id: 0x%x\n",
                           (guint) fu_struct_cfu_offer_get_product_id(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_cfu_offer_validate_internal(FuStructCfuOffer *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_cfu_offer_parse_internal(FuStructCfuOffer *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_cfu_offer_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_cfu_offer_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_cfu_offer_parse_stream: (skip):
 **/
FuStructCfuOffer *
fu_struct_cfu_offer_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCfuOffer) st = fu_struct_cfu_offer_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 16, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCfuOffer failed read of 0x%x: ", (guint) 16);
        return NULL;
    }
    if (st->buf->len != 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCfuOffer requested 0x%x and got 0x%x",
                    (guint) 16,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_cfu_offer_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
