/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-acpi-phat-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/**
 * fu_struct_acpi_phat_hdr_ref: (skip):
 **/
FuStructAcpiPhatHdr *
fu_struct_acpi_phat_hdr_ref(FuStructAcpiPhatHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_acpi_phat_hdr_unref: (skip):
 **/
void
fu_struct_acpi_phat_hdr_unref(FuStructAcpiPhatHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAcpiPhatHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAcpiPhatHdr *
fu_struct_acpi_phat_hdr_new_internal(void)
{
    FuStructAcpiPhatHdr *st = g_new0(FuStructAcpiPhatHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_acpi_phat_hdr_get_magic: (skip):
 **/
static gchar *
fu_struct_acpi_phat_hdr_get_magic(const FuStructAcpiPhatHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 4, NULL);
}

/* setters */
static gboolean
fu_struct_acpi_phat_hdr_validate_internal(FuStructAcpiPhatHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "PHAT", 4) != 0) {
        g_autofree gchar *str = fu_struct_acpi_phat_hdr_get_magic(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructAcpiPhatHdr.magic was not valid, "
                    "expected 'PHAT' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_acpi_phat_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_acpi_phat_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructAcpiPhatHdr) st = fu_struct_acpi_phat_hdr_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 4, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructAcpiPhatHdr failed read of 0x%x: ", (guint) 4);
        return FALSE;
    }
    if (st->buf->len != 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructAcpiPhatHdr requested 0x%x and got 0x%x",
                    (guint) 4,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_acpi_phat_hdr_validate_internal(st, error);
}
/**
 * fu_struct_acpi_phat_health_record_ref: (skip):
 **/
FuStructAcpiPhatHealthRecord *
fu_struct_acpi_phat_health_record_ref(FuStructAcpiPhatHealthRecord *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_acpi_phat_health_record_unref: (skip):
 **/
void
fu_struct_acpi_phat_health_record_unref(FuStructAcpiPhatHealthRecord *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAcpiPhatHealthRecord refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAcpiPhatHealthRecord *
fu_struct_acpi_phat_health_record_new_internal(void)
{
    FuStructAcpiPhatHealthRecord *st = g_new0(FuStructAcpiPhatHealthRecord, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_acpi_phat_health_record_get_signature: (skip):
 **/
guint16
fu_struct_acpi_phat_health_record_get_signature(const FuStructAcpiPhatHealthRecord *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_health_record_get_rcdlen: (skip):
 **/
guint16
fu_struct_acpi_phat_health_record_get_rcdlen(const FuStructAcpiPhatHealthRecord *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_health_record_get_version: (skip):
 **/
guint8
fu_struct_acpi_phat_health_record_get_version(const FuStructAcpiPhatHealthRecord *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_acpi_phat_health_record_get_flags: (skip):
 **/
guint8
fu_struct_acpi_phat_health_record_get_flags(const FuStructAcpiPhatHealthRecord *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_acpi_phat_health_record_get_device_signature: (skip):
 **/
const fwupd_guid_t *
fu_struct_acpi_phat_health_record_get_device_signature(const FuStructAcpiPhatHealthRecord *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 8);
}
/**
 * fu_struct_acpi_phat_health_record_get_device_specific_data: (skip):
 **/
guint32
fu_struct_acpi_phat_health_record_get_device_specific_data(const FuStructAcpiPhatHealthRecord *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_acpi_phat_health_record_set_signature: (skip):
 **/
void
fu_struct_acpi_phat_health_record_set_signature(FuStructAcpiPhatHealthRecord *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_health_record_set_rcdlen: (skip):
 **/
void
fu_struct_acpi_phat_health_record_set_rcdlen(FuStructAcpiPhatHealthRecord *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_health_record_set_version: (skip):
 **/
void
fu_struct_acpi_phat_health_record_set_version(FuStructAcpiPhatHealthRecord *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_acpi_phat_health_record_set_flags: (skip):
 **/
void
fu_struct_acpi_phat_health_record_set_flags(FuStructAcpiPhatHealthRecord *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_acpi_phat_health_record_set_device_signature: (skip):
 **/
void
fu_struct_acpi_phat_health_record_set_device_signature(FuStructAcpiPhatHealthRecord *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 8, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_acpi_phat_health_record_set_device_specific_data: (skip):
 **/
void
fu_struct_acpi_phat_health_record_set_device_specific_data(FuStructAcpiPhatHealthRecord *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_health_record_new: (skip):
 **/
FuStructAcpiPhatHealthRecord *
fu_struct_acpi_phat_health_record_new(void)
{
    FuStructAcpiPhatHealthRecord *st = fu_struct_acpi_phat_health_record_new_internal();
    st->buf = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st->buf, 28, 0x0);
    fu_struct_acpi_phat_health_record_set_signature(st, 0x1);
    return st;
}
/**
 * fu_struct_acpi_phat_health_record_to_string: (skip):
 **/
static gchar *
fu_struct_acpi_phat_health_record_to_string(const FuStructAcpiPhatHealthRecord *st)
{
    g_autoptr(GString) str = g_string_new("FuStructAcpiPhatHealthRecord:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  signature: 0x%x\n",
                           (guint) fu_struct_acpi_phat_health_record_get_signature(st));
    g_string_append_printf(str, "  rcdlen: 0x%x\n",
                           (guint) fu_struct_acpi_phat_health_record_get_rcdlen(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_acpi_phat_health_record_get_version(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_acpi_phat_health_record_get_flags(st));
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_acpi_phat_health_record_get_device_signature(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  device_signature: %s\n", tmp);
    }
    g_string_append_printf(str, "  device_specific_data: 0x%x\n",
                           (guint) fu_struct_acpi_phat_health_record_get_device_specific_data(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_acpi_phat_health_record_validate_internal(FuStructAcpiPhatHealthRecord *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_acpi_phat_health_record_parse_internal(FuStructAcpiPhatHealthRecord *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_acpi_phat_health_record_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_acpi_phat_health_record_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_acpi_phat_health_record_parse_stream: (skip):
 **/
FuStructAcpiPhatHealthRecord *
fu_struct_acpi_phat_health_record_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructAcpiPhatHealthRecord) st = fu_struct_acpi_phat_health_record_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 28, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructAcpiPhatHealthRecord failed read of 0x%x: ", (guint) 28);
        return NULL;
    }
    if (st->buf->len != 28) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructAcpiPhatHealthRecord requested 0x%x and got 0x%x",
                    (guint) 28,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_acpi_phat_health_record_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_acpi_phat_version_element_ref: (skip):
 **/
FuStructAcpiPhatVersionElement *
fu_struct_acpi_phat_version_element_ref(FuStructAcpiPhatVersionElement *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_acpi_phat_version_element_unref: (skip):
 **/
void
fu_struct_acpi_phat_version_element_unref(FuStructAcpiPhatVersionElement *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAcpiPhatVersionElement refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAcpiPhatVersionElement *
fu_struct_acpi_phat_version_element_new_internal(void)
{
    FuStructAcpiPhatVersionElement *st = g_new0(FuStructAcpiPhatVersionElement, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_acpi_phat_version_element_get_component_id: (skip):
 **/
const fwupd_guid_t *
fu_struct_acpi_phat_version_element_get_component_id(const FuStructAcpiPhatVersionElement *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->buf->data + 0);
}
/**
 * fu_struct_acpi_phat_version_element_get_version_value: (skip):
 **/
guint64
fu_struct_acpi_phat_version_element_get_version_value(const FuStructAcpiPhatVersionElement *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_version_element_get_producer_id: (skip):
 **/
gchar *
fu_struct_acpi_phat_version_element_get_producer_id(const FuStructAcpiPhatVersionElement *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 24, 4, NULL);
}

/* setters */
/**
 * fu_struct_acpi_phat_version_element_set_component_id: (skip):
 **/
void
fu_struct_acpi_phat_version_element_set_component_id(FuStructAcpiPhatVersionElement *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->buf->data + 0, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_acpi_phat_version_element_set_version_value: (skip):
 **/
void
fu_struct_acpi_phat_version_element_set_version_value(FuStructAcpiPhatVersionElement *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_version_element_set_producer_id: (skip):
 **/
gboolean
fu_struct_acpi_phat_version_element_set_producer_id(FuStructAcpiPhatVersionElement *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 24, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructAcpiPhatVersionElement.producer_id (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 24, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_acpi_phat_version_element_new: (skip):
 **/
FuStructAcpiPhatVersionElement *
fu_struct_acpi_phat_version_element_new(void)
{
    FuStructAcpiPhatVersionElement *st = fu_struct_acpi_phat_version_element_new_internal();
    st->buf = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st->buf, 28, 0x0);
    return st;
}
/**
 * fu_struct_acpi_phat_version_element_to_string: (skip):
 **/
static gchar *
fu_struct_acpi_phat_version_element_to_string(const FuStructAcpiPhatVersionElement *st)
{
    g_autoptr(GString) str = g_string_new("FuStructAcpiPhatVersionElement:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_acpi_phat_version_element_get_component_id(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  component_id: %s\n", tmp);
    }
    g_string_append_printf(str, "  version_value: 0x%x\n",
                           (guint) fu_struct_acpi_phat_version_element_get_version_value(st));
    {
        g_autofree gchar *tmp = fu_struct_acpi_phat_version_element_get_producer_id(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  producer_id: %s\n", tmp);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_acpi_phat_version_element_validate_internal(FuStructAcpiPhatVersionElement *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_acpi_phat_version_element_parse_internal(FuStructAcpiPhatVersionElement *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_acpi_phat_version_element_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_acpi_phat_version_element_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_acpi_phat_version_element_parse_stream: (skip):
 **/
FuStructAcpiPhatVersionElement *
fu_struct_acpi_phat_version_element_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructAcpiPhatVersionElement) st = fu_struct_acpi_phat_version_element_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 28, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructAcpiPhatVersionElement failed read of 0x%x: ", (guint) 28);
        return NULL;
    }
    if (st->buf->len != 28) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructAcpiPhatVersionElement requested 0x%x and got 0x%x",
                    (guint) 28,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_acpi_phat_version_element_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_acpi_phat_version_record_ref: (skip):
 **/
FuStructAcpiPhatVersionRecord *
fu_struct_acpi_phat_version_record_ref(FuStructAcpiPhatVersionRecord *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_acpi_phat_version_record_unref: (skip):
 **/
void
fu_struct_acpi_phat_version_record_unref(FuStructAcpiPhatVersionRecord *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAcpiPhatVersionRecord refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAcpiPhatVersionRecord *
fu_struct_acpi_phat_version_record_new_internal(void)
{
    FuStructAcpiPhatVersionRecord *st = g_new0(FuStructAcpiPhatVersionRecord, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_acpi_phat_version_record_get_signature: (skip):
 **/
guint16
fu_struct_acpi_phat_version_record_get_signature(const FuStructAcpiPhatVersionRecord *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_version_record_get_rcdlen: (skip):
 **/
guint16
fu_struct_acpi_phat_version_record_get_rcdlen(const FuStructAcpiPhatVersionRecord *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_version_record_get_version: (skip):
 **/
guint8
fu_struct_acpi_phat_version_record_get_version(const FuStructAcpiPhatVersionRecord *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_acpi_phat_version_record_get_record_count: (skip):
 **/
guint32
fu_struct_acpi_phat_version_record_get_record_count(const FuStructAcpiPhatVersionRecord *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_acpi_phat_version_record_set_signature: (skip):
 **/
void
fu_struct_acpi_phat_version_record_set_signature(FuStructAcpiPhatVersionRecord *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_version_record_set_rcdlen: (skip):
 **/
void
fu_struct_acpi_phat_version_record_set_rcdlen(FuStructAcpiPhatVersionRecord *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_version_record_set_version: (skip):
 **/
void
fu_struct_acpi_phat_version_record_set_version(FuStructAcpiPhatVersionRecord *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_acpi_phat_version_record_set_record_count: (skip):
 **/
void
fu_struct_acpi_phat_version_record_set_record_count(FuStructAcpiPhatVersionRecord *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_acpi_phat_version_record_new: (skip):
 **/
FuStructAcpiPhatVersionRecord *
fu_struct_acpi_phat_version_record_new(void)
{
    FuStructAcpiPhatVersionRecord *st = fu_struct_acpi_phat_version_record_new_internal();
    st->buf = g_byte_array_sized_new(12);
    fu_byte_array_set_size(st->buf, 12, 0x0);
    fu_struct_acpi_phat_version_record_set_signature(st, 0x0);
    return st;
}
/**
 * fu_struct_acpi_phat_version_record_to_string: (skip):
 **/
static gchar *
fu_struct_acpi_phat_version_record_to_string(const FuStructAcpiPhatVersionRecord *st)
{
    g_autoptr(GString) str = g_string_new("FuStructAcpiPhatVersionRecord:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  signature: 0x%x\n",
                           (guint) fu_struct_acpi_phat_version_record_get_signature(st));
    g_string_append_printf(str, "  rcdlen: 0x%x\n",
                           (guint) fu_struct_acpi_phat_version_record_get_rcdlen(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_acpi_phat_version_record_get_version(st));
    g_string_append_printf(str, "  record_count: 0x%x\n",
                           (guint) fu_struct_acpi_phat_version_record_get_record_count(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_acpi_phat_version_record_validate_internal(FuStructAcpiPhatVersionRecord *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_acpi_phat_version_record_parse_internal(FuStructAcpiPhatVersionRecord *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_acpi_phat_version_record_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_acpi_phat_version_record_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_acpi_phat_version_record_parse_stream: (skip):
 **/
FuStructAcpiPhatVersionRecord *
fu_struct_acpi_phat_version_record_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructAcpiPhatVersionRecord) st = fu_struct_acpi_phat_version_record_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 12, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructAcpiPhatVersionRecord failed read of 0x%x: ", (guint) 12);
        return NULL;
    }
    if (st->buf->len != 12) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructAcpiPhatVersionRecord requested 0x%x and got 0x%x",
                    (guint) 12,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_acpi_phat_version_record_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
