/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-synaprom-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


static const gchar *
fu_synaprom_product_to_string(FuSynapromProduct val)
{
    if (val == FU_SYNAPROM_PRODUCT_PROMETHEUS)
        return "prometheus";
    if (val == FU_SYNAPROM_PRODUCT_PROMETHEUSPBL)
        return "prometheuspbl";
    if (val == FU_SYNAPROM_PRODUCT_PROMETHEUSMSBL)
        return "prometheusmsbl";
    if (val == FU_SYNAPROM_PRODUCT_TRITON)
        return "triton";
    if (val == FU_SYNAPROM_PRODUCT_TRITONPBL)
        return "tritonpbl";
    if (val == FU_SYNAPROM_PRODUCT_TRITONMSBL)
        return "tritonmsbl";
    return NULL;
}

const gchar *
fu_synaprom_result_to_string(FuSynapromResult val)
{
    if (val == FU_SYNAPROM_RESULT_OK)
        return "ok";
    if (val == FU_SYNAPROM_RESULT_GEN_OPERATION_CANCELED)
        return "gen-operation-canceled";
    if (val == FU_SYNAPROM_RESULT_GEN_INVALID)
        return "gen-invalid";
    if (val == FU_SYNAPROM_RESULT_GEN_BAD_PARAM)
        return "gen-bad-param";
    if (val == FU_SYNAPROM_RESULT_GEN_NULL_POINTER)
        return "gen-null-pointer";
    if (val == FU_SYNAPROM_RESULT_GEN_UNEXPECTED_FORMAT)
        return "gen-unexpected-format";
    if (val == FU_SYNAPROM_RESULT_GEN_TIMEOUT)
        return "gen-timeout";
    if (val == FU_SYNAPROM_RESULT_GEN_OBJECT_DOESNT_EXIST)
        return "gen-object-doesnt-exist";
    if (val == FU_SYNAPROM_RESULT_GEN_ERROR)
        return "gen-error";
    if (val == FU_SYNAPROM_RESULT_SENSOR_MALFUNCTIONED)
        return "sensor-malfunctioned";
    if (val == FU_SYNAPROM_RESULT_SYS_OUT_OF_MEMORY)
        return "sys-out-of-memory";
    return NULL;
}


const gchar *
fu_synaprom_firmware_tag_to_string(FuSynapromFirmwareTag val)
{
    if (val == FU_SYNAPROM_FIRMWARE_TAG_MFW_UPDATE_HEADER)
        return "mfw-update-header";
    if (val == FU_SYNAPROM_FIRMWARE_TAG_MFW_UPDATE_PAYLOAD)
        return "mfw-update-payload";
    if (val == FU_SYNAPROM_FIRMWARE_TAG_CFG_UPDATE_HEADER)
        return "cfg-update-header";
    if (val == FU_SYNAPROM_FIRMWARE_TAG_CFG_UPDATE_PAYLOAD)
        return "cfg-update-payload";
    return NULL;
}
/**
 * fu_struct_synaprom_request_ref: (skip):
 **/
FuStructSynapromRequest *
fu_struct_synaprom_request_ref(FuStructSynapromRequest *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaprom_request_unref: (skip):
 **/
void
fu_struct_synaprom_request_unref(FuStructSynapromRequest *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapromRequest refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapromRequest *
fu_struct_synaprom_request_new_internal(void)
{
    FuStructSynapromRequest *st = g_new0(FuStructSynapromRequest, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_synaprom_request_set_cmd: (skip):
 **/
void
fu_struct_synaprom_request_set_cmd(FuStructSynapromRequest *st, FuSynapromCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_synaprom_request_new: (skip):
 **/
FuStructSynapromRequest *
fu_struct_synaprom_request_new(void)
{
    FuStructSynapromRequest *st = fu_struct_synaprom_request_new_internal();
    st->buf = g_byte_array_sized_new(1);
    fu_byte_array_set_size(st->buf, 1, 0x0);
    return st;
}
/**
 * fu_struct_synaprom_reply_generic_ref: (skip):
 **/
FuStructSynapromReplyGeneric *
fu_struct_synaprom_reply_generic_ref(FuStructSynapromReplyGeneric *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaprom_reply_generic_unref: (skip):
 **/
void
fu_struct_synaprom_reply_generic_unref(FuStructSynapromReplyGeneric *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapromReplyGeneric refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapromReplyGeneric *
fu_struct_synaprom_reply_generic_new_internal(void)
{
    FuStructSynapromReplyGeneric *st = g_new0(FuStructSynapromReplyGeneric, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaprom_reply_generic_get_status: (skip):
 **/
guint16
fu_struct_synaprom_reply_generic_get_status(const FuStructSynapromReplyGeneric *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaprom_reply_generic_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_reply_generic_to_string(const FuStructSynapromReplyGeneric *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapromReplyGeneric:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_generic_get_status(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaprom_reply_generic_validate_internal(FuStructSynapromReplyGeneric *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaprom_reply_generic_parse_internal(FuStructSynapromReplyGeneric *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaprom_reply_generic_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaprom_reply_generic_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_synaprom_reply_generic_parse: (skip):
 **/
FuStructSynapromReplyGeneric *
fu_struct_synaprom_reply_generic_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapromReplyGeneric) st = fu_struct_synaprom_reply_generic_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSynapromReplyGeneric: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 2);
    if (!fu_struct_synaprom_reply_generic_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaprom_reply_get_version_ref: (skip):
 **/
FuStructSynapromReplyGetVersion *
fu_struct_synaprom_reply_get_version_ref(FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaprom_reply_get_version_unref: (skip):
 **/
void
fu_struct_synaprom_reply_get_version_unref(FuStructSynapromReplyGetVersion *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapromReplyGetVersion refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapromReplyGetVersion *
fu_struct_synaprom_reply_get_version_new_internal(void)
{
    FuStructSynapromReplyGetVersion *st = g_new0(FuStructSynapromReplyGetVersion, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaprom_reply_get_version_get_status: (skip):
 **/
guint16
fu_struct_synaprom_reply_get_version_get_status(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_reply_get_version_get_buildtime: (skip):
 **/
guint32
fu_struct_synaprom_reply_get_version_get_buildtime(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_reply_get_version_get_buildnum: (skip):
 **/
guint32
fu_struct_synaprom_reply_get_version_get_buildnum(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_reply_get_version_get_vmajor: (skip):
 **/
guint8
fu_struct_synaprom_reply_get_version_get_vmajor(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[10];
}
/**
 * fu_struct_synaprom_reply_get_version_get_vminor: (skip):
 **/
guint8
fu_struct_synaprom_reply_get_version_get_vminor(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[11];
}
/**
 * fu_struct_synaprom_reply_get_version_get_target: (skip):
 **/
guint8
fu_struct_synaprom_reply_get_version_get_target(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[12];
}
/**
 * fu_struct_synaprom_reply_get_version_get_product: (skip):
 **/
FuSynapromProduct
fu_struct_synaprom_reply_get_version_get_product(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[13];
}
/**
 * fu_struct_synaprom_reply_get_version_get_siliconrev: (skip):
 **/
guint8
fu_struct_synaprom_reply_get_version_get_siliconrev(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[14];
}
/**
 * fu_struct_synaprom_reply_get_version_get_formalrel: (skip):
 **/
guint8
fu_struct_synaprom_reply_get_version_get_formalrel(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[15];
}
/**
 * fu_struct_synaprom_reply_get_version_get_platform: (skip):
 **/
guint8
fu_struct_synaprom_reply_get_version_get_platform(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[16];
}
/**
 * fu_struct_synaprom_reply_get_version_get_patch: (skip):
 **/
guint8
fu_struct_synaprom_reply_get_version_get_patch(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[17];
}
/**
 * fu_struct_synaprom_reply_get_version_get_serial_number: (skip):
 **/
const guint8 *
fu_struct_synaprom_reply_get_version_get_serial_number(const FuStructSynapromReplyGetVersion *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 6;
    return st->buf->data + 18;
}
/**
 * fu_struct_synaprom_reply_get_version_get_security0: (skip):
 **/
guint8
fu_struct_synaprom_reply_get_version_get_security0(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[24];
}
/**
 * fu_struct_synaprom_reply_get_version_get_security1: (skip):
 **/
guint8
fu_struct_synaprom_reply_get_version_get_security1(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[25];
}
/**
 * fu_struct_synaprom_reply_get_version_get_patchsig: (skip):
 **/
guint32
fu_struct_synaprom_reply_get_version_get_patchsig(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 26, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_reply_get_version_get_iface: (skip):
 **/
guint8
fu_struct_synaprom_reply_get_version_get_iface(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[30];
}
/**
 * fu_struct_synaprom_reply_get_version_get_otpsig: (skip):
 **/
const guint8 *
fu_struct_synaprom_reply_get_version_get_otpsig(const FuStructSynapromReplyGetVersion *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 3;
    return st->buf->data + 31;
}
/**
 * fu_struct_synaprom_reply_get_version_get_otpspare1: (skip):
 **/
guint16
fu_struct_synaprom_reply_get_version_get_otpspare1(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 34, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_reply_get_version_get_device_type: (skip):
 **/
guint8
fu_struct_synaprom_reply_get_version_get_device_type(const FuStructSynapromReplyGetVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[37];
}

/* setters */
/**
 * fu_struct_synaprom_reply_get_version_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_reply_get_version_to_string(const FuStructSynapromReplyGetVersion *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapromReplyGetVersion:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_status(st));
    g_string_append_printf(str, "  buildtime: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_buildtime(st));
    g_string_append_printf(str, "  buildnum: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_buildnum(st));
    g_string_append_printf(str, "  vmajor: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_vmajor(st));
    g_string_append_printf(str, "  vminor: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_vminor(st));
    g_string_append_printf(str, "  target: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_target(st));
    {
        const gchar *tmp = fu_synaprom_product_to_string(fu_struct_synaprom_reply_get_version_get_product(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  product: 0x%x [%s]\n", (guint) fu_struct_synaprom_reply_get_version_get_product(st), tmp);
        } else {
            g_string_append_printf(str, "  product: 0x%x\n", (guint) fu_struct_synaprom_reply_get_version_get_product(st));
        }
    }
    g_string_append_printf(str, "  siliconrev: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_siliconrev(st));
    g_string_append_printf(str, "  formalrel: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_formalrel(st));
    g_string_append_printf(str, "  platform: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_platform(st));
    g_string_append_printf(str, "  patch: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_patch(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_synaprom_reply_get_version_get_serial_number(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  serial_number: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  security0: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_security0(st));
    g_string_append_printf(str, "  security1: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_security1(st));
    g_string_append_printf(str, "  patchsig: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_patchsig(st));
    g_string_append_printf(str, "  iface: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_iface(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_synaprom_reply_get_version_get_otpsig(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  otpsig: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  otpspare1: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_otpspare1(st));
    g_string_append_printf(str, "  device_type: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_get_version_get_device_type(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaprom_reply_get_version_validate_internal(FuStructSynapromReplyGetVersion *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaprom_reply_get_version_parse_internal(FuStructSynapromReplyGetVersion *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaprom_reply_get_version_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaprom_reply_get_version_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_synaprom_reply_get_version_parse: (skip):
 **/
FuStructSynapromReplyGetVersion *
fu_struct_synaprom_reply_get_version_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapromReplyGetVersion) st = fu_struct_synaprom_reply_get_version_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 38, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSynapromReplyGetVersion: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 38);
    if (!fu_struct_synaprom_reply_get_version_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaprom_mfw_hdr_ref: (skip):
 **/
FuStructSynapromMfwHdr *
fu_struct_synaprom_mfw_hdr_ref(FuStructSynapromMfwHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaprom_mfw_hdr_unref: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_unref(FuStructSynapromMfwHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapromMfwHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapromMfwHdr *
fu_struct_synaprom_mfw_hdr_new_internal(void)
{
    FuStructSynapromMfwHdr *st = g_new0(FuStructSynapromMfwHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaprom_mfw_hdr_get_product: (skip):
 **/
guint32
fu_struct_synaprom_mfw_hdr_get_product(const FuStructSynapromMfwHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_get_id: (skip):
 **/
guint32
fu_struct_synaprom_mfw_hdr_get_id(const FuStructSynapromMfwHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_get_buildtime: (skip):
 **/
guint32
fu_struct_synaprom_mfw_hdr_get_buildtime(const FuStructSynapromMfwHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_get_buildnum: (skip):
 **/
guint32
fu_struct_synaprom_mfw_hdr_get_buildnum(const FuStructSynapromMfwHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_get_vmajor: (skip):
 **/
guint8
fu_struct_synaprom_mfw_hdr_get_vmajor(const FuStructSynapromMfwHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[16];
}
/**
 * fu_struct_synaprom_mfw_hdr_get_vminor: (skip):
 **/
guint8
fu_struct_synaprom_mfw_hdr_get_vminor(const FuStructSynapromMfwHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[17];
}
/**
 * fu_struct_synaprom_mfw_hdr_get_unused: (skip):
 **/
const guint8 *
fu_struct_synaprom_mfw_hdr_get_unused(const FuStructSynapromMfwHdr *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 6;
    return st->buf->data + 18;
}

/* setters */
/**
 * fu_struct_synaprom_mfw_hdr_set_product: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_product(FuStructSynapromMfwHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_set_id: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_id(FuStructSynapromMfwHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_set_buildtime: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_buildtime(FuStructSynapromMfwHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_set_buildnum: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_buildnum(FuStructSynapromMfwHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_set_vmajor: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_vmajor(FuStructSynapromMfwHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[16] = value;
}
/**
 * fu_struct_synaprom_mfw_hdr_set_vminor: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_vminor(FuStructSynapromMfwHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[17] = value;
}
/**
 * fu_struct_synaprom_mfw_hdr_set_unused: (skip):
 **/
gboolean
fu_struct_synaprom_mfw_hdr_set_unused(FuStructSynapromMfwHdr *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 18, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_synaprom_mfw_hdr_new: (skip):
 **/
FuStructSynapromMfwHdr *
fu_struct_synaprom_mfw_hdr_new(void)
{
    FuStructSynapromMfwHdr *st = fu_struct_synaprom_mfw_hdr_new_internal();
    st->buf = g_byte_array_sized_new(24);
    fu_byte_array_set_size(st->buf, 24, 0x0);
    fu_struct_synaprom_mfw_hdr_set_id(st, 0xFF);
    fu_struct_synaprom_mfw_hdr_set_buildtime(st, 0xFF);
    fu_struct_synaprom_mfw_hdr_set_buildnum(st, 0xFF);
    fu_struct_synaprom_mfw_hdr_set_vmajor(st, 10);
    fu_struct_synaprom_mfw_hdr_set_vminor(st, 1);
    return st;
}
/**
 * fu_struct_synaprom_mfw_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_mfw_hdr_to_string(const FuStructSynapromMfwHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapromMfwHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  product: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_product(st));
    g_string_append_printf(str, "  id: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_id(st));
    g_string_append_printf(str, "  buildtime: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_buildtime(st));
    g_string_append_printf(str, "  buildnum: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_buildnum(st));
    g_string_append_printf(str, "  vmajor: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_vmajor(st));
    g_string_append_printf(str, "  vminor: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_vminor(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_synaprom_mfw_hdr_get_unused(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  unused: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaprom_mfw_hdr_validate_internal(FuStructSynapromMfwHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaprom_mfw_hdr_parse_internal(FuStructSynapromMfwHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaprom_mfw_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaprom_mfw_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_synaprom_mfw_hdr_parse_stream: (skip):
 **/
FuStructSynapromMfwHdr *
fu_struct_synaprom_mfw_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapromMfwHdr) st = fu_struct_synaprom_mfw_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 24, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructSynapromMfwHdr failed read of 0x%x: ", (guint) 24);
        return NULL;
    }
    if (st->buf->len != 24) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructSynapromMfwHdr requested 0x%x and got 0x%x",
                    (guint) 24,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_synaprom_mfw_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaprom_hdr_ref: (skip):
 **/
FuStructSynapromHdr *
fu_struct_synaprom_hdr_ref(FuStructSynapromHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaprom_hdr_unref: (skip):
 **/
void
fu_struct_synaprom_hdr_unref(FuStructSynapromHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapromHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapromHdr *
fu_struct_synaprom_hdr_new_internal(void)
{
    FuStructSynapromHdr *st = g_new0(FuStructSynapromHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaprom_hdr_get_tag: (skip):
 **/
FuSynapromFirmwareTag
fu_struct_synaprom_hdr_get_tag(const FuStructSynapromHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_hdr_get_bufsz: (skip):
 **/
guint32
fu_struct_synaprom_hdr_get_bufsz(const FuStructSynapromHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaprom_hdr_set_tag: (skip):
 **/
void
fu_struct_synaprom_hdr_set_tag(FuStructSynapromHdr *st, FuSynapromFirmwareTag value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_hdr_set_bufsz: (skip):
 **/
void
fu_struct_synaprom_hdr_set_bufsz(FuStructSynapromHdr *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_hdr_new: (skip):
 **/
FuStructSynapromHdr *
fu_struct_synaprom_hdr_new(void)
{
    FuStructSynapromHdr *st = fu_struct_synaprom_hdr_new_internal();
    st->buf = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st->buf, 6, 0x0);
    return st;
}
/**
 * fu_struct_synaprom_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_hdr_to_string(const FuStructSynapromHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapromHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_synaprom_firmware_tag_to_string(fu_struct_synaprom_hdr_get_tag(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  tag: 0x%x [%s]\n", (guint) fu_struct_synaprom_hdr_get_tag(st), tmp);
        } else {
            g_string_append_printf(str, "  tag: 0x%x\n", (guint) fu_struct_synaprom_hdr_get_tag(st));
        }
    }
    g_string_append_printf(str, "  bufsz: 0x%x\n",
                           (guint) fu_struct_synaprom_hdr_get_bufsz(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaprom_hdr_validate_internal(FuStructSynapromHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaprom_hdr_parse_internal(FuStructSynapromHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaprom_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaprom_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_synaprom_hdr_parse_stream: (skip):
 **/
FuStructSynapromHdr *
fu_struct_synaprom_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapromHdr) st = fu_struct_synaprom_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 6, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructSynapromHdr failed read of 0x%x: ", (guint) 6);
        return NULL;
    }
    if (st->buf->len != 6) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructSynapromHdr requested 0x%x and got 0x%x",
                    (guint) 6,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_synaprom_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaprom_cfg_hdr_ref: (skip):
 **/
FuStructSynapromCfgHdr *
fu_struct_synaprom_cfg_hdr_ref(FuStructSynapromCfgHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaprom_cfg_hdr_unref: (skip):
 **/
void
fu_struct_synaprom_cfg_hdr_unref(FuStructSynapromCfgHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapromCfgHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapromCfgHdr *
fu_struct_synaprom_cfg_hdr_new_internal(void)
{
    FuStructSynapromCfgHdr *st = g_new0(FuStructSynapromCfgHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaprom_cfg_hdr_get_product: (skip):
 **/
guint32
fu_struct_synaprom_cfg_hdr_get_product(const FuStructSynapromCfgHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cfg_hdr_get_id1: (skip):
 **/
guint32
fu_struct_synaprom_cfg_hdr_get_id1(const FuStructSynapromCfgHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cfg_hdr_get_id2: (skip):
 **/
guint32
fu_struct_synaprom_cfg_hdr_get_id2(const FuStructSynapromCfgHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cfg_hdr_get_version: (skip):
 **/
guint16
fu_struct_synaprom_cfg_hdr_get_version(const FuStructSynapromCfgHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaprom_cfg_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_cfg_hdr_to_string(const FuStructSynapromCfgHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapromCfgHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  product: 0x%x\n",
                           (guint) fu_struct_synaprom_cfg_hdr_get_product(st));
    g_string_append_printf(str, "  id1: 0x%x\n",
                           (guint) fu_struct_synaprom_cfg_hdr_get_id1(st));
    g_string_append_printf(str, "  id2: 0x%x\n",
                           (guint) fu_struct_synaprom_cfg_hdr_get_id2(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_synaprom_cfg_hdr_get_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaprom_cfg_hdr_validate_internal(FuStructSynapromCfgHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaprom_cfg_hdr_parse_internal(FuStructSynapromCfgHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaprom_cfg_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaprom_cfg_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_synaprom_cfg_hdr_parse_stream: (skip):
 **/
FuStructSynapromCfgHdr *
fu_struct_synaprom_cfg_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapromCfgHdr) st = fu_struct_synaprom_cfg_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 16, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructSynapromCfgHdr failed read of 0x%x: ", (guint) 16);
        return NULL;
    }
    if (st->buf->len != 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructSynapromCfgHdr requested 0x%x and got 0x%x",
                    (guint) 16,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_synaprom_cfg_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaprom_iota_config_version_ref: (skip):
 **/
FuStructSynapromIotaConfigVersion *
fu_struct_synaprom_iota_config_version_ref(FuStructSynapromIotaConfigVersion *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaprom_iota_config_version_unref: (skip):
 **/
void
fu_struct_synaprom_iota_config_version_unref(FuStructSynapromIotaConfigVersion *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapromIotaConfigVersion refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapromIotaConfigVersion *
fu_struct_synaprom_iota_config_version_new_internal(void)
{
    FuStructSynapromIotaConfigVersion *st = g_new0(FuStructSynapromIotaConfigVersion, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaprom_iota_config_version_get_config_id1: (skip):
 **/
guint32
fu_struct_synaprom_iota_config_version_get_config_id1(const FuStructSynapromIotaConfigVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_iota_config_version_get_config_id2: (skip):
 **/
guint32
fu_struct_synaprom_iota_config_version_get_config_id2(const FuStructSynapromIotaConfigVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_iota_config_version_get_version: (skip):
 **/
guint16
fu_struct_synaprom_iota_config_version_get_version(const FuStructSynapromIotaConfigVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaprom_iota_config_version_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_iota_config_version_to_string(const FuStructSynapromIotaConfigVersion *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapromIotaConfigVersion:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  config_id1: 0x%x\n",
                           (guint) fu_struct_synaprom_iota_config_version_get_config_id1(st));
    g_string_append_printf(str, "  config_id2: 0x%x\n",
                           (guint) fu_struct_synaprom_iota_config_version_get_config_id2(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_synaprom_iota_config_version_get_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaprom_iota_config_version_validate_internal(FuStructSynapromIotaConfigVersion *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaprom_iota_config_version_parse_internal(FuStructSynapromIotaConfigVersion *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaprom_iota_config_version_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaprom_iota_config_version_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_synaprom_iota_config_version_parse: (skip):
 **/
FuStructSynapromIotaConfigVersion *
fu_struct_synaprom_iota_config_version_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapromIotaConfigVersion) st = fu_struct_synaprom_iota_config_version_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSynapromIotaConfigVersion: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 16);
    if (!fu_struct_synaprom_iota_config_version_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaprom_reply_iota_find_hdr_ref: (skip):
 **/
FuStructSynapromReplyIotaFindHdr *
fu_struct_synaprom_reply_iota_find_hdr_ref(FuStructSynapromReplyIotaFindHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaprom_reply_iota_find_hdr_unref: (skip):
 **/
void
fu_struct_synaprom_reply_iota_find_hdr_unref(FuStructSynapromReplyIotaFindHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapromReplyIotaFindHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapromReplyIotaFindHdr *
fu_struct_synaprom_reply_iota_find_hdr_new_internal(void)
{
    FuStructSynapromReplyIotaFindHdr *st = g_new0(FuStructSynapromReplyIotaFindHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaprom_reply_iota_find_hdr_get_status: (skip):
 **/
guint16
fu_struct_synaprom_reply_iota_find_hdr_get_status(const FuStructSynapromReplyIotaFindHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_reply_iota_find_hdr_get_fullsize: (skip):
 **/
guint32
fu_struct_synaprom_reply_iota_find_hdr_get_fullsize(const FuStructSynapromReplyIotaFindHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_reply_iota_find_hdr_get_nbytes: (skip):
 **/
guint16
fu_struct_synaprom_reply_iota_find_hdr_get_nbytes(const FuStructSynapromReplyIotaFindHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_reply_iota_find_hdr_get_itype: (skip):
 **/
guint16
fu_struct_synaprom_reply_iota_find_hdr_get_itype(const FuStructSynapromReplyIotaFindHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaprom_reply_iota_find_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_reply_iota_find_hdr_to_string(const FuStructSynapromReplyIotaFindHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapromReplyIotaFindHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_iota_find_hdr_get_status(st));
    g_string_append_printf(str, "  fullsize: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_iota_find_hdr_get_fullsize(st));
    g_string_append_printf(str, "  nbytes: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_iota_find_hdr_get_nbytes(st));
    g_string_append_printf(str, "  itype: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_iota_find_hdr_get_itype(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaprom_reply_iota_find_hdr_validate_internal(FuStructSynapromReplyIotaFindHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaprom_reply_iota_find_hdr_parse_internal(FuStructSynapromReplyIotaFindHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaprom_reply_iota_find_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaprom_reply_iota_find_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_synaprom_reply_iota_find_hdr_parse: (skip):
 **/
FuStructSynapromReplyIotaFindHdr *
fu_struct_synaprom_reply_iota_find_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapromReplyIotaFindHdr) st = fu_struct_synaprom_reply_iota_find_hdr_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 10, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSynapromReplyIotaFindHdr: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 10);
    if (!fu_struct_synaprom_reply_iota_find_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaprom_cmd_iota_find_ref: (skip):
 **/
FuStructSynapromCmdIotaFind *
fu_struct_synaprom_cmd_iota_find_ref(FuStructSynapromCmdIotaFind *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaprom_cmd_iota_find_unref: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_unref(FuStructSynapromCmdIotaFind *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapromCmdIotaFind refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapromCmdIotaFind *
fu_struct_synaprom_cmd_iota_find_new_internal(void)
{
    FuStructSynapromCmdIotaFind *st = g_new0(FuStructSynapromCmdIotaFind, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaprom_cmd_iota_find_get_itype: (skip):
 **/
guint16
fu_struct_synaprom_cmd_iota_find_get_itype(const FuStructSynapromCmdIotaFind *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_get_flags: (skip):
 **/
guint16
fu_struct_synaprom_cmd_iota_find_get_flags(const FuStructSynapromCmdIotaFind *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_get_maxniotas: (skip):
 **/
guint8
fu_struct_synaprom_cmd_iota_find_get_maxniotas(const FuStructSynapromCmdIotaFind *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_synaprom_cmd_iota_find_get_firstidx: (skip):
 **/
guint8
fu_struct_synaprom_cmd_iota_find_get_firstidx(const FuStructSynapromCmdIotaFind *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_synaprom_cmd_iota_find_get_offset: (skip):
 **/
guint32
fu_struct_synaprom_cmd_iota_find_get_offset(const FuStructSynapromCmdIotaFind *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_get_nbytes: (skip):
 **/
guint32
fu_struct_synaprom_cmd_iota_find_get_nbytes(const FuStructSynapromCmdIotaFind *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaprom_cmd_iota_find_set_itype: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_itype(FuStructSynapromCmdIotaFind *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_set_flags: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_flags(FuStructSynapromCmdIotaFind *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_set_maxniotas: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_maxniotas(FuStructSynapromCmdIotaFind *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_synaprom_cmd_iota_find_set_firstidx: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_firstidx(FuStructSynapromCmdIotaFind *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_synaprom_cmd_iota_find_set_offset: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_offset(FuStructSynapromCmdIotaFind *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_set_nbytes: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_nbytes(FuStructSynapromCmdIotaFind *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_new: (skip):
 **/
FuStructSynapromCmdIotaFind *
fu_struct_synaprom_cmd_iota_find_new(void)
{
    FuStructSynapromCmdIotaFind *st = fu_struct_synaprom_cmd_iota_find_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    return st;
}
