/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-synaptics-vmm9-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_synaptics_vmm9_rc_ctrl_to_string(FuSynapticsVmm9RcCtrl val)
{
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_ENABLE_RC)
        return "enable-rc";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_DISABLE_RC)
        return "disable-rc";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_GET_ID)
        return "get-id";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_ERASE_FLASH)
        return "erase-flash";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_ACTIVATE_FIRMWARE)
        return "activate-firmware";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_WRITE_FLASH_DATA)
        return "write-flash-data";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_MEMORY_WRITE)
        return "memory-write";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_TX_DPCD_REGISTER_WRITE)
        return "tx-dpcd-register-write";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_READ_FLASH_DATA)
        return "read-flash-data";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_MEMORY_READ)
        return "memory-read";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_TX_DPCD_REGISTER_READ)
        return "tx-dpcd-register-read";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_ENABLE_RC_BUSY)
        return "enable-rc-busy";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_DISABLE_RC_BUSY)
        return "disable-rc-busy";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_GET_ID_BUSY)
        return "get-id-busy";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_ERASE_FLASH_BUSY)
        return "erase-flash-busy";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_ACTIVATE_FIRMWARE_BUSY)
        return "activate-firmware-busy";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_WRITE_FLASH_DATA_BUSY)
        return "write-flash-data-busy";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_MEMORY_WRITE_BUSY)
        return "memory-write-busy";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_READ_FLASH_DATA_BUSY)
        return "read-flash-data-busy";
    if (val == FU_SYNAPTICS_VMM9_RC_CTRL_MEMORY_READ_BUSY)
        return "memory-read-busy";
    return NULL;
}

const gchar *
fu_synaptics_vmm9_rc_sts_to_string(FuSynapticsVmm9RcSts val)
{
    if (val == FU_SYNAPTICS_VMM9_RC_STS_SUCCESS)
        return "success";
    if (val == FU_SYNAPTICS_VMM9_RC_STS_INVALID)
        return "invalid";
    if (val == FU_SYNAPTICS_VMM9_RC_STS_UNSUPPORTED)
        return "unsupported";
    if (val == FU_SYNAPTICS_VMM9_RC_STS_FAILED)
        return "failed";
    if (val == FU_SYNAPTICS_VMM9_RC_STS_DISABLED)
        return "disabled";
    if (val == FU_SYNAPTICS_VMM9_RC_STS_CONFIGURE_SIGN_FAILED)
        return "configure-sign-failed";
    if (val == FU_SYNAPTICS_VMM9_RC_STS_FIRMWARE_SIGN_FAILED)
        return "firmware-sign-failed";
    if (val == FU_SYNAPTICS_VMM9_RC_STS_ROLLBACK_FAILED)
        return "rollback-failed";
    return NULL;
}
/**
 * fu_struct_synaptics_vmm9_ref: (skip):
 **/
FuStructSynapticsVmm9 *
fu_struct_synaptics_vmm9_ref(FuStructSynapticsVmm9 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_vmm9_unref: (skip):
 **/
void
fu_struct_synaptics_vmm9_unref(FuStructSynapticsVmm9 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsVmm9 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapticsVmm9 *
fu_struct_synaptics_vmm9_new_internal(void)
{
    FuStructSynapticsVmm9 *st = g_new0(FuStructSynapticsVmm9, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaptics_vmm9_get_signature: (skip):
 **/
static gchar *
fu_struct_synaptics_vmm9_get_signature(const FuStructSynapticsVmm9 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 7, NULL);
}

/* setters */
/**
 * fu_struct_synaptics_vmm9_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_vmm9_to_string(const FuStructSynapticsVmm9 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapticsVmm9:\n");
    g_return_val_if_fail(st != NULL, NULL);
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaptics_vmm9_validate_internal(FuStructSynapticsVmm9 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "CARRERA", 7) != 0) {
        g_autofree gchar *str = fu_struct_synaptics_vmm9_get_signature(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructSynapticsVmm9.signature was not valid, "
                    "expected 'CARRERA' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_synaptics_vmm9_validate_stream: (skip):
 **/
gboolean
fu_struct_synaptics_vmm9_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapticsVmm9) st = fu_struct_synaptics_vmm9_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 7, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructSynapticsVmm9 failed read of 0x%x: ", (guint) 7);
        return FALSE;
    }
    if (st->buf->len != 7) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructSynapticsVmm9 requested 0x%x and got 0x%x",
                    (guint) 7,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_synaptics_vmm9_validate_internal(st, error);
}
static gboolean
fu_struct_synaptics_vmm9_parse_internal(FuStructSynapticsVmm9 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaptics_vmm9_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaptics_vmm9_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_synaptics_vmm9_parse_stream: (skip):
 **/
FuStructSynapticsVmm9 *
fu_struct_synaptics_vmm9_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapticsVmm9) st = fu_struct_synaptics_vmm9_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 7, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructSynapticsVmm9 failed read of 0x%x: ", (guint) 7);
        return NULL;
    }
    if (st->buf->len != 7) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructSynapticsVmm9 requested 0x%x and got 0x%x",
                    (guint) 7,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_synaptics_vmm9_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_hid_payload_ref: (skip):
 **/
FuStructHidPayload *
fu_struct_hid_payload_ref(FuStructHidPayload *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_hid_payload_unref: (skip):
 **/
void
fu_struct_hid_payload_unref(FuStructHidPayload *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructHidPayload refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructHidPayload *
fu_struct_hid_payload_new_internal(void)
{
    FuStructHidPayload *st = g_new0(FuStructHidPayload, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_hid_payload_get_cap: (skip):
 **/
guint8
fu_struct_hid_payload_get_cap(const FuStructHidPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_hid_payload_get_state: (skip):
 **/
guint8
fu_struct_hid_payload_get_state(const FuStructHidPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_hid_payload_get_ctrl: (skip):
 **/
FuSynapticsVmm9RcCtrl
fu_struct_hid_payload_get_ctrl(const FuStructHidPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_hid_payload_get_sts: (skip):
 **/
FuSynapticsVmm9RcSts
fu_struct_hid_payload_get_sts(const FuStructHidPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_hid_payload_get_offset: (skip):
 **/
guint32
fu_struct_hid_payload_get_offset(const FuStructHidPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hid_payload_get_length: (skip):
 **/
guint32
fu_struct_hid_payload_get_length(const FuStructHidPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hid_payload_get_fifo: (skip):
 **/
const guint8 *
fu_struct_hid_payload_get_fifo(const FuStructHidPayload *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 32;
    return st->buf->data + 12;
}

/* setters */
/**
 * fu_struct_hid_payload_set_cap: (skip):
 **/
void
fu_struct_hid_payload_set_cap(FuStructHidPayload *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_hid_payload_set_state: (skip):
 **/
void
fu_struct_hid_payload_set_state(FuStructHidPayload *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_hid_payload_set_ctrl: (skip):
 **/
void
fu_struct_hid_payload_set_ctrl(FuStructHidPayload *st, FuSynapticsVmm9RcCtrl value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_hid_payload_set_sts: (skip):
 **/
void
fu_struct_hid_payload_set_sts(FuStructHidPayload *st, FuSynapticsVmm9RcSts value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_hid_payload_set_offset: (skip):
 **/
void
fu_struct_hid_payload_set_offset(FuStructHidPayload *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hid_payload_set_length: (skip):
 **/
void
fu_struct_hid_payload_set_length(FuStructHidPayload *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_hid_payload_set_fifo: (skip):
 **/
gboolean
fu_struct_hid_payload_set_fifo(FuStructHidPayload *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 12, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_hid_payload_new: (skip):
 **/
FuStructHidPayload *
fu_struct_hid_payload_new(void)
{
    FuStructHidPayload *st = fu_struct_hid_payload_new_internal();
    st->buf = g_byte_array_sized_new(44);
    fu_byte_array_set_size(st->buf, 44, 0x0);
    return st;
}
/**
 * fu_struct_hid_payload_to_string: (skip):
 **/
static gchar *
fu_struct_hid_payload_to_string(const FuStructHidPayload *st)
{
    g_autoptr(GString) str = g_string_new("FuStructHidPayload:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  cap: 0x%x\n",
                           (guint) fu_struct_hid_payload_get_cap(st));
    g_string_append_printf(str, "  state: 0x%x\n",
                           (guint) fu_struct_hid_payload_get_state(st));
    {
        const gchar *tmp = fu_synaptics_vmm9_rc_ctrl_to_string(fu_struct_hid_payload_get_ctrl(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  ctrl: 0x%x [%s]\n", (guint) fu_struct_hid_payload_get_ctrl(st), tmp);
        } else {
            g_string_append_printf(str, "  ctrl: 0x%x\n", (guint) fu_struct_hid_payload_get_ctrl(st));
        }
    }
    {
        const gchar *tmp = fu_synaptics_vmm9_rc_sts_to_string(fu_struct_hid_payload_get_sts(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  sts: 0x%x [%s]\n", (guint) fu_struct_hid_payload_get_sts(st), tmp);
        } else {
            g_string_append_printf(str, "  sts: 0x%x\n", (guint) fu_struct_hid_payload_get_sts(st));
        }
    }
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_hid_payload_get_offset(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_hid_payload_get_length(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_hid_payload_get_fifo(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  fifo: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_hid_payload_validate_internal(FuStructHidPayload *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/**
 * fu_struct_hid_set_command_ref: (skip):
 **/
FuStructHidSetCommand *
fu_struct_hid_set_command_ref(FuStructHidSetCommand *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_hid_set_command_unref: (skip):
 **/
void
fu_struct_hid_set_command_unref(FuStructHidSetCommand *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructHidSetCommand refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructHidSetCommand *
fu_struct_hid_set_command_new_internal(void)
{
    FuStructHidSetCommand *st = g_new0(FuStructHidSetCommand, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_hid_set_command_get_size: (skip):
 **/
guint8
fu_struct_hid_set_command_get_size(const FuStructHidSetCommand *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_hid_set_command_get_payload: (skip):
 **/
FuStructHidPayload *
fu_struct_hid_set_command_get_payload(const FuStructHidSetCommand *st)
{
    g_autoptr(FuStructHidPayload) st_tmp = fu_struct_hid_payload_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_HID_SET_COMMAND_OFFSET_PAYLOAD, 44);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_hid_set_command_get_checksum: (skip):
 **/
guint8
fu_struct_hid_set_command_get_checksum(const FuStructHidSetCommand *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[47];
}

/* setters */
/**
 * fu_struct_hid_set_command_set_id: (skip):
 **/
static void
fu_struct_hid_set_command_set_id(FuStructHidSetCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_hid_set_command_set_type: (skip):
 **/
static void
fu_struct_hid_set_command_set_type(FuStructHidSetCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_hid_set_command_set_size: (skip):
 **/
void
fu_struct_hid_set_command_set_size(FuStructHidSetCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_hid_set_command_set_payload: (skip):
 **/
gboolean
fu_struct_hid_set_command_set_payload(FuStructHidSetCommand *st, const FuStructHidPayload *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_HID_PAYLOAD_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructHidPayload' (0x%x bytes) does not fit in "
                    "FuStructHidSetCommand.payload (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_HID_PAYLOAD_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_HID_SET_COMMAND_OFFSET_PAYLOAD, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_hid_set_command_set_checksum: (skip):
 **/
void
fu_struct_hid_set_command_set_checksum(FuStructHidSetCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[47] = value;
}
/**
 * fu_struct_hid_set_command_new: (skip):
 **/
FuStructHidSetCommand *
fu_struct_hid_set_command_new(void)
{
    FuStructHidSetCommand *st = fu_struct_hid_set_command_new_internal();
    st->buf = g_byte_array_sized_new(48);
    fu_byte_array_set_size(st->buf, 48, 0x0);
    {
        g_autoptr(FuStructHidPayload) st_donor = fu_struct_hid_payload_new();
        memcpy(st->buf->data + 0x3, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    fu_struct_hid_set_command_set_id(st, 0x1);
    fu_struct_hid_set_command_set_type(st, 0x0);
    return st;
}
/**
 * fu_struct_hid_set_command_to_string: (skip):
 **/
gchar *
fu_struct_hid_set_command_to_string(const FuStructHidSetCommand *st)
{
    g_autoptr(GString) str = g_string_new("FuStructHidSetCommand:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_hid_set_command_get_size(st));
    {
        g_autoptr(FuStructHidPayload) st_tmp = fu_struct_hid_set_command_get_payload(st);
        g_autofree gchar *tmp = fu_struct_hid_payload_to_string(st_tmp);
        g_string_append_printf(str, "  payload: %s\n", tmp);
    }
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_hid_set_command_get_checksum(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_hid_get_command_ref: (skip):
 **/
FuStructHidGetCommand *
fu_struct_hid_get_command_ref(FuStructHidGetCommand *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_hid_get_command_unref: (skip):
 **/
void
fu_struct_hid_get_command_unref(FuStructHidGetCommand *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructHidGetCommand refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructHidGetCommand *
fu_struct_hid_get_command_new_internal(void)
{
    FuStructHidGetCommand *st = g_new0(FuStructHidGetCommand, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_hid_get_command_get_id: (skip):
 **/
static guint8
fu_struct_hid_get_command_get_id(const FuStructHidGetCommand *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_hid_get_command_get_type: (skip):
 **/
static guint8
fu_struct_hid_get_command_get_type(const FuStructHidGetCommand *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_hid_get_command_get_size: (skip):
 **/
guint8
fu_struct_hid_get_command_get_size(const FuStructHidGetCommand *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_hid_get_command_get_payload: (skip):
 **/
FuStructHidPayload *
fu_struct_hid_get_command_get_payload(const FuStructHidGetCommand *st)
{
    g_autoptr(FuStructHidPayload) st_tmp = fu_struct_hid_payload_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_HID_GET_COMMAND_OFFSET_PAYLOAD, 44);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_hid_get_command_get_checksum: (skip):
 **/
guint8
fu_struct_hid_get_command_get_checksum(const FuStructHidGetCommand *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[47];
}

/* setters */
/**
 * fu_struct_hid_get_command_set_id: (skip):
 **/
static void
fu_struct_hid_get_command_set_id(FuStructHidGetCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_hid_get_command_set_type: (skip):
 **/
static void
fu_struct_hid_get_command_set_type(FuStructHidGetCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_hid_get_command_set_size: (skip):
 **/
void
fu_struct_hid_get_command_set_size(FuStructHidGetCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_hid_get_command_set_payload: (skip):
 **/
gboolean
fu_struct_hid_get_command_set_payload(FuStructHidGetCommand *st, const FuStructHidPayload *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_HID_PAYLOAD_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructHidPayload' (0x%x bytes) does not fit in "
                    "FuStructHidGetCommand.payload (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_HID_PAYLOAD_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_HID_GET_COMMAND_OFFSET_PAYLOAD, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_hid_get_command_set_checksum: (skip):
 **/
void
fu_struct_hid_get_command_set_checksum(FuStructHidGetCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[47] = value;
}
/**
 * fu_struct_hid_get_command_new: (skip):
 **/
FuStructHidGetCommand *
fu_struct_hid_get_command_new(void)
{
    FuStructHidGetCommand *st = fu_struct_hid_get_command_new_internal();
    st->buf = g_byte_array_sized_new(48);
    fu_byte_array_set_size(st->buf, 48, 0x0);
    {
        g_autoptr(FuStructHidPayload) st_donor = fu_struct_hid_payload_new();
        memcpy(st->buf->data + 0x3, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    fu_struct_hid_get_command_set_id(st, 0x1);
    fu_struct_hid_get_command_set_type(st, 0x0);
    return st;
}
/**
 * fu_struct_hid_get_command_to_string: (skip):
 **/
static gchar *
fu_struct_hid_get_command_to_string(const FuStructHidGetCommand *st)
{
    g_autoptr(GString) str = g_string_new("FuStructHidGetCommand:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_hid_get_command_get_size(st));
    {
        g_autoptr(FuStructHidPayload) st_tmp = fu_struct_hid_get_command_get_payload(st);
        g_autofree gchar *tmp = fu_struct_hid_payload_to_string(st_tmp);
        g_string_append_printf(str, "  payload: %s\n", tmp);
    }
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_hid_get_command_get_checksum(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_hid_get_command_validate_internal(FuStructHidGetCommand *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_hid_get_command_get_id(st) != 0x1) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructHidGetCommand.id was not valid");
        return FALSE;
    }
    if (fu_struct_hid_get_command_get_type(st) != 0x0) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructHidGetCommand.type was not valid");
        return FALSE;
    }
    {
        GByteArray buf_tmp = {
            .data = (guint8*) st->buf->data + 0x3,
            .len = 44,
        };
        FuStructHidPayload st_tmp = { .buf = &buf_tmp };
        if (!fu_struct_hid_payload_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_hid_get_command_parse_internal(FuStructHidGetCommand *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_hid_get_command_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_hid_get_command_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_hid_get_command_parse: (skip):
 **/
FuStructHidGetCommand *
fu_struct_hid_get_command_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructHidGetCommand) st = fu_struct_hid_get_command_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 48, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructHidGetCommand: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 48);
    if (!fu_struct_hid_get_command_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaptics_upd_get_id_ref: (skip):
 **/
FuStructSynapticsUpdGetId *
fu_struct_synaptics_upd_get_id_ref(FuStructSynapticsUpdGetId *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_upd_get_id_unref: (skip):
 **/
void
fu_struct_synaptics_upd_get_id_unref(FuStructSynapticsUpdGetId *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsUpdGetId refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructSynapticsUpdGetId *
fu_struct_synaptics_upd_get_id_new_internal(void)
{
    FuStructSynapticsUpdGetId *st = g_new0(FuStructSynapticsUpdGetId, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaptics_upd_get_id_get_cid: (skip):
 **/
guint8
fu_struct_synaptics_upd_get_id_get_cid(const FuStructSynapticsUpdGetId *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_synaptics_upd_get_id_get_bid: (skip):
 **/
guint8
fu_struct_synaptics_upd_get_id_get_bid(const FuStructSynapticsUpdGetId *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}

/* setters */
/**
 * fu_struct_synaptics_upd_get_id_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_upd_get_id_to_string(const FuStructSynapticsUpdGetId *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapticsUpdGetId:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  cid: 0x%x\n",
                           (guint) fu_struct_synaptics_upd_get_id_get_cid(st));
    g_string_append_printf(str, "  bid: 0x%x\n",
                           (guint) fu_struct_synaptics_upd_get_id_get_bid(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaptics_upd_get_id_validate_internal(FuStructSynapticsUpdGetId *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaptics_upd_get_id_parse_internal(FuStructSynapticsUpdGetId *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaptics_upd_get_id_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaptics_upd_get_id_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_synaptics_upd_get_id_parse: (skip):
 **/
FuStructSynapticsUpdGetId *
fu_struct_synaptics_upd_get_id_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapticsUpdGetId) st = fu_struct_synaptics_upd_get_id_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSynapticsUpdGetId: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_struct_synaptics_upd_get_id_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
