/* components-inspector-log-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from components-inspector-log-view.vala, do not modify */

/*
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <handy.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define COMPONENTS_INSPECTOR_LOG_VIEW_COL_MESSAGE 0
#define COMPONENTS_INSPECTOR_LOG_VIEW_COL_ACCOUNT 1
#define COMPONENTS_INSPECTOR_LOG_VIEW_COL_DOMAIN 2
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	COMPONENTS_INSPECTOR_LOG_VIEW_0_PROPERTY,
	COMPONENTS_INSPECTOR_LOG_VIEW_SEARCH_MODE_ENABLED_PROPERTY,
	COMPONENTS_INSPECTOR_LOG_VIEW_NUM_PROPERTIES
};
static GParamSpec* components_inspector_log_view_properties[COMPONENTS_INSPECTOR_LOG_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _geary_logging_record_unref0(var) ((var == NULL) ? NULL : (var = (geary_logging_record_unref (var), NULL)))
typedef struct _Block58Data Block58Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
typedef struct _Block59Data Block59Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define COMPONENTS_INSPECTOR_LOG_VIEW_TYPE_SIDEBAR_ROW (components_inspector_log_view_sidebar_row_get_type ())
#define COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), COMPONENTS_INSPECTOR_LOG_VIEW_TYPE_SIDEBAR_ROW, ComponentsInspectorLogViewSidebarRow))
#define COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), COMPONENTS_INSPECTOR_LOG_VIEW_TYPE_SIDEBAR_ROW, ComponentsInspectorLogViewSidebarRowClass))
#define COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), COMPONENTS_INSPECTOR_LOG_VIEW_TYPE_SIDEBAR_ROW))
#define COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), COMPONENTS_INSPECTOR_LOG_VIEW_TYPE_SIDEBAR_ROW))
#define COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), COMPONENTS_INSPECTOR_LOG_VIEW_TYPE_SIDEBAR_ROW, ComponentsInspectorLogViewSidebarRowClass))

typedef struct _ComponentsInspectorLogViewSidebarRow ComponentsInspectorLogViewSidebarRow;
typedef struct _ComponentsInspectorLogViewSidebarRowClass ComponentsInspectorLogViewSidebarRowClass;
typedef enum  {
	COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_ACCOUNT,
	COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_INTERNAL_DOMAIN,
	COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_EXTERNAL_DOMAIN
} ComponentsInspectorLogViewSidebarRowRowType;

#define COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_TYPE_ROW_TYPE (components_inspector_log_view_sidebar_row_row_type_get_type ())
typedef struct _Block60Data Block60Data;
typedef struct _ComponentsInspectorLogViewSidebarRowPrivate ComponentsInspectorLogViewSidebarRowPrivate;
enum  {
	COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_0_PROPERTY,
	COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_PROPERTY,
	COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ID_PROPERTY,
	COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ENABLED_PROPERTY,
	COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_NUM_PROPERTIES
};
static GParamSpec* components_inspector_log_view_sidebar_row_properties[COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_NUM_PROPERTIES];
enum  {
	COMPONENTS_INSPECTOR_LOG_VIEW_RECORD_SELECTION_CHANGED_SIGNAL,
	COMPONENTS_INSPECTOR_LOG_VIEW_NUM_SIGNALS
};
static guint components_inspector_log_view_signals[COMPONENTS_INSPECTOR_LOG_VIEW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ComponentsInspectorLogViewPrivate {
	HdySearchBar* search_bar;
	GtkSearchEntry* search_entry;
	GtkListBox* sidebar;
	GtkScrolledWindow* logs_scroller;
	GtkTreeView* logs_view;
	GtkCellRendererText* log_renderer;
	GtkListStore* logs_store;
	GtkTreeModelFilter* logs_filter;
	gchar** logs_filter_terms;
	gint logs_filter_terms_length1;
	gint _logs_filter_terms_size_;
	gboolean update_logs;
	GearyLoggingRecord* first_pending;
	gboolean autoscroll;
	GeeSet* seen_accounts;
	GeeSet* suppressed_accounts;
	GeeSet* seen_domains;
	GearyAccountInformation* account_filter;
	gboolean listener_installed;
};

struct _Block58Data {
	int _ref_count_;
	ComponentsInspectorLogView* self;
	gchar* line_sep;
	GDataOutputStream* out;
	GCancellable* cancellable;
};

struct _Block59Data {
	int _ref_count_;
	Block58Data * _data58_;
	GError* inner_err;
};

struct _Block60Data {
	int _ref_count_;
	ComponentsInspectorLogView* self;
	GearyLoggingRecord* record;
};

struct _ComponentsInspectorLogViewSidebarRow {
	GtkListBoxRow parent_instance;
	ComponentsInspectorLogViewSidebarRowPrivate * priv;
};

struct _ComponentsInspectorLogViewSidebarRowClass {
	GtkListBoxRowClass parent_class;
};

struct _ComponentsInspectorLogViewSidebarRowPrivate {
	ComponentsInspectorLogViewSidebarRowRowType _row_type;
	gchar* _id;
	GtkCheckButton* enabled_toggle;
};

static gint ComponentsInspectorLogView_private_offset;
static gpointer components_inspector_log_view_parent_class = NULL;
static gint ComponentsInspectorLogViewSidebarRow_private_offset;
static gpointer components_inspector_log_view_sidebar_row_parent_class = NULL;

static void components_inspector_log_view_add_domain (ComponentsInspectorLogView* self,
                                               const gchar* domain);
static void components_inspector_log_view_sidebar_header_update (ComponentsInspectorLogView* self,
                                                          GtkListBoxRow* current_row,
                                                          GtkListBoxRow* previous_row);
static void _components_inspector_log_view_sidebar_header_update_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                           GtkListBoxRow* before,
                                                                                           gpointer self);
static void components_inspector_log_view_on_log_record (ComponentsInspectorLogView* self,
                                                  GearyLoggingRecord* record);
static void _components_inspector_log_view_on_log_record_geary_logging_log_record (GearyLoggingRecord* record,
                                                                            gpointer self);
static inline void components_inspector_log_view_update_record (ComponentsInspectorLogView* self,
                                                  GearyLoggingRecord* record,
                                                  GtkListStore* store,
                                                  gint position);
static gboolean components_inspector_log_view_log_filter_func (ComponentsInspectorLogView* self,
                                                        GtkTreeModel* model,
                                                        GtkTreeIter* iter);
static gboolean _components_inspector_log_view_log_filter_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                                            GtkTreeIter* iter,
                                                                                            gpointer self);
static void components_inspector_log_view_real_destroy (GtkWidget* base);
static Block58Data* block58_data_ref (Block58Data* _data58_);
static void block58_data_unref (void * _userdata_);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static inline void components_inspector_log_view_save_record (ComponentsInspectorLogView* self,
                                                GtkTreeModel* model,
                                                GtkTreeIter* iter,
                                                GDataOutputStream* out,
                                                GCancellable* cancellable,
                                                GError** error);
static Block59Data* block59_data_ref (Block59Data* _data59_);
static void block59_data_unref (void * _userdata_);
static void ___lambda38_ (Block59Data* _data59_,
                   GtkTreeModel* model,
                   GtkTreePath* path,
                   GtkTreeIter* iter);
static void ____lambda38__gtk_tree_selection_foreach_func (GtkTreeModel* model,
                                                    GtkTreePath* path,
                                                    GtkTreeIter* iter,
                                                    gpointer self);
static void components_inspector_log_view_add_account (ComponentsInspectorLogView* self,
                                                GearyAccountInformation* account);
static GType components_inspector_log_view_sidebar_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType components_inspector_log_view_sidebar_row_row_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ComponentsInspectorLogViewSidebarRow* components_inspector_log_view_sidebar_row_new (ComponentsInspectorLogViewSidebarRowRowType type,
                                                                                     const gchar* label,
                                                                                     const gchar* id);
static ComponentsInspectorLogViewSidebarRow* components_inspector_log_view_sidebar_row_construct (GType object_type,
                                                                                           ComponentsInspectorLogViewSidebarRowRowType type,
                                                                                           const gchar* label,
                                                                                           const gchar* id);
static void components_inspector_log_view_sidebar_row_set_enabled (ComponentsInspectorLogViewSidebarRow* self,
                                                            gboolean value);
static void components_inspector_log_view_on_account_enabled_changed (ComponentsInspectorLogView* self,
                                                               GObject* object,
                                                               GParamSpec* param);
static void _components_inspector_log_view_on_account_enabled_changed_g_object_notify (GObject* _sender,
                                                                                GParamSpec* pspec,
                                                                                gpointer self);
static ComponentsInspectorLogViewSidebarRowRowType components_inspector_log_view_sidebar_row_get_row_type (ComponentsInspectorLogViewSidebarRow* self);
static const gchar* components_inspector_log_view_sidebar_row_get_id (ComponentsInspectorLogViewSidebarRow* self);
static void components_inspector_log_view_on_domain_enabled_changed (ComponentsInspectorLogView* self,
                                                              GObject* object,
                                                              GParamSpec* param);
static void _components_inspector_log_view_on_domain_enabled_changed_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self);
static void components_inspector_log_view_update_scrollbar (ComponentsInspectorLogView* self);
static void components_inspector_log_view_update_logs_filter (ComponentsInspectorLogView* self);
static void components_inspector_log_view_on_logs_size_allocate (ComponentsInspectorLogView* self);
static void _components_inspector_log_view_on_logs_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                                    GtkAllocation* allocation,
                                                                                    gpointer self);
static void components_inspector_log_view_on_logs_search_changed (ComponentsInspectorLogView* self);
static void _components_inspector_log_view_on_logs_search_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                            gpointer self);
static void components_inspector_log_view_on_logs_selection_changed (ComponentsInspectorLogView* self);
static void _components_inspector_log_view_on_logs_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                                                                          gpointer self);
static void components_inspector_log_view_on_sidebar_row_activated (ComponentsInspectorLogView* self,
                                                             GtkListBox* list,
                                                             GtkListBoxRow* activated);
static gboolean components_inspector_log_view_sidebar_row_get_enabled (ComponentsInspectorLogViewSidebarRow* self);
static void _components_inspector_log_view_on_sidebar_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                         GtkListBoxRow* row,
                                                                                         gpointer self);
static Block60Data* block60_data_ref (Block60Data* _data60_);
static void block60_data_unref (void * _userdata_);
static gboolean ___lambda37_ (Block60Data* _data60_);
static gboolean ____lambda37__gsource_func (gpointer self);
static void components_inspector_log_view_sidebar_row_set_row_type (ComponentsInspectorLogViewSidebarRow* self,
                                                             ComponentsInspectorLogViewSidebarRowRowType value);
static void components_inspector_log_view_sidebar_row_set_id (ComponentsInspectorLogViewSidebarRow* self,
                                                       const gchar* value);
static void __lambda36_ (ComponentsInspectorLogViewSidebarRow* self);
static void ___lambda36__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void components_inspector_log_view_sidebar_row_finalize (GObject * obj);
static GType components_inspector_log_view_sidebar_row_get_type_once (void);
static void _vala_components_inspector_log_view_sidebar_row_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec);
static void _vala_components_inspector_log_view_sidebar_row_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec);
static void components_inspector_log_view_finalize (GObject * obj);
static GType components_inspector_log_view_get_type_once (void);
static void _vala_components_inspector_log_view_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_components_inspector_log_view_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
components_inspector_log_view_get_instance_private (ComponentsInspectorLogView* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsInspectorLogView_private_offset);
}

gboolean
components_inspector_log_view_get_search_mode_enabled (ComponentsInspectorLogView* self)
{
	gboolean result;
	HdySearchBar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self), FALSE);
	_tmp0_ = self->priv->search_bar;
	g_object_get (_tmp0_, "search-mode-enabled", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
components_inspector_log_view_set_search_mode_enabled (ComponentsInspectorLogView* self,
                                                       gboolean value)
{
	HdySearchBar* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	_tmp0_ = self->priv->search_bar;
	g_object_set (_tmp0_, "search-mode-enabled", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, components_inspector_log_view_properties[COMPONENTS_INSPECTOR_LOG_VIEW_SEARCH_MODE_ENABLED_PROPERTY]);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_components_inspector_log_view_sidebar_header_update_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                      GtkListBoxRow* before,
                                                                                      gpointer self)
{
	components_inspector_log_view_sidebar_header_update ((ComponentsInspectorLogView*) self, row, before);
}

ComponentsInspectorLogView*
components_inspector_log_view_construct (GType object_type,
                                         ApplicationConfiguration* config,
                                         GearyAccountInformation* filter_by)
{
	ComponentsInspectorLogView * self = NULL;
	GSettings* system = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GtkCellRendererText* _tmp3_;
	HdySearchBar* _tmp4_;
	GtkSearchEntry* _tmp5_;
	GtkListBox* _tmp6_;
	GearyAccountInformation* _tmp7_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	g_return_val_if_fail ((filter_by == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (filter_by, GEARY_TYPE_ACCOUNT_INFORMATION), NULL);
	self = (ComponentsInspectorLogView*) g_object_new (object_type, NULL);
	_tmp0_ = application_configuration_get_gnome_interface (config);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	system = _tmp2_;
	_tmp3_ = self->priv->log_renderer;
	g_settings_bind (system, "monospace-font-name", G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject), "font", G_SETTINGS_BIND_DEFAULT);
	components_inspector_log_view_add_domain (self, GEARY_APP_CONVERSATION_MONITOR_LOGGING_DOMAIN);
	components_inspector_log_view_add_domain (self, GEARY_IMAP_CLIENT_SERVICE_LOGGING_DOMAIN);
	components_inspector_log_view_add_domain (self, GEARY_IMAP_CLIENT_SERVICE_DESERIALISATION_LOGGING_DOMAIN);
	components_inspector_log_view_add_domain (self, GEARY_IMAP_CLIENT_SERVICE_PROTOCOL_LOGGING_DOMAIN);
	components_inspector_log_view_add_domain (self, GEARY_IMAP_CLIENT_SERVICE_REPLAY_QUEUE_LOGGING_DOMAIN);
	components_inspector_log_view_add_domain (self, GEARY_SMTP_CLIENT_SERVICE_LOGGING_DOMAIN);
	components_inspector_log_view_add_domain (self, GEARY_SMTP_CLIENT_SERVICE_PROTOCOL_LOGGING_DOMAIN);
	_tmp4_ = self->priv->search_bar;
	_tmp5_ = self->priv->search_entry;
	hdy_search_bar_connect_entry (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_entry_get_type (), GtkEntry));
	_tmp6_ = self->priv->sidebar;
	gtk_list_box_set_header_func (_tmp6_, _components_inspector_log_view_sidebar_header_update_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp7_ = _g_object_ref0 (filter_by);
	_g_object_unref0 (self->priv->account_filter);
	self->priv->account_filter = _tmp7_;
	_g_object_unref0 (system);
	return self;
}

ComponentsInspectorLogView*
components_inspector_log_view_new (ApplicationConfiguration* config,
                                   GearyAccountInformation* filter_by)
{
	return components_inspector_log_view_construct (COMPONENTS_TYPE_INSPECTOR_LOG_VIEW, config, filter_by);
}

/** Loads log records from the logging system into the view. */
static void
_components_inspector_log_view_on_log_record_geary_logging_log_record (GearyLoggingRecord* record,
                                                                       gpointer self)
{
	components_inspector_log_view_on_log_record ((ComponentsInspectorLogView*) self, record);
}

static gpointer
_geary_logging_record_ref0 (gpointer self)
{
	return self ? geary_logging_record_ref (self) : NULL;
}

static gboolean
_components_inspector_log_view_log_filter_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                                   GtkTreeIter* iter,
                                                                                   gpointer self)
{
	gboolean result;
	result = components_inspector_log_view_log_filter_func ((ComponentsInspectorLogView*) self, model, iter);
	return result;
}

void
components_inspector_log_view_load (ComponentsInspectorLogView* self,
                                    GearyLoggingRecord* first,
                                    GearyLoggingRecord* last)
{
	GtkListStore* logs_store = NULL;
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GearyLoggingRecord* logs = NULL;
	GearyLoggingRecord* _tmp2_;
	gint index = 0;
	GtkListStore* _tmp11_;
	GtkTreeModelFilter* _tmp12_;
	GtkTreeModelFilter* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkTreeModelFilter* _tmp15_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (first, GEARY_LOGGING_TYPE_RECORD));
	g_return_if_fail ((last == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (last, GEARY_LOGGING_TYPE_RECORD));
	if (last == NULL) {
		geary_logging_set_log_listener (_components_inspector_log_view_on_log_record_geary_logging_log_record, self);
		self->priv->listener_installed = TRUE;
	}
	_tmp0_ = self->priv->logs_store;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	logs_store = _tmp1_;
	_tmp2_ = _geary_logging_record_ref0 (first);
	logs = _tmp2_;
	index = 0;
	while (TRUE) {
		GearyLoggingRecord* _tmp3_;
		GearyLoggingRecord* _tmp4_;
		GtkListStore* _tmp5_;
		gint _tmp6_;
		GearyLoggingRecord* _tmp7_;
		GearyLoggingRecord* _tmp8_;
		GearyLoggingRecord* _tmp9_;
		GearyLoggingRecord* _tmp10_;
		_tmp3_ = logs;
		if (!(_tmp3_ != last)) {
			break;
		}
		_tmp4_ = logs;
		_tmp5_ = logs_store;
		_tmp6_ = index;
		index = _tmp6_ + 1;
		components_inspector_log_view_update_record (self, _tmp4_, _tmp5_, _tmp6_);
		_tmp7_ = logs;
		_tmp8_ = geary_logging_record_get_next (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _geary_logging_record_ref0 (_tmp9_);
		_geary_logging_record_unref0 (logs);
		logs = _tmp10_;
	}
	_tmp11_ = self->priv->logs_store;
	_tmp12_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_tree_model_get_type (), GtkTreeModel), NULL);
	_g_object_unref0 (self->priv->logs_filter);
	self->priv->logs_filter = _tmp12_;
	_tmp13_ = self->priv->logs_filter;
	gtk_tree_model_filter_set_visible_func (_tmp13_, _components_inspector_log_view_log_filter_func_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	_tmp14_ = self->priv->logs_view;
	_tmp15_ = self->priv->logs_filter;
	gtk_tree_view_set_model (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_tree_model_get_type (), GtkTreeModel));
	_geary_logging_record_unref0 (logs);
	_g_object_unref0 (logs_store);
}

/** Clears all log records from the view. */
void
components_inspector_log_view_clear (ComponentsInspectorLogView* self)
{
	GtkListStore* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	_tmp0_ = self->priv->logs_store;
	gtk_list_store_clear (_tmp0_);
	_geary_logging_record_unref0 (self->priv->first_pending);
	self->priv->first_pending = NULL;
}

/** {@inheritDoc} */
static void
components_inspector_log_view_real_destroy (GtkWidget* base)
{
	ComponentsInspectorLogView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, COMPONENTS_TYPE_INSPECTOR_LOG_VIEW, ComponentsInspectorLogView);
	if (self->priv->listener_installed) {
		geary_logging_set_log_listener (NULL, NULL);
	}
	GTK_WIDGET_CLASS (components_inspector_log_view_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid), gtk_widget_get_type (), GtkWidget));
}

/** Forwards a key press event to the search entry. */
gboolean
components_inspector_log_view_handle_key_press (ComponentsInspectorLogView* self,
                                                GdkEventKey* event)
{
	GtkSearchEntry* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->search_entry;
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), "key-press-event", event, &_tmp1_);
	result = _tmp1_;
	return result;
}

/** Returns the number of currently selected log records. */
gint
components_inspector_log_view_count_selected_records (ComponentsInspectorLogView* self)
{
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	gint result;
	g_return_val_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self), 0);
	_tmp0_ = self->priv->logs_view;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	result = gtk_tree_selection_count_selected_rows (_tmp1_);
	return result;
}

/** Enables and disables updating log records as new ones arrive. */
void
components_inspector_log_view_enable_log_updates (ComponentsInspectorLogView* self,
                                                  gboolean enabled)
{
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	self->priv->update_logs = enabled;
	self->priv->autoscroll = enabled;
	if (enabled) {
		GearyLoggingRecord* logs = NULL;
		GearyLoggingRecord* _tmp0_;
		GearyLoggingRecord* _tmp1_;
		_tmp0_ = self->priv->first_pending;
		_tmp1_ = _geary_logging_record_ref0 (_tmp0_);
		logs = _tmp1_;
		while (TRUE) {
			GearyLoggingRecord* _tmp2_;
			GearyLoggingRecord* _tmp3_;
			GtkListStore* _tmp4_;
			GearyLoggingRecord* _tmp5_;
			GearyLoggingRecord* _tmp6_;
			GearyLoggingRecord* _tmp7_;
			GearyLoggingRecord* _tmp8_;
			_tmp2_ = logs;
			if (!(_tmp2_ != NULL)) {
				break;
			}
			_tmp3_ = logs;
			_tmp4_ = self->priv->logs_store;
			components_inspector_log_view_update_record (self, _tmp3_, _tmp4_, -1);
			_tmp5_ = logs;
			_tmp6_ = geary_logging_record_get_next (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _geary_logging_record_ref0 (_tmp7_);
			_geary_logging_record_unref0 (logs);
			logs = _tmp8_;
		}
		_geary_logging_record_unref0 (self->priv->first_pending);
		self->priv->first_pending = NULL;
		_geary_logging_record_unref0 (logs);
	}
}

/** Saves all log records to the given output stream. */
static Block58Data*
block58_data_ref (Block58Data* _data58_)
{
	g_atomic_int_inc (&_data58_->_ref_count_);
	return _data58_;
}

static void
block58_data_unref (void * _userdata_)
{
	Block58Data* _data58_;
	_data58_ = (Block58Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data58_->_ref_count_)) {
		ComponentsInspectorLogView* self;
		self = _data58_->self;
		_g_free0 (_data58_->line_sep);
		_g_object_unref0 (_data58_->out);
		_g_object_unref0 (_data58_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block58Data, _data58_);
	}
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static Block59Data*
block59_data_ref (Block59Data* _data59_)
{
	g_atomic_int_inc (&_data59_->_ref_count_);
	return _data59_;
}

static void
block59_data_unref (void * _userdata_)
{
	Block59Data* _data59_;
	_data59_ = (Block59Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data59_->_ref_count_)) {
		ComponentsInspectorLogView* self;
		self = _data59_->_data58_->self;
		_g_error_free0 (_data59_->inner_err);
		block58_data_unref (_data59_->_data58_);
		_data59_->_data58_ = NULL;
		g_slice_free (Block59Data, _data59_);
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
___lambda38_ (Block59Data* _data59_,
              GtkTreeModel* model,
              GtkTreePath* path,
              GtkTreeIter* iter)
{
	Block58Data* _data58_;
	ComponentsInspectorLogView* self;
	GError* _tmp0_;
	GError* _inner_error0_ = NULL;
	_data58_ = _data59_->_data58_;
	self = _data58_->self;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()));
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = _data59_->inner_err;
	if (_tmp0_ == NULL) {
		{
			GtkTreeIter _tmp1_;
			const gchar* _tmp2_;
			_tmp1_ = *iter;
			components_inspector_log_view_save_record (self, model, &_tmp1_, _data58_->out, _data58_->cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = _data58_->line_sep;
			g_data_output_stream_put_string (_data58_->out, _tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GError* _tmp3_;
			GError* _tmp4_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = err;
			_tmp4_ = _g_error_copy0 (_tmp3_);
			_g_error_free0 (_data59_->inner_err);
			_data59_->inner_err = _tmp4_;
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
____lambda38__gtk_tree_selection_foreach_func (GtkTreeModel* model,
                                               GtkTreePath* path,
                                               GtkTreeIter* iter,
                                               gpointer self)
{
	___lambda38_ (self, model, path, iter);
}

void
components_inspector_log_view_save (ComponentsInspectorLogView* self,
                                    GDataOutputStream* out,
                                    ComponentsInspectorTextFormat format,
                                    gboolean save_all,
                                    GCancellable* cancellable,
                                    GError** error)
{
	Block58Data* _data58_;
	GDataOutputStream* _tmp0_;
	GCancellable* _tmp1_;
	gchar* _tmp2_;
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeModel* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (out, g_data_output_stream_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data58_ = g_slice_new0 (Block58Data);
	_data58_->_ref_count_ = 1;
	_data58_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (out);
	_g_object_unref0 (_data58_->out);
	_data58_->out = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data58_->cancellable);
	_data58_->cancellable = _tmp1_;
	if (format == COMPONENTS_INSPECTOR_TEXT_FORMAT_MARKDOWN) {
		g_data_output_stream_put_string (_data58_->out, "```\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			block58_data_unref (_data58_);
			_data58_ = NULL;
			return;
		}
	}
	_tmp2_ = components_inspector_text_format_get_line_separator (format);
	_data58_->line_sep = _tmp2_;
	_tmp3_ = self->priv->logs_view;
	_tmp4_ = gtk_tree_view_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	model = _tmp6_;
	if (save_all) {
		GtkTreeIter* iter = NULL;
		gboolean valid = FALSE;
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_ = {0};
		gboolean _tmp9_;
		GtkTreeIter _tmp10_;
		GtkTreeIter* _tmp11_;
		_tmp7_ = model;
		_tmp9_ = gtk_tree_model_get_iter_first (_tmp7_, &_tmp8_);
		__vala_GtkTreeIter_free0 (iter);
		_tmp10_ = _tmp8_;
		_tmp11_ = __vala_GtkTreeIter_copy0 (&_tmp10_);
		iter = _tmp11_;
		valid = _tmp9_;
		while (TRUE) {
			gboolean _tmp12_ = FALSE;
			GtkTreeModel* _tmp13_;
			GtkTreeIter* _tmp14_;
			GtkTreeIter _tmp15_;
			const gchar* _tmp16_;
			GtkTreeModel* _tmp17_;
			gboolean _tmp18_;
			if (valid) {
				_tmp12_ = !g_cancellable_is_cancelled (_data58_->cancellable);
			} else {
				_tmp12_ = FALSE;
			}
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = model;
			_tmp14_ = iter;
			_tmp15_ = *_tmp14_;
			components_inspector_log_view_save_record (self, _tmp13_, &_tmp15_, _data58_->out, _data58_->cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				__vala_GtkTreeIter_free0 (iter);
				_g_object_unref0 (model);
				block58_data_unref (_data58_);
				_data58_ = NULL;
				return;
			}
			_tmp16_ = _data58_->line_sep;
			g_data_output_stream_put_string (_data58_->out, _tmp16_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				__vala_GtkTreeIter_free0 (iter);
				_g_object_unref0 (model);
				block58_data_unref (_data58_);
				_data58_ = NULL;
				return;
			}
			_tmp17_ = model;
			_tmp18_ = gtk_tree_model_iter_next (_tmp17_, iter);
			valid = _tmp18_;
		}
		__vala_GtkTreeIter_free0 (iter);
	} else {
		Block59Data* _data59_;
		GtkTreeView* _tmp19_;
		GtkTreeSelection* _tmp20_;
		GError* _tmp21_;
		_data59_ = g_slice_new0 (Block59Data);
		_data59_->_ref_count_ = 1;
		_data59_->_data58_ = block58_data_ref (_data58_);
		_data59_->inner_err = NULL;
		_tmp19_ = self->priv->logs_view;
		_tmp20_ = gtk_tree_view_get_selection (_tmp19_);
		gtk_tree_selection_selected_foreach (_tmp20_, ____lambda38__gtk_tree_selection_foreach_func, _data59_);
		_tmp21_ = _data59_->inner_err;
		if (_tmp21_ != NULL) {
			GError* _tmp22_;
			GError* _tmp23_;
			_tmp22_ = _data59_->inner_err;
			_tmp23_ = _g_error_copy0 (_tmp22_);
			_inner_error0_ = _tmp23_;
			g_propagate_error (error, _inner_error0_);
			block59_data_unref (_data59_);
			_data59_ = NULL;
			_g_object_unref0 (model);
			block58_data_unref (_data58_);
			_data58_ = NULL;
			return;
		}
		block59_data_unref (_data59_);
		_data59_ = NULL;
	}
	if (format == COMPONENTS_INSPECTOR_TEXT_FORMAT_MARKDOWN) {
		g_data_output_stream_put_string (_data58_->out, "```\n", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (model);
			block58_data_unref (_data58_);
			_data58_ = NULL;
			return;
		}
	}
	_g_object_unref0 (model);
	block58_data_unref (_data58_);
	_data58_ = NULL;
}

static inline void
components_inspector_log_view_save_record (ComponentsInspectorLogView* self,
                                           GtkTreeModel* model,
                                           GtkTreeIter* iter,
                                           GDataOutputStream* out,
                                           GCancellable* cancellable,
                                           GError** error)
{
	GValue value = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	gchar* message = NULL;
	GValue _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()));
	g_return_if_fail (iter != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (out, g_data_output_stream_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = *iter;
	gtk_tree_model_get_value (model, &_tmp0_, COMPONENTS_INSPECTOR_LOG_VIEW_COL_MESSAGE, &_tmp1_);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp1_;
	_tmp2_ = value;
	_tmp3_ = g_strdup (g_value_get_string (&_tmp2_));
	message = _tmp3_;
	_tmp4_ = message;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = message;
		g_data_output_stream_put_string (out, _tmp5_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (message);
			G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
			return;
		}
	}
	_g_free0 (message);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}

static void
_components_inspector_log_view_on_account_enabled_changed_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self)
{
	components_inspector_log_view_on_account_enabled_changed ((ComponentsInspectorLogView*) self, _sender, pspec);
}

static void
components_inspector_log_view_add_account (ComponentsInspectorLogView* self,
                                           GearyAccountInformation* account)
{
	GeeSet* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT_INFORMATION));
	_tmp0_ = self->priv->seen_accounts;
	_tmp1_ = geary_account_information_get_id (account);
	_tmp2_ = _tmp1_;
	if (gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), _tmp2_)) {
		ComponentsInspectorLogViewSidebarRow* row = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ComponentsInspectorLogViewSidebarRow* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GearyAccountInformation* _tmp9_;
		ComponentsInspectorLogViewSidebarRow* _tmp15_;
		ComponentsInspectorLogViewSidebarRow* _tmp16_;
		_tmp3_ = geary_account_information_get_display_name (account);
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_account_information_get_id (account);
		_tmp6_ = _tmp5_;
		_tmp7_ = components_inspector_log_view_sidebar_row_new (COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_ACCOUNT, _tmp4_, _tmp6_);
		g_object_ref_sink (_tmp7_);
		row = _tmp7_;
		_tmp9_ = self->priv->account_filter;
		if (_tmp9_ == NULL) {
			_tmp8_ = TRUE;
		} else {
			GearyAccountInformation* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp10_ = self->priv->account_filter;
			_tmp11_ = geary_account_information_get_id (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = geary_account_information_get_id (account);
			_tmp14_ = _tmp13_;
			_tmp8_ = g_strcmp0 (_tmp12_, _tmp14_) == 0;
		}
		_tmp15_ = row;
		components_inspector_log_view_sidebar_row_set_enabled (_tmp15_, _tmp8_);
		_tmp16_ = row;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, G_TYPE_OBJECT, GObject), "notify::enabled", (GCallback) _components_inspector_log_view_on_account_enabled_changed_g_object_notify, self, 0);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp17_ = FALSE;
				_tmp17_ = TRUE;
				while (TRUE) {
					ComponentsInspectorLogViewSidebarRow* existing = NULL;
					GtkListBox* _tmp19_;
					GtkListBoxRow* _tmp20_;
					ComponentsInspectorLogViewSidebarRow* _tmp21_;
					gboolean _tmp22_ = FALSE;
					gboolean _tmp23_ = FALSE;
					ComponentsInspectorLogViewSidebarRow* _tmp24_;
					if (!_tmp17_) {
						gint _tmp18_;
						_tmp18_ = i;
						i = _tmp18_ + 1;
					}
					_tmp17_ = FALSE;
					_tmp19_ = self->priv->sidebar;
					_tmp20_ = gtk_list_box_get_row_at_index (_tmp19_, i);
					_tmp21_ = _g_object_ref0 (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (_tmp20_) ? ((ComponentsInspectorLogViewSidebarRow*) _tmp20_) : NULL);
					existing = _tmp21_;
					_tmp24_ = existing;
					if (_tmp24_ == NULL) {
						_tmp23_ = TRUE;
					} else {
						ComponentsInspectorLogViewSidebarRow* _tmp25_;
						ComponentsInspectorLogViewSidebarRowRowType _tmp26_;
						ComponentsInspectorLogViewSidebarRowRowType _tmp27_;
						_tmp25_ = existing;
						_tmp26_ = components_inspector_log_view_sidebar_row_get_row_type (_tmp25_);
						_tmp27_ = _tmp26_;
						_tmp23_ = _tmp27_ != COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_ACCOUNT;
					}
					if (_tmp23_) {
						_tmp22_ = TRUE;
					} else {
						ComponentsInspectorLogViewSidebarRow* _tmp28_;
						const gchar* _tmp29_;
						const gchar* _tmp30_;
						ComponentsInspectorLogViewSidebarRow* _tmp31_;
						const gchar* _tmp32_;
						const gchar* _tmp33_;
						_tmp28_ = existing;
						_tmp29_ = components_inspector_log_view_sidebar_row_get_id (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = row;
						_tmp32_ = components_inspector_log_view_sidebar_row_get_id (_tmp31_);
						_tmp33_ = _tmp32_;
						_tmp22_ = g_utf8_collate (_tmp30_, _tmp33_) > 0;
					}
					if (_tmp22_) {
						GtkListBox* _tmp34_;
						ComponentsInspectorLogViewSidebarRow* _tmp35_;
						_tmp34_ = self->priv->sidebar;
						_tmp35_ = row;
						gtk_list_box_insert (_tmp34_, G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, gtk_widget_get_type (), GtkWidget), i);
						_g_object_unref0 (existing);
						break;
					}
					_g_object_unref0 (existing);
				}
			}
		}
		_g_object_unref0 (row);
	}
}

static void
_components_inspector_log_view_on_domain_enabled_changed_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self)
{
	components_inspector_log_view_on_domain_enabled_changed ((ComponentsInspectorLogView*) self, _sender, pspec);
}

static void
components_inspector_log_view_add_domain (ComponentsInspectorLogView* self,
                                          const gchar* domain)
{
	const gchar* _tmp0_ = NULL;
	gchar* safe_domain = NULL;
	gchar* _tmp1_;
	GeeSet* _tmp2_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	_tmp0_ = domain;
	if (_tmp0_ == NULL) {
		_tmp0_ = "(none)";
	}
	_tmp1_ = g_strdup (_tmp0_);
	safe_domain = _tmp1_;
	_tmp2_ = self->priv->seen_domains;
	if (gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), domain)) {
		ComponentsInspectorLogViewSidebarRowRowType _tmp3_ = 0;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_;
		ComponentsInspectorLogViewSidebarRowRowType type = 0;
		ComponentsInspectorLogViewSidebarRow* row = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ComponentsInspectorLogViewSidebarRow* _tmp12_;
		const gchar* _tmp13_ = NULL;
		ComponentsInspectorLogViewSidebarRow* _tmp14_;
		ComponentsInspectorLogViewSidebarRow* _tmp15_;
		gint i = 0;
		_tmp4_ = safe_domain;
		_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_utf8_strdown (GEARY_LOGGING_DOMAIN, (gssize) -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_str_has_prefix (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		if (_tmp9_) {
			_tmp3_ = COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_INTERNAL_DOMAIN;
		} else {
			_tmp3_ = COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_EXTERNAL_DOMAIN;
		}
		type = _tmp3_;
		_tmp10_ = safe_domain;
		_tmp11_ = safe_domain;
		_tmp12_ = components_inspector_log_view_sidebar_row_new (type, _tmp10_, _tmp11_);
		g_object_ref_sink (_tmp12_);
		row = _tmp12_;
		_tmp13_ = domain;
		if (_tmp13_ == NULL) {
			_tmp13_ = "";
		}
		_tmp14_ = row;
		components_inspector_log_view_sidebar_row_set_enabled (_tmp14_, !geary_logging_is_suppressed_domain (_tmp13_));
		_tmp15_ = row;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, G_TYPE_OBJECT, GObject), "notify::enabled", (GCallback) _components_inspector_log_view_on_domain_enabled_changed_g_object_notify, self, 0);
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				ComponentsInspectorLogViewSidebarRow* existing = NULL;
				GtkListBox* _tmp18_;
				GtkListBoxRow* _tmp19_;
				ComponentsInspectorLogViewSidebarRow* _tmp20_;
				gboolean _tmp21_ = FALSE;
				ComponentsInspectorLogViewSidebarRow* _tmp22_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = self->priv->sidebar;
				_tmp19_ = gtk_list_box_get_row_at_index (_tmp18_, i);
				_tmp20_ = _g_object_ref0 (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (_tmp19_) ? ((ComponentsInspectorLogViewSidebarRow*) _tmp19_) : NULL);
				existing = _tmp20_;
				_tmp22_ = existing;
				if (_tmp22_ == NULL) {
					_tmp21_ = TRUE;
				} else {
					ComponentsInspectorLogViewSidebarRow* _tmp23_;
					ComponentsInspectorLogViewSidebarRowRowType _tmp24_;
					ComponentsInspectorLogViewSidebarRowRowType _tmp25_;
					_tmp23_ = existing;
					_tmp24_ = components_inspector_log_view_sidebar_row_get_row_type (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp21_ = _tmp25_ == type;
				}
				if (_tmp21_) {
					_g_object_unref0 (existing);
					break;
				}
				_g_object_unref0 (existing);
			}
		}
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				ComponentsInspectorLogViewSidebarRow* existing = NULL;
				GtkListBox* _tmp28_;
				GtkListBoxRow* _tmp29_;
				ComponentsInspectorLogViewSidebarRow* _tmp30_;
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_ = FALSE;
				ComponentsInspectorLogViewSidebarRow* _tmp33_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp28_ = self->priv->sidebar;
				_tmp29_ = gtk_list_box_get_row_at_index (_tmp28_, i);
				_tmp30_ = _g_object_ref0 (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (_tmp29_) ? ((ComponentsInspectorLogViewSidebarRow*) _tmp29_) : NULL);
				existing = _tmp30_;
				_tmp33_ = existing;
				if (_tmp33_ == NULL) {
					_tmp32_ = TRUE;
				} else {
					ComponentsInspectorLogViewSidebarRow* _tmp34_;
					ComponentsInspectorLogViewSidebarRowRowType _tmp35_;
					ComponentsInspectorLogViewSidebarRowRowType _tmp36_;
					_tmp34_ = existing;
					_tmp35_ = components_inspector_log_view_sidebar_row_get_row_type (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp32_ = _tmp36_ != type;
				}
				if (_tmp32_) {
					_tmp31_ = TRUE;
				} else {
					ComponentsInspectorLogViewSidebarRow* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					ComponentsInspectorLogViewSidebarRow* _tmp40_;
					const gchar* _tmp41_;
					const gchar* _tmp42_;
					_tmp37_ = existing;
					_tmp38_ = components_inspector_log_view_sidebar_row_get_id (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = row;
					_tmp41_ = components_inspector_log_view_sidebar_row_get_id (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp31_ = g_utf8_collate (_tmp39_, _tmp42_) > 0;
				}
				if (_tmp31_) {
					GtkListBox* _tmp43_;
					ComponentsInspectorLogViewSidebarRow* _tmp44_;
					_tmp43_ = self->priv->sidebar;
					_tmp44_ = row;
					gtk_list_box_insert (_tmp43_, G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_widget_get_type (), GtkWidget), i);
					_g_object_unref0 (existing);
					break;
				}
				_g_object_unref0 (existing);
			}
		}
		_g_object_unref0 (row);
	}
	_g_free0 (safe_domain);
}

static void
components_inspector_log_view_update_scrollbar (ComponentsInspectorLogView* self)
{
	GtkAdjustment* adj = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	_tmp0_ = self->priv->logs_scroller;
	_tmp1_ = gtk_scrolled_window_get_vadjustment (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	adj = _tmp2_;
	_tmp3_ = gtk_adjustment_get_upper (adj);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_adjustment_get_page_size (adj);
	_tmp6_ = _tmp5_;
	gtk_adjustment_set_value (adj, _tmp4_ - _tmp6_);
	_g_object_unref0 (adj);
}

static void
components_inspector_log_view_update_logs_filter (ComponentsInspectorLogView* self)
{
	gchar* cleaned = NULL;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	GtkTreeModelFilter* _tmp9_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_entry_get_type (), GtkEntry));
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_string_reduce_whitespace (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_casefold (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	cleaned = _tmp6_;
	_tmp8_ = _tmp7_ = g_strsplit (cleaned, " ", 0);
	self->priv->logs_filter_terms = (_vala_array_free (self->priv->logs_filter_terms, self->priv->logs_filter_terms_length1, (GDestroyNotify) g_free), NULL);
	self->priv->logs_filter_terms = _tmp8_;
	self->priv->logs_filter_terms_length1 = _vala_array_length (_tmp7_);
	self->priv->_logs_filter_terms_size_ = self->priv->logs_filter_terms_length1;
	_tmp9_ = self->priv->logs_filter;
	gtk_tree_model_filter_refilter (_tmp9_);
	_g_free0 (cleaned);
}

static inline void
components_inspector_log_view_update_record (ComponentsInspectorLogView* self,
                                             GearyLoggingRecord* record,
                                             GtkListStore* store,
                                             gint position)
{
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GearyAccount* account = NULL;
	GearyAccount* _tmp10_;
	GearyAccount* _tmp11_;
	GearyAccount* _tmp12_;
	const gchar* _tmp13_ = NULL;
	GearyAccount* _tmp14_;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (record, GEARY_LOGGING_TYPE_RECORD));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (store, gtk_list_store_get_type ()));
	geary_logging_record_fill_well_known_sources (record);
	_tmp0_ = geary_logging_record_get_account (record);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GearyAccount* _tmp2_;
		GearyAccount* _tmp3_;
		GearyAccountInformation* _tmp4_;
		GearyAccountInformation* _tmp5_;
		_tmp2_ = geary_logging_record_get_account (record);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_account_get_information (_tmp3_);
		_tmp5_ = _tmp4_;
		components_inspector_log_view_add_account (self, _tmp5_);
	}
	_tmp6_ = geary_logging_record_get_domain (record);
	_tmp7_ = _tmp6_;
	components_inspector_log_view_add_domain (self, _tmp7_);
	_tmp8_ = geary_logging_record_format (record);
	_tmp9_ = _tmp8_;
	_vala_assert (_tmp9_ != NULL, "record.format() != null");
	_g_free0 (_tmp9_);
	_tmp10_ = geary_logging_record_get_account (record);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	account = _tmp12_;
	_tmp14_ = account;
	if (_tmp14_ != NULL) {
		GearyAccount* _tmp15_;
		GearyAccountInformation* _tmp16_;
		GearyAccountInformation* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp15_ = account;
		_tmp16_ = geary_account_get_information (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = geary_account_information_get_id (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = _tmp19_;
	} else {
		_tmp13_ = "";
	}
	_tmp21_ = geary_logging_record_get_domain (record);
	_tmp22_ = _tmp21_;
	_tmp20_ = _tmp22_;
	if (_tmp20_ == NULL) {
		_tmp20_ = "";
	}
	_tmp23_ = geary_logging_record_format (record);
	_tmp24_ = _tmp23_;
	gtk_list_store_insert_with_values (store, NULL, position, COMPONENTS_INSPECTOR_LOG_VIEW_COL_MESSAGE, _tmp24_, COMPONENTS_INSPECTOR_LOG_VIEW_COL_ACCOUNT, _tmp13_, COMPONENTS_INSPECTOR_LOG_VIEW_COL_DOMAIN, _tmp20_, -1);
	_g_free0 (_tmp24_);
	_g_object_unref0 (account);
}

static void
components_inspector_log_view_sidebar_header_update (ComponentsInspectorLogView* self,
                                                     GtkListBoxRow* current_row,
                                                     GtkListBoxRow* previous_row)
{
	GtkWidget* header = NULL;
	ComponentsInspectorLogViewSidebarRow* current = NULL;
	ComponentsInspectorLogViewSidebarRow* _tmp0_;
	ComponentsInspectorLogViewSidebarRow* previous = NULL;
	ComponentsInspectorLogViewSidebarRow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ComponentsInspectorLogViewSidebarRow* _tmp3_;
	GtkWidget* _tmp13_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (current_row, gtk_list_box_row_get_type ()));
	g_return_if_fail ((previous_row == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (previous_row, gtk_list_box_row_get_type ()));
	header = NULL;
	_tmp0_ = _g_object_ref0 (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (current_row) ? ((ComponentsInspectorLogViewSidebarRow*) current_row) : NULL);
	current = _tmp0_;
	_tmp1_ = _g_object_ref0 (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (previous_row) ? ((ComponentsInspectorLogViewSidebarRow*) previous_row) : NULL);
	previous = _tmp1_;
	_tmp3_ = current;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ComponentsInspectorLogViewSidebarRow* _tmp5_;
		_tmp5_ = previous;
		if (_tmp5_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			ComponentsInspectorLogViewSidebarRow* _tmp6_;
			ComponentsInspectorLogViewSidebarRowRowType _tmp7_;
			ComponentsInspectorLogViewSidebarRowRowType _tmp8_;
			ComponentsInspectorLogViewSidebarRow* _tmp9_;
			ComponentsInspectorLogViewSidebarRowRowType _tmp10_;
			ComponentsInspectorLogViewSidebarRowRowType _tmp11_;
			_tmp6_ = current;
			_tmp7_ = components_inspector_log_view_sidebar_row_get_row_type (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = previous;
			_tmp10_ = components_inspector_log_view_sidebar_row_get_row_type (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp4_ = _tmp8_ != _tmp11_;
		}
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkSeparator* _tmp12_;
		_tmp12_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (header);
		header = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget);
	}
	_tmp13_ = header;
	gtk_list_box_row_set_header (current_row, _tmp13_);
	_g_object_unref0 (previous);
	_g_object_unref0 (current);
	_g_object_unref0 (header);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
components_inspector_log_view_log_filter_func (ComponentsInspectorLogView* self,
                                               GtkTreeModel* model,
                                               GtkTreeIter* iter)
{
	GValue value = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	gchar* account = NULL;
	GValue _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean show_row = FALSE;
	GtkTreeIter _tmp13_;
	GValue _tmp14_ = {0};
	gchar* message = NULL;
	GValue _tmp15_;
	gchar* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean result;
	g_return_val_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (model, gtk_tree_model_get_type ()), FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get_value (model, &_tmp0_, COMPONENTS_INSPECTOR_LOG_VIEW_COL_ACCOUNT, &_tmp1_);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp1_;
	_tmp2_ = value;
	_tmp3_ = g_strdup (g_value_get_string (&_tmp2_));
	account = _tmp3_;
	_tmp5_ = account;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		_tmp4_ = TRUE;
	} else {
		GeeSet* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->suppressed_accounts;
		_tmp7_ = account;
		_tmp4_ = !gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection), _tmp7_);
	}
	show_row = _tmp4_;
	if (show_row) {
		GtkTreeIter _tmp8_;
		GValue _tmp9_ = {0};
		gchar* domain = NULL;
		GValue _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = *iter;
		gtk_tree_model_get_value (model, &_tmp8_, COMPONENTS_INSPECTOR_LOG_VIEW_COL_DOMAIN, &_tmp9_);
		G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
		value = _tmp9_;
		_tmp10_ = value;
		_tmp11_ = g_strdup (g_value_get_string (&_tmp10_));
		domain = _tmp11_;
		_tmp12_ = domain;
		show_row = !geary_logging_is_suppressed_domain (_tmp12_);
		_g_free0 (domain);
	}
	_tmp13_ = *iter;
	gtk_tree_model_get_value (model, &_tmp13_, COMPONENTS_INSPECTOR_LOG_VIEW_COL_MESSAGE, &_tmp14_);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp14_;
	_tmp15_ = value;
	_tmp16_ = g_strdup (g_value_get_string (&_tmp15_));
	message = _tmp16_;
	if (show_row) {
		gchar** _tmp18_;
		gint _tmp18__length1;
		_tmp18_ = self->priv->logs_filter_terms;
		_tmp18__length1 = self->priv->logs_filter_terms_length1;
		_tmp17_ = _tmp18__length1 > 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gchar* folded_message = NULL;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		_tmp19_ = message;
		_tmp20_ = g_utf8_casefold (_tmp19_, (gssize) -1);
		folded_message = _tmp20_;
		_tmp21_ = self->priv->logs_filter_terms;
		_tmp21__length1 = self->priv->logs_filter_terms_length1;
		{
			gchar** term_collection = NULL;
			gint term_collection_length1 = 0;
			gint _term_collection_size_ = 0;
			gint term_it = 0;
			term_collection = _tmp21_;
			term_collection_length1 = _tmp21__length1;
			for (term_it = 0; term_it < term_collection_length1; term_it = term_it + 1) {
				gchar* _tmp22_;
				gchar* term = NULL;
				_tmp22_ = g_strdup (term_collection[term_it]);
				term = _tmp22_;
				{
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					_tmp23_ = folded_message;
					_tmp24_ = term;
					if (!string_contains (_tmp23_, _tmp24_)) {
						show_row = FALSE;
						_g_free0 (term);
						break;
					}
					_g_free0 (term);
				}
			}
		}
		_g_free0 (folded_message);
	}
	if (!show_row) {
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp26_ = message;
		_tmp27_ = message;
		_tmp28_ = strlen (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp25_ = string_index_of (_tmp26_, "---- 8< ----", _tmp29_ - 15) >= 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		show_row = TRUE;
	}
	result = show_row;
	_g_free0 (message);
	_g_free0 (account);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	return result;
}

static void
components_inspector_log_view_on_logs_size_allocate (ComponentsInspectorLogView* self)
{
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	if (self->priv->autoscroll) {
		components_inspector_log_view_update_scrollbar (self);
	}
}

static void
_components_inspector_log_view_on_logs_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                               GtkAllocation* allocation,
                                                                               gpointer self)
{
	components_inspector_log_view_on_logs_size_allocate ((ComponentsInspectorLogView*) self);
}

static void
components_inspector_log_view_on_logs_search_changed (ComponentsInspectorLogView* self)
{
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	components_inspector_log_view_update_logs_filter (self);
}

static void
_components_inspector_log_view_on_logs_search_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                       gpointer self)
{
	components_inspector_log_view_on_logs_search_changed ((ComponentsInspectorLogView*) self);
}

static void
components_inspector_log_view_on_logs_selection_changed (ComponentsInspectorLogView* self)
{
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	g_signal_emit (self, components_inspector_log_view_signals[COMPONENTS_INSPECTOR_LOG_VIEW_RECORD_SELECTION_CHANGED_SIGNAL], 0);
}

static void
_components_inspector_log_view_on_logs_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                                                                     gpointer self)
{
	components_inspector_log_view_on_logs_selection_changed ((ComponentsInspectorLogView*) self);
}

static void
components_inspector_log_view_on_sidebar_row_activated (ComponentsInspectorLogView* self,
                                                        GtkListBox* list,
                                                        GtkListBoxRow* activated)
{
	ComponentsInspectorLogViewSidebarRow* row = NULL;
	ComponentsInspectorLogViewSidebarRow* _tmp0_;
	ComponentsInspectorLogViewSidebarRow* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (list, gtk_list_box_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (activated, gtk_list_box_row_get_type ()));
	_tmp0_ = _g_object_ref0 (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (activated) ? ((ComponentsInspectorLogViewSidebarRow*) activated) : NULL);
	row = _tmp0_;
	_tmp1_ = row;
	if (_tmp1_ != NULL) {
		ComponentsInspectorLogViewSidebarRow* _tmp2_;
		ComponentsInspectorLogViewSidebarRow* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = row;
		_tmp3_ = row;
		_tmp4_ = components_inspector_log_view_sidebar_row_get_enabled (_tmp3_);
		_tmp5_ = _tmp4_;
		components_inspector_log_view_sidebar_row_set_enabled (_tmp2_, !_tmp5_);
	}
	_g_object_unref0 (row);
}

static void
_components_inspector_log_view_on_sidebar_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                    GtkListBoxRow* row,
                                                                                    gpointer self)
{
	components_inspector_log_view_on_sidebar_row_activated ((ComponentsInspectorLogView*) self, _sender, row);
}

static Block60Data*
block60_data_ref (Block60Data* _data60_)
{
	g_atomic_int_inc (&_data60_->_ref_count_);
	return _data60_;
}

static void
block60_data_unref (void * _userdata_)
{
	Block60Data* _data60_;
	_data60_ = (Block60Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data60_->_ref_count_)) {
		ComponentsInspectorLogView* self;
		self = _data60_->self;
		_geary_logging_record_unref0 (_data60_->record);
		_g_object_unref0 (self);
		g_slice_free (Block60Data, _data60_);
	}
}

static gboolean
___lambda37_ (Block60Data* _data60_)
{
	ComponentsInspectorLogView* self;
	GtkListStore* _tmp0_;
	gboolean result;
	self = _data60_->self;
	_tmp0_ = self->priv->logs_store;
	components_inspector_log_view_update_record (self, _data60_->record, _tmp0_, -1);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda37__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda37_ (self);
	return result;
}

static void
components_inspector_log_view_on_log_record (ComponentsInspectorLogView* self,
                                             GearyLoggingRecord* record)
{
	Block60Data* _data60_;
	GearyLoggingRecord* _tmp0_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (record, GEARY_LOGGING_TYPE_RECORD));
	_data60_ = g_slice_new0 (Block60Data);
	_data60_->_ref_count_ = 1;
	_data60_->self = g_object_ref (self);
	_tmp0_ = _geary_logging_record_ref0 (record);
	_geary_logging_record_unref0 (_data60_->record);
	_data60_->record = _tmp0_;
	if (self->priv->update_logs) {
		GMainContext* _tmp1_;
		_tmp1_ = g_main_context_default ();
		g_main_context_invoke_full (_tmp1_, G_PRIORITY_DEFAULT, ____lambda37__gsource_func, block60_data_ref (_data60_), block60_data_unref);
	} else {
		GearyLoggingRecord* _tmp2_;
		_tmp2_ = self->priv->first_pending;
		if (_tmp2_ == NULL) {
			GearyLoggingRecord* _tmp3_;
			_tmp3_ = _geary_logging_record_ref0 (_data60_->record);
			_geary_logging_record_unref0 (self->priv->first_pending);
			self->priv->first_pending = _tmp3_;
		}
	}
	block60_data_unref (_data60_);
	_data60_ = NULL;
}

static void
components_inspector_log_view_on_account_enabled_changed (ComponentsInspectorLogView* self,
                                                          GObject* object,
                                                          GParamSpec* param)
{
	ComponentsInspectorLogViewSidebarRow* row = NULL;
	ComponentsInspectorLogViewSidebarRow* _tmp0_;
	ComponentsInspectorLogViewSidebarRow* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (object, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (param, G_TYPE_PARAM));
	_tmp0_ = _g_object_ref0 (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (object) ? ((ComponentsInspectorLogViewSidebarRow*) object) : NULL);
	row = _tmp0_;
	_tmp1_ = row;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		ComponentsInspectorLogViewSidebarRow* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = row;
		_tmp5_ = components_inspector_log_view_sidebar_row_get_enabled (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			GeeSet* _tmp7_;
			ComponentsInspectorLogViewSidebarRow* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp7_ = self->priv->suppressed_accounts;
			_tmp8_ = row;
			_tmp9_ = components_inspector_log_view_sidebar_row_get_id (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp3_ = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), _tmp10_);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			gboolean _tmp11_ = FALSE;
			ComponentsInspectorLogViewSidebarRow* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp12_ = row;
			_tmp13_ = components_inspector_log_view_sidebar_row_get_enabled (_tmp12_);
			_tmp14_ = _tmp13_;
			if (!_tmp14_) {
				GeeSet* _tmp15_;
				ComponentsInspectorLogViewSidebarRow* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp15_ = self->priv->suppressed_accounts;
				_tmp16_ = row;
				_tmp17_ = components_inspector_log_view_sidebar_row_get_id (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp11_ = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), _tmp18_);
			} else {
				_tmp11_ = FALSE;
			}
			_tmp2_ = _tmp11_;
		}
		if (_tmp2_) {
			components_inspector_log_view_update_logs_filter (self);
		}
	}
	_g_object_unref0 (row);
}

static void
components_inspector_log_view_on_domain_enabled_changed (ComponentsInspectorLogView* self,
                                                         GObject* object,
                                                         GParamSpec* param)
{
	ComponentsInspectorLogViewSidebarRow* row = NULL;
	ComponentsInspectorLogViewSidebarRow* _tmp0_;
	ComponentsInspectorLogViewSidebarRow* _tmp1_;
	g_return_if_fail (COMPONENTS_IS_INSPECTOR_LOG_VIEW (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (object, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (param, G_TYPE_PARAM));
	_tmp0_ = _g_object_ref0 (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (object) ? ((ComponentsInspectorLogViewSidebarRow*) object) : NULL);
	row = _tmp0_;
	_tmp1_ = row;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		ComponentsInspectorLogViewSidebarRow* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = row;
		_tmp5_ = components_inspector_log_view_sidebar_row_get_enabled (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			ComponentsInspectorLogViewSidebarRow* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = row;
			_tmp8_ = components_inspector_log_view_sidebar_row_get_id (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = geary_logging_unsuppress_domain (_tmp9_);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			gboolean _tmp10_ = FALSE;
			ComponentsInspectorLogViewSidebarRow* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp11_ = row;
			_tmp12_ = components_inspector_log_view_sidebar_row_get_enabled (_tmp11_);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				ComponentsInspectorLogViewSidebarRow* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp14_ = row;
				_tmp15_ = components_inspector_log_view_sidebar_row_get_id (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp10_ = geary_logging_suppress_domain (_tmp16_);
			} else {
				_tmp10_ = FALSE;
			}
			_tmp2_ = _tmp10_;
		}
		if (_tmp2_) {
			components_inspector_log_view_update_logs_filter (self);
		}
	}
	_g_object_unref0 (row);
}

static inline gpointer
components_inspector_log_view_sidebar_row_get_instance_private (ComponentsInspectorLogViewSidebarRow* self)
{
	return G_STRUCT_MEMBER_P (self, ComponentsInspectorLogViewSidebarRow_private_offset);
}

static GType
components_inspector_log_view_sidebar_row_row_type_get_type_once (void)
{
	static const GEnumValue values[] = {{COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_ACCOUNT, "COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_ACCOUNT", "account"}, {COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_INTERNAL_DOMAIN, "COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_INTERNAL_DOMAIN", "internal-domain"}, {COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_EXTERNAL_DOMAIN, "COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_EXTERNAL_DOMAIN", "external-domain"}, {0, NULL, NULL}};
	GType components_inspector_log_view_sidebar_row_row_type_type_id;
	components_inspector_log_view_sidebar_row_row_type_type_id = g_enum_register_static ("ComponentsInspectorLogViewSidebarRowRowType", values);
	return components_inspector_log_view_sidebar_row_row_type_type_id;
}

GType
components_inspector_log_view_sidebar_row_row_type_get_type (void)
{
	static volatile gsize components_inspector_log_view_sidebar_row_row_type_type_id__once = 0;
	if (g_once_init_enter (&components_inspector_log_view_sidebar_row_row_type_type_id__once)) {
		GType components_inspector_log_view_sidebar_row_row_type_type_id;
		components_inspector_log_view_sidebar_row_row_type_type_id = components_inspector_log_view_sidebar_row_row_type_get_type_once ();
		g_once_init_leave (&components_inspector_log_view_sidebar_row_row_type_type_id__once, components_inspector_log_view_sidebar_row_row_type_type_id);
	}
	return components_inspector_log_view_sidebar_row_row_type_type_id__once;
}

static ComponentsInspectorLogViewSidebarRowRowType
components_inspector_log_view_sidebar_row_get_row_type (ComponentsInspectorLogViewSidebarRow* self)
{
	ComponentsInspectorLogViewSidebarRowRowType result;
	g_return_val_if_fail (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (self), 0);
	result = self->priv->_row_type;
	return result;
}

static void
components_inspector_log_view_sidebar_row_set_row_type (ComponentsInspectorLogViewSidebarRow* self,
                                                        ComponentsInspectorLogViewSidebarRowRowType value)
{
	ComponentsInspectorLogViewSidebarRowRowType old_value;
	g_return_if_fail (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (self));
	old_value = components_inspector_log_view_sidebar_row_get_row_type (self);
	if (old_value != value) {
		self->priv->_row_type = value;
		g_object_notify_by_pspec ((GObject *) self, components_inspector_log_view_sidebar_row_properties[COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_PROPERTY]);
	}
}

static const gchar*
components_inspector_log_view_sidebar_row_get_id (ComponentsInspectorLogViewSidebarRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (self), NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
components_inspector_log_view_sidebar_row_set_id (ComponentsInspectorLogViewSidebarRow* self,
                                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (self));
	old_value = components_inspector_log_view_sidebar_row_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, components_inspector_log_view_sidebar_row_properties[COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ID_PROPERTY]);
	}
}

static gboolean
components_inspector_log_view_sidebar_row_get_enabled (ComponentsInspectorLogViewSidebarRow* self)
{
	gboolean result;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (self), FALSE);
	_tmp0_ = self->priv->enabled_toggle;
	_tmp1_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
components_inspector_log_view_sidebar_row_set_enabled (ComponentsInspectorLogViewSidebarRow* self,
                                                       gboolean value)
{
	GtkCheckButton* _tmp0_;
	g_return_if_fail (COMPONENTS_INSPECTOR_LOG_VIEW_IS_SIDEBAR_ROW (self));
	_tmp0_ = self->priv->enabled_toggle;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), value);
	g_object_notify_by_pspec ((GObject *) self, components_inspector_log_view_sidebar_row_properties[COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ENABLED_PROPERTY]);
}

static void
__lambda36_ (ComponentsInspectorLogViewSidebarRow* self)
{
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "enabled");
}

static void
___lambda36__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda36_ ((ComponentsInspectorLogViewSidebarRow*) self);
}

static ComponentsInspectorLogViewSidebarRow*
components_inspector_log_view_sidebar_row_construct (GType object_type,
                                                     ComponentsInspectorLogViewSidebarRowRowType type,
                                                     const gchar* label,
                                                     const gchar* id)
{
	ComponentsInspectorLogViewSidebarRow * self = NULL;
	GtkLabel* label_widget = NULL;
	GtkLabel* _tmp0_;
	GtkCheckButton* _tmp1_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp2_;
	GtkCheckButton* _tmp3_;
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	self = (ComponentsInspectorLogViewSidebarRow*) g_object_new (object_type, NULL);
	components_inspector_log_view_sidebar_row_set_row_type (self, type);
	components_inspector_log_view_sidebar_row_set_id (self, id);
	_tmp0_ = (GtkLabel*) gtk_label_new (label);
	g_object_ref_sink (_tmp0_);
	label_widget = _tmp0_;
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (label_widget, gtk_widget_get_type (), GtkWidget), TRUE);
	gtk_label_set_xalign (label_widget, 0.0f);
	_tmp1_ = self->priv->enabled_toggle;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_toggle_button_get_type (), GtkToggleButton), "toggled", (GCallback) ___lambda36__gtk_toggle_button_toggled, self, 0);
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp2_);
	grid = _tmp2_;
	gtk_orientable_set_orientation (G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_orientable_get_type (), GtkOrientable), GTK_ORIENTATION_HORIZONTAL);
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (label_widget, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = self->priv->enabled_toggle;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_widget_get_type (), GtkWidget));
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (grid);
	_g_object_unref0 (label_widget);
	return self;
}

static ComponentsInspectorLogViewSidebarRow*
components_inspector_log_view_sidebar_row_new (ComponentsInspectorLogViewSidebarRowRowType type,
                                               const gchar* label,
                                               const gchar* id)
{
	return components_inspector_log_view_sidebar_row_construct (COMPONENTS_INSPECTOR_LOG_VIEW_TYPE_SIDEBAR_ROW, type, label, id);
}

static void
components_inspector_log_view_sidebar_row_class_init (ComponentsInspectorLogViewSidebarRowClass * klass,
                                                      gpointer klass_data)
{
	components_inspector_log_view_sidebar_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsInspectorLogViewSidebarRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_components_inspector_log_view_sidebar_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_components_inspector_log_view_sidebar_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = components_inspector_log_view_sidebar_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_PROPERTY, components_inspector_log_view_sidebar_row_properties[COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_PROPERTY] = g_param_spec_enum ("row-type", "row-type", "row-type", COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_TYPE_ROW_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ID_PROPERTY, components_inspector_log_view_sidebar_row_properties[COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ENABLED_PROPERTY, components_inspector_log_view_sidebar_row_properties[COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
components_inspector_log_view_sidebar_row_instance_init (ComponentsInspectorLogViewSidebarRow * self,
                                                         gpointer klass)
{
	GtkCheckButton* _tmp0_;
	self->priv = components_inspector_log_view_sidebar_row_get_instance_private (self);
	_tmp0_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->enabled_toggle = _tmp0_;
}

static void
components_inspector_log_view_sidebar_row_finalize (GObject * obj)
{
	ComponentsInspectorLogViewSidebarRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_INSPECTOR_LOG_VIEW_TYPE_SIDEBAR_ROW, ComponentsInspectorLogViewSidebarRow);
	_g_free0 (self->priv->_id);
	_g_object_unref0 (self->priv->enabled_toggle);
	G_OBJECT_CLASS (components_inspector_log_view_sidebar_row_parent_class)->finalize (obj);
}

static GType
components_inspector_log_view_sidebar_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsInspectorLogViewSidebarRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_inspector_log_view_sidebar_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsInspectorLogViewSidebarRow), 0, (GInstanceInitFunc) components_inspector_log_view_sidebar_row_instance_init, NULL };
	GType components_inspector_log_view_sidebar_row_type_id;
	components_inspector_log_view_sidebar_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "ComponentsInspectorLogViewSidebarRow", &g_define_type_info, 0);
	ComponentsInspectorLogViewSidebarRow_private_offset = g_type_add_instance_private (components_inspector_log_view_sidebar_row_type_id, sizeof (ComponentsInspectorLogViewSidebarRowPrivate));
	return components_inspector_log_view_sidebar_row_type_id;
}

static GType
components_inspector_log_view_sidebar_row_get_type (void)
{
	static volatile gsize components_inspector_log_view_sidebar_row_type_id__once = 0;
	if (g_once_init_enter (&components_inspector_log_view_sidebar_row_type_id__once)) {
		GType components_inspector_log_view_sidebar_row_type_id;
		components_inspector_log_view_sidebar_row_type_id = components_inspector_log_view_sidebar_row_get_type_once ();
		g_once_init_leave (&components_inspector_log_view_sidebar_row_type_id__once, components_inspector_log_view_sidebar_row_type_id);
	}
	return components_inspector_log_view_sidebar_row_type_id__once;
}

static void
_vala_components_inspector_log_view_sidebar_row_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec)
{
	ComponentsInspectorLogViewSidebarRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_INSPECTOR_LOG_VIEW_TYPE_SIDEBAR_ROW, ComponentsInspectorLogViewSidebarRow);
	switch (property_id) {
		case COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_PROPERTY:
		g_value_set_enum (value, components_inspector_log_view_sidebar_row_get_row_type (self));
		break;
		case COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ID_PROPERTY:
		g_value_set_string (value, components_inspector_log_view_sidebar_row_get_id (self));
		break;
		case COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ENABLED_PROPERTY:
		g_value_set_boolean (value, components_inspector_log_view_sidebar_row_get_enabled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_components_inspector_log_view_sidebar_row_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec)
{
	ComponentsInspectorLogViewSidebarRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_INSPECTOR_LOG_VIEW_TYPE_SIDEBAR_ROW, ComponentsInspectorLogViewSidebarRow);
	switch (property_id) {
		case COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ROW_TYPE_PROPERTY:
		components_inspector_log_view_sidebar_row_set_row_type (self, g_value_get_enum (value));
		break;
		case COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ID_PROPERTY:
		components_inspector_log_view_sidebar_row_set_id (self, g_value_get_string (value));
		break;
		case COMPONENTS_INSPECTOR_LOG_VIEW_SIDEBAR_ROW_ENABLED_PROPERTY:
		components_inspector_log_view_sidebar_row_set_enabled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
components_inspector_log_view_class_init (ComponentsInspectorLogViewClass * klass,
                                          gpointer klass_data)
{
	components_inspector_log_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComponentsInspectorLogView_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) components_inspector_log_view_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_components_inspector_log_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_components_inspector_log_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = components_inspector_log_view_finalize;
	/** Determines if the log record search user interface is shown. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPONENTS_INSPECTOR_LOG_VIEW_SEARCH_MODE_ENABLED_PROPERTY, components_inspector_log_view_properties[COMPONENTS_INSPECTOR_LOG_VIEW_SEARCH_MODE_ENABLED_PROPERTY] = g_param_spec_boolean ("search-mode-enabled", "search-mode-enabled", "search-mode-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/components-inspector-log-view.ui");
	/** Emitted when the number of selected records changes. */
	components_inspector_log_view_signals[COMPONENTS_INSPECTOR_LOG_VIEW_RECORD_SELECTION_CHANGED_SIGNAL] = g_signal_new ("record-selection-changed", COMPONENTS_TYPE_INSPECTOR_LOG_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_bar", FALSE, ComponentsInspectorLogView_private_offset + G_STRUCT_OFFSET (ComponentsInspectorLogViewPrivate, search_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, ComponentsInspectorLogView_private_offset + G_STRUCT_OFFSET (ComponentsInspectorLogViewPrivate, search_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "sidebar", FALSE, ComponentsInspectorLogView_private_offset + G_STRUCT_OFFSET (ComponentsInspectorLogViewPrivate, sidebar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "logs_scroller", FALSE, ComponentsInspectorLogView_private_offset + G_STRUCT_OFFSET (ComponentsInspectorLogViewPrivate, logs_scroller));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "logs_view", FALSE, ComponentsInspectorLogView_private_offset + G_STRUCT_OFFSET (ComponentsInspectorLogViewPrivate, logs_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "log_renderer", FALSE, ComponentsInspectorLogView_private_offset + G_STRUCT_OFFSET (ComponentsInspectorLogViewPrivate, log_renderer));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_logs_size_allocate", G_CALLBACK(_components_inspector_log_view_on_logs_size_allocate_gtk_widget_size_allocate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_logs_search_changed", G_CALLBACK(_components_inspector_log_view_on_logs_search_changed_gtk_search_entry_search_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_logs_selection_changed", G_CALLBACK(_components_inspector_log_view_on_logs_selection_changed_gtk_tree_selection_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_sidebar_row_activated", G_CALLBACK(_components_inspector_log_view_on_sidebar_row_activated_gtk_list_box_row_activated));
}

static void
components_inspector_log_view_instance_init (ComponentsInspectorLogView * self,
                                             gpointer klass)
{
	GType* _tmp0_;
	GType* _tmp1_;
	gint _tmp1__length1;
	GtkListStore* _tmp2_;
	gchar** _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSet* _tmp5_;
	GeeHashSet* _tmp6_;
	self->priv = components_inspector_log_view_get_instance_private (self);
	_tmp0_ = g_new0 (GType, 3);
	_tmp0_[0] = G_TYPE_STRING;
	_tmp0_[1] = G_TYPE_STRING;
	_tmp0_[2] = G_TYPE_STRING;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	_tmp2_ = gtk_list_store_newv (3, _tmp1_);
	self->priv->logs_store = _tmp2_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	self->priv->logs_filter_terms = _tmp3_;
	self->priv->logs_filter_terms_length1 = 0;
	self->priv->_logs_filter_terms_size_ = self->priv->logs_filter_terms_length1;
	self->priv->update_logs = TRUE;
	self->priv->first_pending = NULL;
	self->priv->autoscroll = TRUE;
	_tmp4_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->seen_accounts = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_SET, GeeSet);
	_tmp5_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->suppressed_accounts = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_SET, GeeSet);
	_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->seen_domains = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_SET, GeeSet);
	self->priv->account_filter = NULL;
	self->priv->listener_installed = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
components_inspector_log_view_finalize (GObject * obj)
{
	ComponentsInspectorLogView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPONENTS_TYPE_INSPECTOR_LOG_VIEW, ComponentsInspectorLogView);
	_g_object_unref0 (self->priv->logs_store);
	_g_object_unref0 (self->priv->logs_filter);
	self->priv->logs_filter_terms = (_vala_array_free (self->priv->logs_filter_terms, self->priv->logs_filter_terms_length1, (GDestroyNotify) g_free), NULL);
	_geary_logging_record_unref0 (self->priv->first_pending);
	_g_object_unref0 (self->priv->seen_accounts);
	_g_object_unref0 (self->priv->suppressed_accounts);
	_g_object_unref0 (self->priv->seen_domains);
	_g_object_unref0 (self->priv->account_filter);
	G_OBJECT_CLASS (components_inspector_log_view_parent_class)->finalize (obj);
}

/**
 * A view that displays the contents of the Engine's log.
 */
static GType
components_inspector_log_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComponentsInspectorLogViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) components_inspector_log_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComponentsInspectorLogView), 0, (GInstanceInitFunc) components_inspector_log_view_instance_init, NULL };
	GType components_inspector_log_view_type_id;
	components_inspector_log_view_type_id = g_type_register_static (gtk_grid_get_type (), "ComponentsInspectorLogView", &g_define_type_info, 0);
	ComponentsInspectorLogView_private_offset = g_type_add_instance_private (components_inspector_log_view_type_id, sizeof (ComponentsInspectorLogViewPrivate));
	return components_inspector_log_view_type_id;
}

GType
components_inspector_log_view_get_type (void)
{
	static volatile gsize components_inspector_log_view_type_id__once = 0;
	if (g_once_init_enter (&components_inspector_log_view_type_id__once)) {
		GType components_inspector_log_view_type_id;
		components_inspector_log_view_type_id = components_inspector_log_view_get_type_once ();
		g_once_init_leave (&components_inspector_log_view_type_id__once, components_inspector_log_view_type_id);
	}
	return components_inspector_log_view_type_id__once;
}

static void
_vala_components_inspector_log_view_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	ComponentsInspectorLogView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_INSPECTOR_LOG_VIEW, ComponentsInspectorLogView);
	switch (property_id) {
		case COMPONENTS_INSPECTOR_LOG_VIEW_SEARCH_MODE_ENABLED_PROPERTY:
		g_value_set_boolean (value, components_inspector_log_view_get_search_mode_enabled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_components_inspector_log_view_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	ComponentsInspectorLogView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPONENTS_TYPE_INSPECTOR_LOG_VIEW, ComponentsInspectorLogView);
	switch (property_id) {
		case COMPONENTS_INSPECTOR_LOG_VIEW_SEARCH_MODE_ENABLED_PROPERTY:
		components_inspector_log_view_set_search_mode_enabled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

