// Loadable modules
//
// Generated by /build/paraview/src/build/bin/vtkProcessXML
//
#ifndef DigitalSignalProcessing_server_manager_modules_data_h
#define DigitalSignalProcessing_server_manager_modules_data_h

#include <cstring>
#include <cassert>
#include <algorithm>


// From file /build/paraview/src/ParaView-v6.0.1/Plugins/DSP/Filters/DSPFilters.xml
static const char* const DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface0 =
"<ServerManagerConfiguration>\n"
"  <ProxyGroup name=\"filters\">\n"
"    <!-- ================================================================== -->\n"
"    <SourceProxy class=\"vtkMeanPowerSpectralDensity\"\n"
"                label=\"Mean Power Spectral Density\"\n"
"                name=\"MeanPowerSpectralDensity\">\n"
"      <Documentation short_help=\"Compute mean power spectral density (PSD).\">\n"
"        This filter computes the mean power spectral density (PSD) of temporal signals.\n"
"        The input should contain tables of data arrays where each table typically\n"
"        corresponds to a point or cell.\n"
"        The recommended sequence of filters applied to a vtkDataSet is:\n"
"        Temporal Multiplexing -> DSP Table FFT -> Mean Power Spectral Density\n"
"        while this one is also supported:\n"
"        Plot Data Over Time -> Table FFT -> Mean Power Spectral Density\n"
"\n"
"        Make sure that ghost points are marked as such when using the filter\n"
"        in distributed mode to prevent duplicates. This can be done by applying a\n"
"        Ghost Cells Generator on the geometry prior to transforming it into tables\n"
"        in the previous steps.\n"
"      </Documentation>\n"
"\n"
"      <InputProperty\n"
"          name=\"Input\"\n"
"          command=\"SetInputConnection\">\n"
"        <ProxyGroupDomain name=\"groups\">\n"
"          <Group name=\"sources\"/>\n"
"          <Group name=\"filters\"/>\n"
"        </ProxyGroupDomain>\n"
"        <DataTypeDomain name=\"input_type\">\n"
"          <DataType value=\"vtkMultiBlockDataSet\"/>\n"
"          <DataType value=\"vtkTable\"/>\n"
"        </DataTypeDomain>\n"
"        <InputArrayDomain name=\"row_arrays\" attribute_type=\"row\" optional=\"1\" />\n"
"      </InputProperty>\n"
"\n"
"      <StringVectorProperty animateable=\"0\"\n"
"                            command=\"SetFFTArrayName\"\n"
"                            name=\"FFTArrayName\"\n"
"                            label=\"FFT Column\"\n"
"                            number_of_elements=\"1\">\n"
"        <ArrayListDomain attribute_type=\"Scalars\"\n"
"                          name=\"array_list\"\n"
"                          none_string=\"None\"\n"
"                          input_domain_name=\"row_arrays\">\n"
"          <RequiredProperties>\n"
"            <Property function=\"Input\"\n"
"                      name=\"Input\" />\n"
"          </RequiredProperties>\n"
"        </ArrayListDomain>\n"
"        <Documentation>\n"
"          Name of the FFT array from which to compute the mean PSD.\n"
"        </Documentation>\n"
"      </StringVectorProperty>\n"
"\n"
"      <StringVectorProperty animateable=\"0\"\n"
"                            command=\"SetFrequencyArrayName\"\n"
"                            name=\"FrequencyArrayName\"\n"
"                            label=\"Frequency Column\"\n"
"                            number_of_elements=\"1\">\n"
"        <ArrayListDomain attribute_type=\"Scalars\"\n"
"                          name=\"array_list\"\n"
"                          none_string=\"None\"\n"
"                          input_domain_name=\"row_arrays\">\n"
"          <RequiredProperties>\n"
"            <Property function=\"Input\"\n"
"                      name=\"Input\" />\n"
"          </RequiredProperties>\n"
"        </ArrayListDomain>\n"
"        <Documentation>\n"
"          Name of the frequency array to copy.\n"
"        </Documentation>\n"
"      </StringVectorProperty>\n"
"\n"
"      <Hints>\n"
"        <View type=\"XYChartView\" />\n"
"      </Hints>\n"
"\n"
"    </SourceProxy>\n"
"    <!-- ================================================================== -->\n"
"    <SourceProxy class=\"vtkMergeReduceTables\"\n"
"                 label=\"Merge Reduce Tables\"\n"
"                 name=\"MergeReduceTables\">\n"
"      <Documentation short_help=\"Reduce table arrays over points/cells with operations such as mean or sum.\">\n"
"        This filter performs reduction operations such as the mean or the sum\n"
"        over columns across vtkTables. Each table typically corresponds to a\n"
"        point/cell. These tables can be obtained after applying a Temporal\n"
"        Multiplexing or Plot Data Over Time filter.\n"
"\n"
"        Make sure that ghost points are marked as such when using the filter\n"
"        in distributed mode to prevent duplicates. This can be done by applying a\n"
"        Ghost Cells Generator on the geometry prior to transforming it into tables\n"
"        in the previous steps.\n"
"      </Documentation>\n"
"\n"
"      <InputProperty command=\"SetInputConnection\"\n"
"                     name=\"Input\">\n"
"        <ProxyGroupDomain name=\"groups\">\n"
"          <Group name=\"sources\" />\n"
"          <Group name=\"filters\" />\n"
"        </ProxyGroupDomain>\n"
"        <DataTypeDomain name=\"input_type\">\n"
"          <DataType value=\"vtkMultiBlockDataSet\"/>\n"
"          <DataType value=\"vtkTable\"/>\n"
"        </DataTypeDomain>\n"
"        <InputArrayDomain name=\"row_arrays\"\n"
"                          attribute_type=\"row\"\n"
"                          optional=\"1\" />\n"
"        <Documentation>\n"
"          This property specifies the input of the filter.\n"
"        </Documentation>\n"
"      </InputProperty>\n"
"\n"
"      <StringVectorProperty command=\"GetColumnToReduceSelection\"\n"
"                            name=\"ColumnArraysToReduce\"\n"
"                            number_of_elements_per_command=\"1\"\n"
"                            repeat_command=\"1\"\n"
"                            si_class=\"vtkSIDataArraySelectionProperty\">\n"
"          <ArrayListDomain name=\"array_list\" input_domain_name=\"row_arrays\">\n"
"            <RequiredProperties>\n"
"              <Property name=\"Input\" function=\"Input\" />\n"
"            </RequiredProperties>\n"
"          </ArrayListDomain>\n"
"          <Documentation>\n"
"            Select the row data arrays to reduce.\n"
"          </Documentation>\n"
"          <Hints>\n"
"            <ArraySelectionWidget icon_type=\"row\"/>\n"
"          </Hints>\n"
"      </StringVectorProperty>\n"
"\n"
"      <StringVectorProperty command=\"GetColumnToCopySelection\"\n"
"                            name=\"ColumnArraysToCopy\"\n"
"                            number_of_elements_per_command=\"1\"\n"
"                            repeat_command=\"1\"\n"
"                            si_class=\"vtkSIDataArraySelectionProperty\">\n"
"          <ArrayListDomain name=\"array_list\" input_domain_name=\"row_arrays\">\n"
"            <RequiredProperties>\n"
"              <Property name=\"Input\" function=\"Input\" />\n"
"            </RequiredProperties>\n"
"          </ArrayListDomain>\n"
"          <Documentation>\n"
"            Select the row data arrays to copy from input to output.\n"
"            Arrays are copied from the first table.\n"
"          </Documentation>\n"
"          <Hints>\n"
"            <ArraySelectionWidget icon_type=\"row\"/>\n"
"          </Hints>\n"
"      </StringVectorProperty>\n"
"\n"
"      <StringVectorProperty command=\"GetOperationSelection\"\n"
"                            name=\"OperationSelectionInfo\"\n"
"                            number_of_elements_per_command=\"2\"\n"
"                            information_only=\"1\"\n"
"                            si_class=\"vtkSIDataArraySelectionProperty\" />\n"
"\n"
"      <StringVectorProperty command=\"GetOperationSelection\"\n"
"                            name=\"OperationTypes\"\n"
"                            information_property=\"OperationSelectionInfo\"\n"
"                            number_of_elements_per_command=\"2\"\n"
"                            element_types=\"2 0\"\n"
"                            repeat_command=\"1\"\n"
"                            si_class=\"vtkSIDataArraySelectionProperty\">\n"
"        <ArraySelectionDomain name=\"array_list\">\n"
"          <RequiredProperties>\n"
"            <Property function=\"ArrayList\" name=\"OperationSelectionInfo\" />\n"
"          </RequiredProperties>\n"
"        </ArraySelectionDomain>\n"
"        <Documentation>\n"
"          Select the operations to apply for reduction.\n"
"        </Documentation>\n"
"      </StringVectorProperty>\n"
"    </SourceProxy>\n"
"    <!-- ================================================================== -->\n"
"    <SourceProxy class=\"vtkSoundQuantitiesCalculator\"\n"
"                 label=\"Sound Quantities Calculator\"\n"
"                 name=\"SoundQuantitiesCalculator\">\n"
"      <Documentation short_help=\"Compute intensity from sound pressure level.\">\n"
"        Compute the pressure RMS value (Pa and dB) as well as the acoustic power from a sound pressure (Pa) array.\n"
"\n"
"        The output is the destination mesh with the computed sound quantities attached to\n"
"        it i.e. the mean pressure, the RMS pressure and the acoustic power.\n"
"      </Documentation>\n"
"\n"
"      <InputProperty command=\"SetInputConnection\"\n"
"                     name=\"Input\"\n"
"                     label=\"Table Data\" >\n"
"        <ProxyGroupDomain name=\"groups\">\n"
"          <Group name=\"sources\"/>\n"
"          <Group name=\"filters\"/>\n"
"        </ProxyGroupDomain>\n"
"        <DataTypeDomain name=\"input_type\">\n"
"          <DataType value=\"vtkMultiBlockDataSet\"/>\n"
"          <DataType value=\"vtkTable\"/>\n"
"        </DataTypeDomain>\n"
"        <InputArrayDomain name=\"row_arrays1\"\n"
"                          attribute_type=\"row\"\n"
"                          number_of_components=\"1\"\n"
"                          optional=\"1\" />\n"
"        <Documentation>\n"
"          Multiblock dataset or multidimensional table containing the temporal data. Each block/point table corresponds to one point.\n"
"        </Documentation>\n"
"      </InputProperty>\n"
"\n"
"      <InputProperty command=\"SetSourceConnection\"\n"
"                     name=\"Source\"\n"
"                     label=\"Destination Mesh\">\n"
"        <ProxyGroupDomain name=\"groups\">\n"
"          <Group name=\"sources\"/>\n"
"          <Group name=\"filters\"/>\n"
"        </ProxyGroupDomain>\n"
"        <DataTypeDomain name=\"input_type\">\n"
"          <DataType value=\"vtkDataSet\"/>\n"
"        </DataTypeDomain>\n"
"        <Documentation>\n"
"          Mesh on which to display point values.\n"
"        </Documentation>\n"
"      </InputProperty>\n"
"\n"
"      <StringVectorProperty animateable=\"0\"\n"
"                            command=\"SetPressureArrayName\"\n"
"                            name=\"PressureArrayName\"\n"
"                            label=\"Pressure Column\"\n"
"                            number_of_elements=\"1\">\n"
"        <ArrayListDomain attribute_type=\"Scalars\"\n"
"                         name=\"array_list\"\n"
"                         input_domain_name=\"row_arrays1\">\n"
"          <RequiredProperties>\n"
"            <Property function=\"Input\"\n"
"                      name=\"Input\" />\n"
"          </RequiredProperties>\n"
"        </ArrayListDomain>\n"
"        <Documentation>\n"
"          Specify the input array containing the pressure level (in Pa).\n"
"        </Documentation>\n"
"      </StringVectorProperty>\n"
"\n"
"      <DoubleVectorProperty name=\"MediumDensity\"\n"
"                            label=\"Medium Density (kg/m3)\"\n"
"                            command=\"SetMediumDensity\"\n"
"                            number_of_elements=\"1\"\n"
"                            animateable=\"1\"\n"
"                            default_values=\"1.2\">\n"
"         <Documentation>\n"
"           Density of the medium the sound is traveling through.\n"
"         </Documentation>\n"
"      </DoubleVectorProperty>\n"
"\n"
"      <DoubleVectorProperty name=\"MediumSoundVelocity\"\n"
"                            label=\"Sound Velocity (m/s)\"\n"
"                            command=\"SetMediumSoundVelocity\"\n"
"                            number_of_elements=\"1\"\n"
"                            animateable=\"1\"\n"
"                            default_values=\"340\">\n"
"         <Documentation>\n"
"           Velocity of the sound in the medium it is traveling through.\n"
"         </Documentation>\n"
"      </DoubleVectorProperty>\n"
"\n"
"      <IntVectorProperty  name=\"ComputeMeanPressure\"\n"
"                          label=\"Compute Mean Pressure (Pa)\"\n"
"                          command=\"SetComputeMeanPressure\"\n"
"                          number_of_elements=\"1\"\n"
"                          animateable=\"1\"\n"
"                          default_values=\"1\">\n"
"        <BooleanDomain name=\"bool\"/>\n"
"        <Documentation>\n"
"          If enabled, compute the mean pressure through time over the surface.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <IntVectorProperty  name=\"ComputeRMSPressure\"\n"
"                          label=\"Compute RMS Pressure (Pa + dB)\"\n"
"                          command=\"SetComputeRMSPressure\"\n"
"                          number_of_elements=\"1\"\n"
"                          animateable=\"1\"\n"
"                          default_values=\"1\">\n"
"        <BooleanDomain name=\"bool\"/>\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator  type=\"GenericDecorator\"\n"
"                                    mode=\"visibility\"\n"
"                                    property=\"ComputeMeanPressure\"\n"
"                                    value=\"1\" />\n"
"        </Hints>\n"
"        <Documentation>\n"
"           If enabled, compute the root mean squared pressure value through time over the surface.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <IntVectorProperty  name=\"ComputePower\"\n"
"                          label=\"Compute Acoustic Power (dB)\"\n"
"                          command=\"SetComputePower\"\n"
"                          number_of_elements=\"1\"\n"
"                          animateable=\"1\"\n"
"                          default_values=\"1\">\n"
"        <BooleanDomain name=\"bool\"/>\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator  type=\"GenericDecorator\"\n"
"                                    mode=\"visibility\"\n"
"                                    property=\"ComputeRMSPressure\"\n"
"                                    value=\"1\" />\n"
"          <PropertyWidgetDecorator  type=\"GenericDecorator\"\n"
"                                    mode=\"visibility\"\n"
"                                    property=\"ComputeMeanPressure\"\n"
"                                    value=\"1\" />\n"
"        </Hints>\n"
"        <Documentation>\n"
"          If enabled, compute the sound power over time and over the whole surface.\n"
"          This is a single value that will be stored in the field data.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <Hints>\n"
"        <View type=\"RenderView\" port=\"0\" />\n"
"      </Hints>\n"
"\n"
"    </SourceProxy>\n"
"    <!-- ================================================================== -->\n"
"    <SourceProxy class=\"vtkSpectrogramFilter\"\n"
"                 label=\"Spectrogram\"\n"
"                 name=\"Spectrogram\">\n"
"      <Documentation long_help=\"Compute spectrogram from given vtkTable temporal data.\"\n"
"                     short_help=\"Compute spectrogram.\">\n"
"        This filter computes the spectrogram of the input vtkTable column.\n"
"        The output is a vtkImageData where the X and Y axes correspond to time and\n"
"        frequency, respectively.\n"
"        The spectrogram is computed by applying a FFT on temporal windows each containing\n"
"        a subset of the input samples. The window size and type can be controlled with the\n"
"        time resolution and window type properties, respectively.\n"
"      </Documentation>\n"
"\n"
"      <InputProperty name=\"Input\"\n"
;

// From file /build/paraview/src/ParaView-v6.0.1/Plugins/DSP/Filters/DSPFilters.xml
static const char* const DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface1 =
"                     command=\"SetInputConnection\">\n"
"        <ProxyGroupDomain name=\"groups\">\n"
"          <Group name=\"sources\"/>\n"
"          <Group name=\"filters\"/>\n"
"        </ProxyGroupDomain>\n"
"        <DataTypeDomain name=\"input_type\">\n"
"          <DataType value=\"vtkTable\"/>\n"
"        </DataTypeDomain>\n"
"        <InputArrayDomain attribute_type=\"row\"\n"
"                          name=\"input_array\"\n"
"                          number_of_components=\"1\" >\n"
"        </InputArrayDomain>\n"
"      </InputProperty>\n"
"\n"
"      <StringVectorProperty animateable=\"0\"\n"
"                            command=\"SetInputArrayToProcess\"\n"
"                            element_types=\"0 0 0 0 2\"\n"
"                            name=\"SelectInputScalars\"\n"
"                            label=\"Column\"\n"
"                            number_of_elements=\"5\">\n"
"        <ArrayListDomain attribute_type=\"Scalars\"\n"
"                         name=\"array_list\">\n"
"          <RequiredProperties>\n"
"            <Property function=\"Input\"\n"
"                      name=\"Input\" />\n"
"          </RequiredProperties>\n"
"        </ArrayListDomain>\n"
"        <Documentation>\n"
"          Name of the column array from which to compute a spectrogram.\n"
"        </Documentation>\n"
"      </StringVectorProperty>\n"
"\n"
"      <IntVectorProperty command=\"SetWindowType\"\n"
"                         name=\"WindowType\"\n"
"                         label=\"Window Type\"\n"
"                         number_of_elements=\"1\"\n"
"                         default_values=\"0\">\n"
"        <EnumerationDomain name=\"enum\">\n"
"          <Entry text=\"Hanning\" value=\"0\" />\n"
"          <Entry text=\"Bartlett\" value=\"1\" />\n"
"          <Entry text=\"Sine\" value=\"2\" />\n"
"          <Entry text=\"Blackman\" value=\"3\" />\n"
"          <Entry text=\"Rectangular\" value=\"4\" />\n"
"        </EnumerationDomain>\n"
"        <Documentation>\n"
"          Type of windowing function.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <IntVectorProperty command=\"SetTimeResolution\"\n"
"                         name=\"TimeResolution\"\n"
"                         label=\"Time Resolution\"\n"
"                         number_of_elements=\"1\"\n"
"                         default_values=\"100\">\n"
"        <IntRangeDomain name=\"range\" min=\"3\" max=\"1000\"/>\n"
"        <Documentation>\n"
"          Number of samples per temporal window.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <IntVectorProperty command=\"SetOverlapPercentage\"\n"
"                         name=\"OverlapPercentage\"\n"
"                         label=\"Overlap Percentage\"\n"
"                         number_of_elements=\"1\"\n"
"                         default_values=\"50\"\n"
"                         panel_visibility=\"advanced\">\n"
"        <IntRangeDomain name=\"range\" min=\"0\" max=\"100\" />\n"
"        <Documentation>\n"
"            Percentage of samples overlap between consecutive windows.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <DoubleVectorProperty command=\"SetDefaultSampleRate\"\n"
"                            name=\"DefaultSampleRate\"\n"
"                            label=\"Default Sampling Rate\"\n"
"                            number_of_elements=\"1\"\n"
"                            default_values=\"10000\">\n"
"        <DoubleRangeDomain name=\"range\" min=\"0\" max=\"48000\" />\n"
"        <Documentation>\n"
"            Sampling rate of the signal in Hz. Only used if no column called\n"
"            \"Time\" (case insensitive) is available in the input.\n"
"        </Documentation>\n"
"      </DoubleVectorProperty>\n"
"\n"
"    </SourceProxy>\n"
"    <!-- ================================================================== -->\n"
"    <SourceProxy class=\"vtkProjectSpectrumMagnitude\"\n"
"                 name=\"ProjectSpectrumMagnitude\"\n"
"                 label=\"Project Spectrum Magnitude\">\n"
"      <Documentation short_help=\"Project spectrum magnitude on mesh.\">\n"
"        This filter computes the magnitudes of complex data values from a multi block\n"
"        of tables or multidimensional table (input) and\n"
"        places them on the points of a given mesh (source) for\n"
"        a specified frequency range.\n"
"      </Documentation>\n"
"\n"
"      <InputProperty command=\"SetInputConnection\"\n"
"                     name=\"Input\"\n"
"                     label=\"Table Data\" >\n"
"        <ProxyGroupDomain name=\"groups\">\n"
"          <Group name=\"sources\"/>\n"
"          <Group name=\"filters\"/>\n"
"        </ProxyGroupDomain>\n"
"        <DataTypeDomain name=\"input_type\">\n"
"          <DataType value=\"vtkMultiBlockDataSet\"/>\n"
"          <DataType value=\"vtkTable\"/>\n"
"        </DataTypeDomain>\n"
"        <InputArrayDomain name=\"row_arrays1\"\n"
"                          attribute_type=\"row\"\n"
"                          number_of_components=\"1\"\n"
"                          optional=\"1\" />\n"
"        <InputArrayDomain name=\"row_arrays\"\n"
"                          attribute_type=\"row\"\n"
"                          optional=\"1\" />\n"
"        <Documentation>\n"
"          Multiblock dataset or multidimensional table containing the temporal data. Each block/table corresponds to one point.\n"
"        </Documentation>\n"
"      </InputProperty>\n"
"\n"
"      <InputProperty command=\"SetSourceConnection\"\n"
"                     name=\"Source\"\n"
"                     label=\"Destination Mesh\">\n"
"        <ProxyGroupDomain name=\"groups\">\n"
"          <Group name=\"sources\"/>\n"
"          <Group name=\"filters\"/>\n"
"        </ProxyGroupDomain>\n"
"        <DataTypeDomain name=\"input_type\">\n"
"          <DataType value=\"vtkDataSet\"/>\n"
"        </DataTypeDomain>\n"
"        <Documentation>\n"
"          Mesh on which to display point values.\n"
"        </Documentation>\n"
"      </InputProperty>\n"
"\n"
"      <StringVectorProperty command=\"GetColumnSelection\"\n"
"                            name=\"ColumnSelection\"\n"
"                            label=\"Columns To Project\"\n"
"                            number_of_elements_per_command=\"1\"\n"
"                            repeat_command=\"1\"\n"
"                            si_class=\"vtkSIDataArraySelectionProperty\">\n"
"          <ArrayListDomain name=\"array_list\" input_domain_name=\"row_arrays\">\n"
"            <RequiredProperties>\n"
"              <Property name=\"Input\" function=\"Input\" />\n"
"            </RequiredProperties>\n"
"          </ArrayListDomain>\n"
"          <Documentation>\n"
"            Select the column data arrays to project on the mesh.\n"
"          </Documentation>\n"
"          <Hints>\n"
"            <ArraySelectionWidget icon_type=\"row\"/>\n"
"          </Hints>\n"
"      </StringVectorProperty>\n"
"\n"
"      <StringVectorProperty command=\"SetInputArrayToProcess\"\n"
"                            element_types=\"0 0 0 0 2\"\n"
"                            name=\"FrequencyArray\"\n"
"                            number_of_elements=\"5\">\n"
"        <ArrayListDomain attribute_type=\"Scalars\"\n"
"                         name=\"array_list\"\n"
"                         input_domain_name=\"row_arrays1\">\n"
"          <RequiredProperties>\n"
"            <Property function=\"Input\"\n"
"                      name=\"Input\" />\n"
"          </RequiredProperties>\n"
"        </ArrayListDomain>\n"
"        <Documentation>\n"
"          Name of the frequency array.\n"
"        </Documentation>\n"
"      </StringVectorProperty>\n"
"\n"
"      <IntVectorProperty command=\"SetFreqFromOctave\"\n"
"                         default_values=\"0\"\n"
"                         name=\"UseOctave\"\n"
"                         number_of_elements=\"1\">\n"
"        <BooleanDomain name=\"bool\" />\n"
"        <Documentation>\n"
"          Whether to compute frequencies from octave bands or not.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <IntVectorProperty command=\"SetBaseTwoOctave\"\n"
"                         default_values=\"1\"\n"
"                         name=\"BaseTwoOctave\"\n"
"                         number_of_elements=\"1\"\n"
"                         panel_visibility=\"advanced\">\n"
"        <BooleanDomain name=\"bool\" />\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator type=\"ShowWidgetDecorator\">\n"
"            <Property name=\"UseOctave\"\n"
"                      function=\"boolean\" />\n"
"          </PropertyWidgetDecorator>\n"
"        </Hints>\n"
"        <Documentation>\n"
"          Whether to compute frequencies using base-two or base-ten power.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <IntVectorProperty command=\"SetOctave\"\n"
"                         default_values=\"9\"\n"
"                         name=\"Octave\"\n"
"                         number_of_elements=\"1\">\n"
"        <EnumerationDomain name=\"enum\">\n"
"          <Entry value=\"5\" text=\"31.5 Hz\"/>\n"
"          <Entry value=\"6\" text=\"63 Hz\"/>\n"
"          <Entry value=\"7\" text=\"125 Hz\"/>\n"
"          <Entry value=\"8\" text=\"250 Hz\"/>\n"
"          <Entry value=\"9\" text=\"500 Hz\"/>\n"
"          <Entry value=\"10\" text=\"1 kHz\"/>\n"
"          <Entry value=\"11\" text=\"2 kHz\"/>\n"
"          <Entry value=\"12\" text=\"4 kHz\"/>\n"
"          <Entry value=\"13\" text=\"8 kHz\"/>\n"
"          <Entry value=\"14\" text=\"16 kHz\"/>\n"
"        </EnumerationDomain>\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator type=\"ShowWidgetDecorator\">\n"
"            <Property name=\"UseOctave\"\n"
"                      function=\"boolean\" />\n"
"          </PropertyWidgetDecorator>\n"
"        </Hints>\n"
"        <Documentation>\n"
"          Octave used to compute frequencies, referred to by its nominal band frequency.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <IntVectorProperty command=\"SetOctaveSubdivision\"\n"
"                         default_values=\"0\"\n"
"                         name=\"OctaveSubdivision\"\n"
"                         number_of_elements=\"1\">\n"
"        <EnumerationDomain name=\"enum\">\n"
"          <Entry value=\"0\" text=\"Full\"/>\n"
"          <Entry value=\"1\" text=\"First Half\"/>\n"
"          <Entry value=\"2\" text=\"Second Half\"/>\n"
"          <Entry value=\"3\" text=\"First Third\"/>\n"
"          <Entry value=\"4\" text=\"Second Third\"/>\n"
"          <Entry value=\"5\" text=\"Third Third\"/>\n"
"        </EnumerationDomain>\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator type=\"ShowWidgetDecorator\">\n"
"            <Property name=\"UseOctave\"\n"
"                      function=\"boolean\" />\n"
"          </PropertyWidgetDecorator>\n"
"        </Hints>\n"
"        <Documentation>\n"
"          Which subdivision of octave used to compute octave frequency range.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <DoubleVectorProperty command=\"GetComputedLowerFrequency\"\n"
"                            name=\"ComputedLowerFrequency\"\n"
"                            information_only=\"1\"\n"
"                            panel_visibility=\"default\">\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator type=\"ShowWidgetDecorator\">\n"
"            <Property name=\"UseOctave\"\n"
"                      function=\"boolean\" />\n"
"          </PropertyWidgetDecorator>\n"
"        </Hints>\n"
"        <Documentation>\n"
"          Lower bound of the frequency range.\n"
"        </Documentation>\n"
"      </DoubleVectorProperty>\n"
"\n"
"      <DoubleVectorProperty command=\"GetComputedUpperFrequency\"\n"
"                            name=\"ComputedUpperFrequency\"\n"
"                            information_only=\"1\"\n"
"                            panel_visibility=\"default\">\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator type=\"ShowWidgetDecorator\">\n"
"            <Property name=\"UseOctave\"\n"
"                      function=\"boolean\" />\n"
"          </PropertyWidgetDecorator>\n"
"        </Hints>\n"
"        <Documentation>\n"
"          Upper bound of the frequency range.\n"
"        </Documentation>\n"
"      </DoubleVectorProperty>\n"
"\n"
"      <DoubleVectorProperty command=\"SetLowerFrequency\"\n"
"                            name=\"LowerFrequency\"\n"
"                            default_values=\"0\"\n"
"                            number_of_elements=\"1\">\n"
"        <ArrayRangeDomain name=\"range\"\n"
"                          default_mode=\"min\">\n"
"          <RequiredProperties>\n"
"            <Property function=\"Input\"\n"
"                      name=\"Input\" />\n"
"            <Property function=\"ArraySelection\"\n"
"                      name=\"FrequencyArray\" />\n"
"          </RequiredProperties>\n"
"        </ArrayRangeDomain>\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator type=\"ShowWidgetDecorator\">\n"
"            <Property name=\"UseOctave\"\n"
"                      function=\"boolean_invert\" />\n"
"          </PropertyWidgetDecorator>\n"
"        </Hints>\n"
"        <Documentation>\n"
"          Lower bound of the frequency range.\n"
"        </Documentation>\n"
"      </DoubleVectorProperty>\n"
"\n"
"      <DoubleVectorProperty command=\"SetUpperFrequency\"\n"
"                            name=\"UpperFrequency\"\n"
"                            default_values=\"0\"\n"
"                            number_of_elements=\"1\">\n"
"        <ArrayRangeDomain name=\"range\"\n"
"                          default_mode=\"max\">\n"
"          <RequiredProperties>\n"
"            <Property function=\"Input\"\n"
"                      name=\"Input\" />\n"
"            <Property function=\"ArraySelection\"\n"
"                      name=\"FrequencyArray\" />\n"
"          </RequiredProperties>\n"
"        </ArrayRangeDomain>\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator type=\"ShowWidgetDecorator\">\n"
"            <Property name=\"UseOctave\"\n"
"                      function=\"boolean_invert\" />\n"
"          </PropertyWidgetDecorator>\n"
"        </Hints>\n"
"        <Documentation>\n"
"          Upper bound of the frequency range.\n"
"        </Documentation>\n"
"      </DoubleVectorProperty>\n"
"\n"
"      <Hints>\n"
"        <View type=\"RenderView\" port=\"0\" />\n"
"      </Hints>\n"
"\n"
"    </SourceProxy>\n"
"    <!-- ================================================================== -->\n"
"    <SourceProxy class=\"vtkBandFiltering\"\n"
"                 label=\"Band filtering\"\n"
"                 name=\"BandFiltering\">\n"
"      <Documentation short_help=\"Compute amplitude per band of a table.\">\n"
"        This filter computes the magnitudes of complex data values from a multi block\n"
"        of tables (input) per frequency band. The user can specify their band manually. Bands\n"
"        are created using either temporal informations or the frequency related ones.\n"
"        By default it processes temporal signals but deactivating the \"Apply FFT\" option\n"
"        allows to process directly the result of a given FFT.\n"
"      </Documentation>\n"
"      <InputProperty command=\"SetInputConnection\"\n"
"                     name=\"Input\">\n"
"        <ProxyGroupDomain name=\"groups\">\n"
"          <Group name=\"sources\" />\n"
"          <Group name=\"filters\" />\n"
"        </ProxyGroupDomain>\n"
"        <DataTypeDomain name=\"input_type\" composite_data_supported=\"1\">\n"
"          <DataType value=\"vtkTable\" />\n"
"        </DataTypeDomain>\n"
"        <InputArrayDomain attribute_type=\"row\"\n"
"                          name=\"input_array\"/>\n"
"      </InputProperty>\n"
"\n"
"      <IntVectorProperty command=\"SetBandFilteringMode\"\n"
;

// From file /build/paraview/src/ParaView-v6.0.1/Plugins/DSP/Filters/DSPFilters.xml
static const char* const DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface2 =
"                         default_values=\"0\"\n"
"                         name=\"BandFilteringMode\"\n"
"                         number_of_elements=\"1\">\n"
"        <EnumerationDomain name=\"enum\">\n"
"          <Entry text=\"Octave\" value=\"0\" />\n"
"          <Entry text=\"Third-octave\" value=\"1\" />\n"
"          <Entry text=\"Custom\" value=\"2\" />\n"
"        </EnumerationDomain>\n"
"        <Documentation>\n"
"          Specify if the filter should use octave, third or custom octave band.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <IntVectorProperty command=\"SetOctaveSubdivision\"\n"
"                         default_values=\"1\"\n"
"                         name=\"OctaveSubdivision\"\n"
"                         number_of_elements=\"1\">\n"
"        <IntRangeDomain name=\"range\" min=\"1\" max=\"9\" resolution=\"2\"/>\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator  type=\"GenericDecorator\"\n"
"                                    mode=\"visibility\"\n"
"                                    property=\"BandFilteringMode\"\n"
"                                    value=\"2\" />\n"
"        </Hints>\n"
"        <Documentation>\n"
"          Set the number of octave subdivision when\n"
"          BandFilteringMode is \"Custom\" . Only odd numbers are valid.\n"
"          When using even numbers, the number just below will be used.\n"
"          1 is equivalent to using the \"Octave\" mode, and 3 the \"Third-octave\"\n"
"          mode.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <DoubleVectorProperty command=\"SetDefaultSamplingRate\"\n"
"                         default_values=\"10000\"\n"
"                         name=\"DefaultSamplingRate\"\n"
"                         panel_visibility=\"advanced\"\n"
"                         number_of_elements=\"1\" >\n"
"        <Documentation>\n"
"          Specify the frequency sample rate in Hz.\n"
"          If ApplyFFT is true: this will be used if the filter cannot find a time column\n"
"          If ApplyFFT is false: this will be used if the filter cannot find a frequency column.\n"
"        </Documentation>\n"
"      </DoubleVectorProperty>\n"
"\n"
"       <IntVectorProperty command=\"SetApplyFFT\"\n"
"                         default_values=\"1\"\n"
"                         name=\"ApplyFFT\"\n"
"                         panel_visibility=\"advanced\"\n"
"                         number_of_elements=\"1\">\n"
"        <BooleanDomain name=\"bool\"/>\n"
"      </IntVectorProperty>\n"
"\n"
"       <IntVectorProperty command=\"SetWindowType\"\n"
"                         name=\"WindowType\"\n"
"                         panel_visibility=\"advanced\"\n"
"                         number_of_elements=\"1\"\n"
"                         default_values=\"0\">\n"
"        <EnumerationDomain name=\"enum\">\n"
"          <Entry text=\"Hanning\" value=\"0\" />\n"
"          <Entry text=\"Bartlett\" value=\"1\" />\n"
"          <Entry text=\"Sine\" value=\"2\" />\n"
"          <Entry text=\"Blackman\" value=\"3\" />\n"
"          <Entry text=\"Rectangular\" value=\"4\" />\n"
"        </EnumerationDomain>\n"
"        <Documentation>\n"
"          Type of windowing function when applying the fft when the input is temporal.\n"
"        </Documentation>\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator  type=\"GenericDecorator\"\n"
"                                    mode=\"visibility\"\n"
"                                    property=\"ApplyFFT\"\n"
"                                    value=\"1\" />\n"
"        </Hints>\n"
"        <Documentation>\n"
"          Used only when ApplyFFT is true, meaning that input is temporal.\n"
"          Set the windowing function to use before applying the FFT.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"    </SourceProxy>\n"
"    <!-- ================================================================== -->\n"
"    <SourceProxy class=\"vtkTemporalMultiplexing\"\n"
"                 label=\"Temporal Multiplexing\"\n"
"                 name=\"TemporalMultiplexing\">\n"
"      <Documentation short_help=\"Create table with 3D arrays from temporal data.\">\n"
"        This filter creates a vtkTable containing 3D arrays based on a temporal input.\n"
"        Each point/cell array of the input is converted to a 3D array defined by\n"
"        (index, tuple, component), corresponding to (point/cell, timestep, component).\n"
"        The arrays are vtkMultiDimensionalArray objects.\n"
"      </Documentation>\n"
"\n"
"      <InputProperty name=\"Input\"\n"
"                     command=\"SetInputConnection\">\n"
"        <ProxyGroupDomain name=\"groups\">\n"
"          <Group name=\"sources\"/>\n"
"          <Group name=\"filters\"/>\n"
"        </ProxyGroupDomain>\n"
"        <DataTypeDomain name=\"input_type\">\n"
"          <DataType value=\"vtkDataSet\"/>\n"
"        </DataTypeDomain>\n"
"      </InputProperty>\n"
"\n"
"      <IntVectorProperty name=\"GenerateTimeColumn\"\n"
"                         command=\"SetGenerateTimeColumn\"\n"
"                         default_values=\"1\"\n"
"                         number_of_elements=\"1\">\n"
"        <BooleanDomain name=\"bool\"/>\n"
"        <Documentation>\n"
"          Generate a time column, as a data array containing time steps values.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <IntVectorProperty name=\"FieldAssociation\"\n"
"                         command=\"SetFieldAssociation\"\n"
"                         default_values=\"0\"\n"
"                         number_of_elements=\"1\">\n"
"        <FieldDataDomain enable_field_data=\"0\"\n"
"                         name=\"enum\">\n"
"          <RequiredProperties>\n"
"            <Property function=\"Input\" name=\"Input\" />\n"
"          </RequiredProperties>\n"
"        </FieldDataDomain>\n"
"        <Documentation>\n"
"          Select the attribute data to filter.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <StringVectorProperty name=\"SelectArrays\"\n"
"                            label=\"Data Arrays\"\n"
"                            command=\"EnableAttributeArray\"\n"
"                            clean_command=\"ClearAttributeArrays\"\n"
"                            number_of_elements_per_command=\"1\"\n"
"                            repeat_command=\"1\">\n"
"        <ArrayListDomain name=\"array_list\">\n"
"          <RequiredProperties>\n"
"            <Property function=\"Input\"\n"
"                      name=\"Input\" />\n"
"            <Property function=\"FieldDataSelection\"\n"
"                      name=\"FieldAssociation\" />\n"
"          </RequiredProperties>\n"
"        </ArrayListDomain>\n"
"        <Documentation>\n"
"          Arrays to be transformed into multidimensional arrays.\n"
"        </Documentation>\n"
"      </StringVectorProperty>\n"
"\n"
"      <Hints>\n"
"        <View type=\"SpreadSheetView\" port=\"0\" />\n"
"      </Hints>\n"
"    </SourceProxy>\n"
"    <!-- ================================================================== -->\n"
"    <SourceProxy class=\"vtkMultiDimensionBrowser\"\n"
"                 label=\"Multi Dimension Browser\"\n"
"                 name=\"MultiDimensionBrowser\">\n"
"      <Documentation long_help=\"Select index (dimension) for multidimensionnal array.\"\n"
"        short_help=\"Browse multidimensionnal array dimension\">\n"
"        Select a dimension to use for all multidimensionnal arrays.\n"
"        This shallow copies the arrays to avoid side effects on upstream pipeline.\n"
"      </Documentation>\n"
"\n"
"      <InputProperty name=\"Input\"\n"
"                     command=\"SetInputConnection\">\n"
"        <ProxyGroupDomain name=\"groups\">\n"
"          <Group name=\"sources\"/>\n"
"          <Group name=\"filters\"/>\n"
"        </ProxyGroupDomain>\n"
"        <DataTypeDomain name=\"input_type\">\n"
"          <DataType value=\"vtkTable\"/>\n"
"        </DataTypeDomain>\n"
"        <InputArrayDomain attribute_type=\"row\"\n"
"                          name=\"input_array\" >\n"
"        </InputArrayDomain>\n"
"      </InputProperty>\n"
"\n"
"      <IntVectorProperty command=\"GetIndexRange\"\n"
"                         name=\"IndexRangeInfo\"\n"
"                         information_only=\"1\"\n"
"                         number_of_elements=\"2\"\n"
"                         panel_visibility=\"never\"\n"
"                         default_values=\"0 1\">\n"
"        <Documentation>\n"
"          Range to use for Index property.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <IntVectorProperty command=\"SetIndex\"\n"
"                         name=\"Index\"\n"
"                         label=\"Index\"\n"
"                         number_of_elements=\"1\"\n"
"                         default_values=\"0\">\n"
"        <IntRangeDomain default_mode=\"min\" min=\"0\" max=\"1\" name=\"range\">\n"
"          <RequiredProperties>\n"
"            <Property name=\"IndexRangeInfo\" function=\"RangeInfo\" />\n"
"          </RequiredProperties>\n"
"        </IntRangeDomain>\n"
"        <Documentation>\n"
"          Index to use for hidden dimension of multidimensionnal array.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <IntVectorProperty  name=\"UseGlobalIds\"\n"
"                          label=\"Use Global Ids\"\n"
"                          command=\"SetUseGlobalIds\"\n"
"                          number_of_elements=\"1\"\n"
"                          animateable=\"0\"\n"
"                          default_values=\"0\">\n"
"        <BooleanDomain name=\"bool\"/>\n"
"        <Documentation>\n"
"          If enabled, use global ids array to get Index.\n"
"        </Documentation>\n"
"      </IntVectorProperty>\n"
"\n"
"      <StringVectorProperty animateable=\"0\"\n"
"                            command=\"SetInputArrayToProcess\"\n"
"                            element_types=\"0 0 0 0 2\"\n"
"                            name=\"GlobalIds\"\n"
"                            label=\"Global Ids\"\n"
"                            number_of_elements=\"5\">\n"
"        <ArrayListDomain attribute_type=\"Scalars\"\n"
"                         name=\"array_list\">\n"
"          <RequiredProperties>\n"
"            <Property function=\"Input\"\n"
"                      name=\"Input\" />\n"
"          </RequiredProperties>\n"
"        </ArrayListDomain>\n"
"        <Hints>\n"
"          <PropertyWidgetDecorator  type=\"GenericDecorator\"\n"
"                                    mode=\"visibility\"\n"
"                                    property=\"UseGlobalIds\"\n"
"                                    value=\"1\" />\n"
"        </Hints>\n"
"        <Documentation>\n"
"          Name of the global ids array.\n"
"        </Documentation>\n"
"      </StringVectorProperty>\n"
"\n"
"    </SourceProxy>\n"
"    <!-- ================================================================== -->\n"
"    <SourceProxy class=\"vtkDSPTableFFT\"\n"
"                 label=\"DSP Table FFT\"\n"
"                 name=\"DSPTableFFT\"\n"
"                 base_proxygroup=\"filters\"\n"
"                 base_proxyname=\"TableFFT\">\n"
"      <Documentation short_help=\"Run an FFT on output from Temporal Multiplexing.\">\n"
"        This filter replaces the Table FFT filter when outputting data from the\n"
"        Temporal Multiplexing filter. It will iterate over the hidden spatial\n"
"        dimension and output mutliplexed FFT data.\n"
"      </Documentation>\n"
"    </SourceProxy>\n"
"\n"
"  </ProxyGroup>\n"
"\n"
"  <ParaViewFilters>\n"
"    <Category name=\"Digital Signal Processing\" menu_label=\"DSP\" show_in_toolbar=\"0\">\n"
"      <Proxy group=\"filters\" name=\"SoundQuantitiesCalculator\" />\n"
"      <Proxy group=\"filters\" name=\"MeanPowerSpectralDensity\" />\n"
"      <Proxy group=\"filters\" name=\"MergeReduceTables\" />\n"
"      <Proxy group=\"filters\" name=\"Spectrogram\" />\n"
"      <Proxy group=\"filters\" name=\"ProjectSpectrumMagnitude\" />\n"
"      <Proxy group=\"filters\" name=\"TableFFT\" />\n"
"      <Proxy group=\"filters\" name=\"EqualizerFilter\"/>\n"
"      <Proxy group=\"filters\" name=\"BandFiltering\"/>\n"
"      <Proxy group=\"filters\" name=\"TemporalMultiplexing\" />\n"
"      <Proxy group=\"filters\" name=\"MultiDimensionBrowser\" />\n"
"      <Proxy group=\"filters\" name=\"DSPTableFFT\" />\n"
"    </Category>\n"
"  </ParaViewFilters>\n"
"</ServerManagerConfiguration>\n"
"\n";
// Get single string
inline char* DigitalSignalProcessing_server_manager_modulesDSPFiltersGetInterfaces()
{

  const size_t len0 = strlen(DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface0);
  const size_t len1 = strlen(DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface1);
  const size_t len2 = strlen(DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface2);
  size_t len = ( 0
    + len0
    + len1
    + len2 );
  char* res = new char[ len + 1];
  size_t offset = 0;
  std::copy(DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface0, DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface0 + len0, res + offset); offset += len0;
  std::copy(DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface1, DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface1 + len1, res + offset); offset += len1;
  std::copy(DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface2, DigitalSignalProcessing_server_manager_modulesDSPFiltersInterface2 + len2, res + offset); offset += len2;
  assert(offset == len);
  res[offset] = 0;
  return res;
}



#endif
