/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.13.1
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtGui/qcursor.sip"
#include <qcursor.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQCursor.cpp"

#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtGui/qbitmap.sip"
#include <qbitmap.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQCursor.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtGui/qpixmap.sip"
#include <qpixmap.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQCursor.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qvariant.sip"
#include <qvariant.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQCursor.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQCursor.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtGui/qscreen.sip"
#include <qscreen.h>
#line 45 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQCursor.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 154 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtCore/qtextstream.sip"
#include <qtextstream.h>
#line 50 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQCursor.cpp"


PyDoc_STRVAR(doc_QCursor_shape, "shape(self) -> Qt.CursorShape");

extern "C" {static PyObject *meth_QCursor_shape(PyObject *, PyObject *);}
static PyObject *meth_QCursor_shape(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCursor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCursor, &sipCpp))
        {
            ::Qt::CursorShape sipRes;

            sipRes = sipCpp->shape();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_Qt_CursorShape);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCursor, sipName_shape, doc_QCursor_shape);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCursor_setShape, "setShape(self, newShape: Qt.CursorShape)");

extern "C" {static PyObject *meth_QCursor_setShape(PyObject *, PyObject *);}
static PyObject *meth_QCursor_setShape(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::Qt::CursorShape a0;
        ::QCursor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QCursor, &sipCpp, sipType_Qt_CursorShape, &a0))
        {
            sipCpp->setShape(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QCursor, sipName_setShape, doc_QCursor_setShape);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCursor_bitmap, "bitmap(self) -> QBitmap");

extern "C" {static PyObject *meth_QCursor_bitmap(PyObject *, PyObject *);}
static PyObject *meth_QCursor_bitmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCursor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCursor, &sipCpp))
        {
            ::QBitmap*sipRes;

            sipRes = new ::QBitmap(sipCpp->bitmap());

            return sipConvertFromNewType(sipRes, sipType_QBitmap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCursor, sipName_bitmap, doc_QCursor_bitmap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCursor_mask, "mask(self) -> QBitmap");

extern "C" {static PyObject *meth_QCursor_mask(PyObject *, PyObject *);}
static PyObject *meth_QCursor_mask(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCursor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCursor, &sipCpp))
        {
            ::QBitmap*sipRes;

            sipRes = new ::QBitmap(sipCpp->mask());

            return sipConvertFromNewType(sipRes, sipType_QBitmap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCursor, sipName_mask, doc_QCursor_mask);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCursor_pixmap, "pixmap(self) -> QPixmap");

extern "C" {static PyObject *meth_QCursor_pixmap(PyObject *, PyObject *);}
static PyObject *meth_QCursor_pixmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCursor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCursor, &sipCpp))
        {
            ::QPixmap*sipRes;

            sipRes = new ::QPixmap(sipCpp->pixmap());

            return sipConvertFromNewType(sipRes, sipType_QPixmap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCursor, sipName_pixmap, doc_QCursor_pixmap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCursor_hotSpot, "hotSpot(self) -> QPoint");

extern "C" {static PyObject *meth_QCursor_hotSpot(PyObject *, PyObject *);}
static PyObject *meth_QCursor_hotSpot(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCursor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCursor, &sipCpp))
        {
            ::QPoint*sipRes;

            sipRes = new ::QPoint(sipCpp->hotSpot());

            return sipConvertFromNewType(sipRes, sipType_QPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCursor, sipName_hotSpot, doc_QCursor_hotSpot);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCursor_pos, "pos() -> QPoint\n"
"pos(screen: Optional[QScreen]) -> QPoint");

extern "C" {static PyObject *meth_QCursor_pos(PyObject *, PyObject *);}
static PyObject *meth_QCursor_pos(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, "C", &sipSelf))
        {
            ::QPoint*sipRes;

            sipRes = new ::QPoint(::QCursor::pos());

            return sipConvertFromNewType(sipRes, sipType_QPoint, SIP_NULLPTR);
        }
    }

    {
        const ::QScreen* a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ8", &sipSelf, sipType_QScreen, &a0))
        {
            ::QPoint*sipRes;

            sipRes = new ::QPoint(::QCursor::pos(a0));

            return sipConvertFromNewType(sipRes, sipType_QPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCursor, sipName_pos, doc_QCursor_pos);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCursor_setPos, "setPos(x: int, y: int)\n"
"setPos(p: QPoint)\n"
"setPos(screen: Optional[QScreen], x: int, y: int)\n"
"setPos(screen: Optional[QScreen], p: QPoint)");

extern "C" {static PyObject *meth_QCursor_setPos(PyObject *, PyObject *);}
static PyObject *meth_QCursor_setPos(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "Cii", &sipSelf, &a0, &a1))
        {
            ::QCursor::setPos(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::QPoint* a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ9", &sipSelf, sipType_QPoint, &a0))
        {
            ::QCursor::setPos(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QScreen* a0;
        int a1;
        int a2;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ8ii", &sipSelf, sipType_QScreen, &a0, &a1, &a2))
        {
            ::QCursor::setPos(a0, a1, a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QScreen* a0;
        const ::QPoint* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ8J9", &sipSelf, sipType_QScreen, &a0, sipType_QPoint, &a1))
        {
            ::QCursor::setPos(a0, *a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QCursor, sipName_setPos, doc_QCursor_setPos);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCursor_swap, "swap(self, other: Union[QCursor, Qt.CursorShape])");

extern "C" {static PyObject *meth_QCursor_swap(PyObject *, PyObject *);}
static PyObject *meth_QCursor_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QCursor* a0;
        int a0State = 0;
        ::QCursor *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QCursor, &sipCpp, sipType_QCursor, &a0, &a0State))
        {
            sipCpp->swap(*a0);
            sipReleaseType(a0, sipType_QCursor, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QCursor, sipName_swap, doc_QCursor_swap);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QCursor___ne__(PyObject *, PyObject *);}
static PyObject *slot_QCursor___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QCursor *sipCpp = reinterpret_cast< ::QCursor *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QCursor));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCursor* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QCursor, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QCursor *>(a0), sipType_QCursor, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, ne_slot, sipType_QCursor, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QCursor___eq__(PyObject *, PyObject *);}
static PyObject *slot_QCursor___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QCursor *sipCpp = reinterpret_cast< ::QCursor *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QCursor));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCursor* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QCursor, &a0, &a0State))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);
            sipReleaseType(const_cast< ::QCursor *>(a0), sipType_QCursor, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, eq_slot, sipType_QCursor, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QCursor(void *, int);}
static void release_QCursor(void *sipCppV, int)
{
    delete reinterpret_cast< ::QCursor *>(sipCppV);
}


extern "C" {static void *array_QCursor(Py_ssize_t);}
static void *array_QCursor(Py_ssize_t sipNrElem)
{
    return new ::QCursor[sipNrElem];
}


extern "C" {static void array_delete_QCursor(void *);}
static void array_delete_QCursor(void *sipCpp)
{
    delete[] reinterpret_cast< ::QCursor *>(sipCpp);
}


extern "C" {static void assign_QCursor(void *, Py_ssize_t, void *);}
static void assign_QCursor(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QCursor *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QCursor *>(sipSrc);
}


extern "C" {static void *copy_QCursor(const void *, Py_ssize_t);}
static void *copy_QCursor(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QCursor(reinterpret_cast<const ::QCursor *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QCursor(sipSimpleWrapper *);}
static void dealloc_QCursor(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QCursor(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QCursor(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QCursor(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QCursor *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QCursor();

            return sipCpp;
        }
    }

    {
        const ::QBitmap* a0;
        const ::QBitmap* a1;
        int a2 = -1;
        int a3 = -1;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_hotX,
            sipName_hotY,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9J9|ii", sipType_QBitmap, &a0, sipType_QBitmap, &a1, &a2, &a3))
        {
            sipCpp = new ::QCursor(*a0, *a1, a2, a3);

            return sipCpp;
        }
    }

    {
        const ::QPixmap* a0;
        int a1 = -1;
        int a2 = -1;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_hotX,
            sipName_hotY,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9|ii", sipType_QPixmap, &a0, &a1, &a2))
        {
            sipCpp = new ::QCursor(*a0, a1, a2);

            return sipCpp;
        }
    }

    {
        const ::QCursor* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QCursor, &a0, &a0State))
        {
            sipCpp = new ::QCursor(*a0);
            sipReleaseType(const_cast< ::QCursor *>(a0), sipType_QCursor, a0State);

            return sipCpp;
        }
    }

    {
        const ::QVariant* a0;
        PyObject *a0Wrapper;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "@J1", &a0Wrapper, sipType_QVariant, &a0, &a0State))
        {
            sipErrorState sipError = sipErrorNone;

#line 65 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtGui/qcursor.sip"
        if (a0->canConvert<QCursor>())
            sipCpp = new QCursor(a0->value<QCursor>());
        else
            sipError = sipBadCallableArg(0, a0Wrapper);
#line 532 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQCursor.cpp"
            sipReleaseType(const_cast< ::QVariant *>(a0), sipType_QVariant, a0State);

            if (sipError == sipErrorNone)
                return sipCpp;

            if (sipUnused)
            {
                Py_XDECREF(*sipUnused);
            }

            sipAddException(sipError, sipParseErr);

            if (sipError == sipErrorFail)
                return SIP_NULLPTR;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_QCursor(PyObject *, void **, int *, PyObject *, void **);}
static int convertTo_QCursor(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj, void **)
{
    ::QCursor **sipCppPtr = reinterpret_cast< ::QCursor **>(sipCppPtrV);

#line 30 "/build/pyqt6/src/pyqt6-6.10.0/sip/QtGui/qcursor.sip"
// SIP doesn't support automatic type convertors so we explicitly allow a
// Qt::CursorShape to be used whenever a QCursor is expected.

bool is_cursor_shape = true;
int cursor_shape = sipConvertToEnum(sipPy, sipType_Qt_CursorShape);

if (PyErr_Occurred())
{
    PyErr_Clear();
    is_cursor_shape = false;
}

if (sipIsErr == NULL)
    return (is_cursor_shape ||
            sipCanConvertToType(sipPy, sipType_QCursor, SIP_NO_CONVERTORS));

if (is_cursor_shape)
{
    *sipCppPtr = new QCursor(static_cast<Qt::CursorShape>(cursor_shape));

    return sipGetState(sipTransferObj);
}

*sipCppPtr = reinterpret_cast<QCursor *>(sipConvertToType(sipPy, sipType_QCursor, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

return 0;
#line 586 "/build/pyqt6/src/pyqt6-6.10.0/build/QtGui/sipQtGuiQCursor.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QCursor[] = {
    {(void *)slot_QCursor___ne__, ne_slot},
    {(void *)slot_QCursor___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QCursor[] = {
    {sipName_bitmap, meth_QCursor_bitmap, METH_VARARGS, doc_QCursor_bitmap},
    {sipName_hotSpot, meth_QCursor_hotSpot, METH_VARARGS, doc_QCursor_hotSpot},
    {sipName_mask, meth_QCursor_mask, METH_VARARGS, doc_QCursor_mask},
    {sipName_pixmap, meth_QCursor_pixmap, METH_VARARGS, doc_QCursor_pixmap},
    {sipName_pos, meth_QCursor_pos, METH_VARARGS, doc_QCursor_pos},
    {sipName_setPos, meth_QCursor_setPos, METH_VARARGS, doc_QCursor_setPos},
    {sipName_setShape, meth_QCursor_setShape, METH_VARARGS, doc_QCursor_setShape},
    {sipName_shape, meth_QCursor_shape, METH_VARARGS, doc_QCursor_shape},
    {sipName_swap, meth_QCursor_swap, METH_VARARGS, doc_QCursor_swap}
};

PyDoc_STRVAR(doc_QCursor, "\1QCursor()\n"
"QCursor(bitmap: QBitmap, mask: QBitmap, hotX: int = -1, hotY: int = -1)\n"
"QCursor(pixmap: QPixmap, hotX: int = -1, hotY: int = -1)\n"
"QCursor(cursor: Union[QCursor, Qt.CursorShape])\n"
"QCursor(variant: Any)");


sipClassTypeDef sipTypeDef_QtGui_QCursor = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QCursor,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QCursor,
        {0, 0, 1},
        9, methods_QCursor,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QCursor,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QCursor,
    init_type_QCursor,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QCursor,
    assign_QCursor,
    array_QCursor,
    copy_QCursor,
    release_QCursor,
    SIP_NULLPTR,
    convertTo_QCursor,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QCursor,
    sizeof (::QCursor),
};
