/*
 * Module code.
 *
 * Generated by SIP 6.14.0
 */

#include "sipAPI_core.h"

#line 24 "auto_generated/proj/qgscelestialbody.sip"
#include "qgscelestialbody.h"
#line 12 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 16 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


PyDoc_STRVAR(doc_QgsCelestialBody_isValid, "isValid(self) -> bool\n"
"Returns ``True`` if the body is a valid object, or ``False`` if it is a\n"
"null/invalid object.");

extern "C" {static PyObject *meth_QgsCelestialBody_isValid(PyObject *, PyObject *);}
static PyObject *meth_QgsCelestialBody_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsCelestialBody *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsCelestialBody, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->isValid();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsCelestialBody, sipName_isValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsCelestialBody_name, "name(self) -> str\n"
"Name of celestial body.");

extern "C" {static PyObject *meth_QgsCelestialBody_name(PyObject *, PyObject *);}
static PyObject *meth_QgsCelestialBody_name(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsCelestialBody *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsCelestialBody, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->name());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsCelestialBody, sipName_name, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsCelestialBody_authority, "authority(self) -> str\n"
"Authority name, e.g. EPSG.");

extern "C" {static PyObject *meth_QgsCelestialBody_authority(PyObject *, PyObject *);}
static PyObject *meth_QgsCelestialBody_authority(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsCelestialBody *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsCelestialBody, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->authority());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsCelestialBody, sipName_authority, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QgsCelestialBody___repr__(PyObject *);}
static PyObject *slot_QgsCelestialBody___repr__(PyObject *sipSelf)
{
    ::QgsCelestialBody *sipCpp = reinterpret_cast< ::QgsCelestialBody *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsCelestialBody));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 46 "auto_generated/proj/qgscelestialbody.sip"
    QString str;
    if ( !sipCpp->isValid() )
    {
      str = QStringLiteral( "<QgsCelestialBody: invalid>" );
    }
    else
    {
      QString id;
      if ( !sipCpp->authority().isEmpty() )
        id = QStringLiteral( "%1 (%2)" ).arg( sipCpp->name(), sipCpp->authority() );
      else
        id = sipCpp->name();
      str = QStringLiteral( "<QgsCelestialBody: %1>" ).arg( id );
    }
    sipRes = PyUnicode_FromString( str.toUtf8().constData() );
#line 190 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsCelestialBody(void *, int);}
static void release_QgsCelestialBody(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsCelestialBody *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsCelestialBody(Py_ssize_t);}
static void *array_QgsCelestialBody(Py_ssize_t sipNrElem)
{
    return new ::QgsCelestialBody[sipNrElem];
}


extern "C" {static void array_delete_QgsCelestialBody(void *);}
static void array_delete_QgsCelestialBody(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsCelestialBody *>(sipCpp);
}


extern "C" {static void assign_QgsCelestialBody(void *, Py_ssize_t, void *);}
static void assign_QgsCelestialBody(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsCelestialBody *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsCelestialBody *>(sipSrc);
}


extern "C" {static void *copy_QgsCelestialBody(const void *, Py_ssize_t);}
static void *copy_QgsCelestialBody(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsCelestialBody(reinterpret_cast<const ::QgsCelestialBody *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsCelestialBody(sipSimpleWrapper *);}
static void dealloc_QgsCelestialBody(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsCelestialBody(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsCelestialBody(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsCelestialBody(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsCelestialBody *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsCelestialBody();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsCelestialBody* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsCelestialBody, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsCelestialBody(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QgsCelestialBody[] = {
    {(void *)slot_QgsCelestialBody___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QgsCelestialBody[] = {
    {sipName_authority, meth_QgsCelestialBody_authority, METH_VARARGS, doc_QgsCelestialBody_authority},
    {sipName_isValid, meth_QgsCelestialBody_isValid, METH_VARARGS, doc_QgsCelestialBody_isValid},
    {sipName_name, meth_QgsCelestialBody_name, METH_VARARGS, doc_QgsCelestialBody_name}
};

PyDoc_STRVAR(doc_QgsCelestialBody, "Contains information about a celestial body.\n"
"\n"
".. note::\n"
"\n"
"   Only used in builds based on on PROJ 8.1 or later\n"
"\n"
".. versionadded:: 3.20\n"
"\n"
"");


static pyqt5ClassPluginDef plugin_QgsCelestialBody = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsCelestialBody = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsCelestialBody,
        SIP_NULLPTR,
        &plugin_QgsCelestialBody,
    },
    {
        sipNameNr_QgsCelestialBody,
        {0, 0, 1},
        3, methods_QgsCelestialBody,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsCelestialBody,
    -1,
    -1,
    SIP_NULLPTR,
    slots_QgsCelestialBody,
    init_type_QgsCelestialBody,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsCelestialBody,
    assign_QgsCelestialBody,
    array_QgsCelestialBody,
    copy_QgsCelestialBody,
    release_QgsCelestialBody,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsCelestialBody,
    sizeof (::QgsCelestialBody),
};

#line 39 "auto_generated/pointcloud/qgspointcloudstatistics.sip"
#include "qgspointcloudstatistics.h"
#line 397 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 30 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 401 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 404 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 646 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 407 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qvector.sip"
#include <qvector.h>
#line 410 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 23 "auto_generated/pointcloud/qgspointcloudattribute.sip"
#include "qgspointcloudattribute.h"
#line 413 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


PyDoc_STRVAR(doc_QgsPointCloudStatistics_sampledPointsCount, "sampledPointsCount(self) -> int\n"
"Returns the number of points used to calculate the statistics");

extern "C" {static PyObject *meth_QgsPointCloudStatistics_sampledPointsCount(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudStatistics_sampledPointsCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudStatistics *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudStatistics, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sampledPointsCount();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudStatistics, sipName_sampledPointsCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudStatistics_clear, "clear(self)\n"
"Clears the statistics of all attributes\n"
"\n"
"clear(self, attributes: Iterable[QgsPointCloudAttribute])\n"
"Clears the statistics of given attributes ``attributes``");

extern "C" {static PyObject *meth_QgsPointCloudStatistics_clear(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudStatistics_clear(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudStatistics *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QgsPointCloudStatistics, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->clear();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const QVector< ::QgsPointCloudAttribute>* a0;
        int a0State = 0;
        ::QgsPointCloudStatistics *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attributes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudStatistics, &sipCpp, sipType_QVector_0100QgsPointCloudAttribute, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->clear(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast<QVector< ::QgsPointCloudAttribute> *>(a0), sipType_QVector_0100QgsPointCloudAttribute, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QVector< ::QgsPointCloudAttribute> *>(a0), sipType_QVector_0100QgsPointCloudAttribute, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudStatistics, sipName_clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudStatistics_statisticsOf, "statisticsOf(self, attribute: Optional[str]) -> QgsPointCloudAttributeStatistics\n"
"Returns the calculated statistics of attribute ``attribute``");

extern "C" {static PyObject *meth_QgsPointCloudStatistics_statisticsOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudStatistics_statisticsOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QgsPointCloudStatistics *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attribute,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudStatistics, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QgsPointCloudAttributeStatistics*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudAttributeStatistics(sipCpp->statisticsOf(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudAttributeStatistics, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudStatistics, sipName_statisticsOf, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudStatistics_classesOf, "classesOf(self, attribute: Optional[str]) -> list[int]\n"
"Returns a list of existing classes which are present for the specified\n"
"``attribute``");

extern "C" {static PyObject *meth_QgsPointCloudStatistics_classesOf(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudStatistics_classesOf(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QgsPointCloudStatistics *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attribute,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudStatistics, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QList<int>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QList<int>(sipCpp->classesOf(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QList_1800, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudStatistics, sipName_classesOf, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudStatistics_minimum, "minimum(self, attribute: Optional[str]) -> float\n"
"Returns the minimum value for the attribute ``attribute`` If no matching\n"
"statistic is available then NaN will be returned.");

extern "C" {static PyObject *meth_QgsPointCloudStatistics_minimum(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudStatistics_minimum(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QgsPointCloudStatistics *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attribute,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudStatistics, &sipCpp, sipType_QString, &a0, &a0State))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->minimum(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudStatistics, sipName_minimum, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudStatistics_maximum, "maximum(self, attribute: Optional[str]) -> float\n"
"Returns the maximum value for the attribute ``attribute`` If no matching\n"
"statistic is available then NaN will be returned.");

extern "C" {static PyObject *meth_QgsPointCloudStatistics_maximum(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudStatistics_maximum(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QgsPointCloudStatistics *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attribute,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudStatistics, &sipCpp, sipType_QString, &a0, &a0State))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->maximum(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudStatistics, sipName_maximum, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudStatistics_mean, "mean(self, attribute: Optional[str]) -> float\n"
"Returns the mean value for the attribute ``attribute`` If no matching\n"
"statistic is available then NaN will be returned.");

extern "C" {static PyObject *meth_QgsPointCloudStatistics_mean(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudStatistics_mean(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QgsPointCloudStatistics *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attribute,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudStatistics, &sipCpp, sipType_QString, &a0, &a0State))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->mean(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudStatistics, sipName_mean, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudStatistics_stDev, "stDev(self, attribute: Optional[str]) -> float\n"
"Returns the standard deviation value for the attribute ``attribute`` If\n"
"no matching statistic is available then NaN will be returned.");

extern "C" {static PyObject *meth_QgsPointCloudStatistics_stDev(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudStatistics_stDev(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QgsPointCloudStatistics *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attribute,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudStatistics, &sipCpp, sipType_QString, &a0, &a0State))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->stDev(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudStatistics, sipName_stDev, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudStatistics_combineWith, "combineWith(self, stats: QgsPointCloudStatistics)\n"
"Merges the current statistics with the statistics from ``stats``");

extern "C" {static PyObject *meth_QgsPointCloudStatistics_combineWith(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudStatistics_combineWith(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudStatistics* a0;
        ::QgsPointCloudStatistics *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stats,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudStatistics, &sipCpp, sipType_QgsPointCloudStatistics, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->combineWith(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudStatistics, sipName_combineWith, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudStatistics_toStatisticsJson, "toStatisticsJson(self) -> QByteArray\n"
"Converts the current statistics object into JSON object");

extern "C" {static PyObject *meth_QgsPointCloudStatistics_toStatisticsJson(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudStatistics_toStatisticsJson(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudStatistics *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudStatistics, &sipCpp))
        {
            ::QByteArray*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QByteArray(sipCpp->toStatisticsJson());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudStatistics, sipName_toStatisticsJson, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudStatistics_fromStatisticsJson, "fromStatisticsJson(stats: Union[QByteArray, bytes, bytearray]) -> QgsPointCloudStatistics\n"
"Creates a statistics object from the JSON object ``stats``");

extern "C" {static PyObject *meth_QgsPointCloudStatistics_fromStatisticsJson(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudStatistics_fromStatisticsJson(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        static const char *sipKwdList[] = {
            sipName_stats,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_QByteArray, &a0, &a0State))
        {
            ::QgsPointCloudStatistics*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudStatistics(::QgsPointCloudStatistics::fromStatisticsJson(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudStatistics, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudStatistics, sipName_fromStatisticsJson, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudStatistics(void *, int);}
static void release_QgsPointCloudStatistics(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsPointCloudStatistics *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsPointCloudStatistics(Py_ssize_t);}
static void *array_QgsPointCloudStatistics(Py_ssize_t sipNrElem)
{
    return new ::QgsPointCloudStatistics[sipNrElem];
}


extern "C" {static void array_delete_QgsPointCloudStatistics(void *);}
static void array_delete_QgsPointCloudStatistics(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsPointCloudStatistics *>(sipCpp);
}


extern "C" {static void assign_QgsPointCloudStatistics(void *, Py_ssize_t, void *);}
static void assign_QgsPointCloudStatistics(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsPointCloudStatistics *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsPointCloudStatistics *>(sipSrc);
}


extern "C" {static void *copy_QgsPointCloudStatistics(const void *, Py_ssize_t);}
static void *copy_QgsPointCloudStatistics(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsPointCloudStatistics(reinterpret_cast<const ::QgsPointCloudStatistics *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsPointCloudStatistics(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudStatistics(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudStatistics(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsPointCloudStatistics(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudStatistics(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsPointCloudStatistics *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudStatistics();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsPointCloudStatistics* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsPointCloudStatistics, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudStatistics(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsPointCloudStatistics[] = {
    {sipName_classesOf, SIP_MLMETH_CAST(meth_QgsPointCloudStatistics_classesOf), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudStatistics_classesOf},
    {sipName_clear, SIP_MLMETH_CAST(meth_QgsPointCloudStatistics_clear), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudStatistics_clear},
    {sipName_combineWith, SIP_MLMETH_CAST(meth_QgsPointCloudStatistics_combineWith), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudStatistics_combineWith},
    {sipName_fromStatisticsJson, SIP_MLMETH_CAST(meth_QgsPointCloudStatistics_fromStatisticsJson), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudStatistics_fromStatisticsJson},
    {sipName_maximum, SIP_MLMETH_CAST(meth_QgsPointCloudStatistics_maximum), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudStatistics_maximum},
    {sipName_mean, SIP_MLMETH_CAST(meth_QgsPointCloudStatistics_mean), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudStatistics_mean},
    {sipName_minimum, SIP_MLMETH_CAST(meth_QgsPointCloudStatistics_minimum), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudStatistics_minimum},
    {sipName_sampledPointsCount, meth_QgsPointCloudStatistics_sampledPointsCount, METH_VARARGS, doc_QgsPointCloudStatistics_sampledPointsCount},
    {sipName_stDev, SIP_MLMETH_CAST(meth_QgsPointCloudStatistics_stDev), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudStatistics_stDev},
    {sipName_statisticsOf, SIP_MLMETH_CAST(meth_QgsPointCloudStatistics_statisticsOf), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudStatistics_statisticsOf},
    {sipName_toStatisticsJson, meth_QgsPointCloudStatistics_toStatisticsJson, METH_VARARGS, doc_QgsPointCloudStatistics_toStatisticsJson}
};

PyDoc_STRVAR(doc_QgsPointCloudStatistics, "Used to store statistics of a point cloud dataset.\n"
"\n"
".. versionadded:: 3.26\n"
"\n"
"");


static pyqt5ClassPluginDef plugin_QgsPointCloudStatistics = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudStatistics = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudStatistics,
        SIP_NULLPTR,
        &plugin_QgsPointCloudStatistics,
    },
    {
        sipNameNr_QgsPointCloudStatistics,
        {0, 0, 1},
        11, methods_QgsPointCloudStatistics,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudStatistics,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsPointCloudStatistics,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudStatistics,
    assign_QgsPointCloudStatistics,
    array_QgsPointCloudStatistics,
    copy_QgsPointCloudStatistics,
    release_QgsPointCloudStatistics,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsPointCloudStatistics,
    sizeof (::QgsPointCloudStatistics),
};




PyDoc_STRVAR(doc_QgsPointCloudAttributeStatistics_singleClassCount, "singleClassCount(self, cls: int) -> int\n"
"Returns the count of points in given class or -1 on error\n"
"\n"
".. versionadded:: 3.42");

extern "C" {static PyObject *meth_QgsPointCloudAttributeStatistics_singleClassCount(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudAttributeStatistics_singleClassCount(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QgsPointCloudAttributeStatistics *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cls,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_QgsPointCloudAttributeStatistics, &sipCpp, &a0))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->singleClassCount(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudAttributeStatistics, sipName_singleClassCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudAttributeStatistics(void *, int);}
static void release_QgsPointCloudAttributeStatistics(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsPointCloudAttributeStatistics(Py_ssize_t);}
static void *array_QgsPointCloudAttributeStatistics(Py_ssize_t sipNrElem)
{
    return new ::QgsPointCloudAttributeStatistics[sipNrElem];
}


extern "C" {static void array_delete_QgsPointCloudAttributeStatistics(void *);}
static void array_delete_QgsPointCloudAttributeStatistics(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipCpp);
}


extern "C" {static void assign_QgsPointCloudAttributeStatistics(void *, Py_ssize_t, void *);}
static void assign_QgsPointCloudAttributeStatistics(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipSrc);
}


extern "C" {static void *copy_QgsPointCloudAttributeStatistics(const void *, Py_ssize_t);}
static void *copy_QgsPointCloudAttributeStatistics(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsPointCloudAttributeStatistics(reinterpret_cast<const ::QgsPointCloudAttributeStatistics *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsPointCloudAttributeStatistics(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudAttributeStatistics(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudAttributeStatistics(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsPointCloudAttributeStatistics(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudAttributeStatistics(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsPointCloudAttributeStatistics *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudAttributeStatistics();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsPointCloudAttributeStatistics* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsPointCloudAttributeStatistics, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudAttributeStatistics(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsPointCloudAttributeStatistics[] = {
    {sipName_singleClassCount, SIP_MLMETH_CAST(meth_QgsPointCloudAttributeStatistics_singleClassCount), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudAttributeStatistics_singleClassCount}
};


extern "C" {static PyObject *varget_QgsPointCloudAttributeStatistics_count(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsPointCloudAttributeStatistics_count(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
    ::QgsPointCloudAttributeStatistics *sipCpp = reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipSelf);

    sipVal = sipCpp->count;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_QgsPointCloudAttributeStatistics_count(void *, PyObject *, PyObject *);}
static int varset_QgsPointCloudAttributeStatistics_count(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::QgsPointCloudAttributeStatistics *sipCpp = reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->count = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsPointCloudAttributeStatistics_maximum(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsPointCloudAttributeStatistics_maximum(void *sipSelf, PyObject *, PyObject *)
{
    double sipVal;
    ::QgsPointCloudAttributeStatistics *sipCpp = reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipSelf);

    sipVal = sipCpp->maximum;

    return PyFloat_FromDouble(sipVal);
}


extern "C" {static int varset_QgsPointCloudAttributeStatistics_maximum(void *, PyObject *, PyObject *);}
static int varset_QgsPointCloudAttributeStatistics_maximum(void *sipSelf, PyObject *sipPy, PyObject *)
{
    double sipVal;
    ::QgsPointCloudAttributeStatistics *sipCpp = reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipSelf);

    sipVal = PyFloat_AsDouble(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->maximum = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsPointCloudAttributeStatistics_mean(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsPointCloudAttributeStatistics_mean(void *sipSelf, PyObject *, PyObject *)
{
    double sipVal;
    ::QgsPointCloudAttributeStatistics *sipCpp = reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipSelf);

    sipVal = sipCpp->mean;

    return PyFloat_FromDouble(sipVal);
}


extern "C" {static int varset_QgsPointCloudAttributeStatistics_mean(void *, PyObject *, PyObject *);}
static int varset_QgsPointCloudAttributeStatistics_mean(void *sipSelf, PyObject *sipPy, PyObject *)
{
    double sipVal;
    ::QgsPointCloudAttributeStatistics *sipCpp = reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipSelf);

    sipVal = PyFloat_AsDouble(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->mean = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsPointCloudAttributeStatistics_minimum(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsPointCloudAttributeStatistics_minimum(void *sipSelf, PyObject *, PyObject *)
{
    double sipVal;
    ::QgsPointCloudAttributeStatistics *sipCpp = reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipSelf);

    sipVal = sipCpp->minimum;

    return PyFloat_FromDouble(sipVal);
}


extern "C" {static int varset_QgsPointCloudAttributeStatistics_minimum(void *, PyObject *, PyObject *);}
static int varset_QgsPointCloudAttributeStatistics_minimum(void *sipSelf, PyObject *sipPy, PyObject *)
{
    double sipVal;
    ::QgsPointCloudAttributeStatistics *sipCpp = reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipSelf);

    sipVal = PyFloat_AsDouble(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->minimum = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QgsPointCloudAttributeStatistics_stDev(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsPointCloudAttributeStatistics_stDev(void *sipSelf, PyObject *, PyObject *)
{
    double sipVal;
    ::QgsPointCloudAttributeStatistics *sipCpp = reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipSelf);

    sipVal = sipCpp->stDev;

    return PyFloat_FromDouble(sipVal);
}


extern "C" {static int varset_QgsPointCloudAttributeStatistics_stDev(void *, PyObject *, PyObject *);}
static int varset_QgsPointCloudAttributeStatistics_stDev(void *sipSelf, PyObject *sipPy, PyObject *)
{
    double sipVal;
    ::QgsPointCloudAttributeStatistics *sipCpp = reinterpret_cast< ::QgsPointCloudAttributeStatistics *>(sipSelf);

    sipVal = PyFloat_AsDouble(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->stDev = sipVal;

    return 0;
}

sipVariableDef variables_QgsPointCloudAttributeStatistics[] = {
    {InstanceVariable, sipName_count, (PyMethodDef *)varget_QgsPointCloudAttributeStatistics_count, (PyMethodDef *)varset_QgsPointCloudAttributeStatistics_count, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_maximum, (PyMethodDef *)varget_QgsPointCloudAttributeStatistics_maximum, (PyMethodDef *)varset_QgsPointCloudAttributeStatistics_maximum, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_mean, (PyMethodDef *)varget_QgsPointCloudAttributeStatistics_mean, (PyMethodDef *)varset_QgsPointCloudAttributeStatistics_mean, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_minimum, (PyMethodDef *)varget_QgsPointCloudAttributeStatistics_minimum, (PyMethodDef *)varset_QgsPointCloudAttributeStatistics_minimum, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_stDev, (PyMethodDef *)varget_QgsPointCloudAttributeStatistics_stDev, (PyMethodDef *)varset_QgsPointCloudAttributeStatistics_stDev, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_QgsPointCloudAttributeStatistics, "\1QgsPointCloudAttributeStatistics()\n"
"QgsPointCloudAttributeStatistics(a0: QgsPointCloudAttributeStatistics)");


static pyqt5ClassPluginDef plugin_QgsPointCloudAttributeStatistics = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudAttributeStatistics = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudAttributeStatistics,
        SIP_NULLPTR,
        &plugin_QgsPointCloudAttributeStatistics,
    },
    {
        sipNameNr_QgsPointCloudAttributeStatistics,
        {0, 0, 1},
        1, methods_QgsPointCloudAttributeStatistics,
        0, SIP_NULLPTR,
        5, variables_QgsPointCloudAttributeStatistics,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudAttributeStatistics,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsPointCloudAttributeStatistics,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudAttributeStatistics,
    assign_QgsPointCloudAttributeStatistics,
    array_QgsPointCloudAttributeStatistics,
    copy_QgsPointCloudAttributeStatistics,
    release_QgsPointCloudAttributeStatistics,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsPointCloudAttributeStatistics,
    sizeof (::QgsPointCloudAttributeStatistics),
};

#line 253 "auto_generated/pointcloud/qgspointcloudlayerexporter.sip"
#include "qgspointcloudlayerexporter.h"
#line 1622 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 24 "auto_generated/pointcloud/qgspointcloudlayerexporter.sip"
#include "qgspointcloudlayerexporter.h"
#line 1626 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 149 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 1629 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "auto_generated/qgsmaplayer.sip"
#include "qgsmaplayer.h"
#line 1632 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 35 "auto_generated/qgstaskmanager.sip"
#include "qgstaskmanager.h"
#line 1635 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 149 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 1638 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 1641 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 35 "auto_generated/qgstaskmanager.sip"
#include "qgstaskmanager.h"
#line 1644 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 146 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 1649 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 1652 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 1655 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 252 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 1658 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 240 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 1661 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
#include <qobject.h>
#line 1664 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qvariant.sip"
#include <qvariant.h>
#line 1667 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 38 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 1670 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 30 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 1673 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 149 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 1676 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 1679 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qthread.sip"
#include <qthread.h>
#line 1682 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 1685 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qregexp.sip"
#include <qregexp.h>
#line 1688 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qregularexpression.sip"
#include <qregularexpression.h>
#line 1691 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 1694 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


class sipQgsPointCloudLayerExporterTask : public ::QgsPointCloudLayerExporterTask
{
public:
    sipQgsPointCloudLayerExporterTask(::QgsPointCloudLayerExporter*);
    virtual ~sipQgsPointCloudLayerExporterTask();

    int qt_metacall(QMetaObject::Call, int, void **) SIP_OVERRIDE;
    void *qt_metacast(const char *) SIP_OVERRIDE;
    const QMetaObject *metaObject() const SIP_OVERRIDE;

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    ::QObject* sipProtect_sender() const;
    int sipProtect_receivers(const char*) const;
    void sipProtectVirt_timerEvent(bool, ::QTimerEvent*);
    void sipProtectVirt_childEvent(bool, ::QChildEvent*);
    void sipProtectVirt_customEvent(bool, ::QEvent*);
    void sipProtectVirt_connectNotify(bool, const ::QMetaMethod&);
    void sipProtectVirt_disconnectNotify(bool, const ::QMetaMethod&);
    int sipProtect_senderSignalIndex() const;
    bool sipProtect_isSignalConnected(const ::QMetaMethod&) const;
    bool sipProtect_isCanceled() const;
    void sipProtect_setProgress(double);
    bool sipProtectVirt_run(bool);
    void sipProtectVirt_finished(bool, bool);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void disconnectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void connectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void customEvent(::QEvent*) SIP_OVERRIDE;
    void childEvent(::QChildEvent*) SIP_OVERRIDE;
    void timerEvent(::QTimerEvent*) SIP_OVERRIDE;
    bool eventFilter(::QObject*, ::QEvent*) SIP_OVERRIDE;
    bool event(::QEvent*) SIP_OVERRIDE;
    void cancel() SIP_OVERRIDE;
    bool run() SIP_OVERRIDE;
    void finished(bool) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQgsPointCloudLayerExporterTask(const sipQgsPointCloudLayerExporterTask &);
    sipQgsPointCloudLayerExporterTask &operator = (const sipQgsPointCloudLayerExporterTask &);

    char sipPyMethods[10];
};

sipQgsPointCloudLayerExporterTask::sipQgsPointCloudLayerExporterTask(::QgsPointCloudLayerExporter*a0): ::QgsPointCloudLayerExporterTask(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsPointCloudLayerExporterTask::~sipQgsPointCloudLayerExporterTask()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

const QMetaObject *sipQgsPointCloudLayerExporterTask::metaObject() const
{
    if (sipGetInterpreter())
        return QObject::d_ptr->metaObject ? QObject::d_ptr->dynamicMetaObject() : sip__core_qt_metaobject(sipPySelf, sipType_QgsPointCloudLayerExporterTask);

    return ::QgsPointCloudLayerExporterTask::metaObject();
}

int sipQgsPointCloudLayerExporterTask::qt_metacall(QMetaObject::Call _c, int _id, void **_a)
{
    _id = ::QgsPointCloudLayerExporterTask::qt_metacall(_c, _id, _a);

    if (_id >= 0)
    {
        SIP_BLOCK_THREADS
        _id = sip__core_qt_metacall(sipPySelf, sipType_QgsPointCloudLayerExporterTask, _c, _id, _a);
        SIP_UNBLOCK_THREADS
    }

    return _id;
}

void *sipQgsPointCloudLayerExporterTask::qt_metacast(const char *_clname)
{
    void *sipCpp;

    return (sip__core_qt_metacast(sipPySelf, sipType_QgsPointCloudLayerExporterTask, _clname, &sipCpp) ? sipCpp : ::QgsPointCloudLayerExporterTask::qt_metacast(_clname));
}

void sipQgsPointCloudLayerExporterTask::disconnectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_disconnectNotify);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerExporterTask::disconnectNotify(a0);
        return;
    }

    extern void sipVH__core_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH__core_3(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayerExporterTask::connectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_connectNotify);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerExporterTask::connectNotify(a0);
        return;
    }

    extern void sipVH__core_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH__core_3(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayerExporterTask::customEvent(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_customEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerExporterTask::customEvent(a0);
        return;
    }

    extern void sipVH__core_4(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    sipVH__core_4(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayerExporterTask::childEvent(::QChildEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_childEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerExporterTask::childEvent(a0);
        return;
    }

    extern void sipVH__core_5(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QChildEvent*);

    sipVH__core_5(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayerExporterTask::timerEvent(::QTimerEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_timerEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerExporterTask::timerEvent(a0);
        return;
    }

    extern void sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QTimerEvent*);

    sipVH__core_6(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQgsPointCloudLayerExporterTask::eventFilter(::QObject*a0, ::QEvent*a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, SIP_NULLPTR, sipName_eventFilter);

    if (!sipMeth)
        return ::QgsPointCloudLayerExporterTask::eventFilter(a0, a1);

    extern bool sipVH__core_7(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QObject*, ::QEvent*);

    return sipVH__core_7(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudLayerExporterTask::event(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_event);

    if (!sipMeth)
        return ::QgsPointCloudLayerExporterTask::event(a0);

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    return sipVH__core_8(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayerExporterTask::cancel()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_cancel);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerExporterTask::cancel();
        return;
    }

    extern void sipVH__core_426(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_426(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudLayerExporterTask::run()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[8], &sipPySelf, SIP_NULLPTR, sipName_run);

    if (!sipMeth)
        return ::QgsPointCloudLayerExporterTask::run();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudLayerExporterTask::finished(bool a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[9], &sipPySelf, SIP_NULLPTR, sipName_finished);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerExporterTask::finished(a0);
        return;
    }

    extern void sipVH__core_81(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool);

    sipVH__core_81(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QObject* sipQgsPointCloudLayerExporterTask::sipProtect_sender() const
{
    return ::QObject::sender();
}

int sipQgsPointCloudLayerExporterTask::sipProtect_receivers(const char*a0) const
{
    return ::QObject::receivers(a0);
}

void sipQgsPointCloudLayerExporterTask::sipProtectVirt_timerEvent(bool sipSelfWasArg, ::QTimerEvent*a0)
{
    (sipSelfWasArg ? ::QObject::timerEvent(a0) : timerEvent(a0));
}

void sipQgsPointCloudLayerExporterTask::sipProtectVirt_childEvent(bool sipSelfWasArg, ::QChildEvent*a0)
{
    (sipSelfWasArg ? ::QObject::childEvent(a0) : childEvent(a0));
}

void sipQgsPointCloudLayerExporterTask::sipProtectVirt_customEvent(bool sipSelfWasArg, ::QEvent*a0)
{
    (sipSelfWasArg ? ::QObject::customEvent(a0) : customEvent(a0));
}

void sipQgsPointCloudLayerExporterTask::sipProtectVirt_connectNotify(bool sipSelfWasArg, const ::QMetaMethod& a0)
{
    (sipSelfWasArg ? ::QObject::connectNotify(a0) : connectNotify(a0));
}

void sipQgsPointCloudLayerExporterTask::sipProtectVirt_disconnectNotify(bool sipSelfWasArg, const ::QMetaMethod& a0)
{
    (sipSelfWasArg ? ::QObject::disconnectNotify(a0) : disconnectNotify(a0));
}

int sipQgsPointCloudLayerExporterTask::sipProtect_senderSignalIndex() const
{
    return ::QObject::senderSignalIndex();
}

bool sipQgsPointCloudLayerExporterTask::sipProtect_isSignalConnected(const ::QMetaMethod& a0) const
{
    return ::QObject::isSignalConnected(a0);
}

bool sipQgsPointCloudLayerExporterTask::sipProtect_isCanceled() const
{
    return ::QgsTask::isCanceled();
}

void sipQgsPointCloudLayerExporterTask::sipProtect_setProgress(double a0)
{
    ::QgsTask::setProgress(a0);
}

bool sipQgsPointCloudLayerExporterTask::sipProtectVirt_run(bool sipSelfWasArg)
{
    return (sipSelfWasArg ? ::QgsPointCloudLayerExporterTask::run() : run());
}

void sipQgsPointCloudLayerExporterTask::sipProtectVirt_finished(bool sipSelfWasArg, bool a0)
{
    (sipSelfWasArg ? ::QgsPointCloudLayerExporterTask::finished(a0) : finished(a0));
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_sender, "sender(self) -> Optional[QObject]");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_sender(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_sender(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const sipQgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp))
        {
            ::QObject*sipRes = 0;

#line 570 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
        // sender() must be called without the GIL to avoid possible deadlocks between
        // the GIL and Qt's internal thread data mutex.
        
        Py_BEGIN_ALLOW_THREADS
        
        #if defined(SIP_PROTECTED_IS_PUBLIC)
        sipRes = sipCpp->sender();
        #else
        sipRes = sipCpp->sipProtect_sender();
        #endif
        
        Py_END_ALLOW_THREADS
        
        if (!sipRes)
        {
            typedef QObject *(*qtcore_qobject_sender_t)();
        
            static qtcore_qobject_sender_t qtcore_qobject_sender = 0;
        
            if (!qtcore_qobject_sender)
            {
                qtcore_qobject_sender = (qtcore_qobject_sender_t)sipImportSymbol("qtcore_qobject_sender");
                Q_ASSERT(qtcore_qobject_sender);
            }
        
            sipRes = qtcore_qobject_sender();
        }
#line 2069 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            return sipConvertFromType(sipRes, sipType_QObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_sender, doc_QgsPointCloudLayerExporterTask_sender);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_receivers, "receivers(self, signal: PYQT_SIGNAL) -> int");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_receivers(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_receivers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * a0;
        const sipQgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BP0", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp, &a0))
        {
            int sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 601 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
        // We need to handle the signal object.  Import the helper if it hasn't already
        // been done.
        typedef sipErrorState (*pyqt5_get_signal_signature_t)(PyObject *, const QObject *, const QByteArray &);
        
        static pyqt5_get_signal_signature_t pyqt5_get_signal_signature = 0;
        
        if (!pyqt5_get_signal_signature)
        {
            pyqt5_get_signal_signature = (pyqt5_get_signal_signature_t)sipImportSymbol("pyqt5_get_signal_signature");
            Q_ASSERT(pyqt5_get_signal_signature);
        }
        
        QByteArray signal_signature;
            
        #if defined(SIP_PROTECTED_IS_PUBLIC)
        if ((sipError = pyqt5_get_signal_signature(a0, sipCpp, signal_signature)) == sipErrorNone)
        {
            sipRes = sipCpp->receivers(signal_signature.constData());
        }
        #else
        if ((sipError = pyqt5_get_signal_signature(a0, static_cast<const QObject *>(sipCpp), signal_signature)) == sipErrorNone)
        {
            sipRes = sipCpp->sipProtect_receivers(signal_signature.constData());
        }
        #endif
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(0, a0);
        }
#line 2127 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyLong_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_receivers, doc_QgsPointCloudLayerExporterTask_receivers);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_timerEvent, "timerEvent(self, a0: Optional[QTimerEvent])");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_timerEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_timerEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QTimerEvent* a0;
        sipQgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp, sipType_QTimerEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_timerEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_timerEvent, doc_QgsPointCloudLayerExporterTask_timerEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_childEvent, "childEvent(self, a0: Optional[QChildEvent])");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_childEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_childEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QChildEvent* a0;
        sipQgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp, sipType_QChildEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_childEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_childEvent, doc_QgsPointCloudLayerExporterTask_childEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_customEvent, "customEvent(self, a0: Optional[QEvent])");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_customEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_customEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QEvent* a0;
        sipQgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp, sipType_QEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_customEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_customEvent, doc_QgsPointCloudLayerExporterTask_customEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_connectNotify, "connectNotify(self, signal: QMetaMethod)");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_connectNotify(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_connectNotify(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QMetaMethod* a0;
        sipQgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp, sipType_QMetaMethod, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_connectNotify(sipSelfWasArg, *a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_connectNotify, doc_QgsPointCloudLayerExporterTask_connectNotify);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_disconnectNotify, "disconnectNotify(self, signal: QMetaMethod)");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_disconnectNotify(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_disconnectNotify(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QMetaMethod* a0;
        sipQgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp, sipType_QMetaMethod, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_disconnectNotify(sipSelfWasArg, *a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_disconnectNotify, doc_QgsPointCloudLayerExporterTask_disconnectNotify);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_senderSignalIndex, "senderSignalIndex(self) -> int");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_senderSignalIndex(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_senderSignalIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const sipQgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sipProtect_senderSignalIndex();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_senderSignalIndex, doc_QgsPointCloudLayerExporterTask_senderSignalIndex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_isSignalConnected, "isSignalConnected(self, signal: QMetaMethod) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_isSignalConnected(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_isSignalConnected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaMethod* a0;
        const sipQgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp, sipType_QMetaMethod, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sipProtect_isSignalConnected(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_isSignalConnected, doc_QgsPointCloudLayerExporterTask_isSignalConnected);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_isCanceled, "isCanceled(self) -> bool\n"
"Will return ``True`` if task should terminate ASAP. If the task reports\n"
"the CanCancel flag, then derived classes' :py:func:`~QgsTask.run`\n"
"methods should periodically check this and terminate in a safe manner.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_isCanceled(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_isCanceled(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const sipQgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sipProtect_isCanceled();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_isCanceled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_setProgress, "setProgress(self, progress: float)\n"
"Sets the task's current progress. The derived class should call this\n"
"method whenever the task wants to update its progress. Calling will\n"
"automatically emit the progressChanged signal.\n"
"\n"
":param progress: percent of progress, from 0.0 - 100.0");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_setProgress(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_setProgress(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        sipQgsPointCloudLayerExporterTask *sipCpp;

        static const char *sipKwdList[] = {
            sipName_progress,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bd", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_setProgress(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_setProgress, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_cancel, "cancel(self)");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_cancel(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_cancel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            (sipSelfWasArg ? sipCpp->::QgsPointCloudLayerExporterTask::cancel() : sipCpp->cancel());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_cancel, doc_QgsPointCloudLayerExporterTask_cancel);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_run, "run(self) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_run(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_run(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        sipQgsPointCloudLayerExporterTask *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sipProtectVirt_run(sipSelfWasArg);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_run, doc_QgsPointCloudLayerExporterTask_run);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask_finished, "finished(self, result: bool)");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporterTask_finished(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporterTask_finished(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        bool a0;
        sipQgsPointCloudLayerExporterTask *sipCpp;

        static const char *sipKwdList[] = {
            sipName_result,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_QgsPointCloudLayerExporterTask, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_finished(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporterTask, sipName_finished, doc_QgsPointCloudLayerExporterTask_finished);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QgsPointCloudLayerExporterTask(void *, const sipTypeDef *);}
static void *cast_QgsPointCloudLayerExporterTask(void *sipCppV, const sipTypeDef *targetType)
{
    ::QgsPointCloudLayerExporterTask *sipCpp = reinterpret_cast< ::QgsPointCloudLayerExporterTask *>(sipCppV);

    if (targetType == sipType_QgsPointCloudLayerExporterTask)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_QgsTask)->ctd_cast(static_cast< ::QgsTask *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudLayerExporterTask(void *, int);}
static void release_QgsPointCloudLayerExporterTask(void *sipCppV, int)
{
    ::QgsPointCloudLayerExporterTask *sipCpp = reinterpret_cast< ::QgsPointCloudLayerExporterTask *>(sipCppV);

    Py_BEGIN_ALLOW_THREADS

    if (QThread::currentThread() == sipCpp->thread())
        delete sipCpp;
    else
        sipCpp->deleteLater();

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QgsPointCloudLayerExporterTask(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudLayerExporterTask(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQgsPointCloudLayerExporterTask *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudLayerExporterTask(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QgsPointCloudLayerExporterTask(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudLayerExporterTask(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQgsPointCloudLayerExporterTask *sipCpp = SIP_NULLPTR;

    {
        ::QgsPointCloudLayerExporter* a0;

        static const char *sipKwdList[] = {
            sipName_exporter,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J8", sipType_QgsPointCloudLayerExporter, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsPointCloudLayerExporterTask(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QgsPointCloudLayerExporterTask[] = {{2349, 255, 1}};


static PyMethodDef methods_QgsPointCloudLayerExporterTask[] = {
    {sipName_cancel, meth_QgsPointCloudLayerExporterTask_cancel, METH_VARARGS, doc_QgsPointCloudLayerExporterTask_cancel},
    {sipName_childEvent, meth_QgsPointCloudLayerExporterTask_childEvent, METH_VARARGS, SIP_NULLPTR},
    {sipName_connectNotify, meth_QgsPointCloudLayerExporterTask_connectNotify, METH_VARARGS, SIP_NULLPTR},
    {sipName_customEvent, meth_QgsPointCloudLayerExporterTask_customEvent, METH_VARARGS, SIP_NULLPTR},
    {sipName_disconnectNotify, meth_QgsPointCloudLayerExporterTask_disconnectNotify, METH_VARARGS, SIP_NULLPTR},
    {sipName_finished, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporterTask_finished), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporterTask_finished},
    {sipName_isCanceled, meth_QgsPointCloudLayerExporterTask_isCanceled, METH_VARARGS, SIP_NULLPTR},
    {sipName_isSignalConnected, meth_QgsPointCloudLayerExporterTask_isSignalConnected, METH_VARARGS, SIP_NULLPTR},
    {sipName_receivers, meth_QgsPointCloudLayerExporterTask_receivers, METH_VARARGS, SIP_NULLPTR},
    {sipName_run, meth_QgsPointCloudLayerExporterTask_run, METH_VARARGS, doc_QgsPointCloudLayerExporterTask_run},
    {sipName_sender, meth_QgsPointCloudLayerExporterTask_sender, METH_VARARGS, SIP_NULLPTR},
    {sipName_senderSignalIndex, meth_QgsPointCloudLayerExporterTask_senderSignalIndex, METH_VARARGS, SIP_NULLPTR},
    {sipName_setProgress, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporterTask_setProgress), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_timerEvent, meth_QgsPointCloudLayerExporterTask_timerEvent, METH_VARARGS, SIP_NULLPTR}
};

PyDoc_STRVAR(doc_QgsPointCloudLayerExporterTask, ":py:class:`QgsTask` task which performs a\n"
":py:class:`QgsPointCloudLayerExporter` layer export operation as a\n"
"background task.\n"
"\n"
"This can be used to export a point cloud layer out to a provider without\n"
"blocking the QGIS interface.\n"
"\n"
".. versionadded:: 3.28\n"
"\n"
"QgsPointCloudLayerExporterTask(exporter: Optional[QgsPointCloudLayerExporter])\n"
"Constructor for QgsPointCloudLayerExporterTask. Takes ownership of\n"
"``exporter``.");


/* Define this type's signals. */
static const pyqt5QtSignal signals_QgsPointCloudLayerExporterTask[] = {
    {"exportComplete()", "exportComplete(self)\nEmitted when exporting the layer is successfully completed.", SIP_NULLPTR, SIP_NULLPTR},
    {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
};


static pyqt5ClassPluginDef plugin_QgsPointCloudLayerExporterTask = {
    &::QgsPointCloudLayerExporterTask::staticMetaObject,
    0,
    signals_QgsPointCloudLayerExporterTask,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudLayerExporterTask = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudLayerExporterTask,
        SIP_NULLPTR,
        &plugin_QgsPointCloudLayerExporterTask,
    },
    {
        sipNameNr_QgsPointCloudLayerExporterTask,
        {0, 0, 1},
        14, methods_QgsPointCloudLayerExporterTask,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudLayerExporterTask,
    -1,
    -1,
    supers_QgsPointCloudLayerExporterTask,
    SIP_NULLPTR,
    init_type_QgsPointCloudLayerExporterTask,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudLayerExporterTask,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QgsPointCloudLayerExporterTask,
    cast_QgsPointCloudLayerExporterTask,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsPointCloudLayerExporterTask),
};

#line 24 "auto_generated/pointcloud/qgspointcloudlayerexporter.sip"
#include "qgspointcloudlayerexporter.h"
#line 2912 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 28 "auto_generated/pointcloud/qgspointcloudlayer.sip"
#include "qgspointcloudlayer.h"
#line 2916 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 2919 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "auto_generated/qgsmaplayer.sip"
#include "qgsmaplayer.h"
#line 2922 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "auto_generated/qgsvectorfilewriter.sip"
#include "qgsvectorfilewriter.h"
#line 2925 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 205 "auto_generated/proj/qgscoordinatereferencesystem.sip"
#include "qgscoordinatereferencesystem.h"
#line 2928 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 39 "auto_generated/proj/qgscoordinatetransformcontext.sip"
#include "qgscoordinatetransformcontext.h"
#line 2931 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 36 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 2934 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 38 "auto_generated/qgsfeedback.sip"
#include "qgsfeedback.h"
#line 2937 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 163 "auto_generated/qgsrange.sip"
#include "qgsrange.h"
typedef QgsRange<double> QgsRangedoubleBase;
#line 2941 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 37 "auto_generated/geometry/qgsabstractgeometry.sip"
#include "qgsabstractgeometry.h"
#line 2944 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 29 "auto_generated/geometry/qgsrectangle.sip"
#include "qgsrectangle.h"
#line 2947 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setFileName, "setFileName(self, filename: Optional[str])\n"
"Sets the ``filename`` for the new layer.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setFileName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setFileName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, sipType_QString, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setFileName(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setFileName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_fileName, "fileName(self) -> str\n"
"Gets the filename for the new layer.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_fileName(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_fileName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->fileName());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_fileName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setLayerName, "setLayerName(self, name: Optional[str])\n"
"Sets the ``name`` for the new layer.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setLayerName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setLayerName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, sipType_QString, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setLayerName(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setLayerName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_layerName, "layerName(self) -> str\n"
"Gets the name for the new layer.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_layerName(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_layerName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->layerName());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_layerName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setFilterExtent, "setFilterExtent(self, extent: QgsRectangle)\n"
"Sets a filter extent for points to be exported in the target CRS Points\n"
"that fall outside the extent will be skipped.\n"
"\n"
".. seealso:: :py:func:`setCrs`");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setFilterExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setFilterExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsRectangle* a0;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_extent,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, sipType_QgsRectangle, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setFilterExtent(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setFilterExtent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_filterExtent, "filterExtent(self) -> QgsRectangle\n"
"Gets the filter extent for points to be exported.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_filterExtent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_filterExtent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            ::QgsRectangle*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsRectangle(sipCpp->filterExtent());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsRectangle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_filterExtent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setFilterGeometry, "setFilterGeometry(self, geometry: Optional[QgsAbstractGeometry])\n"
"Sets a spatial filter for points to be exported based on ``geom`` in the\n"
"point cloud's CRS. Points that do not intersect ``geometry`` will be\n"
"skipped.\n"
"\n"
"setFilterGeometry(self, layer: Optional[QgsMapLayer], selectedFeaturesOnly: bool = False)\n"
"Sets a spatial filter for points to be exported based on the features of\n"
"``layer``. Points that do not intersect the ``layer``'s features will be\n"
"skipped.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setFilterGeometry(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setFilterGeometry(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsAbstractGeometry* a0;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_geometry,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, sipType_QgsAbstractGeometry, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setFilterGeometry(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        ::QgsMapLayer* a0;
        bool a1 = 0;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layer,
            sipName_selectedFeaturesOnly,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8|b", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, sipType_QgsMapLayer, &a0, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setFilterGeometry(a0, a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setFilterGeometry, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setZRange, "setZRange(self, zRange: QgsDoubleRange)\n"
"Sets an inclusive range for Z values to be exported. Points with Z\n"
"values outside the range will be skipped.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setZRange(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setZRange(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsDoubleRange* a0;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_zRange,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, sipType_QgsDoubleRange, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setZRange(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setZRange, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_zRange, "zRange(self) -> QgsDoubleRange\n"
"Gets the inclusive range for Z values to be exported.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_zRange(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_zRange(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            ::QgsDoubleRange*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsDoubleRange(sipCpp->zRange());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsDoubleRange, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_zRange, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setFeedback, "setFeedback(self, feedback: Optional[QgsFeedback])\n"
"Sets a :py:class:`QgsFeedback` object to allow cancellation / progress\n"
"reporting.\n"
"\n"
".. note::\n"
"\n"
"   The ``feedback`` object must exist for the lifetime of the exporter.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setFeedback(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setFeedback(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsFeedback* a0;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_feedback,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, sipType_QgsFeedback, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setFeedback(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setFeedback, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_feedback, "feedback(self) -> Optional[QgsFeedback]\n"
"Gets a pointer to the :py:class:`QgsFeedback` object used for\n"
"cancellation / progress reporting, or None if not set.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_feedback(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_feedback(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            ::QgsFeedback*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->feedback();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsFeedback, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_feedback, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setAttributes, "setAttributes(self, attributes: Iterable[Optional[str]])\n"
"Sets the list of point cloud ``attributes`` that will be exported. If\n"
"never called, all attributes will be exported.\n"
"\n"
".. note::\n"
"\n"
"   This has no effect when exporting to LAS/LAZ format.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QStringList* a0;
        int a0State = 0;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attributes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, sipType_QStringList, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setAttributes(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QStringList *>(a0), sipType_QStringList, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QStringList *>(a0), sipType_QStringList, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setNoAttributes, "setNoAttributes(self)\n"
"Sets that no attributes will be exported.\n"
"\n"
".. note::\n"
"\n"
"   This has no effect when exporting to LAS/LAZ format.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setNoAttributes(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setNoAttributes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setNoAttributes();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setNoAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setAllAttributes, "setAllAttributes(self)\n"
"Sets that all attributes will be exported.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setAllAttributes(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setAllAttributes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setAllAttributes();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setAllAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_attributes, "attributes(self) -> list[str]\n"
"Gets the list of point cloud attributes that will be exported.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_attributes(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_attributes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            ::QStringList*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QStringList(sipCpp->attributes());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_attributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setCrs, "setCrs(self, crs: QgsCoordinateReferenceSystem, context: QgsCoordinateTransformContext = QgsCoordinateTransformContext())\n"
"Sets the ``crs`` for the exported file, and the transform ``context``\n"
"that will be used for reprojection if different from the point cloud\n"
"layer's CRS.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setCrs(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setCrs(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsCoordinateReferenceSystem* a0;
        const ::QgsCoordinateTransformContext& a1def = QgsCoordinateTransformContext();
        const ::QgsCoordinateTransformContext* a1 = &a1def;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_crs,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|J9", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, sipType_QgsCoordinateReferenceSystem, &a0, sipType_QgsCoordinateTransformContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setCrs(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setCrs, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_crs, "crs(self) -> QgsCoordinateReferenceSystem\n"
"Gets the ``crs`` for the exported file.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_crs(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_crs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            ::QgsCoordinateReferenceSystem*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsCoordinateReferenceSystem(sipCpp->crs());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsCoordinateReferenceSystem, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_crs, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setFormat, "setFormat(self, format: QgsPointCloudLayerExporter.ExportFormat) -> bool\n"
"Sets the ``format`` for the exported file.\n"
"\n"
":return: true if the ``format`` is supported, false otherwise.\n"
"\n"
".. seealso:: ExportFormat");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setFormat(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setFormat(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudLayerExporter::ExportFormat a0;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, sipType_QgsPointCloudLayerExporter_ExportFormat, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->setFormat(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setFormat, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_format, "format(self) -> QgsPointCloudLayerExporter.ExportFormat\n"
"Returns the format for the exported file or layer.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_format(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_format(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            ::QgsPointCloudLayerExporter::ExportFormat sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->format();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QgsPointCloudLayerExporter_ExportFormat);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_format, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setPointsLimit, "setPointsLimit(self, limit: int)\n"
"Sets the maximum number of points to be exported. Default value is 0.\n"
"\n"
".. note::\n"
"\n"
"   Any ``limit`` value <= 0 means no limit.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setPointsLimit(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setPointsLimit(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_limit,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bn", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setPointsLimit(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setPointsLimit, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_pointsLimit, "pointsLimit(self) -> int\n"
"Gets the maximum number of points to be exported. 0 means no limit.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_pointsLimit(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_pointsLimit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            ::qint64 sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointsLimit();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_pointsLimit, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_setActionOnExistingFile, "setActionOnExistingFile(self, action: QgsVectorFileWriter.ActionOnExistingFile)\n"
"Sets whether an existing output vector file should be overwritten on\n"
"appended to.\n"
"\n"
".. note::\n"
"\n"
"   Only applies to vector formats");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_setActionOnExistingFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_setActionOnExistingFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsVectorFileWriter::ActionOnExistingFile a0;
        ::QgsPointCloudLayerExporter *sipCpp;

        static const char *sipKwdList[] = {
            sipName_action,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp, sipType_QgsVectorFileWriter_ActionOnExistingFile, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setActionOnExistingFile(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_setActionOnExistingFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_prepareExport, "prepareExport(self)\n"
"Creates the :py:class:`QgsVectorLayer` for exporting to a memory layer,\n"
"if necessary. This method allows the exported memory layer to be created\n"
"in the main thread. If not explicitly called, this method will be\n"
"implicitly called by :py:func:`~QgsPointCloudLayerExporter.doExport`.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_prepareExport(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_prepareExport(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->prepareExport();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_prepareExport, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_doExport, "doExport(self)\n"
"Performs the actual exporting operation.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_doExport(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_doExport(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->doExport();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_doExport, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_takeExportedLayer, "takeExportedLayer(self) -> Optional[QgsMapLayer]\n"
"Gets a pointer to the exported layer. Caller takes ownership of the\n"
"returned object.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_takeExportedLayer(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_takeExportedLayer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            ::QgsMapLayer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->takeExportedLayer();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsMapLayer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_takeExportedLayer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerExporter_lastError, "lastError(self) -> str\n"
"Gets the last error that occurred during the exporting operation. If no\n"
"error occurred an empty string is returned.");

extern "C" {static PyObject *meth_QgsPointCloudLayerExporter_lastError(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerExporter_lastError(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerExporter *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerExporter, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->lastError());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerExporter, sipName_lastError, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudLayerExporter(void *, int);}
static void release_QgsPointCloudLayerExporter(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsPointCloudLayerExporter *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QgsPointCloudLayerExporter(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudLayerExporter(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudLayerExporter(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsPointCloudLayerExporter(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudLayerExporter(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsPointCloudLayerExporter *sipCpp = SIP_NULLPTR;

    {
        ::QgsPointCloudLayer* a0;

        static const char *sipKwdList[] = {
            sipName_layer,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J8", sipType_QgsPointCloudLayer, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudLayerExporter(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsPointCloudLayerExporter[] = {
    {sipName_attributes, meth_QgsPointCloudLayerExporter_attributes, METH_VARARGS, doc_QgsPointCloudLayerExporter_attributes},
    {sipName_crs, meth_QgsPointCloudLayerExporter_crs, METH_VARARGS, doc_QgsPointCloudLayerExporter_crs},
    {sipName_doExport, meth_QgsPointCloudLayerExporter_doExport, METH_VARARGS, doc_QgsPointCloudLayerExporter_doExport},
    {sipName_feedback, meth_QgsPointCloudLayerExporter_feedback, METH_VARARGS, doc_QgsPointCloudLayerExporter_feedback},
    {sipName_fileName, meth_QgsPointCloudLayerExporter_fileName, METH_VARARGS, doc_QgsPointCloudLayerExporter_fileName},
    {sipName_filterExtent, meth_QgsPointCloudLayerExporter_filterExtent, METH_VARARGS, doc_QgsPointCloudLayerExporter_filterExtent},
    {sipName_format, meth_QgsPointCloudLayerExporter_format, METH_VARARGS, doc_QgsPointCloudLayerExporter_format},
    {sipName_lastError, meth_QgsPointCloudLayerExporter_lastError, METH_VARARGS, doc_QgsPointCloudLayerExporter_lastError},
    {sipName_layerName, meth_QgsPointCloudLayerExporter_layerName, METH_VARARGS, doc_QgsPointCloudLayerExporter_layerName},
    {sipName_pointsLimit, meth_QgsPointCloudLayerExporter_pointsLimit, METH_VARARGS, doc_QgsPointCloudLayerExporter_pointsLimit},
    {sipName_prepareExport, meth_QgsPointCloudLayerExporter_prepareExport, METH_VARARGS, doc_QgsPointCloudLayerExporter_prepareExport},
    {sipName_setActionOnExistingFile, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporter_setActionOnExistingFile), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporter_setActionOnExistingFile},
    {sipName_setAllAttributes, meth_QgsPointCloudLayerExporter_setAllAttributes, METH_VARARGS, doc_QgsPointCloudLayerExporter_setAllAttributes},
    {sipName_setAttributes, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporter_setAttributes), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporter_setAttributes},
    {sipName_setCrs, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporter_setCrs), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporter_setCrs},
    {sipName_setFeedback, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporter_setFeedback), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporter_setFeedback},
    {sipName_setFileName, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporter_setFileName), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporter_setFileName},
    {sipName_setFilterExtent, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporter_setFilterExtent), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporter_setFilterExtent},
    {sipName_setFilterGeometry, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporter_setFilterGeometry), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporter_setFilterGeometry},
    {sipName_setFormat, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporter_setFormat), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporter_setFormat},
    {sipName_setLayerName, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporter_setLayerName), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporter_setLayerName},
    {sipName_setNoAttributes, meth_QgsPointCloudLayerExporter_setNoAttributes, METH_VARARGS, doc_QgsPointCloudLayerExporter_setNoAttributes},
    {sipName_setPointsLimit, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporter_setPointsLimit), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporter_setPointsLimit},
    {sipName_setZRange, SIP_MLMETH_CAST(meth_QgsPointCloudLayerExporter_setZRange), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerExporter_setZRange},
    {sipName_takeExportedLayer, meth_QgsPointCloudLayerExporter_takeExportedLayer, METH_VARARGS, doc_QgsPointCloudLayerExporter_takeExportedLayer},
    {sipName_zRange, meth_QgsPointCloudLayerExporter_zRange, METH_VARARGS, doc_QgsPointCloudLayerExporter_zRange}
};

static sipEnumMemberDef enummembers_QgsPointCloudLayerExporter[] = {
    {sipName_Csv, static_cast<int>(::QgsPointCloudLayerExporter::ExportFormat::Csv), 1804},
    {sipName_Dxf, static_cast<int>(::QgsPointCloudLayerExporter::ExportFormat::Dxf), 1804},
    {sipName_Gpkg, static_cast<int>(::QgsPointCloudLayerExporter::ExportFormat::Gpkg), 1804},
    {sipName_Las, static_cast<int>(::QgsPointCloudLayerExporter::ExportFormat::Las), 1804},
    {sipName_Memory, static_cast<int>(::QgsPointCloudLayerExporter::ExportFormat::Memory), 1804},
    {sipName_Shp, static_cast<int>(::QgsPointCloudLayerExporter::ExportFormat::Shp), 1804},
};

PyDoc_STRVAR(doc_QgsPointCloudLayerExporter, "Handles exporting point cloud layers to memory layers, OGR supported\n"
"files and PDAL supported files.\n"
"\n"
".. versionadded:: 3.28\n"
"\n"
"QgsPointCloudLayerExporter(layer: Optional[QgsPointCloudLayer])\n"
"Constructor for QgsPointCloudLayerExporter, associated with the\n"
"specified ``layer``.\n"
"\n"
".. note::\n"
"\n"
"   The ``layer`` is safe to be deleted once it's used in the constructor.");


static pyqt5ClassPluginDef plugin_QgsPointCloudLayerExporter = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudLayerExporter = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudLayerExporter,
        SIP_NULLPTR,
        &plugin_QgsPointCloudLayerExporter,
    },
    {
        sipNameNr_QgsPointCloudLayerExporter,
        {0, 0, 1},
        26, methods_QgsPointCloudLayerExporter,
        6, enummembers_QgsPointCloudLayerExporter,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudLayerExporter,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsPointCloudLayerExporter,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudLayerExporter,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QgsPointCloudLayerExporter,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsPointCloudLayerExporter),
};

#line 25 "auto_generated/pointcloud/qgspointcloudrgbrenderer.sip"
#include "qgspointcloudrgbrenderer.h"
#line 4482 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 25 "auto_generated/raster/qgscontrastenhancement.sip"
#include "qgscontrastenhancement.h"
#line 4486 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 4489 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 179 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 4492 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 312 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 4495 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 21 "auto_generated/qgsreadwritecontext.sip"
#include "qgsreadwritecontext.h"
#line 4498 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qset.sip"
#include <qset.h>
#line 4501 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 24 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 4504 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 192 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 4507 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "auto_generated/pointcloud/qgspointcloudblock.sip"
#include "qgspointcloudblock.h"
#line 4510 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtGui/qcolor.sip"
#include <qcolor.h>
#line 4513 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 4516 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 24 "auto_generated/textrenderer/qgstextformat.sip"
#include "qgstextformat.h"
#line 4519 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 36 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 4522 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 149 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 4525 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 25 "auto_generated/layertree/qgslayertreemodellegendnode.sip"
#include "qgslayertreemodellegendnode.h"
#include "qgscolorramplegendnode.h"
#line 4529 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "auto_generated/layertree/qgslayertreelayer.sip"
#include "qgslayertreelayer.h"
#line 4532 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 25 "auto_generated/qgsmapunitscale.sip"
#include "qgsmapunitscale.h"
#line 4535 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qmap.sip"
#include <qmap.h>
#line 4538 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qvariant.sip"
#include <qvariant.h>
#line 4541 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


class sipQgsPointCloudRgbRenderer : public ::QgsPointCloudRgbRenderer
{
public:
    sipQgsPointCloudRgbRenderer();
    virtual ~sipQgsPointCloudRgbRenderer();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    static void sipProtect_pointXY(::QgsPointCloudRenderContext&, const char*, int, double&, double&);
    static double sipProtect_pointZ(::QgsPointCloudRenderContext&, const char*, int);
    void sipProtect_drawPoint(double, double, const ::QColor&, ::QgsPointCloudRenderContext&) const;
    void sipProtect_drawPoint(double, double, const ::QColor&, int, ::QgsPointCloudRenderContext&) const;
    void sipProtect_addPointToTriangulation(double, double, double, const ::QColor&, ::QgsPointCloudRenderContext&);
    void sipProtect_copyCommonProperties(::QgsPointCloudRenderer*) const;
    void sipProtect_restoreCommonProperties(const ::QDomElement&, const ::QgsReadWriteContext&);
    void sipProtect_saveCommonProperties(::QDomElement&, const ::QgsReadWriteContext&) const;

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::QString type() const SIP_OVERRIDE;
    ::QgsPointCloudRenderer* clone() const SIP_OVERRIDE;
    void renderBlock(const ::QgsPointCloudBlock*, ::QgsPointCloudRenderContext&) SIP_OVERRIDE;
    bool willRenderPoint(const QMap< ::QString, ::QVariant>&) SIP_OVERRIDE;
    ::QDomElement save(::QDomDocument&, const ::QgsReadWriteContext&) const SIP_OVERRIDE;
    QSet< ::QString> usedAttributes(const ::QgsPointCloudRenderContext&) const SIP_OVERRIDE;
    void startRender(::QgsPointCloudRenderContext&) SIP_OVERRIDE;
    void stopRender(::QgsPointCloudRenderContext&) SIP_OVERRIDE;
    bool legendItemChecked(const ::QString&) SIP_OVERRIDE;
    void checkLegendItem(const ::QString&, bool) SIP_OVERRIDE;
    QList< ::QgsLayerTreeModelLegendNode*> createLegendNodes(::QgsLayerTreeLayer*) SIP_OVERRIDE;
    ::QStringList legendRuleKeys() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQgsPointCloudRgbRenderer(const sipQgsPointCloudRgbRenderer &);
    sipQgsPointCloudRgbRenderer &operator = (const sipQgsPointCloudRgbRenderer &);

    char sipPyMethods[12];
};

sipQgsPointCloudRgbRenderer::sipQgsPointCloudRgbRenderer(): ::QgsPointCloudRgbRenderer(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsPointCloudRgbRenderer::~sipQgsPointCloudRgbRenderer()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::QString sipQgsPointCloudRgbRenderer::type() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_type);

    if (!sipMeth)
        return ::QgsPointCloudRgbRenderer::type();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsPointCloudRenderer* sipQgsPointCloudRgbRenderer::clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_clone);

    if (!sipMeth)
        return ::QgsPointCloudRgbRenderer::clone();

    extern ::QgsPointCloudRenderer* sipVH__core_739(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_739(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudRgbRenderer::renderBlock(const ::QgsPointCloudBlock*a0, ::QgsPointCloudRenderContext& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_renderBlock);

    if (!sipMeth)
    {
        ::QgsPointCloudRgbRenderer::renderBlock(a0, a1);
        return;
    }

    extern void sipVH__core_740(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsPointCloudBlock*, ::QgsPointCloudRenderContext&);

    sipVH__core_740(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudRgbRenderer::willRenderPoint(const QMap< ::QString, ::QVariant>& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_willRenderPoint);

    if (!sipMeth)
        return ::QgsPointCloudRgbRenderer::willRenderPoint(a0);

    extern bool sipVH__core_741(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const QMap< ::QString, ::QVariant>&);

    return sipVH__core_741(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QDomElement sipQgsPointCloudRgbRenderer::save(::QDomDocument& a0, const ::QgsReadWriteContext& a1) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[4]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_save);

    if (!sipMeth)
        return ::QgsPointCloudRgbRenderer::save(a0, a1);

    extern ::QDomElement sipVH__core_166(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomDocument&, const ::QgsReadWriteContext&);

    return sipVH__core_166(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

QSet< ::QString> sipQgsPointCloudRgbRenderer::usedAttributes(const ::QgsPointCloudRenderContext& a0) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[5]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_usedAttributes);

    if (!sipMeth)
        return ::QgsPointCloudRgbRenderer::usedAttributes(a0);

    extern QSet< ::QString> sipVH__core_742(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsPointCloudRenderContext&);

    return sipVH__core_742(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudRgbRenderer::startRender(::QgsPointCloudRenderContext& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_startRender);

    if (!sipMeth)
    {
        ::QgsPointCloudRgbRenderer::startRender(a0);
        return;
    }

    extern void sipVH__core_743(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsPointCloudRenderContext&);

    sipVH__core_743(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudRgbRenderer::stopRender(::QgsPointCloudRenderContext& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_stopRender);

    if (!sipMeth)
    {
        ::QgsPointCloudRgbRenderer::stopRender(a0);
        return;
    }

    extern void sipVH__core_743(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsPointCloudRenderContext&);

    sipVH__core_743(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQgsPointCloudRgbRenderer::legendItemChecked(const ::QString& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[8], &sipPySelf, SIP_NULLPTR, sipName_legendItemChecked);

    if (!sipMeth)
        return ::QgsPointCloudRgbRenderer::legendItemChecked(a0);

    extern bool sipVH__core_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&);

    return sipVH__core_9(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudRgbRenderer::checkLegendItem(const ::QString& a0, bool a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[9], &sipPySelf, SIP_NULLPTR, sipName_checkLegendItem);

    if (!sipMeth)
    {
        ::QgsPointCloudRgbRenderer::checkLegendItem(a0, a1);
        return;
    }

    extern void sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool);

    sipVH__core_11(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

QList< ::QgsLayerTreeModelLegendNode*> sipQgsPointCloudRgbRenderer::createLegendNodes(::QgsLayerTreeLayer*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[10], &sipPySelf, SIP_NULLPTR, sipName_createLegendNodes);

    if (!sipMeth)
        return ::QgsPointCloudRgbRenderer::createLegendNodes(a0);

    extern QList< ::QgsLayerTreeModelLegendNode*> sipVH__core_141(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsLayerTreeLayer*);

    return sipVH__core_141(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QStringList sipQgsPointCloudRgbRenderer::legendRuleKeys() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[11]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_legendRuleKeys);

    if (!sipMeth)
        return ::QgsPointCloudRgbRenderer::legendRuleKeys();

    extern ::QStringList sipVH__core_20(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_20(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudRgbRenderer::sipProtect_pointXY(::QgsPointCloudRenderContext& a0, const char*a1, int a2, double& a3, double& a4)
{
    ::QgsPointCloudRenderer::pointXY(a0, a1, a2, a3, a4);
}

double sipQgsPointCloudRgbRenderer::sipProtect_pointZ(::QgsPointCloudRenderContext& a0, const char*a1, int a2)
{
    return ::QgsPointCloudRenderer::pointZ(a0, a1, a2);
}

void sipQgsPointCloudRgbRenderer::sipProtect_drawPoint(double a0, double a1, const ::QColor& a2, ::QgsPointCloudRenderContext& a3) const
{
    ::QgsPointCloudRenderer::drawPoint(a0, a1, a2, a3);
}

void sipQgsPointCloudRgbRenderer::sipProtect_drawPoint(double a0, double a1, const ::QColor& a2, int a3, ::QgsPointCloudRenderContext& a4) const
{
    ::QgsPointCloudRenderer::drawPoint(a0, a1, a2, a3, a4);
}

void sipQgsPointCloudRgbRenderer::sipProtect_addPointToTriangulation(double a0, double a1, double a2, const ::QColor& a3, ::QgsPointCloudRenderContext& a4)
{
    ::QgsPointCloudRenderer::addPointToTriangulation(a0, a1, a2, a3, a4);
}

void sipQgsPointCloudRgbRenderer::sipProtect_copyCommonProperties(::QgsPointCloudRenderer*a0) const
{
    ::QgsPointCloudRenderer::copyCommonProperties(a0);
}

void sipQgsPointCloudRgbRenderer::sipProtect_restoreCommonProperties(const ::QDomElement& a0, const ::QgsReadWriteContext& a1)
{
    ::QgsPointCloudRenderer::restoreCommonProperties(a0, a1);
}

void sipQgsPointCloudRgbRenderer::sipProtect_saveCommonProperties(::QDomElement& a0, const ::QgsReadWriteContext& a1) const
{
    ::QgsPointCloudRenderer::saveCommonProperties(a0, a1);
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_pointXY, "pointXY(context: QgsPointCloudRenderContext, ptr: Optional[str], i: int) -> (float, float)\n"
"Retrieves the x and y coordinate for the point at index ``i``.");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_pointXY(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_pointXY(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRenderContext* a0;
        const char* a1;
        PyObject *a1Keep;
        int a2;
        double a3;
        double a4;

        static const char *sipKwdList[] = {
            sipName_context,
            sipName_ptr,
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9AAi", sipType_QgsPointCloudRenderContext, &a0, &a1Keep, &a1, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipQgsPointCloudRgbRenderer::sipProtect_pointXY(*a0, a1, a2, a3, a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            Py_DECREF(a1Keep);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            Py_DECREF(a1Keep);

            return sipBuildResult(0, "(dd)", a3, a4);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_pointXY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_pointZ, "pointZ(context: QgsPointCloudRenderContext, ptr: Optional[str], i: int) -> float\n"
"Retrieves the z value for the point at index ``i``.");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_pointZ(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_pointZ(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRenderContext* a0;
        const char* a1;
        PyObject *a1Keep;
        int a2;

        static const char *sipKwdList[] = {
            sipName_context,
            sipName_ptr,
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9AAi", sipType_QgsPointCloudRenderContext, &a0, &a1Keep, &a1, &a2))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipQgsPointCloudRgbRenderer::sipProtect_pointZ(*a0, a1, a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            Py_DECREF(a1Keep);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            Py_DECREF(a1Keep);

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_pointZ, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_drawPoint, "drawPoint(self, x: float, y: float, color: Union[QColor, Qt.GlobalColor], context: QgsPointCloudRenderContext)\n"
"Draws a point using a ``color`` at the specified ``x`` and ``y`` (in map\n"
"coordinates).\n"
"\n"
"drawPoint(self, x: float, y: float, color: Union[QColor, Qt.GlobalColor], width: int, context: QgsPointCloudRenderContext)\n"
"Draws a point using a ``color`` and painter ``width`` at the specified\n"
"``x`` and ``y`` (in map coordinates).\n"
"\n"
".. versionadded:: 3.36");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_drawPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_drawPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        double a1;
        const ::QColor* a2;
        int a2State = 0;
        ::QgsPointCloudRenderContext* a3;
        const sipQgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_color,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BddJ1J9", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, &a0, &a1, sipType_QColor, &a2, &a2State, sipType_QgsPointCloudRenderContext, &a3))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_drawPoint(a0, a1, *a2, *a3);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        double a0;
        double a1;
        const ::QColor* a2;
        int a2State = 0;
        int a3;
        ::QgsPointCloudRenderContext* a4;
        const sipQgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_color,
            sipName_width,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BddJ1iJ9", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, &a0, &a1, sipType_QColor, &a2, &a2State, &a3, sipType_QgsPointCloudRenderContext, &a4))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_drawPoint(a0, a1, *a2, a3, *a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_drawPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_addPointToTriangulation, "addPointToTriangulation(self, x: float, y: float, z: float, color: Union[QColor, Qt.GlobalColor], context: QgsPointCloudRenderContext)\n"
"Adds a point to the list of points to be triangulated (only used when\n"
":py:func:`~QgsPointCloudRenderer.renderAsTriangles` is enabled)\n"
"\n"
".. versionadded:: 3.36");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_addPointToTriangulation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_addPointToTriangulation(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        double a1;
        double a2;
        const ::QColor* a3;
        int a3State = 0;
        ::QgsPointCloudRenderContext* a4;
        sipQgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_z,
            sipName_color,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BdddJ1J9", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, &a0, &a1, &a2, sipType_QColor, &a3, &a3State, sipType_QgsPointCloudRenderContext, &a4))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_addPointToTriangulation(a0, a1, a2, *a3, *a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QColor *>(a3), sipType_QColor, a3State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QColor *>(a3), sipType_QColor, a3State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_addPointToTriangulation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_copyCommonProperties, "copyCommonProperties(self, destination: Optional[QgsPointCloudRenderer])\n"
"Copies common point cloud properties (such as point size and screen\n"
"error) to the ``destination`` renderer.");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_copyCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_copyCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRenderer* a0;
        const sipQgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_destination,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QgsPointCloudRenderer, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_copyCommonProperties(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_copyCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_restoreCommonProperties, "restoreCommonProperties(self, element: QDomElement, context: QgsReadWriteContext)\n"
"Restores common renderer properties (such as point size and screen\n"
"error) from the specified DOM ``element``.\n"
"\n"
".. seealso:: :py:func:`saveCommonProperties`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_restoreCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_restoreCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;
        sipQgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_restoreCommonProperties(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_restoreCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_saveCommonProperties, "saveCommonProperties(self, element: QDomElement, context: QgsReadWriteContext)\n"
"Saves common renderer properties (such as point size and screen error)\n"
"to the specified DOM ``element``.\n"
"\n"
".. seealso:: :py:func:`restoreCommonProperties`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_saveCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_saveCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;
        const sipQgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_saveCommonProperties(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_saveCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_type, "type(self) -> str");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_type(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_type(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudRgbRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString((sipSelfWasArg ? sipCpp->::QgsPointCloudRgbRenderer::type() : sipCpp->type()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_type, doc_QgsPointCloudRgbRenderer_type);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_clone, "clone(self) -> Optional[QgsPointCloudRenderer]");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_clone(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudRgbRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp))
        {
            ::QgsPointCloudRenderer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudRgbRenderer::clone() : sipCpp->clone());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsPointCloudRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_clone, doc_QgsPointCloudRgbRenderer_clone);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_renderBlock, "renderBlock(self, block: Optional[QgsPointCloudBlock], context: QgsPointCloudRenderContext)");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_renderBlock(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_renderBlock(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudBlock* a0;
        ::QgsPointCloudRenderContext* a1;
        ::QgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_block,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J9", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QgsPointCloudBlock, &a0, sipType_QgsPointCloudRenderContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            (sipSelfWasArg ? sipCpp->::QgsPointCloudRgbRenderer::renderBlock(a0, *a1) : sipCpp->renderBlock(a0, *a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_renderBlock, doc_QgsPointCloudRgbRenderer_renderBlock);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_save, "save(self, doc: QDomDocument, context: QgsReadWriteContext) -> QDomElement");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_save(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_save(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QDomDocument* a0;
        const ::QgsReadWriteContext* a1;
        const ::QgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_doc,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QDomDocument, &a0, sipType_QgsReadWriteContext, &a1))
        {
            ::QDomElement*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QDomElement((sipSelfWasArg ? sipCpp->::QgsPointCloudRgbRenderer::save(*a0, *a1) : sipCpp->save(*a0, *a1)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QDomElement, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_save, doc_QgsPointCloudRgbRenderer_save);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_usedAttributes, "usedAttributes(self, context: QgsPointCloudRenderContext) -> set[str]");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_usedAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_usedAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudRenderContext* a0;
        const ::QgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QgsPointCloudRenderContext, &a0))
        {
            QSet< ::QString>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QSet< ::QString>((sipSelfWasArg ? sipCpp->::QgsPointCloudRgbRenderer::usedAttributes(*a0) : sipCpp->usedAttributes(*a0)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QSet_0100QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_usedAttributes, doc_QgsPointCloudRgbRenderer_usedAttributes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_create, "create(element: QDomElement, context: QgsReadWriteContext) -> Optional[QgsPointCloudRenderer]\n"
"Creates an RGB renderer from an XML ``element``.");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_create(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9J9", sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            ::QgsPointCloudRenderer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = ::QgsPointCloudRgbRenderer::create(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_create, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_redAttribute, "redAttribute(self) -> str\n"
"Returns the attribute to use for the red channel.\n"
"\n"
".. seealso:: :py:func:`greenAttribute`\n"
"\n"
".. seealso:: :py:func:`blueAttribute`\n"
"\n"
".. seealso:: :py:func:`setRedAttribute`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_redAttribute(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_redAttribute(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRgbRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->redAttribute());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_redAttribute, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_setRedAttribute, "setRedAttribute(self, attribute: Optional[str])\n"
"Sets the ``attribute`` to use for the red channel.\n"
"\n"
".. seealso:: :py:func:`setGreenAttribute`\n"
"\n"
".. seealso:: :py:func:`setBlueAttribute`\n"
"\n"
".. seealso:: :py:func:`redAttribute`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_setRedAttribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_setRedAttribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attribute,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QString, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setRedAttribute(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_setRedAttribute, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_greenAttribute, "greenAttribute(self) -> str\n"
"Returns the attribute to use for the green channel.\n"
"\n"
".. seealso:: :py:func:`redAttribute`\n"
"\n"
".. seealso:: :py:func:`blueAttribute`\n"
"\n"
".. seealso:: :py:func:`setGreenAttribute`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_greenAttribute(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_greenAttribute(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRgbRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->greenAttribute());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_greenAttribute, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_setGreenAttribute, "setGreenAttribute(self, attribute: Optional[str])\n"
"Sets the ``attribute`` to use for the green channel.\n"
"\n"
".. seealso:: :py:func:`setRedAttribute`\n"
"\n"
".. seealso:: :py:func:`setBlueAttribute`\n"
"\n"
".. seealso:: :py:func:`greenAttribute`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_setGreenAttribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_setGreenAttribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attribute,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QString, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setGreenAttribute(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_setGreenAttribute, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_blueAttribute, "blueAttribute(self) -> str\n"
"Returns the attribute to use for the blue channel.\n"
"\n"
".. seealso:: :py:func:`greenAttribute`\n"
"\n"
".. seealso:: :py:func:`redAttribute`\n"
"\n"
".. seealso:: :py:func:`setBlueAttribute`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_blueAttribute(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_blueAttribute(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRgbRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->blueAttribute());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_blueAttribute, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_setBlueAttribute, "setBlueAttribute(self, attribute: Optional[str])\n"
"Sets the ``attribute`` to use for the blue channel.\n"
"\n"
".. seealso:: :py:func:`setRedAttribute`\n"
"\n"
".. seealso:: :py:func:`setGreenAttribute`\n"
"\n"
".. seealso:: :py:func:`blueAttribute`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_setBlueAttribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_setBlueAttribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attribute,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QString, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setBlueAttribute(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_setBlueAttribute, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_redContrastEnhancement, "redContrastEnhancement(self) -> Optional[QgsContrastEnhancement]\n"
"Returns the contrast enhancement to use for the red channel.\n"
"\n"
".. seealso:: :py:func:`setRedContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`greenContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`blueContrastEnhancement`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_redContrastEnhancement(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_redContrastEnhancement(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRgbRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp))
        {
            const ::QgsContrastEnhancement*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->redContrastEnhancement();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(const_cast< ::QgsContrastEnhancement *>(sipRes), sipType_QgsContrastEnhancement, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_redContrastEnhancement, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_setRedContrastEnhancement, "setRedContrastEnhancement(self, enhancement: Optional[QgsContrastEnhancement])\n"
"Sets the contrast ``enhancement`` to use for the red channel.\n"
"\n"
"Ownership of ``enhancement`` is transferred.\n"
"\n"
".. seealso:: :py:func:`redContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`setGreenContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`setBlueContrastEnhancement`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_setRedContrastEnhancement(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_setRedContrastEnhancement(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsContrastEnhancement* a0;
        ::QgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enhancement,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QgsContrastEnhancement, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setRedContrastEnhancement(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_setRedContrastEnhancement, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_greenContrastEnhancement, "greenContrastEnhancement(self) -> Optional[QgsContrastEnhancement]\n"
"Returns the contrast enhancement to use for the green channel.\n"
"\n"
".. seealso:: :py:func:`setGreenContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`redContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`blueContrastEnhancement`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_greenContrastEnhancement(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_greenContrastEnhancement(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRgbRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp))
        {
            const ::QgsContrastEnhancement*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->greenContrastEnhancement();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(const_cast< ::QgsContrastEnhancement *>(sipRes), sipType_QgsContrastEnhancement, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_greenContrastEnhancement, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_setGreenContrastEnhancement, "setGreenContrastEnhancement(self, enhancement: Optional[QgsContrastEnhancement])\n"
"Sets the contrast ``enhancement`` to use for the green channel.\n"
"\n"
"Ownership of ``enhancement`` is transferred.\n"
"\n"
".. seealso:: :py:func:`greenContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`setRedContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`setBlueContrastEnhancement`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_setGreenContrastEnhancement(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_setGreenContrastEnhancement(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsContrastEnhancement* a0;
        ::QgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enhancement,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QgsContrastEnhancement, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setGreenContrastEnhancement(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_setGreenContrastEnhancement, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_blueContrastEnhancement, "blueContrastEnhancement(self) -> Optional[QgsContrastEnhancement]\n"
"Returns the contrast enhancement to use for the blue channel.\n"
"\n"
".. seealso:: :py:func:`setBlueContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`redContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`greenContrastEnhancement`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_blueContrastEnhancement(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_blueContrastEnhancement(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRgbRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp))
        {
            const ::QgsContrastEnhancement*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->blueContrastEnhancement();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(const_cast< ::QgsContrastEnhancement *>(sipRes), sipType_QgsContrastEnhancement, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_blueContrastEnhancement, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer_setBlueContrastEnhancement, "setBlueContrastEnhancement(self, enhancement: Optional[QgsContrastEnhancement])\n"
"Sets the contrast ``enhancement`` to use for the blue channel.\n"
"\n"
"Ownership of ``enhancement`` is transferred.\n"
"\n"
".. seealso:: :py:func:`blueContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`setRedContrastEnhancement`\n"
"\n"
".. seealso:: :py:func:`setGreenContrastEnhancement`");

extern "C" {static PyObject *meth_QgsPointCloudRgbRenderer_setBlueContrastEnhancement(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRgbRenderer_setBlueContrastEnhancement(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsContrastEnhancement* a0;
        ::QgsPointCloudRgbRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enhancement,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_QgsPointCloudRgbRenderer, &sipCpp, sipType_QgsContrastEnhancement, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setBlueContrastEnhancement(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRgbRenderer, sipName_setBlueContrastEnhancement, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QgsPointCloudRgbRenderer(void *, const sipTypeDef *);}
static void *cast_QgsPointCloudRgbRenderer(void *sipCppV, const sipTypeDef *targetType)
{
    ::QgsPointCloudRgbRenderer *sipCpp = reinterpret_cast< ::QgsPointCloudRgbRenderer *>(sipCppV);

    if (targetType == sipType_QgsPointCloudRgbRenderer)
        return sipCppV;

    if (targetType == sipType_QgsPointCloudRenderer)
        return static_cast< ::QgsPointCloudRenderer *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudRgbRenderer(void *, int);}
static void release_QgsPointCloudRgbRenderer(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQgsPointCloudRgbRenderer *>(sipCppV);
    else
        delete reinterpret_cast< ::QgsPointCloudRgbRenderer *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsPointCloudRgbRenderer(Py_ssize_t);}
static void *array_QgsPointCloudRgbRenderer(Py_ssize_t sipNrElem)
{
    return new ::QgsPointCloudRgbRenderer[sipNrElem];
}


extern "C" {static void array_delete_QgsPointCloudRgbRenderer(void *);}
static void array_delete_QgsPointCloudRgbRenderer(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsPointCloudRgbRenderer *>(sipCpp);
}


extern "C" {static void dealloc_QgsPointCloudRgbRenderer(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudRgbRenderer(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQgsPointCloudRgbRenderer *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudRgbRenderer(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QgsPointCloudRgbRenderer(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudRgbRenderer(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQgsPointCloudRgbRenderer *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsPointCloudRgbRenderer();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QgsPointCloudRgbRenderer[] = {{1809, 255, 1}};


static PyMethodDef methods_QgsPointCloudRgbRenderer[] = {
    {sipName_addPointToTriangulation, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_addPointToTriangulation), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_blueAttribute, meth_QgsPointCloudRgbRenderer_blueAttribute, METH_VARARGS, doc_QgsPointCloudRgbRenderer_blueAttribute},
    {sipName_blueContrastEnhancement, meth_QgsPointCloudRgbRenderer_blueContrastEnhancement, METH_VARARGS, doc_QgsPointCloudRgbRenderer_blueContrastEnhancement},
    {sipName_clone, meth_QgsPointCloudRgbRenderer_clone, METH_VARARGS, doc_QgsPointCloudRgbRenderer_clone},
    {sipName_copyCommonProperties, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_copyCommonProperties), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_create, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_create), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRgbRenderer_create},
    {sipName_drawPoint, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_drawPoint), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_greenAttribute, meth_QgsPointCloudRgbRenderer_greenAttribute, METH_VARARGS, doc_QgsPointCloudRgbRenderer_greenAttribute},
    {sipName_greenContrastEnhancement, meth_QgsPointCloudRgbRenderer_greenContrastEnhancement, METH_VARARGS, doc_QgsPointCloudRgbRenderer_greenContrastEnhancement},
    {sipName_pointXY, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_pointXY), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_pointZ, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_pointZ), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_redAttribute, meth_QgsPointCloudRgbRenderer_redAttribute, METH_VARARGS, doc_QgsPointCloudRgbRenderer_redAttribute},
    {sipName_redContrastEnhancement, meth_QgsPointCloudRgbRenderer_redContrastEnhancement, METH_VARARGS, doc_QgsPointCloudRgbRenderer_redContrastEnhancement},
    {sipName_renderBlock, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_renderBlock), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRgbRenderer_renderBlock},
    {sipName_restoreCommonProperties, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_restoreCommonProperties), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_save, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_save), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRgbRenderer_save},
    {sipName_saveCommonProperties, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_saveCommonProperties), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_setBlueAttribute, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_setBlueAttribute), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRgbRenderer_setBlueAttribute},
    {sipName_setBlueContrastEnhancement, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_setBlueContrastEnhancement), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRgbRenderer_setBlueContrastEnhancement},
    {sipName_setGreenAttribute, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_setGreenAttribute), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRgbRenderer_setGreenAttribute},
    {sipName_setGreenContrastEnhancement, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_setGreenContrastEnhancement), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRgbRenderer_setGreenContrastEnhancement},
    {sipName_setRedAttribute, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_setRedAttribute), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRgbRenderer_setRedAttribute},
    {sipName_setRedContrastEnhancement, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_setRedContrastEnhancement), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRgbRenderer_setRedContrastEnhancement},
    {sipName_type, meth_QgsPointCloudRgbRenderer_type, METH_VARARGS, doc_QgsPointCloudRgbRenderer_type},
    {sipName_usedAttributes, SIP_MLMETH_CAST(meth_QgsPointCloudRgbRenderer_usedAttributes), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRgbRenderer_usedAttributes}
};

PyDoc_STRVAR(doc_QgsPointCloudRgbRenderer, "An RGB renderer for 2d visualisation of point clouds using embedded red,\n"
"green and blue attributes.\n"
"\n"
".. versionadded:: 3.18\n"
"\n"
"QgsPointCloudRgbRenderer()\n"
"Constructor for QgsPointCloudRgbRenderer.");


static pyqt5ClassPluginDef plugin_QgsPointCloudRgbRenderer = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudRgbRenderer = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudRgbRenderer,
        SIP_NULLPTR,
        &plugin_QgsPointCloudRgbRenderer,
    },
    {
        sipNameNr_QgsPointCloudRgbRenderer,
        {0, 0, 1},
        25, methods_QgsPointCloudRgbRenderer,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudRgbRenderer,
    -1,
    -1,
    supers_QgsPointCloudRgbRenderer,
    SIP_NULLPTR,
    init_type_QgsPointCloudRgbRenderer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudRgbRenderer,
    SIP_NULLPTR,
    array_QgsPointCloudRgbRenderer,
    SIP_NULLPTR,
    release_QgsPointCloudRgbRenderer,
    cast_QgsPointCloudRgbRenderer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsPointCloudRgbRenderer,
    sizeof (::QgsPointCloudRgbRenderer),
};

#line 124 "auto_generated/pointcloud/qgspointcloudrendererregistry.sip"
#include "qgspointcloudrendererregistry.h"
#line 6468 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 38 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 6472 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 23 "auto_generated/pointcloud/qgspointcloudclassifiedrenderer.sip"
#include "qgspointcloudclassifiedrenderer.h"
#line 6475 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "auto_generated/pointcloud/qgspointcloudlayer.sip"
#include "qgspointcloudlayer.h"
#line 6478 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 179 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 6481 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 36 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 6484 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "auto_generated/pointcloud/qgspointcloudrendererregistry.sip"
#include "qgspointcloudrendererregistry.h"
#line 6487 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 6490 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


PyDoc_STRVAR(doc_QgsPointCloudRendererRegistry_addRenderer, "addRenderer(self, metadata: Optional[QgsPointCloudRendererAbstractMetadata]) -> bool\n"
"Adds a renderer to the registry. Takes ownership of the metadata object.\n"
"\n"
":param metadata: renderer metadata\n"
"\n"
":return: ``True`` if renderer was added successfully, or ``False`` if\n"
"         renderer could not be added (e.g., a renderer with a duplicate\n"
"         name already exists)");

extern "C" {static PyObject *meth_QgsPointCloudRendererRegistry_addRenderer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererRegistry_addRenderer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRendererAbstractMetadata* a0;
        ::QgsPointCloudRendererRegistry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_metadata,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_QgsPointCloudRendererRegistry, &sipCpp, sipType_QgsPointCloudRendererAbstractMetadata, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->addRenderer(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererRegistry, sipName_addRenderer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRendererRegistry_removeRenderer, "removeRenderer(self, rendererName: Optional[str]) -> bool\n"
"Removes a renderer from registry.\n"
"\n"
":param rendererName: name of renderer to remove from registry\n"
"\n"
":return: ``True`` if renderer was successfully removed, or ``False`` if\n"
"         matching renderer could not be found");

extern "C" {static PyObject *meth_QgsPointCloudRendererRegistry_removeRenderer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererRegistry_removeRenderer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QgsPointCloudRendererRegistry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rendererName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudRendererRegistry, &sipCpp, sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->removeRenderer(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererRegistry, sipName_removeRenderer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRendererRegistry_rendererMetadata, "rendererMetadata(self, rendererName: Optional[str]) -> Optional[QgsPointCloudRendererAbstractMetadata]\n"
"Returns the metadata for a specified renderer. Returns ``None`` if a\n"
"matching renderer was not found in the registry.");

extern "C" {static PyObject *meth_QgsPointCloudRendererRegistry_rendererMetadata(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererRegistry_rendererMetadata(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QgsPointCloudRendererRegistry *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rendererName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudRendererRegistry, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QgsPointCloudRendererAbstractMetadata*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->rendererMetadata(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromType(sipRes, sipType_QgsPointCloudRendererAbstractMetadata, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererRegistry, sipName_rendererMetadata, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRendererRegistry_renderersList, "renderersList(self) -> list[str]\n"
"Returns a list of available renderers.");

extern "C" {static PyObject *meth_QgsPointCloudRendererRegistry_renderersList(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererRegistry_renderersList(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRendererRegistry *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRendererRegistry, &sipCpp))
        {
            ::QStringList*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QStringList(sipCpp->renderersList());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererRegistry, sipName_renderersList, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRendererRegistry_defaultRenderer, "defaultRenderer(layer: Optional[QgsPointCloudLayer]) -> Optional[QgsPointCloudRenderer]\n"
"Returns a new default point cloud renderer for a specified ``layer``.\n"
"\n"
"Caller takes ownership of the returned renderer.");

extern "C" {static PyObject *meth_QgsPointCloudRendererRegistry_defaultRenderer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererRegistry_defaultRenderer(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayer* a0;

        static const char *sipKwdList[] = {
            sipName_layer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8", sipType_QgsPointCloudLayer, &a0))
        {
            ::QgsPointCloudRenderer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = ::QgsPointCloudRendererRegistry::defaultRenderer(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererRegistry, sipName_defaultRenderer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRendererRegistry_classificationAttributeCategories, "classificationAttributeCategories(layer: Optional[QgsPointCloudLayer]) -> list[QgsPointCloudCategory]\n"
"Returns a list of categories using the available Classification classes\n"
"of a specified ``layer``, along with default colors and translated names\n"
"for the 19 classes (0-18) of point data record formats 6-10");

extern "C" {static PyObject *meth_QgsPointCloudRendererRegistry_classificationAttributeCategories(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererRegistry_classificationAttributeCategories(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayer* a0;

        static const char *sipKwdList[] = {
            sipName_layer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8", sipType_QgsPointCloudLayer, &a0))
        {
            ::QgsPointCloudCategoryList*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudCategoryList(::QgsPointCloudRendererRegistry::classificationAttributeCategories(a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QList_0100QgsPointCloudCategory, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererRegistry, sipName_classificationAttributeCategories, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudRendererRegistry(void *, int);}
static void release_QgsPointCloudRendererRegistry(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsPointCloudRendererRegistry *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsPointCloudRendererRegistry(Py_ssize_t);}
static void *array_QgsPointCloudRendererRegistry(Py_ssize_t sipNrElem)
{
    return new ::QgsPointCloudRendererRegistry[sipNrElem];
}


extern "C" {static void array_delete_QgsPointCloudRendererRegistry(void *);}
static void array_delete_QgsPointCloudRendererRegistry(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsPointCloudRendererRegistry *>(sipCpp);
}


extern "C" {static void dealloc_QgsPointCloudRendererRegistry(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudRendererRegistry(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudRendererRegistry(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsPointCloudRendererRegistry(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudRendererRegistry(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsPointCloudRendererRegistry *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudRendererRegistry();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsPointCloudRendererRegistry[] = {
    {sipName_addRenderer, SIP_MLMETH_CAST(meth_QgsPointCloudRendererRegistry_addRenderer), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRendererRegistry_addRenderer},
    {sipName_classificationAttributeCategories, SIP_MLMETH_CAST(meth_QgsPointCloudRendererRegistry_classificationAttributeCategories), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRendererRegistry_classificationAttributeCategories},
    {sipName_defaultRenderer, SIP_MLMETH_CAST(meth_QgsPointCloudRendererRegistry_defaultRenderer), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRendererRegistry_defaultRenderer},
    {sipName_removeRenderer, SIP_MLMETH_CAST(meth_QgsPointCloudRendererRegistry_removeRenderer), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRendererRegistry_removeRenderer},
    {sipName_rendererMetadata, SIP_MLMETH_CAST(meth_QgsPointCloudRendererRegistry_rendererMetadata), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRendererRegistry_rendererMetadata},
    {sipName_renderersList, meth_QgsPointCloudRendererRegistry_renderersList, METH_VARARGS, doc_QgsPointCloudRendererRegistry_renderersList}
};

PyDoc_STRVAR(doc_QgsPointCloudRendererRegistry, "Registry of 2D renderers for point clouds.\n"
"\n"
":py:class:`QgsPointCloudRendererRegistry` is not usually directly\n"
"created, but rather accessed through\n"
":py:func:`QgsApplication.pointCloudRendererRegistry()`.\n"
"\n"
".. versionadded:: 3.18\n"
"");


static pyqt5ClassPluginDef plugin_QgsPointCloudRendererRegistry = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudRendererRegistry = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudRendererRegistry,
        SIP_NULLPTR,
        &plugin_QgsPointCloudRendererRegistry,
    },
    {
        sipNameNr_QgsPointCloudRendererRegistry,
        {0, 0, 1},
        6, methods_QgsPointCloudRendererRegistry,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudRendererRegistry,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsPointCloudRendererRegistry,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudRendererRegistry,
    SIP_NULLPTR,
    array_QgsPointCloudRendererRegistry,
    SIP_NULLPTR,
    release_QgsPointCloudRendererRegistry,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsPointCloudRendererRegistry,
    sizeof (::QgsPointCloudRendererRegistry),
};

#line 94 "auto_generated/pointcloud/qgspointcloudrendererregistry.sip"
#include "qgspointcloudrendererregistry.h"
#line 6967 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 179 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 6971 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 312 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 6974 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 21 "auto_generated/qgsreadwritecontext.sip"
#include "qgsreadwritecontext.h"
#line 6977 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtGui/qicon.sip"
#include <qicon.h>
#line 6980 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 6983 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


class sipQgsPointCloudRendererMetadata : public ::QgsPointCloudRendererMetadata
{
public:
    sipQgsPointCloudRendererMetadata(const ::QgsPointCloudRendererMetadata&);
    virtual ~sipQgsPointCloudRendererMetadata();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::QgsPointCloudRenderer* createRenderer(::QDomElement&, const ::QgsReadWriteContext&) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQgsPointCloudRendererMetadata(const sipQgsPointCloudRendererMetadata &);
    sipQgsPointCloudRendererMetadata &operator = (const sipQgsPointCloudRendererMetadata &);

    char sipPyMethods[1];
};

sipQgsPointCloudRendererMetadata::sipQgsPointCloudRendererMetadata(const ::QgsPointCloudRendererMetadata& a0): ::QgsPointCloudRendererMetadata(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsPointCloudRendererMetadata::~sipQgsPointCloudRendererMetadata()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::QgsPointCloudRenderer* sipQgsPointCloudRendererMetadata::createRenderer(::QDomElement& a0, const ::QgsReadWriteContext& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_createRenderer);

    if (!sipMeth)
        return ::QgsPointCloudRendererMetadata::createRenderer(a0, a1);

    extern ::QgsPointCloudRenderer* sipVH__core_753(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomElement&, const ::QgsReadWriteContext&);

    return sipVH__core_753(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}


PyDoc_STRVAR(doc_QgsPointCloudRendererMetadata_createRenderer, "createRenderer(self, elem: QDomElement, context: QgsReadWriteContext) -> Optional[QgsPointCloudRenderer]");

extern "C" {static PyObject *meth_QgsPointCloudRendererMetadata_createRenderer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererMetadata_createRenderer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;
        ::QgsPointCloudRendererMetadata *sipCpp;

        static const char *sipKwdList[] = {
            sipName_elem,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudRendererMetadata, &sipCpp, sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            ::QgsPointCloudRenderer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudRendererMetadata::createRenderer(*a0, *a1) : sipCpp->createRenderer(*a0, *a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererMetadata, sipName_createRenderer, doc_QgsPointCloudRendererMetadata_createRenderer);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QgsPointCloudRendererMetadata(void *, const sipTypeDef *);}
static void *cast_QgsPointCloudRendererMetadata(void *sipCppV, const sipTypeDef *targetType)
{
    ::QgsPointCloudRendererMetadata *sipCpp = reinterpret_cast< ::QgsPointCloudRendererMetadata *>(sipCppV);

    if (targetType == sipType_QgsPointCloudRendererMetadata)
        return sipCppV;

    if (targetType == sipType_QgsPointCloudRendererAbstractMetadata)
        return static_cast< ::QgsPointCloudRendererAbstractMetadata *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudRendererMetadata(void *, int);}
static void release_QgsPointCloudRendererMetadata(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQgsPointCloudRendererMetadata *>(sipCppV);
    else
        delete reinterpret_cast< ::QgsPointCloudRendererMetadata *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QgsPointCloudRendererMetadata(void *, Py_ssize_t, void *);}
static void assign_QgsPointCloudRendererMetadata(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsPointCloudRendererMetadata *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsPointCloudRendererMetadata *>(sipSrc);
}


extern "C" {static void *copy_QgsPointCloudRendererMetadata(const void *, Py_ssize_t);}
static void *copy_QgsPointCloudRendererMetadata(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsPointCloudRendererMetadata(reinterpret_cast<const ::QgsPointCloudRendererMetadata *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsPointCloudRendererMetadata(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudRendererMetadata(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQgsPointCloudRendererMetadata *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudRendererMetadata(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QgsPointCloudRendererMetadata(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudRendererMetadata(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQgsPointCloudRendererMetadata *sipCpp = SIP_NULLPTR;

    {
        const ::QgsPointCloudRendererMetadata* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsPointCloudRendererMetadata, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsPointCloudRendererMetadata(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QgsPointCloudRendererMetadata[] = {{1810, 255, 1}};


static PyMethodDef methods_QgsPointCloudRendererMetadata[] = {
    {sipName_createRenderer, SIP_MLMETH_CAST(meth_QgsPointCloudRendererMetadata_createRenderer), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRendererMetadata_createRenderer}
};

PyDoc_STRVAR(doc_QgsPointCloudRendererMetadata, "Convenience metadata class that uses static functions to create point\n"
"cloud renderer and its widget.\n"
"\n"
".. versionadded:: 3.18\n"
"");


static pyqt5ClassPluginDef plugin_QgsPointCloudRendererMetadata = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudRendererMetadata = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudRendererMetadata,
        SIP_NULLPTR,
        &plugin_QgsPointCloudRendererMetadata,
    },
    {
        sipNameNr_QgsPointCloudRendererMetadata,
        {0, 0, 1},
        1, methods_QgsPointCloudRendererMetadata,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudRendererMetadata,
    -1,
    -1,
    supers_QgsPointCloudRendererMetadata,
    SIP_NULLPTR,
    init_type_QgsPointCloudRendererMetadata,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudRendererMetadata,
    assign_QgsPointCloudRendererMetadata,
    SIP_NULLPTR,
    copy_QgsPointCloudRendererMetadata,
    release_QgsPointCloudRendererMetadata,
    cast_QgsPointCloudRendererMetadata,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsPointCloudRendererMetadata),
};

#line 26 "auto_generated/pointcloud/qgspointcloudrendererregistry.sip"
#include "qgspointcloudrendererregistry.h"
#line 7258 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 7262 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtGui/qicon.sip"
#include <qicon.h>
#line 7265 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 179 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 7268 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 312 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 7271 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 21 "auto_generated/qgsreadwritecontext.sip"
#include "qgsreadwritecontext.h"
#line 7274 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


class sipQgsPointCloudRendererAbstractMetadata : public ::QgsPointCloudRendererAbstractMetadata
{
public:
    sipQgsPointCloudRendererAbstractMetadata(const ::QString&, const ::QString&, const ::QIcon&);
    sipQgsPointCloudRendererAbstractMetadata(const ::QgsPointCloudRendererAbstractMetadata&);
    virtual ~sipQgsPointCloudRendererAbstractMetadata();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::QgsPointCloudRenderer* createRenderer(::QDomElement&, const ::QgsReadWriteContext&) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQgsPointCloudRendererAbstractMetadata(const sipQgsPointCloudRendererAbstractMetadata &);
    sipQgsPointCloudRendererAbstractMetadata &operator = (const sipQgsPointCloudRendererAbstractMetadata &);

    char sipPyMethods[1];
};

sipQgsPointCloudRendererAbstractMetadata::sipQgsPointCloudRendererAbstractMetadata(const ::QString& a0, const ::QString& a1, const ::QIcon& a2): ::QgsPointCloudRendererAbstractMetadata(a0, a1, a2), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsPointCloudRendererAbstractMetadata::sipQgsPointCloudRendererAbstractMetadata(const ::QgsPointCloudRendererAbstractMetadata& a0): ::QgsPointCloudRendererAbstractMetadata(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsPointCloudRendererAbstractMetadata::~sipQgsPointCloudRendererAbstractMetadata()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::QgsPointCloudRenderer* sipQgsPointCloudRendererAbstractMetadata::createRenderer(::QDomElement& a0, const ::QgsReadWriteContext& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, sipName_QgsPointCloudRendererAbstractMetadata, sipName_createRenderer);

    if (!sipMeth)
        return 0;

    extern ::QgsPointCloudRenderer* sipVH__core_753(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomElement&, const ::QgsReadWriteContext&);

    return sipVH__core_753(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}


PyDoc_STRVAR(doc_QgsPointCloudRendererAbstractMetadata_name, "name(self) -> str\n"
"Returns the unique name of the renderer. This value is not translated.\n"
"\n"
".. seealso:: :py:func:`visibleName`");

extern "C" {static PyObject *meth_QgsPointCloudRendererAbstractMetadata_name(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererAbstractMetadata_name(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRendererAbstractMetadata *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRendererAbstractMetadata, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->name());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererAbstractMetadata, sipName_name, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRendererAbstractMetadata_visibleName, "visibleName(self) -> str\n"
"Returns a friendly display name of the renderer. This value is\n"
"translated.\n"
"\n"
".. seealso:: :py:func:`name`");

extern "C" {static PyObject *meth_QgsPointCloudRendererAbstractMetadata_visibleName(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererAbstractMetadata_visibleName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRendererAbstractMetadata *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRendererAbstractMetadata, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->visibleName());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererAbstractMetadata, sipName_visibleName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRendererAbstractMetadata_icon, "icon(self) -> QIcon\n"
"Returns an icon representing the renderer.\n"
"\n"
".. seealso:: :py:func:`setIcon`");

extern "C" {static PyObject *meth_QgsPointCloudRendererAbstractMetadata_icon(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererAbstractMetadata_icon(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRendererAbstractMetadata *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRendererAbstractMetadata, &sipCpp))
        {
            ::QIcon*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QIcon(sipCpp->icon());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QIcon, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererAbstractMetadata, sipName_icon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRendererAbstractMetadata_setIcon, "setIcon(self, icon: QIcon)\n"
"Sets an ``icon`` representing the renderer.\n"
"\n"
".. seealso:: :py:func:`icon`");

extern "C" {static PyObject *meth_QgsPointCloudRendererAbstractMetadata_setIcon(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererAbstractMetadata_setIcon(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QIcon* a0;
        ::QgsPointCloudRendererAbstractMetadata *sipCpp;

        static const char *sipKwdList[] = {
            sipName_icon,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudRendererAbstractMetadata, &sipCpp, sipType_QIcon, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setIcon(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererAbstractMetadata, sipName_setIcon, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRendererAbstractMetadata_createRenderer, "createRenderer(self, elem: QDomElement, context: QgsReadWriteContext) -> Optional[QgsPointCloudRenderer]\n"
"Returns new instance of the renderer given the DOM element. Returns\n"
"``None`` on error. Pure virtual function: must be implemented in derived\n"
"classes.");

extern "C" {static PyObject *meth_QgsPointCloudRendererAbstractMetadata_createRenderer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRendererAbstractMetadata_createRenderer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;
        ::QgsPointCloudRendererAbstractMetadata *sipCpp;

        static const char *sipKwdList[] = {
            sipName_elem,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudRendererAbstractMetadata, &sipCpp, sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            ::QgsPointCloudRenderer*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_QgsPointCloudRendererAbstractMetadata, sipName_createRenderer);
                return SIP_NULLPTR;
            }

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->createRenderer(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRendererAbstractMetadata, sipName_createRenderer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudRendererAbstractMetadata(void *, int);}
static void release_QgsPointCloudRendererAbstractMetadata(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQgsPointCloudRendererAbstractMetadata *>(sipCppV);
    else
        delete reinterpret_cast< ::QgsPointCloudRendererAbstractMetadata *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QgsPointCloudRendererAbstractMetadata(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudRendererAbstractMetadata(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQgsPointCloudRendererAbstractMetadata *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudRendererAbstractMetadata(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QgsPointCloudRendererAbstractMetadata(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudRendererAbstractMetadata(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQgsPointCloudRendererAbstractMetadata *sipCpp = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        const ::QIcon& a2def = QIcon();
        const ::QIcon* a2 = &a2def;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_visibleName,
            sipName_icon,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1|J9", sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QIcon, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsPointCloudRendererAbstractMetadata(*a0, *a1, *a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::QgsPointCloudRendererAbstractMetadata* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsPointCloudRendererAbstractMetadata, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsPointCloudRendererAbstractMetadata(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsPointCloudRendererAbstractMetadata[] = {
    {sipName_createRenderer, SIP_MLMETH_CAST(meth_QgsPointCloudRendererAbstractMetadata_createRenderer), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRendererAbstractMetadata_createRenderer},
    {sipName_icon, meth_QgsPointCloudRendererAbstractMetadata_icon, METH_VARARGS, doc_QgsPointCloudRendererAbstractMetadata_icon},
    {sipName_name, meth_QgsPointCloudRendererAbstractMetadata_name, METH_VARARGS, doc_QgsPointCloudRendererAbstractMetadata_name},
    {sipName_setIcon, SIP_MLMETH_CAST(meth_QgsPointCloudRendererAbstractMetadata_setIcon), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRendererAbstractMetadata_setIcon},
    {sipName_visibleName, meth_QgsPointCloudRendererAbstractMetadata_visibleName, METH_VARARGS, doc_QgsPointCloudRendererAbstractMetadata_visibleName}
};

PyDoc_STRVAR(doc_QgsPointCloudRendererAbstractMetadata, "Stores metadata about one point cloud renderer class.\n"
"\n"
".. note::\n"
"\n"
"   It's necessary to implement :py:func:`~createRenderer` function.\n"
"   In C++ you can use :py:class:`QgsPointCloudRendererMetadata` convenience class.\n"
"\n"
".. versionadded:: 3.18\n"
"\n"
"QgsPointCloudRendererAbstractMetadata(name: Optional[str], visibleName: Optional[str], icon: QIcon = QIcon())\n"
"Constructor for QgsPointCloudRendererAbstractMetadata, with the\n"
"specified ``name``.\n"
"\n"
"The ``visibleName`` argument gives a translated, user friendly string\n"
"identifying the renderer type.\n"
"\n"
"The ``icon`` argument can be used to specify an icon representing the\n"
"renderer.\n"
"\n"
"QgsPointCloudRendererAbstractMetadata(a0: QgsPointCloudRendererAbstractMetadata)");


static pyqt5ClassPluginDef plugin_QgsPointCloudRendererAbstractMetadata = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudRendererAbstractMetadata = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudRendererAbstractMetadata,
        SIP_NULLPTR,
        &plugin_QgsPointCloudRendererAbstractMetadata,
    },
    {
        sipNameNr_QgsPointCloudRendererAbstractMetadata,
        {0, 0, 1},
        5, methods_QgsPointCloudRendererAbstractMetadata,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudRendererAbstractMetadata,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsPointCloudRendererAbstractMetadata,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudRendererAbstractMetadata,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QgsPointCloudRendererAbstractMetadata,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsPointCloudRendererAbstractMetadata),
};

#line 24 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 7798 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 26 "auto_generated/qgsrendercontext.sip"
#include "qgsrendercontext.h"
#line 7802 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 20 "auto_generated/qgsvector3d.sip"
#include "qgsvector3d.h"
#line 7805 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 38 "auto_generated/qgsfeedback.sip"
#include "qgsfeedback.h"
#line 7808 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 106 "auto_generated/pointcloud/qgspointcloudattribute.sip"
#include "qgspointcloudattribute.h"
#line 7811 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_renderContext, "renderContext(self) -> QgsRenderContext\n"
"Returns a reference to the context's render context.");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_renderContext(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_renderContext(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            ::QgsRenderContext*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = &sipCpp->renderContext();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsRenderContext, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_renderContext, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_scale, "scale(self) -> QgsVector3D\n"
"Returns the scale of the layer's int32 coordinates compared to CRS\n"
"coords.");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_scale(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_scale(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            ::QgsVector3D*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsVector3D(sipCpp->scale());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_scale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_setScale, "setScale(self, scale: QgsVector3D)\n"
"Sets the scale of the layer's int32 coordinates compared to CRS coords.\n"
"\n"
".. versionadded:: 3.20");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_setScale(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_setScale(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsVector3D* a0;
        ::QgsPointCloudRenderContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_scale,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp, sipType_QgsVector3D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setScale(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_setScale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_offset, "offset(self) -> QgsVector3D\n"
"Returns the offset of the layer's int32 coordinates compared to CRS\n"
"coords.");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_offset(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_offset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            ::QgsVector3D*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsVector3D(sipCpp->offset());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_offset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_setOffset, "setOffset(self, offset: QgsVector3D)\n"
"Sets the offset of the layer's int32 coordinates compared to CRS coords.\n"
"\n"
".. versionadded:: 3.20");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_setOffset(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_setOffset(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsVector3D* a0;
        ::QgsPointCloudRenderContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_offset,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp, sipType_QgsVector3D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setOffset(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_setOffset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_pointsRendered, "pointsRendered(self) -> int\n"
"Returns the total number of points rendered.");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_pointsRendered(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_pointsRendered(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointsRendered();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_pointsRendered, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_incrementPointsRendered, "incrementPointsRendered(self, count: int)\n"
"Increments the count of points rendered by the specified amount.\n"
"\n"
"It is a point cloud renderer's responsibility to correctly call this\n"
"after rendering a block of points.");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_incrementPointsRendered(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_incrementPointsRendered(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long a0;
        ::QgsPointCloudRenderContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_count,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->incrementPointsRendered(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_incrementPointsRendered, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_attributes, "attributes(self) -> QgsPointCloudAttributeCollection\n"
"Returns the attributes associated with the rendered block.\n"
"\n"
".. seealso:: :py:func:`setAttributes`");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_attributes(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_attributes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            ::QgsPointCloudAttributeCollection*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudAttributeCollection(sipCpp->attributes());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudAttributeCollection, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_attributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_setAttributes, "setAttributes(self, attributes: QgsPointCloudAttributeCollection)\n"
"Sets the ``attributes`` associated with the rendered block.\n"
"\n"
".. seealso:: :py:func:`attributes`");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_setAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_setAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudAttributeCollection* a0;
        ::QgsPointCloudRenderContext *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attributes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp, sipType_QgsPointCloudAttributeCollection, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setAttributes(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_setAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_pointRecordSize, "pointRecordSize(self) -> int\n"
"Returns the size of a single point record.");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_pointRecordSize(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_pointRecordSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointRecordSize();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_pointRecordSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_xOffset, "xOffset(self) -> int\n"
"Returns the offset for the x value in a point record.\n"
"\n"
".. seealso:: :py:func:`yOffset`\n"
"\n"
".. seealso:: :py:func:`zOffset`");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_xOffset(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_xOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->xOffset();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_xOffset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_yOffset, "yOffset(self) -> int\n"
"Returns the offset for the y value in a point record.\n"
"\n"
".. seealso:: :py:func:`xOffset`\n"
"\n"
".. seealso:: :py:func:`zOffset`");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_yOffset(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_yOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->yOffset();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_yOffset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_zOffset, "zOffset(self) -> int\n"
"Returns the offset for the y value in a point record.\n"
"\n"
".. seealso:: :py:func:`xOffset`\n"
"\n"
".. seealso:: :py:func:`yOffset`");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_zOffset(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_zOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->zOffset();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_zOffset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_zValueScale, "zValueScale(self) -> float\n"
"Returns any constant scaling factor which must be applied to z values\n"
"taken from the point cloud index.\n"
"\n"
".. note::\n"
"\n"
"   Scaling of z values should be applied before the :py:func:`~QgsPointCloudRenderContext.zValueFixedOffset`.");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_zValueScale(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_zValueScale(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->zValueScale();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_zValueScale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_zValueFixedOffset, "zValueFixedOffset(self) -> float\n"
"Returns any constant offset which must be applied to z values taken from\n"
"the point cloud index.\n"
"\n"
".. note::\n"
"\n"
"   Scaling of z values via :py:func:`~QgsPointCloudRenderContext.zValueScale` should be applied before the :py:func:`~QgsPointCloudRenderContext.zValueFixedOffset`.");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_zValueFixedOffset(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_zValueFixedOffset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->zValueFixedOffset();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_zValueFixedOffset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudRenderContext_feedback, "feedback(self) -> Optional[QgsFeedback]\n"
"Returns the feedback object used to cancel rendering\n"
"\n"
".. versionadded:: 3.20");

extern "C" {static PyObject *meth_QgsPointCloudRenderContext_feedback(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudRenderContext_feedback(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudRenderContext *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudRenderContext, &sipCpp))
        {
            ::QgsFeedback*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->feedback();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsFeedback, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudRenderContext, sipName_feedback, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudRenderContext(void *, int);}
static void release_QgsPointCloudRenderContext(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsPointCloudRenderContext *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QgsPointCloudRenderContext(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudRenderContext(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudRenderContext(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsPointCloudRenderContext(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudRenderContext(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsPointCloudRenderContext *sipCpp = SIP_NULLPTR;

    {
        ::QgsRenderContext* a0;
        const ::QgsVector3D* a1;
        const ::QgsVector3D* a2;
        double a3;
        double a4;
        ::QgsFeedback* a5 = 0;

        static const char *sipKwdList[] = {
            sipName_context,
            sipName_scale,
            sipName_offset,
            sipName_zValueScale,
            sipName_zValueFixedOffset,
            sipName_feedback,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9J9J9dd|J8", sipType_QgsRenderContext, &a0, sipType_QgsVector3D, &a1, sipType_QgsVector3D, &a2, &a3, &a4, sipType_QgsFeedback, &a5))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudRenderContext(*a0, *a1, *a2, a3, a4, a5);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsPointCloudRenderContext[] = {
    {sipName_attributes, meth_QgsPointCloudRenderContext_attributes, METH_VARARGS, doc_QgsPointCloudRenderContext_attributes},
    {sipName_feedback, meth_QgsPointCloudRenderContext_feedback, METH_VARARGS, doc_QgsPointCloudRenderContext_feedback},
    {sipName_incrementPointsRendered, SIP_MLMETH_CAST(meth_QgsPointCloudRenderContext_incrementPointsRendered), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRenderContext_incrementPointsRendered},
    {sipName_offset, meth_QgsPointCloudRenderContext_offset, METH_VARARGS, doc_QgsPointCloudRenderContext_offset},
    {sipName_pointRecordSize, meth_QgsPointCloudRenderContext_pointRecordSize, METH_VARARGS, doc_QgsPointCloudRenderContext_pointRecordSize},
    {sipName_pointsRendered, meth_QgsPointCloudRenderContext_pointsRendered, METH_VARARGS, doc_QgsPointCloudRenderContext_pointsRendered},
    {sipName_renderContext, meth_QgsPointCloudRenderContext_renderContext, METH_VARARGS, doc_QgsPointCloudRenderContext_renderContext},
    {sipName_scale, meth_QgsPointCloudRenderContext_scale, METH_VARARGS, doc_QgsPointCloudRenderContext_scale},
    {sipName_setAttributes, SIP_MLMETH_CAST(meth_QgsPointCloudRenderContext_setAttributes), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRenderContext_setAttributes},
    {sipName_setOffset, SIP_MLMETH_CAST(meth_QgsPointCloudRenderContext_setOffset), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRenderContext_setOffset},
    {sipName_setScale, SIP_MLMETH_CAST(meth_QgsPointCloudRenderContext_setScale), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudRenderContext_setScale},
    {sipName_xOffset, meth_QgsPointCloudRenderContext_xOffset, METH_VARARGS, doc_QgsPointCloudRenderContext_xOffset},
    {sipName_yOffset, meth_QgsPointCloudRenderContext_yOffset, METH_VARARGS, doc_QgsPointCloudRenderContext_yOffset},
    {sipName_zOffset, meth_QgsPointCloudRenderContext_zOffset, METH_VARARGS, doc_QgsPointCloudRenderContext_zOffset},
    {sipName_zValueFixedOffset, meth_QgsPointCloudRenderContext_zValueFixedOffset, METH_VARARGS, doc_QgsPointCloudRenderContext_zValueFixedOffset},
    {sipName_zValueScale, meth_QgsPointCloudRenderContext_zValueScale, METH_VARARGS, doc_QgsPointCloudRenderContext_zValueScale}
};

PyDoc_STRVAR(doc_QgsPointCloudRenderContext, "Encapsulates the render context for a 2D point cloud rendering\n"
"operation.\n"
"\n"
".. versionadded:: 3.18\n"
"\n"
"QgsPointCloudRenderContext(context: QgsRenderContext, scale: QgsVector3D, offset: QgsVector3D, zValueScale: float, zValueFixedOffset: float, feedback: Optional[QgsFeedback] = None)\n"
"Constructor for QgsPointCloudRenderContext.\n"
"\n"
"The ``scale`` and ``offset`` arguments specify the scale and offset of\n"
"the layer's int32 coordinates compared to CRS coordinates respectively.\n"
"\n"
"The ``zValueScale`` argument specifies any constant scaling factor which\n"
"must be applied to z values taken from the point cloud index.\n"
"\n"
"The ``zValueFixedOffset`` argument specifies any constant offset value\n"
"which must be added to z values taken from the point cloud index.");


static pyqt5ClassPluginDef plugin_QgsPointCloudRenderContext = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudRenderContext = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudRenderContext,
        SIP_NULLPTR,
        &plugin_QgsPointCloudRenderContext,
    },
    {
        sipNameNr_QgsPointCloudRenderContext,
        {0, 0, 1},
        16, methods_QgsPointCloudRenderContext,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudRenderContext,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsPointCloudRenderContext,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudRenderContext,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QgsPointCloudRenderContext,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsPointCloudRenderContext),
};

#line 29 "auto_generated/pointcloud/qgspointclouddataprovider.sip"
#include "qgspointclouddataprovider.h"
#line 8786 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 29 "auto_generated/pointcloud/qgspointclouddataprovider.sip"
#include "qgspointclouddataprovider.h"
#line 8790 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


extern "C" {static long slot_QgsPointCloudDataProvider_Capabilities___hash__(PyObject *);}
static long slot_QgsPointCloudDataProvider_Capabilities___hash__(PyObject *sipSelf)
{
    ::QgsPointCloudDataProvider::Capabilities *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudDataProvider_Capabilities));

    if (!sipCpp)
        return 0L;


    {
        {
            long sipRes = 0;

#line 122 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qglobal.sip"
        sipRes = sipCpp->operator QgsPointCloudDataProvider::Capabilities::Int();
#line 8808 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static int slot_QgsPointCloudDataProvider_Capabilities___bool__(PyObject *);}
static int slot_QgsPointCloudDataProvider_Capabilities___bool__(PyObject *sipSelf)
{
    ::QgsPointCloudDataProvider::Capabilities *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudDataProvider_Capabilities));

    if (!sipCpp)
        return -1;


    {
        {
            int sipRes = 0;

#line 117 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qglobal.sip"
        sipRes = (sipCpp->operator QgsPointCloudDataProvider::Capabilities::Int() != 0);
#line 8833 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            return sipRes;
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QgsPointCloudDataProvider_Capabilities___ne__(PyObject *, PyObject *);}
static PyObject *slot_QgsPointCloudDataProvider_Capabilities___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QgsPointCloudDataProvider::Capabilities *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudDataProvider_Capabilities));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudDataProvider::Capabilities* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QgsPointCloudDataProvider_Capabilities, &a0, &a0State))
        {
            bool sipRes = 0;

#line 112 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qglobal.sip"
        sipRes = (sipCpp->operator QgsPointCloudDataProvider::Capabilities::Int() != a0->operator QgsPointCloudDataProvider::Capabilities::Int());
#line 8863 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
            sipReleaseType(const_cast< ::QgsPointCloudDataProvider::Capabilities *>(a0), sipType_QgsPointCloudDataProvider_Capabilities, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_QgsPointCloudDataProvider_Capabilities, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QgsPointCloudDataProvider_Capabilities___eq__(PyObject *, PyObject *);}
static PyObject *slot_QgsPointCloudDataProvider_Capabilities___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QgsPointCloudDataProvider::Capabilities *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudDataProvider_Capabilities));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudDataProvider::Capabilities* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J1", sipType_QgsPointCloudDataProvider_Capabilities, &a0, &a0State))
        {
            bool sipRes = 0;

#line 107 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qglobal.sip"
        sipRes = (sipCpp->operator QgsPointCloudDataProvider::Capabilities::Int() == a0->operator QgsPointCloudDataProvider::Capabilities::Int());
#line 8896 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
            sipReleaseType(const_cast< ::QgsPointCloudDataProvider::Capabilities *>(a0), sipType_QgsPointCloudDataProvider_Capabilities, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_QgsPointCloudDataProvider_Capabilities, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QgsPointCloudDataProvider_Capabilities___ixor__(PyObject *, PyObject *);}
static PyObject *slot_QgsPointCloudDataProvider_Capabilities___ixor__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QgsPointCloudDataProvider_Capabilities)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QgsPointCloudDataProvider::Capabilities *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudDataProvider_Capabilities));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
#line 101 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qglobal.sip"
        *sipCpp = QgsPointCloudDataProvider::Capabilities(*sipCpp ^ a0);
#line 8932 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QgsPointCloudDataProvider_Capabilities___xor__(PyObject *, PyObject *);}
static PyObject *slot_QgsPointCloudDataProvider_Capabilities___xor__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudDataProvider::Capabilities* a0;
        int a0State = 0;
        int a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1i", sipType_QgsPointCloudDataProvider_Capabilities, &a0, &a0State, &a1))
        {
            ::QgsPointCloudDataProvider::Capabilities*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudDataProvider::Capabilities((*a0 ^ a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(a0, sipType_QgsPointCloudDataProvider_Capabilities, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(a0, sipType_QgsPointCloudDataProvider_Capabilities, a0State);

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudDataProvider_Capabilities, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, xor_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QgsPointCloudDataProvider_Capabilities___ior__(PyObject *, PyObject *);}
static PyObject *slot_QgsPointCloudDataProvider_Capabilities___ior__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QgsPointCloudDataProvider_Capabilities)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QgsPointCloudDataProvider::Capabilities *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudDataProvider_Capabilities));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
#line 95 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qglobal.sip"
        *sipCpp = QgsPointCloudDataProvider::Capabilities(*sipCpp | a0);
#line 9025 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QgsPointCloudDataProvider_Capabilities___or__(PyObject *, PyObject *);}
static PyObject *slot_QgsPointCloudDataProvider_Capabilities___or__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudDataProvider::Capabilities* a0;
        int a0State = 0;
        int a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1i", sipType_QgsPointCloudDataProvider_Capabilities, &a0, &a0State, &a1))
        {
            ::QgsPointCloudDataProvider::Capabilities*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudDataProvider::Capabilities((*a0 | a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(a0, sipType_QgsPointCloudDataProvider_Capabilities, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(a0, sipType_QgsPointCloudDataProvider_Capabilities, a0State);

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudDataProvider_Capabilities, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, or_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QgsPointCloudDataProvider_Capabilities___iand__(PyObject *, PyObject *);}
static PyObject *slot_QgsPointCloudDataProvider_Capabilities___iand__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QgsPointCloudDataProvider_Capabilities)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QgsPointCloudDataProvider::Capabilities *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudDataProvider_Capabilities));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->::QgsPointCloudDataProvider::Capabilities::operator&=(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QgsPointCloudDataProvider_Capabilities___and__(PyObject *, PyObject *);}
static PyObject *slot_QgsPointCloudDataProvider_Capabilities___and__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudDataProvider::Capabilities* a0;
        int a0State = 0;
        int a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J1i", sipType_QgsPointCloudDataProvider_Capabilities, &a0, &a0State, &a1))
        {
            ::QgsPointCloudDataProvider::Capabilities*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudDataProvider::Capabilities((*a0 & a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(a0, sipType_QgsPointCloudDataProvider_Capabilities, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(a0, sipType_QgsPointCloudDataProvider_Capabilities, a0State);

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudDataProvider_Capabilities, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, and_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QgsPointCloudDataProvider_Capabilities___invert__(PyObject *);}
static PyObject *slot_QgsPointCloudDataProvider_Capabilities___invert__(PyObject *sipSelf)
{
    ::QgsPointCloudDataProvider::Capabilities *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudDataProvider_Capabilities));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            ::QgsPointCloudDataProvider::Capabilities*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudDataProvider::Capabilities(~(*sipCpp));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudDataProvider_Capabilities, SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QgsPointCloudDataProvider_Capabilities___index__(PyObject *);}
static PyObject *slot_QgsPointCloudDataProvider_Capabilities___index__(PyObject *sipSelf)
{
    ::QgsPointCloudDataProvider::Capabilities *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudDataProvider_Capabilities));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            int sipRes = 0;

#line 84 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qglobal.sip"
        sipRes = sipCpp->operator QgsPointCloudDataProvider::Capabilities::Int();
#line 9264 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            return PyLong_FromLong(sipRes);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QgsPointCloudDataProvider_Capabilities___int__(PyObject *);}
static PyObject *slot_QgsPointCloudDataProvider_Capabilities___int__(PyObject *sipSelf)
{
    ::QgsPointCloudDataProvider::Capabilities *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudDataProvider_Capabilities));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = int(*sipCpp);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudDataProvider_Capabilities(void *, int);}
static void release_QgsPointCloudDataProvider_Capabilities(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsPointCloudDataProvider_Capabilities(Py_ssize_t);}
static void *array_QgsPointCloudDataProvider_Capabilities(Py_ssize_t sipNrElem)
{
    return new ::QgsPointCloudDataProvider::Capabilities[sipNrElem];
}


extern "C" {static void array_delete_QgsPointCloudDataProvider_Capabilities(void *);}
static void array_delete_QgsPointCloudDataProvider_Capabilities(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipCpp);
}


extern "C" {static void assign_QgsPointCloudDataProvider_Capabilities(void *, Py_ssize_t, void *);}
static void assign_QgsPointCloudDataProvider_Capabilities(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities *>(sipSrc);
}


extern "C" {static void *copy_QgsPointCloudDataProvider_Capabilities(const void *, Py_ssize_t);}
static void *copy_QgsPointCloudDataProvider_Capabilities(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsPointCloudDataProvider::Capabilities(reinterpret_cast<const ::QgsPointCloudDataProvider::Capabilities *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsPointCloudDataProvider_Capabilities(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudDataProvider_Capabilities(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudDataProvider_Capabilities(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsPointCloudDataProvider_Capabilities(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudDataProvider_Capabilities(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsPointCloudDataProvider::Capabilities *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudDataProvider::Capabilities();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        int a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "i", &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudDataProvider::Capabilities(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsPointCloudDataProvider::Capabilities* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QgsPointCloudDataProvider_Capabilities, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudDataProvider::Capabilities(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QgsPointCloudDataProvider::Capabilities *>(a0), sipType_QgsPointCloudDataProvider_Capabilities, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QgsPointCloudDataProvider::Capabilities *>(a0), sipType_QgsPointCloudDataProvider_Capabilities, a0State);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static int convertTo_QgsPointCloudDataProvider_Capabilities(PyObject *, void **, int *, PyObject *);}
static int convertTo_QgsPointCloudDataProvider_Capabilities(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::QgsPointCloudDataProvider::Capabilities **sipCppPtr = reinterpret_cast< ::QgsPointCloudDataProvider::Capabilities **>(sipCppPtrV);

#line 127 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qglobal.sip"
// Allow an instance of the base enum whenever a QgsPointCloudDataProvider::Capabilities is expected.

if (sipIsErr == NULL)
    return (PyObject_TypeCheck(sipPy, sipTypeAsPyTypeObject(sipType_QgsPointCloudDataProvider_Capability)) ||
            sipCanConvertToType(sipPy, sipType_QgsPointCloudDataProvider_Capabilities, SIP_NO_CONVERTORS));

if (PyObject_TypeCheck(sipPy, sipTypeAsPyTypeObject(sipType_QgsPointCloudDataProvider_Capability)))
{
    *sipCppPtr = new QgsPointCloudDataProvider::Capabilities(int(SIPLong_AsLong(sipPy)));

    return sipGetState(sipTransferObj);
}

*sipCppPtr = reinterpret_cast<QgsPointCloudDataProvider::Capabilities *>(sipConvertToType(sipPy, sipType_QgsPointCloudDataProvider_Capabilities, sipTransferObj, SIP_NO_CONVERTORS, 0, sipIsErr));

return 0;
#line 9492 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QgsPointCloudDataProvider_Capabilities[] = {
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___hash__, hash_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___bool__, bool_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___ne__, ne_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___eq__, eq_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___ixor__, ixor_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___xor__, xor_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___ior__, ior_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___or__, or_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___iand__, iand_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___and__, and_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___invert__, invert_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___index__, index_slot},
    {(void *)slot_QgsPointCloudDataProvider_Capabilities___int__, int_slot},
    {0, (sipPySlotType)0}
};

PyDoc_STRVAR(doc_QgsPointCloudDataProvider_Capabilities, "\1QgsPointCloudDataProvider.Capabilities()\n"
"QgsPointCloudDataProvider.Capabilities(f: Union[QgsPointCloudDataProvider.Capabilities, QgsPointCloudDataProvider.Capability])\n"
"QgsPointCloudDataProvider.Capabilities(a0: QgsPointCloudDataProvider.Capabilities)");


static pyqt5ClassPluginDef plugin_QgsPointCloudDataProvider_Capabilities = {
    SIP_NULLPTR,
    1,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudDataProvider_Capabilities = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudDataProvider__Capabilities,
        SIP_NULLPTR,
        &plugin_QgsPointCloudDataProvider_Capabilities,
    },
    {
        sipNameNr_Capabilities,
        {1793, 255, 0},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudDataProvider_Capabilities,
    -1,
    -1,
    SIP_NULLPTR,
    slots_QgsPointCloudDataProvider_Capabilities,
    init_type_QgsPointCloudDataProvider_Capabilities,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudDataProvider_Capabilities,
    assign_QgsPointCloudDataProvider_Capabilities,
    array_QgsPointCloudDataProvider_Capabilities,
    copy_QgsPointCloudDataProvider_Capabilities,
    release_QgsPointCloudDataProvider_Capabilities,
    SIP_NULLPTR,
    convertTo_QgsPointCloudDataProvider_Capabilities,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsPointCloudDataProvider_Capabilities,
    sizeof (::QgsPointCloudDataProvider::Capabilities),
};

#line 29 "auto_generated/pointcloud/qgspointclouddataprovider.sip"
#include "qgspointclouddataprovider.h"
#line 9573 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 9577 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 21 "auto_generated/providers/qgsdataprovider.sip"
#include "qgsdataprovider.h"
#line 9580 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 9583 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 146 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qmap.sip"
#include <qmap.h>
#line 9586 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 39 "auto_generated/pointcloud/qgspointcloudstatistics.sip"
#include "qgspointcloudstatistics.h"
#line 9589 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 179 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 9592 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 24 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qvariantmap.sip"
#include <qvariant.h>
#line 9595 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 102 "auto_generated/geometry/qgsgeometry.sip"
#include "qgsgeometry.h"
#line 9598 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 166 "auto_generated/pointcloud/qgspointcloudindex.sip"
#include "qgspointcloudindex.h"
#line 9601 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 106 "auto_generated/pointcloud/qgspointcloudattribute.sip"
#include "qgspointcloudattribute.h"
#line 9604 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 29 "auto_generated/pointcloud/qgspointclouddataprovider.sip"
#include "qgspointclouddataprovider.h"
#line 9607 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 163 "auto_generated/qgsrange.sip"
#include "qgsrange.h"
typedef QgsRange<double> QgsRangedoubleBase;
#line 9611 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 60 "auto_generated/qgserror.sip"
#include "qgserror.h"
#line 9614 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 20 "auto_generated/qgserror.sip"
#include "qgserror.h"
#line 9617 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 9620 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 41 "auto_generated/metadata/qgslayermetadata.sip"
#include "qgslayermetadata.h"
#line 9623 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qvariant.sip"
#include <qvariant.h>
#line 9626 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 21 "auto_generated/providers/qgsdataprovider.sip"
#include "qgsdataprovider.h"
#line 9629 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 360 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 9632 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 36 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 9635 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 32 "auto_generated/geometry/qgsbox3d.sip"
#include "qgsbox3d.h"
#line 9638 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 29 "auto_generated/geometry/qgsrectangle.sip"
#include "qgsrectangle.h"
#line 9641 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 23 "auto_generated/qgsdataproviderelevationproperties.sip"
#include "qgsdataproviderelevationproperties.h"
#line 9644 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 23 "auto_generated/qgsdataprovidertemporalcapabilities.sip"
#include "qgsdataprovidertemporalcapabilities.h"
#line 9647 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 9650 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 25 "auto_generated/qgsdatasourceuri.sip"
#include "qgsdatasourceuri.h"
#line 9653 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 205 "auto_generated/proj/qgscoordinatereferencesystem.sip"
#include "qgscoordinatereferencesystem.h"
#line 9656 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 146 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 9661 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 9664 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 9667 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 252 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 9670 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 240 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 9673 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
#include <qobject.h>
#line 9676 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 38 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 9679 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 30 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 9682 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 149 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 9685 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 9688 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qthread.sip"
#include <qthread.h>
#line 9691 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 9694 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qregexp.sip"
#include <qregexp.h>
#line 9697 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qregularexpression.sip"
#include <qregularexpression.h>
#line 9700 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 9703 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


class sipQgsPointCloudDataProvider : public ::QgsPointCloudDataProvider
{
public:
    sipQgsPointCloudDataProvider(const ::QString&, const ::QgsDataProvider::ProviderOptions&, ::Qgis::DataProviderReadFlags);
    virtual ~sipQgsPointCloudDataProvider();

    int qt_metacall(QMetaObject::Call, int, void **) SIP_OVERRIDE;
    void *qt_metacast(const char *) SIP_OVERRIDE;
    const QMetaObject *metaObject() const SIP_OVERRIDE;

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    ::QObject* sipProtect_sender() const;
    int sipProtect_receivers(const char*) const;
    void sipProtectVirt_timerEvent(bool, ::QTimerEvent*);
    void sipProtectVirt_childEvent(bool, ::QChildEvent*);
    void sipProtectVirt_customEvent(bool, ::QEvent*);
    void sipProtectVirt_connectNotify(bool, const ::QMetaMethod&);
    void sipProtectVirt_disconnectNotify(bool, const ::QMetaMethod&);
    int sipProtect_senderSignalIndex() const;
    bool sipProtect_isSignalConnected(const ::QMetaMethod&) const;
    void sipProtect_appendError(const ::QgsErrorMessage&);
    void sipProtect_setError(const ::QgsError&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::QgsPointCloudRenderer* createRenderer(const ::QVariantMap&) const SIP_OVERRIDE;
    ::QVariantMap originalMetadata() const SIP_OVERRIDE;
    ::QgsGeometry polygonBounds() const SIP_OVERRIDE;
    ::qint64 pointCount() const SIP_OVERRIDE;
    ::QgsPointCloudIndex index() const SIP_OVERRIDE;
    ::QgsPointCloudDataProvider::PointCloudIndexGenerationState indexingState() SIP_OVERRIDE;
    void generateIndex() SIP_OVERRIDE;
    void loadIndex() SIP_OVERRIDE;
    ::QgsPointCloudAttributeCollection attributes() const SIP_OVERRIDE;
    ::QgsPointCloudDataProvider::Capabilities capabilities() const SIP_OVERRIDE;
    void disconnectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void connectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void customEvent(::QEvent*) SIP_OVERRIDE;
    void childEvent(::QChildEvent*) SIP_OVERRIDE;
    void timerEvent(::QTimerEvent*) SIP_OVERRIDE;
    bool eventFilter(::QObject*, ::QEvent*) SIP_OVERRIDE;
    bool event(::QEvent*) SIP_OVERRIDE;
    ::QgsCoordinateReferenceSystem crs() const SIP_OVERRIDE;
    void setDataSourceUri(const ::QString&) SIP_OVERRIDE;
    ::QString dataSourceUri(bool) const SIP_OVERRIDE;
    ::QString dataComment() const SIP_OVERRIDE;
    ::QString htmlMetadata() const SIP_OVERRIDE;
    ::Qgis::DataProviderFlags flags() const SIP_OVERRIDE;
    ::QgsDataProviderTemporalCapabilities* temporalCapabilities() SIP_OVERRIDE;
    ::QgsDataProviderElevationProperties* elevationProperties() SIP_OVERRIDE;
    ::QgsRectangle extent() const SIP_OVERRIDE;
    ::QgsBox3D extent3D() const SIP_OVERRIDE;
    bool isValid() const SIP_OVERRIDE;
    void updateExtents() SIP_OVERRIDE;
    ::QString subsetStringDialect() const SIP_OVERRIDE;
    ::QString subsetStringHelpUrl() const SIP_OVERRIDE;
    bool setSubsetString(const ::QString&, bool) SIP_OVERRIDE;
    bool supportsSubsetString() const SIP_OVERRIDE;
    ::QString subsetString() const SIP_OVERRIDE;
    ::QStringList subLayers() const SIP_OVERRIDE;
    ::QStringList subLayerStyles() const SIP_OVERRIDE;
    ::uint subLayerCount() const SIP_OVERRIDE;
    void setLayerOrder(const ::QStringList&) SIP_OVERRIDE;
    void setSubLayerVisibility(const ::QString&, bool) SIP_OVERRIDE;
    ::QString name() const SIP_OVERRIDE;
    ::QString description() const SIP_OVERRIDE;
    ::QString fileVectorFilters() const SIP_OVERRIDE;
    ::QString fileRasterFilters() const SIP_OVERRIDE;
    void reloadData() SIP_OVERRIDE;
    ::QDateTime timestamp() const SIP_OVERRIDE;
    ::QDateTime dataTimestamp() const SIP_OVERRIDE;
    ::QgsError error() const SIP_OVERRIDE;
    void invalidateConnections(const ::QString&) SIP_OVERRIDE;
    bool enterUpdateMode() SIP_OVERRIDE;
    bool leaveUpdateMode() SIP_OVERRIDE;
    void setListening(bool) SIP_OVERRIDE;
    ::QgsLayerMetadata layerMetadata() const SIP_OVERRIDE;
    bool writeLayerMetadata(const ::QgsLayerMetadata&) SIP_OVERRIDE;
    ::Qgis::ProviderStyleStorageCapabilities styleStorageCapabilities() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQgsPointCloudDataProvider(const sipQgsPointCloudDataProvider &);
    sipQgsPointCloudDataProvider &operator = (const sipQgsPointCloudDataProvider &);

    char sipPyMethods[54];
};

sipQgsPointCloudDataProvider::sipQgsPointCloudDataProvider(const ::QString& a0, const ::QgsDataProvider::ProviderOptions& a1, ::Qgis::DataProviderReadFlags a2): ::QgsPointCloudDataProvider(a0, a1, a2), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsPointCloudDataProvider::~sipQgsPointCloudDataProvider()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

const QMetaObject *sipQgsPointCloudDataProvider::metaObject() const
{
    if (sipGetInterpreter())
        return QObject::d_ptr->metaObject ? QObject::d_ptr->dynamicMetaObject() : sip__core_qt_metaobject(sipPySelf, sipType_QgsPointCloudDataProvider);

    return ::QgsPointCloudDataProvider::metaObject();
}

int sipQgsPointCloudDataProvider::qt_metacall(QMetaObject::Call _c, int _id, void **_a)
{
    _id = ::QgsPointCloudDataProvider::qt_metacall(_c, _id, _a);

    if (_id >= 0)
    {
        SIP_BLOCK_THREADS
        _id = sip__core_qt_metacall(sipPySelf, sipType_QgsPointCloudDataProvider, _c, _id, _a);
        SIP_UNBLOCK_THREADS
    }

    return _id;
}

void *sipQgsPointCloudDataProvider::qt_metacast(const char *_clname)
{
    void *sipCpp;

    return (sip__core_qt_metacast(sipPySelf, sipType_QgsPointCloudDataProvider, _clname, &sipCpp) ? sipCpp : ::QgsPointCloudDataProvider::qt_metacast(_clname));
}

::QgsPointCloudRenderer* sipQgsPointCloudDataProvider::createRenderer(const ::QVariantMap& a0) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_createRenderer);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::createRenderer(a0);

    extern ::QgsPointCloudRenderer* sipVH__core_752(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QVariantMap&);

    return sipVH__core_752(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QVariantMap sipQgsPointCloudDataProvider::originalMetadata() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_originalMetadata);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::originalMetadata();

    extern ::QVariantMap sipVH__core_115(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_115(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsGeometry sipQgsPointCloudDataProvider::polygonBounds() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[2]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_polygonBounds);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::polygonBounds();

    extern ::QgsGeometry sipVH__core_649(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_649(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::qint64 sipQgsPointCloudDataProvider::pointCount() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[3]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_QgsPointCloudDataProvider, sipName_pointCount);

    if (!sipMeth)
        return 0;

    extern ::qint64 sipVH__core_72(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_72(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsPointCloudIndex sipQgsPointCloudDataProvider::index() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[4]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_index);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::index();

    extern ::QgsPointCloudIndex sipVH__core_751(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_751(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsPointCloudDataProvider::PointCloudIndexGenerationState sipQgsPointCloudDataProvider::indexingState()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, sipName_QgsPointCloudDataProvider, sipName_indexingState);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::NotIndexed;

    extern ::QgsPointCloudDataProvider::PointCloudIndexGenerationState sipVH__core_750(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_750(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudDataProvider::generateIndex()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, sipName_QgsPointCloudDataProvider, sipName_generateIndex);

    if (!sipMeth)
        return;

    extern void sipVH__core_426(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_426(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudDataProvider::loadIndex()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, sipName_QgsPointCloudDataProvider, sipName_loadIndex);

    if (!sipMeth)
        return;

    extern void sipVH__core_426(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_426(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsPointCloudAttributeCollection sipQgsPointCloudDataProvider::attributes() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[8]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_QgsPointCloudDataProvider, sipName_attributes);

    if (!sipMeth)
        return ::QgsPointCloudAttributeCollection();

    extern ::QgsPointCloudAttributeCollection sipVH__core_749(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_749(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsPointCloudDataProvider::Capabilities sipQgsPointCloudDataProvider::capabilities() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[9]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_capabilities);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::capabilities();

    extern ::QgsPointCloudDataProvider::Capabilities sipVH__core_748(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_748(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudDataProvider::disconnectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[10], &sipPySelf, SIP_NULLPTR, sipName_disconnectNotify);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::disconnectNotify(a0);
        return;
    }

    extern void sipVH__core_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH__core_3(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudDataProvider::connectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[11], &sipPySelf, SIP_NULLPTR, sipName_connectNotify);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::connectNotify(a0);
        return;
    }

    extern void sipVH__core_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH__core_3(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudDataProvider::customEvent(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[12], &sipPySelf, SIP_NULLPTR, sipName_customEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::customEvent(a0);
        return;
    }

    extern void sipVH__core_4(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    sipVH__core_4(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudDataProvider::childEvent(::QChildEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[13], &sipPySelf, SIP_NULLPTR, sipName_childEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::childEvent(a0);
        return;
    }

    extern void sipVH__core_5(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QChildEvent*);

    sipVH__core_5(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudDataProvider::timerEvent(::QTimerEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[14], &sipPySelf, SIP_NULLPTR, sipName_timerEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::timerEvent(a0);
        return;
    }

    extern void sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QTimerEvent*);

    sipVH__core_6(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQgsPointCloudDataProvider::eventFilter(::QObject*a0, ::QEvent*a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[15], &sipPySelf, SIP_NULLPTR, sipName_eventFilter);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::eventFilter(a0, a1);

    extern bool sipVH__core_7(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QObject*, ::QEvent*);

    return sipVH__core_7(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudDataProvider::event(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[16], &sipPySelf, SIP_NULLPTR, sipName_event);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::event(a0);

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    return sipVH__core_8(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QgsCoordinateReferenceSystem sipQgsPointCloudDataProvider::crs() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[17]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_QgsPointCloudDataProvider, sipName_crs);

    if (!sipMeth)
        return ::QgsCoordinateReferenceSystem();

    extern ::QgsCoordinateReferenceSystem sipVH__core_69(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_69(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudDataProvider::setDataSourceUri(const ::QString& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[18], &sipPySelf, SIP_NULLPTR, sipName_setDataSourceUri);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::setDataSourceUri(a0);
        return;
    }

    extern void sipVH__core_185(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&);

    sipVH__core_185(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QString sipQgsPointCloudDataProvider::dataSourceUri(bool a0) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[19]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_dataSourceUri);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::dataSourceUri(a0);

    extern ::QString sipVH__core_697(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool);

    return sipVH__core_697(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QString sipQgsPointCloudDataProvider::dataComment() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[20]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_dataComment);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::dataComment();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QString sipQgsPointCloudDataProvider::htmlMetadata() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[21]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_htmlMetadata);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::htmlMetadata();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::Qgis::DataProviderFlags sipQgsPointCloudDataProvider::flags() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[22]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_flags);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::flags();

    extern ::Qgis::DataProviderFlags sipVH__core_698(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_698(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsDataProviderTemporalCapabilities* sipQgsPointCloudDataProvider::temporalCapabilities()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[23], &sipPySelf, SIP_NULLPTR, sipName_temporalCapabilities);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::temporalCapabilities();

    extern ::QgsDataProviderTemporalCapabilities* sipVH__core_699(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_699(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsDataProviderElevationProperties* sipQgsPointCloudDataProvider::elevationProperties()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[24], &sipPySelf, SIP_NULLPTR, sipName_elevationProperties);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::elevationProperties();

    extern ::QgsDataProviderElevationProperties* sipVH__core_700(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_700(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsRectangle sipQgsPointCloudDataProvider::extent() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[25]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_QgsPointCloudDataProvider, sipName_extent);

    if (!sipMeth)
        return ::QgsRectangle();

    extern ::QgsRectangle sipVH__core_18(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_18(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsBox3D sipQgsPointCloudDataProvider::extent3D() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[26]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_extent3D);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::extent3D();

    extern ::QgsBox3D sipVH__core_19(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_19(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudDataProvider::isValid() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[27]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_QgsPointCloudDataProvider, sipName_isValid);

    if (!sipMeth)
        return 0;

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudDataProvider::updateExtents()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[28], &sipPySelf, SIP_NULLPTR, sipName_updateExtents);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::updateExtents();
        return;
    }

    extern void sipVH__core_426(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_426(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QString sipQgsPointCloudDataProvider::subsetStringDialect() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[29]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_subsetStringDialect);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::subsetStringDialect();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QString sipQgsPointCloudDataProvider::subsetStringHelpUrl() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[30]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_subsetStringHelpUrl);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::subsetStringHelpUrl();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudDataProvider::setSubsetString(const ::QString& a0, bool a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[31], &sipPySelf, SIP_NULLPTR, sipName_setSubsetString);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::setSubsetString(a0, a1);

    extern bool sipVH__core_701(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool);

    return sipVH__core_701(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudDataProvider::supportsSubsetString() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[32]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_supportsSubsetString);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::supportsSubsetString();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QString sipQgsPointCloudDataProvider::subsetString() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[33]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_subsetString);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::subsetString();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QStringList sipQgsPointCloudDataProvider::subLayers() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[34]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_subLayers);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::subLayers();

    extern ::QStringList sipVH__core_20(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_20(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QStringList sipQgsPointCloudDataProvider::subLayerStyles() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[35]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_subLayerStyles);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::subLayerStyles();

    extern ::QStringList sipVH__core_20(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_20(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::uint sipQgsPointCloudDataProvider::subLayerCount() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[36]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_subLayerCount);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::subLayerCount();

    extern ::uint sipVH__core_702(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_702(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudDataProvider::setLayerOrder(const ::QStringList& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[37], &sipPySelf, SIP_NULLPTR, sipName_setLayerOrder);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::setLayerOrder(a0);
        return;
    }

    extern void sipVH__core_21(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QStringList&);

    sipVH__core_21(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudDataProvider::setSubLayerVisibility(const ::QString& a0, bool a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[38], &sipPySelf, SIP_NULLPTR, sipName_setSubLayerVisibility);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::setSubLayerVisibility(a0, a1);
        return;
    }

    extern void sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool);

    sipVH__core_11(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

::QString sipQgsPointCloudDataProvider::name() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[39]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_QgsPointCloudDataProvider, sipName_name);

    if (!sipMeth)
        return ::QString();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QString sipQgsPointCloudDataProvider::description() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[40]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_QgsPointCloudDataProvider, sipName_description);

    if (!sipMeth)
        return ::QString();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QString sipQgsPointCloudDataProvider::fileVectorFilters() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[41]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_fileVectorFilters);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::fileVectorFilters();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QString sipQgsPointCloudDataProvider::fileRasterFilters() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[42]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_fileRasterFilters);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::fileRasterFilters();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudDataProvider::reloadData()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[43], &sipPySelf, SIP_NULLPTR, sipName_reloadData);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::reloadData();
        return;
    }

    extern void sipVH__core_426(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_426(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QDateTime sipQgsPointCloudDataProvider::timestamp() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[44]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_timestamp);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::timestamp();

    extern ::QDateTime sipVH__core_48(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_48(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QDateTime sipQgsPointCloudDataProvider::dataTimestamp() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[45]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_dataTimestamp);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::dataTimestamp();

    extern ::QDateTime sipVH__core_48(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_48(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsError sipQgsPointCloudDataProvider::error() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[46]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_error);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::error();

    extern ::QgsError sipVH__core_29(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_29(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudDataProvider::invalidateConnections(const ::QString& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[47], &sipPySelf, SIP_NULLPTR, sipName_invalidateConnections);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::invalidateConnections(a0);
        return;
    }

    extern void sipVH__core_185(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&);

    sipVH__core_185(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQgsPointCloudDataProvider::enterUpdateMode()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[48], &sipPySelf, SIP_NULLPTR, sipName_enterUpdateMode);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::enterUpdateMode();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudDataProvider::leaveUpdateMode()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[49], &sipPySelf, SIP_NULLPTR, sipName_leaveUpdateMode);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::leaveUpdateMode();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudDataProvider::setListening(bool a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[50], &sipPySelf, SIP_NULLPTR, sipName_setListening);

    if (!sipMeth)
    {
        ::QgsPointCloudDataProvider::setListening(a0);
        return;
    }

    extern void sipVH__core_81(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool);

    sipVH__core_81(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QgsLayerMetadata sipQgsPointCloudDataProvider::layerMetadata() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[51]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_layerMetadata);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::layerMetadata();

    extern ::QgsLayerMetadata sipVH__core_703(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_703(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudDataProvider::writeLayerMetadata(const ::QgsLayerMetadata& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[52], &sipPySelf, SIP_NULLPTR, sipName_writeLayerMetadata);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::writeLayerMetadata(a0);

    extern bool sipVH__core_704(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsLayerMetadata&);

    return sipVH__core_704(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::Qgis::ProviderStyleStorageCapabilities sipQgsPointCloudDataProvider::styleStorageCapabilities() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[53]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_styleStorageCapabilities);

    if (!sipMeth)
        return ::QgsPointCloudDataProvider::styleStorageCapabilities();

    extern ::Qgis::ProviderStyleStorageCapabilities sipVH__core_705(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_705(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QObject* sipQgsPointCloudDataProvider::sipProtect_sender() const
{
    return ::QObject::sender();
}

int sipQgsPointCloudDataProvider::sipProtect_receivers(const char*a0) const
{
    return ::QObject::receivers(a0);
}

void sipQgsPointCloudDataProvider::sipProtectVirt_timerEvent(bool sipSelfWasArg, ::QTimerEvent*a0)
{
    (sipSelfWasArg ? ::QObject::timerEvent(a0) : timerEvent(a0));
}

void sipQgsPointCloudDataProvider::sipProtectVirt_childEvent(bool sipSelfWasArg, ::QChildEvent*a0)
{
    (sipSelfWasArg ? ::QObject::childEvent(a0) : childEvent(a0));
}

void sipQgsPointCloudDataProvider::sipProtectVirt_customEvent(bool sipSelfWasArg, ::QEvent*a0)
{
    (sipSelfWasArg ? ::QObject::customEvent(a0) : customEvent(a0));
}

void sipQgsPointCloudDataProvider::sipProtectVirt_connectNotify(bool sipSelfWasArg, const ::QMetaMethod& a0)
{
    (sipSelfWasArg ? ::QObject::connectNotify(a0) : connectNotify(a0));
}

void sipQgsPointCloudDataProvider::sipProtectVirt_disconnectNotify(bool sipSelfWasArg, const ::QMetaMethod& a0)
{
    (sipSelfWasArg ? ::QObject::disconnectNotify(a0) : disconnectNotify(a0));
}

int sipQgsPointCloudDataProvider::sipProtect_senderSignalIndex() const
{
    return ::QObject::senderSignalIndex();
}

bool sipQgsPointCloudDataProvider::sipProtect_isSignalConnected(const ::QMetaMethod& a0) const
{
    return ::QObject::isSignalConnected(a0);
}

void sipQgsPointCloudDataProvider::sipProtect_appendError(const ::QgsErrorMessage& a0)
{
    ::QgsDataProvider::appendError(a0);
}

void sipQgsPointCloudDataProvider::sipProtect_setError(const ::QgsError& a0)
{
    ::QgsDataProvider::setError(a0);
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_sender, "sender(self) -> Optional[QObject]");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_sender(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_sender(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const sipQgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::QObject*sipRes = 0;

#line 570 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
        // sender() must be called without the GIL to avoid possible deadlocks between
        // the GIL and Qt's internal thread data mutex.
        
        Py_BEGIN_ALLOW_THREADS
        
        #if defined(SIP_PROTECTED_IS_PUBLIC)
        sipRes = sipCpp->sender();
        #else
        sipRes = sipCpp->sipProtect_sender();
        #endif
        
        Py_END_ALLOW_THREADS
        
        if (!sipRes)
        {
            typedef QObject *(*qtcore_qobject_sender_t)();
        
            static qtcore_qobject_sender_t qtcore_qobject_sender = 0;
        
            if (!qtcore_qobject_sender)
            {
                qtcore_qobject_sender = (qtcore_qobject_sender_t)sipImportSymbol("qtcore_qobject_sender");
                Q_ASSERT(qtcore_qobject_sender);
            }
        
            sipRes = qtcore_qobject_sender();
        }
#line 10785 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            return sipConvertFromType(sipRes, sipType_QObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_sender, doc_QgsPointCloudDataProvider_sender);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_receivers, "receivers(self, signal: PYQT_SIGNAL) -> int");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_receivers(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_receivers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * a0;
        const sipQgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BP0", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, &a0))
        {
            int sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 601 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
        // We need to handle the signal object.  Import the helper if it hasn't already
        // been done.
        typedef sipErrorState (*pyqt5_get_signal_signature_t)(PyObject *, const QObject *, const QByteArray &);
        
        static pyqt5_get_signal_signature_t pyqt5_get_signal_signature = 0;
        
        if (!pyqt5_get_signal_signature)
        {
            pyqt5_get_signal_signature = (pyqt5_get_signal_signature_t)sipImportSymbol("pyqt5_get_signal_signature");
            Q_ASSERT(pyqt5_get_signal_signature);
        }
        
        QByteArray signal_signature;
            
        #if defined(SIP_PROTECTED_IS_PUBLIC)
        if ((sipError = pyqt5_get_signal_signature(a0, sipCpp, signal_signature)) == sipErrorNone)
        {
            sipRes = sipCpp->receivers(signal_signature.constData());
        }
        #else
        if ((sipError = pyqt5_get_signal_signature(a0, static_cast<const QObject *>(sipCpp), signal_signature)) == sipErrorNone)
        {
            sipRes = sipCpp->sipProtect_receivers(signal_signature.constData());
        }
        #endif
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(0, a0);
        }
#line 10843 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyLong_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_receivers, doc_QgsPointCloudDataProvider_receivers);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_timerEvent, "timerEvent(self, a0: Optional[QTimerEvent])");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_timerEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_timerEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QTimerEvent* a0;
        sipQgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, sipType_QTimerEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_timerEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_timerEvent, doc_QgsPointCloudDataProvider_timerEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_childEvent, "childEvent(self, a0: Optional[QChildEvent])");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_childEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_childEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QChildEvent* a0;
        sipQgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, sipType_QChildEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_childEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_childEvent, doc_QgsPointCloudDataProvider_childEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_customEvent, "customEvent(self, a0: Optional[QEvent])");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_customEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_customEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QEvent* a0;
        sipQgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, sipType_QEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_customEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_customEvent, doc_QgsPointCloudDataProvider_customEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_connectNotify, "connectNotify(self, signal: QMetaMethod)");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_connectNotify(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_connectNotify(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QMetaMethod* a0;
        sipQgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, sipType_QMetaMethod, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_connectNotify(sipSelfWasArg, *a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_connectNotify, doc_QgsPointCloudDataProvider_connectNotify);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_disconnectNotify, "disconnectNotify(self, signal: QMetaMethod)");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_disconnectNotify(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_disconnectNotify(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QMetaMethod* a0;
        sipQgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, sipType_QMetaMethod, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_disconnectNotify(sipSelfWasArg, *a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_disconnectNotify, doc_QgsPointCloudDataProvider_disconnectNotify);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_senderSignalIndex, "senderSignalIndex(self) -> int");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_senderSignalIndex(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_senderSignalIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const sipQgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sipProtect_senderSignalIndex();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_senderSignalIndex, doc_QgsPointCloudDataProvider_senderSignalIndex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_isSignalConnected, "isSignalConnected(self, signal: QMetaMethod) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_isSignalConnected(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_isSignalConnected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaMethod* a0;
        const sipQgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, sipType_QMetaMethod, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sipProtect_isSignalConnected(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_isSignalConnected, doc_QgsPointCloudDataProvider_isSignalConnected);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_appendError, "appendError(self, message: QgsErrorMessage)\n"
"Add error message");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_appendError(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_appendError(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsErrorMessage* a0;
        sipQgsPointCloudDataProvider *sipCpp;

        static const char *sipKwdList[] = {
            sipName_message,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, sipType_QgsErrorMessage, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_appendError(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_appendError, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_setError, "setError(self, error: QgsError)\n"
"Sets error message");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_setError(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_setError(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsError* a0;
        sipQgsPointCloudDataProvider *sipCpp;

        static const char *sipKwdList[] = {
            sipName_error,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, sipType_QgsError, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_setError(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_setError, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_identify, "identify(self, maxErrorInMapCoords: float, extentGeometry: QgsGeometry, extentZRange: QgsDoubleRange = QgsDoubleRange(), pointsLimit: int = 1000) -> list\n"
"Returns the list of points of the point cloud according to a zoom level\n"
"defined by ``maxError`` (in layer coordinates), an extent ``geometry``\n"
"in the 2D plane and a range ``extentZRange`` for z values. The function\n"
"will try to limit the number of points returned to ``pointsLimit``\n"
"points\n"
"\n"
".. note::\n"
"\n"
"   this function does not handle elevation properties and you need to\n"
"   change elevation coordinates yourself after returning from the function");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_identify(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_identify(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        ::QgsGeometry* a1;
        const ::QgsDoubleRange a2def = QgsDoubleRange();
        const ::QgsDoubleRange* a2 = &a2def;
        int a3 = 1000;
        ::QgsPointCloudDataProvider *sipCpp;

        static const char *sipKwdList[] = {
            sipName_maxErrorInMapCoords,
            sipName_extentGeometry,
            sipName_extentZRange,
            sipName_pointsLimit,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BfJ9|J9i", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, &a0, sipType_QgsGeometry, &a1, sipType_QgsDoubleRange, &a2, &a3))
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 77 "auto_generated/pointcloud/qgspointclouddataprovider.sip"
    {
      QVector<QMap<QString, QVariant>> res = sipCpp->identify( a0, *a1, *a2, a3 );
      sipRes = PyList_New( res.size() );
      for ( int i = 0; i < res.size(); ++i )
      {
        PyObject *dict = PyDict_New();
        for ( QString key : res[i].keys() )
        {
          PyObject *keyObj = sipConvertFromNewType( new QString( key ), sipType_QString, Py_None );
          PyObject *valObj = sipConvertFromNewType( new QVariant( res[i][key] ), sipType_QVariant, Py_None );
          PyDict_SetItem( dict, keyObj, valObj );
        }
        PyList_SET_ITEM( sipRes, i, dict );
      }
    }
#line 11345 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_identify, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_capabilities, "capabilities(self) -> QgsPointCloudDataProvider.Capabilities\n"
"Returns flags containing the supported capabilities for the data\n"
"provider.");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_capabilities(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_capabilities(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::QgsPointCloudDataProvider::Capabilities*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudDataProvider::Capabilities((sipSelfWasArg ? sipCpp->::QgsPointCloudDataProvider::capabilities() : sipCpp->capabilities()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudDataProvider_Capabilities, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_capabilities, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_attributes, "attributes(self) -> QgsPointCloudAttributeCollection\n"
"Returns the attributes available from this data provider. May return\n"
"empty collection until\n"
":py:func:`~QgsPointCloudDataProvider.pointCloudIndexLoaded` is emitted");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_attributes(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_attributes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::QgsPointCloudAttributeCollection*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_QgsPointCloudDataProvider, sipName_attributes);
                return SIP_NULLPTR;
            }

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudAttributeCollection(sipCpp->attributes());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudAttributeCollection, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_attributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_loadIndex, "loadIndex(self)\n"
"Triggers loading of the point cloud index\n"
"\n"
".. seealso:: :py:func:`index`");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_loadIndex(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_loadIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_QgsPointCloudDataProvider, sipName_loadIndex);
                return SIP_NULLPTR;
            }

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->loadIndex();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_loadIndex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_generateIndex, "generateIndex(self)\n"
"Triggers generation of the point cloud index\n"
"\n"
"emits :py:func:`~QgsPointCloudDataProvider.indexGenerationStateChanged`\n"
"\n"
".. seealso:: :py:func:`index`");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_generateIndex(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_generateIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_QgsPointCloudDataProvider, sipName_generateIndex);
                return SIP_NULLPTR;
            }

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->generateIndex();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_generateIndex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_indexingState, "indexingState(self) -> QgsPointCloudDataProvider.PointCloudIndexGenerationState\n"
"Gets the current index generation state");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_indexingState(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_indexingState(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::QgsPointCloudDataProvider::PointCloudIndexGenerationState sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_QgsPointCloudDataProvider, sipName_indexingState);
                return SIP_NULLPTR;
            }

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->indexingState();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QgsPointCloudDataProvider_PointCloudIndexGenerationState);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_indexingState, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_index, "index(self) -> QgsPointCloudIndex\n"
"Returns the point cloud index associated with the provider.\n"
"\n"
"Can be None (e.g. the index is being created)");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_index(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_index(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::QgsPointCloudIndex*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudIndex((sipSelfWasArg ? sipCpp->::QgsPointCloudDataProvider::index() : sipCpp->index()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudIndex, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_index, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_hasValidIndex, "hasValidIndex(self) -> bool\n"
"Returns whether provider has index which is valid");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_hasValidIndex(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_hasValidIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->hasValidIndex();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_hasValidIndex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_pointCount, "pointCount(self) -> int\n"
"Returns the total number of points available in the dataset.");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_pointCount(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_pointCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::qint64 sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_QgsPointCloudDataProvider, sipName_pointCount);
                return SIP_NULLPTR;
            }

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointCount();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_pointCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_polygonBounds, "polygonBounds(self) -> QgsGeometry\n"
"Returns the polygon bounds of the layer. The CRS of the returned\n"
"geometry will match the provider's\n"
":py:func:`~QgsPointCloudDataProvider.crs`.\n"
"\n"
"This method will return the best approximation for the actual bounds of\n"
"points contained in the dataset available from the provider's metadata.\n"
"This may match the bounding box rectangle returned by\n"
":py:func:`~QgsPointCloudDataProvider.extent`, or for some datasets a\n"
"\"convex hull\" style polygon representing a more precise bounds will be\n"
"returned.\n"
"\n"
"This method will not attempt to calculate the data bounds, rather it\n"
"will return only whatever precomputed bounds are included in the data\n"
"source's metadata.");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_polygonBounds(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_polygonBounds(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::QgsGeometry*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsGeometry((sipSelfWasArg ? sipCpp->::QgsPointCloudDataProvider::polygonBounds() : sipCpp->polygonBounds()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsGeometry, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_polygonBounds, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_originalMetadata, "originalMetadata(self) -> dict[str, Any]\n"
"Returns a representation of the original metadata included in a point\n"
"cloud dataset.\n"
"\n"
"This is a free-form dictionary of values, the contents and structure of\n"
"which will vary by provider and dataset.");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_originalMetadata(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_originalMetadata(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::QVariantMap*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QVariantMap((sipSelfWasArg ? sipCpp->::QgsPointCloudDataProvider::originalMetadata() : sipCpp->originalMetadata()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QVariantMap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_originalMetadata, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_createRenderer, "createRenderer(self, configuration: dict[str, Any] = {}) -> Optional[QgsPointCloudRenderer]\n"
"Creates a new 2D point cloud renderer, using provider backend specific\n"
"information.\n"
"\n"
"The ``configuration`` map can be used to pass provider-specific\n"
"configuration maps to the provider to allow customization of the\n"
"returned renderer. Support and format of ``configuration`` varies by\n"
"provider.\n"
"\n"
"When called with an empty ``configuration`` map the provider's default\n"
"renderer will be returned.\n"
"\n"
"This method returns a new renderer and the caller takes ownership of the\n"
"returned object.\n"
"\n"
"Only providers which report the CreateRenderer capability will return a\n"
"2D renderer. Other providers will return ``None``.");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_createRenderer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_createRenderer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QVariantMap& a0def = QVariantMap();
        const ::QVariantMap* a0 = &a0def;
        int a0State = 0;
        const ::QgsPointCloudDataProvider *sipCpp;

        static const char *sipKwdList[] = {
            sipName_configuration,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J1", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, sipType_QVariantMap, &a0, &a0State))
        {
            ::QgsPointCloudRenderer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudDataProvider::createRenderer(*a0) : sipCpp->createRenderer(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QVariantMap *>(a0), sipType_QVariantMap, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QVariantMap *>(a0), sipType_QVariantMap, a0State);

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_createRenderer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_metadataStatistics, "metadataStatistics(self) -> QgsPointCloudStatistics\n"
"Returns the object containing the statistics metadata extracted from the\n"
"dataset\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_metadataStatistics(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_metadataStatistics(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::QgsPointCloudStatistics*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudStatistics(sipCpp->metadataStatistics());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudStatistics, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_metadataStatistics, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_supportsSubsetString, "supportsSubsetString(self) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_supportsSubsetString(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_supportsSubsetString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudDataProvider::supportsSubsetString() : sipCpp->supportsSubsetString());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_supportsSubsetString, doc_QgsPointCloudDataProvider_supportsSubsetString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_subsetStringDialect, "subsetStringDialect(self) -> str");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_subsetStringDialect(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_subsetStringDialect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString((sipSelfWasArg ? sipCpp->::QgsPointCloudDataProvider::subsetStringDialect() : sipCpp->subsetStringDialect()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_subsetStringDialect, doc_QgsPointCloudDataProvider_subsetStringDialect);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_subsetStringHelpUrl, "subsetStringHelpUrl(self) -> str");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_subsetStringHelpUrl(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_subsetStringHelpUrl(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString((sipSelfWasArg ? sipCpp->::QgsPointCloudDataProvider::subsetStringHelpUrl() : sipCpp->subsetStringHelpUrl()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_subsetStringHelpUrl, doc_QgsPointCloudDataProvider_subsetStringHelpUrl);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_subsetString, "subsetString(self) -> str");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_subsetString(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_subsetString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudDataProvider *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString((sipSelfWasArg ? sipCpp->::QgsPointCloudDataProvider::subsetString() : sipCpp->subsetString()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_subsetString, doc_QgsPointCloudDataProvider_subsetString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_setSubsetString, "setSubsetString(self, subset: Optional[str], updateFeatureCount: bool = False) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_setSubsetString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_setSubsetString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QString* a0;
        int a0State = 0;
        bool a1 = 0;
        ::QgsPointCloudDataProvider *sipCpp;

        static const char *sipKwdList[] = {
            sipName_subset,
            sipName_updateFeatureCount,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|b", &sipSelf, sipType_QgsPointCloudDataProvider, &sipCpp, sipType_QString, &a0, &a0State, &a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudDataProvider::setSubsetString(*a0, a1) : sipCpp->setSubsetString(*a0, a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_setSubsetString, doc_QgsPointCloudDataProvider_setSubsetString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_lasClassificationCodes, "lasClassificationCodes() -> dict[int, str]\n"
"Returns the map of LAS classification code to untranslated string value,\n"
"corresponding to the ASPRS Standard Lidar Point Classes.\n"
"\n"
".. seealso:: :py:func:`translatedLasClassificationCodes`");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_lasClassificationCodes(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_lasClassificationCodes(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            QMap<int, ::QString>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QMap<int, ::QString>(::QgsPointCloudDataProvider::lasClassificationCodes());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QMap_1800_0100QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_lasClassificationCodes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_translatedLasClassificationCodes, "translatedLasClassificationCodes() -> dict[int, str]\n"
"Returns the map of LAS classification code to translated string value,\n"
"corresponding to the ASPRS Standard Lidar Point Classes.\n"
"\n"
".. seealso:: :py:func:`lasClassificationCodes`");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_translatedLasClassificationCodes(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_translatedLasClassificationCodes(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            QMap<int, ::QString>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QMap<int, ::QString>(::QgsPointCloudDataProvider::translatedLasClassificationCodes());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QMap_1800_0100QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_translatedLasClassificationCodes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_dataFormatIds, "dataFormatIds() -> dict[int, str]\n"
"Returns the map of LAS data format ID to untranslated string value.\n"
"\n"
".. seealso:: :py:func:`translatedDataFormatIds`");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_dataFormatIds(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_dataFormatIds(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            QMap<int, ::QString>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QMap<int, ::QString>(::QgsPointCloudDataProvider::dataFormatIds());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QMap_1800_0100QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_dataFormatIds, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudDataProvider_translatedDataFormatIds, "translatedDataFormatIds() -> dict[int, str]\n"
"Returns the map of LAS data format ID to translated string value.\n"
"\n"
".. seealso:: :py:func:`dataFormatIds`");

extern "C" {static PyObject *meth_QgsPointCloudDataProvider_translatedDataFormatIds(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudDataProvider_translatedDataFormatIds(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            QMap<int, ::QString>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QMap<int, ::QString>(::QgsPointCloudDataProvider::translatedDataFormatIds());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QMap_1800_0100QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudDataProvider, sipName_translatedDataFormatIds, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QgsPointCloudDataProvider(void *, const sipTypeDef *);}
static void *cast_QgsPointCloudDataProvider(void *sipCppV, const sipTypeDef *targetType)
{
    ::QgsPointCloudDataProvider *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider *>(sipCppV);

    if (targetType == sipType_QgsPointCloudDataProvider)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_QgsDataProvider)->ctd_cast(static_cast< ::QgsDataProvider *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudDataProvider(void *, int);}
static void release_QgsPointCloudDataProvider(void *sipCppV, int)
{
    ::QgsPointCloudDataProvider *sipCpp = reinterpret_cast< ::QgsPointCloudDataProvider *>(sipCppV);

    Py_BEGIN_ALLOW_THREADS

    if (QThread::currentThread() == sipCpp->thread())
        delete sipCpp;
    else
        sipCpp->deleteLater();

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QgsPointCloudDataProvider(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudDataProvider(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQgsPointCloudDataProvider *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudDataProvider(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QgsPointCloudDataProvider(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudDataProvider(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQgsPointCloudDataProvider *sipCpp = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QgsDataProvider::ProviderOptions* a1;
        ::Qgis::DataProviderReadFlags a2def = Qgis::DataProviderReadFlags();
        ::Qgis::DataProviderReadFlags* a2 = &a2def;
        int a2State = 0;

        static const char *sipKwdList[] = {
            sipName_uri,
            sipName_providerOptions,
            sipName_flags,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J9|J1", sipType_QString, &a0, &a0State, sipType_QgsDataProvider_ProviderOptions, &a1, sipType_Qgis_DataProviderReadFlags, &a2, &a2State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsPointCloudDataProvider(*a0, *a1, *a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(a2, sipType_Qgis_DataProviderReadFlags, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(a2, sipType_Qgis_DataProviderReadFlags, a2State);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QgsPointCloudDataProvider[] = {{1070, 255, 1}};


static PyMethodDef methods_QgsPointCloudDataProvider[] = {
    {sipName_appendError, SIP_MLMETH_CAST(meth_QgsPointCloudDataProvider_appendError), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_attributes, meth_QgsPointCloudDataProvider_attributes, METH_VARARGS, doc_QgsPointCloudDataProvider_attributes},
    {sipName_capabilities, meth_QgsPointCloudDataProvider_capabilities, METH_VARARGS, doc_QgsPointCloudDataProvider_capabilities},
    {sipName_childEvent, meth_QgsPointCloudDataProvider_childEvent, METH_VARARGS, SIP_NULLPTR},
    {sipName_connectNotify, meth_QgsPointCloudDataProvider_connectNotify, METH_VARARGS, SIP_NULLPTR},
    {sipName_createRenderer, SIP_MLMETH_CAST(meth_QgsPointCloudDataProvider_createRenderer), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudDataProvider_createRenderer},
    {sipName_customEvent, meth_QgsPointCloudDataProvider_customEvent, METH_VARARGS, SIP_NULLPTR},
    {sipName_dataFormatIds, meth_QgsPointCloudDataProvider_dataFormatIds, METH_VARARGS, doc_QgsPointCloudDataProvider_dataFormatIds},
    {sipName_disconnectNotify, meth_QgsPointCloudDataProvider_disconnectNotify, METH_VARARGS, SIP_NULLPTR},
    {sipName_generateIndex, meth_QgsPointCloudDataProvider_generateIndex, METH_VARARGS, doc_QgsPointCloudDataProvider_generateIndex},
    {sipName_hasValidIndex, meth_QgsPointCloudDataProvider_hasValidIndex, METH_VARARGS, doc_QgsPointCloudDataProvider_hasValidIndex},
    {sipName_identify, SIP_MLMETH_CAST(meth_QgsPointCloudDataProvider_identify), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudDataProvider_identify},
    {sipName_index, meth_QgsPointCloudDataProvider_index, METH_VARARGS, doc_QgsPointCloudDataProvider_index},
    {sipName_indexingState, meth_QgsPointCloudDataProvider_indexingState, METH_VARARGS, doc_QgsPointCloudDataProvider_indexingState},
    {sipName_isSignalConnected, meth_QgsPointCloudDataProvider_isSignalConnected, METH_VARARGS, SIP_NULLPTR},
    {sipName_lasClassificationCodes, meth_QgsPointCloudDataProvider_lasClassificationCodes, METH_VARARGS, doc_QgsPointCloudDataProvider_lasClassificationCodes},
    {sipName_loadIndex, meth_QgsPointCloudDataProvider_loadIndex, METH_VARARGS, doc_QgsPointCloudDataProvider_loadIndex},
    {sipName_metadataStatistics, meth_QgsPointCloudDataProvider_metadataStatistics, METH_VARARGS, doc_QgsPointCloudDataProvider_metadataStatistics},
    {sipName_originalMetadata, meth_QgsPointCloudDataProvider_originalMetadata, METH_VARARGS, doc_QgsPointCloudDataProvider_originalMetadata},
    {sipName_pointCount, meth_QgsPointCloudDataProvider_pointCount, METH_VARARGS, doc_QgsPointCloudDataProvider_pointCount},
    {sipName_polygonBounds, meth_QgsPointCloudDataProvider_polygonBounds, METH_VARARGS, doc_QgsPointCloudDataProvider_polygonBounds},
    {sipName_receivers, meth_QgsPointCloudDataProvider_receivers, METH_VARARGS, SIP_NULLPTR},
    {sipName_sender, meth_QgsPointCloudDataProvider_sender, METH_VARARGS, SIP_NULLPTR},
    {sipName_senderSignalIndex, meth_QgsPointCloudDataProvider_senderSignalIndex, METH_VARARGS, SIP_NULLPTR},
    {sipName_setError, SIP_MLMETH_CAST(meth_QgsPointCloudDataProvider_setError), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_setSubsetString, SIP_MLMETH_CAST(meth_QgsPointCloudDataProvider_setSubsetString), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudDataProvider_setSubsetString},
    {sipName_subsetString, meth_QgsPointCloudDataProvider_subsetString, METH_VARARGS, doc_QgsPointCloudDataProvider_subsetString},
    {sipName_subsetStringDialect, meth_QgsPointCloudDataProvider_subsetStringDialect, METH_VARARGS, doc_QgsPointCloudDataProvider_subsetStringDialect},
    {sipName_subsetStringHelpUrl, meth_QgsPointCloudDataProvider_subsetStringHelpUrl, METH_VARARGS, doc_QgsPointCloudDataProvider_subsetStringHelpUrl},
    {sipName_supportsSubsetString, meth_QgsPointCloudDataProvider_supportsSubsetString, METH_VARARGS, doc_QgsPointCloudDataProvider_supportsSubsetString},
    {sipName_timerEvent, meth_QgsPointCloudDataProvider_timerEvent, METH_VARARGS, SIP_NULLPTR},
    {sipName_translatedDataFormatIds, meth_QgsPointCloudDataProvider_translatedDataFormatIds, METH_VARARGS, doc_QgsPointCloudDataProvider_translatedDataFormatIds},
    {sipName_translatedLasClassificationCodes, meth_QgsPointCloudDataProvider_translatedLasClassificationCodes, METH_VARARGS, doc_QgsPointCloudDataProvider_translatedLasClassificationCodes}
};

static sipEnumMemberDef enummembers_QgsPointCloudDataProvider[] = {
    {sipName_ChangeAttributeValues, static_cast<int>(::QgsPointCloudDataProvider::ChangeAttributeValues), 1795},
    {sipName_ContainSubIndexes, static_cast<int>(::QgsPointCloudDataProvider::ContainSubIndexes), 1795},
    {sipName_CreateRenderer, static_cast<int>(::QgsPointCloudDataProvider::CreateRenderer), 1795},
    {sipName_Indexed, static_cast<int>(::QgsPointCloudDataProvider::Indexed), 1796},
    {sipName_Indexing, static_cast<int>(::QgsPointCloudDataProvider::Indexing), 1796},
    {sipName_NoCapabilities, static_cast<int>(::QgsPointCloudDataProvider::NoCapabilities), 1795},
    {sipName_NotIndexed, static_cast<int>(::QgsPointCloudDataProvider::NotIndexed), 1796},
    {sipName_ReadLayerMetadata, static_cast<int>(::QgsPointCloudDataProvider::ReadLayerMetadata), 1795},
    {sipName_WriteLayerMetadata, static_cast<int>(::QgsPointCloudDataProvider::WriteLayerMetadata), 1795},
};

PyDoc_STRVAR(doc_QgsPointCloudDataProvider, "Base class for providing data for :py:class:`QgsPointCloudLayer`.\n"
"\n"
"Responsible for reading native point cloud data and returning the\n"
"indexed data.\n"
"\n"
".. note::\n"
"\n"
"   The API is considered EXPERIMENTAL and can be changed without a notice\n"
"\n"
".. versionadded:: 3.18\n"
"\n"
"QgsPointCloudDataProvider(uri: Optional[str], providerOptions: QgsDataProvider.ProviderOptions, flags: Union[Qgis.DataProviderReadFlags, Qgis.DataProviderReadFlag] = Qgis.DataProviderReadFlags())\n"
"Ctor");


/* Define this type's signals. */
static const pyqt5QtSignal signals_QgsPointCloudDataProvider[] = {
    {"indexGenerationStateChanged(QgsPointCloudDataProvider::PointCloudIndexGenerationState)", "indexGenerationStateChanged(self, state: QgsPointCloudDataProvider.PointCloudIndexGenerationState)\nEmitted when point cloud generation state is changed", SIP_NULLPTR, SIP_NULLPTR},
    {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
};


static pyqt5ClassPluginDef plugin_QgsPointCloudDataProvider = {
    &::QgsPointCloudDataProvider::staticMetaObject,
    0,
    signals_QgsPointCloudDataProvider,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudDataProvider = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudDataProvider,
        SIP_NULLPTR,
        &plugin_QgsPointCloudDataProvider,
    },
    {
        sipNameNr_QgsPointCloudDataProvider,
        {0, 0, 1},
        33, methods_QgsPointCloudDataProvider,
        9, enummembers_QgsPointCloudDataProvider,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudDataProvider,
    -1,
    -1,
    supers_QgsPointCloudDataProvider,
    SIP_NULLPTR,
    init_type_QgsPointCloudDataProvider,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudDataProvider,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QgsPointCloudDataProvider,
    cast_QgsPointCloudDataProvider,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsPointCloudDataProvider),
};

#line 166 "auto_generated/pointcloud/qgspointcloudindex.sip"
#include "qgspointcloudindex.h"
#line 12681 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 38 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 12685 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "auto_generated/pointcloud/qgspointcloudindex.sip"
#include "qgspointcloudindex.h"
#line 12688 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 12691 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 24 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qvariantmap.sip"
#include <qvariant.h>
#line 12694 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 20 "auto_generated/qgsvector3d.sip"
#include "qgsvector3d.h"
#line 12697 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 32 "auto_generated/geometry/qgsbox3d.sip"
#include "qgsbox3d.h"
#line 12700 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 29 "auto_generated/geometry/qgsrectangle.sip"
#include "qgsrectangle.h"
#line 12703 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qhash.sip"
#include <qhash.h>
#line 12706 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 30 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 12709 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 106 "auto_generated/pointcloud/qgspointcloudattribute.sip"
#include "qgspointcloudattribute.h"
#line 12712 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 107 "auto_generated/pointcloud/qgspointcloudindex.sip"
#include "qgspointcloudindex.h"
#line 12715 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 39 "auto_generated/pointcloud/qgspointcloudstatistics.sip"
#include "qgspointcloudstatistics.h"
#line 12718 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 205 "auto_generated/proj/qgscoordinatereferencesystem.sip"
#include "qgscoordinatereferencesystem.h"
#line 12721 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 12724 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


PyDoc_STRVAR(doc_QgsPointCloudIndex_load, "load(self, fileName: Optional[str])\n"
"Loads the index from the file\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.load`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_load(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_load(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QgsPointCloudIndex *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fileName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp, sipType_QString, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->load(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_load, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_isValid, "isValid(self) -> bool\n"
"Returns whether index is loaded and valid\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.isValid`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_isValid(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->isValid();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_isValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_error, "error(self) -> str\n"
"Returns the error that occurred during the loading of the index.\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.error`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_error(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_error(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->error());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_error, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_accessType, "accessType(self) -> Qgis.PointCloudAccessType\n"
"Returns the access type of the data If the access type is Remote, data\n"
"will be fetched from an HTTP server either synchronously or\n"
"asynchronously If the access type is local, the data is stored locally\n"
"as a file and will only be fetch synchronously ( blocking request with\n"
"nodeData only )\n"
"\n"
".. note::\n"
"\n"
"   Always make sure to check before trying to use asyncNodeData since it is not supported in the case of local access type\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.accessType`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_accessType(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_accessType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::Qgis::PointCloudAccessType sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->accessType();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_Qgis_PointCloudAccessType);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_accessType, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_crs, "crs(self) -> QgsCoordinateReferenceSystem\n"
"Returns the coordinate reference system of the point cloud index\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.crs`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_crs(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_crs(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QgsCoordinateReferenceSystem*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsCoordinateReferenceSystem(sipCpp->crs());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsCoordinateReferenceSystem, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_crs, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_pointCount, "pointCount(self) -> int\n"
"Returns the number of points in the point cloud\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.pointCount`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_pointCount(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_pointCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::qint64 sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointCount();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_pointCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_originalMetadata, "originalMetadata(self) -> dict[str, Any]\n"
"Returns the original metadata map\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.originalMetadata`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_originalMetadata(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_originalMetadata(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QVariantMap*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QVariantMap(sipCpp->originalMetadata());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QVariantMap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_originalMetadata, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_metadataStatistics, "metadataStatistics(self) -> QgsPointCloudStatistics\n"
"Returns the object containing the statistics metadata extracted from the\n"
"dataset\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.metadataStatistics`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_metadataStatistics(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_metadataStatistics(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QgsPointCloudStatistics*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudStatistics(sipCpp->metadataStatistics());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudStatistics, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_metadataStatistics, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_writeStatistics, "writeStatistics(self, stats: QgsPointCloudStatistics) -> bool\n"
"Writes the statistics object ``stats`` into the backing file, if\n"
"possible. Returns true if the data was written successfully.\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.writeStatistics`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_writeStatistics(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_writeStatistics(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudStatistics* a0;
        ::QgsPointCloudIndex *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stats,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp, sipType_QgsPointCloudStatistics, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->writeStatistics(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_writeStatistics, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_root, "root(self) -> QgsPointCloudNodeId\n"
"Returns root node of the index\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.root`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_root(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_root(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QgsPointCloudNodeId*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudNodeId(sipCpp->root());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudNodeId, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_root, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_hasNode, "hasNode(self, id: QgsPointCloudNodeId) -> bool\n"
"Returns whether the octree contain given node\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.hasNode`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_hasNode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_hasNode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNodeId* a0;
        const ::QgsPointCloudIndex *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp, sipType_QgsPointCloudNodeId, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->hasNode(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_hasNode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_getNode, "getNode(self, id: QgsPointCloudNodeId) -> QgsPointCloudNode\n"
"Returns object for a given node\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.getNode`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_getNode(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_getNode(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNodeId* a0;
        const ::QgsPointCloudIndex *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp, sipType_QgsPointCloudNodeId, &a0))
        {
            ::QgsPointCloudNode*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudNode(sipCpp->getNode(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_getNode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_attributes, "attributes(self) -> QgsPointCloudAttributeCollection\n"
"Returns all attributes that are stored in the file\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.attributes`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_attributes(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_attributes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QgsPointCloudAttributeCollection*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudAttributeCollection(sipCpp->attributes());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudAttributeCollection, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_attributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_updateNodeData, "updateNodeData(self, data: dict[QgsPointCloudNodeId, Union[QByteArray, bytes, bytearray]]) -> bool\n"
"Tries to update the data for the specified nodes.\n"
"\n"
":return: ``True`` on success, otherwise ``False``");

extern "C" {static PyObject *meth_QgsPointCloudIndex_updateNodeData(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_updateNodeData(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const QHash< ::QgsPointCloudNodeId, ::QByteArray>* a0;
        int a0State = 0;
        ::QgsPointCloudIndex *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp, sipType_QHash_0100QgsPointCloudNodeId_0100QByteArray, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->updateNodeData(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast<QHash< ::QgsPointCloudNodeId, ::QByteArray> *>(a0), sipType_QHash_0100QgsPointCloudNodeId_0100QByteArray, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QHash< ::QgsPointCloudNodeId, ::QByteArray> *>(a0), sipType_QHash_0100QgsPointCloudNodeId_0100QByteArray, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_updateNodeData, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_extent, "extent(self) -> QgsRectangle\n"
"Returns extent of the data\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.extent`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_extent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_extent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QgsRectangle*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsRectangle(sipCpp->extent());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsRectangle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_extent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_zMin, "zMin(self) -> float\n"
"Returns z min\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.zMin`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_zMin(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_zMin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->zMin();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_zMin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_zMax, "zMax(self) -> float\n"
"Returns z max\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.zMax`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_zMax(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_zMax(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->zMax();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_zMax, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_rootNodeBounds, "rootNodeBounds(self) -> QgsBox3D\n"
"Returns bounding box of root node in CRS coords\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.rootNodeBounds`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_rootNodeBounds(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_rootNodeBounds(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QgsBox3D*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsBox3D(sipCpp->rootNodeBounds());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsBox3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_rootNodeBounds, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_scale, "scale(self) -> QgsVector3D\n"
"Returns scale of data relative to CRS\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.scale`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_scale(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_scale(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QgsVector3D*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsVector3D(sipCpp->scale());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_scale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_offset, "offset(self) -> QgsVector3D\n"
"Returns offset of data from CRS\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.offset`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_offset(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_offset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QgsVector3D*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsVector3D(sipCpp->offset());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_offset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_span, "span(self) -> int\n"
"Returns the number of points in one direction in a single node.\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.span`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_span(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_span(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->span();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_span, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_setSubsetString, "setSubsetString(self, subset: Optional[str]) -> bool\n"
"Sets the string used to define a subset of the point cloud.\n"
"\n"
":param subset: The subset string to be used in a\n"
"               ``:py:class:`QgsPointCloudExpression```\n"
"\n"
":return: true if the expression is parsed with no errors, false\n"
"         otherwise\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.setSubsetString`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_setSubsetString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_setSubsetString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QgsPointCloudIndex *sipCpp;

        static const char *sipKwdList[] = {
            sipName_subset,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp, sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->setSubsetString(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_setSubsetString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_subsetString, "subsetString(self) -> str\n"
"Returns the string used to define a subset of the point cloud.\n"
"\n"
":return: The subset string or empty string if not implemented by the\n"
"         provider\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.subsetString`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_subsetString(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_subsetString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->subsetString());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_subsetString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_extraMetadata, "extraMetadata(self) -> dict[str, Any]\n"
"Returns extra metadata that's not accessible through the other methods\n"
"in an implementation-specific dynamic structure.\n"
"\n"
".. seealso:: :py:func:`QgsAbstractPointCloudIndex.extraMetadata`");

extern "C" {static PyObject *meth_QgsPointCloudIndex_extraMetadata(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_extraMetadata(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            ::QVariantMap*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QVariantMap(sipCpp->extraMetadata());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QVariantMap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_extraMetadata, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_commitChanges, "commitChanges(self) -> (bool, Optional[str])\n"
"Tries to store pending changes to the data provider. If errorMessage is\n"
"not a null pointer, it will receive an error message in case the call\n"
"failed.\n"
"\n"
":return: ``True`` on success, otherwise ``False``");

extern "C" {static PyObject *meth_QgsPointCloudIndex_commitChanges(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_commitChanges(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QString* a0;
        ::QgsPointCloudIndex *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            bool sipRes;
            a0 = new ::QString();

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->commitChanges(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                delete a0;
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipBuildResult(0, "(bN)", sipRes, a0, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_commitChanges, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_isModified, "isModified(self) -> bool\n"
"Returns ``True`` if there are uncommitted changes, ``False`` otherwise");

extern "C" {static PyObject *meth_QgsPointCloudIndex_isModified(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_isModified(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->isModified();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_isModified, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudIndex_updatedNodes, "updatedNodes(self) -> list[QgsPointCloudNodeId]\n"
"Returns a list of node IDs that have been modified");

extern "C" {static PyObject *meth_QgsPointCloudIndex_updatedNodes(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudIndex_updatedNodes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudIndex *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudIndex, &sipCpp))
        {
            QList< ::QgsPointCloudNodeId>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QList< ::QgsPointCloudNodeId>(sipCpp->updatedNodes());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QList_0100QgsPointCloudNodeId, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudIndex, sipName_updatedNodes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QgsPointCloudIndex___int__(PyObject *);}
static PyObject *slot_QgsPointCloudIndex___int__(PyObject *sipSelf)
{
    ::QgsPointCloudIndex *sipCpp = reinterpret_cast< ::QgsPointCloudIndex *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudIndex));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = bool(*sipCpp);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudIndex(void *, int);}
static void release_QgsPointCloudIndex(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsPointCloudIndex *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QgsPointCloudIndex(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudIndex(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudIndex(sipGetAddress(sipSelf), 0);
    }
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QgsPointCloudIndex[] = {
    {(void *)slot_QgsPointCloudIndex___int__, int_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QgsPointCloudIndex[] = {
    {sipName_accessType, meth_QgsPointCloudIndex_accessType, METH_VARARGS, doc_QgsPointCloudIndex_accessType},
    {sipName_attributes, meth_QgsPointCloudIndex_attributes, METH_VARARGS, doc_QgsPointCloudIndex_attributes},
    {sipName_commitChanges, SIP_MLMETH_CAST(meth_QgsPointCloudIndex_commitChanges), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudIndex_commitChanges},
    {sipName_crs, meth_QgsPointCloudIndex_crs, METH_VARARGS, doc_QgsPointCloudIndex_crs},
    {sipName_error, meth_QgsPointCloudIndex_error, METH_VARARGS, doc_QgsPointCloudIndex_error},
    {sipName_extent, meth_QgsPointCloudIndex_extent, METH_VARARGS, doc_QgsPointCloudIndex_extent},
    {sipName_extraMetadata, meth_QgsPointCloudIndex_extraMetadata, METH_VARARGS, doc_QgsPointCloudIndex_extraMetadata},
    {sipName_getNode, SIP_MLMETH_CAST(meth_QgsPointCloudIndex_getNode), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudIndex_getNode},
    {sipName_hasNode, SIP_MLMETH_CAST(meth_QgsPointCloudIndex_hasNode), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudIndex_hasNode},
    {sipName_isModified, meth_QgsPointCloudIndex_isModified, METH_VARARGS, doc_QgsPointCloudIndex_isModified},
    {sipName_isValid, meth_QgsPointCloudIndex_isValid, METH_VARARGS, doc_QgsPointCloudIndex_isValid},
    {sipName_load, SIP_MLMETH_CAST(meth_QgsPointCloudIndex_load), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudIndex_load},
    {sipName_metadataStatistics, meth_QgsPointCloudIndex_metadataStatistics, METH_VARARGS, doc_QgsPointCloudIndex_metadataStatistics},
    {sipName_offset, meth_QgsPointCloudIndex_offset, METH_VARARGS, doc_QgsPointCloudIndex_offset},
    {sipName_originalMetadata, meth_QgsPointCloudIndex_originalMetadata, METH_VARARGS, doc_QgsPointCloudIndex_originalMetadata},
    {sipName_pointCount, meth_QgsPointCloudIndex_pointCount, METH_VARARGS, doc_QgsPointCloudIndex_pointCount},
    {sipName_root, meth_QgsPointCloudIndex_root, METH_VARARGS, doc_QgsPointCloudIndex_root},
    {sipName_rootNodeBounds, meth_QgsPointCloudIndex_rootNodeBounds, METH_VARARGS, doc_QgsPointCloudIndex_rootNodeBounds},
    {sipName_scale, meth_QgsPointCloudIndex_scale, METH_VARARGS, doc_QgsPointCloudIndex_scale},
    {sipName_setSubsetString, SIP_MLMETH_CAST(meth_QgsPointCloudIndex_setSubsetString), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudIndex_setSubsetString},
    {sipName_span, meth_QgsPointCloudIndex_span, METH_VARARGS, doc_QgsPointCloudIndex_span},
    {sipName_subsetString, meth_QgsPointCloudIndex_subsetString, METH_VARARGS, doc_QgsPointCloudIndex_subsetString},
    {sipName_updateNodeData, SIP_MLMETH_CAST(meth_QgsPointCloudIndex_updateNodeData), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudIndex_updateNodeData},
    {sipName_updatedNodes, meth_QgsPointCloudIndex_updatedNodes, METH_VARARGS, doc_QgsPointCloudIndex_updatedNodes},
    {sipName_writeStatistics, SIP_MLMETH_CAST(meth_QgsPointCloudIndex_writeStatistics), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudIndex_writeStatistics},
    {sipName_zMax, meth_QgsPointCloudIndex_zMax, METH_VARARGS, doc_QgsPointCloudIndex_zMax},
    {sipName_zMin, meth_QgsPointCloudIndex_zMin, METH_VARARGS, doc_QgsPointCloudIndex_zMin}
};

PyDoc_STRVAR(doc_QgsPointCloudIndex, "Smart pointer for :py:class:`QgsAbstractPointCloudIndex`.\n"
"\n"
"This is a wrapper for :py:class:`QgsAbstractPointCloudIndex`, an index\n"
"for point cloud layers. It contains a shared_pointer, ensuring that\n"
"concurrent access to the index is memory safe.\n"
"\n"
".. versionadded:: 3.42");


static pyqt5ClassPluginDef plugin_QgsPointCloudIndex = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudIndex = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudIndex,
        SIP_NULLPTR,
        &plugin_QgsPointCloudIndex,
    },
    {
        sipNameNr_QgsPointCloudIndex,
        {0, 0, 1},
        27, methods_QgsPointCloudIndex,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudIndex,
    -1,
    -1,
    SIP_NULLPTR,
    slots_QgsPointCloudIndex,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudIndex,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QgsPointCloudIndex,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};

#line 107 "auto_generated/pointcloud/qgspointcloudindex.sip"
#include "qgspointcloudindex.h"
#line 14274 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 28 "auto_generated/pointcloud/qgspointcloudindex.sip"
#include "qgspointcloudindex.h"
#line 14278 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 38 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 14281 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 32 "auto_generated/geometry/qgsbox3d.sip"
#include "qgsbox3d.h"
#line 14284 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


PyDoc_STRVAR(doc_QgsPointCloudNode_id, "id(self) -> QgsPointCloudNodeId\n"
"Returns node's ID (unique in index)");

extern "C" {static PyObject *meth_QgsPointCloudNode_id(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNode_id(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudNode, &sipCpp))
        {
            ::QgsPointCloudNodeId*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudNodeId(sipCpp->id());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudNodeId, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNode, sipName_id, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudNode_pointCount, "pointCount(self) -> int\n"
"Returns number of points contained in node data");

extern "C" {static PyObject *meth_QgsPointCloudNode_pointCount(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNode_pointCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudNode, &sipCpp))
        {
            ::qint64 sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointCount();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNode, sipName_pointCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudNode_children, "children(self) -> list[QgsPointCloudNodeId]\n"
"Returns IDs of child nodes");

extern "C" {static PyObject *meth_QgsPointCloudNode_children(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNode_children(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudNode, &sipCpp))
        {
            QList< ::QgsPointCloudNodeId>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QList< ::QgsPointCloudNodeId>(sipCpp->children());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QList_0100QgsPointCloudNodeId, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNode, sipName_children, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudNode_error, "error(self) -> float\n"
"Returns node's error in map units (used to determine in whether the node\n"
"has enough detail for the current view)");

extern "C" {static PyObject *meth_QgsPointCloudNode_error(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNode_error(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNode *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudNode, &sipCpp))
        {
            float sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->error();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNode, sipName_error, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudNode_bounds, "bounds(self) -> QgsBox3D\n"
"Returns node's bounding cube in CRS coords\n"
"\n"
"bounds(rootBounds: QgsBox3D, id: QgsPointCloudNodeId) -> QgsBox3D\n"
"Returns bounding box of specific node");

extern "C" {static PyObject *meth_QgsPointCloudNode_bounds(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNode_bounds(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNode *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QgsPointCloudNode, &sipCpp))
        {
            ::QgsBox3D*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsBox3D(sipCpp->bounds());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsBox3D, SIP_NULLPTR);
        }
    }

    {
        ::QgsBox3D* a0;
        ::QgsPointCloudNodeId* a1;

        static const char *sipKwdList[] = {
            sipName_rootBounds,
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9J9", sipType_QgsBox3D, &a0, sipType_QgsPointCloudNodeId, &a1))
        {
            ::QgsBox3D*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsBox3D(::QgsPointCloudNode::bounds(*a0, *a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsBox3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNode, sipName_bounds, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudNode(void *, int);}
static void release_QgsPointCloudNode(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsPointCloudNode *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QgsPointCloudNode(void *, Py_ssize_t, void *);}
static void assign_QgsPointCloudNode(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsPointCloudNode *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsPointCloudNode *>(sipSrc);
}


extern "C" {static void *copy_QgsPointCloudNode(const void *, Py_ssize_t);}
static void *copy_QgsPointCloudNode(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsPointCloudNode(reinterpret_cast<const ::QgsPointCloudNode *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsPointCloudNode(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudNode(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudNode(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsPointCloudNode(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudNode(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsPointCloudNode *sipCpp = SIP_NULLPTR;

    {
        const ::QgsPointCloudNodeId* a0;
        ::qint64 a1;
        const QList< ::QgsPointCloudNodeId>* a2;
        int a2State = 0;
        float a3;
        const ::QgsBox3D* a4;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_pointCount,
            sipName_childIds,
            sipName_error,
            sipName_bounds,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9nJ1fJ9", sipType_QgsPointCloudNodeId, &a0, &a1, sipType_QList_0100QgsPointCloudNodeId, &a2, &a2State, &a3, sipType_QgsBox3D, &a4))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudNode(*a0, a1, *a2, a3, *a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast<QList< ::QgsPointCloudNodeId> *>(a2), sipType_QList_0100QgsPointCloudNodeId, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QList< ::QgsPointCloudNodeId> *>(a2), sipType_QList_0100QgsPointCloudNodeId, a2State);

            return sipCpp;
        }
    }

    {
        const ::QgsPointCloudNode* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsPointCloudNode, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudNode(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsPointCloudNode[] = {
    {sipName_bounds, SIP_MLMETH_CAST(meth_QgsPointCloudNode_bounds), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudNode_bounds},
    {sipName_children, meth_QgsPointCloudNode_children, METH_VARARGS, doc_QgsPointCloudNode_children},
    {sipName_error, meth_QgsPointCloudNode_error, METH_VARARGS, doc_QgsPointCloudNode_error},
    {sipName_id, meth_QgsPointCloudNode_id, METH_VARARGS, doc_QgsPointCloudNode_id},
    {sipName_pointCount, meth_QgsPointCloudNode_pointCount, METH_VARARGS, doc_QgsPointCloudNode_pointCount}
};

PyDoc_STRVAR(doc_QgsPointCloudNode, "Keeps metadata for an indexed point cloud node.\n"
"\n"
".. note::\n"
"\n"
"   The API is considered EXPERIMENTAL and can be changed without a notice\n"
"\n"
".. versionadded:: 3.42\n"
"\n"
"QgsPointCloudNode(id: QgsPointCloudNodeId, pointCount: int, childIds: Iterable[QgsPointCloudNodeId], error: float, bounds: QgsBox3D)\n"
"Constructs new node object. Should only be called by\n"
":py:func:`QgsAbstractPointCloudIndex.getNode()`. Bounds should always be\n"
"computed by :py:func:`QgsPointCloudNode.bounds()`.\n"
"\n"
"QgsPointCloudNode(a0: QgsPointCloudNode)");


static pyqt5ClassPluginDef plugin_QgsPointCloudNode = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudNode = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudNode,
        SIP_NULLPTR,
        &plugin_QgsPointCloudNode,
    },
    {
        sipNameNr_QgsPointCloudNode,
        {0, 0, 1},
        5, methods_QgsPointCloudNode,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudNode,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsPointCloudNode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudNode,
    assign_QgsPointCloudNode,
    SIP_NULLPTR,
    copy_QgsPointCloudNode,
    release_QgsPointCloudNode,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsPointCloudNode),
};

#line 28 "auto_generated/pointcloud/qgspointcloudindex.sip"
#include "qgspointcloudindex.h"
#line 14765 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 14769 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


PyDoc_STRVAR(doc_QgsPointCloudNodeId_isValid, "isValid(self) -> bool\n"
"Returns whether node is valid");

extern "C" {static PyObject *meth_QgsPointCloudNodeId_isValid(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNodeId_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNodeId *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudNodeId, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->isValid();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNodeId, sipName_isValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudNodeId_parentNode, "parentNode(self) -> QgsPointCloudNodeId\n"
"Returns the parent of the node\n"
"\n"
".. versionadded:: 3.20");

extern "C" {static PyObject *meth_QgsPointCloudNodeId_parentNode(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNodeId_parentNode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNodeId *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudNodeId, &sipCpp))
        {
            ::QgsPointCloudNodeId*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudNodeId(sipCpp->parentNode());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudNodeId, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNodeId, sipName_parentNode, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudNodeId_fromString, "fromString(str: Optional[str]) -> QgsPointCloudNodeId\n"
"Creates node from string");

extern "C" {static PyObject *meth_QgsPointCloudNodeId_fromString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNodeId_fromString(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        static const char *sipKwdList[] = {
            sipName_str,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_QString, &a0, &a0State))
        {
            ::QgsPointCloudNodeId*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudNodeId(::QgsPointCloudNodeId::fromString(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudNodeId, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNodeId, sipName_fromString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudNodeId_toString, "toString(self) -> str\n"
"Encode node to string");

extern "C" {static PyObject *meth_QgsPointCloudNodeId_toString(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNodeId_toString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNodeId *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudNodeId, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->toString());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNodeId, sipName_toString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudNodeId_d, "d(self) -> int\n"
"Returns d");

extern "C" {static PyObject *meth_QgsPointCloudNodeId_d(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNodeId_d(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNodeId *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudNodeId, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->d();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNodeId, sipName_d, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudNodeId_x, "x(self) -> int\n"
"Returns x");

extern "C" {static PyObject *meth_QgsPointCloudNodeId_x(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNodeId_x(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNodeId *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudNodeId, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->x();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNodeId, sipName_x, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudNodeId_y, "y(self) -> int\n"
"Returns y");

extern "C" {static PyObject *meth_QgsPointCloudNodeId_y(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNodeId_y(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNodeId *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudNodeId, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->y();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNodeId, sipName_y, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudNodeId_z, "z(self) -> int\n"
"Returns z");

extern "C" {static PyObject *meth_QgsPointCloudNodeId_z(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudNodeId_z(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudNodeId *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudNodeId, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->z();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudNodeId, sipName_z, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QgsPointCloudNodeId___ne__(PyObject *, PyObject *);}
static PyObject *slot_QgsPointCloudNodeId___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QgsPointCloudNodeId *sipCpp = reinterpret_cast< ::QgsPointCloudNodeId *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudNodeId));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudNodeId* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QgsPointCloudNodeId, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = !sipCpp->::QgsPointCloudNodeId::operator==(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_QgsPointCloudNodeId, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QgsPointCloudNodeId___eq__(PyObject *, PyObject *);}
static PyObject *slot_QgsPointCloudNodeId___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QgsPointCloudNodeId *sipCpp = reinterpret_cast< ::QgsPointCloudNodeId *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudNodeId));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudNodeId* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QgsPointCloudNodeId, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->::QgsPointCloudNodeId::operator==(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_QgsPointCloudNodeId, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudNodeId(void *, int);}
static void release_QgsPointCloudNodeId(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsPointCloudNodeId *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsPointCloudNodeId(Py_ssize_t);}
static void *array_QgsPointCloudNodeId(Py_ssize_t sipNrElem)
{
    return new ::QgsPointCloudNodeId[sipNrElem];
}


extern "C" {static void array_delete_QgsPointCloudNodeId(void *);}
static void array_delete_QgsPointCloudNodeId(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsPointCloudNodeId *>(sipCpp);
}


extern "C" {static void assign_QgsPointCloudNodeId(void *, Py_ssize_t, void *);}
static void assign_QgsPointCloudNodeId(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsPointCloudNodeId *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsPointCloudNodeId *>(sipSrc);
}


extern "C" {static void *copy_QgsPointCloudNodeId(const void *, Py_ssize_t);}
static void *copy_QgsPointCloudNodeId(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsPointCloudNodeId(reinterpret_cast<const ::QgsPointCloudNodeId *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsPointCloudNodeId(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudNodeId(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudNodeId(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsPointCloudNodeId(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudNodeId(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsPointCloudNodeId *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudNodeId();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        int a0;
        int a1;
        int a2;
        int a3;

        static const char *sipKwdList[] = {
            sipName__d,
            sipName__x,
            sipName__y,
            sipName__z,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iiii", &a0, &a1, &a2, &a3))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudNodeId(a0, a1, a2, a3);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsPointCloudNodeId* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsPointCloudNodeId, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudNodeId(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QgsPointCloudNodeId[] = {
    {(void *)slot_QgsPointCloudNodeId___ne__, ne_slot},
    {(void *)slot_QgsPointCloudNodeId___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QgsPointCloudNodeId[] = {
    {sipName_d, meth_QgsPointCloudNodeId_d, METH_VARARGS, doc_QgsPointCloudNodeId_d},
    {sipName_fromString, SIP_MLMETH_CAST(meth_QgsPointCloudNodeId_fromString), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudNodeId_fromString},
    {sipName_isValid, meth_QgsPointCloudNodeId_isValid, METH_VARARGS, doc_QgsPointCloudNodeId_isValid},
    {sipName_parentNode, meth_QgsPointCloudNodeId_parentNode, METH_VARARGS, doc_QgsPointCloudNodeId_parentNode},
    {sipName_toString, meth_QgsPointCloudNodeId_toString, METH_VARARGS, doc_QgsPointCloudNodeId_toString},
    {sipName_x, meth_QgsPointCloudNodeId_x, METH_VARARGS, doc_QgsPointCloudNodeId_x},
    {sipName_y, meth_QgsPointCloudNodeId_y, METH_VARARGS, doc_QgsPointCloudNodeId_y},
    {sipName_z, meth_QgsPointCloudNodeId_z, METH_VARARGS, doc_QgsPointCloudNodeId_z}
};

PyDoc_STRVAR(doc_QgsPointCloudNodeId, "Represents an indexed point cloud node's position in octree.\n"
"\n"
".. note::\n"
"\n"
"   The API is considered EXPERIMENTAL and can be changed without a notice\n"
"\n"
".. versionadded:: 3.18\n"
"\n"
"QgsPointCloudNodeId()\n"
"Constructs invalid node\n"
"\n"
"QgsPointCloudNodeId(_d: int, _x: int, _y: int, _z: int)\n"
"Constructs valid node\n"
"\n"
"QgsPointCloudNodeId(a0: QgsPointCloudNodeId)");


static pyqt5ClassPluginDef plugin_QgsPointCloudNodeId = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudNodeId = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudNodeId,
        SIP_NULLPTR,
        &plugin_QgsPointCloudNodeId,
    },
    {
        sipNameNr_QgsPointCloudNodeId,
        {0, 0, 1},
        8, methods_QgsPointCloudNodeId,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudNodeId,
    -1,
    -1,
    SIP_NULLPTR,
    slots_QgsPointCloudNodeId,
    init_type_QgsPointCloudNodeId,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudNodeId,
    assign_QgsPointCloudNodeId,
    array_QgsPointCloudNodeId,
    copy_QgsPointCloudNodeId,
    release_QgsPointCloudNodeId,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsPointCloudNodeId,
    sizeof (::QgsPointCloudNodeId),
};

#line 23 "auto_generated/pointcloud/qgspointcloudlayerelevationproperties.sip"
#include "qgspointcloudlayerelevationproperties.h"
#line 15505 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
#include <qobject.h>
#line 15509 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 15512 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtGui/qcolor.sip"
#include <qcolor.h>
#line 15515 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 751 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 15518 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "auto_generated/qgsmaplayer.sip"
#include "qgsmaplayer.h"
#line 15521 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 163 "auto_generated/qgsrange.sip"
#include "qgsrange.h"
typedef QgsRange<double> QgsRangedoubleBase;
#line 15525 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 15528 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 312 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 15531 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 21 "auto_generated/qgsreadwritecontext.sip"
#include "qgsreadwritecontext.h"
#line 15534 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 192 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 15537 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 29 "auto_generated/qgsmaplayerelevationproperties.sip"
#include "qgsmaplayerelevationproperties.h"
#include "qgspointcloudlayerelevationproperties.h"
#include "qgsrasterlayerelevationproperties.h"
#include "qgsvectorlayerelevationproperties.h"
#include "qgsmeshlayerelevationproperties.h"
#include "qgstiledscenelayerelevationproperties.h"
#line 15545 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 146 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qmap.sip"
#include <qmap.h>
#line 15548 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 25 "auto_generated/qgsproperty.sip"
#include "qgsproperty.h"
#line 15551 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 421 "auto_generated/qgspropertycollection.sip"
#include "qgspropertycollection.h"
#line 15554 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 29 "auto_generated/qgsmaplayerelevationproperties.sip"
#include "qgsmaplayerelevationproperties.h"
#include "qgspointcloudlayerelevationproperties.h"
#include "qgsrasterlayerelevationproperties.h"
#include "qgsvectorlayerelevationproperties.h"
#include "qgsmeshlayerelevationproperties.h"
#include "qgstiledscenelayerelevationproperties.h"
#line 15562 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 146 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 15567 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 15570 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 15573 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 252 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 15576 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 240 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 15579 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qvariant.sip"
#include <qvariant.h>
#line 15582 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 38 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 15585 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 30 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 15588 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 149 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 15591 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 15594 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qthread.sip"
#include <qthread.h>
#line 15597 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 15600 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qregexp.sip"
#include <qregexp.h>
#line 15603 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qregularexpression.sip"
#include <qregularexpression.h>
#line 15606 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 15609 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


class sipQgsPointCloudLayerElevationProperties : public ::QgsPointCloudLayerElevationProperties
{
public:
    sipQgsPointCloudLayerElevationProperties(::QObject*);
    virtual ~sipQgsPointCloudLayerElevationProperties();

    int qt_metacall(QMetaObject::Call, int, void **) SIP_OVERRIDE;
    void *qt_metacast(const char *) SIP_OVERRIDE;
    const QMetaObject *metaObject() const SIP_OVERRIDE;

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    ::QObject* sipProtect_sender() const;
    int sipProtect_receivers(const char*) const;
    void sipProtectVirt_timerEvent(bool, ::QTimerEvent*);
    void sipProtectVirt_childEvent(bool, ::QChildEvent*);
    void sipProtectVirt_customEvent(bool, ::QEvent*);
    void sipProtectVirt_connectNotify(bool, const ::QMetaMethod&);
    void sipProtectVirt_disconnectNotify(bool, const ::QMetaMethod&);
    int sipProtect_senderSignalIndex() const;
    bool sipProtect_isSignalConnected(const ::QMetaMethod&) const;
    void sipProtect_writeCommonProperties(::QDomElement&, ::QDomDocument&, const ::QgsReadWriteContext&);
    void sipProtect_readCommonProperties(const ::QDomElement&, const ::QgsReadWriteContext&);
    void sipProtect_copyCommonProperties(const ::QgsMapLayerElevationProperties*);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void disconnectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void connectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void customEvent(::QEvent*) SIP_OVERRIDE;
    void childEvent(::QChildEvent*) SIP_OVERRIDE;
    void timerEvent(::QTimerEvent*) SIP_OVERRIDE;
    bool eventFilter(::QObject*, ::QEvent*) SIP_OVERRIDE;
    bool event(::QEvent*) SIP_OVERRIDE;
    bool hasElevation() const SIP_OVERRIDE;
    ::QDomElement writeXml(::QDomElement&, ::QDomDocument&, const ::QgsReadWriteContext&) SIP_OVERRIDE;
    bool readXml(const ::QDomElement&, const ::QgsReadWriteContext&) SIP_OVERRIDE;
    void setDefaultsFromLayer(::QgsMapLayer*) SIP_OVERRIDE;
    ::QString htmlSummary() const SIP_OVERRIDE;
    ::QgsPointCloudLayerElevationProperties* clone() const SIP_OVERRIDE;
    bool isVisibleInZRange(const ::QgsDoubleRange&, ::QgsMapLayer*) const SIP_OVERRIDE;
    ::QgsMapLayerElevationProperties::Flags flags() const SIP_OVERRIDE;
    ::QgsDoubleRange calculateZRange(::QgsMapLayer*) const SIP_OVERRIDE;
    ::QList< ::qreal> significantZValues(::QgsMapLayer*) const SIP_OVERRIDE;
    bool showByDefaultInElevationProfilePlots() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQgsPointCloudLayerElevationProperties(const sipQgsPointCloudLayerElevationProperties &);
    sipQgsPointCloudLayerElevationProperties &operator = (const sipQgsPointCloudLayerElevationProperties &);

    char sipPyMethods[18];
};

sipQgsPointCloudLayerElevationProperties::sipQgsPointCloudLayerElevationProperties(::QObject*a0): ::QgsPointCloudLayerElevationProperties(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsPointCloudLayerElevationProperties::~sipQgsPointCloudLayerElevationProperties()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

const QMetaObject *sipQgsPointCloudLayerElevationProperties::metaObject() const
{
    if (sipGetInterpreter())
        return QObject::d_ptr->metaObject ? QObject::d_ptr->dynamicMetaObject() : sip__core_qt_metaobject(sipPySelf, sipType_QgsPointCloudLayerElevationProperties);

    return ::QgsPointCloudLayerElevationProperties::metaObject();
}

int sipQgsPointCloudLayerElevationProperties::qt_metacall(QMetaObject::Call _c, int _id, void **_a)
{
    _id = ::QgsPointCloudLayerElevationProperties::qt_metacall(_c, _id, _a);

    if (_id >= 0)
    {
        SIP_BLOCK_THREADS
        _id = sip__core_qt_metacall(sipPySelf, sipType_QgsPointCloudLayerElevationProperties, _c, _id, _a);
        SIP_UNBLOCK_THREADS
    }

    return _id;
}

void *sipQgsPointCloudLayerElevationProperties::qt_metacast(const char *_clname)
{
    void *sipCpp;

    return (sip__core_qt_metacast(sipPySelf, sipType_QgsPointCloudLayerElevationProperties, _clname, &sipCpp) ? sipCpp : ::QgsPointCloudLayerElevationProperties::qt_metacast(_clname));
}

void sipQgsPointCloudLayerElevationProperties::disconnectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_disconnectNotify);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerElevationProperties::disconnectNotify(a0);
        return;
    }

    extern void sipVH__core_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH__core_3(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayerElevationProperties::connectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_connectNotify);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerElevationProperties::connectNotify(a0);
        return;
    }

    extern void sipVH__core_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH__core_3(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayerElevationProperties::customEvent(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_customEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerElevationProperties::customEvent(a0);
        return;
    }

    extern void sipVH__core_4(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    sipVH__core_4(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayerElevationProperties::childEvent(::QChildEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_childEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerElevationProperties::childEvent(a0);
        return;
    }

    extern void sipVH__core_5(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QChildEvent*);

    sipVH__core_5(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayerElevationProperties::timerEvent(::QTimerEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_timerEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerElevationProperties::timerEvent(a0);
        return;
    }

    extern void sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QTimerEvent*);

    sipVH__core_6(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQgsPointCloudLayerElevationProperties::eventFilter(::QObject*a0, ::QEvent*a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, SIP_NULLPTR, sipName_eventFilter);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::eventFilter(a0, a1);

    extern bool sipVH__core_7(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QObject*, ::QEvent*);

    return sipVH__core_7(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudLayerElevationProperties::event(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_event);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::event(a0);

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    return sipVH__core_8(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQgsPointCloudLayerElevationProperties::hasElevation() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[7]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_hasElevation);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::hasElevation();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QDomElement sipQgsPointCloudLayerElevationProperties::writeXml(::QDomElement& a0, ::QDomDocument& a1, const ::QgsReadWriteContext& a2)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[8], &sipPySelf, SIP_NULLPTR, sipName_writeXml);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::writeXml(a0, a1, a2);

    extern ::QDomElement sipVH__core_170(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomElement&, ::QDomDocument&, const ::QgsReadWriteContext&);

    return sipVH__core_170(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2);
}

bool sipQgsPointCloudLayerElevationProperties::readXml(const ::QDomElement& a0, const ::QgsReadWriteContext& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[9], &sipPySelf, SIP_NULLPTR, sipName_readXml);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::readXml(a0, a1);

    extern bool sipVH__core_171(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QDomElement&, const ::QgsReadWriteContext&);

    return sipVH__core_171(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

void sipQgsPointCloudLayerElevationProperties::setDefaultsFromLayer(::QgsMapLayer*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[10], &sipPySelf, SIP_NULLPTR, sipName_setDefaultsFromLayer);

    if (!sipMeth)
    {
        ::QgsPointCloudLayerElevationProperties::setDefaultsFromLayer(a0);
        return;
    }

    extern void sipVH__core_172(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsMapLayer*);

    sipVH__core_172(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QString sipQgsPointCloudLayerElevationProperties::htmlSummary() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[11]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_htmlSummary);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::htmlSummary();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsPointCloudLayerElevationProperties* sipQgsPointCloudLayerElevationProperties::clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[12]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_clone);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::clone();

    extern ::QgsPointCloudLayerElevationProperties* sipVH__core_747(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_747(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudLayerElevationProperties::isVisibleInZRange(const ::QgsDoubleRange& a0, ::QgsMapLayer*a1) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[13]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_isVisibleInZRange);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::isVisibleInZRange(a0, a1);

    extern bool sipVH__core_174(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsDoubleRange&, ::QgsMapLayer*);

    return sipVH__core_174(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

::QgsMapLayerElevationProperties::Flags sipQgsPointCloudLayerElevationProperties::flags() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[14]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_flags);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::flags();

    extern ::QgsMapLayerElevationProperties::Flags sipVH__core_175(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_175(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsDoubleRange sipQgsPointCloudLayerElevationProperties::calculateZRange(::QgsMapLayer*a0) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[15]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_calculateZRange);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::calculateZRange(a0);

    extern ::QgsDoubleRange sipVH__core_176(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsMapLayer*);

    return sipVH__core_176(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QList< ::qreal> sipQgsPointCloudLayerElevationProperties::significantZValues(::QgsMapLayer*a0) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[16]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_significantZValues);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::significantZValues(a0);

    extern ::QList< ::qreal> sipVH__core_177(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsMapLayer*);

    return sipVH__core_177(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQgsPointCloudLayerElevationProperties::showByDefaultInElevationProfilePlots() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[17]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_showByDefaultInElevationProfilePlots);

    if (!sipMeth)
        return ::QgsPointCloudLayerElevationProperties::showByDefaultInElevationProfilePlots();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QObject* sipQgsPointCloudLayerElevationProperties::sipProtect_sender() const
{
    return ::QObject::sender();
}

int sipQgsPointCloudLayerElevationProperties::sipProtect_receivers(const char*a0) const
{
    return ::QObject::receivers(a0);
}

void sipQgsPointCloudLayerElevationProperties::sipProtectVirt_timerEvent(bool sipSelfWasArg, ::QTimerEvent*a0)
{
    (sipSelfWasArg ? ::QObject::timerEvent(a0) : timerEvent(a0));
}

void sipQgsPointCloudLayerElevationProperties::sipProtectVirt_childEvent(bool sipSelfWasArg, ::QChildEvent*a0)
{
    (sipSelfWasArg ? ::QObject::childEvent(a0) : childEvent(a0));
}

void sipQgsPointCloudLayerElevationProperties::sipProtectVirt_customEvent(bool sipSelfWasArg, ::QEvent*a0)
{
    (sipSelfWasArg ? ::QObject::customEvent(a0) : customEvent(a0));
}

void sipQgsPointCloudLayerElevationProperties::sipProtectVirt_connectNotify(bool sipSelfWasArg, const ::QMetaMethod& a0)
{
    (sipSelfWasArg ? ::QObject::connectNotify(a0) : connectNotify(a0));
}

void sipQgsPointCloudLayerElevationProperties::sipProtectVirt_disconnectNotify(bool sipSelfWasArg, const ::QMetaMethod& a0)
{
    (sipSelfWasArg ? ::QObject::disconnectNotify(a0) : disconnectNotify(a0));
}

int sipQgsPointCloudLayerElevationProperties::sipProtect_senderSignalIndex() const
{
    return ::QObject::senderSignalIndex();
}

bool sipQgsPointCloudLayerElevationProperties::sipProtect_isSignalConnected(const ::QMetaMethod& a0) const
{
    return ::QObject::isSignalConnected(a0);
}

void sipQgsPointCloudLayerElevationProperties::sipProtect_writeCommonProperties(::QDomElement& a0, ::QDomDocument& a1, const ::QgsReadWriteContext& a2)
{
    ::QgsMapLayerElevationProperties::writeCommonProperties(a0, a1, a2);
}

void sipQgsPointCloudLayerElevationProperties::sipProtect_readCommonProperties(const ::QDomElement& a0, const ::QgsReadWriteContext& a1)
{
    ::QgsMapLayerElevationProperties::readCommonProperties(a0, a1);
}

void sipQgsPointCloudLayerElevationProperties::sipProtect_copyCommonProperties(const ::QgsMapLayerElevationProperties*a0)
{
    ::QgsMapLayerElevationProperties::copyCommonProperties(a0);
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_sender, "sender(self) -> Optional[QObject]");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_sender(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_sender(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const sipQgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            ::QObject*sipRes = 0;

#line 570 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
        // sender() must be called without the GIL to avoid possible deadlocks between
        // the GIL and Qt's internal thread data mutex.
        
        Py_BEGIN_ALLOW_THREADS
        
        #if defined(SIP_PROTECTED_IS_PUBLIC)
        sipRes = sipCpp->sender();
        #else
        sipRes = sipCpp->sipProtect_sender();
        #endif
        
        Py_END_ALLOW_THREADS
        
        if (!sipRes)
        {
            typedef QObject *(*qtcore_qobject_sender_t)();
        
            static qtcore_qobject_sender_t qtcore_qobject_sender = 0;
        
            if (!qtcore_qobject_sender)
            {
                qtcore_qobject_sender = (qtcore_qobject_sender_t)sipImportSymbol("qtcore_qobject_sender");
                Q_ASSERT(qtcore_qobject_sender);
            }
        
            sipRes = qtcore_qobject_sender();
        }
#line 16103 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            return sipConvertFromType(sipRes, sipType_QObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_sender, doc_QgsPointCloudLayerElevationProperties_sender);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_receivers, "receivers(self, signal: PYQT_SIGNAL) -> int");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_receivers(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_receivers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * a0;
        const sipQgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BP0", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, &a0))
        {
            int sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 601 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
        // We need to handle the signal object.  Import the helper if it hasn't already
        // been done.
        typedef sipErrorState (*pyqt5_get_signal_signature_t)(PyObject *, const QObject *, const QByteArray &);
        
        static pyqt5_get_signal_signature_t pyqt5_get_signal_signature = 0;
        
        if (!pyqt5_get_signal_signature)
        {
            pyqt5_get_signal_signature = (pyqt5_get_signal_signature_t)sipImportSymbol("pyqt5_get_signal_signature");
            Q_ASSERT(pyqt5_get_signal_signature);
        }
        
        QByteArray signal_signature;
            
        #if defined(SIP_PROTECTED_IS_PUBLIC)
        if ((sipError = pyqt5_get_signal_signature(a0, sipCpp, signal_signature)) == sipErrorNone)
        {
            sipRes = sipCpp->receivers(signal_signature.constData());
        }
        #else
        if ((sipError = pyqt5_get_signal_signature(a0, static_cast<const QObject *>(sipCpp), signal_signature)) == sipErrorNone)
        {
            sipRes = sipCpp->sipProtect_receivers(signal_signature.constData());
        }
        #endif
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(0, a0);
        }
#line 16161 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyLong_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_receivers, doc_QgsPointCloudLayerElevationProperties_receivers);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_timerEvent, "timerEvent(self, a0: Optional[QTimerEvent])");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_timerEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_timerEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QTimerEvent* a0;
        sipQgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QTimerEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_timerEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_timerEvent, doc_QgsPointCloudLayerElevationProperties_timerEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_childEvent, "childEvent(self, a0: Optional[QChildEvent])");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_childEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_childEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QChildEvent* a0;
        sipQgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QChildEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_childEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_childEvent, doc_QgsPointCloudLayerElevationProperties_childEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_customEvent, "customEvent(self, a0: Optional[QEvent])");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_customEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_customEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QEvent* a0;
        sipQgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_customEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_customEvent, doc_QgsPointCloudLayerElevationProperties_customEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_connectNotify, "connectNotify(self, signal: QMetaMethod)");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_connectNotify(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_connectNotify(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QMetaMethod* a0;
        sipQgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QMetaMethod, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_connectNotify(sipSelfWasArg, *a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_connectNotify, doc_QgsPointCloudLayerElevationProperties_connectNotify);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_disconnectNotify, "disconnectNotify(self, signal: QMetaMethod)");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_disconnectNotify(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_disconnectNotify(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QMetaMethod* a0;
        sipQgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QMetaMethod, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_disconnectNotify(sipSelfWasArg, *a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_disconnectNotify, doc_QgsPointCloudLayerElevationProperties_disconnectNotify);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_senderSignalIndex, "senderSignalIndex(self) -> int");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_senderSignalIndex(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_senderSignalIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const sipQgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sipProtect_senderSignalIndex();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_senderSignalIndex, doc_QgsPointCloudLayerElevationProperties_senderSignalIndex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_isSignalConnected, "isSignalConnected(self, signal: QMetaMethod) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_isSignalConnected(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_isSignalConnected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaMethod* a0;
        const sipQgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QMetaMethod, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sipProtect_isSignalConnected(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_isSignalConnected, doc_QgsPointCloudLayerElevationProperties_isSignalConnected);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_writeCommonProperties, "writeCommonProperties(self, element: QDomElement, doc: QDomDocument, context: QgsReadWriteContext)\n"
"Writes common class properties to a DOM ``element``, to be used later\n"
"with :py:func:`~QgsMapLayerElevationProperties.readXml`.\n"
"\n"
".. seealso:: :py:func:`readCommonProperties`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_writeCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_writeCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDomElement* a0;
        ::QDomDocument* a1;
        const ::QgsReadWriteContext* a2;
        sipQgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_doc,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9J9", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QDomElement, &a0, sipType_QDomDocument, &a1, sipType_QgsReadWriteContext, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_writeCommonProperties(*a0, *a1, *a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_writeCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_readCommonProperties, "readCommonProperties(self, element: QDomElement, context: QgsReadWriteContext)\n"
"Reads common class properties from a DOM ``element`` previously written\n"
"by :py:func:`~QgsMapLayerElevationProperties.writeXml`.\n"
"\n"
".. seealso:: :py:func:`writeCommonProperties`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_readCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_readCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;
        sipQgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_readCommonProperties(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_readCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_copyCommonProperties, "copyCommonProperties(self, other: Optional[QgsMapLayerElevationProperties])\n"
"Copies common properties from another object.\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_copyCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_copyCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsMapLayerElevationProperties* a0;
        sipQgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_other,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QgsMapLayerElevationProperties, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_copyCommonProperties(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_copyCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_hasElevation, "hasElevation(self) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_hasElevation(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_hasElevation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayerElevationProperties::hasElevation() : sipCpp->hasElevation());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_hasElevation, doc_QgsPointCloudLayerElevationProperties_hasElevation);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_writeXml, "writeXml(self, element: QDomElement, doc: QDomDocument, context: QgsReadWriteContext) -> QDomElement");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_writeXml(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_writeXml(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QDomElement* a0;
        ::QDomDocument* a1;
        const ::QgsReadWriteContext* a2;
        ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_doc,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9J9", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QDomElement, &a0, sipType_QDomDocument, &a1, sipType_QgsReadWriteContext, &a2))
        {
            ::QDomElement*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QDomElement((sipSelfWasArg ? sipCpp->::QgsPointCloudLayerElevationProperties::writeXml(*a0, *a1, *a2) : sipCpp->writeXml(*a0, *a1, *a2)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QDomElement, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_writeXml, doc_QgsPointCloudLayerElevationProperties_writeXml);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_readXml, "readXml(self, element: QDomElement, context: QgsReadWriteContext) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_readXml(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_readXml(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;
        ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayerElevationProperties::readXml(*a0, *a1) : sipCpp->readXml(*a0, *a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_readXml, doc_QgsPointCloudLayerElevationProperties_readXml);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_clone, "clone(self) -> Optional[QgsPointCloudLayerElevationProperties]");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_clone(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            ::QgsPointCloudLayerElevationProperties*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayerElevationProperties::clone() : sipCpp->clone());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudLayerElevationProperties, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_clone, doc_QgsPointCloudLayerElevationProperties_clone);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_htmlSummary, "htmlSummary(self) -> str");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_htmlSummary(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_htmlSummary(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString((sipSelfWasArg ? sipCpp->::QgsPointCloudLayerElevationProperties::htmlSummary() : sipCpp->htmlSummary()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_htmlSummary, doc_QgsPointCloudLayerElevationProperties_htmlSummary);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_isVisibleInZRange, "isVisibleInZRange(self, range: QgsDoubleRange, layer: Optional[QgsMapLayer] = None) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_isVisibleInZRange(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_isVisibleInZRange(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsDoubleRange* a0;
        ::QgsMapLayer* a1 = 0;
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_range,
            sipName_layer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|J8", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QgsDoubleRange, &a0, sipType_QgsMapLayer, &a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayerElevationProperties::isVisibleInZRange(*a0, a1) : sipCpp->isVisibleInZRange(*a0, a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_isVisibleInZRange, doc_QgsPointCloudLayerElevationProperties_isVisibleInZRange);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_calculateZRange, "calculateZRange(self, layer: Optional[QgsMapLayer]) -> QgsDoubleRange");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_calculateZRange(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_calculateZRange(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QgsMapLayer* a0;
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QgsMapLayer, &a0))
        {
            ::QgsDoubleRange*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsDoubleRange((sipSelfWasArg ? sipCpp->::QgsPointCloudLayerElevationProperties::calculateZRange(a0) : sipCpp->calculateZRange(a0)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsDoubleRange, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_calculateZRange, doc_QgsPointCloudLayerElevationProperties_calculateZRange);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_significantZValues, "significantZValues(self, layer: Optional[QgsMapLayer]) -> list[float]");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_significantZValues(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_significantZValues(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QgsMapLayer* a0;
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QgsMapLayer, &a0))
        {
            ::QList< ::qreal>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QList< ::qreal>((sipSelfWasArg ? sipCpp->::QgsPointCloudLayerElevationProperties::significantZValues(a0) : sipCpp->significantZValues(a0)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QList_2400, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_significantZValues, doc_QgsPointCloudLayerElevationProperties_significantZValues);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_showByDefaultInElevationProfilePlots, "showByDefaultInElevationProfilePlots(self) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_showByDefaultInElevationProfilePlots(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_showByDefaultInElevationProfilePlots(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayerElevationProperties::showByDefaultInElevationProfilePlots() : sipCpp->showByDefaultInElevationProfilePlots());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_showByDefaultInElevationProfilePlots, doc_QgsPointCloudLayerElevationProperties_showByDefaultInElevationProfilePlots);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_maximumScreenError, "maximumScreenError(self) -> float\n"
"Returns the maximum screen error allowed when generating elevation\n"
"profiles for the point cloud.\n"
"\n"
"Larger values result in a faster generation with less points included.\n"
"\n"
"Units are retrieved via\n"
":py:func:`~QgsPointCloudLayerElevationProperties.maximumScreenErrorUnit`.\n"
"\n"
".. seealso:: :py:func:`setMaximumScreenError`\n"
"\n"
".. seealso:: :py:func:`maximumScreenErrorUnit`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_maximumScreenError(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_maximumScreenError(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->maximumScreenError();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_maximumScreenError, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_setMaximumScreenError, "setMaximumScreenError(self, error: float)\n"
"Sets the maximum screen ``error`` allowed when generating elevation\n"
"profiles for the point cloud.\n"
"\n"
"Larger values result in a faster generation with less points included.\n"
"\n"
"Units are set via\n"
":py:func:`~QgsPointCloudLayerElevationProperties.setMaximumScreenErrorUnit`.\n"
"\n"
".. seealso:: :py:func:`maximumScreenError`\n"
"\n"
".. seealso:: :py:func:`setMaximumScreenErrorUnit`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_setMaximumScreenError(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_setMaximumScreenError(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_error,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bd", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setMaximumScreenError(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_setMaximumScreenError, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_maximumScreenErrorUnit, "maximumScreenErrorUnit(self) -> Qgis.RenderUnit\n"
"Returns the unit for the maximum screen error allowed when generating\n"
"elevation profiles for the point cloud.\n"
"\n"
".. seealso:: :py:func:`maximumScreenError`\n"
"\n"
".. seealso:: :py:func:`setMaximumScreenErrorUnit`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_maximumScreenErrorUnit(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_maximumScreenErrorUnit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            ::Qgis::RenderUnit sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->maximumScreenErrorUnit();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_Qgis_RenderUnit);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_maximumScreenErrorUnit, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_setMaximumScreenErrorUnit, "setMaximumScreenErrorUnit(self, unit: Qgis.RenderUnit)\n"
"Sets the ``unit`` for the maximum screen error allowed when generating\n"
"elevation profiles for the point cloud.\n"
"\n"
".. seealso:: :py:func:`setMaximumScreenError`\n"
"\n"
".. seealso:: :py:func:`maximumScreenErrorUnit`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_setMaximumScreenErrorUnit(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_setMaximumScreenErrorUnit(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::Qgis::RenderUnit a0;
        ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_unit,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_Qgis_RenderUnit, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setMaximumScreenErrorUnit(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_setMaximumScreenErrorUnit, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_pointSymbol, "pointSymbol(self) -> Qgis.PointCloudSymbol\n"
"Returns the symbol used drawing points in elevation profile charts.\n"
"\n"
".. seealso:: :py:func:`setPointSymbol`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_pointSymbol(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_pointSymbol(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            ::Qgis::PointCloudSymbol sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointSymbol();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_Qgis_PointCloudSymbol);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_pointSymbol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_setPointSymbol, "setPointSymbol(self, symbol: Qgis.PointCloudSymbol)\n"
"Sets the ``symbol`` used drawing points in elevation profile charts.\n"
"\n"
".. seealso:: :py:func:`pointSymbol`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_setPointSymbol(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_setPointSymbol(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::Qgis::PointCloudSymbol a0;
        ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_symbol,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_Qgis_PointCloudSymbol, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setPointSymbol(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_setPointSymbol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_pointColor, "pointColor(self) -> QColor\n"
"Returns the color used drawing points in elevation profile charts.\n"
"\n"
".. seealso:: :py:func:`setPointColor`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_pointColor(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_pointColor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            ::QColor*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QColor(sipCpp->pointColor());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QColor, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_pointColor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_setPointColor, "setPointColor(self, color: Union[QColor, Qt.GlobalColor])\n"
"Sets the ``color`` used drawing points in elevation profile charts.\n"
"\n"
".. seealso:: :py:func:`pointColor`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_setPointColor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_setPointColor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColor* a0;
        int a0State = 0;
        ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_color,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_QColor, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setPointColor(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QColor *>(a0), sipType_QColor, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QColor *>(a0), sipType_QColor, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_setPointColor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_applyOpacityByDistanceEffect, "applyOpacityByDistanceEffect(self) -> bool\n"
"Returns ``True`` if a reduced opacity by distance from profile curve\n"
"effect should be applied when drawing points in elevation profile\n"
"charts.\n"
"\n"
".. seealso:: :py:func:`setApplyOpacityByDistanceEffect`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_applyOpacityByDistanceEffect(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_applyOpacityByDistanceEffect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->applyOpacityByDistanceEffect();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_applyOpacityByDistanceEffect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_setApplyOpacityByDistanceEffect, "setApplyOpacityByDistanceEffect(self, apply: bool)\n"
"Sets whether a reduced opacity by distance from profile curve effect\n"
"should be applied when drawing points in elevation profile charts.\n"
"\n"
".. seealso:: :py:func:`applyOpacityByDistanceEffect`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_setApplyOpacityByDistanceEffect(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_setApplyOpacityByDistanceEffect(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_apply,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setApplyOpacityByDistanceEffect(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_setApplyOpacityByDistanceEffect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_setPointSize, "setPointSize(self, size: float)\n"
"Sets the point ``size`` used for drawing points in elevation profile\n"
"charts.\n"
"\n"
"Point size units are specified via\n"
":py:func:`~QgsPointCloudLayerElevationProperties.setPointSizeUnit`.\n"
"\n"
".. seealso:: :py:func:`pointSize`\n"
"\n"
".. seealso:: :py:func:`setPointSizeUnit`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_setPointSize(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_setPointSize(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bd", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setPointSize(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_setPointSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_pointSize, "pointSize(self) -> float\n"
"Returns the point size used for drawing points in elevation profile\n"
"charts.\n"
"\n"
"The point size units are retrieved by calling\n"
":py:func:`~QgsPointCloudLayerElevationProperties.pointSizeUnit`.\n"
"\n"
".. seealso:: :py:func:`setPointSize`\n"
"\n"
".. seealso:: :py:func:`pointSizeUnit`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_pointSize(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_pointSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointSize();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_pointSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_setPointSizeUnit, "setPointSizeUnit(self, units: Qgis.RenderUnit)\n"
"Sets the ``units`` used for the point size used for drawing points in\n"
"elevation profile charts.\n"
"\n"
".. seealso:: :py:func:`setPointSize`\n"
"\n"
".. seealso:: :py:func:`pointSizeUnit`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_setPointSizeUnit(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_setPointSizeUnit(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::Qgis::RenderUnit a0;
        ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_units,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, sipType_Qgis_RenderUnit, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setPointSizeUnit(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_setPointSizeUnit, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_pointSizeUnit, "pointSizeUnit(self) -> Qgis.RenderUnit\n"
"Returns the units used for the point size used for drawing points in\n"
"elevation profile charts.\n"
"\n"
".. seealso:: :py:func:`setPointSizeUnit`\n"
"\n"
".. seealso:: :py:func:`pointSize`\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_pointSizeUnit(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_pointSizeUnit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            ::Qgis::RenderUnit sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointSizeUnit();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_Qgis_RenderUnit);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_pointSizeUnit, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_respectLayerColors, "respectLayerColors(self) -> bool\n"
"Returns ``True`` if layer coloring should be respected when rendering\n"
"elevation profile plots.\n"
"\n"
".. seealso:: :py:func:`setRespectLayerColors`");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_respectLayerColors(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_respectLayerColors(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayerElevationProperties *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->respectLayerColors();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_respectLayerColors, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties_setRespectLayerColors, "setRespectLayerColors(self, enabled: bool)\n"
"Sets whether layer coloring should be respected when rendering elevation\n"
"profile plots.\n"
"\n"
".. seealso:: :py:func:`respectLayerColors`");

extern "C" {static PyObject *meth_QgsPointCloudLayerElevationProperties_setRespectLayerColors(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayerElevationProperties_setRespectLayerColors(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QgsPointCloudLayerElevationProperties *sipCpp;

        static const char *sipKwdList[] = {
            sipName_enabled,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_QgsPointCloudLayerElevationProperties, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setRespectLayerColors(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayerElevationProperties, sipName_setRespectLayerColors, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QgsPointCloudLayerElevationProperties(void *, const sipTypeDef *);}
static void *cast_QgsPointCloudLayerElevationProperties(void *sipCppV, const sipTypeDef *targetType)
{
    ::QgsPointCloudLayerElevationProperties *sipCpp = reinterpret_cast< ::QgsPointCloudLayerElevationProperties *>(sipCppV);

    if (targetType == sipType_QgsPointCloudLayerElevationProperties)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_QgsMapLayerElevationProperties)->ctd_cast(static_cast< ::QgsMapLayerElevationProperties *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudLayerElevationProperties(void *, int);}
static void release_QgsPointCloudLayerElevationProperties(void *sipCppV, int)
{
    ::QgsPointCloudLayerElevationProperties *sipCpp = reinterpret_cast< ::QgsPointCloudLayerElevationProperties *>(sipCppV);

    Py_BEGIN_ALLOW_THREADS

    if (QThread::currentThread() == sipCpp->thread())
        delete sipCpp;
    else
        sipCpp->deleteLater();

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_QgsPointCloudLayerElevationProperties(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudLayerElevationProperties(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQgsPointCloudLayerElevationProperties *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudLayerElevationProperties(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QgsPointCloudLayerElevationProperties(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudLayerElevationProperties(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **sipOwner, PyObject **sipParseErr)
{
    sipQgsPointCloudLayerElevationProperties *sipCpp = SIP_NULLPTR;

    {
        ::QObject* a0;

        static const char *sipKwdList[] = {
            sipName_parent,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "JH", sipType_QObject, &a0, sipOwner))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsPointCloudLayerElevationProperties(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QgsPointCloudLayerElevationProperties[] = {{1580, 255, 1}};


static PyMethodDef methods_QgsPointCloudLayerElevationProperties[] = {
    {sipName_applyOpacityByDistanceEffect, meth_QgsPointCloudLayerElevationProperties_applyOpacityByDistanceEffect, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_applyOpacityByDistanceEffect},
    {sipName_calculateZRange, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_calculateZRange), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_calculateZRange},
    {sipName_childEvent, meth_QgsPointCloudLayerElevationProperties_childEvent, METH_VARARGS, SIP_NULLPTR},
    {sipName_clone, meth_QgsPointCloudLayerElevationProperties_clone, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_clone},
    {sipName_connectNotify, meth_QgsPointCloudLayerElevationProperties_connectNotify, METH_VARARGS, SIP_NULLPTR},
    {sipName_copyCommonProperties, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_copyCommonProperties), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_customEvent, meth_QgsPointCloudLayerElevationProperties_customEvent, METH_VARARGS, SIP_NULLPTR},
    {sipName_disconnectNotify, meth_QgsPointCloudLayerElevationProperties_disconnectNotify, METH_VARARGS, SIP_NULLPTR},
    {sipName_hasElevation, meth_QgsPointCloudLayerElevationProperties_hasElevation, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_hasElevation},
    {sipName_htmlSummary, meth_QgsPointCloudLayerElevationProperties_htmlSummary, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_htmlSummary},
    {sipName_isSignalConnected, meth_QgsPointCloudLayerElevationProperties_isSignalConnected, METH_VARARGS, SIP_NULLPTR},
    {sipName_isVisibleInZRange, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_isVisibleInZRange), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_isVisibleInZRange},
    {sipName_maximumScreenError, meth_QgsPointCloudLayerElevationProperties_maximumScreenError, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_maximumScreenError},
    {sipName_maximumScreenErrorUnit, meth_QgsPointCloudLayerElevationProperties_maximumScreenErrorUnit, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_maximumScreenErrorUnit},
    {sipName_pointColor, meth_QgsPointCloudLayerElevationProperties_pointColor, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_pointColor},
    {sipName_pointSize, meth_QgsPointCloudLayerElevationProperties_pointSize, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_pointSize},
    {sipName_pointSizeUnit, meth_QgsPointCloudLayerElevationProperties_pointSizeUnit, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_pointSizeUnit},
    {sipName_pointSymbol, meth_QgsPointCloudLayerElevationProperties_pointSymbol, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_pointSymbol},
    {sipName_readCommonProperties, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_readCommonProperties), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_readXml, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_readXml), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_readXml},
    {sipName_receivers, meth_QgsPointCloudLayerElevationProperties_receivers, METH_VARARGS, SIP_NULLPTR},
    {sipName_respectLayerColors, meth_QgsPointCloudLayerElevationProperties_respectLayerColors, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_respectLayerColors},
    {sipName_sender, meth_QgsPointCloudLayerElevationProperties_sender, METH_VARARGS, SIP_NULLPTR},
    {sipName_senderSignalIndex, meth_QgsPointCloudLayerElevationProperties_senderSignalIndex, METH_VARARGS, SIP_NULLPTR},
    {sipName_setApplyOpacityByDistanceEffect, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_setApplyOpacityByDistanceEffect), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_setApplyOpacityByDistanceEffect},
    {sipName_setMaximumScreenError, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_setMaximumScreenError), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_setMaximumScreenError},
    {sipName_setMaximumScreenErrorUnit, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_setMaximumScreenErrorUnit), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_setMaximumScreenErrorUnit},
    {sipName_setPointColor, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_setPointColor), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_setPointColor},
    {sipName_setPointSize, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_setPointSize), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_setPointSize},
    {sipName_setPointSizeUnit, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_setPointSizeUnit), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_setPointSizeUnit},
    {sipName_setPointSymbol, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_setPointSymbol), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_setPointSymbol},
    {sipName_setRespectLayerColors, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_setRespectLayerColors), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_setRespectLayerColors},
    {sipName_showByDefaultInElevationProfilePlots, meth_QgsPointCloudLayerElevationProperties_showByDefaultInElevationProfilePlots, METH_VARARGS, doc_QgsPointCloudLayerElevationProperties_showByDefaultInElevationProfilePlots},
    {sipName_significantZValues, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_significantZValues), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_significantZValues},
    {sipName_timerEvent, meth_QgsPointCloudLayerElevationProperties_timerEvent, METH_VARARGS, SIP_NULLPTR},
    {sipName_writeCommonProperties, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_writeCommonProperties), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_writeXml, SIP_MLMETH_CAST(meth_QgsPointCloudLayerElevationProperties_writeXml), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayerElevationProperties_writeXml}
};

PyDoc_STRVAR(doc_QgsPointCloudLayerElevationProperties, "Point cloud layer specific subclass of\n"
":py:class:`QgsMapLayerElevationProperties`.\n"
"\n"
".. versionadded:: 3.18\n"
"\n"
"QgsPointCloudLayerElevationProperties(parent: Optional[QObject])\n"
"Constructor for QgsPointCloudLayerElevationProperties, with the\n"
"specified ``parent`` object.");


static pyqt5ClassPluginDef plugin_QgsPointCloudLayerElevationProperties = {
    &::QgsPointCloudLayerElevationProperties::staticMetaObject,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudLayerElevationProperties = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudLayerElevationProperties,
        SIP_NULLPTR,
        &plugin_QgsPointCloudLayerElevationProperties,
    },
    {
        sipNameNr_QgsPointCloudLayerElevationProperties,
        {0, 0, 1},
        37, methods_QgsPointCloudLayerElevationProperties,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudLayerElevationProperties,
    -1,
    -1,
    supers_QgsPointCloudLayerElevationProperties,
    SIP_NULLPTR,
    init_type_QgsPointCloudLayerElevationProperties,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudLayerElevationProperties,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QgsPointCloudLayerElevationProperties,
    cast_QgsPointCloudLayerElevationProperties,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsPointCloudLayerElevationProperties),
};

#line 28 "auto_generated/pointcloud/qgspointcloudlayer.sip"
#include "qgspointcloudlayer.h"
#line 18229 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 39 "auto_generated/proj/qgscoordinatetransformcontext.sip"
#include "qgscoordinatetransformcontext.h"
#line 18233 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudLayer_LayerOptions(void *, int);}
static void release_QgsPointCloudLayer_LayerOptions(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsPointCloudLayer_LayerOptions(Py_ssize_t);}
static void *array_QgsPointCloudLayer_LayerOptions(Py_ssize_t sipNrElem)
{
    return new ::QgsPointCloudLayer::LayerOptions[sipNrElem];
}


extern "C" {static void array_delete_QgsPointCloudLayer_LayerOptions(void *);}
static void array_delete_QgsPointCloudLayer_LayerOptions(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipCpp);
}


extern "C" {static void assign_QgsPointCloudLayer_LayerOptions(void *, Py_ssize_t, void *);}
static void assign_QgsPointCloudLayer_LayerOptions(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipSrc);
}


extern "C" {static void *copy_QgsPointCloudLayer_LayerOptions(const void *, Py_ssize_t);}
static void *copy_QgsPointCloudLayer_LayerOptions(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsPointCloudLayer::LayerOptions(reinterpret_cast<const ::QgsPointCloudLayer::LayerOptions *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsPointCloudLayer_LayerOptions(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudLayer_LayerOptions(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudLayer_LayerOptions(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QgsPointCloudLayer_LayerOptions(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudLayer_LayerOptions(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QgsPointCloudLayer::LayerOptions *sipCpp = SIP_NULLPTR;

    {
        const ::QgsCoordinateTransformContext& a0def = QgsCoordinateTransformContext();
        const ::QgsCoordinateTransformContext* a0 = &a0def;

        static const char *sipKwdList[] = {
            sipName_transformContext,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J9", sipType_QgsCoordinateTransformContext, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudLayer::LayerOptions(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const ::QgsPointCloudLayer::LayerOptions* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsPointCloudLayer_LayerOptions, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new ::QgsPointCloudLayer::LayerOptions(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static PyObject *varget_QgsPointCloudLayer_LayerOptions_loadDefaultStyle(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsPointCloudLayer_LayerOptions_loadDefaultStyle(void *sipSelf, PyObject *, PyObject *)
{
    bool sipVal;
    ::QgsPointCloudLayer::LayerOptions *sipCpp = reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipSelf);

    sipVal = sipCpp->loadDefaultStyle;

    return PyBool_FromLong(sipVal);
}


extern "C" {static int varset_QgsPointCloudLayer_LayerOptions_loadDefaultStyle(void *, PyObject *, PyObject *);}
static int varset_QgsPointCloudLayer_LayerOptions_loadDefaultStyle(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::QgsPointCloudLayer::LayerOptions *sipCpp = reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipSelf);

    sipVal = sipConvertToBool(sipPy);

    if (sipVal < 0)
        return -1;

    sipCpp->loadDefaultStyle = static_cast<bool>(sipVal);

    return 0;
}


extern "C" {static PyObject *varget_QgsPointCloudLayer_LayerOptions_skipCrsValidation(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsPointCloudLayer_LayerOptions_skipCrsValidation(void *sipSelf, PyObject *, PyObject *)
{
    bool sipVal;
    ::QgsPointCloudLayer::LayerOptions *sipCpp = reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipSelf);

    sipVal = sipCpp->skipCrsValidation;

    return PyBool_FromLong(sipVal);
}


extern "C" {static int varset_QgsPointCloudLayer_LayerOptions_skipCrsValidation(void *, PyObject *, PyObject *);}
static int varset_QgsPointCloudLayer_LayerOptions_skipCrsValidation(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::QgsPointCloudLayer::LayerOptions *sipCpp = reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipSelf);

    sipVal = sipConvertToBool(sipPy);

    if (sipVal < 0)
        return -1;

    sipCpp->skipCrsValidation = static_cast<bool>(sipVal);

    return 0;
}


extern "C" {static PyObject *varget_QgsPointCloudLayer_LayerOptions_skipIndexGeneration(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsPointCloudLayer_LayerOptions_skipIndexGeneration(void *sipSelf, PyObject *, PyObject *)
{
    bool sipVal;
    ::QgsPointCloudLayer::LayerOptions *sipCpp = reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipSelf);

    sipVal = sipCpp->skipIndexGeneration;

    return PyBool_FromLong(sipVal);
}


extern "C" {static int varset_QgsPointCloudLayer_LayerOptions_skipIndexGeneration(void *, PyObject *, PyObject *);}
static int varset_QgsPointCloudLayer_LayerOptions_skipIndexGeneration(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::QgsPointCloudLayer::LayerOptions *sipCpp = reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipSelf);

    sipVal = sipConvertToBool(sipPy);

    if (sipVal < 0)
        return -1;

    sipCpp->skipIndexGeneration = static_cast<bool>(sipVal);

    return 0;
}


extern "C" {static PyObject *varget_QgsPointCloudLayer_LayerOptions_skipStatisticsCalculation(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsPointCloudLayer_LayerOptions_skipStatisticsCalculation(void *sipSelf, PyObject *, PyObject *)
{
    bool sipVal;
    ::QgsPointCloudLayer::LayerOptions *sipCpp = reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipSelf);

    sipVal = sipCpp->skipStatisticsCalculation;

    return PyBool_FromLong(sipVal);
}


extern "C" {static int varset_QgsPointCloudLayer_LayerOptions_skipStatisticsCalculation(void *, PyObject *, PyObject *);}
static int varset_QgsPointCloudLayer_LayerOptions_skipStatisticsCalculation(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::QgsPointCloudLayer::LayerOptions *sipCpp = reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipSelf);

    sipVal = sipConvertToBool(sipPy);

    if (sipVal < 0)
        return -1;

    sipCpp->skipStatisticsCalculation = static_cast<bool>(sipVal);

    return 0;
}


extern "C" {static PyObject *varget_QgsPointCloudLayer_LayerOptions_transformContext(void *, PyObject *, PyObject *);}
static PyObject *varget_QgsPointCloudLayer_LayerOptions_transformContext(void *sipSelf, PyObject *sipPySelf, PyObject *)
{
    PyObject *sipPy;
    ::QgsCoordinateTransformContext*sipVal;
    ::QgsPointCloudLayer::LayerOptions *sipCpp = reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipSelf);

    sipPy = sipGetReference(sipPySelf, -135);

    if (sipPy)
        return sipPy;

    sipVal = &sipCpp->transformContext;

    sipPy = sipConvertFromType(sipVal, sipType_QgsCoordinateTransformContext, SIP_NULLPTR);

    if (sipPy)
    {
        sipKeepReference(sipPy, -134, sipPySelf);
        sipKeepReference(sipPySelf, -135, sipPy);
    }

    return sipPy;
}


extern "C" {static int varset_QgsPointCloudLayer_LayerOptions_transformContext(void *, PyObject *, PyObject *);}
static int varset_QgsPointCloudLayer_LayerOptions_transformContext(void *sipSelf, PyObject *sipPy, PyObject *)
{
    ::QgsCoordinateTransformContext*sipVal;
    ::QgsPointCloudLayer::LayerOptions *sipCpp = reinterpret_cast< ::QgsPointCloudLayer::LayerOptions *>(sipSelf);

    int sipIsErr = 0;
    sipVal = reinterpret_cast< ::QgsCoordinateTransformContext *>(sipForceConvertToType(sipPy, sipType_QgsCoordinateTransformContext, SIP_NULLPTR, SIP_NOT_NONE, SIP_NULLPTR, &sipIsErr));

    if (sipIsErr)
        return -1;

    sipCpp->transformContext = *sipVal;

    return 0;
}

sipVariableDef variables_QgsPointCloudLayer_LayerOptions[] = {
    {InstanceVariable, sipName_loadDefaultStyle, (PyMethodDef *)varget_QgsPointCloudLayer_LayerOptions_loadDefaultStyle, (PyMethodDef *)varset_QgsPointCloudLayer_LayerOptions_loadDefaultStyle, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_skipCrsValidation, (PyMethodDef *)varget_QgsPointCloudLayer_LayerOptions_skipCrsValidation, (PyMethodDef *)varset_QgsPointCloudLayer_LayerOptions_skipCrsValidation, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_skipIndexGeneration, (PyMethodDef *)varget_QgsPointCloudLayer_LayerOptions_skipIndexGeneration, (PyMethodDef *)varset_QgsPointCloudLayer_LayerOptions_skipIndexGeneration, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_skipStatisticsCalculation, (PyMethodDef *)varget_QgsPointCloudLayer_LayerOptions_skipStatisticsCalculation, (PyMethodDef *)varset_QgsPointCloudLayer_LayerOptions_skipStatisticsCalculation, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_transformContext, (PyMethodDef *)varget_QgsPointCloudLayer_LayerOptions_transformContext, (PyMethodDef *)varset_QgsPointCloudLayer_LayerOptions_transformContext, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_QgsPointCloudLayer_LayerOptions, "QgsPointCloudLayer.LayerOptions(transformContext: QgsCoordinateTransformContext = QgsCoordinateTransformContext())\n"
"Constructor for LayerOptions with optional ``transformContext``.\n"
"\n"
"QgsPointCloudLayer.LayerOptions(a0: QgsPointCloudLayer.LayerOptions)");


static pyqt5ClassPluginDef plugin_QgsPointCloudLayer_LayerOptions = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudLayer_LayerOptions = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudLayer__LayerOptions,
        SIP_NULLPTR,
        &plugin_QgsPointCloudLayer_LayerOptions,
    },
    {
        sipNameNr_LayerOptions,
        {1799, 255, 0},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        5, variables_QgsPointCloudLayer_LayerOptions,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudLayer_LayerOptions,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsPointCloudLayer_LayerOptions,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudLayer_LayerOptions,
    assign_QgsPointCloudLayer_LayerOptions,
    array_QgsPointCloudLayer_LayerOptions,
    copy_QgsPointCloudLayer_LayerOptions,
    release_QgsPointCloudLayer_LayerOptions,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsPointCloudLayer_LayerOptions,
    sizeof (::QgsPointCloudLayer::LayerOptions),
};

#line 28 "auto_generated/pointcloud/qgspointcloudlayer.sip"
#include "qgspointcloudlayer.h"
#line 18589 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 18593 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "auto_generated/pointcloud/qgspointcloudlayer.sip"
#include "qgspointcloudlayer.h"
#line 18596 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "auto_generated/pointcloud/qgspointcloudindex.sip"
#include "qgspointcloudindex.h"
#line 18599 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 166 "auto_generated/pointcloud/qgspointcloudindex.sip"
#include "qgspointcloudindex.h"
#line 18602 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 39 "auto_generated/pointcloud/qgspointcloudstatistics.sip"
#include "qgspointcloudstatistics.h"
#line 18605 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 179 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 18608 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 106 "auto_generated/pointcloud/qgspointcloudattribute.sip"
#include "qgspointcloudattribute.h"
#line 18611 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 29 "auto_generated/qgsmaplayerelevationproperties.sip"
#include "qgsmaplayerelevationproperties.h"
#include "qgspointcloudlayerelevationproperties.h"
#include "qgsrasterlayerelevationproperties.h"
#include "qgsvectorlayerelevationproperties.h"
#include "qgsmeshlayerelevationproperties.h"
#include "qgstiledscenelayerelevationproperties.h"
#line 18619 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 21 "auto_generated/qgsreadwritecontext.sip"
#include "qgsreadwritecontext.h"
#line 18622 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 39 "auto_generated/proj/qgscoordinatetransformcontext.sip"
#include "qgscoordinatetransformcontext.h"
#line 18625 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 54 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 18628 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 192 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 18631 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "auto_generated/qgsmaplayer.sip"
#include "qgsmaplayer.h"
#line 18634 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 29 "auto_generated/pointcloud/qgspointclouddataprovider.sip"
#include "qgspointclouddataprovider.h"
#line 18637 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 401 "auto_generated/elevation/qgsabstractprofilegenerator.sip"
#include "qgsabstractprofilegenerator.h"
#line 18640 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 23 "auto_generated/elevation/qgsprofilerequest.sip"
#include "qgsprofilerequest.h"
#line 18643 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 22 "auto_generated/elevation/qgsabstractprofilesource.sip"
#include "qgsabstractprofilesource.h"
#line 18646 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 37 "auto_generated/qgsmaplayerrenderer.sip"
#include "qgsmaplayerrenderer.h"
#line 18649 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "auto_generated/qgsrendercontext.sip"
#include "qgsrendercontext.h"
#line 18652 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 29 "auto_generated/geometry/qgsrectangle.sip"
#include "qgsrectangle.h"
#line 18655 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qset.sip"
#include <qset.h>
#line 18658 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "auto_generated/qgsmaplayerdependency.sip"
#include "qgsmaplayerdependency.h"
#line 18661 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 60 "auto_generated/qgserror.sip"
#include "qgserror.h"
#line 18664 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 20 "auto_generated/qgserror.sip"
#include "qgserror.h"
#line 18667 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 312 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 18670 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 32 "auto_generated/geometry/qgsbox3d.sip"
#include "qgsbox3d.h"
#line 18673 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtGui/qpainter.sip"
#include <qpainter.h>
#line 18676 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 36 "auto_generated/project/qgsproject.sip"
#include "qgsproject.h"
#line 18679 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 18682 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "auto_generated/qgsmaplayer.sip"
#include "qgsmaplayer.h"
#line 18685 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "auto_generated/qgsmaplayertemporalproperties.sip"
#include "qgsmaplayertemporalproperties.h"
#include "qgsrasterlayertemporalproperties.h"
#include "qgsmeshlayertemporalproperties.h"
#include "qgsvectorlayertemporalproperties.h"
#line 18691 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "auto_generated/qgsmaplayerselectionproperties.sip"
#include "qgsmaplayerselectionproperties.h"
#include "qgsvectorlayerselectionproperties.h"
#line 18695 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 23 "auto_generated/symbology/qgsstyleentityvisitor.sip"
#include "qgsstyleentityvisitor.h"
#line 18698 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 360 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 18701 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 41 "auto_generated/metadata/qgslayermetadata.sip"
#include "qgslayermetadata.h"
#line 18704 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 18707 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 29 "auto_generated/./3d/qgsabstract3drenderer.sip"
#include "qgsabstract3drenderer.h"
#line 18710 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 48 "auto_generated/qgsmaplayerstylemanager.sip"
#include "qgsmaplayerstylemanager.h"
#line 18713 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 22 "auto_generated/qgsmaplayerlegend.sip"
#include "qgsmaplayerlegend.h"
#line 18716 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 56 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtWidgets/qundostack.sip"
#include <qundostack.h>
#line 18719 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 21 "auto_generated/providers/qgsdataprovider.sip"
#include "qgsdataprovider.h"
#line 18722 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 20 "auto_generated/qgssldexportcontext.sip"
#include "qgssldexportcontext.h"
#line 18725 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 205 "auto_generated/proj/qgscoordinatereferencesystem.sip"
#include "qgscoordinatereferencesystem.h"
#line 18728 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 18731 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "auto_generated/qgsmaplayer.sip"
#include "qgsmaplayer.h"
#line 18734 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 36 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 18737 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 22 "auto_generated/qgsobjectcustomproperties.sip"
#include "qgsobjectcustomproperties.h"
#line 18740 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qvariant.sip"
#include <qvariant.h>
#line 18743 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 21 "auto_generated/providers/qgsdataprovider.sip"
#include "qgsdataprovider.h"
#line 18746 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 219 "auto_generated/qgsmaplayerserverproperties.sip"
#include "qgsmaplayerserverproperties.h"
#line 18749 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 144 "auto_generated/providers/qgsprovidermetadata.sip"
#include "qgsprovidermetadata.h"
#line 18752 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "auto_generated/qgsmaplayer.sip"
#include "qgsmaplayer.h"
#line 18755 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 18758 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "auto_generated/qgsmaplayer.sip"
#include "qgsmaplayer.h"
#line 18761 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 146 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 18766 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qmetaobject.sip"
#include <qmetaobject.h>
#line 18769 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 18772 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 252 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 18775 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 240 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qcoreevent.sip"
#include <qcoreevent.h>
#line 18778 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
#include <qobject.h>
#line 18781 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 38 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 18784 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 30 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 18787 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 149 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 18790 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 18793 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qthread.sip"
#include <qthread.h>
#line 18796 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qnamespace.sip"
#include <qnamespace.h>
#line 18799 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qregexp.sip"
#include <qregexp.h>
#line 18802 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qregularexpression.sip"
#include <qregularexpression.h>
#line 18805 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobjectdefs.sip"
#include <qobjectdefs.h>
#line 18808 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


class sipQgsPointCloudLayer : public ::QgsPointCloudLayer
{
public:
    sipQgsPointCloudLayer(const ::QString&, const ::QString&, const ::QString&, const ::QgsPointCloudLayer::LayerOptions&);
    virtual ~sipQgsPointCloudLayer();

    int qt_metacall(QMetaObject::Call, int, void **) SIP_OVERRIDE;
    void *qt_metacast(const char *) SIP_OVERRIDE;
    const QMetaObject *metaObject() const SIP_OVERRIDE;

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    ::QObject* sipProtect_sender() const;
    int sipProtect_receivers(const char*) const;
    void sipProtectVirt_timerEvent(bool, ::QTimerEvent*);
    void sipProtectVirt_childEvent(bool, ::QChildEvent*);
    void sipProtectVirt_customEvent(bool, ::QEvent*);
    void sipProtectVirt_connectNotify(bool, const ::QMetaMethod&);
    void sipProtectVirt_disconnectNotify(bool, const ::QMetaMethod&);
    int sipProtect_senderSignalIndex() const;
    bool sipProtect_isSignalConnected(const ::QMetaMethod&) const;
    void sipProtectVirt_setExtent(bool, const ::QgsRectangle&);
    void sipProtectVirt_setExtent3D(bool, const ::QgsBox3D&);
    void sipProtect_setValid(bool);
    void sipProtect_readCustomProperties(const ::QDomNode&, const ::QString&);
    void sipProtect_writeCustomProperties(::QDomNode&, ::QDomDocument&) const;
    void sipProtect_readStyleManager(const ::QDomNode&);
    void sipProtect_writeStyleManager(::QDomNode&, ::QDomDocument&) const;
    void sipProtect_writeCommonStyle(::QDomElement&, ::QDomDocument&, const ::QgsReadWriteContext&, ::QgsMapLayer::StyleCategories) const;
    void sipProtect_readCommonStyle(const ::QDomElement&, const ::QgsReadWriteContext&, ::QgsMapLayer::StyleCategories);
    void sipProtect_setProviderType(const ::QString&);
    void sipProtect_appendError(const ::QgsErrorMessage&);
    void sipProtect_setError(const ::QgsError&);
    void sipProtect_invalidateWgs84Extent();
    bool sipProtect_hasDependencyCycle(const QSet< ::QgsMapLayerDependency>&) const;

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::QgsAbstractProfileGenerator* createProfileGenerator(const ::QgsProfileRequest&) SIP_OVERRIDE;
    void disconnectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void connectNotify(const ::QMetaMethod&) SIP_OVERRIDE;
    void customEvent(::QEvent*) SIP_OVERRIDE;
    void childEvent(::QChildEvent*) SIP_OVERRIDE;
    void timerEvent(::QTimerEvent*) SIP_OVERRIDE;
    bool eventFilter(::QObject*, ::QEvent*) SIP_OVERRIDE;
    bool event(::QEvent*) SIP_OVERRIDE;
    ::QgsPointCloudLayer* clone() const SIP_OVERRIDE;
    ::Qgis::MapLayerProperties properties() const SIP_OVERRIDE;
    ::QgsPointCloudDataProvider* dataProvider() SIP_OVERRIDE;
    void setOpacity(double) SIP_OVERRIDE;
    double opacity() const SIP_OVERRIDE;
    void reload() SIP_OVERRIDE;
    ::QgsMapLayerRenderer* createMapRenderer(::QgsRenderContext&) SIP_OVERRIDE;
    ::QgsRectangle extent() const SIP_OVERRIDE;
    ::QgsBox3D extent3D() const SIP_OVERRIDE;
    ::QStringList subLayers() const SIP_OVERRIDE;
    void setLayerOrder(const ::QStringList&) SIP_OVERRIDE;
    void setSubLayerVisibility(const ::QString&, bool) SIP_OVERRIDE;
    bool supportsEditing() const SIP_OVERRIDE;
    bool isEditable() const SIP_OVERRIDE;
    bool isModified() const SIP_OVERRIDE;
    bool isSpatial() const SIP_OVERRIDE;
    bool isTemporary() const SIP_OVERRIDE;
    void resolveReferences(::QgsProject*) SIP_OVERRIDE;
    int listStylesInDatabase(::QStringList&, ::QStringList&, ::QStringList&, ::QString&) SIP_OVERRIDE;
    ::QString getStyleFromDatabase(const ::QString&, ::QString&) SIP_OVERRIDE;
    bool deleteStyleFromDatabase(const ::QString&, ::QString&) SIP_OVERRIDE;
    void saveStyleToDatabase(const ::QString&, const ::QString&, bool, const ::QString&, ::QString&, ::QgsMapLayer::StyleCategories) SIP_OVERRIDE;
    ::QString loadNamedStyle(const ::QString&, bool&, bool, ::QgsMapLayer::StyleCategories, ::Qgis::LoadStyleFlags) SIP_OVERRIDE;
    ::QgsError error() const SIP_OVERRIDE;
    ::QString metadataUri() const SIP_OVERRIDE;
    ::QString saveDefaultMetadata(bool&) SIP_OVERRIDE;
    ::QString loadNamedMetadata(const ::QString&, bool&) SIP_OVERRIDE;
    ::QString loadDefaultMetadata(bool&) SIP_OVERRIDE;
    ::QString styleURI() const SIP_OVERRIDE;
    ::QString loadNamedStyle(const ::QString&, bool&, ::QgsMapLayer::StyleCategories, ::Qgis::LoadStyleFlags) SIP_OVERRIDE;
    bool loadNamedStyleFromDatabase(const ::QString&, const ::QString&, ::QString&) SIP_OVERRIDE;
    bool importNamedStyle(::QDomDocument&, ::QString&, ::QgsMapLayer::StyleCategories) SIP_OVERRIDE;
    void exportNamedStyle(::QDomDocument&, ::QString&, const ::QgsReadWriteContext&, ::QgsMapLayer::StyleCategories) const SIP_OVERRIDE;
    void exportSldStyle(::QDomDocument&, ::QString&) const SIP_OVERRIDE;
    void exportSldStyleV2(::QDomDocument&, ::QString&, ::QgsSldExportContext&) const SIP_OVERRIDE;
    ::QDomDocument exportSldStyleV3(::QgsSldExportContext&) const SIP_OVERRIDE;
    ::QString saveDefaultStyle(bool&, ::QgsMapLayer::StyleCategories) SIP_OVERRIDE;
    ::QString saveDefaultStyle(bool&) SIP_OVERRIDE;
    ::QString saveNamedStyle(const ::QString&, bool&, ::QgsMapLayer::StyleCategories) SIP_OVERRIDE;
    ::QString saveSldStyle(const ::QString&, bool&) const SIP_OVERRIDE;
    ::QString saveSldStyleV2(bool&, ::QgsSldExportContext&) const SIP_OVERRIDE;
    ::QString loadSldStyle(const ::QString&, bool&) SIP_OVERRIDE;
    bool readSld(const ::QDomNode&, ::QString&) SIP_OVERRIDE;
    bool readSymbology(const ::QDomNode&, ::QString&, ::QgsReadWriteContext&, ::QgsMapLayer::StyleCategories) SIP_OVERRIDE;
    bool writeSymbology(::QDomNode&, ::QDomDocument&, ::QString&, const ::QgsReadWriteContext&, ::QgsMapLayer::StyleCategories) const SIP_OVERRIDE;
    const ::QgsLayerMetadata& metadata() const SIP_OVERRIDE;
    void setMetadata(const ::QgsLayerMetadata&) SIP_OVERRIDE;
    ::QString htmlMetadata() const SIP_OVERRIDE;
    ::QDateTime timestamp() const SIP_OVERRIDE;
    QSet< ::QgsMapLayerDependency> dependencies() const SIP_OVERRIDE;
    bool accept(::QgsStyleEntityVisitorInterface*) const SIP_OVERRIDE;
    ::QgsMapLayerSelectionProperties* selectionProperties() SIP_OVERRIDE;
    ::QgsMapLayerTemporalProperties* temporalProperties() SIP_OVERRIDE;
    ::QgsMapLayerElevationProperties* elevationProperties() SIP_OVERRIDE;
    ::QgsAbstractProfileSource* profileSource() SIP_OVERRIDE;
    bool hasMapTips() const SIP_OVERRIDE;
    bool setDependencies(const QSet< ::QgsMapLayerDependency>&) SIP_OVERRIDE;
    void setTransformContext(const ::QgsCoordinateTransformContext&) SIP_OVERRIDE;
    void setExtent(const ::QgsRectangle&) SIP_OVERRIDE;
    void setExtent3D(const ::QgsBox3D&) SIP_OVERRIDE;
    bool readXml(const ::QDomNode&, ::QgsReadWriteContext&) SIP_OVERRIDE;
    bool writeXml(::QDomNode&, ::QDomDocument&, const ::QgsReadWriteContext&) const SIP_OVERRIDE;
    ::QString encodedSource(const ::QString&, const ::QgsReadWriteContext&) const SIP_OVERRIDE;
    ::QString decodedSource(const ::QString&, const ::QString&, const ::QgsReadWriteContext&) const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQgsPointCloudLayer(const sipQgsPointCloudLayer &);
    sipQgsPointCloudLayer &operator = (const sipQgsPointCloudLayer &);

    char sipPyMethods[72];
};

sipQgsPointCloudLayer::sipQgsPointCloudLayer(const ::QString& a0, const ::QString& a1, const ::QString& a2, const ::QgsPointCloudLayer::LayerOptions& a3): ::QgsPointCloudLayer(a0, a1, a2, a3), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsPointCloudLayer::~sipQgsPointCloudLayer()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

const QMetaObject *sipQgsPointCloudLayer::metaObject() const
{
    if (sipGetInterpreter())
        return QObject::d_ptr->metaObject ? QObject::d_ptr->dynamicMetaObject() : sip__core_qt_metaobject(sipPySelf, sipType_QgsPointCloudLayer);

    return ::QgsPointCloudLayer::metaObject();
}

int sipQgsPointCloudLayer::qt_metacall(QMetaObject::Call _c, int _id, void **_a)
{
    _id = ::QgsPointCloudLayer::qt_metacall(_c, _id, _a);

    if (_id >= 0)
    {
        SIP_BLOCK_THREADS
        _id = sip__core_qt_metacall(sipPySelf, sipType_QgsPointCloudLayer, _c, _id, _a);
        SIP_UNBLOCK_THREADS
    }

    return _id;
}

void *sipQgsPointCloudLayer::qt_metacast(const char *_clname)
{
    void *sipCpp;

    return (sip__core_qt_metacast(sipPySelf, sipType_QgsPointCloudLayer, _clname, &sipCpp) ? sipCpp : ::QgsPointCloudLayer::qt_metacast(_clname));
}

::QgsAbstractProfileGenerator* sipQgsPointCloudLayer::createProfileGenerator(const ::QgsProfileRequest& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_createProfileGenerator);

    if (!sipMeth)
        return ::QgsPointCloudLayer::createProfileGenerator(a0);

    extern ::QgsAbstractProfileGenerator* sipVH__core_78(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsProfileRequest&);

    return sipVH__core_78(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayer::disconnectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_disconnectNotify);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::disconnectNotify(a0);
        return;
    }

    extern void sipVH__core_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH__core_3(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayer::connectNotify(const ::QMetaMethod& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_connectNotify);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::connectNotify(a0);
        return;
    }

    extern void sipVH__core_3(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QMetaMethod&);

    sipVH__core_3(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayer::customEvent(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_customEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::customEvent(a0);
        return;
    }

    extern void sipVH__core_4(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    sipVH__core_4(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayer::childEvent(::QChildEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_childEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::childEvent(a0);
        return;
    }

    extern void sipVH__core_5(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QChildEvent*);

    sipVH__core_5(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayer::timerEvent(::QTimerEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, SIP_NULLPTR, sipName_timerEvent);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::timerEvent(a0);
        return;
    }

    extern void sipVH__core_6(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QTimerEvent*);

    sipVH__core_6(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQgsPointCloudLayer::eventFilter(::QObject*a0, ::QEvent*a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_eventFilter);

    if (!sipMeth)
        return ::QgsPointCloudLayer::eventFilter(a0, a1);

    extern bool sipVH__core_7(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QObject*, ::QEvent*);

    return sipVH__core_7(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudLayer::event(::QEvent*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_event);

    if (!sipMeth)
        return ::QgsPointCloudLayer::event(a0);

    extern bool sipVH__core_8(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QEvent*);

    return sipVH__core_8(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QgsPointCloudLayer* sipQgsPointCloudLayer::clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[8]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_clone);

    if (!sipMeth)
        return ::QgsPointCloudLayer::clone();

    extern ::QgsPointCloudLayer* sipVH__core_746(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_746(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::Qgis::MapLayerProperties sipQgsPointCloudLayer::properties() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[9]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_properties);

    if (!sipMeth)
        return ::QgsPointCloudLayer::properties();

    extern ::Qgis::MapLayerProperties sipVH__core_13(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_13(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsPointCloudDataProvider* sipQgsPointCloudLayer::dataProvider()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[10], &sipPySelf, SIP_NULLPTR, sipName_dataProvider);

    if (!sipMeth)
        return ::QgsPointCloudLayer::dataProvider();

    extern ::QgsPointCloudDataProvider* sipVH__core_745(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_745(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudLayer::setOpacity(double a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[11], &sipPySelf, SIP_NULLPTR, sipName_setOpacity);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::setOpacity(a0);
        return;
    }

    extern void sipVH__core_15(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, double);

    sipVH__core_15(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

double sipQgsPointCloudLayer::opacity() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[12]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_opacity);

    if (!sipMeth)
        return ::QgsPointCloudLayer::opacity();

    extern double sipVH__core_16(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_16(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudLayer::reload()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[13], &sipPySelf, SIP_NULLPTR, sipName_reload);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::reload();
        return;
    }

    extern void sipVH__core_426(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    sipVH__core_426(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsMapLayerRenderer* sipQgsPointCloudLayer::createMapRenderer(::QgsRenderContext& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[14], &sipPySelf, SIP_NULLPTR, sipName_createMapRenderer);

    if (!sipMeth)
        return ::QgsPointCloudLayer::createMapRenderer(a0);

    extern ::QgsMapLayerRenderer* sipVH__core_17(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsRenderContext&);

    return sipVH__core_17(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QgsRectangle sipQgsPointCloudLayer::extent() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[15]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_extent);

    if (!sipMeth)
        return ::QgsPointCloudLayer::extent();

    extern ::QgsRectangle sipVH__core_18(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_18(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsBox3D sipQgsPointCloudLayer::extent3D() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[16]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_extent3D);

    if (!sipMeth)
        return ::QgsPointCloudLayer::extent3D();

    extern ::QgsBox3D sipVH__core_19(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_19(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QStringList sipQgsPointCloudLayer::subLayers() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[17]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_subLayers);

    if (!sipMeth)
        return ::QgsPointCloudLayer::subLayers();

    extern ::QStringList sipVH__core_20(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_20(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudLayer::setLayerOrder(const ::QStringList& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[18], &sipPySelf, SIP_NULLPTR, sipName_setLayerOrder);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::setLayerOrder(a0);
        return;
    }

    extern void sipVH__core_21(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QStringList&);

    sipVH__core_21(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayer::setSubLayerVisibility(const ::QString& a0, bool a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[19], &sipPySelf, SIP_NULLPTR, sipName_setSubLayerVisibility);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::setSubLayerVisibility(a0, a1);
        return;
    }

    extern void sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool);

    sipVH__core_11(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudLayer::supportsEditing() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[20]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_supportsEditing);

    if (!sipMeth)
        return ::QgsPointCloudLayer::supportsEditing();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudLayer::isEditable() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[21]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_isEditable);

    if (!sipMeth)
        return ::QgsPointCloudLayer::isEditable();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudLayer::isModified() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[22]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_isModified);

    if (!sipMeth)
        return ::QgsPointCloudLayer::isModified();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudLayer::isSpatial() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[23]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_isSpatial);

    if (!sipMeth)
        return ::QgsPointCloudLayer::isSpatial();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudLayer::isTemporary() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[24]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_isTemporary);

    if (!sipMeth)
        return ::QgsPointCloudLayer::isTemporary();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudLayer::resolveReferences(::QgsProject*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[25], &sipPySelf, SIP_NULLPTR, sipName_resolveReferences);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::resolveReferences(a0);
        return;
    }

    extern void sipVH__core_23(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsProject*);

    sipVH__core_23(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

int sipQgsPointCloudLayer::listStylesInDatabase(::QStringList& a0, ::QStringList& a1, ::QStringList& a2, ::QString& a3)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[26], &sipPySelf, SIP_NULLPTR, sipName_listStylesInDatabase);

    if (!sipMeth)
        return ::QgsPointCloudLayer::listStylesInDatabase(a0, a1, a2, a3);

    extern int sipVH__core_24(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QStringList&, ::QStringList&, ::QStringList&, ::QString&);

    return sipVH__core_24(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2, a3);
}

::QString sipQgsPointCloudLayer::getStyleFromDatabase(const ::QString& a0, ::QString& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[27], &sipPySelf, SIP_NULLPTR, sipName_getStyleFromDatabase);

    if (!sipMeth)
        return ::QgsPointCloudLayer::getStyleFromDatabase(a0, a1);

    extern ::QString sipVH__core_25(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, ::QString&);

    return sipVH__core_25(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudLayer::deleteStyleFromDatabase(const ::QString& a0, ::QString& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[28], &sipPySelf, SIP_NULLPTR, sipName_deleteStyleFromDatabase);

    if (!sipMeth)
        return ::QgsPointCloudLayer::deleteStyleFromDatabase(a0, a1);

    extern bool sipVH__core_26(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, ::QString&);

    return sipVH__core_26(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

void sipQgsPointCloudLayer::saveStyleToDatabase(const ::QString& a0, const ::QString& a1, bool a2, const ::QString& a3, ::QString& a4, ::QgsMapLayer::StyleCategories a5)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[29], &sipPySelf, SIP_NULLPTR, sipName_saveStyleToDatabase);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::saveStyleToDatabase(a0, a1, a2, a3, a4, a5);
        return;
    }

    extern void sipVH__core_27(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, const ::QString&, bool, const ::QString&, ::QString&, ::QgsMapLayer::StyleCategories);

    sipVH__core_27(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2, a3, a4, a5);
}

::QString sipQgsPointCloudLayer::loadNamedStyle(const ::QString& a0, bool& a1, bool a2, ::QgsMapLayer::StyleCategories a3, ::Qgis::LoadStyleFlags a4)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[30], &sipPySelf, SIP_NULLPTR, sipName_loadNamedStyle);

    if (!sipMeth)
        return ::QgsPointCloudLayer::loadNamedStyle(a0, a1, a2, a3, a4);

    extern ::QString sipVH__core_28(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool&, bool, ::QgsMapLayer::StyleCategories, ::Qgis::LoadStyleFlags);

    return sipVH__core_28(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2, a3, a4);
}

::QgsError sipQgsPointCloudLayer::error() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[31]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_error);

    if (!sipMeth)
        return ::QgsPointCloudLayer::error();

    extern ::QgsError sipVH__core_29(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_29(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QString sipQgsPointCloudLayer::metadataUri() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[32]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_metadataUri);

    if (!sipMeth)
        return ::QgsPointCloudLayer::metadataUri();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QString sipQgsPointCloudLayer::saveDefaultMetadata(bool& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[33], &sipPySelf, SIP_NULLPTR, sipName_saveDefaultMetadata);

    if (!sipMeth)
        return ::QgsPointCloudLayer::saveDefaultMetadata(a0);

    extern ::QString sipVH__core_31(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool&);

    return sipVH__core_31(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QString sipQgsPointCloudLayer::loadNamedMetadata(const ::QString& a0, bool& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[34], &sipPySelf, SIP_NULLPTR, sipName_loadNamedMetadata);

    if (!sipMeth)
        return ::QgsPointCloudLayer::loadNamedMetadata(a0, a1);

    extern ::QString sipVH__core_32(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool&);

    return sipVH__core_32(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

::QString sipQgsPointCloudLayer::loadDefaultMetadata(bool& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[35], &sipPySelf, SIP_NULLPTR, sipName_loadDefaultMetadata);

    if (!sipMeth)
        return ::QgsPointCloudLayer::loadDefaultMetadata(a0);

    extern ::QString sipVH__core_31(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool&);

    return sipVH__core_31(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QString sipQgsPointCloudLayer::styleURI() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[36]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_styleURI);

    if (!sipMeth)
        return ::QgsPointCloudLayer::styleURI();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QString sipQgsPointCloudLayer::loadNamedStyle(const ::QString& a0, bool& a1, ::QgsMapLayer::StyleCategories a2, ::Qgis::LoadStyleFlags a3)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[37], &sipPySelf, SIP_NULLPTR, sipName_loadNamedStyle);

    if (!sipMeth)
        return ::QgsPointCloudLayer::loadNamedStyle(a0, a1, a2, a3);

    extern ::QString sipVH__core_33(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool&, ::QgsMapLayer::StyleCategories, ::Qgis::LoadStyleFlags);

    return sipVH__core_33(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2, a3);
}

bool sipQgsPointCloudLayer::loadNamedStyleFromDatabase(const ::QString& a0, const ::QString& a1, ::QString& a2)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[38], &sipPySelf, SIP_NULLPTR, sipName_loadNamedStyleFromDatabase);

    if (!sipMeth)
        return ::QgsPointCloudLayer::loadNamedStyleFromDatabase(a0, a1, a2);

    extern bool sipVH__core_34(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, const ::QString&, ::QString&);

    return sipVH__core_34(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2);
}

bool sipQgsPointCloudLayer::importNamedStyle(::QDomDocument& a0, ::QString& a1, ::QgsMapLayer::StyleCategories a2)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[39], &sipPySelf, SIP_NULLPTR, sipName_importNamedStyle);

    if (!sipMeth)
        return ::QgsPointCloudLayer::importNamedStyle(a0, a1, a2);

    extern bool sipVH__core_35(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomDocument&, ::QString&, ::QgsMapLayer::StyleCategories);

    return sipVH__core_35(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2);
}

void sipQgsPointCloudLayer::exportNamedStyle(::QDomDocument& a0, ::QString& a1, const ::QgsReadWriteContext& a2, ::QgsMapLayer::StyleCategories a3) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[40]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_exportNamedStyle);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::exportNamedStyle(a0, a1, a2, a3);
        return;
    }

    extern void sipVH__core_36(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomDocument&, ::QString&, const ::QgsReadWriteContext&, ::QgsMapLayer::StyleCategories);

    sipVH__core_36(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2, a3);
}

void sipQgsPointCloudLayer::exportSldStyle(::QDomDocument& a0, ::QString& a1) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[41]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_exportSldStyle);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::exportSldStyle(a0, a1);
        return;
    }

    extern void sipVH__core_37(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomDocument&, ::QString&);

    sipVH__core_37(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

void sipQgsPointCloudLayer::exportSldStyleV2(::QDomDocument& a0, ::QString& a1, ::QgsSldExportContext& a2) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[42]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_exportSldStyleV2);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::exportSldStyleV2(a0, a1, a2);
        return;
    }

    extern void sipVH__core_38(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomDocument&, ::QString&, ::QgsSldExportContext&);

    sipVH__core_38(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2);
}

::QDomDocument sipQgsPointCloudLayer::exportSldStyleV3(::QgsSldExportContext& a0) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[43]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_exportSldStyleV3);

    if (!sipMeth)
        return ::QgsPointCloudLayer::exportSldStyleV3(a0);

    extern ::QDomDocument sipVH__core_39(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsSldExportContext&);

    return sipVH__core_39(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QString sipQgsPointCloudLayer::saveDefaultStyle(bool& a0, ::QgsMapLayer::StyleCategories a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[44], &sipPySelf, SIP_NULLPTR, sipName_saveDefaultStyle);

    if (!sipMeth)
        return ::QgsPointCloudLayer::saveDefaultStyle(a0, a1);

    extern ::QString sipVH__core_40(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool&, ::QgsMapLayer::StyleCategories);

    return sipVH__core_40(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

::QString sipQgsPointCloudLayer::saveDefaultStyle(bool& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[45], &sipPySelf, SIP_NULLPTR, sipName_saveDefaultStyle);

    if (!sipMeth)
        return ::QgsPointCloudLayer::saveDefaultStyle(a0);

    extern ::QString sipVH__core_31(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool&);

    return sipVH__core_31(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QString sipQgsPointCloudLayer::saveNamedStyle(const ::QString& a0, bool& a1, ::QgsMapLayer::StyleCategories a2)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[46], &sipPySelf, SIP_NULLPTR, sipName_saveNamedStyle);

    if (!sipMeth)
        return ::QgsPointCloudLayer::saveNamedStyle(a0, a1, a2);

    extern ::QString sipVH__core_41(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool&, ::QgsMapLayer::StyleCategories);

    return sipVH__core_41(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2);
}

::QString sipQgsPointCloudLayer::saveSldStyle(const ::QString& a0, bool& a1) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[47]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_saveSldStyle);

    if (!sipMeth)
        return ::QgsPointCloudLayer::saveSldStyle(a0, a1);

    extern ::QString sipVH__core_32(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool&);

    return sipVH__core_32(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

::QString sipQgsPointCloudLayer::saveSldStyleV2(bool& a0, ::QgsSldExportContext& a1) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[48]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_saveSldStyleV2);

    if (!sipMeth)
        return ::QgsPointCloudLayer::saveSldStyleV2(a0, a1);

    extern ::QString sipVH__core_42(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool&, ::QgsSldExportContext&);

    return sipVH__core_42(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

::QString sipQgsPointCloudLayer::loadSldStyle(const ::QString& a0, bool& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[49], &sipPySelf, SIP_NULLPTR, sipName_loadSldStyle);

    if (!sipMeth)
        return ::QgsPointCloudLayer::loadSldStyle(a0, a1);

    extern ::QString sipVH__core_32(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool&);

    return sipVH__core_32(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudLayer::readSld(const ::QDomNode& a0, ::QString& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[50], &sipPySelf, SIP_NULLPTR, sipName_readSld);

    if (!sipMeth)
        return ::QgsPointCloudLayer::readSld(a0, a1);

    extern bool sipVH__core_43(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QDomNode&, ::QString&);

    return sipVH__core_43(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudLayer::readSymbology(const ::QDomNode& a0, ::QString& a1, ::QgsReadWriteContext& a2, ::QgsMapLayer::StyleCategories a3)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[51], &sipPySelf, SIP_NULLPTR, sipName_readSymbology);

    if (!sipMeth)
        return ::QgsPointCloudLayer::readSymbology(a0, a1, a2, a3);

    extern bool sipVH__core_44(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QDomNode&, ::QString&, ::QgsReadWriteContext&, ::QgsMapLayer::StyleCategories);

    return sipVH__core_44(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2, a3);
}

bool sipQgsPointCloudLayer::writeSymbology(::QDomNode& a0, ::QDomDocument& a1, ::QString& a2, const ::QgsReadWriteContext& a3, ::QgsMapLayer::StyleCategories a4) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[52]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_writeSymbology);

    if (!sipMeth)
        return ::QgsPointCloudLayer::writeSymbology(a0, a1, a2, a3, a4);

    extern bool sipVH__core_45(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomNode&, ::QDomDocument&, ::QString&, const ::QgsReadWriteContext&, ::QgsMapLayer::StyleCategories);

    return sipVH__core_45(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2, a3, a4);
}

const ::QgsLayerMetadata& sipQgsPointCloudLayer::metadata() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[53]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_metadata);

    if (!sipMeth)
        return ::QgsPointCloudLayer::metadata();

    extern const ::QgsLayerMetadata& sipVH__core_46(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_46(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudLayer::setMetadata(const ::QgsLayerMetadata& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[54], &sipPySelf, SIP_NULLPTR, sipName_setMetadata);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::setMetadata(a0);
        return;
    }

    extern void sipVH__core_47(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsLayerMetadata&);

    sipVH__core_47(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QString sipQgsPointCloudLayer::htmlMetadata() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[55]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_htmlMetadata);

    if (!sipMeth)
        return ::QgsPointCloudLayer::htmlMetadata();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QDateTime sipQgsPointCloudLayer::timestamp() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[56]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_timestamp);

    if (!sipMeth)
        return ::QgsPointCloudLayer::timestamp();

    extern ::QDateTime sipVH__core_48(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_48(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

QSet< ::QgsMapLayerDependency> sipQgsPointCloudLayer::dependencies() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[57]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_dependencies);

    if (!sipMeth)
        return ::QgsPointCloudLayer::dependencies();

    extern QSet< ::QgsMapLayerDependency> sipVH__core_49(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_49(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudLayer::accept(::QgsStyleEntityVisitorInterface*a0) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[58]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_accept);

    if (!sipMeth)
        return ::QgsPointCloudLayer::accept(a0);

    extern bool sipVH__core_50(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsStyleEntityVisitorInterface*);

    return sipVH__core_50(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QgsMapLayerSelectionProperties* sipQgsPointCloudLayer::selectionProperties()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[59], &sipPySelf, SIP_NULLPTR, sipName_selectionProperties);

    if (!sipMeth)
        return ::QgsPointCloudLayer::selectionProperties();

    extern ::QgsMapLayerSelectionProperties* sipVH__core_178(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_178(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsMapLayerTemporalProperties* sipQgsPointCloudLayer::temporalProperties()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[60], &sipPySelf, SIP_NULLPTR, sipName_temporalProperties);

    if (!sipMeth)
        return ::QgsPointCloudLayer::temporalProperties();

    extern ::QgsMapLayerTemporalProperties* sipVH__core_52(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_52(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsMapLayerElevationProperties* sipQgsPointCloudLayer::elevationProperties()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[61], &sipPySelf, SIP_NULLPTR, sipName_elevationProperties);

    if (!sipMeth)
        return ::QgsPointCloudLayer::elevationProperties();

    extern ::QgsMapLayerElevationProperties* sipVH__core_173(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_173(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsAbstractProfileSource* sipQgsPointCloudLayer::profileSource()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[62], &sipPySelf, SIP_NULLPTR, sipName_profileSource);

    if (!sipMeth)
        return ::QgsPointCloudLayer::profileSource();

    extern ::QgsAbstractProfileSource* sipVH__core_54(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_54(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudLayer::hasMapTips() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[63]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_hasMapTips);

    if (!sipMeth)
        return ::QgsPointCloudLayer::hasMapTips();

    extern bool sipVH__core_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_22(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

bool sipQgsPointCloudLayer::setDependencies(const QSet< ::QgsMapLayerDependency>& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[64], &sipPySelf, SIP_NULLPTR, sipName_setDependencies);

    if (!sipMeth)
        return ::QgsPointCloudLayer::setDependencies(a0);

    extern bool sipVH__core_55(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const QSet< ::QgsMapLayerDependency>&);

    return sipVH__core_55(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayer::setTransformContext(const ::QgsCoordinateTransformContext& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[65], &sipPySelf, SIP_NULLPTR, sipName_setTransformContext);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::setTransformContext(a0);
        return;
    }

    extern void sipVH__core_56(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsCoordinateTransformContext&);

    sipVH__core_56(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayer::setExtent(const ::QgsRectangle& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[66], &sipPySelf, SIP_NULLPTR, sipName_setExtent);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::setExtent(a0);
        return;
    }

    extern void sipVH__core_57(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsRectangle&);

    sipVH__core_57(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudLayer::setExtent3D(const ::QgsBox3D& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[67], &sipPySelf, SIP_NULLPTR, sipName_setExtent3D);

    if (!sipMeth)
    {
        ::QgsPointCloudLayer::setExtent3D(a0);
        return;
    }

    extern void sipVH__core_58(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsBox3D&);

    sipVH__core_58(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQgsPointCloudLayer::readXml(const ::QDomNode& a0, ::QgsReadWriteContext& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[68], &sipPySelf, SIP_NULLPTR, sipName_readXml);

    if (!sipMeth)
        return ::QgsPointCloudLayer::readXml(a0, a1);

    extern bool sipVH__core_59(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QDomNode&, ::QgsReadWriteContext&);

    return sipVH__core_59(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudLayer::writeXml(::QDomNode& a0, ::QDomDocument& a1, const ::QgsReadWriteContext& a2) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[69]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_writeXml);

    if (!sipMeth)
        return ::QgsPointCloudLayer::writeXml(a0, a1, a2);

    extern bool sipVH__core_60(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomNode&, ::QDomDocument&, const ::QgsReadWriteContext&);

    return sipVH__core_60(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2);
}

::QString sipQgsPointCloudLayer::encodedSource(const ::QString& a0, const ::QgsReadWriteContext& a1) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[70]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_encodedSource);

    if (!sipMeth)
        return ::QgsPointCloudLayer::encodedSource(a0, a1);

    extern ::QString sipVH__core_61(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, const ::QgsReadWriteContext&);

    return sipVH__core_61(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

::QString sipQgsPointCloudLayer::decodedSource(const ::QString& a0, const ::QString& a1, const ::QgsReadWriteContext& a2) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[71]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_decodedSource);

    if (!sipMeth)
        return ::QgsPointCloudLayer::decodedSource(a0, a1, a2);

    extern ::QString sipVH__core_62(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, const ::QString&, const ::QgsReadWriteContext&);

    return sipVH__core_62(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1, a2);
}

::QObject* sipQgsPointCloudLayer::sipProtect_sender() const
{
    return ::QObject::sender();
}

int sipQgsPointCloudLayer::sipProtect_receivers(const char*a0) const
{
    return ::QObject::receivers(a0);
}

void sipQgsPointCloudLayer::sipProtectVirt_timerEvent(bool sipSelfWasArg, ::QTimerEvent*a0)
{
    (sipSelfWasArg ? ::QObject::timerEvent(a0) : timerEvent(a0));
}

void sipQgsPointCloudLayer::sipProtectVirt_childEvent(bool sipSelfWasArg, ::QChildEvent*a0)
{
    (sipSelfWasArg ? ::QObject::childEvent(a0) : childEvent(a0));
}

void sipQgsPointCloudLayer::sipProtectVirt_customEvent(bool sipSelfWasArg, ::QEvent*a0)
{
    (sipSelfWasArg ? ::QObject::customEvent(a0) : customEvent(a0));
}

void sipQgsPointCloudLayer::sipProtectVirt_connectNotify(bool sipSelfWasArg, const ::QMetaMethod& a0)
{
    (sipSelfWasArg ? ::QObject::connectNotify(a0) : connectNotify(a0));
}

void sipQgsPointCloudLayer::sipProtectVirt_disconnectNotify(bool sipSelfWasArg, const ::QMetaMethod& a0)
{
    (sipSelfWasArg ? ::QObject::disconnectNotify(a0) : disconnectNotify(a0));
}

int sipQgsPointCloudLayer::sipProtect_senderSignalIndex() const
{
    return ::QObject::senderSignalIndex();
}

bool sipQgsPointCloudLayer::sipProtect_isSignalConnected(const ::QMetaMethod& a0) const
{
    return ::QObject::isSignalConnected(a0);
}

void sipQgsPointCloudLayer::sipProtectVirt_setExtent(bool sipSelfWasArg, const ::QgsRectangle& a0)
{
    (sipSelfWasArg ? ::QgsMapLayer::setExtent(a0) : setExtent(a0));
}

void sipQgsPointCloudLayer::sipProtectVirt_setExtent3D(bool sipSelfWasArg, const ::QgsBox3D& a0)
{
    (sipSelfWasArg ? ::QgsMapLayer::setExtent3D(a0) : setExtent3D(a0));
}

void sipQgsPointCloudLayer::sipProtect_setValid(bool a0)
{
    ::QgsMapLayer::setValid(a0);
}

void sipQgsPointCloudLayer::sipProtect_readCustomProperties(const ::QDomNode& a0, const ::QString& a1)
{
    ::QgsMapLayer::readCustomProperties(a0, a1);
}

void sipQgsPointCloudLayer::sipProtect_writeCustomProperties(::QDomNode& a0, ::QDomDocument& a1) const
{
    ::QgsMapLayer::writeCustomProperties(a0, a1);
}

void sipQgsPointCloudLayer::sipProtect_readStyleManager(const ::QDomNode& a0)
{
    ::QgsMapLayer::readStyleManager(a0);
}

void sipQgsPointCloudLayer::sipProtect_writeStyleManager(::QDomNode& a0, ::QDomDocument& a1) const
{
    ::QgsMapLayer::writeStyleManager(a0, a1);
}

void sipQgsPointCloudLayer::sipProtect_writeCommonStyle(::QDomElement& a0, ::QDomDocument& a1, const ::QgsReadWriteContext& a2, ::QgsMapLayer::StyleCategories a3) const
{
    ::QgsMapLayer::writeCommonStyle(a0, a1, a2, a3);
}

void sipQgsPointCloudLayer::sipProtect_readCommonStyle(const ::QDomElement& a0, const ::QgsReadWriteContext& a1, ::QgsMapLayer::StyleCategories a2)
{
    ::QgsMapLayer::readCommonStyle(a0, a1, a2);
}

void sipQgsPointCloudLayer::sipProtect_setProviderType(const ::QString& a0)
{
    ::QgsMapLayer::setProviderType(a0);
}

void sipQgsPointCloudLayer::sipProtect_appendError(const ::QgsErrorMessage& a0)
{
    ::QgsMapLayer::appendError(a0);
}

void sipQgsPointCloudLayer::sipProtect_setError(const ::QgsError& a0)
{
    ::QgsMapLayer::setError(a0);
}

void sipQgsPointCloudLayer::sipProtect_invalidateWgs84Extent()
{
    ::QgsMapLayer::invalidateWgs84Extent();
}

bool sipQgsPointCloudLayer::sipProtect_hasDependencyCycle(const QSet< ::QgsMapLayerDependency>& a0) const
{
    return ::QgsMapLayer::hasDependencyCycle(a0);
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_sender, "sender(self) -> Optional[QObject]");

extern "C" {static PyObject *meth_QgsPointCloudLayer_sender(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_sender(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const sipQgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QObject*sipRes = 0;

#line 570 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
        // sender() must be called without the GIL to avoid possible deadlocks between
        // the GIL and Qt's internal thread data mutex.
        
        Py_BEGIN_ALLOW_THREADS
        
        #if defined(SIP_PROTECTED_IS_PUBLIC)
        sipRes = sipCpp->sender();
        #else
        sipRes = sipCpp->sipProtect_sender();
        #endif
        
        Py_END_ALLOW_THREADS
        
        if (!sipRes)
        {
            typedef QObject *(*qtcore_qobject_sender_t)();
        
            static qtcore_qobject_sender_t qtcore_qobject_sender = 0;
        
            if (!qtcore_qobject_sender)
            {
                qtcore_qobject_sender = (qtcore_qobject_sender_t)sipImportSymbol("qtcore_qobject_sender");
                Q_ASSERT(qtcore_qobject_sender);
            }
        
            sipRes = qtcore_qobject_sender();
        }
#line 20268 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            return sipConvertFromType(sipRes, sipType_QObject, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_sender, doc_QgsPointCloudLayer_sender);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_receivers, "receivers(self, signal: PYQT_SIGNAL) -> int");

extern "C" {static PyObject *meth_QgsPointCloudLayer_receivers(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_receivers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * a0;
        const sipQgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BP0", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, &a0))
        {
            int sipRes = 0;
            sipErrorState sipError = sipErrorNone;

#line 601 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qobject.sip"
        // We need to handle the signal object.  Import the helper if it hasn't already
        // been done.
        typedef sipErrorState (*pyqt5_get_signal_signature_t)(PyObject *, const QObject *, const QByteArray &);
        
        static pyqt5_get_signal_signature_t pyqt5_get_signal_signature = 0;
        
        if (!pyqt5_get_signal_signature)
        {
            pyqt5_get_signal_signature = (pyqt5_get_signal_signature_t)sipImportSymbol("pyqt5_get_signal_signature");
            Q_ASSERT(pyqt5_get_signal_signature);
        }
        
        QByteArray signal_signature;
            
        #if defined(SIP_PROTECTED_IS_PUBLIC)
        if ((sipError = pyqt5_get_signal_signature(a0, sipCpp, signal_signature)) == sipErrorNone)
        {
            sipRes = sipCpp->receivers(signal_signature.constData());
        }
        #else
        if ((sipError = pyqt5_get_signal_signature(a0, static_cast<const QObject *>(sipCpp), signal_signature)) == sipErrorNone)
        {
            sipRes = sipCpp->sipProtect_receivers(signal_signature.constData());
        }
        #endif
        else if (sipError == sipErrorContinue)
        {
            sipError = sipBadCallableArg(0, a0);
        }
#line 20326 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            if (sipError == sipErrorFail)
                return 0;

            if (sipError == sipErrorNone)
            {
            return PyLong_FromLong(sipRes);
            }

            sipAddException(sipError, &sipParseErr);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_receivers, doc_QgsPointCloudLayer_receivers);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_timerEvent, "timerEvent(self, a0: Optional[QTimerEvent])");

extern "C" {static PyObject *meth_QgsPointCloudLayer_timerEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_timerEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QTimerEvent* a0;
        sipQgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QTimerEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_timerEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_timerEvent, doc_QgsPointCloudLayer_timerEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_childEvent, "childEvent(self, a0: Optional[QChildEvent])");

extern "C" {static PyObject *meth_QgsPointCloudLayer_childEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_childEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QChildEvent* a0;
        sipQgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QChildEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_childEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_childEvent, doc_QgsPointCloudLayer_childEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_customEvent, "customEvent(self, a0: Optional[QEvent])");

extern "C" {static PyObject *meth_QgsPointCloudLayer_customEvent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_customEvent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QEvent* a0;
        sipQgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_customEvent(sipSelfWasArg, a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_customEvent, doc_QgsPointCloudLayer_customEvent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_connectNotify, "connectNotify(self, signal: QMetaMethod)");

extern "C" {static PyObject *meth_QgsPointCloudLayer_connectNotify(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_connectNotify(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QMetaMethod* a0;
        sipQgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QMetaMethod, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_connectNotify(sipSelfWasArg, *a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_connectNotify, doc_QgsPointCloudLayer_connectNotify);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_disconnectNotify, "disconnectNotify(self, signal: QMetaMethod)");

extern "C" {static PyObject *meth_QgsPointCloudLayer_disconnectNotify(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_disconnectNotify(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QMetaMethod* a0;
        sipQgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QMetaMethod, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_disconnectNotify(sipSelfWasArg, *a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_disconnectNotify, doc_QgsPointCloudLayer_disconnectNotify);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_senderSignalIndex, "senderSignalIndex(self) -> int");

extern "C" {static PyObject *meth_QgsPointCloudLayer_senderSignalIndex(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_senderSignalIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const sipQgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sipProtect_senderSignalIndex();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_senderSignalIndex, doc_QgsPointCloudLayer_senderSignalIndex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_isSignalConnected, "isSignalConnected(self, signal: QMetaMethod) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayer_isSignalConnected(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_isSignalConnected(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QMetaMethod* a0;
        const sipQgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QMetaMethod, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sipProtect_isSignalConnected(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_isSignalConnected, doc_QgsPointCloudLayer_isSignalConnected);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_setExtent, "setExtent(self, rect: QgsRectangle)\n"
"Sets the extent");

extern "C" {static PyObject *meth_QgsPointCloudLayer_setExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_setExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsRectangle* a0;
        sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QgsRectangle, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_setExtent(sipSelfWasArg, *a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_setExtent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_setExtent3D, "setExtent3D(self, box: QgsBox3D)\n"
"Sets the extent\n"
"\n"
".. versionadded:: 3.36");

extern "C" {static PyObject *meth_QgsPointCloudLayer_setExtent3D(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_setExtent3D(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsBox3D* a0;
        sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_box,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QgsBox3D, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtectVirt_setExtent3D(sipSelfWasArg, *a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_setExtent3D, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_setValid, "setValid(self, valid: bool)\n"
"Sets whether layer is valid or not");

extern "C" {static PyObject *meth_QgsPointCloudLayer_setValid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_setValid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_valid,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_setValid(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_setValid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_readCustomProperties, "readCustomProperties(self, layerNode: QDomNode, keyStartsWith: Optional[str] = '')\n"
"Read custom properties from project file.\n"
"\n"
":param layerNode: note to read from\n"
":param keyStartsWith: reads only properties starting with the specified\n"
"                      string (or all if the string is empty)");

extern "C" {static PyObject *meth_QgsPointCloudLayer_readCustomProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_readCustomProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDomNode* a0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;
        sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layerNode,
            sipName_keyStartsWith,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9|J1", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomNode, &a0, sipType_QString, &a1, &a1State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_readCustomProperties(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_readCustomProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_writeCustomProperties, "writeCustomProperties(self, layerNode: QDomNode, doc: QDomDocument)\n"
"Write custom properties to project file.");

extern "C" {static PyObject *meth_QgsPointCloudLayer_writeCustomProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_writeCustomProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDomNode* a0;
        ::QDomDocument* a1;
        const sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layerNode,
            sipName_doc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomNode, &a0, sipType_QDomDocument, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_writeCustomProperties(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_writeCustomProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_readStyleManager, "readStyleManager(self, layerNode: QDomNode)\n"
"Read style manager's configuration (if any). To be called by subclasses.");

extern "C" {static PyObject *meth_QgsPointCloudLayer_readStyleManager(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_readStyleManager(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDomNode* a0;
        sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layerNode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomNode, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_readStyleManager(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_readStyleManager, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_writeStyleManager, "writeStyleManager(self, layerNode: QDomNode, doc: QDomDocument)\n"
"Write style manager's configuration (if exists). To be called by\n"
"subclasses.");

extern "C" {static PyObject *meth_QgsPointCloudLayer_writeStyleManager(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_writeStyleManager(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDomNode* a0;
        ::QDomDocument* a1;
        const sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layerNode,
            sipName_doc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomNode, &a0, sipType_QDomDocument, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_writeStyleManager(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_writeStyleManager, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_writeCommonStyle, "writeCommonStyle(self, layerElement: QDomElement, document: QDomDocument, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = QgsMapLayer.AllStyleCategories)\n"
"Write style data common to all layer types");

extern "C" {static PyObject *meth_QgsPointCloudLayer_writeCommonStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_writeCommonStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDomElement* a0;
        ::QDomDocument* a1;
        const ::QgsReadWriteContext* a2;
        ::QgsMapLayer::StyleCategories a3def = ::QgsMapLayer::AllStyleCategories;
        ::QgsMapLayer::StyleCategories* a3 = &a3def;
        int a3State = 0;
        const sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layerElement,
            sipName_document,
            sipName_context,
            sipName_categories,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9J9|J1", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomElement, &a0, sipType_QDomDocument, &a1, sipType_QgsReadWriteContext, &a2, sipType_QgsMapLayer_StyleCategories, &a3, &a3State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_writeCommonStyle(*a0, *a1, *a2, *a3);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(a3, sipType_QgsMapLayer_StyleCategories, a3State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(a3, sipType_QgsMapLayer_StyleCategories, a3State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_writeCommonStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_readCommonStyle, "readCommonStyle(self, layerElement: QDomElement, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = QgsMapLayer.AllStyleCategories)\n"
"Read style data common to all layer types");

extern "C" {static PyObject *meth_QgsPointCloudLayer_readCommonStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_readCommonStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;
        ::QgsMapLayer::StyleCategories a2def = ::QgsMapLayer::AllStyleCategories;
        ::QgsMapLayer::StyleCategories* a2 = &a2def;
        int a2State = 0;
        sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layerElement,
            sipName_context,
            sipName_categories,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9|J1", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1, sipType_QgsMapLayer_StyleCategories, &a2, &a2State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_readCommonStyle(*a0, *a1, *a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(a2, sipType_QgsMapLayer_StyleCategories, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(a2, sipType_QgsMapLayer_StyleCategories, a2State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_readCommonStyle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_setProviderType, "setProviderType(self, providerType: Optional[str])\n"
"Sets the ``providerType`` (provider key)");

extern "C" {static PyObject *meth_QgsPointCloudLayer_setProviderType(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_setProviderType(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_providerType,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QString, &a0, &a0State))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_setProviderType(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_setProviderType, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_appendError, "appendError(self, error: QgsErrorMessage)\n"
"Add error message");

extern "C" {static PyObject *meth_QgsPointCloudLayer_appendError(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_appendError(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsErrorMessage* a0;
        sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_error,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QgsErrorMessage, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_appendError(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_appendError, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_setError, "setError(self, error: QgsError)\n"
"Sets error message");

extern "C" {static PyObject *meth_QgsPointCloudLayer_setError(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_setError(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsError* a0;
        sipQgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_error,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QgsError, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_setError(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_setError, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_invalidateWgs84Extent, "invalidateWgs84Extent(self)\n"
"Invalidates the WGS84 extent. If FlagTrustLayerMetadata is enabled, the\n"
"extent is not invalidated because we want to trust metadata whatever\n"
"happens.\n"
"\n"
".. versionadded:: 3.20");

extern "C" {static PyObject *meth_QgsPointCloudLayer_invalidateWgs84Extent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_invalidateWgs84Extent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        sipQgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_invalidateWgs84Extent();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_invalidateWgs84Extent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_hasDependencyCycle, "hasDependencyCycle(self, a0: Iterable[QgsMapLayerDependency]) -> bool\n"
"Checks whether a new set of dependencies will introduce a cycle this\n"
"method is now deprecated and always return ``False``, because circular\n"
"dependencies are now correctly managed.\n"
"\n"
".. deprecated:: 3.10");

extern "C" {static PyObject *meth_QgsPointCloudLayer_hasDependencyCycle(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_hasDependencyCycle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const QSet< ::QgsMapLayerDependency>* a0;
        int a0State = 0;
        const sipQgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QSet_0100QgsMapLayerDependency, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sipProtect_hasDependencyCycle(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast<QSet< ::QgsMapLayerDependency> *>(a0), sipType_QSet_0100QgsMapLayerDependency, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<QSet< ::QgsMapLayerDependency> *>(a0), sipType_QSet_0100QgsMapLayerDependency, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_hasDependencyCycle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_clone, "clone(self) -> Optional[QgsPointCloudLayer]");

extern "C" {static PyObject *meth_QgsPointCloudLayer_clone(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QgsPointCloudLayer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::clone() : sipCpp->clone());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudLayer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_clone, doc_QgsPointCloudLayer_clone);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_extent, "extent(self) -> QgsRectangle");

extern "C" {static PyObject *meth_QgsPointCloudLayer_extent(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_extent(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QgsRectangle*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsRectangle((sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::extent() : sipCpp->extent()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsRectangle, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_extent, doc_QgsPointCloudLayer_extent);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_createMapRenderer, "createMapRenderer(self, rendererContext: QgsRenderContext) -> Optional[QgsMapLayerRenderer]");

extern "C" {static PyObject *meth_QgsPointCloudLayer_createMapRenderer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_createMapRenderer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QgsRenderContext* a0;
        ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rendererContext,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QgsRenderContext, &a0))
        {
            ::QgsMapLayerRenderer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::createMapRenderer(*a0) : sipCpp->createMapRenderer(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsMapLayerRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_createMapRenderer, doc_QgsPointCloudLayer_createMapRenderer);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_profileSource, "profileSource(self) -> Optional[QgsAbstractProfileSource]");

extern "C" {static PyObject *meth_QgsPointCloudLayer_profileSource(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_profileSource(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QgsAbstractProfileSource*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::profileSource() : sipCpp->profileSource());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsAbstractProfileSource, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_profileSource, doc_QgsPointCloudLayer_profileSource);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_createProfileGenerator, "createProfileGenerator(self, request: QgsProfileRequest) -> Optional[QgsAbstractProfileGenerator]");

extern "C" {static PyObject *meth_QgsPointCloudLayer_createProfileGenerator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_createProfileGenerator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsProfileRequest* a0;
        ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_request,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QgsProfileRequest, &a0))
        {
            ::QgsAbstractProfileGenerator*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::createProfileGenerator(*a0) : sipCpp->createProfileGenerator(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsAbstractProfileGenerator, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_createProfileGenerator, doc_QgsPointCloudLayer_createProfileGenerator);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_dataProvider, "dataProvider(self) -> Optional[QgsPointCloudDataProvider]");

extern "C" {static PyObject *meth_QgsPointCloudLayer_dataProvider(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_dataProvider(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QgsPointCloudDataProvider*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::dataProvider() : sipCpp->dataProvider());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsPointCloudDataProvider, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_dataProvider, doc_QgsPointCloudLayer_dataProvider);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_supportsEditing, "supportsEditing(self) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayer_supportsEditing(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_supportsEditing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::supportsEditing() : sipCpp->supportsEditing());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_supportsEditing, doc_QgsPointCloudLayer_supportsEditing);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_isEditable, "isEditable(self) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayer_isEditable(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_isEditable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::isEditable() : sipCpp->isEditable());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_isEditable, doc_QgsPointCloudLayer_isEditable);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_isModified, "isModified(self) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayer_isModified(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_isModified(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::isModified() : sipCpp->isModified());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_isModified, doc_QgsPointCloudLayer_isModified);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_readXml, "readXml(self, layerNode: QDomNode, context: QgsReadWriteContext) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayer_readXml(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_readXml(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QDomNode* a0;
        ::QgsReadWriteContext* a1;
        ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layerNode,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomNode, &a0, sipType_QgsReadWriteContext, &a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::readXml(*a0, *a1) : sipCpp->readXml(*a0, *a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_readXml, doc_QgsPointCloudLayer_readXml);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_writeXml, "writeXml(self, layerNode: QDomNode, doc: QDomDocument, context: QgsReadWriteContext) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayer_writeXml(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_writeXml(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QDomNode* a0;
        ::QDomDocument* a1;
        const ::QgsReadWriteContext* a2;
        const ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_layerNode,
            sipName_doc,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9J9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomNode, &a0, sipType_QDomDocument, &a1, sipType_QgsReadWriteContext, &a2))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::writeXml(*a0, *a1, *a2) : sipCpp->writeXml(*a0, *a1, *a2));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_writeXml, doc_QgsPointCloudLayer_writeXml);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_readSymbology, "readSymbology(self, node: QDomNode, errorMessage: Optional[str], context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = QgsMapLayer.AllStyleCategories) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayer_readSymbology(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_readSymbology(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QDomNode* a0;
        ::QString* a1;
        int a1State = 0;
        ::QgsReadWriteContext* a2;
        ::QgsMapLayer::StyleCategories a3def = ::QgsMapLayer::AllStyleCategories;
        ::QgsMapLayer::StyleCategories* a3 = &a3def;
        int a3State = 0;
        ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_node,
            sipName_errorMessage,
            sipName_context,
            sipName_categories,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1J9|J1", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomNode, &a0, sipType_QString, &a1, &a1State, sipType_QgsReadWriteContext, &a2, sipType_QgsMapLayer_StyleCategories, &a3, &a3State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::readSymbology(*a0, *a1, *a2, *a3) : sipCpp->readSymbology(*a0, *a1, *a2, *a3));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(a1, sipType_QString, a1State);
            sipReleaseType(a3, sipType_QgsMapLayer_StyleCategories, a3State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(a1, sipType_QString, a1State);
            sipReleaseType(a3, sipType_QgsMapLayer_StyleCategories, a3State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_readSymbology, doc_QgsPointCloudLayer_readSymbology);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_readStyle, "readStyle(self, node: QDomNode, errorMessage: Optional[str], context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = QgsMapLayer.AllStyleCategories) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayer_readStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_readStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDomNode* a0;
        ::QString* a1;
        int a1State = 0;
        ::QgsReadWriteContext* a2;
        ::QgsMapLayer::StyleCategories a3def = ::QgsMapLayer::AllStyleCategories;
        ::QgsMapLayer::StyleCategories* a3 = &a3def;
        int a3State = 0;
        ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_node,
            sipName_errorMessage,
            sipName_context,
            sipName_categories,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1J9|J1", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomNode, &a0, sipType_QString, &a1, &a1State, sipType_QgsReadWriteContext, &a2, sipType_QgsMapLayer_StyleCategories, &a3, &a3State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->readStyle(*a0, *a1, *a2, *a3);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(a1, sipType_QString, a1State);
            sipReleaseType(a3, sipType_QgsMapLayer_StyleCategories, a3State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(a1, sipType_QString, a1State);
            sipReleaseType(a3, sipType_QgsMapLayer_StyleCategories, a3State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_readStyle, doc_QgsPointCloudLayer_readStyle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_writeSymbology, "writeSymbology(self, node: QDomNode, doc: QDomDocument, errorMessage: Optional[str], context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = QgsMapLayer.AllStyleCategories) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayer_writeSymbology(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_writeSymbology(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QDomNode* a0;
        ::QDomDocument* a1;
        ::QString* a2;
        int a2State = 0;
        const ::QgsReadWriteContext* a3;
        ::QgsMapLayer::StyleCategories a4def = ::QgsMapLayer::AllStyleCategories;
        ::QgsMapLayer::StyleCategories* a4 = &a4def;
        int a4State = 0;
        const ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_node,
            sipName_doc,
            sipName_errorMessage,
            sipName_context,
            sipName_categories,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9J1J9|J1", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomNode, &a0, sipType_QDomDocument, &a1, sipType_QString, &a2, &a2State, sipType_QgsReadWriteContext, &a3, sipType_QgsMapLayer_StyleCategories, &a4, &a4State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::writeSymbology(*a0, *a1, *a2, *a3, *a4) : sipCpp->writeSymbology(*a0, *a1, *a2, *a3, *a4));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(a2, sipType_QString, a2State);
            sipReleaseType(a4, sipType_QgsMapLayer_StyleCategories, a4State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(a2, sipType_QString, a2State);
            sipReleaseType(a4, sipType_QgsMapLayer_StyleCategories, a4State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_writeSymbology, doc_QgsPointCloudLayer_writeSymbology);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_writeStyle, "writeStyle(self, node: QDomNode, doc: QDomDocument, errorMessage: Optional[str], context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = QgsMapLayer.AllStyleCategories) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudLayer_writeStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_writeStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDomNode* a0;
        ::QDomDocument* a1;
        ::QString* a2;
        int a2State = 0;
        const ::QgsReadWriteContext* a3;
        ::QgsMapLayer::StyleCategories a4def = ::QgsMapLayer::AllStyleCategories;
        ::QgsMapLayer::StyleCategories* a4 = &a4def;
        int a4State = 0;
        const ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_node,
            sipName_doc,
            sipName_errorMessage,
            sipName_context,
            sipName_categories,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9J1J9|J1", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QDomNode, &a0, sipType_QDomDocument, &a1, sipType_QString, &a2, &a2State, sipType_QgsReadWriteContext, &a3, sipType_QgsMapLayer_StyleCategories, &a4, &a4State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->writeStyle(*a0, *a1, *a2, *a3, *a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(a2, sipType_QString, a2State);
            sipReleaseType(a4, sipType_QgsMapLayer_StyleCategories, a4State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(a2, sipType_QString, a2State);
            sipReleaseType(a4, sipType_QgsMapLayer_StyleCategories, a4State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_writeStyle, doc_QgsPointCloudLayer_writeStyle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_setTransformContext, "setTransformContext(self, transformContext: QgsCoordinateTransformContext)");

extern "C" {static PyObject *meth_QgsPointCloudLayer_setTransformContext(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_setTransformContext(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsCoordinateTransformContext* a0;
        ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_transformContext,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QgsCoordinateTransformContext, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::setTransformContext(*a0) : sipCpp->setTransformContext(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_setTransformContext, doc_QgsPointCloudLayer_setTransformContext);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_encodedSource, "encodedSource(self, source: Optional[str], context: QgsReadWriteContext) -> str");

extern "C" {static PyObject *meth_QgsPointCloudLayer_encodedSource(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_encodedSource(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QgsReadWriteContext* a1;
        const ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_source,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QString, &a0, &a0State, sipType_QgsReadWriteContext, &a1))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString((sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::encodedSource(*a0, *a1) : sipCpp->encodedSource(*a0, *a1)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_encodedSource, doc_QgsPointCloudLayer_encodedSource);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_decodedSource, "decodedSource(self, source: Optional[str], dataProvider: Optional[str], context: QgsReadWriteContext) -> str");

extern "C" {static PyObject *meth_QgsPointCloudLayer_decodedSource(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_decodedSource(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        const ::QgsReadWriteContext* a2;
        const ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_source,
            sipName_dataProvider,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1J9", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QgsReadWriteContext, &a2))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString((sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::decodedSource(*a0, *a1, *a2) : sipCpp->decodedSource(*a0, *a1, *a2)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_decodedSource, doc_QgsPointCloudLayer_decodedSource);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_loadDefaultStyle, "loadDefaultStyle(self) -> (str, bool)");

extern "C" {static PyObject *meth_QgsPointCloudLayer_loadDefaultStyle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_loadDefaultStyle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QgsPointCloudLayer *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->loadDefaultStyle(a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            PyObject *sipResObj = sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
            return sipBuildResult(0, "(Rb)", sipResObj, a0);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_loadDefaultStyle, doc_QgsPointCloudLayer_loadDefaultStyle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_htmlMetadata, "htmlMetadata(self) -> str");

extern "C" {static PyObject *meth_QgsPointCloudLayer_htmlMetadata(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_htmlMetadata(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString((sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::htmlMetadata() : sipCpp->htmlMetadata()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_htmlMetadata, doc_QgsPointCloudLayer_htmlMetadata);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_elevationProperties, "elevationProperties(self) -> Optional[QgsMapLayerElevationProperties]");

extern "C" {static PyObject *meth_QgsPointCloudLayer_elevationProperties(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_elevationProperties(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QgsMapLayerElevationProperties*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudLayer::elevationProperties() : sipCpp->elevationProperties());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsMapLayerElevationProperties, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_elevationProperties, doc_QgsPointCloudLayer_elevationProperties);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_attributes, "attributes(self) -> QgsPointCloudAttributeCollection\n"
"Returns the attributes available from the layer.");

extern "C" {static PyObject *meth_QgsPointCloudLayer_attributes(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_attributes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QgsPointCloudAttributeCollection*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudAttributeCollection(sipCpp->attributes());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudAttributeCollection, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_attributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_pointCount, "pointCount(self) -> int\n"
"Returns the total number of points available in the layer.");

extern "C" {static PyObject *meth_QgsPointCloudLayer_pointCount(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_pointCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::qint64 sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointCount();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_pointCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_renderer, "renderer(self) -> Optional[QgsPointCloudRenderer]\n"
"Returns the 2D renderer for the point cloud.\n"
"\n"
".. seealso:: :py:func:`setRenderer`");

extern "C" {static PyObject *meth_QgsPointCloudLayer_renderer(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_renderer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QgsPointCloudRenderer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->renderer();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsPointCloudRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_renderer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_setRenderer, "setRenderer(self, renderer: Optional[QgsPointCloudRenderer])\n"
"Sets the 2D ``renderer`` for the point cloud.\n"
"\n"
"Ownership of ``renderer`` is transferred to the layer.\n"
"\n"
".. seealso:: :py:func:`renderer`");

extern "C" {static PyObject *meth_QgsPointCloudLayer_setRenderer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_setRenderer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRenderer* a0;
        ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_renderer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QgsPointCloudRenderer, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setRenderer(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_setRenderer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_setSubsetString, "setSubsetString(self, subset: Optional[str]) -> bool\n"
"Sets the string used to define a subset of the layer\n"
"\n"
":param subset: The subset string to be used in a\n"
"               ``:py:class:`QgsPointCloudExpression```\n"
"\n"
":return: ``True``, when setting the subset string was successful,\n"
"         ``False`` otherwise\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayer_setSubsetString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_setSubsetString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_subset,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->setSubsetString(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_setSubsetString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_subsetString, "subsetString(self) -> str\n"
"Returns the string used to define a subset of the layer.\n"
"\n"
":return: The subset string or an empty string if not implemented by the\n"
"         provider\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayer_subsetString(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_subsetString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->subsetString());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_subsetString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_setSync3DRendererTo2DRenderer, "setSync3DRendererTo2DRenderer(self, sync: bool)\n"
"Sets whether this layer's 3D renderer should be automatically updated\n"
"with changes applied to the layer's 2D renderer\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayer_setSync3DRendererTo2DRenderer(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_setSync3DRendererTo2DRenderer(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_sync,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setSync3DRendererTo2DRenderer(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_setSync3DRendererTo2DRenderer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_sync3DRendererTo2DRenderer, "sync3DRendererTo2DRenderer(self) -> bool\n"
"Returns whether this layer's 3D renderer should be automatically updated\n"
"with changes applied to the layer's 2D renderer\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayer_sync3DRendererTo2DRenderer(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_sync3DRendererTo2DRenderer(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->sync3DRendererTo2DRenderer();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_sync3DRendererTo2DRenderer, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_convertRenderer3DFromRenderer2D, "convertRenderer3DFromRenderer2D(self) -> bool\n"
"Updates the layer's 3D renderer's symbol to match that of the layer's 2D\n"
"renderer\n"
"\n"
":return: ``True`` on success, ``False`` otherwise\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayer_convertRenderer3DFromRenderer2D(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_convertRenderer3DFromRenderer2D(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->convertRenderer3DFromRenderer2D();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_convertRenderer3DFromRenderer2D, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_statistics, "statistics(self) -> QgsPointCloudStatistics\n"
"Returns the object containing statistics\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayer_statistics(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_statistics(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QgsPointCloudStatistics*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudStatistics(sipCpp->statistics());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudStatistics, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_statistics, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_statisticsCalculationState, "statisticsCalculationState(self) -> QgsPointCloudLayer.PointCloudStatisticsCalculationState\n"
"Returns the status of point cloud statistics calculation\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudLayer_statisticsCalculationState(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_statisticsCalculationState(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QgsPointCloudLayer::PointCloudStatisticsCalculationState sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->statisticsCalculationState();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QgsPointCloudLayer_PointCloudStatisticsCalculationState);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_statisticsCalculationState, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_startEditing, "startEditing(self) -> bool\n"
"Makes the layer editable.\n"
"\n"
"This starts an edit session on this layer. Changes made in this edit\n"
"session will not be made persistent until\n"
":py:func:`~QgsPointCloudLayer.commitChanges` is called, and can be\n"
"reverted by calling :py:func:`~QgsPointCloudLayer.rollBack`.\n"
"\n"
":return: ``True`` if the layer was successfully made editable, or\n"
"         ``False`` if the operation failed (e.g. due to an underlying\n"
"         read-only data source, or lack of edit support by the backend\n"
"         data provider).\n"
"\n"
".. seealso:: :py:func:`commitChanges`\n"
"\n"
".. seealso:: :py:func:`rollBack`\n"
"\n"
".. versionadded:: 3.42");

extern "C" {static PyObject *meth_QgsPointCloudLayer_startEditing(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_startEditing(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->startEditing();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_startEditing, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_commitChanges, "commitChanges(self, stopEditing: bool = True) -> bool\n"
"Attempts to commit to the underlying data provider any buffered changes\n"
"made since the last to call to\n"
":py:func:`~QgsPointCloudLayer.startEditing`.\n"
"\n"
"Returns the result of the attempt. If a commit fails (i.e. ``False`` is\n"
"returned), the in-memory changes are left untouched and are not\n"
"discarded. This allows editing to continue if the commit failed on e.g.\n"
"a disallowed value for an attribute - the user can re-edit and try\n"
"again.\n"
"\n"
"If the commit failed, an error message may returned by\n"
":py:func:`~QgsPointCloudLayer.commitError`.\n"
"\n"
"By setting ``stopEditing`` to ``False``, the layer will stay in editing\n"
"mode. Otherwise the layer editing mode will be disabled if the commit is\n"
"successful.\n"
"\n"
".. seealso:: :py:func:`startEditing`\n"
"\n"
".. seealso:: :py:func:`commitError`\n"
"\n"
".. seealso:: :py:func:`rollBack`\n"
"\n"
".. versionadded:: 3.42");

extern "C" {static PyObject *meth_QgsPointCloudLayer_commitChanges(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_commitChanges(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0 = 1;
        ::QgsPointCloudLayer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stopEditing,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->commitChanges(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_commitChanges, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_commitError, "commitError(self) -> str\n"
"Returns the last error message generated when attempting to commit\n"
"changes to the layer.\n"
"\n"
".. seealso:: :py:func:`commitChanges`\n"
"\n"
".. versionadded:: 3.42");

extern "C" {static PyObject *meth_QgsPointCloudLayer_commitError(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_commitError(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString(sipCpp->commitError());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_commitError, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_rollBack, "rollBack(self) -> bool\n"
"Stops a current editing operation and discards any uncommitted edits.\n"
"\n"
".. seealso:: :py:func:`startEditing`\n"
"\n"
".. seealso:: :py:func:`commitChanges`\n"
"\n"
".. versionadded:: 3.42");

extern "C" {static PyObject *meth_QgsPointCloudLayer_rollBack(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_rollBack(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->rollBack();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_rollBack, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudLayer_index, "index(self) -> QgsPointCloudIndex\n"
"Returns the point cloud index associated with the layer. If the layer is\n"
"editable, its :py:class:`QgsPointCloudEditingIndex` is returned,\n"
"otherwise the index is fetched from the data provider.\n"
"\n"
".. versionadded:: 3.42");

extern "C" {static PyObject *meth_QgsPointCloudLayer_index(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudLayer_index(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudLayer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudLayer, &sipCpp))
        {
            ::QgsPointCloudIndex*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudIndex(sipCpp->index());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudIndex, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudLayer, sipName_index, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QgsPointCloudLayer___repr__(PyObject *);}
static PyObject *slot_QgsPointCloudLayer___repr__(PyObject *sipSelf)
{
    ::QgsPointCloudLayer *sipCpp = reinterpret_cast< ::QgsPointCloudLayer *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QgsPointCloudLayer));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 72 "auto_generated/pointcloud/qgspointcloudlayer.sip"
    QString str = QStringLiteral( "<QgsPointCloudLayer: '%1' (%2)>" ).arg( sipCpp->name(), sipCpp->dataProvider() ? sipCpp->dataProvider()->name() : QStringLiteral( "Invalid" ) );
    sipRes = PyUnicode_FromString( str.toUtf8().constData() );
#line 23425 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QgsPointCloudLayer(void *, const sipTypeDef *);}
static void *cast_QgsPointCloudLayer(void *sipCppV, const sipTypeDef *targetType)
{
    ::QgsPointCloudLayer *sipCpp = reinterpret_cast< ::QgsPointCloudLayer *>(sipCppV);

    if (targetType == sipType_QgsPointCloudLayer)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_QgsMapLayer)->ctd_cast(static_cast< ::QgsMapLayer *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    if (targetType == sipType_QgsAbstractProfileSource)
        return static_cast< ::QgsAbstractProfileSource *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudLayer(void *, int);}
static void release_QgsPointCloudLayer(void *sipCppV, int)
{
    ::QgsPointCloudLayer *sipCpp = reinterpret_cast< ::QgsPointCloudLayer *>(sipCppV);

    Py_BEGIN_ALLOW_THREADS

    if (QThread::currentThread() == sipCpp->thread())
        delete sipCpp;
    else
        sipCpp->deleteLater();

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsPointCloudLayer(Py_ssize_t);}
static void *array_QgsPointCloudLayer(Py_ssize_t sipNrElem)
{
    return new ::QgsPointCloudLayer[sipNrElem];
}


extern "C" {static void array_delete_QgsPointCloudLayer(void *);}
static void array_delete_QgsPointCloudLayer(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsPointCloudLayer *>(sipCpp);
}


extern "C" {static void dealloc_QgsPointCloudLayer(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudLayer(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQgsPointCloudLayer *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudLayer(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QgsPointCloudLayer(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudLayer(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQgsPointCloudLayer *sipCpp = SIP_NULLPTR;

    {
        const ::QString& a0def = QString();
        const ::QString* a0 = &a0def;
        int a0State = 0;
        const ::QString& a1def = QString();
        const ::QString* a1 = &a1def;
        int a1State = 0;
        const ::QString& a2def = QStringLiteral("pointcloud");
        const ::QString* a2 = &a2def;
        int a2State = 0;
        const ::QgsPointCloudLayer::LayerOptions& a3def = QgsPointCloudLayer::LayerOptions();
        const ::QgsPointCloudLayer::LayerOptions* a3 = &a3def;

        static const char *sipKwdList[] = {
            sipName_uri,
            sipName_baseName,
            sipName_providerLib,
            sipName_options,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1J1J1J9", sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State, sipType_QString, &a2, &a2State, sipType_QgsPointCloudLayer_LayerOptions, &a3))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsPointCloudLayer(*a0, *a1, *a2, *a3);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
            sipReleaseType(const_cast< ::QString *>(a2), sipType_QString, a2State);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QgsPointCloudLayer[] = {{1567, 255, 0}, {828, 255, 1}};


/* Define this type's Python slots. */
static sipPySlotDef slots_QgsPointCloudLayer[] = {
    {(void *)slot_QgsPointCloudLayer___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QgsPointCloudLayer[] = {
    {sipName_appendError, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_appendError), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_attributes, meth_QgsPointCloudLayer_attributes, METH_VARARGS, doc_QgsPointCloudLayer_attributes},
    {sipName_childEvent, meth_QgsPointCloudLayer_childEvent, METH_VARARGS, SIP_NULLPTR},
    {sipName_clone, meth_QgsPointCloudLayer_clone, METH_VARARGS, doc_QgsPointCloudLayer_clone},
    {sipName_commitChanges, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_commitChanges), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_commitChanges},
    {sipName_commitError, meth_QgsPointCloudLayer_commitError, METH_VARARGS, doc_QgsPointCloudLayer_commitError},
    {sipName_connectNotify, meth_QgsPointCloudLayer_connectNotify, METH_VARARGS, SIP_NULLPTR},
    {sipName_convertRenderer3DFromRenderer2D, meth_QgsPointCloudLayer_convertRenderer3DFromRenderer2D, METH_VARARGS, doc_QgsPointCloudLayer_convertRenderer3DFromRenderer2D},
    {sipName_createMapRenderer, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_createMapRenderer), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_createMapRenderer},
    {sipName_createProfileGenerator, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_createProfileGenerator), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_createProfileGenerator},
    {sipName_customEvent, meth_QgsPointCloudLayer_customEvent, METH_VARARGS, SIP_NULLPTR},
    {sipName_dataProvider, meth_QgsPointCloudLayer_dataProvider, METH_VARARGS, doc_QgsPointCloudLayer_dataProvider},
    {sipName_decodedSource, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_decodedSource), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_decodedSource},
    {sipName_disconnectNotify, meth_QgsPointCloudLayer_disconnectNotify, METH_VARARGS, SIP_NULLPTR},
    {sipName_elevationProperties, meth_QgsPointCloudLayer_elevationProperties, METH_VARARGS, doc_QgsPointCloudLayer_elevationProperties},
    {sipName_encodedSource, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_encodedSource), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_encodedSource},
    {sipName_extent, meth_QgsPointCloudLayer_extent, METH_VARARGS, doc_QgsPointCloudLayer_extent},
    {sipName_hasDependencyCycle, meth_QgsPointCloudLayer_hasDependencyCycle, METH_VARARGS, SIP_NULLPTR},
    {sipName_htmlMetadata, meth_QgsPointCloudLayer_htmlMetadata, METH_VARARGS, doc_QgsPointCloudLayer_htmlMetadata},
    {sipName_index, meth_QgsPointCloudLayer_index, METH_VARARGS, doc_QgsPointCloudLayer_index},
    {sipName_invalidateWgs84Extent, meth_QgsPointCloudLayer_invalidateWgs84Extent, METH_VARARGS, SIP_NULLPTR},
    {sipName_isEditable, meth_QgsPointCloudLayer_isEditable, METH_VARARGS, doc_QgsPointCloudLayer_isEditable},
    {sipName_isModified, meth_QgsPointCloudLayer_isModified, METH_VARARGS, doc_QgsPointCloudLayer_isModified},
    {sipName_isSignalConnected, meth_QgsPointCloudLayer_isSignalConnected, METH_VARARGS, SIP_NULLPTR},
    {sipName_loadDefaultStyle, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_loadDefaultStyle), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_loadDefaultStyle},
    {sipName_pointCount, meth_QgsPointCloudLayer_pointCount, METH_VARARGS, doc_QgsPointCloudLayer_pointCount},
    {sipName_profileSource, meth_QgsPointCloudLayer_profileSource, METH_VARARGS, doc_QgsPointCloudLayer_profileSource},
    {sipName_readCommonStyle, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_readCommonStyle), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_readCustomProperties, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_readCustomProperties), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_readStyle, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_readStyle), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_readStyle},
    {sipName_readStyleManager, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_readStyleManager), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_readSymbology, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_readSymbology), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_readSymbology},
    {sipName_readXml, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_readXml), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_readXml},
    {sipName_receivers, meth_QgsPointCloudLayer_receivers, METH_VARARGS, SIP_NULLPTR},
    {sipName_renderer, meth_QgsPointCloudLayer_renderer, METH_VARARGS, doc_QgsPointCloudLayer_renderer},
    {sipName_rollBack, meth_QgsPointCloudLayer_rollBack, METH_VARARGS, doc_QgsPointCloudLayer_rollBack},
    {sipName_sender, meth_QgsPointCloudLayer_sender, METH_VARARGS, SIP_NULLPTR},
    {sipName_senderSignalIndex, meth_QgsPointCloudLayer_senderSignalIndex, METH_VARARGS, SIP_NULLPTR},
    {sipName_setError, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_setError), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_setExtent, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_setExtent), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_setExtent3D, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_setExtent3D), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_setProviderType, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_setProviderType), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_setRenderer, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_setRenderer), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_setRenderer},
    {sipName_setSubsetString, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_setSubsetString), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_setSubsetString},
    {sipName_setSync3DRendererTo2DRenderer, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_setSync3DRendererTo2DRenderer), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_setSync3DRendererTo2DRenderer},
    {sipName_setTransformContext, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_setTransformContext), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_setTransformContext},
    {sipName_setValid, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_setValid), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_startEditing, meth_QgsPointCloudLayer_startEditing, METH_VARARGS, doc_QgsPointCloudLayer_startEditing},
    {sipName_statistics, meth_QgsPointCloudLayer_statistics, METH_VARARGS, doc_QgsPointCloudLayer_statistics},
    {sipName_statisticsCalculationState, meth_QgsPointCloudLayer_statisticsCalculationState, METH_VARARGS, doc_QgsPointCloudLayer_statisticsCalculationState},
    {sipName_subsetString, meth_QgsPointCloudLayer_subsetString, METH_VARARGS, doc_QgsPointCloudLayer_subsetString},
    {sipName_supportsEditing, meth_QgsPointCloudLayer_supportsEditing, METH_VARARGS, doc_QgsPointCloudLayer_supportsEditing},
    {sipName_sync3DRendererTo2DRenderer, meth_QgsPointCloudLayer_sync3DRendererTo2DRenderer, METH_VARARGS, doc_QgsPointCloudLayer_sync3DRendererTo2DRenderer},
    {sipName_timerEvent, meth_QgsPointCloudLayer_timerEvent, METH_VARARGS, SIP_NULLPTR},
    {sipName_writeCommonStyle, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_writeCommonStyle), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_writeCustomProperties, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_writeCustomProperties), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_writeStyle, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_writeStyle), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_writeStyle},
    {sipName_writeStyleManager, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_writeStyleManager), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_writeSymbology, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_writeSymbology), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_writeSymbology},
    {sipName_writeXml, SIP_MLMETH_CAST(meth_QgsPointCloudLayer_writeXml), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudLayer_writeXml}
};

static sipEnumMemberDef enummembers_QgsPointCloudLayer[] = {
    {sipName_Calculated, static_cast<int>(::QgsPointCloudLayer::PointCloudStatisticsCalculationState::Calculated), 1801},
    {sipName_Calculating, static_cast<int>(::QgsPointCloudLayer::PointCloudStatisticsCalculationState::Calculating), 1801},
    {sipName_NotStarted, static_cast<int>(::QgsPointCloudLayer::PointCloudStatisticsCalculationState::NotStarted), 1801},
};

PyDoc_STRVAR(doc_QgsPointCloudLayer, "Represents a map layer supporting display of point clouds.\n"
"\n"
".. note::\n"
"\n"
"   The API is considered EXPERIMENTAL and can be changed without a notice\n"
"\n"
".. versionadded:: 3.18\n"
"\n"
"QgsPointCloudLayer(uri: Optional[str] = '', baseName: Optional[str] = '', providerLib: Optional[str] = '', options: QgsPointCloudLayer.LayerOptions = QgsPointCloudLayer.LayerOptions())\n"
"Constructor - creates a point cloud layer");


/* Define this type's signals. */
static const pyqt5QtSignal signals_QgsPointCloudLayer[] = {
    {"chunkAttributeValuesChanged(QgsPointCloudNodeId)", "chunkAttributeValuesChanged(self, n: QgsPointCloudNodeId)\nEmitted when a node gets some attribute values of some points changed\n"
"\n"
".. versionadded:: 3.42", SIP_NULLPTR, SIP_NULLPTR},
    {"statisticsCalculationStateChanged(QgsPointCloudLayer::PointCloudStatisticsCalculationState)", "statisticsCalculationStateChanged(self, state: QgsPointCloudLayer.PointCloudStatisticsCalculationState)\nEmitted when statistics calculation state has changed\n"
"\n"
".. versionadded:: 3.26", SIP_NULLPTR, SIP_NULLPTR},
    {"raiseError(QString)", "raiseError(self, msg: Optional[str])\nSignals an error related to this point cloud layer.\n"
"\n"
".. versionadded:: 3.26", SIP_NULLPTR, SIP_NULLPTR},
    {"subsetStringChanged()", "subsetStringChanged(self)\nEmitted when the layer's subset string has changed.\n"
"\n"
".. versionadded:: 3.26", SIP_NULLPTR, SIP_NULLPTR},
    {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR}
};


static pyqt5ClassPluginDef plugin_QgsPointCloudLayer = {
    &::QgsPointCloudLayer::staticMetaObject,
    0,
    signals_QgsPointCloudLayer,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudLayer = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudLayer,
        SIP_NULLPTR,
        &plugin_QgsPointCloudLayer,
    },
    {
        sipNameNr_QgsPointCloudLayer,
        {0, 0, 1},
        60, methods_QgsPointCloudLayer,
        3, enummembers_QgsPointCloudLayer,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudLayer,
    -1,
    -1,
    supers_QgsPointCloudLayer,
    slots_QgsPointCloudLayer,
    init_type_QgsPointCloudLayer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudLayer,
    SIP_NULLPTR,
    array_QgsPointCloudLayer,
    SIP_NULLPTR,
    release_QgsPointCloudLayer,
    cast_QgsPointCloudLayer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsPointCloudLayer,
    sizeof (::QgsPointCloudLayer),
};

#line 26 "auto_generated/pointcloud/qgspointcloudblock.sip"
#include "qgspointcloudblock.h"
#line 23728 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 106 "auto_generated/pointcloud/qgspointcloudattribute.sip"
#include "qgspointcloudattribute.h"
#line 23732 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 30 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 23735 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 20 "auto_generated/qgsvector3d.sip"
#include "qgsvector3d.h"
#line 23738 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


class sipQgsPointCloudBlock : public ::QgsPointCloudBlock
{
public:
    sipQgsPointCloudBlock(int, const ::QgsPointCloudAttributeCollection&, const ::QByteArray&, const ::QgsVector3D&, const ::QgsVector3D&);
    sipQgsPointCloudBlock(const ::QgsPointCloudBlock&);
    ~sipQgsPointCloudBlock();

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQgsPointCloudBlock(const sipQgsPointCloudBlock &);
    sipQgsPointCloudBlock &operator = (const sipQgsPointCloudBlock &);
};

sipQgsPointCloudBlock::sipQgsPointCloudBlock(int a0, const ::QgsPointCloudAttributeCollection& a1, const ::QByteArray& a2, const ::QgsVector3D& a3, const ::QgsVector3D& a4): ::QgsPointCloudBlock(a0, a1, a2, a3, a4), sipPySelf(SIP_NULLPTR)
{
}

sipQgsPointCloudBlock::sipQgsPointCloudBlock(const ::QgsPointCloudBlock& a0): ::QgsPointCloudBlock(a0), sipPySelf(SIP_NULLPTR)
{
}

sipQgsPointCloudBlock::~sipQgsPointCloudBlock()
{
    sipInstanceDestroyedEx(&sipPySelf);
}


PyDoc_STRVAR(doc_QgsPointCloudBlock_clone, "clone(self) -> Optional[QgsPointCloudBlock]\n"
"Clones the QgsPointCloudBlock returning a new copy. Caller takes\n"
"ownership of the returned object.\n"
"\n"
".. versionadded:: 3.36");

extern "C" {static PyObject *meth_QgsPointCloudBlock_clone(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudBlock_clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudBlock *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudBlock, &sipCpp))
        {
            ::QgsPointCloudBlock*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->clone();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudBlock, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudBlock, sipName_clone, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudBlock_data, "data(self) -> Optional[str]\n"
"Returns raw pointer to data");

extern "C" {static PyObject *meth_QgsPointCloudBlock_data(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudBlock_data(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudBlock *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudBlock, &sipCpp))
        {
            const char*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->data();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            if (sipRes == SIP_NULLPTR)
            {
                Py_INCREF(Py_None);
                return Py_None;
            }

            return PyUnicode_DecodeASCII(sipRes, strlen(sipRes), SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudBlock, sipName_data, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudBlock_pointCount, "pointCount(self) -> int\n"
"Returns number of points that are stored in the block");

extern "C" {static PyObject *meth_QgsPointCloudBlock_pointCount(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudBlock_pointCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudBlock *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudBlock, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointCount();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudBlock, sipName_pointCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudBlock_pointRecordSize, "pointRecordSize(self) -> int\n"
"Returns the total size of each individual point record.\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudBlock_pointRecordSize(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudBlock_pointRecordSize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudBlock *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudBlock, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->pointRecordSize();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudBlock, sipName_pointRecordSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudBlock_attributes, "attributes(self) -> QgsPointCloudAttributeCollection\n"
"Returns the attributes that are stored in the data block, along with\n"
"their size");

extern "C" {static PyObject *meth_QgsPointCloudBlock_attributes(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudBlock_attributes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudBlock *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudBlock, &sipCpp))
        {
            ::QgsPointCloudAttributeCollection*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsPointCloudAttributeCollection(sipCpp->attributes());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudAttributeCollection, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudBlock, sipName_attributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudBlock_scale, "scale(self) -> QgsVector3D\n"
"Returns the custom scale of the block.");

extern "C" {static PyObject *meth_QgsPointCloudBlock_scale(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudBlock_scale(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudBlock *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudBlock, &sipCpp))
        {
            ::QgsVector3D*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsVector3D(sipCpp->scale());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudBlock, sipName_scale, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudBlock_offset, "offset(self) -> QgsVector3D\n"
"Returns the custom offset of the block.");

extern "C" {static PyObject *meth_QgsPointCloudBlock_offset(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudBlock_offset(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudBlock *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudBlock, &sipCpp))
        {
            ::QgsVector3D*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QgsVector3D(sipCpp->offset());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudBlock, sipName_offset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudBlock_setPointCount, "setPointCount(self, size: int)\n"
"Changes the number of points in the block.\n"
"\n"
"This is used in order to remove all points after point ``size``.\n"
"\n"
"If a ``size`` larger than :py:func:`~QgsPointCloudBlock.pointCount` is\n"
"used, data for the new points will be uninitialized.\n"
"\n"
".. versionadded:: 3.26");

extern "C" {static PyObject *meth_QgsPointCloudBlock_setPointCount(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudBlock_setPointCount(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QgsPointCloudBlock *sipCpp;

        static const char *sipKwdList[] = {
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_QgsPointCloudBlock, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setPointCount(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudBlock, sipName_setPointCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudBlock(void *, int);}
static void release_QgsPointCloudBlock(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQgsPointCloudBlock *>(sipCppV);
    else
        delete reinterpret_cast< ::QgsPointCloudBlock *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_QgsPointCloudBlock(void *, Py_ssize_t, void *);}
static void assign_QgsPointCloudBlock(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QgsPointCloudBlock *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QgsPointCloudBlock *>(sipSrc);
}


extern "C" {static void *copy_QgsPointCloudBlock(const void *, Py_ssize_t);}
static void *copy_QgsPointCloudBlock(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QgsPointCloudBlock(reinterpret_cast<const ::QgsPointCloudBlock *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QgsPointCloudBlock(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudBlock(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQgsPointCloudBlock *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudBlock(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QgsPointCloudBlock(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudBlock(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQgsPointCloudBlock *sipCpp = SIP_NULLPTR;

    {
        int a0;
        const ::QgsPointCloudAttributeCollection* a1;
        const ::QByteArray* a2;
        int a2State = 0;
        const ::QgsVector3D* a3;
        const ::QgsVector3D* a4;

        static const char *sipKwdList[] = {
            sipName_count,
            sipName_attributes,
            sipName_data,
            sipName_scale,
            sipName_offset,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iJ9J1J9J9", &a0, sipType_QgsPointCloudAttributeCollection, &a1, sipType_QByteArray, &a2, &a2State, sipType_QgsVector3D, &a3, sipType_QgsVector3D, &a4))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsPointCloudBlock(a0, *a1, *a2, *a3, *a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QByteArray *>(a2), sipType_QByteArray, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QByteArray *>(a2), sipType_QByteArray, a2State);

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::QgsPointCloudBlock* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QgsPointCloudBlock, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsPointCloudBlock(*a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QgsPointCloudBlock[] = {
    {sipName_attributes, meth_QgsPointCloudBlock_attributes, METH_VARARGS, doc_QgsPointCloudBlock_attributes},
    {sipName_clone, meth_QgsPointCloudBlock_clone, METH_VARARGS, doc_QgsPointCloudBlock_clone},
    {sipName_data, meth_QgsPointCloudBlock_data, METH_VARARGS, doc_QgsPointCloudBlock_data},
    {sipName_offset, meth_QgsPointCloudBlock_offset, METH_VARARGS, doc_QgsPointCloudBlock_offset},
    {sipName_pointCount, meth_QgsPointCloudBlock_pointCount, METH_VARARGS, doc_QgsPointCloudBlock_pointCount},
    {sipName_pointRecordSize, meth_QgsPointCloudBlock_pointRecordSize, METH_VARARGS, doc_QgsPointCloudBlock_pointRecordSize},
    {sipName_scale, meth_QgsPointCloudBlock_scale, METH_VARARGS, doc_QgsPointCloudBlock_scale},
    {sipName_setPointCount, SIP_MLMETH_CAST(meth_QgsPointCloudBlock_setPointCount), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudBlock_setPointCount}
};

PyDoc_STRVAR(doc_QgsPointCloudBlock, "Base class for storing raw data from point cloud nodes.\n"
"\n"
".. note::\n"
"\n"
"   The API is considered EXPERIMENTAL and can be changed without a notice\n"
"\n"
".. versionadded:: 3.18\n"
"\n"
"QgsPointCloudBlock(count: int, attributes: QgsPointCloudAttributeCollection, data: Union[QByteArray, bytes, bytearray], scale: QgsVector3D, offset: QgsVector3D)\n"
"Ctor\n"
"\n"
"QgsPointCloudBlock(a0: QgsPointCloudBlock)");


static pyqt5ClassPluginDef plugin_QgsPointCloudBlock = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudBlock = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudBlock,
        SIP_NULLPTR,
        &plugin_QgsPointCloudBlock,
    },
    {
        sipNameNr_QgsPointCloudBlock,
        {0, 0, 1},
        8, methods_QgsPointCloudBlock,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudBlock,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QgsPointCloudBlock,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudBlock,
    assign_QgsPointCloudBlock,
    SIP_NULLPTR,
    copy_QgsPointCloudBlock,
    release_QgsPointCloudBlock,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QgsPointCloudBlock),
};

#line 23 "auto_generated/pointcloud/qgspointcloudextentrenderer.sip"
#include "qgspointcloudextentrenderer.h"
#line 24380 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 18 "auto_generated/symbology/qgsfillsymbol.sip"
#include "qgsfillsymbol.h"
#line 24384 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 164 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qrect.sip"
#include <qrect.h>
#line 24387 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 24390 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 24 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 24393 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 102 "auto_generated/geometry/qgsgeometry.sip"
#include "qgsgeometry.h"
#line 24396 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 179 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 24399 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 312 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 24402 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 21 "auto_generated/qgsreadwritecontext.sip"
#include "qgsreadwritecontext.h"
#line 24405 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 149 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 24408 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 25 "auto_generated/layertree/qgslayertreemodellegendnode.sip"
#include "qgslayertreemodellegendnode.h"
#include "qgscolorramplegendnode.h"
#line 24412 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "auto_generated/layertree/qgslayertreelayer.sip"
#include "qgslayertreelayer.h"
#line 24415 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 192 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 24418 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "auto_generated/pointcloud/qgspointcloudblock.sip"
#include "qgspointcloudblock.h"
#line 24421 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtGui/qcolor.sip"
#include <qcolor.h>
#line 24424 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 24427 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 24 "auto_generated/textrenderer/qgstextformat.sip"
#include "qgstextformat.h"
#line 24430 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 36 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 24433 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 25 "auto_generated/qgsmapunitscale.sip"
#include "qgsmapunitscale.h"
#line 24436 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qset.sip"
#include <qset.h>
#line 24439 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qmap.sip"
#include <qmap.h>
#line 24442 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qvariant.sip"
#include <qvariant.h>
#line 24445 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


class sipQgsPointCloudExtentRenderer : public ::QgsPointCloudExtentRenderer
{
public:
    sipQgsPointCloudExtentRenderer(::QgsFillSymbol*);
    virtual ~sipQgsPointCloudExtentRenderer();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    static void sipProtect_pointXY(::QgsPointCloudRenderContext&, const char*, int, double&, double&);
    static double sipProtect_pointZ(::QgsPointCloudRenderContext&, const char*, int);
    void sipProtect_drawPoint(double, double, const ::QColor&, ::QgsPointCloudRenderContext&) const;
    void sipProtect_drawPoint(double, double, const ::QColor&, int, ::QgsPointCloudRenderContext&) const;
    void sipProtect_addPointToTriangulation(double, double, double, const ::QColor&, ::QgsPointCloudRenderContext&);
    void sipProtect_copyCommonProperties(::QgsPointCloudRenderer*) const;
    void sipProtect_restoreCommonProperties(const ::QDomElement&, const ::QgsReadWriteContext&);
    void sipProtect_saveCommonProperties(::QDomElement&, const ::QgsReadWriteContext&) const;

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::QString type() const SIP_OVERRIDE;
    ::QgsPointCloudRenderer* clone() const SIP_OVERRIDE;
    void renderBlock(const ::QgsPointCloudBlock*, ::QgsPointCloudRenderContext&) SIP_OVERRIDE;
    bool willRenderPoint(const QMap< ::QString, ::QVariant>&) SIP_OVERRIDE;
    ::QDomElement save(::QDomDocument&, const ::QgsReadWriteContext&) const SIP_OVERRIDE;
    QSet< ::QString> usedAttributes(const ::QgsPointCloudRenderContext&) const SIP_OVERRIDE;
    void startRender(::QgsPointCloudRenderContext&) SIP_OVERRIDE;
    void stopRender(::QgsPointCloudRenderContext&) SIP_OVERRIDE;
    bool legendItemChecked(const ::QString&) SIP_OVERRIDE;
    void checkLegendItem(const ::QString&, bool) SIP_OVERRIDE;
    QList< ::QgsLayerTreeModelLegendNode*> createLegendNodes(::QgsLayerTreeLayer*) SIP_OVERRIDE;
    ::QStringList legendRuleKeys() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQgsPointCloudExtentRenderer(const sipQgsPointCloudExtentRenderer &);
    sipQgsPointCloudExtentRenderer &operator = (const sipQgsPointCloudExtentRenderer &);

    char sipPyMethods[12];
};

sipQgsPointCloudExtentRenderer::sipQgsPointCloudExtentRenderer(::QgsFillSymbol*a0): ::QgsPointCloudExtentRenderer(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsPointCloudExtentRenderer::~sipQgsPointCloudExtentRenderer()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::QString sipQgsPointCloudExtentRenderer::type() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_type);

    if (!sipMeth)
        return ::QgsPointCloudExtentRenderer::type();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsPointCloudRenderer* sipQgsPointCloudExtentRenderer::clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_clone);

    if (!sipMeth)
        return ::QgsPointCloudExtentRenderer::clone();

    extern ::QgsPointCloudRenderer* sipVH__core_739(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_739(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudExtentRenderer::renderBlock(const ::QgsPointCloudBlock*a0, ::QgsPointCloudRenderContext& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_renderBlock);

    if (!sipMeth)
    {
        ::QgsPointCloudExtentRenderer::renderBlock(a0, a1);
        return;
    }

    extern void sipVH__core_740(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsPointCloudBlock*, ::QgsPointCloudRenderContext&);

    sipVH__core_740(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

bool sipQgsPointCloudExtentRenderer::willRenderPoint(const QMap< ::QString, ::QVariant>& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_willRenderPoint);

    if (!sipMeth)
        return ::QgsPointCloudExtentRenderer::willRenderPoint(a0);

    extern bool sipVH__core_741(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const QMap< ::QString, ::QVariant>&);

    return sipVH__core_741(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QDomElement sipQgsPointCloudExtentRenderer::save(::QDomDocument& a0, const ::QgsReadWriteContext& a1) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[4]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_save);

    if (!sipMeth)
        return ::QgsPointCloudExtentRenderer::save(a0, a1);

    extern ::QDomElement sipVH__core_166(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomDocument&, const ::QgsReadWriteContext&);

    return sipVH__core_166(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

QSet< ::QString> sipQgsPointCloudExtentRenderer::usedAttributes(const ::QgsPointCloudRenderContext& a0) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[5]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_usedAttributes);

    if (!sipMeth)
        return ::QgsPointCloudExtentRenderer::usedAttributes(a0);

    extern QSet< ::QString> sipVH__core_742(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsPointCloudRenderContext&);

    return sipVH__core_742(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudExtentRenderer::startRender(::QgsPointCloudRenderContext& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_startRender);

    if (!sipMeth)
    {
        ::QgsPointCloudExtentRenderer::startRender(a0);
        return;
    }

    extern void sipVH__core_743(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsPointCloudRenderContext&);

    sipVH__core_743(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudExtentRenderer::stopRender(::QgsPointCloudRenderContext& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_stopRender);

    if (!sipMeth)
    {
        ::QgsPointCloudExtentRenderer::stopRender(a0);
        return;
    }

    extern void sipVH__core_743(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsPointCloudRenderContext&);

    sipVH__core_743(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQgsPointCloudExtentRenderer::legendItemChecked(const ::QString& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[8], &sipPySelf, SIP_NULLPTR, sipName_legendItemChecked);

    if (!sipMeth)
        return ::QgsPointCloudExtentRenderer::legendItemChecked(a0);

    extern bool sipVH__core_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&);

    return sipVH__core_9(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudExtentRenderer::checkLegendItem(const ::QString& a0, bool a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[9], &sipPySelf, SIP_NULLPTR, sipName_checkLegendItem);

    if (!sipMeth)
    {
        ::QgsPointCloudExtentRenderer::checkLegendItem(a0, a1);
        return;
    }

    extern void sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool);

    sipVH__core_11(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

QList< ::QgsLayerTreeModelLegendNode*> sipQgsPointCloudExtentRenderer::createLegendNodes(::QgsLayerTreeLayer*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[10], &sipPySelf, SIP_NULLPTR, sipName_createLegendNodes);

    if (!sipMeth)
        return ::QgsPointCloudExtentRenderer::createLegendNodes(a0);

    extern QList< ::QgsLayerTreeModelLegendNode*> sipVH__core_141(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsLayerTreeLayer*);

    return sipVH__core_141(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QStringList sipQgsPointCloudExtentRenderer::legendRuleKeys() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[11]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_legendRuleKeys);

    if (!sipMeth)
        return ::QgsPointCloudExtentRenderer::legendRuleKeys();

    extern ::QStringList sipVH__core_20(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_20(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudExtentRenderer::sipProtect_pointXY(::QgsPointCloudRenderContext& a0, const char*a1, int a2, double& a3, double& a4)
{
    ::QgsPointCloudRenderer::pointXY(a0, a1, a2, a3, a4);
}

double sipQgsPointCloudExtentRenderer::sipProtect_pointZ(::QgsPointCloudRenderContext& a0, const char*a1, int a2)
{
    return ::QgsPointCloudRenderer::pointZ(a0, a1, a2);
}

void sipQgsPointCloudExtentRenderer::sipProtect_drawPoint(double a0, double a1, const ::QColor& a2, ::QgsPointCloudRenderContext& a3) const
{
    ::QgsPointCloudRenderer::drawPoint(a0, a1, a2, a3);
}

void sipQgsPointCloudExtentRenderer::sipProtect_drawPoint(double a0, double a1, const ::QColor& a2, int a3, ::QgsPointCloudRenderContext& a4) const
{
    ::QgsPointCloudRenderer::drawPoint(a0, a1, a2, a3, a4);
}

void sipQgsPointCloudExtentRenderer::sipProtect_addPointToTriangulation(double a0, double a1, double a2, const ::QColor& a3, ::QgsPointCloudRenderContext& a4)
{
    ::QgsPointCloudRenderer::addPointToTriangulation(a0, a1, a2, a3, a4);
}

void sipQgsPointCloudExtentRenderer::sipProtect_copyCommonProperties(::QgsPointCloudRenderer*a0) const
{
    ::QgsPointCloudRenderer::copyCommonProperties(a0);
}

void sipQgsPointCloudExtentRenderer::sipProtect_restoreCommonProperties(const ::QDomElement& a0, const ::QgsReadWriteContext& a1)
{
    ::QgsPointCloudRenderer::restoreCommonProperties(a0, a1);
}

void sipQgsPointCloudExtentRenderer::sipProtect_saveCommonProperties(::QDomElement& a0, const ::QgsReadWriteContext& a1) const
{
    ::QgsPointCloudRenderer::saveCommonProperties(a0, a1);
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_pointXY, "pointXY(context: QgsPointCloudRenderContext, ptr: Optional[str], i: int) -> (float, float)\n"
"Retrieves the x and y coordinate for the point at index ``i``.");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_pointXY(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_pointXY(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRenderContext* a0;
        const char* a1;
        PyObject *a1Keep;
        int a2;
        double a3;
        double a4;

        static const char *sipKwdList[] = {
            sipName_context,
            sipName_ptr,
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9AAi", sipType_QgsPointCloudRenderContext, &a0, &a1Keep, &a1, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipQgsPointCloudExtentRenderer::sipProtect_pointXY(*a0, a1, a2, a3, a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            Py_DECREF(a1Keep);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            Py_DECREF(a1Keep);

            return sipBuildResult(0, "(dd)", a3, a4);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_pointXY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_pointZ, "pointZ(context: QgsPointCloudRenderContext, ptr: Optional[str], i: int) -> float\n"
"Retrieves the z value for the point at index ``i``.");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_pointZ(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_pointZ(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRenderContext* a0;
        const char* a1;
        PyObject *a1Keep;
        int a2;

        static const char *sipKwdList[] = {
            sipName_context,
            sipName_ptr,
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9AAi", sipType_QgsPointCloudRenderContext, &a0, &a1Keep, &a1, &a2))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipQgsPointCloudExtentRenderer::sipProtect_pointZ(*a0, a1, a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            Py_DECREF(a1Keep);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            Py_DECREF(a1Keep);

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_pointZ, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_drawPoint, "drawPoint(self, x: float, y: float, color: Union[QColor, Qt.GlobalColor], context: QgsPointCloudRenderContext)\n"
"Draws a point using a ``color`` at the specified ``x`` and ``y`` (in map\n"
"coordinates).\n"
"\n"
"drawPoint(self, x: float, y: float, color: Union[QColor, Qt.GlobalColor], width: int, context: QgsPointCloudRenderContext)\n"
"Draws a point using a ``color`` and painter ``width`` at the specified\n"
"``x`` and ``y`` (in map coordinates).\n"
"\n"
".. versionadded:: 3.36");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_drawPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_drawPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        double a1;
        const ::QColor* a2;
        int a2State = 0;
        ::QgsPointCloudRenderContext* a3;
        const sipQgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_color,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BddJ1J9", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, &a0, &a1, sipType_QColor, &a2, &a2State, sipType_QgsPointCloudRenderContext, &a3))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_drawPoint(a0, a1, *a2, *a3);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        double a0;
        double a1;
        const ::QColor* a2;
        int a2State = 0;
        int a3;
        ::QgsPointCloudRenderContext* a4;
        const sipQgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_color,
            sipName_width,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BddJ1iJ9", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, &a0, &a1, sipType_QColor, &a2, &a2State, &a3, sipType_QgsPointCloudRenderContext, &a4))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_drawPoint(a0, a1, *a2, a3, *a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_drawPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_addPointToTriangulation, "addPointToTriangulation(self, x: float, y: float, z: float, color: Union[QColor, Qt.GlobalColor], context: QgsPointCloudRenderContext)\n"
"Adds a point to the list of points to be triangulated (only used when\n"
":py:func:`~QgsPointCloudRenderer.renderAsTriangles` is enabled)\n"
"\n"
".. versionadded:: 3.36");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_addPointToTriangulation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_addPointToTriangulation(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        double a1;
        double a2;
        const ::QColor* a3;
        int a3State = 0;
        ::QgsPointCloudRenderContext* a4;
        sipQgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_z,
            sipName_color,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BdddJ1J9", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, &a0, &a1, &a2, sipType_QColor, &a3, &a3State, sipType_QgsPointCloudRenderContext, &a4))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_addPointToTriangulation(a0, a1, a2, *a3, *a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QColor *>(a3), sipType_QColor, a3State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QColor *>(a3), sipType_QColor, a3State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_addPointToTriangulation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_copyCommonProperties, "copyCommonProperties(self, destination: Optional[QgsPointCloudRenderer])\n"
"Copies common point cloud properties (such as point size and screen\n"
"error) to the ``destination`` renderer.");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_copyCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_copyCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRenderer* a0;
        const sipQgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_destination,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, sipType_QgsPointCloudRenderer, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_copyCommonProperties(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_copyCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_restoreCommonProperties, "restoreCommonProperties(self, element: QDomElement, context: QgsReadWriteContext)\n"
"Restores common renderer properties (such as point size and screen\n"
"error) from the specified DOM ``element``.\n"
"\n"
".. seealso:: :py:func:`saveCommonProperties`");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_restoreCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_restoreCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;
        sipQgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_restoreCommonProperties(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_restoreCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_saveCommonProperties, "saveCommonProperties(self, element: QDomElement, context: QgsReadWriteContext)\n"
"Saves common renderer properties (such as point size and screen error)\n"
"to the specified DOM ``element``.\n"
"\n"
".. seealso:: :py:func:`restoreCommonProperties`");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_saveCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_saveCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;
        const sipQgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_saveCommonProperties(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_saveCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_type, "type(self) -> str");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_type(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_type(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudExtentRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString((sipSelfWasArg ? sipCpp->::QgsPointCloudExtentRenderer::type() : sipCpp->type()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_type, doc_QgsPointCloudExtentRenderer_type);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_clone, "clone(self) -> Optional[QgsPointCloudRenderer]");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_clone(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudExtentRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp))
        {
            ::QgsPointCloudRenderer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudExtentRenderer::clone() : sipCpp->clone());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsPointCloudRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_clone, doc_QgsPointCloudExtentRenderer_clone);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_renderBlock, "renderBlock(self, block: Optional[QgsPointCloudBlock], context: QgsPointCloudRenderContext)");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_renderBlock(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_renderBlock(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudBlock* a0;
        ::QgsPointCloudRenderContext* a1;
        ::QgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_block,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J9", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, sipType_QgsPointCloudBlock, &a0, sipType_QgsPointCloudRenderContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            (sipSelfWasArg ? sipCpp->::QgsPointCloudExtentRenderer::renderBlock(a0, *a1) : sipCpp->renderBlock(a0, *a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_renderBlock, doc_QgsPointCloudExtentRenderer_renderBlock);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_save, "save(self, doc: QDomDocument, context: QgsReadWriteContext) -> QDomElement");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_save(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_save(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QDomDocument* a0;
        const ::QgsReadWriteContext* a1;
        const ::QgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_doc,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, sipType_QDomDocument, &a0, sipType_QgsReadWriteContext, &a1))
        {
            ::QDomElement*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QDomElement((sipSelfWasArg ? sipCpp->::QgsPointCloudExtentRenderer::save(*a0, *a1) : sipCpp->save(*a0, *a1)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QDomElement, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_save, doc_QgsPointCloudExtentRenderer_save);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_startRender, "startRender(self, context: QgsPointCloudRenderContext)");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_startRender(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_startRender(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QgsPointCloudRenderContext* a0;
        ::QgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, sipType_QgsPointCloudRenderContext, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            (sipSelfWasArg ? sipCpp->::QgsPointCloudExtentRenderer::startRender(*a0) : sipCpp->startRender(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_startRender, doc_QgsPointCloudExtentRenderer_startRender);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_stopRender, "stopRender(self, context: QgsPointCloudRenderContext)");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_stopRender(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_stopRender(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QgsPointCloudRenderContext* a0;
        ::QgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, sipType_QgsPointCloudRenderContext, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            (sipSelfWasArg ? sipCpp->::QgsPointCloudExtentRenderer::stopRender(*a0) : sipCpp->stopRender(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_stopRender, doc_QgsPointCloudExtentRenderer_stopRender);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_createLegendNodes, "createLegendNodes(self, nodeLayer: Optional[QgsLayerTreeLayer]) -> list[QgsLayerTreeModelLegendNode]");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_createLegendNodes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_createLegendNodes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QgsLayerTreeLayer* a0;
        ::QgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_nodeLayer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, sipType_QgsLayerTreeLayer, &a0))
        {
            QList< ::QgsLayerTreeModelLegendNode*>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QList< ::QgsLayerTreeModelLegendNode*>((sipSelfWasArg ? sipCpp->::QgsPointCloudExtentRenderer::createLegendNodes(a0) : sipCpp->createLegendNodes(a0)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QList_0101QgsLayerTreeModelLegendNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_createLegendNodes, doc_QgsPointCloudExtentRenderer_createLegendNodes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_create, "create(element: QDomElement, context: QgsReadWriteContext) -> Optional[QgsPointCloudRenderer]\n"
"Creates an extent renderer from an XML ``element``.");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_create(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9J9", sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            ::QgsPointCloudRenderer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = ::QgsPointCloudExtentRenderer::create(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_create, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_renderExtent, "renderExtent(self, extent: QgsGeometry, context: QgsPointCloudRenderContext)\n"
"Renders a polygon ``extent`` geometry to the specified render\n"
"``context``.");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_renderExtent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_renderExtent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsGeometry* a0;
        ::QgsPointCloudRenderContext* a1;
        ::QgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_extent,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, sipType_QgsGeometry, &a0, sipType_QgsPointCloudRenderContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->renderExtent(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_renderExtent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_defaultFillSymbol, "defaultFillSymbol() -> Optional[QgsFillSymbol]\n"
"Returns a new instance of the default fill symbol to use for showing\n"
"point cloud extents.");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_defaultFillSymbol(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_defaultFillSymbol(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QgsFillSymbol*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = ::QgsPointCloudExtentRenderer::defaultFillSymbol();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsFillSymbol, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_defaultFillSymbol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_fillSymbol, "fillSymbol(self) -> Optional[QgsFillSymbol]\n"
"Returns the symbol used to render the cloud's extent.\n"
"\n"
".. seealso:: :py:func:`setFillSymbol`");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_fillSymbol(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_fillSymbol(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QgsPointCloudExtentRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp))
        {
            ::QgsFillSymbol*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipCpp->fillSymbol();
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsFillSymbol, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_fillSymbol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_setFillSymbol, "setFillSymbol(self, symbol: Optional[QgsFillSymbol])\n"
"Sets the ``symbol`` used to render the cloud's extent.\n"
"\n"
"Ownership of ``symbol`` is transferred to the renderer.\n"
"\n"
".. seealso:: :py:func:`fillSymbol`");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_setFillSymbol(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_setFillSymbol(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsFillSymbol* a0;
        ::QgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_symbol,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, sipType_QgsFillSymbol, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->setFillSymbol(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_setFillSymbol, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer_renderLabel, "renderLabel(self, extent: QRectF, text: Optional[str], context: QgsPointCloudRenderContext)\n"
"Renders a label inside the specified extent rectangle.\n"
"\n"
"The label will be rendered centered horizontally and vertically inside\n"
"``extent``. If the label is too large to fit inside this rectangle, it\n"
"will not be rendered.\n"
"\n"
":param extent: rectangle (in painter coordinates) inside which the label\n"
"               will be rendered\n"
":param text: label text to render\n"
":param context: point cloud rendering context\n"
"\n"
".. versionadded:: 3.42");

extern "C" {static PyObject *meth_QgsPointCloudExtentRenderer_renderLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudExtentRenderer_renderLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QRectF* a0;
        const ::QString* a1;
        int a1State = 0;
        ::QgsPointCloudRenderContext* a2;
        const ::QgsPointCloudExtentRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_extent,
            sipName_text,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1J9", &sipSelf, sipType_QgsPointCloudExtentRenderer, &sipCpp, sipType_QRectF, &a0, sipType_QString, &a1, &a1State, sipType_QgsPointCloudRenderContext, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->renderLabel(*a0, *a1, *a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudExtentRenderer, sipName_renderLabel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_QgsPointCloudExtentRenderer(void *, const sipTypeDef *);}
static void *cast_QgsPointCloudExtentRenderer(void *sipCppV, const sipTypeDef *targetType)
{
    ::QgsPointCloudExtentRenderer *sipCpp = reinterpret_cast< ::QgsPointCloudExtentRenderer *>(sipCppV);

    if (targetType == sipType_QgsPointCloudExtentRenderer)
        return sipCppV;

    if (targetType == sipType_QgsPointCloudRenderer)
        return static_cast< ::QgsPointCloudRenderer *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QgsPointCloudExtentRenderer(void *, int);}
static void release_QgsPointCloudExtentRenderer(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipQgsPointCloudExtentRenderer *>(sipCppV);
    else
        delete reinterpret_cast< ::QgsPointCloudExtentRenderer *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_QgsPointCloudExtentRenderer(Py_ssize_t);}
static void *array_QgsPointCloudExtentRenderer(Py_ssize_t sipNrElem)
{
    return new ::QgsPointCloudExtentRenderer[sipNrElem];
}


extern "C" {static void array_delete_QgsPointCloudExtentRenderer(void *);}
static void array_delete_QgsPointCloudExtentRenderer(void *sipCpp)
{
    delete[] reinterpret_cast< ::QgsPointCloudExtentRenderer *>(sipCpp);
}


extern "C" {static void dealloc_QgsPointCloudExtentRenderer(sipSimpleWrapper *);}
static void dealloc_QgsPointCloudExtentRenderer(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipQgsPointCloudExtentRenderer *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_QgsPointCloudExtentRenderer(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_QgsPointCloudExtentRenderer(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QgsPointCloudExtentRenderer(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipQgsPointCloudExtentRenderer *sipCpp = SIP_NULLPTR;

    {
        ::QgsFillSymbol* a0 = 0;

        static const char *sipKwdList[] = {
            sipName_symbol,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "#|J:", sipSelf, sipType_QgsFillSymbol, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp = new sipQgsPointCloudExtentRenderer(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_QgsPointCloudExtentRenderer[] = {{1809, 255, 1}};


static PyMethodDef methods_QgsPointCloudExtentRenderer[] = {
    {sipName_addPointToTriangulation, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_addPointToTriangulation), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_clone, meth_QgsPointCloudExtentRenderer_clone, METH_VARARGS, doc_QgsPointCloudExtentRenderer_clone},
    {sipName_copyCommonProperties, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_copyCommonProperties), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_create, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_create), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudExtentRenderer_create},
    {sipName_createLegendNodes, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_createLegendNodes), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudExtentRenderer_createLegendNodes},
    {sipName_defaultFillSymbol, meth_QgsPointCloudExtentRenderer_defaultFillSymbol, METH_VARARGS, doc_QgsPointCloudExtentRenderer_defaultFillSymbol},
    {sipName_drawPoint, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_drawPoint), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_fillSymbol, meth_QgsPointCloudExtentRenderer_fillSymbol, METH_VARARGS, doc_QgsPointCloudExtentRenderer_fillSymbol},
    {sipName_pointXY, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_pointXY), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_pointZ, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_pointZ), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_renderBlock, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_renderBlock), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudExtentRenderer_renderBlock},
    {sipName_renderExtent, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_renderExtent), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudExtentRenderer_renderExtent},
    {sipName_renderLabel, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_renderLabel), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudExtentRenderer_renderLabel},
    {sipName_restoreCommonProperties, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_restoreCommonProperties), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_save, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_save), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudExtentRenderer_save},
    {sipName_saveCommonProperties, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_saveCommonProperties), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_setFillSymbol, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_setFillSymbol), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudExtentRenderer_setFillSymbol},
    {sipName_startRender, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_startRender), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudExtentRenderer_startRender},
    {sipName_stopRender, SIP_MLMETH_CAST(meth_QgsPointCloudExtentRenderer_stopRender), METH_VARARGS|METH_KEYWORDS, doc_QgsPointCloudExtentRenderer_stopRender},
    {sipName_type, meth_QgsPointCloudExtentRenderer_type, METH_VARARGS, doc_QgsPointCloudExtentRenderer_type}
};

PyDoc_STRVAR(doc_QgsPointCloudExtentRenderer, "A renderer for 2d visualisation of point clouds which shows the\n"
"dataset's extents using a fill symbol.\n"
"\n"
".. versionadded:: 3.18\n"
"\n"
"QgsPointCloudExtentRenderer(symbol: Optional[QgsFillSymbol] = None)\n"
"Constructor for QgsPointCloudExtentRenderer.\n"
"\n"
"Optionally the ``symbol`` to use for showing the extent can be\n"
"specified. If specified, ownership is transferred to the renderer. If no\n"
"``symbol`` is specified a default one will be created instead.");


static pyqt5ClassPluginDef plugin_QgsPointCloudExtentRenderer = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef__core_QgsPointCloudExtentRenderer = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_QgsPointCloudExtentRenderer,
        SIP_NULLPTR,
        &plugin_QgsPointCloudExtentRenderer,
    },
    {
        sipNameNr_QgsPointCloudExtentRenderer,
        {0, 0, 1},
        20, methods_QgsPointCloudExtentRenderer,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QgsPointCloudExtentRenderer,
    -1,
    -1,
    supers_QgsPointCloudExtentRenderer,
    SIP_NULLPTR,
    init_type_QgsPointCloudExtentRenderer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QgsPointCloudExtentRenderer,
    SIP_NULLPTR,
    array_QgsPointCloudExtentRenderer,
    SIP_NULLPTR,
    release_QgsPointCloudExtentRenderer,
    cast_QgsPointCloudExtentRenderer,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QgsPointCloudExtentRenderer,
    sizeof (::QgsPointCloudExtentRenderer),
};

#line 138 "auto_generated/pointcloud/qgspointcloudclassifiedrenderer.sip"
#include "qgspointcloudclassifiedrenderer.h"
#line 26077 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"

#line 27 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstring.sip"
#include <qstring.h>
#line 26081 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 38 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 26084 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 23 "auto_generated/pointcloud/qgspointcloudclassifiedrenderer.sip"
#include "qgspointcloudclassifiedrenderer.h"
#line 26087 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 179 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 26090 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 312 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 26093 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 21 "auto_generated/qgsreadwritecontext.sip"
#include "qgsreadwritecontext.h"
#line 26096 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 36 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 26099 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 149 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 26102 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 25 "auto_generated/layertree/qgslayertreemodellegendnode.sip"
#include "qgslayertreemodellegendnode.h"
#include "qgscolorramplegendnode.h"
#line 26106 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "auto_generated/layertree/qgslayertreelayer.sip"
#include "qgslayertreelayer.h"
#line 26109 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 28 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qset.sip"
#include <qset.h>
#line 26112 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 24 "auto_generated/pointcloud/qgspointcloudrenderer.sip"
#include "qgspointcloudrenderer.h"
#line 26115 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 192 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtXml/qdom.sip"
#include <qdom.h>
#line 26118 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 24 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtCore/qpycore_qvariantmap.sip"
#include <qvariant.h>
#line 26121 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "auto_generated/pointcloud/qgspointcloudblock.sip"
#include "qgspointcloudblock.h"
#line 26124 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 26 "/usr/lib/python3.13/site-packages/PyQt5/bindings/QtGui/qcolor.sip"
#include <qcolor.h>
#line 26127 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 31 "auto_generated/qgis.sip"
#include "qgis.h"
#line 26130 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 24 "auto_generated/textrenderer/qgstextformat.sip"
#include "qgstextformat.h"
#line 26133 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"
#line 25 "auto_generated/qgsmapunitscale.sip"
#include "qgsmapunitscale.h"
#line 26136 "/build/qgis/src/build/python/core/build/_core/sip_corepart12.cpp"


class sipQgsPointCloudClassifiedRenderer : public ::QgsPointCloudClassifiedRenderer
{
public:
    sipQgsPointCloudClassifiedRenderer(const ::QString&, const ::QgsPointCloudCategoryList&);
    virtual ~sipQgsPointCloudClassifiedRenderer();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    static void sipProtect_pointXY(::QgsPointCloudRenderContext&, const char*, int, double&, double&);
    static double sipProtect_pointZ(::QgsPointCloudRenderContext&, const char*, int);
    void sipProtect_drawPoint(double, double, const ::QColor&, ::QgsPointCloudRenderContext&) const;
    void sipProtect_drawPoint(double, double, const ::QColor&, int, ::QgsPointCloudRenderContext&) const;
    void sipProtect_addPointToTriangulation(double, double, double, const ::QColor&, ::QgsPointCloudRenderContext&);
    void sipProtect_copyCommonProperties(::QgsPointCloudRenderer*) const;
    void sipProtect_restoreCommonProperties(const ::QDomElement&, const ::QgsReadWriteContext&);
    void sipProtect_saveCommonProperties(::QDomElement&, const ::QgsReadWriteContext&) const;

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool willRenderPoint(const ::QVariantMap&) SIP_OVERRIDE;
    ::QString type() const SIP_OVERRIDE;
    ::QgsPointCloudRenderer* clone() const SIP_OVERRIDE;
    void renderBlock(const ::QgsPointCloudBlock*, ::QgsPointCloudRenderContext&) SIP_OVERRIDE;
    ::QDomElement save(::QDomDocument&, const ::QgsReadWriteContext&) const SIP_OVERRIDE;
    QSet< ::QString> usedAttributes(const ::QgsPointCloudRenderContext&) const SIP_OVERRIDE;
    void startRender(::QgsPointCloudRenderContext&) SIP_OVERRIDE;
    void stopRender(::QgsPointCloudRenderContext&) SIP_OVERRIDE;
    bool legendItemChecked(const ::QString&) SIP_OVERRIDE;
    void checkLegendItem(const ::QString&, bool) SIP_OVERRIDE;
    QList< ::QgsLayerTreeModelLegendNode*> createLegendNodes(::QgsLayerTreeLayer*) SIP_OVERRIDE;
    ::QStringList legendRuleKeys() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipQgsPointCloudClassifiedRenderer(const sipQgsPointCloudClassifiedRenderer &);
    sipQgsPointCloudClassifiedRenderer &operator = (const sipQgsPointCloudClassifiedRenderer &);

    char sipPyMethods[12];
};

sipQgsPointCloudClassifiedRenderer::sipQgsPointCloudClassifiedRenderer(const ::QString& a0, const ::QgsPointCloudCategoryList& a1): ::QgsPointCloudClassifiedRenderer(a0, a1), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipQgsPointCloudClassifiedRenderer::~sipQgsPointCloudClassifiedRenderer()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipQgsPointCloudClassifiedRenderer::willRenderPoint(const ::QVariantMap& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_willRenderPoint);

    if (!sipMeth)
        return ::QgsPointCloudClassifiedRenderer::willRenderPoint(a0);

    extern bool sipVH__core_744(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QVariantMap&);

    return sipVH__core_744(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QString sipQgsPointCloudClassifiedRenderer::type() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_type);

    if (!sipMeth)
        return ::QgsPointCloudClassifiedRenderer::type();

    extern ::QString sipVH__core_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_30(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

::QgsPointCloudRenderer* sipQgsPointCloudClassifiedRenderer::clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[2]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_clone);

    if (!sipMeth)
        return ::QgsPointCloudClassifiedRenderer::clone();

    extern ::QgsPointCloudRenderer* sipVH__core_739(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_739(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudClassifiedRenderer::renderBlock(const ::QgsPointCloudBlock*a0, ::QgsPointCloudRenderContext& a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_renderBlock);

    if (!sipMeth)
    {
        ::QgsPointCloudClassifiedRenderer::renderBlock(a0, a1);
        return;
    }

    extern void sipVH__core_740(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsPointCloudBlock*, ::QgsPointCloudRenderContext&);

    sipVH__core_740(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

::QDomElement sipQgsPointCloudClassifiedRenderer::save(::QDomDocument& a0, const ::QgsReadWriteContext& a1) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[4]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_save);

    if (!sipMeth)
        return ::QgsPointCloudClassifiedRenderer::save(a0, a1);

    extern ::QDomElement sipVH__core_166(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QDomDocument&, const ::QgsReadWriteContext&);

    return sipVH__core_166(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

QSet< ::QString> sipQgsPointCloudClassifiedRenderer::usedAttributes(const ::QgsPointCloudRenderContext& a0) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[5]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_usedAttributes);

    if (!sipMeth)
        return ::QgsPointCloudClassifiedRenderer::usedAttributes(a0);

    extern QSet< ::QString> sipVH__core_742(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QgsPointCloudRenderContext&);

    return sipVH__core_742(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudClassifiedRenderer::startRender(::QgsPointCloudRenderContext& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_startRender);

    if (!sipMeth)
    {
        ::QgsPointCloudClassifiedRenderer::startRender(a0);
        return;
    }

    extern void sipVH__core_743(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsPointCloudRenderContext&);

    sipVH__core_743(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudClassifiedRenderer::stopRender(::QgsPointCloudRenderContext& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_stopRender);

    if (!sipMeth)
    {
        ::QgsPointCloudClassifiedRenderer::stopRender(a0);
        return;
    }

    extern void sipVH__core_743(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsPointCloudRenderContext&);

    sipVH__core_743(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

bool sipQgsPointCloudClassifiedRenderer::legendItemChecked(const ::QString& a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[8], &sipPySelf, SIP_NULLPTR, sipName_legendItemChecked);

    if (!sipMeth)
        return ::QgsPointCloudClassifiedRenderer::legendItemChecked(a0);

    extern bool sipVH__core_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&);

    return sipVH__core_9(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

void sipQgsPointCloudClassifiedRenderer::checkLegendItem(const ::QString& a0, bool a1)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[9], &sipPySelf, SIP_NULLPTR, sipName_checkLegendItem);

    if (!sipMeth)
    {
        ::QgsPointCloudClassifiedRenderer::checkLegendItem(a0, a1);
        return;
    }

    extern void sipVH__core_11(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::QString&, bool);

    sipVH__core_11(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0, a1);
}

QList< ::QgsLayerTreeModelLegendNode*> sipQgsPointCloudClassifiedRenderer::createLegendNodes(::QgsLayerTreeLayer*a0)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[10], &sipPySelf, SIP_NULLPTR, sipName_createLegendNodes);

    if (!sipMeth)
        return ::QgsPointCloudClassifiedRenderer::createLegendNodes(a0);

    extern QList< ::QgsLayerTreeModelLegendNode*> sipVH__core_141(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::QgsLayerTreeLayer*);

    return sipVH__core_141(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth, a0);
}

::QStringList sipQgsPointCloudClassifiedRenderer::legendRuleKeys() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[11]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_legendRuleKeys);

    if (!sipMeth)
        return ::QgsPointCloudClassifiedRenderer::legendRuleKeys();

    extern ::QStringList sipVH__core_20(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_20(sipGILState, sipImportedVirtErrorHandlers__core_QtCore[0].iveh_handler, sipPySelf, sipMeth);
}

void sipQgsPointCloudClassifiedRenderer::sipProtect_pointXY(::QgsPointCloudRenderContext& a0, const char*a1, int a2, double& a3, double& a4)
{
    ::QgsPointCloudRenderer::pointXY(a0, a1, a2, a3, a4);
}

double sipQgsPointCloudClassifiedRenderer::sipProtect_pointZ(::QgsPointCloudRenderContext& a0, const char*a1, int a2)
{
    return ::QgsPointCloudRenderer::pointZ(a0, a1, a2);
}

void sipQgsPointCloudClassifiedRenderer::sipProtect_drawPoint(double a0, double a1, const ::QColor& a2, ::QgsPointCloudRenderContext& a3) const
{
    ::QgsPointCloudRenderer::drawPoint(a0, a1, a2, a3);
}

void sipQgsPointCloudClassifiedRenderer::sipProtect_drawPoint(double a0, double a1, const ::QColor& a2, int a3, ::QgsPointCloudRenderContext& a4) const
{
    ::QgsPointCloudRenderer::drawPoint(a0, a1, a2, a3, a4);
}

void sipQgsPointCloudClassifiedRenderer::sipProtect_addPointToTriangulation(double a0, double a1, double a2, const ::QColor& a3, ::QgsPointCloudRenderContext& a4)
{
    ::QgsPointCloudRenderer::addPointToTriangulation(a0, a1, a2, a3, a4);
}

void sipQgsPointCloudClassifiedRenderer::sipProtect_copyCommonProperties(::QgsPointCloudRenderer*a0) const
{
    ::QgsPointCloudRenderer::copyCommonProperties(a0);
}

void sipQgsPointCloudClassifiedRenderer::sipProtect_restoreCommonProperties(const ::QDomElement& a0, const ::QgsReadWriteContext& a1)
{
    ::QgsPointCloudRenderer::restoreCommonProperties(a0, a1);
}

void sipQgsPointCloudClassifiedRenderer::sipProtect_saveCommonProperties(::QDomElement& a0, const ::QgsReadWriteContext& a1) const
{
    ::QgsPointCloudRenderer::saveCommonProperties(a0, a1);
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_pointXY, "pointXY(context: QgsPointCloudRenderContext, ptr: Optional[str], i: int) -> (float, float)\n"
"Retrieves the x and y coordinate for the point at index ``i``.");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_pointXY(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_pointXY(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRenderContext* a0;
        const char* a1;
        PyObject *a1Keep;
        int a2;
        double a3;
        double a4;

        static const char *sipKwdList[] = {
            sipName_context,
            sipName_ptr,
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9AAi", sipType_QgsPointCloudRenderContext, &a0, &a1Keep, &a1, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipQgsPointCloudClassifiedRenderer::sipProtect_pointXY(*a0, a1, a2, a3, a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            Py_DECREF(a1Keep);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            Py_DECREF(a1Keep);

            return sipBuildResult(0, "(dd)", a3, a4);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_pointXY, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_pointZ, "pointZ(context: QgsPointCloudRenderContext, ptr: Optional[str], i: int) -> float\n"
"Retrieves the z value for the point at index ``i``.");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_pointZ(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_pointZ(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRenderContext* a0;
        const char* a1;
        PyObject *a1Keep;
        int a2;

        static const char *sipKwdList[] = {
            sipName_context,
            sipName_ptr,
            sipName_i,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9AAi", sipType_QgsPointCloudRenderContext, &a0, &a1Keep, &a1, &a2))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = sipQgsPointCloudClassifiedRenderer::sipProtect_pointZ(*a0, a1, a2);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            Py_DECREF(a1Keep);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            Py_DECREF(a1Keep);

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_pointZ, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_drawPoint, "drawPoint(self, x: float, y: float, color: Union[QColor, Qt.GlobalColor], context: QgsPointCloudRenderContext)\n"
"Draws a point using a ``color`` at the specified ``x`` and ``y`` (in map\n"
"coordinates).\n"
"\n"
"drawPoint(self, x: float, y: float, color: Union[QColor, Qt.GlobalColor], width: int, context: QgsPointCloudRenderContext)\n"
"Draws a point using a ``color`` and painter ``width`` at the specified\n"
"``x`` and ``y`` (in map coordinates).\n"
"\n"
".. versionadded:: 3.36");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_drawPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_drawPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        double a1;
        const ::QColor* a2;
        int a2State = 0;
        ::QgsPointCloudRenderContext* a3;
        const sipQgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_color,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BddJ1J9", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, &a0, &a1, sipType_QColor, &a2, &a2State, sipType_QgsPointCloudRenderContext, &a3))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_drawPoint(a0, a1, *a2, *a3);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        double a0;
        double a1;
        const ::QColor* a2;
        int a2State = 0;
        int a3;
        ::QgsPointCloudRenderContext* a4;
        const sipQgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_color,
            sipName_width,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BddJ1iJ9", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, &a0, &a1, sipType_QColor, &a2, &a2State, &a3, sipType_QgsPointCloudRenderContext, &a4))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_drawPoint(a0, a1, *a2, a3, *a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QColor *>(a2), sipType_QColor, a2State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_drawPoint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_addPointToTriangulation, "addPointToTriangulation(self, x: float, y: float, z: float, color: Union[QColor, Qt.GlobalColor], context: QgsPointCloudRenderContext)\n"
"Adds a point to the list of points to be triangulated (only used when\n"
":py:func:`~QgsPointCloudRenderer.renderAsTriangles` is enabled)\n"
"\n"
".. versionadded:: 3.36");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_addPointToTriangulation(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_addPointToTriangulation(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
        double a1;
        double a2;
        const ::QColor* a3;
        int a3State = 0;
        ::QgsPointCloudRenderContext* a4;
        sipQgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_z,
            sipName_color,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BdddJ1J9", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, &a0, &a1, &a2, sipType_QColor, &a3, &a3State, sipType_QgsPointCloudRenderContext, &a4))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_addPointToTriangulation(a0, a1, a2, *a3, *a4);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QColor *>(a3), sipType_QColor, a3State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QColor *>(a3), sipType_QColor, a3State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_addPointToTriangulation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_copyCommonProperties, "copyCommonProperties(self, destination: Optional[QgsPointCloudRenderer])\n"
"Copies common point cloud properties (such as point size and screen\n"
"error) to the ``destination`` renderer.");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_copyCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_copyCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QgsPointCloudRenderer* a0;
        const sipQgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_destination,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, sipType_QgsPointCloudRenderer, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_copyCommonProperties(a0);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_copyCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_restoreCommonProperties, "restoreCommonProperties(self, element: QDomElement, context: QgsReadWriteContext)\n"
"Restores common renderer properties (such as point size and screen\n"
"error) from the specified DOM ``element``.\n"
"\n"
".. seealso:: :py:func:`saveCommonProperties`");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_restoreCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_restoreCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;
        sipQgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_restoreCommonProperties(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_restoreCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_saveCommonProperties, "saveCommonProperties(self, element: QDomElement, context: QgsReadWriteContext)\n"
"Saves common renderer properties (such as point size and screen error)\n"
"to the specified DOM ``element``.\n"
"\n"
".. seealso:: :py:func:`restoreCommonProperties`");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_saveCommonProperties(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_saveCommonProperties(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;
        const sipQgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipCpp->sipProtect_saveCommonProperties(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_saveCommonProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_type, "type(self) -> str");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_type(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_type(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudClassifiedRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp))
        {
            ::QString*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QString((sipSelfWasArg ? sipCpp->::QgsPointCloudClassifiedRenderer::type() : sipCpp->type()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_type, doc_QgsPointCloudClassifiedRenderer_type);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_clone, "clone(self) -> Optional[QgsPointCloudRenderer]");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_clone(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudClassifiedRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp))
        {
            ::QgsPointCloudRenderer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudClassifiedRenderer::clone() : sipCpp->clone());
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromType(sipRes, sipType_QgsPointCloudRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_clone, doc_QgsPointCloudClassifiedRenderer_clone);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_renderBlock, "renderBlock(self, block: Optional[QgsPointCloudBlock], context: QgsPointCloudRenderContext)");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_renderBlock(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_renderBlock(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudBlock* a0;
        ::QgsPointCloudRenderContext* a1;
        ::QgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_block,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J9", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, sipType_QgsPointCloudBlock, &a0, sipType_QgsPointCloudRenderContext, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            (sipSelfWasArg ? sipCpp->::QgsPointCloudClassifiedRenderer::renderBlock(a0, *a1) : sipCpp->renderBlock(a0, *a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_renderBlock, doc_QgsPointCloudClassifiedRenderer_renderBlock);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_willRenderPoint, "willRenderPoint(self, pointAttributes: dict[str, Any]) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_willRenderPoint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_willRenderPoint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QVariantMap* a0;
        int a0State = 0;
        ::QgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pointAttributes,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, sipType_QVariantMap, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudClassifiedRenderer::willRenderPoint(*a0) : sipCpp->willRenderPoint(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QVariantMap *>(a0), sipType_QVariantMap, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QVariantMap *>(a0), sipType_QVariantMap, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_willRenderPoint, doc_QgsPointCloudClassifiedRenderer_willRenderPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_save, "save(self, doc: QDomDocument, context: QgsReadWriteContext) -> QDomElement");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_save(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_save(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QDomDocument* a0;
        const ::QgsReadWriteContext* a1;
        const ::QgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_doc,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J9", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, sipType_QDomDocument, &a0, sipType_QgsReadWriteContext, &a1))
        {
            ::QDomElement*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QDomElement((sipSelfWasArg ? sipCpp->::QgsPointCloudClassifiedRenderer::save(*a0, *a1) : sipCpp->save(*a0, *a1)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QDomElement, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_save, doc_QgsPointCloudClassifiedRenderer_save);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_usedAttributes, "usedAttributes(self, context: QgsPointCloudRenderContext) -> set[str]");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_usedAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_usedAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudRenderContext* a0;
        const ::QgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, sipType_QgsPointCloudRenderContext, &a0))
        {
            QSet< ::QString>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QSet< ::QString>((sipSelfWasArg ? sipCpp->::QgsPointCloudClassifiedRenderer::usedAttributes(*a0) : sipCpp->usedAttributes(*a0)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QSet_0100QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_usedAttributes, doc_QgsPointCloudClassifiedRenderer_usedAttributes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_createLegendNodes, "createLegendNodes(self, nodeLayer: Optional[QgsLayerTreeLayer]) -> list[QgsLayerTreeModelLegendNode]");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_createLegendNodes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_createLegendNodes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::QgsLayerTreeLayer* a0;
        ::QgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_nodeLayer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, sipType_QgsLayerTreeLayer, &a0))
        {
            QList< ::QgsLayerTreeModelLegendNode*>*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new QList< ::QgsLayerTreeModelLegendNode*>((sipSelfWasArg ? sipCpp->::QgsPointCloudClassifiedRenderer::createLegendNodes(a0) : sipCpp->createLegendNodes(a0)));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QList_0101QgsLayerTreeModelLegendNode, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_createLegendNodes, doc_QgsPointCloudClassifiedRenderer_createLegendNodes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_legendRuleKeys, "legendRuleKeys(self) -> list[str]");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_legendRuleKeys(PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_legendRuleKeys(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QgsPointCloudClassifiedRenderer *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp))
        {
            ::QStringList*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = new ::QStringList((sipSelfWasArg ? sipCpp->::QgsPointCloudClassifiedRenderer::legendRuleKeys() : sipCpp->legendRuleKeys()));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_legendRuleKeys, doc_QgsPointCloudClassifiedRenderer_legendRuleKeys);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_legendItemChecked, "legendItemChecked(self, key: Optional[str]) -> bool");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_legendItemChecked(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_legendItemChecked(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QString* a0;
        int a0State = 0;
        ::QgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = (sipSelfWasArg ? sipCpp->::QgsPointCloudClassifiedRenderer::legendItemChecked(*a0) : sipCpp->legendItemChecked(*a0));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_legendItemChecked, doc_QgsPointCloudClassifiedRenderer_legendItemChecked);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_checkLegendItem, "checkLegendItem(self, key: Optional[str], state: bool = True)");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_checkLegendItem(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_checkLegendItem(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::QString* a0;
        int a0State = 0;
        bool a1 = 1;
        ::QgsPointCloudClassifiedRenderer *sipCpp;

        static const char *sipKwdList[] = {
            sipName_key,
            sipName_state,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|b", &sipSelf, sipType_QgsPointCloudClassifiedRenderer, &sipCpp, sipType_QString, &a0, &a0State, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            try
            {
            (sipSelfWasArg ? sipCpp->::QgsPointCloudClassifiedRenderer::checkLegendItem(*a0, a1) : sipCpp->checkLegendItem(*a0, a1));
            }
            catch (...)
            {
                Py_BLOCK_THREADS

            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_checkLegendItem, doc_QgsPointCloudClassifiedRenderer_checkLegendItem);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QgsPointCloudClassifiedRenderer_create, "create(element: QDomElement, context: QgsReadWriteContext) -> Optional[QgsPointCloudRenderer]\n"
"Creates an RGB renderer from an XML ``element``.");

extern "C" {static PyObject *meth_QgsPointCloudClassifiedRenderer_create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QgsPointCloudClassifiedRenderer_create(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDomElement* a0;
        const ::QgsReadWriteContext* a1;

        static const char *sipKwdList[] = {
            sipName_element,
            sipName_context,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J9J9", sipType_QDomElement, &a0, sipType_QgsReadWriteContext, &a1))
        {
            ::QgsPointCloudRenderer*sipRes;

            Py_BEGIN_ALLOW_THREADS
            try
            {
            sipRes = ::QgsPointCloudClassifiedRenderer::create(*a0, *a1);
            }
            catch (...)
            {
                Py_BLOCK_THREADS

                void *sipExcState = SIP_NULLPTR;
                sipExceptionHandler sipExcHandler;
                std::exception_ptr sipExcPtr = std::current_exception();

                while ((sipExcHandler = sipNextExceptionHandler(&sipExcState)) != SIP_NULLPTR)
                    if (sipExcHandler(sipExcPtr))
                        return SIP_NULLPTR;

                sipRaiseUnknownException();
                return SIP_NULLPTR;
            }
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes, sipType_QgsPointCloudRenderer, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QgsPointCloudClassifiedRenderer, sipName_create, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STR