const char jit_v_lua[] =
"----------------------------------------------------------------------------\n"
"-- Verbose mode of the LuaJIT compiler.\n"
"--\n"
"-- Copyright (C) 2005-2017 Mike Pall. All rights reserved.\n"
"-- Released under the MIT license. See Copyright Notice in luajit.h\n"
"----------------------------------------------------------------------------\n"
"--\n"
"-- This module shows verbose information about the progress of the\n"
"-- JIT compiler. It prints one line for each generated trace. This module\n"
"-- is useful to see which code has been compiled or where the compiler\n"
"-- punts and falls back to the interpreter.\n"
"--\n"
"-- Example usage:\n"
"--\n"
"--   luajit -jv -e \"for i=1,1000 do for j=1,1000 do end end\"\n"
"--   luajit -jv=myapp.out myapp.lua\n"
"--\n"
"-- Default output is to stderr. To redirect the output to a file, pass a\n"
"-- filename as an argument (use '-' for stdout) or set the environment\n"
"-- variable LUAJIT_VERBOSEFILE. The file is overwritten every time the\n"
"-- module is started.\n"
"--\n"
"-- The output from the first example should look like this:\n"
"--\n"
"-- [TRACE   1 (command line):1 loop]\n"
"-- [TRACE   2 (1/3) (command line):1 -> 1]\n"
"--\n"
"-- The first number in each line is the internal trace number. Next are\n"
"-- the file name ('(command line)') and the line number (':1') where the\n"
"-- trace has started. Side traces also show the parent trace number and\n"
"-- the exit number where they are attached to in parentheses ('(1/3)').\n"
"-- An arrow at the end shows where the trace links to ('-> 1'), unless\n"
"-- it loops to itself.\n"
"--\n"
"-- In this case the inner loop gets hot and is traced first, generating\n"
"-- a root trace. Then the last exit from the 1st trace gets hot, too,\n"
"-- and triggers generation of the 2nd trace. The side trace follows the\n"
"-- path along the outer loop and *around* the inner loop, back to its\n"
"-- start, and then links to the 1st trace. Yes, this may seem unusual,\n"
"-- if you know how traditional compilers work. Trace compilers are full\n"
"-- of surprises like this -- have fun! :-)\n"
"--\n"
"-- Aborted traces are shown like this:\n"
"--\n"
"-- [TRACE --- foo.lua:44 -- leaving loop in root trace at foo:lua:50]\n"
"--\n"
"-- Don't worry -- trace aborts are quite common, even in programs which\n"
"-- can be fully compiled. The compiler may retry several times until it\n"
"-- finds a suitable trace.\n"
"--\n"
"-- Of course this doesn't work with features that are not-yet-implemented\n"
"-- (NYI error messages). The VM simply falls back to the interpreter. This\n"
"-- may not matter at all if the particular trace is not very high up in\n"
"-- the CPU usage profile. Oh, and the interpreter is quite fast, too.\n"
"--\n"
"-- Also check out the -jdump module, which prints all the gory details.\n"
"--\n"
"------------------------------------------------------------------------------\n"
"\n"
"-- Cache some library functions and objects.\n"
"local jit = require(\"jit\")\n"
"assert(jit.version_num == 20100, \"LuaJIT core/library version mismatch\")\n"
"local jutil = require(\"jit.util\")\n"
"local vmdef = require(\"jit.vmdef\")\n"
"local funcinfo, traceinfo = jutil.funcinfo, jutil.traceinfo\n"
"local type, sub, format = type, string.sub, string.format\n"
"local stdout, stderr = io.stdout, io.stderr\n"
"\n"
"-- Active flag and output file handle.\n"
"local active, out\n"
"\n"
"------------------------------------------------------------------------------\n"
"\n"
"local startloc, startex\n"
"\n"
"local function fmtfunc(func, pc)\n"
"  local fi = funcinfo(func, pc)\n"
"  if fi.loc then\n"
"    return fi.loc\n"
"  elseif fi.ffid then\n"
"    return vmdef.ffnames[fi.ffid]\n"
"  elseif fi.addr then\n"
"    return format(\"C:%x\", fi.addr)\n"
"  else\n"
"    return \"(\?)\"\n"
"  end\n"
"end\n"
"\n"
"-- Format trace error message.\n"
"local function fmterr(err, info)\n"
"  if type(err) == \"number\" then\n"
"    if type(info) == \"function\" then info = fmtfunc(info) end\n"
"    local fmt = vmdef.traceerr[err]\n"
"    if fmt == \"NYI: bytecode %s\" then\n"
"      local oidx = 6 * info\n"
"      info = sub(vmdef.bcnames, oidx+1, oidx+6)\n"
"    end\n"
"    err = format(fmt, info)\n"
"  end\n"
"  return err\n"
"end\n"
"\n"
"-- Dump trace states.\n"
"local function dump_trace(what, tr, func, pc, otr, oex)\n"
"  if what == \"start\" then\n"
"    startloc = fmtfunc(func, pc)\n"
"    startex = otr and \"(\"..otr..\"/\"..(oex == -1 and \"stitch\" or oex)..\") \" or \"\"\n"
"  else\n"
"    if what == \"abort\" then\n"
"      local loc = fmtfunc(func, pc)\n"
"      if loc ~= startloc then\n"
"\tout:write(format(\"[TRACE --- %s%s -- %s at %s]\\n\",\n"
"\t  startex, startloc, fmterr(otr, oex), loc))\n"
"      else\n"
"\tout:write(format(\"[TRACE --- %s%s -- %s]\\n\",\n"
"\t  startex, startloc, fmterr(otr, oex)))\n"
"      end\n"
"    elseif what == \"stop\" then\n"
"      local info = traceinfo(tr)\n"
"      local link, ltype = info.link, info.linktype\n"
"      if ltype == \"interpreter\" then\n"
"\tout:write(format(\"[TRACE %3s %s%s -- fallback to interpreter]\\n\",\n"
"\t  tr, startex, startloc))\n"
"      elseif ltype == \"stitch\" then\n"
"\tout:write(format(\"[TRACE %3s %s%s %s %s]\\n\",\n"
"\t  tr, startex, startloc, ltype, fmtfunc(func, pc)))\n"
"      elseif link == tr or link == 0 then\n"
"\tout:write(format(\"[TRACE %3s %s%s %s]\\n\",\n"
"\t  tr, startex, startloc, ltype))\n"
"      elseif ltype == \"root\" then\n"
"\tout:write(format(\"[TRACE %3s %s%s -> %d]\\n\",\n"
"\t  tr, startex, startloc, link))\n"
"      else\n"
"\tout:write(format(\"[TRACE %3s %s%s -> %d %s]\\n\",\n"
"\t  tr, startex, startloc, link, ltype))\n"
"      end\n"
"    else\n"
"      out:write(format(\"[TRACE %s]\\n\", what))\n"
"    end\n"
"    out:flush()\n"
"  end\n"
"end\n"
"\n"
"------------------------------------------------------------------------------\n"
"\n"
"-- Detach dump handlers.\n"
"local function dumpoff()\n"
"  if active then\n"
"    active = false\n"
"    jit.attach(dump_trace)\n"
"    if out and out ~= stdout and out ~= stderr then out:close() end\n"
"    out = nil\n"
"  end\n"
"end\n"
"\n"
"-- Open the output file and attach dump handlers.\n"
"local function dumpon(outfile)\n"
"  if active then dumpoff() end\n"
"  if not outfile then outfile = os.getenv(\"LUAJIT_VERBOSEFILE\") end\n"
"  if outfile then\n"
"    out = outfile == \"-\" and stdout or assert(io.open(outfile, \"w\"))\n"
"  else\n"
"    out = stderr\n"
"  end\n"
"  jit.attach(dump_trace, \"trace\")\n"
"  active = true\n"
"end\n"
"\n"
"-- Public module functions.\n"
"return {\n"
"  on = dumpon,\n"
"  off = dumpoff,\n"
"  start = dumpon -- For -j command line option.\n"
"}\n"
"\n"
""
;
