/* This file is generated by vkr_device_object.py. */

#ifndef VKR_ACCELERATION_STRUCTURE_GEN_H
#define VKR_ACCELERATION_STRUCTURE_GEN_H

#include "vkr_common.h"

#include "venus-protocol/vn_protocol_renderer_acceleration_structure.h"

#include "vkr_context.h"
#include "vkr_device.h"

/* create a driver VkAccelerationStructureKHR and update the vkr_acceleration_structure */
static inline VkResult
vkr_acceleration_structure_create_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkCreateAccelerationStructureKHR *args,
   struct vkr_acceleration_structure *obj)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkCreateAccelerationStructureKHR_args_handle(args);
   args->ret = vk->CreateAccelerationStructureKHR(args->device, args->pCreateInfo, NULL,
      &obj->base.handle.acceleration_structure);
   return args->ret;
}

/* create a vkr_acceleration_structure */
static inline struct vkr_acceleration_structure *
vkr_acceleration_structure_create(
   struct vkr_context *ctx,
   struct vn_command_vkCreateAccelerationStructureKHR *args)
{
   struct vkr_acceleration_structure *obj = vkr_context_alloc_object(ctx, sizeof(*obj),
      VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR, args->pAccelerationStructure);
   if (!obj) {
      args->ret = VK_ERROR_OUT_OF_HOST_MEMORY;
      return NULL;
   }

   /* handles in args are replaced */
   if (vkr_acceleration_structure_create_driver_handle(ctx, args, obj) != VK_SUCCESS) {
      free(obj);
      return NULL;
   }

   return obj;
}

/* create a vkr_acceleration_structure and add it to the vkr_device */
static inline struct vkr_acceleration_structure *
vkr_acceleration_structure_create_and_add(
   struct vkr_context *ctx,
   struct vn_command_vkCreateAccelerationStructureKHR *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);

   struct vkr_acceleration_structure *obj = vkr_acceleration_structure_create(ctx, args);
   if (!obj)
      return NULL;

   vkr_device_add_object(ctx, dev, &obj->base);
   return obj;
}

/* destroy a driver VkAccelerationStructureKHR */
static inline void
vkr_acceleration_structure_destroy_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkDestroyAccelerationStructureKHR *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkDestroyAccelerationStructureKHR_args_handle(args);
   vk->DestroyAccelerationStructureKHR(args->device, args->accelerationStructure, NULL);
}

/* remove a vkr_acceleration_structure from the device and destroy it */
static inline void
vkr_acceleration_structure_destroy_and_remove(
   struct vkr_context *ctx,
   struct vn_command_vkDestroyAccelerationStructureKHR *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vkr_acceleration_structure *obj = vkr_acceleration_structure_from_handle(args->accelerationStructure);
   if (!obj)
      return;

   vkr_acceleration_structure_destroy_driver_handle(ctx, args);

   vkr_device_remove_object(ctx, dev, &obj->base);
}

#endif /* VKR_ACCELERATION_STRUCTURE_GEN_H */
