// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef COMPACTSILRESTRICTIONATTRIBUTES_H
#define COMPACTSILRESTRICTIONATTRIBUTES_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: CompactSILRestrictionAttributes
//
// Purpose:
//    The class contains attributes for a compacted SIL restrictions.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API CompactSILRestrictionAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    CompactSILRestrictionAttributes();
    CompactSILRestrictionAttributes(const CompactSILRestrictionAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    CompactSILRestrictionAttributes(private_tmfs_t tmfs);
    CompactSILRestrictionAttributes(const CompactSILRestrictionAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~CompactSILRestrictionAttributes();

    virtual CompactSILRestrictionAttributes& operator = (const CompactSILRestrictionAttributes &obj);
    virtual bool operator == (const CompactSILRestrictionAttributes &obj) const;
    virtual bool operator != (const CompactSILRestrictionAttributes &obj) const;
private:
    void Init();
    void Copy(const CompactSILRestrictionAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectUseSet();
    void SelectTopSet();

    // Property setting methods
    void SetUseSet(const unsignedCharVector &useSet_);
    void SetTopSet(const std::string &topSet_);
    void SetTopSetIsAllOn(bool topSetIsAllOn_);

    // Property getting methods
    const unsignedCharVector &GetUseSet() const;
          unsignedCharVector &GetUseSet();
    const std::string        &GetTopSet() const;
          std::string        &GetTopSet();
    bool                     GetTopSetIsAllOn() const;

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_useSet = 0,
        ID_topSet,
        ID_topSetIsAllOn,
        ID__LAST
    };

private:
    unsignedCharVector useSet;
    std::string        topSet;
    bool               topSetIsAllOn;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define COMPACTSILRESTRICTIONATTRIBUTES_TMFS "u*sb"

#endif
