#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkContourValues_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkErrorCode_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExprTkFunctionParser_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFunctionParser_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHeap_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPolygonBuilder_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkResourceFileLocator_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkCommonMiscCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkContourValues_Init(csi);
  vtkErrorCode_Init(csi);
  vtkExprTkFunctionParser_Init(csi);
  vtkFunctionParser_Init(csi);
  vtkHeap_Init(csi);
  vtkPolygonBuilder_Init(csi);
  vtkResourceFileLocator_Init(csi);
}
