// python wrapper for vtkPVClipDataSet
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVClipDataSet.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVClipDataSet(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVClipDataSet_ClassNew(); }


static PyObject *
PyvtkPVClipDataSet_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVClipDataSet::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClipDataSet *op = static_cast<vtkPVClipDataSet *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVClipDataSet::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVClipDataSet *tempr = vtkPVClipDataSet::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClipDataSet *op = static_cast<vtkPVClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVClipDataSet *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVClipDataSet::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVClipDataSet::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClipDataSet *op = static_cast<vtkPVClipDataSet *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVClipDataSet::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_SetUseAMRDualClipForAMR(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseAMRDualClipForAMR");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClipDataSet *op = static_cast<vtkPVClipDataSet *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseAMRDualClipForAMR(temp0);
    }
    else
    {
      op->vtkPVClipDataSet::SetUseAMRDualClipForAMR(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_GetUseAMRDualClipForAMR(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseAMRDualClipForAMR");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClipDataSet *op = static_cast<vtkPVClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseAMRDualClipForAMR() :
      op->vtkPVClipDataSet::GetUseAMRDualClipForAMR());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_UseAMRDualClipForAMROn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseAMRDualClipForAMROn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClipDataSet *op = static_cast<vtkPVClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseAMRDualClipForAMROn();
    }
    else
    {
      op->vtkPVClipDataSet::UseAMRDualClipForAMROn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_UseAMRDualClipForAMROff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UseAMRDualClipForAMROff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClipDataSet *op = static_cast<vtkPVClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UseAMRDualClipForAMROff();
    }
    else
    {
      op->vtkPVClipDataSet::UseAMRDualClipForAMROff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_SetExactBoxClip(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExactBoxClip");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClipDataSet *op = static_cast<vtkPVClipDataSet *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExactBoxClip(temp0);
    }
    else
    {
      op->vtkPVClipDataSet::SetExactBoxClip(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_GetExactBoxClip(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExactBoxClip");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClipDataSet *op = static_cast<vtkPVClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExactBoxClip() :
      op->vtkPVClipDataSet::GetExactBoxClip());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_ExactBoxClipOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExactBoxClipOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClipDataSet *op = static_cast<vtkPVClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExactBoxClipOn();
    }
    else
    {
      op->vtkPVClipDataSet::ExactBoxClipOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVClipDataSet_ExactBoxClipOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExactBoxClipOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVClipDataSet *op = static_cast<vtkPVClipDataSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExactBoxClipOff();
    }
    else
    {
      op->vtkPVClipDataSet::ExactBoxClipOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVClipDataSet_Methods[] = {
  {"IsTypeOf", PyvtkPVClipDataSet_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVClipDataSet_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVClipDataSet_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVClipDataSet\nC++: static vtkPVClipDataSet *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVClipDataSet_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVClipDataSet\nC++: vtkPVClipDataSet *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVClipDataSet_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVClipDataSet_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetUseAMRDualClipForAMR", PyvtkPVClipDataSet_SetUseAMRDualClipForAMR, METH_VARARGS,
   "SetUseAMRDualClipForAMR(self, _arg:bool) -> None\nC++: virtual void SetUseAMRDualClipForAMR(bool _arg)\n\nThis filter uses vtkAMRDualClip for clipping AMR datasets. To\ndisable that behavior, turn this flag off.\n"},
  {"GetUseAMRDualClipForAMR", PyvtkPVClipDataSet_GetUseAMRDualClipForAMR, METH_VARARGS,
   "GetUseAMRDualClipForAMR(self) -> bool\nC++: virtual bool GetUseAMRDualClipForAMR()\n\n"},
  {"UseAMRDualClipForAMROn", PyvtkPVClipDataSet_UseAMRDualClipForAMROn, METH_VARARGS,
   "UseAMRDualClipForAMROn(self) -> None\nC++: virtual void UseAMRDualClipForAMROn()\n\n"},
  {"UseAMRDualClipForAMROff", PyvtkPVClipDataSet_UseAMRDualClipForAMROff, METH_VARARGS,
   "UseAMRDualClipForAMROff(self) -> None\nC++: virtual void UseAMRDualClipForAMROff()\n\n"},
  {"SetExactBoxClip", PyvtkPVClipDataSet_SetExactBoxClip, METH_VARARGS,
   "SetExactBoxClip(self, _arg:bool) -> None\nC++: virtual void SetExactBoxClip(bool _arg)\n\nFor a vtkPVBlox implicit function we can do an exact clip of the\nexterior portion of the box.\n"},
  {"GetExactBoxClip", PyvtkPVClipDataSet_GetExactBoxClip, METH_VARARGS,
   "GetExactBoxClip(self) -> bool\nC++: virtual bool GetExactBoxClip()\n\n"},
  {"ExactBoxClipOn", PyvtkPVClipDataSet_ExactBoxClipOn, METH_VARARGS,
   "ExactBoxClipOn(self) -> None\nC++: virtual void ExactBoxClipOn()\n\n"},
  {"ExactBoxClipOff", PyvtkPVClipDataSet_ExactBoxClipOff, METH_VARARGS,
   "ExactBoxClipOff(self) -> None\nC++: virtual void ExactBoxClipOff()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVClipDataSet_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("use_amr_dual_clip_for_amr"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVClipDataSet_GetUseAMRDualClipForAMR(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVClipDataSet_SetUseAMRDualClipForAMR(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVClipDataSet_SetUseAMRDualClipForAMR(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseAMRDualClipForAMR/SetUseAMRDualClipForAMR\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exact_box_clip"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVClipDataSet_GetExactBoxClip(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVClipDataSet_SetExactBoxClip(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVClipDataSet_SetExactBoxClip(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExactBoxClip/SetExactBoxClip\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVClipDataSet_Doc =
  "vtkPVClipDataSet - Clip filter\n\n"
  "Superclass: vtkTableBasedClipDataSet\n\n"
  "This is a subclass of vtkTableBasedClipDataSet that allows selection\n"
  "of input scalars.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVClipDataSet_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkPVClipDataSet", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVClipDataSet_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVClipDataSet_StaticNew()
{
  return vtkPVClipDataSet::New();
}

PyObject *PyvtkPVClipDataSet_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVClipDataSet_Type, PyvtkPVClipDataSet_Methods,
    "vtkPVClipDataSet",
 &PyvtkPVClipDataSet_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkTableBasedClipDataSet");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVClipDataSet_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVClipDataSet(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVClipDataSet_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVClipDataSet", o) != 0)
  {
    Py_DECREF(o);
  }

}

