/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implements a fast rectangular sigma filter using the accumulator
approach.


This code was contributed in the Insight Journal paper: "Efficient
implementation of kernel filtering" by Beare R., Lehmann G https://doi.org/10.54294/igq8fn


Gaetan Lehmann

See:
 itk::simple::BoxSigma for the procedural interface

 itk::BoxSigmaImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBoxSigmaImageFilter.h
*/
public class BoxSigmaImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BoxSigmaImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BoxSigmaImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BoxSigmaImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BoxSigmaImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BoxSigmaImageFilter::~BoxSigmaImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BoxSigmaImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BoxSigmaImageFilter::BoxSigmaImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BoxSigmaImageFilter() {
    this(SimpleITKJNI.new_BoxSigmaImageFilter(), true);
  }

  /**
Self&amp; itk::simple::BoxSigmaImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(VectorUInt32 Radius) {
    SimpleITKJNI.BoxSigmaImageFilter_setRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(Radius), Radius);
  }

  /**
Self&amp; itk::simple::BoxSigmaImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(long value) {
    SimpleITKJNI.BoxSigmaImageFilter_setRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::BoxSigmaImageFilter::GetRadius() const
*/
public  VectorUInt32 getRadius() {
    return new VectorUInt32(SimpleITKJNI.BoxSigmaImageFilter_getRadius(swigCPtr, this), true);
  }

  /**
std::string itk::simple::BoxSigmaImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BoxSigmaImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BoxSigmaImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BoxSigmaImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BoxSigmaImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BoxSigmaImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
