﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectcampaigns/ConnectCampaigns_EXPORTS.h>
#include <aws/connectcampaigns/model/Campaign.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ConnectCampaigns {
namespace Model {
/**
 * <p>DescribeCampaignResponse</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connectcampaigns-2021-01-30/DescribeCampaignResponse">AWS
 * API Reference</a></p>
 */
class DescribeCampaignResult {
 public:
  AWS_CONNECTCAMPAIGNS_API DescribeCampaignResult() = default;
  AWS_CONNECTCAMPAIGNS_API DescribeCampaignResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CONNECTCAMPAIGNS_API DescribeCampaignResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const Campaign& GetCampaign() const { return m_campaign; }
  template <typename CampaignT = Campaign>
  void SetCampaign(CampaignT&& value) {
    m_campaignHasBeenSet = true;
    m_campaign = std::forward<CampaignT>(value);
  }
  template <typename CampaignT = Campaign>
  DescribeCampaignResult& WithCampaign(CampaignT&& value) {
    SetCampaign(std::forward<CampaignT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeCampaignResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Campaign m_campaign;
  bool m_campaignHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectCampaigns
}  // namespace Aws
