/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.tool.FileSize;
import mediathek.tool.FileUtils;
import okhttp3.HttpUrl;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002J6\u0010\f\u001a\u00060\rj\u0002`\u000e2\n\u0010\u000f\u001a\u00060\rj\u0002`\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0004J\u001a\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\"\u0010\u0017\u001a\u00020\u00182\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0016\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d\u00a8\u0006\u001f"}, d2={"Lmediathek/tool/MVInfoFile;", "", "<init>", "()V", "formatFilmAsString", "", "film", "Lmediathek/daten/DatenFilm;", "url", "Lokhttp3/HttpUrl;", "extended", "", "appendFormattedTableLine", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "formatString", "keyTitle", "value", "splitStringIntoMaxFixedLengthLines", "input", "lineLength", "", "writeInfoFile", "", "path", "Ljava/nio/file/Path;", "writeManualInfoFile", "datenDownload", "Lmediathek/daten/DatenDownload;", "Companion", "MediathekView"})
@SourceDebugExtension(value={"SMAP\nMVInfoFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MVInfoFile.kt\nmediathek/tool/MVInfoFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public class MVInfoFile {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private static final Logger logger = LogManager.getLogger(MVInfoFile.class);
    @NotNull
    private static final String FILM_GROESSE = "Gr\u00f6\u00dfe";
    @NotNull
    private static final String FILM_SENDER = "Sender";
    @NotNull
    private static final String FILM_THEMA = "Thema";
    @NotNull
    private static final String FILM_TITEL = "Titel";
    @NotNull
    private static final String FILM_DATUM = "Datum";
    @NotNull
    private static final String FILM_ZEIT = "Zeit";
    @NotNull
    private static final String FILM_DAUER = "Dauer";
    private static final int MAX_HEADER_LENGTH = 12;
    private static final int MAX_LINE_LENGTH = 62;

    private final String formatFilmAsString(DatenFilm film, HttpUrl url, boolean extended) {
        if (film == null || url == null) {
            return "";
        }
        long fileSize = FileSize.getFileSizeFromUrl(url);
        String string = "%%-%ds %%s";
        Object[] objectArray = new Object[]{12};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String formatString = string2;
        StringBuilder sb = new StringBuilder();
        sb = this.appendFormattedTableLine(sb, formatString, FILM_SENDER, film.getSender());
        StringBuilder stringBuilder = this.appendFormattedTableLine(sb, formatString, FILM_THEMA, film.getThema()).append(System.lineSeparator());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        sb = stringBuilder;
        StringBuilder stringBuilder2 = this.appendFormattedTableLine(sb, formatString, FILM_TITEL, film.getTitle()).append(System.lineSeparator());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        sb = stringBuilder2;
        sb = this.appendFormattedTableLine(sb, formatString, FILM_DATUM, film.getSendeDatum());
        sb = this.appendFormattedTableLine(sb, formatString, FILM_ZEIT, film.getSendeZeit());
        sb = this.appendFormattedTableLine(sb, formatString, FILM_DAUER, film.getFilmLengthAsString());
        if (fileSize > -1L) {
            sb = this.appendFormattedTableLine(sb, formatString, FILM_GROESSE, FileUtils.humanReadableByteCountBinary(fileSize));
        } else {
            sb.append(System.lineSeparator());
        }
        sb.append(System.lineSeparator());
        sb.append("Website");
        sb.append(System.lineSeparator());
        sb.append(film.getWebsiteUrl());
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append("URL");
        sb.append(System.lineSeparator());
        if (!extended) {
            v3 = sb.append(url);
        } else {
            if (film.isHighQuality()) {
                sb.append("HQ: " + film.decompressUrl(film.getHighQualityUrl()) + "\n");
            }
            sb.append("Normal: " + film.getUrlNormalQuality() + "\n");
            v3 = sb.append("LQ: " + film.decompressUrl(film.getLowQualityUrl()) + "\n");
        }
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append(this.splitStringIntoMaxFixedLengthLines(film.getDescription(), 62));
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    static /* synthetic */ String formatFilmAsString$default(MVInfoFile mVInfoFile, DatenFilm datenFilm, HttpUrl httpUrl, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: formatFilmAsString");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return mVInfoFile.formatFilmAsString(datenFilm, httpUrl, bl);
    }

    @NotNull
    protected final StringBuilder appendFormattedTableLine(@NotNull StringBuilder sb, @Nullable String formatString, @Nullable String keyTitle, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        String string = formatString;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Object[] objectArray = new Object[2];
        String string3 = "%s:";
        Object[] objectArray2 = new Object[]{keyTitle};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(string3, Arrays.copyOf(objectArray2, objectArray2.length)), (String)"format(...)");
        objectArray[1] = value;
        String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        StringBuilder stringBuilder = sb.append(string4).append(System.lineSeparator());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        return stringBuilder;
    }

    @NotNull
    protected final String splitStringIntoMaxFixedLengthLines(@Nullable String input, int lineLength) {
        String string = Optional.ofNullable(input).map(arg_0 -> MVInfoFile.splitStringIntoMaxFixedLengthLines$lambda$1(arg_0 -> MVInfoFile.splitStringIntoMaxFixedLengthLines$lambda$0(lineLength, arg_0), arg_0)).orElse("");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"orElse(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeInfoFile(@Nullable DatenFilm film, @NotNull Path path, @Nullable HttpUrl url) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        logger.info("Infofile schreiben nach: {}", (Object)((Object)path.toAbsolutePath()).toString());
        path.toFile().getParentFile().mkdirs();
        Closeable closeable = Files.newOutputStream(path, new OpenOption[0]);
        Throwable throwable = null;
        try {
            OutputStream os = (OutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataOutputStream(os);
            Throwable throwable2 = null;
            try {
                DataOutputStream dos = (DataOutputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = new OutputStreamWriter(dos);
                Throwable throwable3 = null;
                try {
                    OutputStreamWriter osw = (OutputStreamWriter)closeable3;
                    boolean bl3 = false;
                    Closeable closeable4 = new BufferedWriter(osw);
                    Throwable throwable4 = null;
                    try {
                        BufferedWriter br = (BufferedWriter)closeable4;
                        boolean bl4 = false;
                        br.write(MVInfoFile.formatFilmAsString$default(this, film, url, false, 4, null));
                        br.flush();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        logger.info("Infodatei geschrieben");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeManualInfoFile(@NotNull DatenFilm film, @NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter((Object)film, (String)"film");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        path.toFile().getParentFile().mkdirs();
        Closeable closeable = Files.newOutputStream(path, new OpenOption[0]);
        Throwable throwable = null;
        try {
            OutputStream os = (OutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new DataOutputStream(os);
            Throwable throwable2 = null;
            try {
                DataOutputStream dos = (DataOutputStream)closeable2;
                boolean bl2 = false;
                Closeable closeable3 = new OutputStreamWriter(dos);
                Throwable throwable3 = null;
                try {
                    OutputStreamWriter osw = (OutputStreamWriter)closeable3;
                    boolean bl3 = false;
                    Closeable closeable4 = new BufferedWriter(osw);
                    Throwable throwable4 = null;
                    try {
                        BufferedWriter br = (BufferedWriter)closeable4;
                        boolean bl4 = false;
                        String string = film.getUrlNormalQuality();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrlNormalQuality(...)");
                        br.write(this.formatFilmAsString(film, HttpUrl.Companion.get(string), true));
                        br.flush();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void writeInfoFile(@NotNull DatenDownload datenDownload) throws IOException {
        block0: {
            Intrinsics.checkNotNullParameter((Object)datenDownload, (String)"datenDownload");
            new File(datenDownload.arr[30]).mkdirs();
            Path path = Paths.get(datenDownload.getFileNameWithoutSuffix() + ".txt", new String[0]);
            DatenFilm film = datenDownload.film;
            String string = datenDownload.arr[21];
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            HttpUrl url = HttpUrl.Companion.get(string);
            DatenFilm datenFilm = film;
            if (datenFilm == null) break block0;
            DatenFilm it = datenFilm;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)path);
            this.writeInfoFile(it, path, url);
        }
    }

    private static final String splitStringIntoMaxFixedLengthLines$lambda$0(int $lineLength, String s) {
        return WordUtils.wrap((String)s, (int)$lineLength);
    }

    private static final String splitStringIntoMaxFixedLengthLines$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmediathek/tool/MVInfoFile$Companion;", "", "<init>", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "FILM_GROESSE", "", "FILM_SENDER", "FILM_THEMA", "FILM_TITEL", "FILM_DATUM", "FILM_ZEIT", "FILM_DAUER", "MAX_HEADER_LENGTH", "", "MAX_LINE_LENGTH", "MediathekView"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

