/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.formatter.serialize;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.formatter.serialize.CatalogSerializer;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.PropertyNamingStrategies;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.annotation.JsonNaming;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.FilterProvider;
import tools.jackson.databind.ser.PropertyFilter;
import tools.jackson.databind.ser.PropertyWriter;
import tools.jackson.databind.ser.std.SimpleBeanPropertyFilter;
import tools.jackson.databind.ser.std.SimpleFilterProvider;

public abstract class BaseJacksonSerializedCatalog
implements CatalogSerializer {
    private static final Logger LOGGER = Logger.getLogger(BaseJacksonSerializedCatalog.class.getName());
    private final Catalog catalog;
    private final SortedSet<Column> allTableColumns;

    protected static Catalog readCatalog(InputStream in) {
        Objects.requireNonNull(in, "No input stream provided");
        try {
            ObjectMapper mapper = BaseJacksonSerializedCatalog.newConfiguredObjectMapper(JsonMapper.builder());
            Catalog catalog = (Catalog)mapper.readValue(in, Catalog.class);
            return catalog;
        }
        catch (JacksonException e) {
            throw new ExecutionRuntimeException("Could not deserialize catalog", (Throwable)e);
        }
    }

    private static ObjectMapper newConfiguredObjectMapper(MapperBuilder<? extends ObjectMapper, ?> mapperBuilder) {
        Objects.requireNonNull(mapperBuilder, "No mapper builder provided");
        mapperBuilder.enable(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, SerializationFeature.INDENT_OUTPUT, SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID});
        mapperBuilder.enable(new StreamReadFeature[]{StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION, StreamReadFeature.IGNORE_UNDEFINED});
        mapperBuilder.enable(new StreamWriteFeature[]{StreamWriteFeature.IGNORE_UNKNOWN});
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("ignore-getter-errors-filter", (PropertyFilter)new IgnoreExceptionBeanPropertyFilter());
        BasicPolymorphicTypeValidator typeValidator = BasicPolymorphicTypeValidator.builder().allowIfSubType(Object.class).build();
        @JsonIgnoreProperties(value={"parent", "referenced-column", "exported-foreign-keys", "imported-foreign-keys"})
        @JsonPropertyOrder(value={"@uuid", "@class", "name", "short-name", "full-name", "crawl-info", "schema-crawler-info", "jvm-system-info", "operating-system-info", "database-info", "jdbc-driver-info", "schemas", "system-column-data-types", "column-data-types", "all-table-columns"}, alphabetic=true)
        @JsonIdentityInfo(generator=ObjectIdGenerators.UUIDGenerator.class, property="@uuid")
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
        @JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
        @JsonFilter(value="ignore-getter-errors-filter")
        class JacksonAnnotationMixIn {
            JacksonAnnotationMixIn() {
            }
        }
        mapperBuilder.addMixIn(Object.class, JacksonAnnotationMixIn.class);
        mapperBuilder.filterProvider((FilterProvider)filters);
        mapperBuilder.activateDefaultTyping((PolymorphicTypeValidator)typeValidator);
        ObjectMapper objectMapper = mapperBuilder.build();
        return objectMapper;
    }

    public BaseJacksonSerializedCatalog(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
        this.allTableColumns = new TreeSet<Column>();
        this.loadAllTableColumns();
    }

    public Set<Column> getAllTableColumns() {
        return new TreeSet<Column>(this.allTableColumns);
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void save(OutputStream out) {
        Objects.requireNonNull(out, "No output stream provided");
        this.save(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    @Override
    public void save(Writer out) {
        Objects.requireNonNull(out, "No writer provided");
        try {
            ObjectMapper mapper = BaseJacksonSerializedCatalog.newConfiguredObjectMapper(this.newMapperBuilder());
            mapper.writeValue(out, (Object)this);
        }
        catch (JacksonException e) {
            throw new ExecutionRuntimeException("Could not serialize catalog", (Throwable)e);
        }
    }

    protected abstract MapperBuilder<? extends ObjectMapper, ?> newMapperBuilder();

    private void loadAllTableColumns() {
        for (Table table : this.catalog.getTables()) {
            this.allTableColumns.addAll(table.getColumns());
        }
    }

    private static class IgnoreExceptionBeanPropertyFilter
    extends SimpleBeanPropertyFilter {
        private static final List<String> PARTIAL_PROPERTIES = Arrays.asList("name", "short-name", "full-name", "attributes", "parent-partial", "remarks", "schema");

        private IgnoreExceptionBeanPropertyFilter() {
        }

        public void serializeAsProperty(Object pojo, JsonGenerator g, SerializationContext provider, PropertyWriter writer) throws Exception {
            if (this.include(writer)) {
                try {
                    if (pojo instanceof PartialDatabaseObject && !PARTIAL_PROPERTIES.contains(writer.getName())) {
                        return;
                    }
                    writer.serializeAsProperty(pojo, g, provider);
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    return;
                }
            } else if (!g.canOmitProperties()) {
                writer.serializeAsOmittedProperty(pojo, g, provider);
            }
        }

        protected boolean include(BeanPropertyWriter writer) {
            return true;
        }

        protected boolean include(PropertyWriter writer) {
            return true;
        }
    }
}

