/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ints;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodesFactory;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.IntNodes;
import com.oracle.graal.python.builtins.objects.ints.IntNodesFactory;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyLongCheckNodeGen;
import com.oracle.graal.python.lib.PyLongCopy;
import com.oracle.graal.python.lib.PyLongCopyNodeGen;
import com.oracle.graal.python.lib.PyLongFromUnicodeObject;
import com.oracle.graal.python.lib.PyLongFromUnicodeObjectNodeGen;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNodeGen;
import com.oracle.graal.python.lib.PyNumberFloatNode;
import com.oracle.graal.python.lib.PyNumberFloatNodeGen;
import com.oracle.graal.python.lib.PyNumberLongNode;
import com.oracle.graal.python.lib.PyNumberLongNodeGen;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectHashNodeGen;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNodeGen;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.lib.PyUnicodeCheckNodeGen;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.BuiltinClassProfilesFactory;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypesGen;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=IntBuiltins.class)
public final class IntBuiltinsFactory {
    private static final LibraryFactory<PythonBufferAccessLibrary> PYTHON_BUFFER_ACCESS_LIBRARY_ = LibraryFactory.resolve(PythonBufferAccessLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final RichCmpOp[] RICH_CMP_OP_VALUES = (RichCmpOp[])DSLSupport.lookupEnumConstants(RichCmpOp.class);

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(IntNewNodeFactory.getInstance(), RoundNodeFactory.getInstance(), AddNodeFactory.getInstance(), SubNodeFactory.getInstance(), TrueDivNodeFactory.getInstance(), FloorDivNodeFactory.getInstance(), DivModNodeFactory.getInstance(), ModNodeFactory.getInstance(), MulNodeFactory.getInstance(), PowNodeFactory.getInstance(), AbsNodeFactory.getInstance(), CeilNodeFactory.getInstance(), FloorNodeFactory.getInstance(), PosNodeFactory.getInstance(), NegNodeFactory.getInstance(), InvertNodeFactory.getInstance(), LShiftNodeFactory.getInstance(), RShiftNodeFactory.getInstance(), AndNodeFactory.getInstance(), OrNodeFactory.getInstance(), XorNodeFactory.getInstance(), RichCompareNodeFactory.getInstance(), ToBytesNodeFactory.getInstance(), FromBytesNodeFactory.getInstance(), BoolNodeFactory.getInstance(), StrNodeFactory.getInstance(), ReprNodeFactory.getInstance(), FormatNodeFactory.getInstance(), HashNodeFactory.getInstance(), BitCountNodeFactory.getInstance(), BitLengthNodeFactory.getInstance(), IsIntegerNodeFactory.getInstance(), RealNodeFactory.getInstance(), ImagNodeFactory.getInstance(), NumeratorNodeFactory.getInstance(), ConjugateNodeFactory.getInstance(), DenominatorNodeFactory.getInstance(), AsIntegerRatioNodeFactory.getInstance(), TruncNodeFactory.getInstance(), IntNodeFactory.getInstance(), GetNewArgsNodeFactory.getInstance(), FloatNodeFactory.getInstance());
    }

    private static RichCmpOp decodeRichCmpOp(int state) {
        if (state >= 0) {
            return RICH_CMP_OP_VALUES[state];
        }
        return null;
    }

    private static int encodeRichCmpOp(RichCmpOp e) {
        if (e != null) {
            return e.ordinal();
        }
        return -1;
    }

    @GeneratedBy(value=IntBuiltins.IntNewNode.class)
    public static final class IntNewNodeFactory
    implements NodeFactory<IntBuiltins.IntNewNode> {
        private static final IntNewNodeFactory INT_NEW_NODE_FACTORY_INSTANCE = new IntNewNodeFactory();

        private IntNewNodeFactory() {
        }

        public Class<IntBuiltins.IntNewNode> getNodeClass() {
            return IntBuiltins.IntNewNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.IntNewNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return IntNewNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.IntNewNode> getInstance() {
            return INT_NEW_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.IntNewNode create() {
            return new IntNewNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.IntNewNode.class)
        public static final class IntNewNodeGen
        extends IntBuiltins.IntNewNode {
            private static final InlineSupport.StateField STATE_0_IntNewNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final IntBuiltins.IntNewNode.IntNodeInnerNode INLINED_INNER_NODE_ = IntNodeInnerNodeGen.inline(InlineSupport.InlineTarget.create(IntBuiltins.IntNewNode.IntNodeInnerNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IntNewNode_UPDATER.subUpdater(0, 14), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"innerNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"innerNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"innerNode__field3_", Node.class)}));
            private static final BuiltinClassProfiles.IsBuiltinClassExactProfile INLINED_IS_PRIMITIVE_INT_PROFILE_ = BuiltinClassProfilesFactory.IsBuiltinClassExactProfileNodeGen.inline(InlineSupport.InlineTarget.create(BuiltinClassProfiles.IsBuiltinClassExactProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IntNewNode_UPDATER.subUpdater(14, 5)}));
            private static final IntBuiltins.IntNewNode.CreateIntSubclassNode INLINED_CREATE_INT_SUBCLASS_NODE_ = CreateIntSubclassNodeGen.inline(InlineSupport.InlineTarget.create(IntBuiltins.IntNewNode.CreateIntSubclassNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IntNewNode_UPDATER.subUpdater(19, 4), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"createIntSubclassNode__field1_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node innerNode__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node innerNode__field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node innerNode__field3_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node createIntSubclassNode__field1_;

            private IntNewNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                IntNewNodeGen inliningTarget__ = this;
                return IntBuiltins.IntNewNode.doGeneric(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, INLINED_INNER_NODE_, INLINED_IS_PRIMITIVE_INT_PROFILE_, INLINED_CREATE_INT_SUBCLASS_NODE_);
            }
        }

        @GeneratedBy(value=IntBuiltins.IntNewNode.IntNodeInnerNode.class)
        static final class IntNodeInnerNodeGen {
            private static final InlineSupport.StateField FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_0_");
            private static final InlinedBranchProfile INLINED_FALLBACK_MISSING_ARGUMENT_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(0, 1)}));
            private static final InlinedBranchProfile INLINED_FALLBACK_WRONG_BASE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(1, 1)}));
            private static final InlinedBranchProfile INLINED_FALLBACK_CANNOT_CONVERT_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(2, 1)}));
            private static final PyNumberAsSizeNode INLINED_FALLBACK_AS_SIZE_NODE_ = PyNumberAsSizeNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberAsSizeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(3, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_asSizeNode__field1_", Node.class)}));
            private static final PyUnicodeCheckNode INLINED_FALLBACK_UNICODE_CHECK_NODE_ = PyUnicodeCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyUnicodeCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(8, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_unicodeCheckNode__field1_", Node.class)}));
            private static final PyLongFromUnicodeObject INLINED_FALLBACK_LONG_FROM_UNICODE_ = PyLongFromUnicodeObjectNodeGen.inline(InlineSupport.InlineTarget.create(PyLongFromUnicodeObject.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(11, 11), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_longFromUnicode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_longFromUnicode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_longFromUnicode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_longFromUnicode__field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_longFromUnicode__field5_", Node.class)}));
            private static final InlineSupport.StateField FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_1_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_state_1_");
            private static final BytesNodes.BytesLikeCheck INLINED_FALLBACK_BYTES_LIKE_CHECK_ = BytesNodesFactory.BytesLikeCheckNodeGen.inline(InlineSupport.InlineTarget.create(BytesNodes.BytesLikeCheck.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_1_UPDATER.subUpdater(0, 19), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_bytesLikeCheck__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_bytesLikeCheck__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)FallbackData.lookup_(), (String)"fallback_bytesLikeCheck__field3_", Node.class)}));
            private static final PRaiseNode INLINED_FALLBACK_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{FALLBACK_INT_NODE_INNER_NODE_FALLBACK_STATE_0_UPDATER.subUpdater(22, 1)}));

            IntNodeInnerNodeGen() {
            }

            @NeverDefault
            public static IntBuiltins.IntNewNode.IntNodeInnerNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=14, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
                return new Inlined(target);
            }

            @GeneratedBy(value=IntBuiltins.IntNewNode.IntNodeInnerNode.class)
            @DenyReplace
            private static final class Inlined
            extends IntBuiltins.IntNewNode.IntNodeInnerNode
            implements UnadoptableNode {
                private final InlineSupport.StateField state_0_;
                private final InlineSupport.ReferenceField<Node> noBase_pyNumberLongNode__field1_;
                private final InlineSupport.ReferenceField<Node> noBase_pyNumberLongNode__field2_;
                private final InlineSupport.ReferenceField<FallbackData> fallback_cache;
                private final InlinedBranchProfile noBase_noX_;
                private final PyNumberLongNode noBase_pyNumberLongNode_;

                private Inlined(InlineSupport.InlineTarget target) {
                    assert (target.getTargetClass().isAssignableFrom(IntBuiltins.IntNewNode.IntNodeInnerNode.class));
                    this.state_0_ = target.getState(0, 14);
                    this.noBase_pyNumberLongNode__field1_ = target.getReference(1, Node.class);
                    this.noBase_pyNumberLongNode__field2_ = target.getReference(2, Node.class);
                    this.fallback_cache = target.getReference(3, FallbackData.class);
                    this.noBase_noX_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(2, 1)}));
                    this.noBase_pyNumberLongNode_ = PyNumberLongNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberLongNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_0_.subUpdater(3, 11), this.noBase_pyNumberLongNode__field1_, this.noBase_pyNumberLongNode__field2_}));
                }

                private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value, Object arg2Value) {
                    return (state_0 & 1) != 0 || !PGuards.isNoValue(arg2Value);
                }

                @Override
                public Object execute(VirtualFrame frameValue, Node arg0Value, Object arg1Value, Object arg2Value) {
                    int state_0 = this.state_0_.get(arg0Value);
                    if ((state_0 & 3) != 0) {
                        FallbackData s1_;
                        if ((state_0 & 1) != 0 && PGuards.isNoValue(arg2Value)) {
                            assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.noBase_pyNumberLongNode__field1_, this.noBase_pyNumberLongNode__field2_}));
                            return IntBuiltins.IntNewNode.IntNodeInnerNode.doNoBase(frameValue, arg0Value, arg1Value, arg2Value, this.noBase_noX_, this.noBase_pyNumberLongNode_);
                        }
                        if ((state_0 & 2) != 0 && (s1_ = (FallbackData)((Object)this.fallback_cache.get(arg0Value))) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value)) {
                            return IntBuiltins.IntNewNode.IntNodeInnerNode.doWithBase(frameValue, s1_, arg1Value, arg2Value, INLINED_FALLBACK_MISSING_ARGUMENT_, INLINED_FALLBACK_WRONG_BASE_, INLINED_FALLBACK_CANNOT_CONVERT_, INLINED_FALLBACK_AS_SIZE_NODE_, INLINED_FALLBACK_UNICODE_CHECK_NODE_, INLINED_FALLBACK_LONG_FROM_UNICODE_, INLINED_FALLBACK_BYTES_LIKE_CHECK_, s1_.fromBufferNode_, INLINED_FALLBACK_RAISE_NODE_);
                        }
                    }
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
                }

                private Object executeAndSpecialize(VirtualFrame frameValue, Node arg0Value, Object arg1Value, Object arg2Value) {
                    int state_0 = this.state_0_.get(arg0Value);
                    if (PGuards.isNoValue(arg2Value)) {
                        this.state_0_.set(arg0Value, state_0 |= 1);
                        assert (InlineSupport.validate((Node)arg0Value, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField)this.state_0_, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.noBase_pyNumberLongNode__field1_, this.noBase_pyNumberLongNode__field2_}));
                        return IntBuiltins.IntNewNode.IntNodeInnerNode.doNoBase(frameValue, arg0Value, arg1Value, arg2Value, this.noBase_noX_, this.noBase_pyNumberLongNode_);
                    }
                    FallbackData s1_ = (FallbackData)arg0Value.insert((Node)new FallbackData());
                    PyNumberLongNode.LongFromBufferNode fromBufferNode__ = (PyNumberLongNode.LongFromBufferNode)s1_.insert(PyNumberLongNodeGen.LongFromBufferNodeGen.create());
                    Objects.requireNonNull(fromBufferNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s1_.fromBufferNode_ = fromBufferNode__;
                    VarHandle.storeStoreFence();
                    this.fallback_cache.set(arg0Value, (Object)s1_);
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return IntBuiltins.IntNewNode.IntNodeInnerNode.doWithBase(frameValue, s1_, arg1Value, arg2Value, INLINED_FALLBACK_MISSING_ARGUMENT_, INLINED_FALLBACK_WRONG_BASE_, INLINED_FALLBACK_CANNOT_CONVERT_, INLINED_FALLBACK_AS_SIZE_NODE_, INLINED_FALLBACK_UNICODE_CHECK_NODE_, INLINED_FALLBACK_LONG_FROM_UNICODE_, INLINED_FALLBACK_BYTES_LIKE_CHECK_, fromBufferNode__, INLINED_FALLBACK_RAISE_NODE_);
                }
            }

            @GeneratedBy(value=IntBuiltins.IntNewNode.IntNodeInnerNode.class)
            @DenyReplace
            private static final class FallbackData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int fallback_state_0_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int fallback_state_1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_asSizeNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_unicodeCheckNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_longFromUnicode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_longFromUnicode__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_longFromUnicode__field3_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_longFromUnicode__field4_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_longFromUnicode__field5_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_bytesLikeCheck__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_bytesLikeCheck__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node fallback_bytesLikeCheck__field3_;
                @Node.Child
                PyNumberLongNode.LongFromBufferNode fromBufferNode_;

                FallbackData() {
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }

        @GeneratedBy(value=IntBuiltins.IntNewNode.CreateIntSubclassNode.class)
        static final class CreateIntSubclassNodeGen {
            CreateIntSubclassNodeGen() {
            }

            @NeverDefault
            public static IntBuiltins.IntNewNode.CreateIntSubclassNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=4, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
                return new Inlined(target);
            }

            @GeneratedBy(value=IntBuiltins.IntNewNode.CreateIntSubclassNode.class)
            @DenyReplace
            private static final class Inlined
            extends IntBuiltins.IntNewNode.CreateIntSubclassNode
            implements UnadoptableNode {
                private final InlineSupport.StateField state_0_;
                private final InlineSupport.ReferenceField<TypeNodes.GetInstanceShape> getInstanceShape;

                private Inlined(InlineSupport.InlineTarget target) {
                    assert (target.getTargetClass().isAssignableFrom(IntBuiltins.IntNewNode.CreateIntSubclassNode.class));
                    this.state_0_ = target.getState(0, 4);
                    this.getInstanceShape = target.getReference(1, TypeNodes.GetInstanceShape.class);
                }

                @Override
                public Object execute(Node arg0Value, Object arg1Value, Object arg2Value) {
                    int state_0 = this.state_0_.get(arg0Value);
                    if (state_0 != 0) {
                        if ((state_0 & 1) != 0 && arg2Value instanceof Integer) {
                            int n = (Integer)arg2Value;
                            TypeNodes.GetInstanceShape getInstanceShape_ = (TypeNodes.GetInstanceShape)((Object)this.getInstanceShape.get(arg0Value));
                            if (getInstanceShape_ != null) {
                                PythonLanguage language__ = PythonLanguage.get(arg0Value);
                                return IntBuiltins.IntNewNode.CreateIntSubclassNode.doSubclass(arg1Value, n, language__, getInstanceShape_);
                            }
                        }
                        if ((state_0 & 2) != 0 && arg2Value instanceof Long) {
                            long l = (Long)arg2Value;
                            TypeNodes.GetInstanceShape getInstanceShape_1 = (TypeNodes.GetInstanceShape)((Object)this.getInstanceShape.get(arg0Value));
                            if (getInstanceShape_1 != null) {
                                PythonLanguage language__1 = PythonLanguage.get(arg0Value);
                                return IntBuiltins.IntNewNode.CreateIntSubclassNode.doSubclass(arg1Value, l, language__1, getInstanceShape_1);
                            }
                        }
                        if ((state_0 & 4) != 0 && arg2Value instanceof Boolean) {
                            boolean bl = (Boolean)arg2Value;
                            TypeNodes.GetInstanceShape getInstanceShape_2 = (TypeNodes.GetInstanceShape)((Object)this.getInstanceShape.get(arg0Value));
                            if (getInstanceShape_2 != null) {
                                PythonLanguage language__2 = PythonLanguage.get(arg0Value);
                                return IntBuiltins.IntNewNode.CreateIntSubclassNode.doSubclass(arg1Value, bl, language__2, getInstanceShape_2);
                            }
                        }
                        if ((state_0 & 8) != 0 && arg2Value instanceof PInt) {
                            PInt pInt = (PInt)arg2Value;
                            TypeNodes.GetInstanceShape getInstanceShape_3 = (TypeNodes.GetInstanceShape)((Object)this.getInstanceShape.get(arg0Value));
                            if (getInstanceShape_3 != null) {
                                PythonLanguage language__3 = PythonLanguage.get(arg0Value);
                                return IntBuiltins.IntNewNode.CreateIntSubclassNode.doSubclass(arg1Value, pInt, language__3, getInstanceShape_3);
                            }
                        }
                    }
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                }

                private Object executeAndSpecialize(Node arg0Value, Object arg1Value, Object arg2Value) {
                    int state_0 = this.state_0_.get(arg0Value);
                    PythonLanguage language__ = null;
                    if (arg2Value instanceof Integer) {
                        TypeNodes.GetInstanceShape getInstanceShape_;
                        int arg2Value_ = (Integer)arg2Value;
                        language__ = PythonLanguage.get(arg0Value);
                        TypeNodes.GetInstanceShape getInstanceShape__shared = (TypeNodes.GetInstanceShape)((Object)this.getInstanceShape.get(arg0Value));
                        if (getInstanceShape__shared != null) {
                            getInstanceShape_ = getInstanceShape__shared;
                        } else {
                            getInstanceShape_ = (TypeNodes.GetInstanceShape)arg0Value.insert((Node)TypeNodesFactory.GetInstanceShapeNodeGen.create());
                            if (getInstanceShape_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.getInstanceShape.get(arg0Value) == null) {
                            VarHandle.storeStoreFence();
                            this.getInstanceShape.set(arg0Value, (Object)getInstanceShape_);
                        }
                        this.state_0_.set(arg0Value, state_0 |= 1);
                        return IntBuiltins.IntNewNode.CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__, getInstanceShape_);
                    }
                    PythonLanguage language__1 = null;
                    if (arg2Value instanceof Long) {
                        TypeNodes.GetInstanceShape getInstanceShape_1;
                        long arg2Value_ = (Long)arg2Value;
                        language__1 = PythonLanguage.get(arg0Value);
                        TypeNodes.GetInstanceShape getInstanceShape_1_shared = (TypeNodes.GetInstanceShape)((Object)this.getInstanceShape.get(arg0Value));
                        if (getInstanceShape_1_shared != null) {
                            getInstanceShape_1 = getInstanceShape_1_shared;
                        } else {
                            getInstanceShape_1 = (TypeNodes.GetInstanceShape)arg0Value.insert((Node)TypeNodesFactory.GetInstanceShapeNodeGen.create());
                            if (getInstanceShape_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.getInstanceShape.get(arg0Value) == null) {
                            VarHandle.storeStoreFence();
                            this.getInstanceShape.set(arg0Value, (Object)getInstanceShape_1);
                        }
                        this.state_0_.set(arg0Value, state_0 |= 2);
                        return IntBuiltins.IntNewNode.CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__1, getInstanceShape_1);
                    }
                    PythonLanguage language__2 = null;
                    if (arg2Value instanceof Boolean) {
                        TypeNodes.GetInstanceShape getInstanceShape_2;
                        boolean arg2Value_ = (Boolean)arg2Value;
                        language__2 = PythonLanguage.get(arg0Value);
                        TypeNodes.GetInstanceShape getInstanceShape_2_shared = (TypeNodes.GetInstanceShape)((Object)this.getInstanceShape.get(arg0Value));
                        if (getInstanceShape_2_shared != null) {
                            getInstanceShape_2 = getInstanceShape_2_shared;
                        } else {
                            getInstanceShape_2 = (TypeNodes.GetInstanceShape)arg0Value.insert((Node)TypeNodesFactory.GetInstanceShapeNodeGen.create());
                            if (getInstanceShape_2 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.getInstanceShape.get(arg0Value) == null) {
                            VarHandle.storeStoreFence();
                            this.getInstanceShape.set(arg0Value, (Object)getInstanceShape_2);
                        }
                        this.state_0_.set(arg0Value, state_0 |= 4);
                        return IntBuiltins.IntNewNode.CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__2, getInstanceShape_2);
                    }
                    PythonLanguage language__3 = null;
                    if (arg2Value instanceof PInt) {
                        TypeNodes.GetInstanceShape getInstanceShape_3;
                        PInt arg2Value_ = (PInt)arg2Value;
                        language__3 = PythonLanguage.get(arg0Value);
                        TypeNodes.GetInstanceShape getInstanceShape_3_shared = (TypeNodes.GetInstanceShape)((Object)this.getInstanceShape.get(arg0Value));
                        if (getInstanceShape_3_shared != null) {
                            getInstanceShape_3 = getInstanceShape_3_shared;
                        } else {
                            getInstanceShape_3 = (TypeNodes.GetInstanceShape)arg0Value.insert((Node)TypeNodesFactory.GetInstanceShapeNodeGen.create());
                            if (getInstanceShape_3 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.getInstanceShape.get(arg0Value) == null) {
                            VarHandle.storeStoreFence();
                            this.getInstanceShape.set(arg0Value, (Object)getInstanceShape_3);
                        }
                        this.state_0_.set(arg0Value, state_0 |= 8);
                        return IntBuiltins.IntNewNode.CreateIntSubclassNode.doSubclass(arg1Value, arg2Value_, language__3, getInstanceShape_3);
                    }
                    throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value});
                }
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.RoundNode.class)
    static final class RoundNodeFactory
    implements NodeFactory<IntBuiltins.RoundNode> {
        private static final RoundNodeFactory ROUND_NODE_FACTORY_INSTANCE = new RoundNodeFactory();

        private RoundNodeFactory() {
        }

        public Class<IntBuiltins.RoundNode> getNodeClass() {
            return IntBuiltins.RoundNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.RoundNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return RoundNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.RoundNode> getInstance() {
            return ROUND_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.RoundNode create() {
            return new RoundNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.RoundNode.class)
        static final class RoundNodeGen
        extends IntBuiltins.RoundNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_INT_OVF = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(20, 1)}));
            private static final InlinedBranchProfile INLINED_LONG_OVF = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(21, 1)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private RoundNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x3FF) != 0) {
                    PythonAbstractObject arg1Value_;
                    if ((state_0 & 7) != 0 && arg1Value instanceof PNone) {
                        arg1Value_ = (PNone)arg1Value;
                        if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xC00) >>> 10, arg0Value)) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xC00) >>> 10, arg0Value);
                            return IntBuiltins.RoundNode.roundIntNone(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000) >>> 12, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000) >>> 12, arg0Value);
                            return IntBuiltins.RoundNode.roundLongNone(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            RoundNodeGen inliningTarget__ = this;
                            PythonLanguage language__ = PythonLanguage.get(this);
                            return IntBuiltins.RoundNode.roundPIntNone(arg0Value_, arg1Value_, inliningTarget__, language__);
                        }
                    }
                    if ((state_0 & 0x18) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x18000) >>> 15, arg1Value)) {
                        int arg1Value_2 = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x18000) >>> 15, arg1Value);
                        if ((state_0 & 8) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000) >>> 12, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000) >>> 12, arg0Value);
                            RoundNodeGen inliningTarget__1 = this;
                            return IntBuiltins.RoundNode.roundLongInt(arg0Value_, arg1Value_2, inliningTarget__1, INLINED_INT_OVF, INLINED_LONG_OVF);
                        }
                        if ((state_0 & 0x10) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            RoundNodeGen inliningTarget__2 = this;
                            return IntBuiltins.RoundNode.roundPIntInt(arg0Value_, arg1Value_2, inliningTarget__2, INLINED_INT_OVF, INLINED_LONG_OVF);
                        }
                    }
                    if ((state_0 & 0x60) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg1Value)) {
                        long arg1Value_3 = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg1Value);
                        if ((state_0 & 0x20) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000) >>> 12, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000) >>> 12, arg0Value);
                            RoundNodeGen inliningTarget__3 = this;
                            return IntBuiltins.RoundNode.roundLongLong(arg0Value_, arg1Value_3, inliningTarget__3, INLINED_INT_OVF, INLINED_LONG_OVF);
                        }
                        if ((state_0 & 0x40) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            RoundNodeGen inliningTarget__4 = this;
                            return IntBuiltins.RoundNode.roundPIntLong(arg0Value_, arg1Value_3, (Node)inliningTarget__4, INLINED_INT_OVF, INLINED_LONG_OVF);
                        }
                    }
                    if ((state_0 & 0x180) != 0 && arg1Value instanceof PInt) {
                        arg1Value_ = (PInt)arg1Value;
                        if ((state_0 & 0x80) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000) >>> 12, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000) >>> 12, arg0Value);
                            RoundNodeGen inliningTarget__5 = this;
                            return IntBuiltins.RoundNode.roundPIntLong(arg0Value_, (PInt)arg1Value_, (Node)inliningTarget__5, INLINED_INT_OVF, INLINED_LONG_OVF);
                        }
                        if ((state_0 & 0x100) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            RoundNodeGen inliningTarget__6 = this;
                            return IntBuiltins.RoundNode.roundPIntPInt(arg0Value_, (PInt)arg1Value_, inliningTarget__6, INLINED_INT_OVF, INLINED_LONG_OVF);
                        }
                    }
                    if ((state_0 & 0x200) != 0 && !MathGuards.isInteger(arg1Value)) {
                        RoundNodeGen inliningTarget__7 = this;
                        return IntBuiltins.RoundNode.roundPIntPInt(arg0Value, arg1Value, inliningTarget__7);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int longCast1;
                int intCast1;
                int state_0 = this.state_0_;
                if (arg1Value instanceof PNone) {
                    PNone arg1Value_ = (PNone)arg1Value;
                    int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                    if (intCast0 != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                        state_0 |= intCast0 << 10;
                        this.state_0_ = state_0 |= 1;
                        return IntBuiltins.RoundNode.roundIntNone(arg0Value_, arg1Value_);
                    }
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        state_0 |= longCast0 << 12;
                        this.state_0_ = state_0 |= 2;
                        return IntBuiltins.RoundNode.roundLongNone(arg0Value_, arg1Value_);
                    }
                    PythonLanguage language__ = null;
                    RoundNodeGen inliningTarget__ = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        inliningTarget__ = this;
                        language__ = PythonLanguage.get(this);
                        this.state_0_ = state_0 |= 4;
                        return IntBuiltins.RoundNode.roundPIntNone(arg0Value_, arg1Value_, inliningTarget__, language__);
                    }
                }
                if ((intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                    int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                    RoundNodeGen inliningTarget__1 = null;
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        inliningTarget__1 = this;
                        state_0 |= longCast0 << 12;
                        state_0 |= intCast1 << 15;
                        this.state_0_ = state_0 |= 8;
                        return IntBuiltins.RoundNode.roundLongInt(arg0Value_, arg1Value_, inliningTarget__1, INLINED_INT_OVF, INLINED_LONG_OVF);
                    }
                    RoundNodeGen inliningTarget__2 = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        inliningTarget__2 = this;
                        state_0 |= intCast1 << 15;
                        this.state_0_ = state_0 |= 0x10;
                        return IntBuiltins.RoundNode.roundPIntInt(arg0Value_, arg1Value_, inliningTarget__2, INLINED_INT_OVF, INLINED_LONG_OVF);
                    }
                }
                if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                    RoundNodeGen inliningTarget__3 = null;
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        inliningTarget__3 = this;
                        state_0 |= longCast0 << 12;
                        state_0 |= longCast1 << 17;
                        this.state_0_ = state_0 |= 0x20;
                        return IntBuiltins.RoundNode.roundLongLong(arg0Value_, arg1Value_, inliningTarget__3, INLINED_INT_OVF, INLINED_LONG_OVF);
                    }
                    RoundNodeGen inliningTarget__4 = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        inliningTarget__4 = this;
                        state_0 |= longCast1 << 17;
                        this.state_0_ = state_0 |= 0x40;
                        return IntBuiltins.RoundNode.roundPIntLong(arg0Value_, arg1Value_, (Node)inliningTarget__4, INLINED_INT_OVF, INLINED_LONG_OVF);
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt)arg1Value;
                    RoundNodeGen inliningTarget__5 = null;
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        inliningTarget__5 = this;
                        state_0 |= longCast0 << 12;
                        this.state_0_ = state_0 |= 0x80;
                        return IntBuiltins.RoundNode.roundPIntLong(arg0Value_, arg1Value_, (Node)inliningTarget__5, INLINED_INT_OVF, INLINED_LONG_OVF);
                    }
                    RoundNodeGen inliningTarget__6 = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        inliningTarget__6 = this;
                        this.state_0_ = state_0 |= 0x100;
                        return IntBuiltins.RoundNode.roundPIntPInt(arg0Value_, arg1Value_, inliningTarget__6, INLINED_INT_OVF, INLINED_LONG_OVF);
                    }
                }
                RoundNodeGen inliningTarget__7 = null;
                if (!MathGuards.isInteger(arg1Value)) {
                    inliningTarget__7 = this;
                    this.state_0_ = state_0 |= 0x200;
                    return IntBuiltins.RoundNode.roundPIntPInt(arg0Value, arg1Value, inliningTarget__7);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.AddNode.class)
    public static final class AddNodeFactory
    implements NodeFactory<IntBuiltins.AddNode> {
        private static final AddNodeFactory ADD_NODE_FACTORY_INSTANCE = new AddNodeFactory();

        private AddNodeFactory() {
        }

        public Class<IntBuiltins.AddNode> getNodeClass() {
            return IntBuiltins.AddNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.AddNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return AddNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.AddNode> getInstance() {
            return ADD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.AddNode create() {
            return new AddNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.AddNode.class)
        public static final class AddNodeGen
        extends IntBuiltins.AddNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AddNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x6DB5) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x18000) >>> 15, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x18000) >>> 15, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60000) >>> 17, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60000) >>> 17, arg1Value);
                            try {
                                return IntBuiltins.AddNode.doII(arg0Value_, arg1Value_);
                            }
                            catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFE;
                                this.state_0_ = state_0 |= 2;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                    }
                    if ((state_0 & 0xB4) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value);
                        if ((state_0 & 0x14) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19, arg0Value);
                            if ((state_0 & 4) != 0) {
                                try {
                                    return IntBuiltins.AddNode.doLL(arg0Value_, arg1Value_);
                                }
                                catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFFB;
                                    this.state_0_ = state_0 |= 8;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x10) != 0) {
                                PythonLanguage language__ = PythonLanguage.get(this);
                                return IntBuiltins.AddNode.doLLOvf(arg0Value_, arg1Value_, language__);
                            }
                        }
                        if ((state_0 & 0xA0) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            if ((state_0 & 0x20) != 0) {
                                try {
                                    return IntBuiltins.AddNode.doPLNarrow(arg0Value_, arg1Value_);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFDF;
                                    this.state_0_ = state_0 |= 0x40;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x80) != 0) {
                                PythonLanguage language__1 = PythonLanguage.get(this);
                                return IntBuiltins.AddNode.doPL(arg0Value_, arg1Value_, language__1);
                            }
                        }
                    }
                    if ((state_0 & 0x2D00) != 0 && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        if ((state_0 & 0x500) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19, arg0Value);
                            if ((state_0 & 0x100) != 0) {
                                try {
                                    return IntBuiltins.AddNode.doLPNarrow(arg0Value_, arg1Value_);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFEFF;
                                    this.state_0_ = state_0 |= 0x200;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x400) != 0) {
                                PythonLanguage language__2 = PythonLanguage.get(this);
                                return IntBuiltins.AddNode.doLP(arg0Value_, arg1Value_, language__2);
                            }
                        }
                        if ((state_0 & 0x2800) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            if ((state_0 & 0x800) != 0) {
                                try {
                                    return IntBuiltins.AddNode.doPPNarrow(arg0Value_, arg1Value_);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFF7FF;
                                    this.state_0_ = state_0 |= 0x1000;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x2000) != 0) {
                                PythonLanguage language__3 = PythonLanguage.get(this);
                                return IntBuiltins.AddNode.doPP(arg0Value_, arg1Value_, language__3);
                            }
                        }
                    }
                    if ((state_0 & 0x4000) != 0 && (IntBuiltins.AddNode.isNotImplemented(arg0Value) || IntBuiltins.AddNode.isNotImplemented(arg1Value))) {
                        return IntBuiltins.AddNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x4015) != 0) {
                    if ((state_0 & 1) != 0) {
                        try {
                            return IntBuiltins.AddNode.doII(arg0Value, arg1Value);
                        }
                        catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            return this.executeAndSpecialize(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0x14) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value);
                            if ((state_0 & 4) != 0) {
                                try {
                                    return IntBuiltins.AddNode.doLL(arg0Value_, arg1Value_);
                                }
                                catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFFB;
                                    this.state_0_ = state_0 |= 8;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x10) != 0) {
                                PythonLanguage language__ = PythonLanguage.get(this);
                                return IntBuiltins.AddNode.doLLOvf(arg0Value_, arg1Value_, language__);
                            }
                        }
                    }
                    if ((state_0 & 0x4000) != 0 && (IntBuiltins.AddNode.isNotImplemented(arg0Value) || IntBuiltins.AddNode.isNotImplemented(arg1Value))) {
                        return IntBuiltins.AddNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int longCast1;
                int intCast0;
                int state_0 = this.state_0_;
                if ((state_0 & 0x14) == 0 && (state_0 & 2) == 0 && (intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value)) != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        state_0 |= intCast0 << 15;
                        state_0 |= intCast1 << 17;
                        this.state_0_ = state_0 |= 1;
                        try {
                            return IntBuiltins.AddNode.doII(arg0Value_, arg1Value_);
                        }
                        catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            return this.executeAndSpecialize(arg0Value_, arg1Value_);
                        }
                    }
                }
                if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        if ((state_0 & 0x10) == 0 && (state_0 & 8) == 0) {
                            state_0 &= 0xFFFFFFFE;
                            state_0 |= longCast0 << 19;
                            state_0 |= longCast1 << 22;
                            this.state_0_ = state_0 |= 4;
                            try {
                                return IntBuiltins.AddNode.doLL(arg0Value_, arg1Value_);
                            }
                            catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_ = state_0 |= 8;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__ = null;
                        language__ = PythonLanguage.get(this);
                        state_0 &= 0xFFFFFFFA;
                        state_0 |= longCast0 << 19;
                        state_0 |= longCast1 << 22;
                        this.state_0_ = state_0 |= 0x10;
                        return IntBuiltins.AddNode.doLLOvf(arg0Value_, arg1Value_, language__);
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x80) == 0 && (state_0 & 0x40) == 0) {
                            state_0 |= longCast1 << 22;
                            this.state_0_ = state_0 |= 0x20;
                            try {
                                return IntBuiltins.AddNode.doPLNarrow(arg0Value_, arg1Value_);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_ = state_0 |= 0x40;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__1 = null;
                        language__1 = PythonLanguage.get(this);
                        state_0 &= 0xFFFFFFDF;
                        state_0 |= longCast1 << 22;
                        this.state_0_ = state_0 |= 0x80;
                        return IntBuiltins.AddNode.doPL(arg0Value_, arg1Value_, language__1);
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt)arg1Value;
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        if ((state_0 & 0x400) == 0 && (state_0 & 0x200) == 0) {
                            state_0 |= longCast0 << 19;
                            this.state_0_ = state_0 |= 0x100;
                            try {
                                return IntBuiltins.AddNode.doLPNarrow(arg0Value_, arg1Value_);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFEFF;
                                this.state_0_ = state_0 |= 0x200;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__2 = null;
                        language__2 = PythonLanguage.get(this);
                        state_0 &= 0xFFFFFEFF;
                        state_0 |= longCast0 << 19;
                        this.state_0_ = state_0 |= 0x400;
                        return IntBuiltins.AddNode.doLP(arg0Value_, arg1Value_, language__2);
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x2000) == 0 && (state_0 & 0x1000) == 0) {
                            this.state_0_ = state_0 |= 0x800;
                            try {
                                return IntBuiltins.AddNode.doPPNarrow(arg0Value_, arg1Value_);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFF7FF;
                                this.state_0_ = state_0 |= 0x1000;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__3 = null;
                        language__3 = PythonLanguage.get(this);
                        state_0 &= 0xFFFFF7FF;
                        this.state_0_ = state_0 |= 0x2000;
                        return IntBuiltins.AddNode.doPP(arg0Value_, arg1Value_, language__3);
                    }
                }
                if (IntBuiltins.AddNode.isNotImplemented(arg0Value) || IntBuiltins.AddNode.isNotImplemented(arg1Value)) {
                    this.state_0_ = state_0 |= 0x4000;
                    return IntBuiltins.AddNode.doGeneric(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.SubNode.class)
    public static final class SubNodeFactory
    implements NodeFactory<IntBuiltins.SubNode> {
        private static final SubNodeFactory SUB_NODE_FACTORY_INSTANCE = new SubNodeFactory();

        private SubNodeFactory() {
        }

        public Class<IntBuiltins.SubNode> getNodeClass() {
            return IntBuiltins.SubNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.SubNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return SubNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.SubNode> getInstance() {
            return SUB_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.SubNode create() {
            return new SubNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.SubNode.class)
        public static final class SubNodeGen
        extends IntBuiltins.SubNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private SubNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (((state_0 & 0x20) == 0 || (state_0 & 0x3F00000) != 0x3F00000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (((state_0 & 0x100) == 0 || (state_0 & 0x3800000) != 0x3800000) && arg0Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg1Value instanceof PInt) {
                    if (((state_0 & 0x800) == 0 || (state_0 & 0x700000) != 0x700000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if ((state_0 & 0x4000) == 0 && arg0Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xDB6D) != 0) {
                    if ((state_0 & 5) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x30000) >>> 16, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x30000) >>> 16, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xC0000) >>> 18, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xC0000) >>> 18, arg1Value);
                            if ((state_0 & 1) != 0) {
                                try {
                                    return IntBuiltins.SubNode.doII(arg0Value_, arg1Value_);
                                }
                                catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFFE;
                                    this.state_0_ = state_0 |= 2;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 4) != 0) {
                                return IntBuiltins.SubNode.doIIOvf(arg0Value_, arg1Value_);
                            }
                        }
                    }
                    if ((state_0 & 0x168) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x3800000) >>> 23, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x3800000) >>> 23, arg1Value);
                        if ((state_0 & 0x28) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x700000) >>> 20, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x700000) >>> 20, arg0Value);
                            if ((state_0 & 8) != 0) {
                                try {
                                    return IntBuiltins.SubNode.doLL(arg0Value_, arg1Value_);
                                }
                                catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFF7;
                                    this.state_0_ = state_0 |= 0x10;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x20) != 0) {
                                SubNodeGen inliningTarget__ = this;
                                return IntBuiltins.SubNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                            }
                        }
                        if ((state_0 & 0x140) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            if ((state_0 & 0x40) != 0) {
                                try {
                                    return IntBuiltins.SubNode.doPIntLongAndNarrow(arg0Value_, arg1Value_);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFBF;
                                    this.state_0_ = state_0 |= 0x80;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x100) != 0) {
                                PythonLanguage language__ = PythonLanguage.get(this);
                                return IntBuiltins.SubNode.doPIntLong(arg0Value_, arg1Value_, language__);
                            }
                        }
                    }
                    if ((state_0 & 0x5A00) != 0 && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        if ((state_0 & 0xA00) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x700000) >>> 20, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x700000) >>> 20, arg0Value);
                            if ((state_0 & 0x200) != 0) {
                                try {
                                    return IntBuiltins.SubNode.doLongPIntAndNarrow(arg0Value_, arg1Value_);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFDFF;
                                    this.state_0_ = state_0 |= 0x400;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x800) != 0) {
                                PythonLanguage language__1 = PythonLanguage.get(this);
                                return IntBuiltins.SubNode.doLongPInt(arg0Value_, arg1Value_, language__1);
                            }
                        }
                        if ((state_0 & 0x5000) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            if ((state_0 & 0x1000) != 0) {
                                try {
                                    return IntBuiltins.SubNode.doPIntPIntAndNarrow(arg0Value_, arg1Value_);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFEFFF;
                                    this.state_0_ = state_0 |= 0x2000;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x4000) != 0) {
                                PythonLanguage language__2 = PythonLanguage.get(this);
                                return IntBuiltins.SubNode.doPIntPInt(arg0Value_, arg1Value_, language__2);
                            }
                        }
                    }
                    if ((state_0 & 0x8000) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.SubNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x802D) != 0) {
                    if ((state_0 & 5) != 0) {
                        if ((state_0 & 1) != 0) {
                            try {
                                return IntBuiltins.SubNode.doII(arg0Value, arg1Value);
                            }
                            catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFE;
                                this.state_0_ = state_0 |= 2;
                                return this.executeAndSpecialize(arg0Value, arg1Value);
                            }
                        }
                        if ((state_0 & 4) != 0) {
                            return IntBuiltins.SubNode.doIIOvf(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0x28) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x700000) >>> 20, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x700000) >>> 20, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x3800000) >>> 23, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x3800000) >>> 23, arg1Value);
                            if ((state_0 & 8) != 0) {
                                try {
                                    return IntBuiltins.SubNode.doLL(arg0Value_, arg1Value_);
                                }
                                catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFF7;
                                    this.state_0_ = state_0 |= 0x10;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x20) != 0) {
                                SubNodeGen inliningTarget__ = this;
                                return IntBuiltins.SubNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                            }
                        }
                    }
                    if ((state_0 & 0x8000) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.SubNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int longCast1;
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        if ((state_0 & 4) == 0 && (state_0 & 2) == 0) {
                            state_0 |= intCast0 << 16;
                            state_0 |= intCast1 << 18;
                            this.state_0_ = state_0 |= 1;
                            try {
                                return IntBuiltins.SubNode.doII(arg0Value_, arg1Value_);
                            }
                            catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFE;
                                this.state_0_ = state_0 |= 2;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        state_0 &= 0xFFFFFFFE;
                        state_0 |= intCast0 << 16;
                        state_0 |= intCast1 << 18;
                        this.state_0_ = state_0 |= 4;
                        return IntBuiltins.SubNode.doIIOvf(arg0Value_, arg1Value_);
                    }
                }
                if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        if ((state_0 & 0x20) == 0 && (state_0 & 0x10) == 0) {
                            state_0 |= longCast0 << 20;
                            state_0 |= longCast1 << 23;
                            this.state_0_ = state_0 |= 8;
                            try {
                                return IntBuiltins.SubNode.doLL(arg0Value_, arg1Value_);
                            }
                            catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFF7;
                                this.state_0_ = state_0 |= 0x10;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        SubNodeGen inliningTarget__ = null;
                        inliningTarget__ = this;
                        state_0 &= 0xFFFFFFF7;
                        state_0 |= longCast0 << 20;
                        state_0 |= longCast1 << 23;
                        this.state_0_ = state_0 |= 0x20;
                        return IntBuiltins.SubNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x100) == 0 && (state_0 & 0x80) == 0) {
                            state_0 |= longCast1 << 23;
                            this.state_0_ = state_0 |= 0x40;
                            try {
                                return IntBuiltins.SubNode.doPIntLongAndNarrow(arg0Value_, arg1Value_);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFBF;
                                this.state_0_ = state_0 |= 0x80;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__ = null;
                        language__ = PythonLanguage.get(this);
                        state_0 &= 0xFFFFFFBF;
                        state_0 |= longCast1 << 23;
                        this.state_0_ = state_0 |= 0x100;
                        return IntBuiltins.SubNode.doPIntLong(arg0Value_, arg1Value_, language__);
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt)arg1Value;
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        if ((state_0 & 0x800) == 0 && (state_0 & 0x400) == 0) {
                            state_0 |= longCast0 << 20;
                            this.state_0_ = state_0 |= 0x200;
                            try {
                                return IntBuiltins.SubNode.doLongPIntAndNarrow(arg0Value_, arg1Value_);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFDFF;
                                this.state_0_ = state_0 |= 0x400;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__1 = null;
                        language__1 = PythonLanguage.get(this);
                        state_0 &= 0xFFFFFDFF;
                        state_0 |= longCast0 << 20;
                        this.state_0_ = state_0 |= 0x800;
                        return IntBuiltins.SubNode.doLongPInt(arg0Value_, arg1Value_, language__1);
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x4000) == 0 && (state_0 & 0x2000) == 0) {
                            this.state_0_ = state_0 |= 0x1000;
                            try {
                                return IntBuiltins.SubNode.doPIntPIntAndNarrow(arg0Value_, arg1Value_);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFEFFF;
                                this.state_0_ = state_0 |= 0x2000;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__2 = null;
                        language__2 = PythonLanguage.get(this);
                        state_0 &= 0xFFFFEFFF;
                        this.state_0_ = state_0 |= 0x4000;
                        return IntBuiltins.SubNode.doPIntPInt(arg0Value_, arg1Value_, language__2);
                    }
                }
                this.state_0_ = state_0 |= 0x8000;
                return IntBuiltins.SubNode.doGeneric(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.TrueDivNode.class)
    public static final class TrueDivNodeFactory
    implements NodeFactory<IntBuiltins.TrueDivNode> {
        private static final TrueDivNodeFactory TRUE_DIV_NODE_FACTORY_INSTANCE = new TrueDivNodeFactory();

        private TrueDivNodeFactory() {
        }

        public Class<IntBuiltins.TrueDivNode> getNodeClass() {
            return IntBuiltins.TrueDivNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.TrueDivNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return TrueDivNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.TrueDivNode> getInstance() {
            return TRUE_DIV_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.TrueDivNode create() {
            return new TrueDivNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.TrueDivNode.class)
        public static final class TrueDivNodeGen
        extends IntBuiltins.TrueDivNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(17, 1)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private TrueDivNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (((state_0 & 1) == 0 || (state_0 & 0x780) != 1920) && PythonIntegerTypesGen.isImplicitInteger(arg0Value) && PythonIntegerTypesGen.isImplicitInteger(arg1Value)) {
                    return false;
                }
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        long arg1Value_;
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value);
                        if (IntBuiltins.TrueDivNode.fitsIntoDouble(arg0Value_) && IntBuiltins.TrueDivNode.fitsIntoDouble(arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value))) {
                            return false;
                        }
                        arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value);
                        arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value);
                        if (!IntBuiltins.TrueDivNode.fitsIntoDouble(arg0Value_) || !IntBuiltins.TrueDivNode.fitsIntoDouble(arg1Value_)) {
                            return false;
                        }
                    }
                    if (((state_0 & 8) == 0 || (state_0 & 0x3800) != 14336) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg0Value instanceof PInt) {
                    if (((state_0 & 0x10) == 0 || (state_0 & 0x1C000) != 114688) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if ((state_0 & 0x20) == 0 && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x7F) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x180) >>> 7, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x180) >>> 7, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x600) >>> 9, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x600) >>> 9, arg1Value);
                            TrueDivNodeGen inliningTarget__ = this;
                            return IntBuiltins.TrueDivNode.divII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0xE) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x3800) >>> 11, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x3800) >>> 11, arg0Value);
                        if ((state_0 & 6) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value);
                            if ((state_0 & 2) != 0 && IntBuiltins.TrueDivNode.fitsIntoDouble(arg0Value_) && IntBuiltins.TrueDivNode.fitsIntoDouble(arg1Value_)) {
                                TrueDivNodeGen inliningTarget__1 = this;
                                return IntBuiltins.TrueDivNode.divLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                            if (!((state_0 & 4) == 0 || IntBuiltins.TrueDivNode.fitsIntoDouble(arg0Value_) && IntBuiltins.TrueDivNode.fitsIntoDouble(arg1Value_))) {
                                TrueDivNodeGen inliningTarget__2 = this;
                                return IntBuiltins.TrueDivNode.divLLLarge(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 8) != 0 && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            TrueDivNodeGen inliningTarget__3 = this;
                            return IntBuiltins.TrueDivNode.doPI(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x30) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x10) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value);
                            TrueDivNodeGen inliningTarget__4 = this;
                            return IntBuiltins.TrueDivNode.doPL(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x20) != 0 && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            TrueDivNodeGen inliningTarget__5 = this;
                            return IntBuiltins.TrueDivNode.doPP(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x40) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.TrueDivNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x47) != 0) {
                    if ((state_0 & 1) != 0) {
                        TrueDivNodeGen inliningTarget__ = this;
                        return IntBuiltins.TrueDivNode.divII(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                    }
                    if ((state_0 & 6) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x3800) >>> 11, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x3800) >>> 11, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C000) >>> 14, arg1Value);
                            if ((state_0 & 2) != 0 && IntBuiltins.TrueDivNode.fitsIntoDouble(arg0Value_) && IntBuiltins.TrueDivNode.fitsIntoDouble(arg1Value_)) {
                                TrueDivNodeGen inliningTarget__1 = this;
                                return IntBuiltins.TrueDivNode.divLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                            if (!((state_0 & 4) == 0 || IntBuiltins.TrueDivNode.fitsIntoDouble(arg0Value_) && IntBuiltins.TrueDivNode.fitsIntoDouble(arg1Value_))) {
                                TrueDivNodeGen inliningTarget__2 = this;
                                return IntBuiltins.TrueDivNode.divLLLarge(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0x40) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.TrueDivNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int longCast0;
                int state_0 = this.state_0_;
                TrueDivNodeGen inliningTarget__ = null;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        inliningTarget__ = this;
                        state_0 |= intCast0 << 7;
                        state_0 |= intCast1 << 9;
                        this.state_0_ = state_0 |= 1;
                        return IntBuiltins.TrueDivNode.divII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                    }
                }
                if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    int longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        TrueDivNodeGen inliningTarget__1 = null;
                        if (IntBuiltins.TrueDivNode.fitsIntoDouble(arg0Value_) && IntBuiltins.TrueDivNode.fitsIntoDouble(arg1Value_)) {
                            inliningTarget__1 = this;
                            state_0 |= longCast0 << 11;
                            state_0 |= longCast1 << 14;
                            this.state_0_ = state_0 |= 2;
                            return IntBuiltins.TrueDivNode.divLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                        }
                        TrueDivNodeGen inliningTarget__2 = null;
                        if (!IntBuiltins.TrueDivNode.fitsIntoDouble(arg0Value_) || !IntBuiltins.TrueDivNode.fitsIntoDouble(arg1Value_)) {
                            inliningTarget__2 = this;
                            state_0 |= longCast0 << 11;
                            state_0 |= longCast1 << 14;
                            this.state_0_ = state_0 |= 4;
                            return IntBuiltins.TrueDivNode.divLLLarge(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                        }
                    }
                    TrueDivNodeGen inliningTarget__3 = null;
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        inliningTarget__3 = this;
                        state_0 |= longCast0 << 11;
                        this.state_0_ = state_0 |= 8;
                        return IntBuiltins.TrueDivNode.doPI(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    TrueDivNodeGen inliningTarget__4 = null;
                    int longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        inliningTarget__4 = this;
                        state_0 |= longCast1 << 14;
                        this.state_0_ = state_0 |= 0x10;
                        return IntBuiltins.TrueDivNode.doPL(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                    }
                    TrueDivNodeGen inliningTarget__5 = null;
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        inliningTarget__5 = this;
                        this.state_0_ = state_0 |= 0x20;
                        return IntBuiltins.TrueDivNode.doPP(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                    }
                }
                this.state_0_ = state_0 |= 0x40;
                return IntBuiltins.TrueDivNode.doGeneric(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.FloorDivNode.class)
    public static final class FloorDivNodeFactory
    implements NodeFactory<IntBuiltins.FloorDivNode> {
        private static final FloorDivNodeFactory FLOOR_DIV_NODE_FACTORY_INSTANCE = new FloorDivNodeFactory();

        private FloorDivNodeFactory() {
        }

        public Class<IntBuiltins.FloorDivNode> getNodeClass() {
            return IntBuiltins.FloorDivNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.FloorDivNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FloorDivNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.FloorDivNode> getInstance() {
            return FLOOR_DIV_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.FloorDivNode create() {
            return new FloorDivNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.FloorDivNode.class)
        public static final class FloorDivNodeGen
        extends IntBuiltins.FloorDivNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedBranchProfile INLINED_OVERFLOW_VALUE_PROFILE = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(24, 1)}));
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(25, 1)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private FloorDivNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    if (((state_0 & 2) == 0 || (state_0 & 0xFC0000) != 0xFC0000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (((state_0 & 8) == 0 || (state_0 & 0x1C0000) != 0x1C0000) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg0Value instanceof PInt) {
                    if (((state_0 & 0x200) == 0 || (state_0 & 0xE00000) != 0xE00000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if ((state_0 & 0x1000) == 0 && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x36DF) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xC000) >>> 14, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xC000) >>> 14, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x30000) >>> 16, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x30000) >>> 16, arg1Value);
                            FloorDivNodeGen inliningTarget__ = this;
                            return IntBuiltins.FloorDivNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value);
                            FloorDivNodeGen inliningTarget__1 = this;
                            return IntBuiltins.FloorDivNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0xC) != 0 && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        if ((state_0 & 4) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xC000) >>> 14, arg0Value)) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xC000) >>> 14, arg0Value);
                            FloorDivNodeGen inliningTarget__2 = this;
                            return IntBuiltins.FloorDivNode.doIPi(arg0Value_, arg1Value_, inliningTarget__2, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 8) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value);
                            FloorDivNodeGen inliningTarget__3 = this;
                            return IntBuiltins.FloorDivNode.doLPi(arg0Value_, arg1Value_, inliningTarget__3, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x16D0) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x50) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x30000) >>> 16, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x30000) >>> 16, arg1Value);
                            if ((state_0 & 0x10) != 0) {
                                FloorDivNodeGen inliningTarget__4 = this;
                                try {
                                    return IntBuiltins.FloorDivNode.doPiIAndNarrow(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFEF;
                                    this.state_0_ = state_0 |= 0x20;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x40) != 0) {
                                FloorDivNodeGen inliningTarget__5 = this;
                                PythonLanguage language__ = PythonLanguage.get(this);
                                return IntBuiltins.FloorDivNode.doPiI(arg0Value_, arg1Value_, inliningTarget__5, language__, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0x280) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value);
                            if ((state_0 & 0x80) != 0) {
                                FloorDivNodeGen inliningTarget__6 = this;
                                try {
                                    return IntBuiltins.FloorDivNode.doPiLAndNarrow(arg0Value_, arg1Value_, inliningTarget__6, INLINED_RAISE_NODE);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFF7F;
                                    this.state_0_ = state_0 |= 0x100;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x200) != 0) {
                                FloorDivNodeGen inliningTarget__7 = this;
                                PythonLanguage language__1 = PythonLanguage.get(this);
                                return IntBuiltins.FloorDivNode.doPiL(arg0Value_, arg1Value_, inliningTarget__7, language__1, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0x1400) != 0 && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            if ((state_0 & 0x400) != 0) {
                                FloorDivNodeGen inliningTarget__8 = this;
                                try {
                                    return IntBuiltins.FloorDivNode.doPiPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFBFF;
                                    this.state_0_ = state_0 |= 0x800;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x1000) != 0) {
                                FloorDivNodeGen inliningTarget__9 = this;
                                PythonLanguage language__2 = PythonLanguage.get(this);
                                return IntBuiltins.FloorDivNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__9, language__2, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0x2000) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.FloorDivNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x2003) != 0) {
                    if ((state_0 & 1) != 0) {
                        FloorDivNodeGen inliningTarget__ = this;
                        return IntBuiltins.FloorDivNode.doII(arg0Value, arg1Value, inliningTarget__, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value);
                            FloorDivNodeGen inliningTarget__1 = this;
                            return IntBuiltins.FloorDivNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x2000) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.FloorDivNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                FloorDivNodeGen inliningTarget__ = null;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        inliningTarget__ = this;
                        state_0 |= intCast0 << 14;
                        state_0 |= intCast1 << 16;
                        this.state_0_ = state_0 |= 1;
                        return IntBuiltins.FloorDivNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                    }
                }
                FloorDivNodeGen inliningTarget__1 = null;
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    int longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        inliningTarget__1 = this;
                        state_0 |= longCast0 << 18;
                        state_0 |= longCast1 << 21;
                        this.state_0_ = state_0 |= 2;
                        return IntBuiltins.FloorDivNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt)arg1Value;
                    FloorDivNodeGen inliningTarget__2 = null;
                    int intCast02 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                    if (intCast02 != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast02, arg0Value);
                        inliningTarget__2 = this;
                        state_0 |= intCast02 << 14;
                        this.state_0_ = state_0 |= 4;
                        return IntBuiltins.FloorDivNode.doIPi(arg0Value_, arg1Value_, inliningTarget__2, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                    }
                    FloorDivNodeGen inliningTarget__3 = null;
                    int longCast02 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast02 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast02, arg0Value);
                        inliningTarget__3 = this;
                        state_0 |= longCast02 << 18;
                        this.state_0_ = state_0 |= 8;
                        return IntBuiltins.FloorDivNode.doLPi(arg0Value_, arg1Value_, inliningTarget__3, INLINED_OVERFLOW_VALUE_PROFILE, INLINED_RAISE_NODE);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        FloorDivNodeGen inliningTarget__4 = null;
                        if ((state_0 & 0x40) == 0 && (state_0 & 0x20) == 0) {
                            inliningTarget__4 = this;
                            state_0 |= intCast1 << 16;
                            this.state_0_ = state_0 |= 0x10;
                            try {
                                return IntBuiltins.FloorDivNode.doPiIAndNarrow(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFEF;
                                this.state_0_ = state_0 |= 0x20;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__ = null;
                        FloorDivNodeGen inliningTarget__5 = null;
                        inliningTarget__5 = this;
                        language__ = PythonLanguage.get(this);
                        state_0 &= 0xFFFFFFEF;
                        state_0 |= intCast1 << 16;
                        this.state_0_ = state_0 |= 0x40;
                        return IntBuiltins.FloorDivNode.doPiI(arg0Value_, arg1Value_, inliningTarget__5, language__, INLINED_RAISE_NODE);
                    }
                    int longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        FloorDivNodeGen inliningTarget__6 = null;
                        if ((state_0 & 0x200) == 0 && (state_0 & 0x100) == 0) {
                            inliningTarget__6 = this;
                            state_0 |= longCast1 << 21;
                            this.state_0_ = state_0 |= 0x80;
                            try {
                                return IntBuiltins.FloorDivNode.doPiLAndNarrow(arg0Value_, arg1Value_, inliningTarget__6, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFF7F;
                                this.state_0_ = state_0 |= 0x100;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__1 = null;
                        FloorDivNodeGen inliningTarget__7 = null;
                        inliningTarget__7 = this;
                        language__1 = PythonLanguage.get(this);
                        state_0 &= 0xFFFFFF7F;
                        state_0 |= longCast1 << 21;
                        this.state_0_ = state_0 |= 0x200;
                        return IntBuiltins.FloorDivNode.doPiL(arg0Value_, arg1Value_, inliningTarget__7, language__1, INLINED_RAISE_NODE);
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        FloorDivNodeGen inliningTarget__8 = null;
                        if ((state_0 & 0x1000) == 0 && (state_0 & 0x800) == 0) {
                            inliningTarget__8 = this;
                            this.state_0_ = state_0 |= 0x400;
                            try {
                                return IntBuiltins.FloorDivNode.doPiPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFBFF;
                                this.state_0_ = state_0 |= 0x800;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__2 = null;
                        FloorDivNodeGen inliningTarget__9 = null;
                        inliningTarget__9 = this;
                        language__2 = PythonLanguage.get(this);
                        state_0 &= 0xFFFFFBFF;
                        this.state_0_ = state_0 |= 0x1000;
                        return IntBuiltins.FloorDivNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__9, language__2, INLINED_RAISE_NODE);
                    }
                }
                this.state_0_ = state_0 |= 0x2000;
                return IntBuiltins.FloorDivNode.doGeneric(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.DivModNode.class)
    static final class DivModNodeFactory
    implements NodeFactory<IntBuiltins.DivModNode> {
        private static final DivModNodeFactory DIV_MOD_NODE_FACTORY_INSTANCE = new DivModNodeFactory();

        private DivModNodeFactory() {
        }

        public Class<IntBuiltins.DivModNode> getNodeClass() {
            return IntBuiltins.DivModNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.DivModNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return DivModNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.DivModNode> getInstance() {
            return DIV_MOD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.DivModNode create() {
            return new DivModNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.DivModNode.class)
        static final class DivModNodeGen
        extends IntBuiltins.DivModNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private IntBuiltins.FloorDivNode floorDivNode_;
            @Node.Child
            private IntBuiltins.ModNode modNode_;

            private DivModNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                IntBuiltins.ModNode modNode__;
                IntBuiltins.FloorDivNode floorDivNode__;
                int state_0 = this.state_0_;
                if (state_0 != 0 && (floorDivNode__ = this.floorDivNode_) != null && (modNode__ = this.modNode_) != null) {
                    DivModNodeGen inliningTarget__ = this;
                    return IntBuiltins.DivModNode.doGeneric(frameValue, arg0Value, arg1Value, inliningTarget__, floorDivNode__, modNode__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                DivModNodeGen inliningTarget__ = null;
                inliningTarget__ = this;
                IntBuiltins.FloorDivNode floorDivNode__ = (IntBuiltins.FloorDivNode)this.insert(IntBuiltins.FloorDivNode.create());
                Objects.requireNonNull(floorDivNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.floorDivNode_ = floorDivNode__;
                IntBuiltins.ModNode modNode__ = (IntBuiltins.ModNode)this.insert(IntBuiltins.ModNode.create());
                Objects.requireNonNull(modNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.modNode_ = modNode__;
                this.state_0_ = state_0 |= 1;
                return IntBuiltins.DivModNode.doGeneric(frameValue, arg0Value, arg1Value, inliningTarget__, floorDivNode__, modNode__);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.ModNode.class)
    public static final class ModNodeFactory
    implements NodeFactory<IntBuiltins.ModNode> {
        private static final ModNodeFactory MOD_NODE_FACTORY_INSTANCE = new ModNodeFactory();

        private ModNodeFactory() {
        }

        public Class<IntBuiltins.ModNode> getNodeClass() {
            return IntBuiltins.ModNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.ModNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ModNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.ModNode> getInstance() {
            return MOD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.ModNode create() {
            return new ModNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.ModNode.class)
        public static final class ModNodeGen
        extends IntBuiltins.ModNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(31, 1)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private ModNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    if (((state_0 & 2) == 0 || (state_0 & 0x7E000000) != 0x7E000000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        if (arg1Value_.isZeroOrPositive()) {
                            return false;
                        }
                        arg1Value_ = (PInt)arg1Value;
                        if (!arg1Value_.isZeroOrPositive()) {
                            return false;
                        }
                    }
                }
                if (arg0Value instanceof PInt) {
                    if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value);
                        if (arg1Value_ >= 0L) {
                            return false;
                        }
                        arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value);
                        if (arg1Value_ < 0L) {
                            return false;
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        if (arg1Value_.isZeroOrPositive()) {
                            return false;
                        }
                        arg1Value_ = (PInt)arg1Value;
                        if (!arg1Value_.isZeroOrPositive()) {
                            return false;
                        }
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1B6DB7) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x600000) >>> 21, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x600000) >>> 21, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x1800000) >>> 23, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x1800000) >>> 23, arg1Value);
                            ModNodeGen inliningTarget__ = this;
                            return IntBuiltins.ModNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0xB6) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE000000) >>> 25, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE000000) >>> 25, arg0Value);
                        if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000000) >>> 28, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000000) >>> 28, arg1Value);
                            ModNodeGen inliningTarget__1 = this;
                            return IntBuiltins.ModNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0xB4) != 0 && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            if ((state_0 & 4) != 0 && arg1Value_.isZeroOrPositive()) {
                                ModNodeGen inliningTarget__2 = this;
                                try {
                                    return IntBuiltins.ModNode.doLPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFFB;
                                    this.state_0_ = state_0 |= 8;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x10) != 0 && arg1Value_.isZeroOrPositive()) {
                                ModNodeGen inliningTarget__3 = this;
                                PythonLanguage language__ = PythonLanguage.get(this);
                                return IntBuiltins.ModNode.doLPi(arg0Value_, arg1Value_, inliningTarget__3, language__, INLINED_RAISE_NODE);
                            }
                            if ((state_0 & 0x20) != 0 && !arg1Value_.isZeroOrPositive()) {
                                ModNodeGen inliningTarget__4 = this;
                                try {
                                    return IntBuiltins.ModNode.doLPiNegativeAndNarrow(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFDF;
                                    this.state_0_ = state_0 |= 0x40;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x80) != 0 && !arg1Value_.isZeroOrPositive()) {
                                ModNodeGen inliningTarget__5 = this;
                                PythonLanguage language__1 = PythonLanguage.get(this);
                                return IntBuiltins.ModNode.doLPiNegative(arg0Value_, arg1Value_, inliningTarget__5, language__1, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0xB6D00) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x2D00) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000000) >>> 28, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000000) >>> 28, arg1Value);
                            if ((state_0 & 0x100) != 0 && arg1Value_ >= 0L) {
                                ModNodeGen inliningTarget__6 = this;
                                try {
                                    return IntBuiltins.ModNode.doPiLAndNarrow(arg0Value_, arg1Value_, inliningTarget__6, INLINED_RAISE_NODE);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFEFF;
                                    this.state_0_ = state_0 |= 0x200;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x400) != 0 && arg1Value_ >= 0L) {
                                ModNodeGen inliningTarget__7 = this;
                                PythonLanguage language__2 = PythonLanguage.get(this);
                                return IntBuiltins.ModNode.doPiL(arg0Value_, arg1Value_, inliningTarget__7, language__2, INLINED_RAISE_NODE);
                            }
                            if ((state_0 & 0x800) != 0 && arg1Value_ < 0L) {
                                ModNodeGen inliningTarget__8 = this;
                                try {
                                    return IntBuiltins.ModNode.doPiLNegAndNarrow(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFF7FF;
                                    this.state_0_ = state_0 |= 0x1000;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x2000) != 0 && arg1Value_ < 0L) {
                                ModNodeGen inliningTarget__9 = this;
                                PythonLanguage language__3 = PythonLanguage.get(this);
                                return IntBuiltins.ModNode.doPiLNeg(arg0Value_, arg1Value_, inliningTarget__9, language__3, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0xB4000) != 0 && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            if ((state_0 & 0x4000) != 0 && arg1Value_.isZeroOrPositive()) {
                                ModNodeGen inliningTarget__10 = this;
                                try {
                                    return IntBuiltins.ModNode.doPiPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__10, INLINED_RAISE_NODE);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFBFFF;
                                    this.state_0_ = state_0 |= 0x8000;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x10000) != 0 && arg1Value_.isZeroOrPositive()) {
                                ModNodeGen inliningTarget__11 = this;
                                PythonLanguage language__4 = PythonLanguage.get(this);
                                return IntBuiltins.ModNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__11, language__4, INLINED_RAISE_NODE);
                            }
                            if ((state_0 & 0x20000) != 0 && !arg1Value_.isZeroOrPositive()) {
                                try {
                                    return IntBuiltins.ModNode.doPiPiNegAndNarrow(arg0Value_, arg1Value_);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFDFFFF;
                                    this.state_0_ = state_0 |= 0x40000;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x80000) != 0 && !arg1Value_.isZeroOrPositive()) {
                                PythonLanguage language__5 = PythonLanguage.get(this);
                                return IntBuiltins.ModNode.doPiPiNeg(arg0Value_, arg1Value_, language__5);
                            }
                        }
                    }
                    if ((state_0 & 0x100000) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.ModNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x100003) != 0) {
                    if ((state_0 & 1) != 0) {
                        ModNodeGen inliningTarget__ = this;
                        return IntBuiltins.ModNode.doII(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE000000) >>> 25, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE000000) >>> 25, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000000) >>> 28, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000000) >>> 28, arg1Value);
                            ModNodeGen inliningTarget__1 = this;
                            return IntBuiltins.ModNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x100000) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.ModNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public int executeInt(int arg0Value, int arg1Value) throws UnexpectedResultException {
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    ModNodeGen inliningTarget__ = this;
                    return IntBuiltins.ModNode.doII(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ModNodeGen.expectInteger(this.executeAndSpecialize(arg0Value, arg1Value));
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int longCast0;
                int state_0 = this.state_0_;
                ModNodeGen inliningTarget__ = null;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        inliningTarget__ = this;
                        state_0 |= intCast0 << 21;
                        state_0 |= intCast1 << 23;
                        this.state_0_ = state_0 |= 1;
                        return IntBuiltins.ModNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                    }
                }
                if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    ModNodeGen inliningTarget__1 = null;
                    int longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        inliningTarget__1 = this;
                        state_0 |= longCast0 << 25;
                        state_0 |= longCast1 << 28;
                        this.state_0_ = state_0 |= 2;
                        return IntBuiltins.ModNode.doLL(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        ModNodeGen inliningTarget__2 = null;
                        if ((state_0 & 0x10) == 0 && (state_0 & 8) == 0 && arg1Value_.isZeroOrPositive()) {
                            inliningTarget__2 = this;
                            state_0 |= longCast0 << 25;
                            this.state_0_ = state_0 |= 4;
                            try {
                                return IntBuiltins.ModNode.doLPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_ = state_0 |= 8;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__ = null;
                        ModNodeGen inliningTarget__3 = null;
                        if (arg1Value_.isZeroOrPositive()) {
                            inliningTarget__3 = this;
                            language__ = PythonLanguage.get(this);
                            state_0 &= 0xFFFFFFFB;
                            state_0 |= longCast0 << 25;
                            this.state_0_ = state_0 |= 0x10;
                            return IntBuiltins.ModNode.doLPi(arg0Value_, arg1Value_, inliningTarget__3, language__, INLINED_RAISE_NODE);
                        }
                        ModNodeGen inliningTarget__4 = null;
                        if ((state_0 & 0x80) == 0 && (state_0 & 0x40) == 0 && !arg1Value_.isZeroOrPositive()) {
                            inliningTarget__4 = this;
                            state_0 |= longCast0 << 25;
                            this.state_0_ = state_0 |= 0x20;
                            try {
                                return IntBuiltins.ModNode.doLPiNegativeAndNarrow(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_ = state_0 |= 0x40;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__1 = null;
                        ModNodeGen inliningTarget__5 = null;
                        if (!arg1Value_.isZeroOrPositive()) {
                            inliningTarget__5 = this;
                            language__1 = PythonLanguage.get(this);
                            state_0 &= 0xFFFFFFDF;
                            state_0 |= longCast0 << 25;
                            this.state_0_ = state_0 |= 0x80;
                            return IntBuiltins.ModNode.doLPiNegative(arg0Value_, arg1Value_, inliningTarget__5, language__1, INLINED_RAISE_NODE);
                        }
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    int longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        ModNodeGen inliningTarget__6 = null;
                        if ((state_0 & 0x400) == 0 && (state_0 & 0x200) == 0 && arg1Value_ >= 0L) {
                            inliningTarget__6 = this;
                            state_0 |= longCast1 << 28;
                            this.state_0_ = state_0 |= 0x100;
                            try {
                                return IntBuiltins.ModNode.doPiLAndNarrow(arg0Value_, arg1Value_, inliningTarget__6, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFEFF;
                                this.state_0_ = state_0 |= 0x200;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__2 = null;
                        ModNodeGen inliningTarget__7 = null;
                        if (arg1Value_ >= 0L) {
                            inliningTarget__7 = this;
                            language__2 = PythonLanguage.get(this);
                            state_0 &= 0xFFFFFEFF;
                            state_0 |= longCast1 << 28;
                            this.state_0_ = state_0 |= 0x400;
                            return IntBuiltins.ModNode.doPiL(arg0Value_, arg1Value_, inliningTarget__7, language__2, INLINED_RAISE_NODE);
                        }
                        ModNodeGen inliningTarget__8 = null;
                        if ((state_0 & 0x2000) == 0 && (state_0 & 0x1000) == 0 && arg1Value_ < 0L) {
                            inliningTarget__8 = this;
                            state_0 |= longCast1 << 28;
                            this.state_0_ = state_0 |= 0x800;
                            try {
                                return IntBuiltins.ModNode.doPiLNegAndNarrow(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFF7FF;
                                this.state_0_ = state_0 |= 0x1000;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__3 = null;
                        ModNodeGen inliningTarget__9 = null;
                        if (arg1Value_ < 0L) {
                            inliningTarget__9 = this;
                            language__3 = PythonLanguage.get(this);
                            state_0 &= 0xFFFFF7FF;
                            state_0 |= longCast1 << 28;
                            this.state_0_ = state_0 |= 0x2000;
                            return IntBuiltins.ModNode.doPiLNeg(arg0Value_, arg1Value_, inliningTarget__9, language__3, INLINED_RAISE_NODE);
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        ModNodeGen inliningTarget__10 = null;
                        if ((state_0 & 0x10000) == 0 && (state_0 & 0x8000) == 0 && arg1Value_.isZeroOrPositive()) {
                            inliningTarget__10 = this;
                            this.state_0_ = state_0 |= 0x4000;
                            try {
                                return IntBuiltins.ModNode.doPiPiAndNarrow(arg0Value_, arg1Value_, inliningTarget__10, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFBFFF;
                                this.state_0_ = state_0 |= 0x8000;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__4 = null;
                        ModNodeGen inliningTarget__11 = null;
                        if (arg1Value_.isZeroOrPositive()) {
                            inliningTarget__11 = this;
                            language__4 = PythonLanguage.get(this);
                            state_0 &= 0xFFFFBFFF;
                            this.state_0_ = state_0 |= 0x10000;
                            return IntBuiltins.ModNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__11, language__4, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x80000) == 0 && (state_0 & 0x40000) == 0 && !arg1Value_.isZeroOrPositive()) {
                            this.state_0_ = state_0 |= 0x20000;
                            try {
                                return IntBuiltins.ModNode.doPiPiNegAndNarrow(arg0Value_, arg1Value_);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFDFFFF;
                                this.state_0_ = state_0 |= 0x40000;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        PythonLanguage language__5 = null;
                        if (!arg1Value_.isZeroOrPositive()) {
                            language__5 = PythonLanguage.get(this);
                            state_0 &= 0xFFFDFFFF;
                            this.state_0_ = state_0 |= 0x80000;
                            return IntBuiltins.ModNode.doPiPiNeg(arg0Value_, arg1Value_, language__5);
                        }
                    }
                }
                this.state_0_ = state_0 |= 0x100000;
                return IntBuiltins.ModNode.doGeneric(arg0Value, arg1Value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.MulNode.class)
    public static final class MulNodeFactory
    implements NodeFactory<IntBuiltins.MulNode> {
        private static final MulNodeFactory MUL_NODE_FACTORY_INSTANCE = new MulNodeFactory();

        private MulNodeFactory() {
        }

        public Class<IntBuiltins.MulNode> getNodeClass() {
            return IntBuiltins.MulNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.MulNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return MulNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.MulNode> getInstance() {
            return MUL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.MulNode create() {
            return new MulNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.MulNode.class)
        public static final class MulNodeGen
        extends IntBuiltins.MulNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private MulNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                long arg0Value_;
                long arg1Value_;
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (((state_0 & 0x20) == 0 || (state_0 & 0xFC0000) != 0xFC0000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (arg0Value instanceof PInt && (arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value)) == 0L) {
                        return false;
                    }
                }
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value) && arg1Value instanceof PInt && (arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value)) == 0L) {
                    return false;
                }
                if (arg0Value instanceof PInt && PythonIntegerTypesGen.isImplicitLong(arg1Value) && (arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value)) == 1L) {
                    return false;
                }
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value) && arg1Value instanceof PInt && (arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value)) == 1L) {
                    return false;
                }
                if (arg0Value instanceof PInt && PythonIntegerTypesGen.isImplicitLong(arg1Value) && (arg1Value_ = PythonIntegerTypesGen.asImplicitLong(arg1Value)) != 0L && arg1Value_ != 1L) {
                    return false;
                }
                if (arg1Value instanceof PInt) {
                    if (PythonIntegerTypesGen.isImplicitLong(arg0Value) && (arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value)) != 0L && arg0Value_ != 1L) {
                        return false;
                    }
                    if ((state_0 & 0x1000) == 0 && arg0Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x3FED) != 0) {
                    if ((state_0 & 5) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xC000) >>> 14, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xC000) >>> 14, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x30000) >>> 16, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x30000) >>> 16, arg1Value);
                            if ((state_0 & 1) != 0) {
                                try {
                                    return IntBuiltins.MulNode.doII(arg0Value_, arg1Value_);
                                }
                                catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFFE;
                                    this.state_0_ = state_0 |= 2;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 4) != 0) {
                                return IntBuiltins.MulNode.doIIL(arg0Value_, arg1Value_);
                            }
                        }
                    }
                    if ((state_0 & 0x68) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value);
                        if ((state_0 & 0x28) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value);
                            if ((state_0 & 8) != 0) {
                                try {
                                    return IntBuiltins.MulNode.doLL(arg0Value_, arg1Value_);
                                }
                                catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFF7;
                                    this.state_0_ = state_0 |= 0x10;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x20) != 0) {
                                MulNodeGen inliningTarget__ = this;
                                return IntBuiltins.MulNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                            }
                        }
                        if ((state_0 & 0x40) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            if (arg1Value_ == 0L) {
                                return IntBuiltins.MulNode.doPIntLongZero(arg0Value_, arg1Value_);
                            }
                        }
                    }
                    if ((state_0 & 0x80) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            if (arg0Value_ == 0L) {
                                return IntBuiltins.MulNode.doPIntLongZero(arg0Value_, arg1Value_);
                            }
                        }
                    }
                    if ((state_0 & 0x100) != 0 && arg0Value instanceof PInt) {
                        long arg1Value_;
                        PInt arg0Value_ = (PInt)arg0Value;
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value) && (arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value)) == 1L) {
                            PythonLanguage language__ = PythonLanguage.get(this);
                            return IntBuiltins.MulNode.doPIntLongOne(arg0Value_, arg1Value_, language__);
                        }
                    }
                    if ((state_0 & 0x200) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            if (arg0Value_ == 1L) {
                                PythonLanguage language__1 = PythonLanguage.get(this);
                                return this.doPIntLongOne(arg0Value_, arg1Value_, language__1);
                            }
                        }
                    }
                    if ((state_0 & 0x400) != 0 && arg0Value instanceof PInt) {
                        long arg1Value_;
                        PInt arg0Value_ = (PInt)arg0Value;
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value) && (arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value)) != 0L && arg1Value_ != 1L) {
                            PythonLanguage language__2 = PythonLanguage.get(this);
                            return IntBuiltins.MulNode.doPIntLong(arg0Value_, arg1Value_, language__2);
                        }
                    }
                    if ((state_0 & 0x1800) != 0 && arg1Value instanceof PInt) {
                        long arg0Value_;
                        PInt arg1Value_ = (PInt)arg1Value;
                        if ((state_0 & 0x800) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value) && (arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value)) != 0L && arg0Value_ != 1L) {
                            PythonLanguage language__3 = PythonLanguage.get(this);
                            return this.doPIntLong(arg0Value_, arg1Value_, language__3);
                        }
                        if ((state_0 & 0x1000) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_2 = (PInt)arg0Value;
                            PythonLanguage language__4 = PythonLanguage.get(this);
                            return IntBuiltins.MulNode.doPIntPInt(arg0Value_2, arg1Value_, language__4);
                        }
                    }
                    if ((state_0 & 0x2000) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.MulNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x202D) != 0) {
                    if ((state_0 & 5) != 0) {
                        if ((state_0 & 1) != 0) {
                            try {
                                return IntBuiltins.MulNode.doII(arg0Value, arg1Value);
                            }
                            catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFE;
                                this.state_0_ = state_0 |= 2;
                                return this.executeAndSpecialize(arg0Value, arg1Value);
                            }
                        }
                        if ((state_0 & 4) != 0) {
                            return IntBuiltins.MulNode.doIIL(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0x28) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C0000) >>> 18, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg1Value);
                            if ((state_0 & 8) != 0) {
                                try {
                                    return IntBuiltins.MulNode.doLL(arg0Value_, arg1Value_);
                                }
                                catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFF7;
                                    this.state_0_ = state_0 |= 0x10;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 0x20) != 0) {
                                MulNodeGen inliningTarget__ = this;
                                return IntBuiltins.MulNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                            }
                        }
                    }
                    if ((state_0 & 0x2000) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.MulNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int longCast0;
                int longCast1;
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        if ((state_0 & 4) == 0 && (state_0 & 2) == 0) {
                            state_0 |= intCast0 << 14;
                            state_0 |= intCast1 << 16;
                            this.state_0_ = state_0 |= 1;
                            try {
                                return IntBuiltins.MulNode.doII(arg0Value_, arg1Value_);
                            }
                            catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFE;
                                this.state_0_ = state_0 |= 2;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        state_0 &= 0xFFFFFFFE;
                        state_0 |= intCast0 << 14;
                        state_0 |= intCast1 << 16;
                        this.state_0_ = state_0 |= 4;
                        return IntBuiltins.MulNode.doIIL(arg0Value_, arg1Value_);
                    }
                }
                if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                    int longCast02 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast02 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast02, arg0Value);
                        if ((state_0 & 0x20) == 0 && (state_0 & 0x10) == 0) {
                            state_0 |= longCast02 << 18;
                            state_0 |= longCast1 << 21;
                            this.state_0_ = state_0 |= 8;
                            try {
                                return IntBuiltins.MulNode.doLL(arg0Value_, arg1Value_);
                            }
                            catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFF7;
                                this.state_0_ = state_0 |= 0x10;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        MulNodeGen inliningTarget__ = null;
                        inliningTarget__ = this;
                        state_0 &= 0xFFFFFFF7;
                        state_0 |= longCast02 << 18;
                        state_0 |= longCast1 << 21;
                        this.state_0_ = state_0 |= 0x20;
                        return IntBuiltins.MulNode.doLongWithOverflow(arg0Value_, arg1Value_, inliningTarget__);
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if (arg1Value_ == 0L) {
                            state_0 |= longCast1 << 21;
                            this.state_0_ = state_0 |= 0x40;
                            return IntBuiltins.MulNode.doPIntLongZero(arg0Value_, arg1Value_);
                        }
                    }
                }
                if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        if (arg0Value_ == 0L) {
                            state_0 |= longCast0 << 18;
                            this.state_0_ = state_0 |= 0x80;
                            return IntBuiltins.MulNode.doPIntLongZero(arg0Value_, arg1Value_);
                        }
                    }
                }
                PythonLanguage language__ = null;
                if (arg0Value instanceof PInt) {
                    long arg1Value_;
                    PInt arg0Value_ = (PInt)arg0Value;
                    int longCast12 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast12 != 0 && (arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast12, arg1Value)) == 1L) {
                        language__ = PythonLanguage.get(this);
                        state_0 |= longCast12 << 21;
                        this.state_0_ = state_0 |= 0x100;
                        return IntBuiltins.MulNode.doPIntLongOne(arg0Value_, arg1Value_, language__);
                    }
                }
                PythonLanguage language__1 = null;
                int longCast03 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast03 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast03, arg0Value);
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        if (arg0Value_ == 1L) {
                            language__1 = PythonLanguage.get(this);
                            state_0 |= longCast03 << 18;
                            this.state_0_ = state_0 |= 0x200;
                            return this.doPIntLongOne(arg0Value_, arg1Value_, language__1);
                        }
                    }
                }
                PythonLanguage language__2 = null;
                if (arg0Value instanceof PInt) {
                    long arg1Value_;
                    PInt arg0Value_ = (PInt)arg0Value;
                    int longCast13 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast13 != 0 && (arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast13, arg1Value)) != 0L && arg1Value_ != 1L) {
                        language__2 = PythonLanguage.get(this);
                        state_0 |= longCast13 << 21;
                        this.state_0_ = state_0 |= 0x400;
                        return IntBuiltins.MulNode.doPIntLong(arg0Value_, arg1Value_, language__2);
                    }
                }
                if (arg1Value instanceof PInt) {
                    long arg0Value_;
                    PInt arg1Value_ = (PInt)arg1Value;
                    PythonLanguage language__3 = null;
                    int longCast04 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast04 != 0 && (arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast04, arg0Value)) != 0L && arg0Value_ != 1L) {
                        language__3 = PythonLanguage.get(this);
                        state_0 |= longCast04 << 18;
                        this.state_0_ = state_0 |= 0x800;
                        return this.doPIntLong(arg0Value_, arg1Value_, language__3);
                    }
                    PythonLanguage language__4 = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_2 = (PInt)arg0Value;
                        language__4 = PythonLanguage.get(this);
                        this.state_0_ = state_0 |= 0x1000;
                        return IntBuiltins.MulNode.doPIntPInt(arg0Value_2, arg1Value_, language__4);
                    }
                }
                this.state_0_ = state_0 |= 0x2000;
                return IntBuiltins.MulNode.doGeneric(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.PowNode.class)
    public static final class PowNodeFactory
    implements NodeFactory<IntBuiltins.PowNode> {
        private static final PowNodeFactory POW_NODE_FACTORY_INSTANCE = new PowNodeFactory();

        private PowNodeFactory() {
        }

        public Class<IntBuiltins.PowNode> getNodeClass() {
            return IntBuiltins.PowNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.PowNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return PowNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.PowNode> getInstance() {
            return POW_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.PowNode create() {
            return new PowNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.PowNode.class)
        public static final class PowNodeGen
        extends IntBuiltins.PowNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedConditionProfile INLINED_LEFT_IS_ZERO = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(30, 2)}));
            private static final InlineSupport.StateField STATE_1_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_UPDATER.subUpdater(0, 1)}));
            private static final InlineSupport.StateField STATE_1_PowNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final InlinedConditionProfile INLINED_L_LPOS_LGENERIC_MOD_NEGATIVE_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_PowNode_UPDATER.subUpdater(1, 2)}));
            private static final PRaiseNode INLINED_L_LPOS_LGENERIC_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_PowNode_UPDATER.subUpdater(3, 1)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_1_;

            private PowNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1FB75) != 0) {
                    if ((state_0 & 0x3B75) != 0 && arg2Value instanceof PNone) {
                        PNone arg2Value_ = (PNone)arg2Value;
                        if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60000) >>> 17, arg0Value)) {
                            int arg1Value_;
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60000) >>> 17, arg0Value);
                            if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x180000) >>> 19, arg1Value) && (arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x180000) >>> 19, arg1Value)) >= 0) {
                                try {
                                    return IntBuiltins.PowNode.doIIFast(arg0Value_, arg1Value_, arg2Value_);
                                }
                                catch (ArithmeticException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFFE;
                                    this.state_0_ = state_0 |= 2;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                }
                            }
                        }
                        if ((state_0 & 0x174) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value);
                            if ((state_0 & 0x34) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value)) {
                                long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value);
                                if ((state_0 & 4) != 0 && arg1Value_ >= 0L) {
                                    try {
                                        return IntBuiltins.PowNode.doLLFast(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                    catch (ArithmeticException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 &= 0xFFFFFFFB;
                                        this.state_0_ = state_0 |= 8;
                                        return this.executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                                if ((state_0 & 0x10) != 0 && arg1Value_ >= 0L) {
                                    PythonLanguage language__ = PythonLanguage.get(this);
                                    return this.doLLPos(arg0Value_, arg1Value_, arg2Value_, language__);
                                }
                                if ((state_0 & 0x20) != 0 && arg1Value_ < 0L) {
                                    PowNodeGen inliningTarget__ = this;
                                    return this.doLLNeg(arg0Value_, arg1Value_, arg2Value_, inliningTarget__, INLINED_LEFT_IS_ZERO, INLINED_RAISE_NODE);
                                }
                            }
                            if ((state_0 & 0x140) != 0 && arg1Value instanceof PInt) {
                                PInt arg1Value_ = (PInt)arg1Value;
                                if ((state_0 & 0x40) != 0) {
                                    PowNodeGen inliningTarget__1 = this;
                                    try {
                                        return this.doLPNarrow(arg0Value_, arg1Value_, arg2Value_, inliningTarget__1, INLINED_LEFT_IS_ZERO, INLINED_RAISE_NODE);
                                    }
                                    catch (OverflowException | ArithmeticException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 &= 0xFFFFFFBF;
                                        this.state_0_ = state_0 |= 0x80;
                                        return this.executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                                if ((state_0 & 0x100) != 0) {
                                    return this.doLP(arg0Value_, arg1Value_, arg2Value_);
                                }
                            }
                        }
                        if ((state_0 & 0x3A00) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            if ((state_0 & 0x1A00) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value)) {
                                long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value);
                                if ((state_0 & 0x200) != 0 && arg1Value_ >= 0L) {
                                    try {
                                        return this.doPLNarrow(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                    catch (OverflowException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 &= 0xFFFFFDFF;
                                        this.state_0_ = state_0 |= 0x400;
                                        return this.executeAndSpecialize(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                                if ((state_0 & 0x800) != 0 && arg1Value_ >= 0L) {
                                    PythonLanguage language__1 = PythonLanguage.get(this);
                                    return this.doPLPos(arg0Value_, arg1Value_, arg2Value_, language__1);
                                }
                                if ((state_0 & 0x1000) != 0 && arg1Value_ < 0L) {
                                    PowNodeGen inliningTarget__2 = this;
                                    return this.doPLNeg(arg0Value_, arg1Value_, arg2Value_, inliningTarget__2, INLINED_LEFT_IS_ZERO, INLINED_RAISE_NODE);
                                }
                            }
                            if ((state_0 & 0x2000) != 0 && arg1Value instanceof PInt) {
                                PInt arg1Value_ = (PInt)arg1Value;
                                return this.doPP(arg0Value_, arg1Value_, arg2Value_);
                            }
                        }
                    }
                    if ((state_0 & 0x18000) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value);
                            if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x38000000) >>> 27, arg2Value)) {
                                long arg2Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x38000000) >>> 27, arg2Value);
                                if ((state_0 & 0x8000) != 0 && arg1Value_ >= 0L && arg2Value_ > 0L) {
                                    return IntBuiltins.PowNode.doLLPosLPos(arg0Value_, arg1Value_, arg2Value_);
                                }
                                if ((state_0 & 0x10000) != 0 && arg1Value_ >= 0L) {
                                    PowNodeGen inliningTarget__3 = this;
                                    return IntBuiltins.PowNode.doLLPosLGeneric(arg0Value_, arg1Value_, arg2Value_, inliningTarget__3, INLINED_L_LPOS_LGENERIC_MOD_NEGATIVE_PROFILE_, INLINED_L_LPOS_LGENERIC_RAISE_NODE_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x4000) != 0) {
                        return this.powModulo(arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @Override
            protected Object execute(int arg0Value, int arg1Value, PNone arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x4035) != 0) {
                    if ((state_0 & 0x35) != 0) {
                        if ((state_0 & 1) != 0 && arg1Value >= 0) {
                            try {
                                return IntBuiltins.PowNode.doIIFast(arg0Value, arg1Value, arg2Value);
                            }
                            catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFE;
                                this.state_0_ = state_0 |= 2;
                                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
                            }
                        }
                        if ((state_0 & 0x34) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value);
                            if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value)) {
                                long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value);
                                if ((state_0 & 4) != 0 && arg1Value_ >= 0L) {
                                    try {
                                        return IntBuiltins.PowNode.doLLFast(arg0Value_, arg1Value_, arg2Value);
                                    }
                                    catch (ArithmeticException ex) {
                                        CompilerDirectives.transferToInterpreterAndInvalidate();
                                        state_0 = this.state_0_;
                                        state_0 &= 0xFFFFFFFB;
                                        this.state_0_ = state_0 |= 8;
                                        return this.executeAndSpecialize(arg0Value_, arg1Value_, arg2Value);
                                    }
                                }
                                if ((state_0 & 0x10) != 0 && arg1Value_ >= 0L) {
                                    PythonLanguage language__ = PythonLanguage.get(this);
                                    return this.doLLPos(arg0Value_, arg1Value_, arg2Value, language__);
                                }
                                if ((state_0 & 0x20) != 0 && arg1Value_ < 0L) {
                                    PowNodeGen inliningTarget__ = this;
                                    return this.doLLNeg(arg0Value_, arg1Value_, arg2Value, inliningTarget__, INLINED_LEFT_IS_ZERO, INLINED_RAISE_NODE);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x4000) != 0) {
                        return this.powModulo(arg0Value, arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            @Override
            protected int executeInt(int arg0Value, int arg1Value, PNone arg2Value) throws UnexpectedResultException {
                int state_0 = this.state_0_;
                if ((state_0 & 0x4000) != 0) {
                    return PowNodeGen.expectInteger(this.execute(null, arg0Value, arg1Value, arg2Value));
                }
                if ((state_0 & 1) != 0 && arg1Value >= 0) {
                    try {
                        return IntBuiltins.PowNode.doIIFast(arg0Value, arg1Value, arg2Value);
                    }
                    catch (ArithmeticException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        return PowNodeGen.expectInteger(this.executeAndSpecialize(arg0Value, arg1Value, arg2Value));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return PowNodeGen.expectInteger(this.executeAndSpecialize(arg0Value, arg1Value, arg2Value));
            }

            /*
             * Exception decompiling
             */
            private Object executeAndSpecialize(Object arg0Value, Object arg1Value, Object arg2Value) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private void checkForPolymorphicSpecialize(int oldState_0) {
                int state_0 = this.state_0_;
                int newState_0 = state_0 & 0x1FFFF;
                if ((oldState_0 ^ newState_0) != 0) {
                    this.reportPolymorphicSpecialize();
                }
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.AbsNode.class)
    static final class AbsNodeFactory
    implements NodeFactory<IntBuiltins.AbsNode> {
        private static final AbsNodeFactory ABS_NODE_FACTORY_INSTANCE = new AbsNodeFactory();

        private AbsNodeFactory() {
        }

        public Class<IntBuiltins.AbsNode> getNodeClass() {
            return IntBuiltins.AbsNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.AbsNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return AbsNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.AbsNode> getInstance() {
            return ABS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.AbsNode create() {
            return new AbsNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.AbsNode.class)
        static final class AbsNodeGen
        extends IntBuiltins.AbsNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private AbsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                        int arg0Value_ = (Integer)arg0Value;
                        return IntBuiltins.AbsNode.absInt(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof Long) {
                        long arg0Value_ = (Long)arg0Value;
                        AbsNodeGen inliningTarget__ = this;
                        return IntBuiltins.AbsNode.absLong(arg0Value_, inliningTarget__);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        PythonLanguage language__ = PythonLanguage.get(this);
                        return IntBuiltins.AbsNode.absPInt(arg0Value_, language__);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (Boolean)arg0Value;
                        return IntBuiltins.AbsNode.absBoolean(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.AbsNode.absInt(arg0Value_);
                }
                AbsNodeGen inliningTarget__ = null;
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    inliningTarget__ = this;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.AbsNode.absLong(arg0Value_, inliningTarget__);
                }
                PythonLanguage language__ = null;
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    language__ = PythonLanguage.get(this);
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.AbsNode.absPInt(arg0Value_, language__);
                }
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    this.state_0_ = state_0 |= 8;
                    return IntBuiltins.AbsNode.absBoolean(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.CeilNode.class)
    static final class CeilNodeFactory
    implements NodeFactory<IntBuiltins.CeilNode> {
        private static final CeilNodeFactory CEIL_NODE_FACTORY_INSTANCE = new CeilNodeFactory();

        private CeilNodeFactory() {
        }

        public Class<IntBuiltins.CeilNode> getNodeClass() {
            return IntBuiltins.CeilNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.CeilNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return CeilNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.CeilNode> getInstance() {
            return CEIL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.CeilNode create() {
            return new CeilNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.CeilNode.class)
        static final class CeilNodeGen
        extends IntBuiltins.CeilNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private CeilNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x18) >>> 3, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x18) >>> 3, arg0Value);
                        return IntBuiltins.CeilNode.ceil(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE0) >>> 5, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE0) >>> 5, arg0Value);
                        return IntBuiltins.CeilNode.ceil(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return IntBuiltins.CeilNode.ceil(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    state_0 |= intCast0 << 3;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.CeilNode.ceil(arg0Value_);
                }
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 5;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.CeilNode.ceil(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.CeilNode.ceil(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.FloorNode.class)
    static final class FloorNodeFactory
    implements NodeFactory<IntBuiltins.FloorNode> {
        private static final FloorNodeFactory FLOOR_NODE_FACTORY_INSTANCE = new FloorNodeFactory();

        private FloorNodeFactory() {
        }

        public Class<IntBuiltins.FloorNode> getNodeClass() {
            return IntBuiltins.FloorNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.FloorNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FloorNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.FloorNode> getInstance() {
            return FLOOR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.FloorNode create() {
            return new FloorNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.FloorNode.class)
        static final class FloorNodeGen
        extends IntBuiltins.FloorNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private FloorNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x18) >>> 3, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x18) >>> 3, arg0Value);
                        return IntBuiltins.FloorNode.floor(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE0) >>> 5, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE0) >>> 5, arg0Value);
                        return IntBuiltins.FloorNode.floor(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        PythonLanguage language__ = PythonLanguage.get(this);
                        return IntBuiltins.FloorNode.floor(arg0Value_, language__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    state_0 |= intCast0 << 3;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.FloorNode.floor(arg0Value_);
                }
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 5;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.FloorNode.floor(arg0Value_);
                }
                PythonLanguage language__ = null;
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    language__ = PythonLanguage.get(this);
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.FloorNode.floor(arg0Value_, language__);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.PosNode.class)
    static final class PosNodeFactory
    implements NodeFactory<IntBuiltins.PosNode> {
        private static final PosNodeFactory POS_NODE_FACTORY_INSTANCE = new PosNodeFactory();

        private PosNodeFactory() {
        }

        public Class<IntBuiltins.PosNode> getNodeClass() {
            return IntBuiltins.PosNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.PosNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return PosNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.PosNode> getInstance() {
            return POS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.PosNode create() {
            return new PosNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.PosNode.class)
        static final class PosNodeGen
        extends IntBuiltins.PosNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private PosNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof Integer) {
                        Integer arg0Value_ = (Integer)arg0Value;
                        return IntBuiltins.PosNode.pos(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof Long) {
                        Long arg0Value_ = (Long)arg0Value;
                        return IntBuiltins.PosNode.pos(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        PythonLanguage language__ = PythonLanguage.get(this);
                        return IntBuiltins.PosNode.pos(arg0Value_, language__);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (Boolean)arg0Value;
                        return IntBuiltins.PosNode.pos(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    Integer arg0Value_ = (Integer)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.PosNode.pos(arg0Value_);
                }
                if (arg0Value instanceof Long) {
                    Long arg0Value_ = (Long)arg0Value;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.PosNode.pos(arg0Value_);
                }
                PythonLanguage language__ = null;
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    language__ = PythonLanguage.get(this);
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.PosNode.pos(arg0Value_, language__);
                }
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    this.state_0_ = state_0 |= 8;
                    return IntBuiltins.PosNode.pos(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.NegNode.class)
    public static final class NegNodeFactory
    implements NodeFactory<IntBuiltins.NegNode> {
        private static final NegNodeFactory NEG_NODE_FACTORY_INSTANCE = new NegNodeFactory();

        private NegNodeFactory() {
        }

        public Class<IntBuiltins.NegNode> getNodeClass() {
            return IntBuiltins.NegNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.NegNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return NegNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.NegNode> getInstance() {
            return NEG_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.NegNode create() {
            return new NegNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.NegNode.class)
        public static final class NegNodeGen
        extends IntBuiltins.NegNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private NegNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xED) != 0) {
                    int arg0Value_;
                    if ((state_0 & 5) != 0 && arg0Value instanceof Integer) {
                        arg0Value_ = (Integer)arg0Value;
                        if ((state_0 & 1) != 0) {
                            try {
                                return IntBuiltins.NegNode.neg(arg0Value_);
                            }
                            catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFE;
                                this.state_0_ = state_0 |= 2;
                                return this.executeAndSpecialize(arg0Value_);
                            }
                        }
                        if ((state_0 & 4) != 0) {
                            return IntBuiltins.NegNode.negOvf(arg0Value_);
                        }
                    }
                    if ((state_0 & 0x28) != 0 && arg0Value instanceof Long) {
                        long arg0Value_2 = (Long)arg0Value;
                        if ((state_0 & 8) != 0) {
                            try {
                                return IntBuiltins.NegNode.neg(arg0Value_2);
                            }
                            catch (ArithmeticException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFF7;
                                this.state_0_ = state_0 |= 0x10;
                                return this.executeAndSpecialize(arg0Value_2);
                            }
                        }
                        if ((state_0 & 0x20) != 0) {
                            PythonLanguage language__ = PythonLanguage.get(this);
                            return IntBuiltins.NegNode.negOvf(arg0Value_2, language__);
                        }
                    }
                    if ((state_0 & 0x40) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_3 = (PInt)arg0Value;
                        PythonLanguage language__1 = PythonLanguage.get(this);
                        return IntBuiltins.NegNode.doPInt(arg0Value_3, language__1);
                    }
                    if ((state_0 & 0x80) != 0 && arg0Value instanceof Boolean) {
                        arg0Value_ = ((Boolean)arg0Value).booleanValue() ? 1 : 0;
                        return IntBuiltins.NegNode.doBoolean(arg0Value_ != 0);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            @Override
            public Object execute(int arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 5) != 0) {
                    if ((state_0 & 1) != 0) {
                        try {
                            return IntBuiltins.NegNode.neg(arg0Value);
                        }
                        catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            return this.executeAndSpecialize(arg0Value);
                        }
                    }
                    if ((state_0 & 4) != 0) {
                        return IntBuiltins.NegNode.negOvf(arg0Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    if ((state_0 & 2) == 0) {
                        this.state_0_ = state_0 |= 1;
                        try {
                            return IntBuiltins.NegNode.neg(arg0Value_);
                        }
                        catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            return this.executeAndSpecialize(arg0Value_);
                        }
                    }
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.NegNode.negOvf(arg0Value_);
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    if ((state_0 & 0x10) == 0) {
                        this.state_0_ = state_0 |= 8;
                        try {
                            return IntBuiltins.NegNode.neg(arg0Value_);
                        }
                        catch (ArithmeticException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFF7;
                            this.state_0_ = state_0 |= 0x10;
                            return this.executeAndSpecialize(arg0Value_);
                        }
                    }
                    PythonLanguage language__ = null;
                    language__ = PythonLanguage.get(this);
                    this.state_0_ = state_0 |= 0x20;
                    return IntBuiltins.NegNode.negOvf(arg0Value_, language__);
                }
                PythonLanguage language__1 = null;
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    language__1 = PythonLanguage.get(this);
                    this.state_0_ = state_0 |= 0x40;
                    return IntBuiltins.NegNode.doPInt(arg0Value_, language__1);
                }
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    this.state_0_ = state_0 |= 0x80;
                    return IntBuiltins.NegNode.doBoolean(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.InvertNode.class)
    static final class InvertNodeFactory
    implements NodeFactory<IntBuiltins.InvertNode> {
        private static final InvertNodeFactory INVERT_NODE_FACTORY_INSTANCE = new InvertNodeFactory();

        private InvertNodeFactory() {
        }

        public Class<IntBuiltins.InvertNode> getNodeClass() {
            return IntBuiltins.InvertNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.InvertNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return InvertNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.InvertNode> getInstance() {
            return INVERT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.InvertNode create() {
            return new InvertNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.InvertNode.class)
        static final class InvertNodeGen
        extends IntBuiltins.InvertNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private InvertNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (Boolean)arg0Value;
                        return IntBuiltins.InvertNode.neg(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof Integer) {
                        int arg0Value_ = (Integer)arg0Value;
                        return IntBuiltins.InvertNode.neg(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof Long) {
                        long arg0Value_ = (Long)arg0Value;
                        return IntBuiltins.InvertNode.neg(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        PythonLanguage language__ = PythonLanguage.get(this);
                        return IntBuiltins.InvertNode.doPInt(arg0Value_, language__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.InvertNode.neg(arg0Value_);
                }
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.InvertNode.neg(arg0Value_);
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.InvertNode.neg(arg0Value_);
                }
                PythonLanguage language__ = null;
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    language__ = PythonLanguage.get(this);
                    this.state_0_ = state_0 |= 8;
                    return IntBuiltins.InvertNode.doPInt(arg0Value_, language__);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.LShiftNode.class)
    public static final class LShiftNodeFactory
    implements NodeFactory<IntBuiltins.LShiftNode> {
        private static final LShiftNodeFactory LSHIFT_NODE_FACTORY_INSTANCE = new LShiftNodeFactory();

        private LShiftNodeFactory() {
        }

        public Class<IntBuiltins.LShiftNode> getNodeClass() {
            return IntBuiltins.LShiftNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.LShiftNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return LShiftNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.LShiftNode> getInstance() {
            return LSHIFT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.LShiftNode create() {
            return new LShiftNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.LShiftNode.class)
        public static final class LShiftNodeGen
        extends IntBuiltins.LShiftNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(27, 1)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private LShiftNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    if (((state_0 & 0x80) == 0 || (state_0 & 0x7E00000) != 0x7E00000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (((state_0 & 0x800) == 0 || (state_0 & 0xE00000) != 0xE00000) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg0Value instanceof PInt) {
                    if (((state_0 & 0x2000) == 0 || (state_0 & 0x7000000) != 0x7000000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if ((state_0 & 0x8000) == 0 && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1FFED) != 0) {
                    if ((state_0 & 5) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60000) >>> 17, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60000) >>> 17, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x180000) >>> 19, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x180000) >>> 19, arg1Value);
                            if ((state_0 & 1) != 0) {
                                LShiftNodeGen inliningTarget__ = this;
                                try {
                                    return IntBuiltins.LShiftNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                                }
                                catch (OverflowException ex) {
                                    CompilerDirectives.transferToInterpreterAndInvalidate();
                                    state_0 = this.state_0_;
                                    state_0 &= 0xFFFFFFFE;
                                    this.state_0_ = state_0 |= 2;
                                    return this.executeAndSpecialize(arg0Value_, arg1Value_);
                                }
                            }
                            if ((state_0 & 4) != 0) {
                                LShiftNodeGen inliningTarget__1 = this;
                                return IntBuiltins.LShiftNode.doIIOvf(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0x28) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value);
                        if ((state_0 & 8) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value);
                            LShiftNodeGen inliningTarget__2 = this;
                            try {
                                return IntBuiltins.LShiftNode.doLL(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFF7;
                                this.state_0_ = state_0 |= 0x10;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        if ((state_0 & 0x20) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60000) >>> 17, arg0Value)) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60000) >>> 17, arg0Value);
                            LShiftNodeGen inliningTarget__3 = this;
                            return IntBuiltins.LShiftNode.doILOvf(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0xC0) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value);
                        if ((state_0 & 0x40) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x180000) >>> 19, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x180000) >>> 19, arg1Value);
                            LShiftNodeGen inliningTarget__4 = this;
                            return IntBuiltins.LShiftNode.doLIOvf(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x80) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value);
                            LShiftNodeGen inliningTarget__5 = this;
                            return IntBuiltins.LShiftNode.doLLOvf(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0xF00) != 0 && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        if ((state_0 & 0x300) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60000) >>> 17, arg0Value)) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60000) >>> 17, arg0Value);
                            if ((state_0 & 0x100) != 0 && arg0Value_ == 0 && arg1Value_.isZeroOrPositive()) {
                                return IntBuiltins.LShiftNode.doIPiZero(arg0Value_, arg1Value_);
                            }
                            if ((state_0 & 0x200) != 0) {
                                LShiftNodeGen inliningTarget__6 = this;
                                PythonLanguage language__ = PythonLanguage.get(this);
                                return IntBuiltins.LShiftNode.doIPi(arg0Value_, arg1Value_, inliningTarget__6, language__, INLINED_RAISE_NODE);
                            }
                        }
                        if ((state_0 & 0xC00) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value);
                            if ((state_0 & 0x400) != 0 && arg0Value_ == 0L && arg1Value_.isZeroOrPositive()) {
                                return IntBuiltins.LShiftNode.doLPiZero(arg0Value_, arg1Value_);
                            }
                            if ((state_0 & 0x800) != 0) {
                                LShiftNodeGen inliningTarget__7 = this;
                                return IntBuiltins.LShiftNode.doLPi(arg0Value_, arg1Value_, inliningTarget__7, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0xF000) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x1000) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x180000) >>> 19, arg1Value)) {
                            int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x180000) >>> 19, arg1Value);
                            LShiftNodeGen inliningTarget__8 = this;
                            return IntBuiltins.LShiftNode.doPiI(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x2000) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value);
                            LShiftNodeGen inliningTarget__9 = this;
                            return IntBuiltins.LShiftNode.doPiL(arg0Value_, arg1Value_, inliningTarget__9, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0xC000) != 0 && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt)arg1Value;
                            if ((state_0 & 0x4000) != 0 && arg0Value_.isZero() && arg1Value_.isZeroOrPositive()) {
                                return IntBuiltins.LShiftNode.doPiPiZero(arg0Value_, arg1Value_);
                            }
                            if ((state_0 & 0x8000) != 0) {
                                LShiftNodeGen inliningTarget__10 = this;
                                return IntBuiltins.LShiftNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__10, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0x10000) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.LShiftNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x100ED) != 0) {
                    if ((state_0 & 5) != 0) {
                        if ((state_0 & 1) != 0) {
                            LShiftNodeGen inliningTarget__ = this;
                            try {
                                return IntBuiltins.LShiftNode.doII(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFE;
                                this.state_0_ = state_0 |= 2;
                                return this.executeAndSpecialize(arg0Value, arg1Value);
                            }
                        }
                        if ((state_0 & 4) != 0) {
                            LShiftNodeGen inliningTarget__1 = this;
                            return IntBuiltins.LShiftNode.doIIOvf(arg0Value, arg1Value, inliningTarget__1, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x28) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value);
                        if ((state_0 & 8) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value);
                            LShiftNodeGen inliningTarget__2 = this;
                            try {
                                return IntBuiltins.LShiftNode.doLL(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFF7;
                                this.state_0_ = state_0 |= 0x10;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        if ((state_0 & 0x20) != 0) {
                            LShiftNodeGen inliningTarget__3 = this;
                            return IntBuiltins.LShiftNode.doILOvf(arg0Value, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0xC0) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00000) >>> 21, arg0Value);
                        if ((state_0 & 0x40) != 0) {
                            LShiftNodeGen inliningTarget__4 = this;
                            return IntBuiltins.LShiftNode.doLIOvf(arg0Value_, arg1Value, inliningTarget__4, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x80) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000000) >>> 24, arg1Value);
                            LShiftNodeGen inliningTarget__5 = this;
                            return IntBuiltins.LShiftNode.doLLOvf(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x10000) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.LShiftNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public int executeInt(int arg0Value, int arg1Value) throws UnexpectedResultException {
                int state_0 = this.state_0_;
                if ((state_0 & 0xE4) != 0) {
                    return LShiftNodeGen.expectInteger(this.execute(null, arg0Value, arg1Value));
                }
                if ((state_0 & 1) != 0) {
                    LShiftNodeGen inliningTarget__ = this;
                    try {
                        return IntBuiltins.LShiftNode.doII(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                    }
                    catch (OverflowException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        return LShiftNodeGen.expectInteger(this.executeAndSpecialize(arg0Value, arg1Value));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LShiftNodeGen.expectInteger(this.executeAndSpecialize(arg0Value, arg1Value));
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int longCast0;
                int longCast1;
                int intCast1;
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        LShiftNodeGen inliningTarget__ = null;
                        if ((state_0 & 2) == 0) {
                            inliningTarget__ = this;
                            state_0 |= intCast0 << 17;
                            state_0 |= intCast1 << 19;
                            this.state_0_ = state_0 |= 1;
                            try {
                                return IntBuiltins.LShiftNode.doII(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_;
                                state_0 &= 0xFFFFFFFE;
                                this.state_0_ = state_0 |= 2;
                                return this.executeAndSpecialize(arg0Value_, arg1Value_);
                            }
                        }
                        LShiftNodeGen inliningTarget__1 = null;
                        inliningTarget__1 = this;
                        state_0 |= intCast0 << 17;
                        state_0 |= intCast1 << 19;
                        this.state_0_ = state_0 |= 4;
                        return IntBuiltins.LShiftNode.doIIOvf(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                    }
                }
                if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    int longCast02;
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                    LShiftNodeGen inliningTarget__2 = null;
                    if ((state_0 & 0x10) == 0 && (longCast02 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast02, arg0Value);
                        inliningTarget__2 = this;
                        state_0 |= longCast02 << 21;
                        state_0 |= longCast1 << 24;
                        this.state_0_ = state_0 |= 8;
                        try {
                            return IntBuiltins.LShiftNode.doLL(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                        }
                        catch (OverflowException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFF7;
                            this.state_0_ = state_0 |= 0x10;
                            return this.executeAndSpecialize(arg0Value_, arg1Value_);
                        }
                    }
                    LShiftNodeGen inliningTarget__3 = null;
                    int intCast02 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                    if (intCast02 != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast02, arg0Value);
                        inliningTarget__3 = this;
                        state_0 |= intCast02 << 17;
                        state_0 |= longCast1 << 24;
                        this.state_0_ = state_0 |= 0x20;
                        return IntBuiltins.LShiftNode.doILOvf(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                    }
                }
                if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    LShiftNodeGen inliningTarget__4 = null;
                    int intCast12 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast12 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast12, arg1Value);
                        inliningTarget__4 = this;
                        state_0 |= longCast0 << 21;
                        state_0 |= intCast12 << 19;
                        this.state_0_ = state_0 |= 0x40;
                        return IntBuiltins.LShiftNode.doLIOvf(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                    }
                    LShiftNodeGen inliningTarget__5 = null;
                    int longCast12 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast12 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast12, arg1Value);
                        inliningTarget__5 = this;
                        state_0 |= longCast0 << 21;
                        state_0 |= longCast12 << 24;
                        this.state_0_ = state_0 |= 0x80;
                        return IntBuiltins.LShiftNode.doLLOvf(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt)arg1Value;
                    int intCast03 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                    if (intCast03 != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast03, arg0Value);
                        if ((state_0 & 0x200) == 0 && arg0Value_ == 0 && arg1Value_.isZeroOrPositive()) {
                            state_0 |= intCast03 << 17;
                            this.state_0_ = state_0 |= 0x100;
                            return IntBuiltins.LShiftNode.doIPiZero(arg0Value_, arg1Value_);
                        }
                        PythonLanguage language__ = null;
                        LShiftNodeGen inliningTarget__6 = null;
                        inliningTarget__6 = this;
                        language__ = PythonLanguage.get(this);
                        state_0 &= 0xFFFFFEFF;
                        state_0 |= intCast03 << 17;
                        this.state_0_ = state_0 |= 0x200;
                        return IntBuiltins.LShiftNode.doIPi(arg0Value_, arg1Value_, inliningTarget__6, language__, INLINED_RAISE_NODE);
                    }
                    int longCast03 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast03 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast03, arg0Value);
                        if ((state_0 & 0x800) == 0 && arg0Value_ == 0L && arg1Value_.isZeroOrPositive()) {
                            state_0 |= longCast03 << 21;
                            this.state_0_ = state_0 |= 0x400;
                            return IntBuiltins.LShiftNode.doLPiZero(arg0Value_, arg1Value_);
                        }
                        LShiftNodeGen inliningTarget__7 = null;
                        inliningTarget__7 = this;
                        state_0 &= 0xFFFFFBFF;
                        state_0 |= longCast03 << 21;
                        this.state_0_ = state_0 |= 0x800;
                        return IntBuiltins.LShiftNode.doLPi(arg0Value_, arg1Value_, inliningTarget__7, INLINED_RAISE_NODE);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    LShiftNodeGen inliningTarget__8 = null;
                    intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        inliningTarget__8 = this;
                        state_0 |= intCast1 << 19;
                        this.state_0_ = state_0 |= 0x1000;
                        return IntBuiltins.LShiftNode.doPiI(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                    }
                    LShiftNodeGen inliningTarget__9 = null;
                    int longCast13 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast13 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast13, arg1Value);
                        inliningTarget__9 = this;
                        state_0 |= longCast13 << 24;
                        this.state_0_ = state_0 |= 0x2000;
                        return IntBuiltins.LShiftNode.doPiL(arg0Value_, arg1Value_, inliningTarget__9, INLINED_RAISE_NODE);
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        if ((state_0 & 0x8000) == 0 && arg0Value_.isZero() && arg1Value_.isZeroOrPositive()) {
                            this.state_0_ = state_0 |= 0x4000;
                            return IntBuiltins.LShiftNode.doPiPiZero(arg0Value_, arg1Value_);
                        }
                        LShiftNodeGen inliningTarget__10 = null;
                        inliningTarget__10 = this;
                        state_0 &= 0xFFFFBFFF;
                        this.state_0_ = state_0 |= 0x8000;
                        return IntBuiltins.LShiftNode.doPiPi(arg0Value_, arg1Value_, inliningTarget__10, INLINED_RAISE_NODE);
                    }
                }
                this.state_0_ = state_0 |= 0x10000;
                return IntBuiltins.LShiftNode.doGeneric(arg0Value, arg1Value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.RShiftNode.class)
    public static final class RShiftNodeFactory
    implements NodeFactory<IntBuiltins.RShiftNode> {
        private static final RShiftNodeFactory RSHIFT_NODE_FACTORY_INSTANCE = new RShiftNodeFactory();

        private RShiftNodeFactory() {
        }

        public Class<IntBuiltins.RShiftNode> getNodeClass() {
            return IntBuiltins.RShiftNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.RShiftNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return RShiftNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.RShiftNode> getInstance() {
            return RSHIFT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.RShiftNode create() {
            return new RShiftNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.RShiftNode.class)
        public static final class RShiftNodeGen
        extends IntBuiltins.RShiftNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(20, 1)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private RShiftNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    if (((state_0 & 8) == 0 || (state_0 & 0xFC000) != 1032192) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (((state_0 & 0x20) == 0 || (state_0 & 0x1C000) != 114688) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg0Value instanceof PInt) {
                    if (((state_0 & 0x80) == 0 || (state_0 & 0xE0000) != 917504) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if ((state_0 & 0x100) == 0 && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x3FF) != 0) {
                    int arg1Value_;
                    if ((state_0 & 3) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xC00) >>> 10, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xC00) >>> 10, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x3000) >>> 12, arg1Value)) {
                            arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x3000) >>> 12, arg1Value);
                            if ((state_0 & 1) != 0 && arg1Value_ < 32) {
                                RShiftNodeGen inliningTarget__ = this;
                                return IntBuiltins.RShiftNode.doIISmall(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                            }
                            if ((state_0 & 2) != 0) {
                                RShiftNodeGen inliningTarget__1 = this;
                                return IntBuiltins.RShiftNode.doII(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0xC) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C000) >>> 14, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C000) >>> 14, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg1Value)) {
                            long arg1Value_2 = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg1Value);
                            if ((state_0 & 4) != 0 && arg1Value_2 < 64L) {
                                RShiftNodeGen inliningTarget__2 = this;
                                return IntBuiltins.RShiftNode.doLLSmall(arg0Value_, arg1Value_2, inliningTarget__2, INLINED_RAISE_NODE);
                            }
                            if ((state_0 & 8) != 0) {
                                RShiftNodeGen inliningTarget__3 = this;
                                return IntBuiltins.RShiftNode.doLL(arg0Value_, arg1Value_2, inliningTarget__3, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0x30) != 0 && arg1Value instanceof PInt) {
                        PInt arg1Value_3 = (PInt)arg1Value;
                        if ((state_0 & 0x10) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xC00) >>> 10, arg0Value)) {
                            int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xC00) >>> 10, arg0Value);
                            RShiftNodeGen inliningTarget__4 = this;
                            return IntBuiltins.RShiftNode.doIPi(arg0Value_, arg1Value_3, inliningTarget__4, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x20) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C000) >>> 14, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C000) >>> 14, arg0Value);
                            RShiftNodeGen inliningTarget__5 = this;
                            return IntBuiltins.RShiftNode.doLPi(arg0Value_, arg1Value_3, inliningTarget__5, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x1C0) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x40) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x3000) >>> 12, arg1Value)) {
                            arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x3000) >>> 12, arg1Value);
                            RShiftNodeGen inliningTarget__6 = this;
                            PythonLanguage language__ = PythonLanguage.get(this);
                            return IntBuiltins.RShiftNode.doPiI(arg0Value_, arg1Value_, inliningTarget__6, language__, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x80) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg1Value)) {
                            long arg1Value_4 = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg1Value);
                            RShiftNodeGen inliningTarget__7 = this;
                            PythonLanguage language__1 = PythonLanguage.get(this);
                            return IntBuiltins.RShiftNode.doPiL(arg0Value_, arg1Value_4, inliningTarget__7, language__1, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 0x100) != 0 && arg1Value instanceof PInt) {
                            PInt arg1Value_5 = (PInt)arg1Value;
                            RShiftNodeGen inliningTarget__8 = this;
                            return IntBuiltins.RShiftNode.doPInt(arg0Value_, arg1Value_5, inliningTarget__8, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x200) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.RShiftNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public Object execute(int arg0Value, int arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x20F) != 0) {
                    if ((state_0 & 3) != 0) {
                        if ((state_0 & 1) != 0 && arg1Value < 32) {
                            RShiftNodeGen inliningTarget__ = this;
                            return IntBuiltins.RShiftNode.doIISmall(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                        }
                        if ((state_0 & 2) != 0) {
                            RShiftNodeGen inliningTarget__1 = this;
                            return IntBuiltins.RShiftNode.doII(arg0Value, arg1Value, inliningTarget__1, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0xC) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C000) >>> 14, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C000) >>> 14, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE0000) >>> 17, arg1Value)) {
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE0000) >>> 17, arg1Value);
                            if ((state_0 & 4) != 0 && arg1Value_ < 64L) {
                                RShiftNodeGen inliningTarget__2 = this;
                                return IntBuiltins.RShiftNode.doLLSmall(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                            }
                            if ((state_0 & 8) != 0) {
                                RShiftNodeGen inliningTarget__3 = this;
                                return IntBuiltins.RShiftNode.doLL(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                            }
                        }
                    }
                    if ((state_0 & 0x200) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.RShiftNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public int executeInt(int arg0Value, int arg1Value) throws UnexpectedResultException {
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg1Value < 32) {
                        RShiftNodeGen inliningTarget__ = this;
                        return IntBuiltins.RShiftNode.doIISmall(arg0Value, arg1Value, inliningTarget__, INLINED_RAISE_NODE);
                    }
                    if ((state_0 & 2) != 0) {
                        RShiftNodeGen inliningTarget__1 = this;
                        return IntBuiltins.RShiftNode.doII(arg0Value, arg1Value, inliningTarget__1, INLINED_RAISE_NODE);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RShiftNodeGen.expectInteger(this.executeAndSpecialize(arg0Value, arg1Value));
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int longCast1;
                int longCast0;
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        RShiftNodeGen inliningTarget__ = null;
                        if ((state_0 & 2) == 0 && arg1Value_ < 32) {
                            inliningTarget__ = this;
                            state_0 |= intCast0 << 10;
                            state_0 |= intCast1 << 12;
                            this.state_0_ = state_0 |= 1;
                            return IntBuiltins.RShiftNode.doIISmall(arg0Value_, arg1Value_, inliningTarget__, INLINED_RAISE_NODE);
                        }
                        RShiftNodeGen inliningTarget__1 = null;
                        inliningTarget__1 = this;
                        state_0 &= 0xFFFFFFFE;
                        state_0 |= intCast0 << 10;
                        state_0 |= intCast1 << 12;
                        this.state_0_ = state_0 |= 2;
                        return IntBuiltins.RShiftNode.doII(arg0Value_, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                    }
                }
                if ((longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        RShiftNodeGen inliningTarget__2 = null;
                        if ((state_0 & 8) == 0 && arg1Value_ < 64L) {
                            inliningTarget__2 = this;
                            state_0 |= longCast0 << 14;
                            state_0 |= longCast1 << 17;
                            this.state_0_ = state_0 |= 4;
                            return IntBuiltins.RShiftNode.doLLSmall(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                        }
                        RShiftNodeGen inliningTarget__3 = null;
                        inliningTarget__3 = this;
                        state_0 &= 0xFFFFFFFB;
                        state_0 |= longCast0 << 14;
                        state_0 |= longCast1 << 17;
                        this.state_0_ = state_0 |= 8;
                        return IntBuiltins.RShiftNode.doLL(arg0Value_, arg1Value_, inliningTarget__3, INLINED_RAISE_NODE);
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt)arg1Value;
                    RShiftNodeGen inliningTarget__4 = null;
                    int intCast02 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                    if (intCast02 != 0) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast02, arg0Value);
                        inliningTarget__4 = this;
                        state_0 |= intCast02 << 10;
                        this.state_0_ = state_0 |= 0x10;
                        return IntBuiltins.RShiftNode.doIPi(arg0Value_, arg1Value_, inliningTarget__4, INLINED_RAISE_NODE);
                    }
                    RShiftNodeGen inliningTarget__5 = null;
                    int longCast02 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast02 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast02, arg0Value);
                        inliningTarget__5 = this;
                        state_0 |= longCast02 << 14;
                        this.state_0_ = state_0 |= 0x20;
                        return IntBuiltins.RShiftNode.doLPi(arg0Value_, arg1Value_, inliningTarget__5, INLINED_RAISE_NODE);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    PythonLanguage language__ = null;
                    RShiftNodeGen inliningTarget__6 = null;
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        inliningTarget__6 = this;
                        language__ = PythonLanguage.get(this);
                        state_0 |= intCast1 << 12;
                        this.state_0_ = state_0 |= 0x40;
                        return IntBuiltins.RShiftNode.doPiI(arg0Value_, arg1Value_, inliningTarget__6, language__, INLINED_RAISE_NODE);
                    }
                    PythonLanguage language__1 = null;
                    RShiftNodeGen inliningTarget__7 = null;
                    longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        inliningTarget__7 = this;
                        language__1 = PythonLanguage.get(this);
                        state_0 |= longCast1 << 17;
                        this.state_0_ = state_0 |= 0x80;
                        return IntBuiltins.RShiftNode.doPiL(arg0Value_, arg1Value_, inliningTarget__7, language__1, INLINED_RAISE_NODE);
                    }
                    RShiftNodeGen inliningTarget__8 = null;
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        inliningTarget__8 = this;
                        this.state_0_ = state_0 |= 0x100;
                        return IntBuiltins.RShiftNode.doPInt(arg0Value_, arg1Value_, inliningTarget__8, INLINED_RAISE_NODE);
                    }
                }
                this.state_0_ = state_0 |= 0x200;
                return IntBuiltins.RShiftNode.doGeneric(arg0Value, arg1Value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.AndNode.class)
    public static final class AndNodeFactory
    implements NodeFactory<IntBuiltins.AndNode> {
        private static final AndNodeFactory AND_NODE_FACTORY_INSTANCE = new AndNodeFactory();

        private AndNodeFactory() {
        }

        public Class<IntBuiltins.AndNode> getNodeClass() {
            return IntBuiltins.AndNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.AndNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return AndNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.AndNode> getInstance() {
            return AND_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.AndNode create() {
            return new AndNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.AndNode.class)
        public static final class AndNodeGen
        extends IntBuiltins.AndNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyObjectHashNode INLINED_H = PyObjectHashNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectHashNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(22, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field3_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field3_;

            private AndNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                PythonNativeVoidPtr arg0Value_;
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (((state_0 & 2) == 0 || (state_0 & 0x3F0000) != 0x3F0000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (arg0Value_.isNativePointer()) {
                            return false;
                        }
                        arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (!arg0Value_.isNativePointer()) {
                            return false;
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr && arg1Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg1Value_;
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (arg0Value_.isNativePointer() && (arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (arg0Value_.isNativePointer() && !(arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (!arg0Value_.isNativePointer() && (arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (!arg0Value_.isNativePointer() && !(arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                }
                if (((state_0 & 0x100) == 0 || (state_0 & 0x70000) != 458752) && PythonIntegerTypesGen.isImplicitLong(arg0Value) && arg1Value instanceof PInt) {
                    return false;
                }
                if (arg0Value instanceof PInt) {
                    if (((state_0 & 0x200) == 0 || (state_0 & 0x380000) != 0x380000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if ((state_0 & 0x400) == 0 && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xFFF) != 0) {
                    PythonAbstractObject arg1Value_;
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x3000) >>> 12, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x3000) >>> 12, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xC000) >>> 14, arg1Value)) {
                            int arg1Value_2 = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xC000) >>> 14, arg1Value);
                            return this.doInteger(arg0Value_, arg1Value_2);
                        }
                    }
                    if ((state_0 & 0xE) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19, arg1Value)) {
                        long arg1Value_3 = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19, arg1Value);
                        if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16, arg0Value);
                            return this.doInteger(arg0Value_, arg1Value_3);
                        }
                        if ((state_0 & 0xC) != 0 && arg0Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                            if ((state_0 & 4) != 0 && arg0Value_.isNativePointer()) {
                                return this.opVoidNativePtrLong(arg0Value_, arg1Value_3);
                            }
                            if ((state_0 & 8) != 0 && !arg0Value_.isNativePointer()) {
                                AndNodeGen inliningTarget__ = this;
                                return this.opVoidPtrLong(frameValue, arg0Value_, arg1Value_3, inliningTarget__, INLINED_H);
                            }
                        }
                    }
                    if ((state_0 & 0xF0) != 0 && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (arg1Value instanceof PythonNativeVoidPtr) {
                            arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                            if ((state_0 & 0x10) != 0 && arg0Value_.isNativePointer() && ((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                return this.voidPtrsNative(arg0Value_, (PythonNativeVoidPtr)arg1Value_);
                            }
                            if ((state_0 & 0x20) != 0 && arg0Value_.isNativePointer() && !((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                AndNodeGen inliningTarget__1 = this;
                                return this.voidPtrsANative(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__1, INLINED_H);
                            }
                            if ((state_0 & 0x40) != 0 && !arg0Value_.isNativePointer() && ((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                AndNodeGen inliningTarget__2 = this;
                                return this.voidPtrsBNative(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__2, INLINED_H);
                            }
                            if ((state_0 & 0x80) != 0 && !arg0Value_.isNativePointer() && !((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                AndNodeGen inliningTarget__3 = this;
                                return this.voidPtrsManaged(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__3, INLINED_H);
                            }
                        }
                    }
                    if ((state_0 & 0x100) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_4 = (PInt)arg1Value;
                            PythonLanguage language__ = PythonLanguage.get(this);
                            return this.doPInt(arg0Value_, arg1Value_4, language__);
                        }
                    }
                    if ((state_0 & 0x600) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x200) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19, arg1Value)) {
                            long arg1Value_5 = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19, arg1Value);
                            PythonLanguage language__1 = PythonLanguage.get(this);
                            return this.doPInt(arg0Value_, arg1Value_5, language__1);
                        }
                        if ((state_0 & 0x400) != 0 && arg1Value instanceof PInt) {
                            arg1Value_ = (PInt)arg1Value;
                            PythonLanguage language__2 = PythonLanguage.get(this);
                            return this.doPInt(arg0Value_, (PInt)arg1Value_, language__2);
                        }
                    }
                    if ((state_0 & 0x800) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int longCast1;
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        state_0 |= intCast0 << 12;
                        state_0 |= intCast1 << 14;
                        this.state_0_ = state_0 |= 1;
                        return this.doInteger(arg0Value_, arg1Value_);
                    }
                }
                if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        state_0 |= longCast0 << 16;
                        state_0 |= longCast1 << 19;
                        this.state_0_ = state_0 |= 2;
                        return this.doInteger(arg0Value_, arg1Value_);
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (arg0Value_.isNativePointer()) {
                            state_0 |= longCast1 << 19;
                            this.state_0_ = state_0 |= 4;
                            return this.opVoidNativePtrLong(arg0Value_, arg1Value_);
                        }
                        AndNodeGen inliningTarget__ = null;
                        if (!arg0Value_.isNativePointer()) {
                            inliningTarget__ = this;
                            state_0 |= longCast1 << 19;
                            this.state_0_ = state_0 |= 8;
                            return this.opVoidPtrLong(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (arg1Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                        if (arg0Value_.isNativePointer() && arg1Value_.isNativePointer()) {
                            this.state_0_ = state_0 |= 0x10;
                            return this.voidPtrsNative(arg0Value_, arg1Value_);
                        }
                        AndNodeGen inliningTarget__1 = null;
                        if (arg0Value_.isNativePointer() && !arg1Value_.isNativePointer()) {
                            inliningTarget__1 = this;
                            this.state_0_ = state_0 |= 0x20;
                            return this.voidPtrsANative(frameValue, arg0Value_, arg1Value_, inliningTarget__1, INLINED_H);
                        }
                        AndNodeGen inliningTarget__2 = null;
                        if (!arg0Value_.isNativePointer() && arg1Value_.isNativePointer()) {
                            inliningTarget__2 = this;
                            this.state_0_ = state_0 |= 0x40;
                            return this.voidPtrsBNative(frameValue, arg0Value_, arg1Value_, inliningTarget__2, INLINED_H);
                        }
                        AndNodeGen inliningTarget__3 = null;
                        if (!arg0Value_.isNativePointer() && !arg1Value_.isNativePointer()) {
                            inliningTarget__3 = this;
                            this.state_0_ = state_0 |= 0x80;
                            return this.voidPtrsManaged(frameValue, arg0Value_, arg1Value_, inliningTarget__3, INLINED_H);
                        }
                    }
                }
                PythonLanguage language__ = null;
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        language__ = PythonLanguage.get(this);
                        state_0 |= longCast0 << 16;
                        this.state_0_ = state_0 |= 0x100;
                        return this.doPInt(arg0Value_, arg1Value_, language__);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    PythonLanguage language__1 = null;
                    int longCast12 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast12 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast12, arg1Value);
                        language__1 = PythonLanguage.get(this);
                        state_0 |= longCast12 << 19;
                        this.state_0_ = state_0 |= 0x200;
                        return this.doPInt(arg0Value_, arg1Value_, language__1);
                    }
                    PythonLanguage language__2 = null;
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        language__2 = PythonLanguage.get(this);
                        this.state_0_ = state_0 |= 0x400;
                        return this.doPInt(arg0Value_, arg1Value_, language__2);
                    }
                }
                this.state_0_ = state_0 |= 0x800;
                return IntBuiltins.BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.OrNode.class)
    public static final class OrNodeFactory
    implements NodeFactory<IntBuiltins.OrNode> {
        private static final OrNodeFactory OR_NODE_FACTORY_INSTANCE = new OrNodeFactory();

        private OrNodeFactory() {
        }

        public Class<IntBuiltins.OrNode> getNodeClass() {
            return IntBuiltins.OrNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.OrNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return OrNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.OrNode> getInstance() {
            return OR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.OrNode create() {
            return new OrNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.OrNode.class)
        public static final class OrNodeGen
        extends IntBuiltins.OrNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyObjectHashNode INLINED_H = PyObjectHashNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectHashNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(22, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field3_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field3_;

            private OrNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                PythonNativeVoidPtr arg0Value_;
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (((state_0 & 2) == 0 || (state_0 & 0x3F0000) != 0x3F0000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (arg0Value_.isNativePointer()) {
                            return false;
                        }
                        arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (!arg0Value_.isNativePointer()) {
                            return false;
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr && arg1Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg1Value_;
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (arg0Value_.isNativePointer() && (arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (arg0Value_.isNativePointer() && !(arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (!arg0Value_.isNativePointer() && (arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (!arg0Value_.isNativePointer() && !(arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                }
                if (((state_0 & 0x100) == 0 || (state_0 & 0x70000) != 458752) && PythonIntegerTypesGen.isImplicitLong(arg0Value) && arg1Value instanceof PInt) {
                    return false;
                }
                if (arg0Value instanceof PInt) {
                    if (((state_0 & 0x200) == 0 || (state_0 & 0x380000) != 0x380000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if ((state_0 & 0x400) == 0 && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xFFF) != 0) {
                    PythonAbstractObject arg1Value_;
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x3000) >>> 12, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x3000) >>> 12, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xC000) >>> 14, arg1Value)) {
                            int arg1Value_2 = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xC000) >>> 14, arg1Value);
                            return this.doInteger(arg0Value_, arg1Value_2);
                        }
                    }
                    if ((state_0 & 0xE) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19, arg1Value)) {
                        long arg1Value_3 = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19, arg1Value);
                        if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16, arg0Value);
                            return this.doInteger(arg0Value_, arg1Value_3);
                        }
                        if ((state_0 & 0xC) != 0 && arg0Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                            if ((state_0 & 4) != 0 && arg0Value_.isNativePointer()) {
                                return this.opVoidNativePtrLong(arg0Value_, arg1Value_3);
                            }
                            if ((state_0 & 8) != 0 && !arg0Value_.isNativePointer()) {
                                OrNodeGen inliningTarget__ = this;
                                return this.opVoidPtrLong(frameValue, arg0Value_, arg1Value_3, inliningTarget__, INLINED_H);
                            }
                        }
                    }
                    if ((state_0 & 0xF0) != 0 && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (arg1Value instanceof PythonNativeVoidPtr) {
                            arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                            if ((state_0 & 0x10) != 0 && arg0Value_.isNativePointer() && ((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                return this.voidPtrsNative(arg0Value_, (PythonNativeVoidPtr)arg1Value_);
                            }
                            if ((state_0 & 0x20) != 0 && arg0Value_.isNativePointer() && !((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                OrNodeGen inliningTarget__1 = this;
                                return this.voidPtrsANative(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__1, INLINED_H);
                            }
                            if ((state_0 & 0x40) != 0 && !arg0Value_.isNativePointer() && ((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                OrNodeGen inliningTarget__2 = this;
                                return this.voidPtrsBNative(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__2, INLINED_H);
                            }
                            if ((state_0 & 0x80) != 0 && !arg0Value_.isNativePointer() && !((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                OrNodeGen inliningTarget__3 = this;
                                return this.voidPtrsManaged(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__3, INLINED_H);
                            }
                        }
                    }
                    if ((state_0 & 0x100) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_4 = (PInt)arg1Value;
                            PythonLanguage language__ = PythonLanguage.get(this);
                            return this.doPInt(arg0Value_, arg1Value_4, language__);
                        }
                    }
                    if ((state_0 & 0x600) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x200) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19, arg1Value)) {
                            long arg1Value_5 = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19, arg1Value);
                            PythonLanguage language__1 = PythonLanguage.get(this);
                            return this.doPInt(arg0Value_, arg1Value_5, language__1);
                        }
                        if ((state_0 & 0x400) != 0 && arg1Value instanceof PInt) {
                            arg1Value_ = (PInt)arg1Value;
                            PythonLanguage language__2 = PythonLanguage.get(this);
                            return this.doPInt(arg0Value_, (PInt)arg1Value_, language__2);
                        }
                    }
                    if ((state_0 & 0x800) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int longCast1;
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        state_0 |= intCast0 << 12;
                        state_0 |= intCast1 << 14;
                        this.state_0_ = state_0 |= 1;
                        return this.doInteger(arg0Value_, arg1Value_);
                    }
                }
                if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        state_0 |= longCast0 << 16;
                        state_0 |= longCast1 << 19;
                        this.state_0_ = state_0 |= 2;
                        return this.doInteger(arg0Value_, arg1Value_);
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (arg0Value_.isNativePointer()) {
                            state_0 |= longCast1 << 19;
                            this.state_0_ = state_0 |= 4;
                            return this.opVoidNativePtrLong(arg0Value_, arg1Value_);
                        }
                        OrNodeGen inliningTarget__ = null;
                        if (!arg0Value_.isNativePointer()) {
                            inliningTarget__ = this;
                            state_0 |= longCast1 << 19;
                            this.state_0_ = state_0 |= 8;
                            return this.opVoidPtrLong(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (arg1Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                        if (arg0Value_.isNativePointer() && arg1Value_.isNativePointer()) {
                            this.state_0_ = state_0 |= 0x10;
                            return this.voidPtrsNative(arg0Value_, arg1Value_);
                        }
                        OrNodeGen inliningTarget__1 = null;
                        if (arg0Value_.isNativePointer() && !arg1Value_.isNativePointer()) {
                            inliningTarget__1 = this;
                            this.state_0_ = state_0 |= 0x20;
                            return this.voidPtrsANative(frameValue, arg0Value_, arg1Value_, inliningTarget__1, INLINED_H);
                        }
                        OrNodeGen inliningTarget__2 = null;
                        if (!arg0Value_.isNativePointer() && arg1Value_.isNativePointer()) {
                            inliningTarget__2 = this;
                            this.state_0_ = state_0 |= 0x40;
                            return this.voidPtrsBNative(frameValue, arg0Value_, arg1Value_, inliningTarget__2, INLINED_H);
                        }
                        OrNodeGen inliningTarget__3 = null;
                        if (!arg0Value_.isNativePointer() && !arg1Value_.isNativePointer()) {
                            inliningTarget__3 = this;
                            this.state_0_ = state_0 |= 0x80;
                            return this.voidPtrsManaged(frameValue, arg0Value_, arg1Value_, inliningTarget__3, INLINED_H);
                        }
                    }
                }
                PythonLanguage language__ = null;
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        language__ = PythonLanguage.get(this);
                        state_0 |= longCast0 << 16;
                        this.state_0_ = state_0 |= 0x100;
                        return this.doPInt(arg0Value_, arg1Value_, language__);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    PythonLanguage language__1 = null;
                    int longCast12 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast12 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast12, arg1Value);
                        language__1 = PythonLanguage.get(this);
                        state_0 |= longCast12 << 19;
                        this.state_0_ = state_0 |= 0x200;
                        return this.doPInt(arg0Value_, arg1Value_, language__1);
                    }
                    PythonLanguage language__2 = null;
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        language__2 = PythonLanguage.get(this);
                        this.state_0_ = state_0 |= 0x400;
                        return this.doPInt(arg0Value_, arg1Value_, language__2);
                    }
                }
                this.state_0_ = state_0 |= 0x800;
                return IntBuiltins.BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.XorNode.class)
    public static final class XorNodeFactory
    implements NodeFactory<IntBuiltins.XorNode> {
        private static final XorNodeFactory XOR_NODE_FACTORY_INSTANCE = new XorNodeFactory();

        private XorNodeFactory() {
        }

        public Class<IntBuiltins.XorNode> getNodeClass() {
            return IntBuiltins.XorNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.XorNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return XorNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.XorNode> getInstance() {
            return XOR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.XorNode create() {
            return new XorNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.XorNode.class)
        public static final class XorNodeGen
        extends IntBuiltins.XorNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyObjectHashNode INLINED_H = PyObjectHashNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectHashNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(22, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field3_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field3_;

            private XorNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                PythonNativeVoidPtr arg0Value_;
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (((state_0 & 2) == 0 || (state_0 & 0x3F0000) != 0x3F0000) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (arg0Value_.isNativePointer()) {
                            return false;
                        }
                        arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (!arg0Value_.isNativePointer()) {
                            return false;
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr && arg1Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg1Value_;
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (arg0Value_.isNativePointer() && (arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (arg0Value_.isNativePointer() && !(arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (!arg0Value_.isNativePointer() && (arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                    arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (!arg0Value_.isNativePointer() && !(arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                        return false;
                    }
                }
                if (((state_0 & 0x100) == 0 || (state_0 & 0x70000) != 458752) && PythonIntegerTypesGen.isImplicitLong(arg0Value) && arg1Value instanceof PInt) {
                    return false;
                }
                if (arg0Value instanceof PInt) {
                    if (((state_0 & 0x200) == 0 || (state_0 & 0x380000) != 0x380000) && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if ((state_0 & 0x400) == 0 && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0xFFF) != 0) {
                    PythonAbstractObject arg1Value_;
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x3000) >>> 12, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x3000) >>> 12, arg0Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xC000) >>> 14, arg1Value)) {
                            int arg1Value_2 = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xC000) >>> 14, arg1Value);
                            return this.doInteger(arg0Value_, arg1Value_2);
                        }
                    }
                    if ((state_0 & 0xE) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19, arg1Value)) {
                        long arg1Value_3 = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19, arg1Value);
                        if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16, arg0Value);
                            return this.doInteger(arg0Value_, arg1Value_3);
                        }
                        if ((state_0 & 0xC) != 0 && arg0Value instanceof PythonNativeVoidPtr) {
                            PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                            if ((state_0 & 4) != 0 && arg0Value_.isNativePointer()) {
                                return this.opVoidNativePtrLong(arg0Value_, arg1Value_3);
                            }
                            if ((state_0 & 8) != 0 && !arg0Value_.isNativePointer()) {
                                XorNodeGen inliningTarget__ = this;
                                return this.opVoidPtrLong(frameValue, arg0Value_, arg1Value_3, inliningTarget__, INLINED_H);
                            }
                        }
                    }
                    if ((state_0 & 0xF0) != 0 && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (arg1Value instanceof PythonNativeVoidPtr) {
                            arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                            if ((state_0 & 0x10) != 0 && arg0Value_.isNativePointer() && ((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                return this.voidPtrsNative(arg0Value_, (PythonNativeVoidPtr)arg1Value_);
                            }
                            if ((state_0 & 0x20) != 0 && arg0Value_.isNativePointer() && !((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                XorNodeGen inliningTarget__1 = this;
                                return this.voidPtrsANative(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__1, INLINED_H);
                            }
                            if ((state_0 & 0x40) != 0 && !arg0Value_.isNativePointer() && ((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                XorNodeGen inliningTarget__2 = this;
                                return this.voidPtrsBNative(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__2, INLINED_H);
                            }
                            if ((state_0 & 0x80) != 0 && !arg0Value_.isNativePointer() && !((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                XorNodeGen inliningTarget__3 = this;
                                return this.voidPtrsManaged(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__3, INLINED_H);
                            }
                        }
                    }
                    if ((state_0 & 0x100) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x70000) >>> 16, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x70000) >>> 16, arg0Value);
                        if (arg1Value instanceof PInt) {
                            PInt arg1Value_4 = (PInt)arg1Value;
                            PythonLanguage language__ = PythonLanguage.get(this);
                            return this.doPInt(arg0Value_, arg1Value_4, language__);
                        }
                    }
                    if ((state_0 & 0x600) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        if ((state_0 & 0x200) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380000) >>> 19, arg1Value)) {
                            long arg1Value_5 = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380000) >>> 19, arg1Value);
                            PythonLanguage language__1 = PythonLanguage.get(this);
                            return this.doPInt(arg0Value_, arg1Value_5, language__1);
                        }
                        if ((state_0 & 0x400) != 0 && arg1Value instanceof PInt) {
                            arg1Value_ = (PInt)arg1Value;
                            PythonLanguage language__2 = PythonLanguage.get(this);
                            return this.doPInt(arg0Value_, (PInt)arg1Value_, language__2);
                        }
                    }
                    if ((state_0 & 0x800) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int longCast1;
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                    if (intCast1 != 0) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                        state_0 |= intCast0 << 12;
                        state_0 |= intCast1 << 14;
                        this.state_0_ = state_0 |= 1;
                        return this.doInteger(arg0Value_, arg1Value_);
                    }
                }
                if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        state_0 |= longCast0 << 16;
                        state_0 |= longCast1 << 19;
                        this.state_0_ = state_0 |= 2;
                        return this.doInteger(arg0Value_, arg1Value_);
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (arg0Value_.isNativePointer()) {
                            state_0 |= longCast1 << 19;
                            this.state_0_ = state_0 |= 4;
                            return this.opVoidNativePtrLong(arg0Value_, arg1Value_);
                        }
                        XorNodeGen inliningTarget__ = null;
                        if (!arg0Value_.isNativePointer()) {
                            inliningTarget__ = this;
                            state_0 |= longCast1 << 19;
                            this.state_0_ = state_0 |= 8;
                            return this.opVoidPtrLong(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                        }
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if (arg1Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                        if (arg0Value_.isNativePointer() && arg1Value_.isNativePointer()) {
                            this.state_0_ = state_0 |= 0x10;
                            return this.voidPtrsNative(arg0Value_, arg1Value_);
                        }
                        XorNodeGen inliningTarget__1 = null;
                        if (arg0Value_.isNativePointer() && !arg1Value_.isNativePointer()) {
                            inliningTarget__1 = this;
                            this.state_0_ = state_0 |= 0x20;
                            return this.voidPtrsANative(frameValue, arg0Value_, arg1Value_, inliningTarget__1, INLINED_H);
                        }
                        XorNodeGen inliningTarget__2 = null;
                        if (!arg0Value_.isNativePointer() && arg1Value_.isNativePointer()) {
                            inliningTarget__2 = this;
                            this.state_0_ = state_0 |= 0x40;
                            return this.voidPtrsBNative(frameValue, arg0Value_, arg1Value_, inliningTarget__2, INLINED_H);
                        }
                        XorNodeGen inliningTarget__3 = null;
                        if (!arg0Value_.isNativePointer() && !arg1Value_.isNativePointer()) {
                            inliningTarget__3 = this;
                            this.state_0_ = state_0 |= 0x80;
                            return this.voidPtrsManaged(frameValue, arg0Value_, arg1Value_, inliningTarget__3, INLINED_H);
                        }
                    }
                }
                PythonLanguage language__ = null;
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        language__ = PythonLanguage.get(this);
                        state_0 |= longCast0 << 16;
                        this.state_0_ = state_0 |= 0x100;
                        return this.doPInt(arg0Value_, arg1Value_, language__);
                    }
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    PythonLanguage language__1 = null;
                    int longCast12 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast12 != 0) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast12, arg1Value);
                        language__1 = PythonLanguage.get(this);
                        state_0 |= longCast12 << 19;
                        this.state_0_ = state_0 |= 0x200;
                        return this.doPInt(arg0Value_, arg1Value_, language__1);
                    }
                    PythonLanguage language__2 = null;
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        language__2 = PythonLanguage.get(this);
                        this.state_0_ = state_0 |= 0x400;
                        return this.doPInt(arg0Value_, arg1Value_, language__2);
                    }
                }
                this.state_0_ = state_0 |= 0x800;
                return IntBuiltins.BinaryBitwiseNode.doGeneric(arg0Value, arg1Value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.RichCompareNode.class)
    static final class RichCompareNodeFactory
    implements NodeFactory<IntBuiltins.RichCompareNode> {
        private static final RichCompareNodeFactory RICH_COMPARE_NODE_FACTORY_INSTANCE = new RichCompareNodeFactory();

        private RichCompareNodeFactory() {
        }

        public Class<IntBuiltins.RichCompareNode> getNodeClass() {
            return IntBuiltins.RichCompareNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.RichCompareNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return RichCompareNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.RichCompareNode> getInstance() {
            return RICH_COMPARE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.RichCompareNode create() {
            return new RichCompareNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.RichCompareNode.class)
        static final class RichCompareNodeGen
        extends IntBuiltins.RichCompareNode {
            private static final InlineSupport.StateField CACHED_RICH_COMPARE_NODE_CACHED_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cached_state_0_");
            private static final PyLongCheckNode INLINED_CHECK_LEFT_ = PyLongCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyLongCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CACHED_RICH_COMPARE_NODE_CACHED_STATE_0_UPDATER.subUpdater(0, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"checkLeft__field1_", Node.class)}));
            private static final PyLongCheckNode INLINED_CHECK_RIGHT_ = PyLongCheckNodeGen.inline(InlineSupport.InlineTarget.create(PyLongCheckNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CACHED_RICH_COMPARE_NODE_CACHED_STATE_0_UPDATER.subUpdater(5, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"checkRight__field1_", Node.class)}));
            private static final InlineSupport.StateField CACHED_RICH_COMPARE_NODE_CACHED_STATE_1_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cached_state_1_");
            private static final IntBuiltins.RichCompareHelperNode INLINED_CMP_NODE_ = RichCompareHelperNodeGen.inline(InlineSupport.InlineTarget.create(IntBuiltins.RichCompareHelperNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{CACHED_RICH_COMPARE_NODE_CACHED_STATE_1_UPDATER.subUpdater(0, 28), CACHED_RICH_COMPARE_NODE_CACHED_STATE_0_UPDATER.subUpdater(13, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cmpNode__field2_", Object.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cmpNode__field3_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cmpNode__field4_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cmpNode__field5_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cmpNode__field6_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cmpNode__field7_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)CachedData.lookup_(), (String)"cmpNode__field8_", Node.class)}));
            static final InlineSupport.ReferenceField<CachedData> CACHED_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"cached_cache", CachedData.class);
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private CachedData cached_cache;

            private RichCompareNodeGen() {
            }

            @Override
            @ExplodeLoop
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, RichCmpOp arg2Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    CachedData s0_ = this.cached_cache;
                    while (s0_ != null) {
                        if (arg2Value == IntBuiltinsFactory.decodeRichCmpOp(((s0_.cached_state_0_ & 0x1C00) >>> 10) - 2)) {
                            CachedData inliningTarget__ = s0_;
                            return IntBuiltins.RichCompareNode.doCached(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, INLINED_CHECK_LEFT_, INLINED_CHECK_RIGHT_, IntBuiltinsFactory.decodeRichCmpOp(((s0_.cached_state_0_ & 0x1C00) >>> 10) - 2), INLINED_CMP_NODE_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, RichCmpOp arg2Value) {
                CachedData s0_;
                CachedData inliningTarget__;
                block4: {
                    CachedData s0_original;
                    int state_0 = this.state_0_;
                    inliningTarget__ = null;
                    do {
                        int count0_ = 0;
                        s0_original = s0_ = (CachedData)((Object)CACHED_CACHE_UPDATER.getVolatile((Node)this));
                        while (s0_ != null) {
                            if (arg2Value == IntBuiltinsFactory.decodeRichCmpOp(((s0_.cached_state_0_ & 0x1C00) >>> 10) - 2)) {
                                inliningTarget__ = s0_;
                                break;
                            }
                            ++count0_;
                            s0_ = s0_.next_;
                        }
                        if (s0_ != null || count0_ >= 6) break block4;
                        inliningTarget__ = s0_ = (CachedData)this.insert(new CachedData(s0_original));
                        s0_.cached_state_0_ |= IntBuiltinsFactory.encodeRichCmpOp(arg2Value) + 2 << 10;
                    } while (!CACHED_CACHE_UPDATER.compareAndSet((Node)this, (Object)s0_original, (Object)s0_));
                    this.state_0_ = state_0 |= 1;
                }
                if (s0_ != null) {
                    return IntBuiltins.RichCompareNode.doCached(frameValue, arg0Value, arg1Value, arg2Value, inliningTarget__, INLINED_CHECK_LEFT_, INLINED_CHECK_RIGHT_, IntBuiltinsFactory.decodeRichCmpOp(((s0_.cached_state_0_ & 0x1C00) >>> 10) - 2), INLINED_CMP_NODE_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value, arg2Value});
            }

            @GeneratedBy(value=IntBuiltins.RichCompareNode.class)
            @DenyReplace
            private static final class CachedData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                CachedData next_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int cached_state_0_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int cached_state_1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node checkLeft__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node checkRight__field1_;
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private Object cmpNode__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node cmpNode__field3_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node cmpNode__field4_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node cmpNode__field5_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node cmpNode__field6_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node cmpNode__field7_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node cmpNode__field8_;

                CachedData(CachedData next_) {
                    this.next_ = next_;
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.ToBytesNode.class)
    public static final class ToBytesNodeFactory
    implements NodeFactory<IntBuiltins.ToBytesNode> {
        private static final ToBytesNodeFactory TO_BYTES_NODE_FACTORY_INSTANCE = new ToBytesNodeFactory();

        private ToBytesNodeFactory() {
        }

        public Class<IntBuiltins.ToBytesNode> getNodeClass() {
            return IntBuiltins.ToBytesNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public IntBuiltins.ToBytesNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return ToBytesNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.ToBytesNode> getInstance() {
            return TO_BYTES_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.ToBytesNode create(ReadArgumentNode[] arguments) {
            return new ToBytesNodeGen(arguments);
        }

        @GeneratedBy(value=IntBuiltins.ToBytesNode.class)
        public static final class ToBytesNodeGen
        extends IntBuiltins.ToBytesNode {
            private static final InlineSupport.StateField STATE_0_ToBytesNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedConditionProfile INLINED_FROM_LONG_NEGATIVE_BYTE_COUNT_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToBytesNode_UPDATER.subUpdater(7, 2)}));
            private static final InlinedConditionProfile INLINED_FROM_LONG_NEGATIVE_NUMBER_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToBytesNode_UPDATER.subUpdater(9, 2)}));
            private static final InlinedConditionProfile INLINED_FROM_LONG_OVERFLOW_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToBytesNode_UPDATER.subUpdater(11, 2)}));
            private static final PRaiseNode INLINED_FROM_LONG_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToBytesNode_UPDATER.subUpdater(13, 1)}));
            private static final InlinedConditionProfile INLINED_FROM_PINT_INT_NEGATIVE_BYTE_COUNT_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToBytesNode_UPDATER.subUpdater(14, 2)}));
            private static final InlinedConditionProfile INLINED_FROM_PINT_INT_OVERFLOW_PROFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToBytesNode_UPDATER.subUpdater(16, 2)}));
            private static final PRaiseNode INLINED_FROM_PINT_INT_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ToBytesNode_UPDATER.subUpdater(18, 1)}));
            @Node.Child
            private ReadArgumentNode arguments0_;
            @Node.Child
            private ReadArgumentNode arguments1_;
            @Node.Child
            private ReadArgumentNode arguments2_;
            @Node.Child
            private ReadArgumentNode arguments3_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private ToBytesNodeGen(ReadArgumentNode[] arguments) {
                ReadArgumentNode[] arguments_ = arguments != null ? this.createCasts(arguments) : null;
                this.arguments0_ = arguments_ != null && 0 < arguments_.length ? arguments_[0] : null;
                this.arguments1_ = arguments_ != null && 1 < arguments_.length ? arguments_[1] : null;
                this.arguments2_ = arguments_ != null && 2 < arguments_.length ? arguments_[2] : null;
                this.arguments3_ = arguments_ != null && 3 < arguments_.length ? arguments_[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if ((state_0 & 3) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60) >>> 5, arguments1Value_)) {
                    int arguments1Value__ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60) >>> 5, arguments1Value_);
                    if (arguments2Value_ instanceof TruffleString) {
                        TruffleString arguments2Value__ = (TruffleString)arguments2Value_;
                        if (arguments3Value_ instanceof Boolean) {
                            boolean arguments3Value__ = (Boolean)arguments3Value_;
                            if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C) >>> 2, arguments0Value_)) {
                                long arguments0Value__ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C) >>> 2, arguments0Value_);
                                ToBytesNodeGen inliningTarget__ = this;
                                PythonLanguage language__ = PythonLanguage.get(this);
                                return IntBuiltins.ToBytesNode.fromLong(arguments0Value__, arguments1Value__, arguments2Value__, arguments3Value__, inliningTarget__, language__, INLINED_FROM_LONG_NEGATIVE_BYTE_COUNT_PROFILE_, INLINED_FROM_LONG_NEGATIVE_NUMBER_PROFILE_, INLINED_FROM_LONG_OVERFLOW_PROFILE_, INLINED_FROM_LONG_RAISE_NODE_);
                            }
                            if ((state_0 & 2) != 0 && arguments0Value_ instanceof PInt) {
                                PInt arguments0Value__ = (PInt)arguments0Value_;
                                ToBytesNodeGen inliningTarget__1 = this;
                                PythonLanguage language__1 = PythonLanguage.get(this);
                                return IntBuiltins.ToBytesNode.fromPIntInt(arguments0Value__, arguments1Value__, arguments2Value__, arguments3Value__, inliningTarget__1, language__1, INLINED_FROM_PINT_INT_NEGATIVE_BYTE_COUNT_PROFILE_, INLINED_FROM_PINT_INT_OVERFLOW_PROFILE_, INLINED_FROM_PINT_INT_RAISE_NODE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private PBytes executeAndSpecialize(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arguments1Value);
                if (intCast1 != 0) {
                    int arguments1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arguments1Value);
                    if (arguments2Value instanceof TruffleString) {
                        TruffleString arguments2Value_ = (TruffleString)arguments2Value;
                        if (arguments3Value instanceof Boolean) {
                            boolean arguments3Value_ = (Boolean)arguments3Value;
                            PythonLanguage language__ = null;
                            ToBytesNodeGen inliningTarget__ = null;
                            int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arguments0Value);
                            if (longCast0 != 0) {
                                long arguments0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arguments0Value);
                                inliningTarget__ = this;
                                language__ = PythonLanguage.get(this);
                                state_0 |= longCast0 << 2;
                                state_0 |= intCast1 << 5;
                                this.state_0_ = state_0 |= 1;
                                return IntBuiltins.ToBytesNode.fromLong(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, inliningTarget__, language__, INLINED_FROM_LONG_NEGATIVE_BYTE_COUNT_PROFILE_, INLINED_FROM_LONG_NEGATIVE_NUMBER_PROFILE_, INLINED_FROM_LONG_OVERFLOW_PROFILE_, INLINED_FROM_LONG_RAISE_NODE_);
                            }
                            PythonLanguage language__1 = null;
                            ToBytesNodeGen inliningTarget__1 = null;
                            if (arguments0Value instanceof PInt) {
                                PInt arguments0Value_ = (PInt)arguments0Value;
                                inliningTarget__1 = this;
                                language__1 = PythonLanguage.get(this);
                                state_0 |= intCast1 << 5;
                                this.state_0_ = state_0 |= 2;
                                return IntBuiltins.ToBytesNode.fromPIntInt(arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_, inliningTarget__1, language__1, INLINED_FROM_PINT_INT_NEGATIVE_BYTE_COUNT_PROFILE_, INLINED_FROM_PINT_INT_OVERFLOW_PROFILE_, INLINED_FROM_PINT_INT_RAISE_NODE_);
                            }
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.FromBytesNode.class)
    public static final class FromBytesNodeFactory
    implements NodeFactory<IntBuiltins.FromBytesNode> {
        private static final FromBytesNodeFactory FROM_BYTES_NODE_FACTORY_INSTANCE = new FromBytesNodeFactory();

        private FromBytesNodeFactory() {
        }

        public Class<IntBuiltins.FromBytesNode> getNodeClass() {
            return IntBuiltins.FromBytesNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class, ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public IntBuiltins.FromBytesNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return FromBytesNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.FromBytesNode> getInstance() {
            return FROM_BYTES_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.FromBytesNode create(ReadArgumentNode[] arguments) {
            return new FromBytesNodeGen(arguments);
        }

        @GeneratedBy(value=IntBuiltins.FromBytesNode.class)
        public static final class FromBytesNodeGen
        extends IntBuiltins.FromBytesNode {
            private static final InlineSupport.StateField STATE_0_FromBytesNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final BuiltinClassProfiles.IsBuiltinClassExactProfile INLINED_IS_BUILTIN_INT_PROFILE_ = BuiltinClassProfilesFactory.IsBuiltinClassExactProfileNodeGen.inline(InlineSupport.InlineTarget.create(BuiltinClassProfiles.IsBuiltinClassExactProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FromBytesNode_UPDATER.subUpdater(1, 5)}));
            private static final InlinedBranchProfile INLINED_HAS_BYTES_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FromBytesNode_UPDATER.subUpdater(6, 1)}));
            private static final IntNodes.PyLongFromByteArray INLINED_FROM_BYTE_ARRAY_ = IntNodesFactory.PyLongFromByteArrayNodeGen.inline(InlineSupport.InlineTarget.create(IntNodes.PyLongFromByteArray.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FromBytesNode_UPDATER.subUpdater(7, 6)}));
            private static final PRaiseNode INLINED_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FromBytesNode_UPDATER.subUpdater(13, 1)}));
            @Node.Child
            private ReadArgumentNode arguments0_;
            @Node.Child
            private ReadArgumentNode arguments1_;
            @Node.Child
            private ReadArgumentNode arguments2_;
            @Node.Child
            private ReadArgumentNode arguments3_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private LookupAndCallUnaryNode callBytes_;
            @Node.Child
            private PythonBufferAccessLibrary bufferLib_;
            @Node.Child
            private TruffleString.EqualNode equalNode_;
            @Node.Child
            private BytesNodes.BytesFromObject bytesFromObject_;
            @Node.Child
            private CallNode callCtor_;

            private FromBytesNodeGen(ReadArgumentNode[] arguments) {
                ReadArgumentNode[] arguments_ = arguments != null ? this.createCasts(arguments) : null;
                this.arguments0_ = arguments_ != null && 0 < arguments_.length ? arguments_[0] : null;
                this.arguments1_ = arguments_ != null && 1 < arguments_.length ? arguments_[1] : null;
                this.arguments2_ = arguments_ != null && 2 < arguments_.length ? arguments_[2] : null;
                this.arguments3_ = arguments_ != null && 3 < arguments_.length ? arguments_[3] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                Object arguments2Value_ = this.arguments2_.execute(frameValue);
                Object arguments3Value_ = this.arguments3_.execute(frameValue);
                if ((state_0 & 1) != 0 && arguments2Value_ instanceof TruffleString) {
                    TruffleString arguments2Value__ = (TruffleString)arguments2Value_;
                    if (arguments3Value_ instanceof Boolean) {
                        CallNode callCtor__;
                        BytesNodes.BytesFromObject bytesFromObject__;
                        TruffleString.EqualNode equalNode__;
                        PythonBufferAccessLibrary bufferLib__;
                        boolean arguments3Value__ = (Boolean)arguments3Value_;
                        LookupAndCallUnaryNode callBytes__ = this.callBytes_;
                        if (callBytes__ != null && (bufferLib__ = this.bufferLib_) != null && (equalNode__ = this.equalNode_) != null && (bytesFromObject__ = this.bytesFromObject_) != null && (callCtor__ = this.callCtor_) != null) {
                            FromBytesNodeGen inliningTarget__ = this;
                            return IntBuiltins.FromBytesNode.fromObject(frameValue, arguments0Value_, arguments1Value_, arguments2Value__, arguments3Value__, inliningTarget__, callBytes__, bufferLib__, INLINED_IS_BUILTIN_INT_PROFILE_, INLINED_HAS_BYTES_PROFILE_, equalNode__, bytesFromObject__, INLINED_FROM_BYTE_ARRAY_, callCtor__, INLINED_RAISE_NODE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, arguments3Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                int state_0 = this.state_0_;
                FromBytesNodeGen inliningTarget__ = null;
                if (arguments2Value instanceof TruffleString) {
                    TruffleString arguments2Value_ = (TruffleString)arguments2Value;
                    if (arguments3Value instanceof Boolean) {
                        boolean arguments3Value_ = (Boolean)arguments3Value;
                        inliningTarget__ = this;
                        LookupAndCallUnaryNode callBytes__ = (LookupAndCallUnaryNode)this.insert(LookupAndCallUnaryNode.create(SpecialMethodNames.T___BYTES__));
                        Objects.requireNonNull(callBytes__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.callBytes_ = callBytes__;
                        PythonBufferAccessLibrary bufferLib__ = (PythonBufferAccessLibrary)this.insert((Node)((PythonBufferAccessLibrary)PYTHON_BUFFER_ACCESS_LIBRARY_.createDispatched(1)));
                        Objects.requireNonNull(bufferLib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.bufferLib_ = bufferLib__;
                        TruffleString.EqualNode equalNode__ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                        Objects.requireNonNull(equalNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.equalNode_ = equalNode__;
                        BytesNodes.BytesFromObject bytesFromObject__ = (BytesNodes.BytesFromObject)this.insert(BytesNodesFactory.BytesFromObjectNodeGen.create());
                        Objects.requireNonNull(bytesFromObject__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.bytesFromObject_ = bytesFromObject__;
                        CallNode callCtor__ = (CallNode)this.insert(CallNode.create());
                        Objects.requireNonNull(callCtor__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.callCtor_ = callCtor__;
                        this.state_0_ = state_0 |= 1;
                        return IntBuiltins.FromBytesNode.fromObject(frameValue, arguments0Value, arguments1Value, arguments2Value_, arguments3Value_, inliningTarget__, callBytes__, bufferLib__, INLINED_IS_BUILTIN_INT_PROFILE_, INLINED_HAS_BYTES_PROFILE_, equalNode__, bytesFromObject__, INLINED_FROM_BYTE_ARRAY_, callCtor__, INLINED_RAISE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_, this.arguments2_, this.arguments3_}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.BoolNode.class)
    public static final class BoolNodeFactory
    implements NodeFactory<IntBuiltins.BoolNode> {
        private static final BoolNodeFactory BOOL_NODE_FACTORY_INSTANCE = new BoolNodeFactory();

        private BoolNodeFactory() {
        }

        public Class<IntBuiltins.BoolNode> getNodeClass() {
            return IntBuiltins.BoolNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.BoolNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return BoolNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public IntBuiltins.BoolNode getUncachedInstance() {
            return BoolNodeGen.UNCACHED;
        }

        public static NodeFactory<IntBuiltins.BoolNode> getInstance() {
            return BOOL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.BoolNode create() {
            return new BoolNodeGen();
        }

        @NeverDefault
        public static IntBuiltins.BoolNode getUncached() {
            return BoolNodeGen.UNCACHED;
        }

        @GeneratedBy(value=IntBuiltins.BoolNode.class)
        public static final class BoolNodeGen
        extends IntBuiltins.BoolNode {
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private InteropLibrary toBoolean4_lib_;

            private BoolNodeGen() {
            }

            @Override
            public boolean executeBool(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (Boolean)arg0Value;
                        return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof Integer) {
                        int arg0Value_ = (Integer)arg0Value;
                        return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof Long) {
                        long arg0Value_ = (Long)arg0Value;
                        return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                    }
                    if ((state_0 & 0x10) != 0 && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        InteropLibrary lib__ = this.toBoolean4_lib_;
                        if (lib__ != null) {
                            return IntBuiltins.BoolNode.toBoolean(arg0Value_, lib__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private boolean executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                }
                if (arg0Value instanceof Integer) {
                    int arg0Value_ = (Integer)arg0Value;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                }
                if (arg0Value instanceof Long) {
                    long arg0Value_ = (Long)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 8;
                    return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    InteropLibrary lib__ = (InteropLibrary)this.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.createDispatched(1)));
                    Objects.requireNonNull(lib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.toBoolean4_lib_ = lib__;
                    this.state_0_ = state_0 |= 0x10;
                    return IntBuiltins.BoolNode.toBoolean(arg0Value_, lib__);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
                return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value});
            }

            @GeneratedBy(value=IntBuiltins.BoolNode.class)
            @DenyReplace
            private static final class Uncached
            extends IntBuiltins.BoolNode
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                public boolean executeBool(VirtualFrame frameValue, Object arg0Value) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    if (arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (Boolean)arg0Value;
                        return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                    }
                    if (arg0Value instanceof Integer) {
                        int arg0Value_ = (Integer)arg0Value;
                        return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                    }
                    if (arg0Value instanceof Long) {
                        long arg0Value_ = (Long)arg0Value;
                        return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return IntBuiltins.BoolNode.toBoolean(arg0Value_);
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        return IntBuiltins.BoolNode.toBoolean(arg0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached());
                    }
                    throw BoolNodeGen.newUnsupportedSpecializationException1(this, arg0Value);
                }
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.StrNode.class)
    static final class StrNodeFactory
    implements NodeFactory<IntBuiltins.StrNode> {
        private static final StrNodeFactory STR_NODE_FACTORY_INSTANCE = new StrNodeFactory();

        private StrNodeFactory() {
        }

        public Class<IntBuiltins.StrNode> getNodeClass() {
            return IntBuiltins.StrNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.StrNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return StrNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.StrNode> getInstance() {
            return STR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.StrNode create() {
            return new StrNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.StrNode.class)
        static final class StrNodeGen
        extends IntBuiltins.StrNode {
            private static final InlineSupport.StateField STATE_0_StrNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedIntValueProfile INLINED_P_INT_MAX_DIGITS_PROFILE_ = InlinedIntValueProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedIntValueProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_StrNode_UPDATER.subUpdater(6, 2), InlineSupport.IntField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"pInt_maxDigitsProfile__field1_")}));
            private static final InlinedIntValueProfile INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_ = InlinedIntValueProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedIntValueProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_StrNode_UPDATER.subUpdater(8, 2), InlineSupport.IntField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"pInt_maxDigitsBitLengthProfile__field1_")}));
            private static final PRaiseNode INLINED_P_INT_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_StrNode_UPDATER.subUpdater(10, 1)}));
            private static final InlineSupport.StateField NATIVE_VOID_PTR_STR_NODE_NATIVE_VOID_PTR_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)NativeVoidPtrData.lookup_(), (String)"nativeVoidPtr_state_0_");
            private static final PyObjectHashNode INLINED_NATIVE_VOID_PTR_HASH_NODE_ = PyObjectHashNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectHashNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{NATIVE_VOID_PTR_STR_NODE_NATIVE_VOID_PTR_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)NativeVoidPtrData.lookup_(), (String)"nativeVoidPtr_hashNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)NativeVoidPtrData.lookup_(), (String)"nativeVoidPtr_hashNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)NativeVoidPtrData.lookup_(), (String)"nativeVoidPtr_hashNode__field3_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private TruffleString.FromLongNode fromLong;
            @Node.Child
            private TruffleString.FromJavaStringNode pInt_fromJavaStringNode_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int pInt_maxDigitsProfile__field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int pInt_maxDigitsBitLengthProfile__field1_;
            @Node.Child
            private NativeVoidPtrData nativeVoidPtr_cache;

            private StrNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x38) >>> 3, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x38) >>> 3, arg0Value);
                        TruffleString.FromLongNode fromLong_ = this.fromLong;
                        if (fromLong_ != null) {
                            return IntBuiltins.StrNode.doL(arg0Value_, fromLong_);
                        }
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        TruffleString.FromJavaStringNode fromJavaStringNode__ = this.pInt_fromJavaStringNode_;
                        if (fromJavaStringNode__ != null) {
                            StrNodeGen inliningTarget__ = this;
                            return IntBuiltins.StrNode.doPInt(arg0Value_, inliningTarget__, fromJavaStringNode__, INLINED_P_INT_MAX_DIGITS_PROFILE_, INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_, INLINED_P_INT_RAISE_NODE_);
                        }
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PythonNativeVoidPtr) {
                        TruffleString.FromLongNode fromLong_1;
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        NativeVoidPtrData s2_ = this.nativeVoidPtr_cache;
                        if (s2_ != null && (fromLong_1 = this.fromLong) != null) {
                            NativeVoidPtrData inliningTarget__1 = s2_;
                            return IntBuiltins.StrNode.doNativeVoidPtr(frameValue, arg0Value_, inliningTarget__1, INLINED_NATIVE_VOID_PTR_HASH_NODE_, fromLong_1);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private TruffleString executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    TruffleString.FromLongNode fromLong_;
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    TruffleString.FromLongNode fromLong__shared = this.fromLong;
                    if (fromLong__shared != null) {
                        fromLong_ = fromLong__shared;
                    } else {
                        fromLong_ = (TruffleString.FromLongNode)this.insert((Node)TruffleString.FromLongNode.create());
                        if (fromLong_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.fromLong == null) {
                        VarHandle.storeStoreFence();
                        this.fromLong = fromLong_;
                    }
                    state_0 |= longCast0 << 3;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.StrNode.doL(arg0Value_, fromLong_);
                }
                StrNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    inliningTarget__ = this;
                    TruffleString.FromJavaStringNode fromJavaStringNode__ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.pInt_fromJavaStringNode_ = fromJavaStringNode__;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.StrNode.doPInt(arg0Value_, inliningTarget__, fromJavaStringNode__, INLINED_P_INT_MAX_DIGITS_PROFILE_, INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_, INLINED_P_INT_RAISE_NODE_);
                }
                NativeVoidPtrData inliningTarget__1 = null;
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    TruffleString.FromLongNode fromLong_1;
                    NativeVoidPtrData s2_;
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    inliningTarget__1 = s2_ = (NativeVoidPtrData)this.insert(new NativeVoidPtrData());
                    TruffleString.FromLongNode fromLong_1_shared = this.fromLong;
                    if (fromLong_1_shared != null) {
                        fromLong_1 = fromLong_1_shared;
                    } else {
                        fromLong_1 = (TruffleString.FromLongNode)s2_.insert((Node)TruffleString.FromLongNode.create());
                        if (fromLong_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.fromLong == null) {
                        this.fromLong = fromLong_1;
                    }
                    VarHandle.storeStoreFence();
                    this.nativeVoidPtr_cache = s2_;
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.StrNode.doNativeVoidPtr(frameValue, arg0Value_, inliningTarget__1, INLINED_NATIVE_VOID_PTR_HASH_NODE_, fromLong_1);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }

            @GeneratedBy(value=IntBuiltins.StrNode.class)
            @DenyReplace
            private static final class NativeVoidPtrData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int nativeVoidPtr_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node nativeVoidPtr_hashNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node nativeVoidPtr_hashNode__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node nativeVoidPtr_hashNode__field3_;

                NativeVoidPtrData() {
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.ReprNode.class)
    static final class ReprNodeFactory
    implements NodeFactory<IntBuiltins.ReprNode> {
        private static final ReprNodeFactory REPR_NODE_FACTORY_INSTANCE = new ReprNodeFactory();

        private ReprNodeFactory() {
        }

        public Class<IntBuiltins.ReprNode> getNodeClass() {
            return IntBuiltins.ReprNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.ReprNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ReprNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.ReprNode> getInstance() {
            return REPR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.ReprNode create() {
            return new ReprNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.ReprNode.class)
        static final class ReprNodeGen
        extends IntBuiltins.ReprNode {
            private static final InlineSupport.StateField STATE_0_ReprNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final InlinedIntValueProfile INLINED_P_INT_MAX_DIGITS_PROFILE_ = InlinedIntValueProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedIntValueProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ReprNode_UPDATER.subUpdater(6, 2), InlineSupport.IntField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"pInt_maxDigitsProfile__field1_")}));
            private static final InlinedIntValueProfile INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_ = InlinedIntValueProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedIntValueProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ReprNode_UPDATER.subUpdater(8, 2), InlineSupport.IntField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"pInt_maxDigitsBitLengthProfile__field1_")}));
            private static final PRaiseNode INLINED_P_INT_RAISE_NODE_ = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ReprNode_UPDATER.subUpdater(10, 1)}));
            private static final InlineSupport.StateField NATIVE_VOID_PTR_REPR_NODE_NATIVE_VOID_PTR_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)NativeVoidPtrData.lookup_(), (String)"nativeVoidPtr_state_0_");
            private static final PyObjectHashNode INLINED_NATIVE_VOID_PTR_HASH_NODE_ = PyObjectHashNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectHashNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{NATIVE_VOID_PTR_REPR_NODE_NATIVE_VOID_PTR_STATE_0_UPDATER.subUpdater(0, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)NativeVoidPtrData.lookup_(), (String)"nativeVoidPtr_hashNode__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)NativeVoidPtrData.lookup_(), (String)"nativeVoidPtr_hashNode__field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)NativeVoidPtrData.lookup_(), (String)"nativeVoidPtr_hashNode__field3_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            private TruffleString.FromLongNode fromLong;
            @Node.Child
            private TruffleString.FromJavaStringNode pInt_fromJavaStringNode_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int pInt_maxDigitsProfile__field1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int pInt_maxDigitsBitLengthProfile__field1_;
            @Node.Child
            private NativeVoidPtrData nativeVoidPtr_cache;

            private ReprNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x38) >>> 3, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x38) >>> 3, arg0Value);
                        TruffleString.FromLongNode fromLong_ = this.fromLong;
                        if (fromLong_ != null) {
                            return IntBuiltins.StrNode.doL(arg0Value_, fromLong_);
                        }
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        TruffleString.FromJavaStringNode fromJavaStringNode__ = this.pInt_fromJavaStringNode_;
                        if (fromJavaStringNode__ != null) {
                            ReprNodeGen inliningTarget__ = this;
                            return IntBuiltins.StrNode.doPInt(arg0Value_, inliningTarget__, fromJavaStringNode__, INLINED_P_INT_MAX_DIGITS_PROFILE_, INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_, INLINED_P_INT_RAISE_NODE_);
                        }
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PythonNativeVoidPtr) {
                        TruffleString.FromLongNode fromLong_1;
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        NativeVoidPtrData s2_ = this.nativeVoidPtr_cache;
                        if (s2_ != null && (fromLong_1 = this.fromLong) != null) {
                            NativeVoidPtrData inliningTarget__1 = s2_;
                            return IntBuiltins.StrNode.doNativeVoidPtr(frameValue, arg0Value_, inliningTarget__1, INLINED_NATIVE_VOID_PTR_HASH_NODE_, fromLong_1);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value);
            }

            private TruffleString executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    TruffleString.FromLongNode fromLong_;
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    TruffleString.FromLongNode fromLong__shared = this.fromLong;
                    if (fromLong__shared != null) {
                        fromLong_ = fromLong__shared;
                    } else {
                        fromLong_ = (TruffleString.FromLongNode)this.insert((Node)TruffleString.FromLongNode.create());
                        if (fromLong_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.fromLong == null) {
                        VarHandle.storeStoreFence();
                        this.fromLong = fromLong_;
                    }
                    state_0 |= longCast0 << 3;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.StrNode.doL(arg0Value_, fromLong_);
                }
                ReprNodeGen inliningTarget__ = null;
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    inliningTarget__ = this;
                    TruffleString.FromJavaStringNode fromJavaStringNode__ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    Objects.requireNonNull(fromJavaStringNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.pInt_fromJavaStringNode_ = fromJavaStringNode__;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.StrNode.doPInt(arg0Value_, inliningTarget__, fromJavaStringNode__, INLINED_P_INT_MAX_DIGITS_PROFILE_, INLINED_P_INT_MAX_DIGITS_BIT_LENGTH_PROFILE_, INLINED_P_INT_RAISE_NODE_);
                }
                NativeVoidPtrData inliningTarget__1 = null;
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    TruffleString.FromLongNode fromLong_1;
                    NativeVoidPtrData s2_;
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    inliningTarget__1 = s2_ = (NativeVoidPtrData)this.insert(new NativeVoidPtrData());
                    TruffleString.FromLongNode fromLong_1_shared = this.fromLong;
                    if (fromLong_1_shared != null) {
                        fromLong_1 = fromLong_1_shared;
                    } else {
                        fromLong_1 = (TruffleString.FromLongNode)s2_.insert((Node)TruffleString.FromLongNode.create());
                        if (fromLong_1 == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.fromLong == null) {
                        this.fromLong = fromLong_1;
                    }
                    VarHandle.storeStoreFence();
                    this.nativeVoidPtr_cache = s2_;
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.StrNode.doNativeVoidPtr(frameValue, arg0Value_, inliningTarget__1, INLINED_NATIVE_VOID_PTR_HASH_NODE_, fromLong_1);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }

            @GeneratedBy(value=IntBuiltins.ReprNode.class)
            @DenyReplace
            private static final class NativeVoidPtrData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @CompilerDirectives.CompilationFinal
                @InlineSupport.UnsafeAccessedField
                private int nativeVoidPtr_state_0_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node nativeVoidPtr_hashNode__field1_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node nativeVoidPtr_hashNode__field2_;
                @Node.Child
                @InlineSupport.UnsafeAccessedField
                private Node nativeVoidPtr_hashNode__field3_;

                NativeVoidPtrData() {
                }

                private static MethodHandles.Lookup lookup_() {
                    return MethodHandles.lookup();
                }
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.FormatNode.class)
    static final class FormatNodeFactory
    implements NodeFactory<IntBuiltins.FormatNode> {
        private static final FormatNodeFactory FORMAT_NODE_FACTORY_INSTANCE = new FormatNodeFactory();

        private FormatNodeFactory() {
        }

        public Class<IntBuiltins.FormatNode> getNodeClass() {
            return IntBuiltins.FormatNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.FormatNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FormatNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.FormatNode> getInstance() {
            return FORMAT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.FormatNode create() {
            return new FormatNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.FormatNode.class)
        static final class FormatNodeGen
        extends IntBuiltins.FormatNode {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PRaiseNode INLINED_RAISE_NODE = PRaiseNodeGen.inline(InlineSupport.InlineTarget.create(PRaiseNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(9, 1)}));
            private static final PyNumberFloatNode INLINED_FLOAT_NODE = PyNumberFloatNodeGen.inline(InlineSupport.InlineTarget.create(PyNumberFloatNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(10, 5), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"floatNode_field1_", Node.class)}));
            private static final InlineSupport.StateField STATE_0_FormatNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyObjectStrAsObjectNode INLINED_FORMAT_EMPTY_STRING_STR_ = PyObjectStrAsObjectNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectStrAsObjectNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_FormatNode_UPDATER.subUpdater(5, 4), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"formatEmptyString_str__field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"formatEmptyString_str__field2_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node floatNode_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node formatEmptyString_str__field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node formatEmptyString_str__field2_;

            private FormatNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1F) != 0 && arg1Value instanceof TruffleString) {
                    int arg0Value_;
                    TruffleString arg1Value_ = (TruffleString)arg1Value;
                    if ((state_0 & 1) != 0 && arg1Value_.isEmpty()) {
                        FormatNodeGen inliningTarget__ = this;
                        return FormatNodeBase.formatEmptyString(frameValue, arg0Value, arg1Value_, inliningTarget__, INLINED_FORMAT_EMPTY_STRING_STR_);
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof Boolean) {
                        arg0Value_ = ((Boolean)arg0Value).booleanValue();
                        if (!arg1Value_.isEmpty()) {
                            FormatNodeGen inliningTarget__1 = this;
                            return IntBuiltins.FormatNode.formatB(arg0Value_ != 0, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof Integer) {
                        arg0Value_ = (Integer)arg0Value;
                        if (!arg1Value_.isEmpty()) {
                            FormatNodeGen inliningTarget__2 = this;
                            return IntBuiltins.FormatNode.formatI(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof Long) {
                        long arg0Value_2 = (Long)arg0Value;
                        if (!arg1Value_.isEmpty()) {
                            FormatNodeGen inliningTarget__3 = this;
                            PythonLanguage language__ = PythonLanguage.get(this);
                            return IntBuiltins.FormatNode.formatL(frameValue, arg0Value_2, arg1Value_, inliningTarget__3, language__, INLINED_FLOAT_NODE, INLINED_RAISE_NODE);
                        }
                    }
                    if ((state_0 & 0x10) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_3 = (PInt)arg0Value;
                        if (!arg1Value_.isEmpty()) {
                            FormatNodeGen inliningTarget__4 = this;
                            return IntBuiltins.FormatNode.formatPI(frameValue, arg0Value_3, arg1Value_, inliningTarget__4, INLINED_FLOAT_NODE, INLINED_RAISE_NODE);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof TruffleString) {
                    int arg0Value_;
                    TruffleString arg1Value_ = (TruffleString)arg1Value;
                    FormatNodeGen inliningTarget__ = null;
                    if (arg1Value_.isEmpty()) {
                        inliningTarget__ = this;
                        this.state_0_ = state_0 |= 1;
                        return FormatNodeBase.formatEmptyString(frameValue, arg0Value, arg1Value_, inliningTarget__, INLINED_FORMAT_EMPTY_STRING_STR_);
                    }
                    FormatNodeGen inliningTarget__1 = null;
                    if (arg0Value instanceof Boolean) {
                        arg0Value_ = ((Boolean)arg0Value).booleanValue();
                        if (!arg1Value_.isEmpty()) {
                            inliningTarget__1 = this;
                            this.state_0_ = state_0 |= 2;
                            return IntBuiltins.FormatNode.formatB(arg0Value_ != 0, arg1Value_, inliningTarget__1, INLINED_RAISE_NODE);
                        }
                    }
                    FormatNodeGen inliningTarget__2 = null;
                    if (arg0Value instanceof Integer) {
                        arg0Value_ = (Integer)arg0Value;
                        if (!arg1Value_.isEmpty()) {
                            inliningTarget__2 = this;
                            this.state_0_ = state_0 |= 4;
                            return IntBuiltins.FormatNode.formatI(arg0Value_, arg1Value_, inliningTarget__2, INLINED_RAISE_NODE);
                        }
                    }
                    PythonLanguage language__ = null;
                    FormatNodeGen inliningTarget__3 = null;
                    if (arg0Value instanceof Long) {
                        long arg0Value_2 = (Long)arg0Value;
                        if (!arg1Value_.isEmpty()) {
                            inliningTarget__3 = this;
                            language__ = PythonLanguage.get(this);
                            this.state_0_ = state_0 |= 8;
                            return IntBuiltins.FormatNode.formatL(frameValue, arg0Value_2, arg1Value_, inliningTarget__3, language__, INLINED_FLOAT_NODE, INLINED_RAISE_NODE);
                        }
                    }
                    FormatNodeGen inliningTarget__4 = null;
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_3 = (PInt)arg0Value;
                        if (!arg1Value_.isEmpty()) {
                            inliningTarget__4 = this;
                            this.state_0_ = state_0 |= 0x10;
                            return IntBuiltins.FormatNode.formatPI(frameValue, arg0Value_3, arg1Value_, inliningTarget__4, INLINED_FLOAT_NODE, INLINED_RAISE_NODE);
                        }
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value, arg1Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.HashNode.class)
    public static final class HashNodeFactory
    implements NodeFactory<IntBuiltins.HashNode> {
        private static final HashNodeFactory HASH_NODE_FACTORY_INSTANCE = new HashNodeFactory();

        private HashNodeFactory() {
        }

        public Class<IntBuiltins.HashNode> getNodeClass() {
            return IntBuiltins.HashNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.HashNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return HashNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public IntBuiltins.HashNode getUncachedInstance() {
            return HashNodeGen.UNCACHED;
        }

        public static NodeFactory<IntBuiltins.HashNode> getInstance() {
            return HASH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.HashNode create() {
            return new HashNodeGen();
        }

        @NeverDefault
        public static IntBuiltins.HashNode getUncached() {
            return HashNodeGen.UNCACHED;
        }

        @GeneratedBy(value=IntBuiltins.HashNode.class)
        public static final class HashNodeGen
        extends IntBuiltins.HashNode {
            static final InlineSupport.ReferenceField<Hash3Data> HASH3_CACHE_UPDATER = InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"hash3_cache", Hash3Data.class);
            private static final Uncached UNCACHED = new Uncached();
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Hash3Data hash3_cache;

            private HashNodeGen() {
            }

            @Override
            public long executeLong(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1F) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60) >>> 5, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60) >>> 5, arg0Value);
                        return IntBuiltins.HashNode.hash(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380) >>> 7, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380) >>> 7, arg0Value);
                        return IntBuiltins.HashNode.hash(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return IntBuiltins.HashNode.hash(arg0Value_);
                    }
                    if ((state_0 & 0x18) != 0 && arg0Value instanceof PythonNativeVoidPtr) {
                        Hash3Data s3_;
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if ((state_0 & 8) != 0 && (s3_ = this.hash3_cache) != null && s3_.lib_.accepts(arg0Value_.getPointerObject())) {
                            return IntBuiltins.HashNode.hash(arg0Value_, s3_.lib_);
                        }
                        if ((state_0 & 0x10) != 0) {
                            return this.hash4Boundary(state_0, arg0Value_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @CompilerDirectives.TruffleBoundary
            private long hash4Boundary(int state_0, PythonNativeVoidPtr arg0Value_) {
                EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                Node prev_ = encapsulating_.set((Node)this);
                try {
                    InteropLibrary lib__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value_.getPointerObject());
                    long l = IntBuiltins.HashNode.hash(arg0Value_, lib__);
                    return l;
                }
                finally {
                    encapsulating_.set(prev_);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    state_0 |= intCast0 << 5;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.HashNode.hash(arg0Value_);
                }
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 7;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.HashNode.hash(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.HashNode.hash(arg0Value_);
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    if ((state_0 & 0x10) == 0) {
                        Hash3Data s3_;
                        block11: {
                            Hash3Data s3_original;
                            do {
                                int count3_ = 0;
                                s3_original = s3_ = (Hash3Data)((Object)HASH3_CACHE_UPDATER.getVolatile((Node)this));
                                if (s3_ != null && !s3_.lib_.accepts(arg0Value_.getPointerObject())) {
                                    ++count3_;
                                    s3_ = null;
                                }
                                if (s3_ != null || count3_ >= true) break block11;
                                s3_ = (Hash3Data)this.insert(new Hash3Data());
                                InteropLibrary lib__ = (InteropLibrary)s3_.insert((Node)((InteropLibrary)INTEROP_LIBRARY_.create(arg0Value_.getPointerObject())));
                                Objects.requireNonNull(lib__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s3_.lib_ = lib__;
                            } while (!HASH3_CACHE_UPDATER.compareAndSet((Node)this, (Object)s3_original, (Object)s3_));
                            this.state_0_ = state_0 |= 8;
                        }
                        if (s3_ != null) {
                            return IntBuiltins.HashNode.hash(arg0Value_, s3_.lib_);
                        }
                    }
                    InteropLibrary lib__ = null;
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set((Node)this);
                    try {
                        lib__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value_.getPointerObject());
                        this.hash3_cache = null;
                        state_0 &= 0xFFFFFFF7;
                        this.state_0_ = state_0 |= 0x10;
                        long l = IntBuiltins.HashNode.hash(arg0Value_, lib__);
                        return l;
                    }
                    finally {
                        encapsulating_.set(prev_);
                    }
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }

            @CompilerDirectives.TruffleBoundary
            private static UnsupportedSpecializationException newUnsupportedSpecializationException1(Node thisNode_, Object arg0Value) {
                return new UnsupportedSpecializationException(thisNode_, null, new Object[]{arg0Value});
            }

            @GeneratedBy(value=IntBuiltins.HashNode.class)
            @DenyReplace
            private static final class Hash3Data
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                InteropLibrary lib_;

                Hash3Data() {
                }
            }

            @GeneratedBy(value=IntBuiltins.HashNode.class)
            @DenyReplace
            private static final class Uncached
            extends IntBuiltins.HashNode
            implements UnadoptableNode {
                private Uncached() {
                }

                @Override
                public long executeLong(VirtualFrame frameValue, Object arg0Value) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    if (PythonIntegerTypesGen.isImplicitInteger(arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(arg0Value);
                        return IntBuiltins.HashNode.hash(arg0Value_);
                    }
                    if (PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(arg0Value);
                        return IntBuiltins.HashNode.hash(arg0Value_);
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return IntBuiltins.HashNode.hash(arg0Value_);
                    }
                    if (arg0Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        return IntBuiltins.HashNode.hash(arg0Value_, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value_.getPointerObject()));
                    }
                    throw HashNodeGen.newUnsupportedSpecializationException1(this, arg0Value);
                }
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.BitCountNode.class)
    static final class BitCountNodeFactory
    implements NodeFactory<IntBuiltins.BitCountNode> {
        private static final BitCountNodeFactory BIT_COUNT_NODE_FACTORY_INSTANCE = new BitCountNodeFactory();

        private BitCountNodeFactory() {
        }

        public Class<IntBuiltins.BitCountNode> getNodeClass() {
            return IntBuiltins.BitCountNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public IntBuiltins.BitCountNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return BitCountNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.BitCountNode> getInstance() {
            return BIT_COUNT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.BitCountNode create(ReadArgumentNode[] arguments) {
            return new BitCountNodeGen(arguments);
        }

        @GeneratedBy(value=IntBuiltins.BitCountNode.class)
        static final class BitCountNodeGen
        extends IntBuiltins.BitCountNode {
            @Node.Child
            private ReadArgumentNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private BitCountNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x18) >>> 3, arguments0Value_)) {
                        int arguments0Value__ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x18) >>> 3, arguments0Value_);
                        return IntBuiltins.BitCountNode.bitCount(arguments0Value__);
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE0) >>> 5, arguments0Value_)) {
                        long arguments0Value__ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE0) >>> 5, arguments0Value_);
                        return IntBuiltins.BitCountNode.bitCount(arguments0Value__);
                    }
                    if ((state_0 & 4) != 0 && arguments0Value_ instanceof PInt) {
                        PInt arguments0Value__ = (PInt)arguments0Value_;
                        return IntBuiltins.BitCountNode.bitCount(arguments0Value__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arguments0Value_);
            }

            private int executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arguments0Value);
                if (intCast0 != 0) {
                    int arguments0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arguments0Value);
                    state_0 |= intCast0 << 3;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.BitCountNode.bitCount(arguments0Value_);
                }
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arguments0Value);
                if (longCast0 != 0) {
                    long arguments0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arguments0Value);
                    state_0 |= longCast0 << 5;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.BitCountNode.bitCount(arguments0Value_);
                }
                if (arguments0Value instanceof PInt) {
                    PInt arguments0Value_ = (PInt)arguments0Value;
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.BitCountNode.bitCount(arguments0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_}, new Object[]{arguments0Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.BitLengthNode.class)
    public static final class BitLengthNodeFactory
    implements NodeFactory<IntBuiltins.BitLengthNode> {
        private static final BitLengthNodeFactory BIT_LENGTH_NODE_FACTORY_INSTANCE = new BitLengthNodeFactory();

        private BitLengthNodeFactory() {
        }

        public Class<IntBuiltins.BitLengthNode> getNodeClass() {
            return IntBuiltins.BitLengthNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.BitLengthNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return BitLengthNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.BitLengthNode> getInstance() {
            return BIT_LENGTH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.BitLengthNode create() {
            return new BitLengthNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.BitLengthNode.class)
        public static final class BitLengthNodeGen
        extends IntBuiltins.BitLengthNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private BitLengthNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x18) >>> 3, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x18) >>> 3, arg0Value);
                        return IntBuiltins.BitLengthNode.bitLength(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE0) >>> 5, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE0) >>> 5, arg0Value);
                        return IntBuiltins.BitLengthNode.bitLength(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return IntBuiltins.BitLengthNode.bitLength(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            @Override
            public int execute(Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x18) >>> 3, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x18) >>> 3, arg0Value);
                        return IntBuiltins.BitLengthNode.bitLength(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE0) >>> 5, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE0) >>> 5, arg0Value);
                        return IntBuiltins.BitLengthNode.bitLength(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return IntBuiltins.BitLengthNode.bitLength(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private int executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    state_0 |= intCast0 << 3;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.BitLengthNode.bitLength(arg0Value_);
                }
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 5;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.BitLengthNode.bitLength(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.BitLengthNode.bitLength(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.IsIntegerNode.class)
    static final class IsIntegerNodeFactory
    implements NodeFactory<IntBuiltins.IsIntegerNode> {
        private static final IsIntegerNodeFactory IS_INTEGER_NODE_FACTORY_INSTANCE = new IsIntegerNodeFactory();

        private IsIntegerNodeFactory() {
        }

        public Class<IntBuiltins.IsIntegerNode> getNodeClass() {
            return IntBuiltins.IsIntegerNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.IsIntegerNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return IsIntegerNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.IsIntegerNode> getInstance() {
            return IS_INTEGER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.IsIntegerNode create() {
            return new IsIntegerNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.IsIntegerNode.class)
        static final class IsIntegerNodeGen
        extends IntBuiltins.IsIntegerNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private IsIntegerNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C) >>> 2, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C) >>> 2, arg0Value);
                        return IntBuiltins.IsIntegerNode.doLong(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return IntBuiltins.IsIntegerNode.doPInt(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private boolean executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 2;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.IsIntegerNode.doLong(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.IsIntegerNode.doPInt(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.RealNode.class)
    static final class RealNodeFactory
    implements NodeFactory<IntBuiltins.RealNode> {
        private static final RealNodeFactory REAL_NODE_FACTORY_INSTANCE = new RealNodeFactory();

        private RealNodeFactory() {
        }

        public Class<IntBuiltins.RealNode> getNodeClass() {
            return IntBuiltins.RealNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.RealNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return RealNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.RealNode> getInstance() {
            return REAL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.RealNode create() {
            return new RealNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.RealNode.class)
        static final class RealNodeGen
        extends IntBuiltins.RealNode {
            private static final InlineSupport.StateField STATE_0_RealNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineSupport.InlineTarget.create(PyLongCopy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_RealNode_UPDATER.subUpdater(0, 10)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private RealNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                RealNodeGen inliningTarget__ = this;
                return IntBuiltins.IntNode.doCopy(arg0Value, inliningTarget__, INLINED_COPY_);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.ImagNode.class)
    static final class ImagNodeFactory
    implements NodeFactory<IntBuiltins.ImagNode> {
        private static final ImagNodeFactory IMAG_NODE_FACTORY_INSTANCE = new ImagNodeFactory();

        private ImagNodeFactory() {
        }

        public Class<IntBuiltins.ImagNode> getNodeClass() {
            return IntBuiltins.ImagNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public IntBuiltins.ImagNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return ImagNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.ImagNode> getInstance() {
            return IMAG_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.ImagNode create(ReadArgumentNode[] arguments) {
            return new ImagNodeGen(arguments);
        }

        @GeneratedBy(value=IntBuiltins.ImagNode.class)
        static final class ImagNodeGen
        extends IntBuiltins.ImagNode {
            @Node.Child
            private ReadArgumentNode arguments0_;

            private ImagNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return IntBuiltins.ImagNode.get(arguments0Value_);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.NumeratorNode.class)
    static final class NumeratorNodeFactory
    implements NodeFactory<IntBuiltins.NumeratorNode> {
        private static final NumeratorNodeFactory NUMERATOR_NODE_FACTORY_INSTANCE = new NumeratorNodeFactory();

        private NumeratorNodeFactory() {
        }

        public Class<IntBuiltins.NumeratorNode> getNodeClass() {
            return IntBuiltins.NumeratorNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.NumeratorNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return NumeratorNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.NumeratorNode> getInstance() {
            return NUMERATOR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.NumeratorNode create() {
            return new NumeratorNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.NumeratorNode.class)
        static final class NumeratorNodeGen
        extends IntBuiltins.NumeratorNode {
            private static final InlineSupport.StateField STATE_0_NumeratorNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineSupport.InlineTarget.create(PyLongCopy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_NumeratorNode_UPDATER.subUpdater(0, 10)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private NumeratorNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                NumeratorNodeGen inliningTarget__ = this;
                return IntBuiltins.IntNode.doCopy(arg0Value, inliningTarget__, INLINED_COPY_);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.ConjugateNode.class)
    static final class ConjugateNodeFactory
    implements NodeFactory<IntBuiltins.ConjugateNode> {
        private static final ConjugateNodeFactory CONJUGATE_NODE_FACTORY_INSTANCE = new ConjugateNodeFactory();

        private ConjugateNodeFactory() {
        }

        public Class<IntBuiltins.ConjugateNode> getNodeClass() {
            return IntBuiltins.ConjugateNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.ConjugateNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return ConjugateNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.ConjugateNode> getInstance() {
            return CONJUGATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.ConjugateNode create() {
            return new ConjugateNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.ConjugateNode.class)
        static final class ConjugateNodeGen
        extends IntBuiltins.ConjugateNode {
            private static final InlineSupport.StateField STATE_0_ConjugateNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineSupport.InlineTarget.create(PyLongCopy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_ConjugateNode_UPDATER.subUpdater(0, 10)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private ConjugateNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                ConjugateNodeGen inliningTarget__ = this;
                return IntBuiltins.IntNode.doCopy(arg0Value, inliningTarget__, INLINED_COPY_);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.DenominatorNode.class)
    static final class DenominatorNodeFactory
    implements NodeFactory<IntBuiltins.DenominatorNode> {
        private static final DenominatorNodeFactory DENOMINATOR_NODE_FACTORY_INSTANCE = new DenominatorNodeFactory();

        private DenominatorNodeFactory() {
        }

        public Class<IntBuiltins.DenominatorNode> getNodeClass() {
            return IntBuiltins.DenominatorNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public IntBuiltins.DenominatorNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return DenominatorNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.DenominatorNode> getInstance() {
            return DENOMINATOR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.DenominatorNode create(ReadArgumentNode[] arguments) {
            return new DenominatorNodeGen(arguments);
        }

        @GeneratedBy(value=IntBuiltins.DenominatorNode.class)
        static final class DenominatorNodeGen
        extends IntBuiltins.DenominatorNode {
            @Node.Child
            private ReadArgumentNode arguments0_;

            private DenominatorNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return IntBuiltins.DenominatorNode.get(arguments0Value_);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.AsIntegerRatioNode.class)
    static final class AsIntegerRatioNodeFactory
    implements NodeFactory<IntBuiltins.AsIntegerRatioNode> {
        private static final AsIntegerRatioNodeFactory AS_INTEGER_RATIO_NODE_FACTORY_INSTANCE = new AsIntegerRatioNodeFactory();

        private AsIntegerRatioNodeFactory() {
        }

        public Class<IntBuiltins.AsIntegerRatioNode> getNodeClass() {
            return IntBuiltins.AsIntegerRatioNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(ReadArgumentNode.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of(ReadArgumentNode[].class));
        }

        public IntBuiltins.AsIntegerRatioNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return AsIntegerRatioNodeFactory.create((ReadArgumentNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.AsIntegerRatioNode> getInstance() {
            return AS_INTEGER_RATIO_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.AsIntegerRatioNode create(ReadArgumentNode[] arguments) {
            return new AsIntegerRatioNodeGen(arguments);
        }

        @GeneratedBy(value=IntBuiltins.AsIntegerRatioNode.class)
        static final class AsIntegerRatioNodeGen
        extends IntBuiltins.AsIntegerRatioNode {
            @Node.Child
            private ReadArgumentNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private IntBuiltins.IntNode intNode_;

            private AsIntegerRatioNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                IntBuiltins.IntNode intNode__;
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 && (intNode__ = this.intNode_) != null) {
                    PythonLanguage language__ = PythonLanguage.get(this);
                    return IntBuiltins.AsIntegerRatioNode.get(frameValue, arguments0Value_, intNode__, language__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arguments0Value_);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arguments0Value) {
                int state_0 = this.state_0_;
                PythonLanguage language__ = null;
                IntBuiltins.IntNode intNode__ = (IntBuiltins.IntNode)this.insert(IntNodeFactory.create());
                Objects.requireNonNull(intNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.intNode_ = intNode__;
                language__ = PythonLanguage.get(this);
                this.state_0_ = state_0 |= 1;
                return IntBuiltins.AsIntegerRatioNode.get(frameValue, arguments0Value, intNode__, language__);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.TruncNode.class)
    static final class TruncNodeFactory
    implements NodeFactory<IntBuiltins.TruncNode> {
        private static final TruncNodeFactory TRUNC_NODE_FACTORY_INSTANCE = new TruncNodeFactory();

        private TruncNodeFactory() {
        }

        public Class<IntBuiltins.TruncNode> getNodeClass() {
            return IntBuiltins.TruncNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.TruncNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return TruncNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.TruncNode> getInstance() {
            return TRUNC_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.TruncNode create() {
            return new TruncNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.TruncNode.class)
        static final class TruncNodeGen
        extends IntBuiltins.TruncNode {
            private static final InlineSupport.StateField STATE_0_TruncNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineSupport.InlineTarget.create(PyLongCopy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_TruncNode_UPDATER.subUpdater(0, 10)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private TruncNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                TruncNodeGen inliningTarget__ = this;
                return IntBuiltins.IntNode.doCopy(arg0Value, inliningTarget__, INLINED_COPY_);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.IntNode.class)
    static final class IntNodeFactory
    implements NodeFactory<IntBuiltins.IntNode> {
        private static final IntNodeFactory INT_NODE_FACTORY_INSTANCE = new IntNodeFactory();

        private IntNodeFactory() {
        }

        public Class<IntBuiltins.IntNode> getNodeClass() {
            return IntBuiltins.IntNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.IntNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return IntNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.IntNode> getInstance() {
            return INT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.IntNode create() {
            return new IntNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.IntNode.class)
        static final class IntNodeGen
        extends IntBuiltins.IntNode {
            private static final InlineSupport.StateField STATE_0_IntNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineSupport.InlineTarget.create(PyLongCopy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_IntNode_UPDATER.subUpdater(0, 10)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private IntNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                IntNodeGen inliningTarget__ = this;
                return IntBuiltins.IntNode.doCopy(arg0Value, inliningTarget__, INLINED_COPY_);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.GetNewArgsNode.class)
    static final class GetNewArgsNodeFactory
    implements NodeFactory<IntBuiltins.GetNewArgsNode> {
        private static final GetNewArgsNodeFactory GET_NEW_ARGS_NODE_FACTORY_INSTANCE = new GetNewArgsNodeFactory();

        private GetNewArgsNodeFactory() {
        }

        public Class<IntBuiltins.GetNewArgsNode> getNodeClass() {
            return IntBuiltins.GetNewArgsNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.GetNewArgsNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return GetNewArgsNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<IntBuiltins.GetNewArgsNode> getInstance() {
            return GET_NEW_ARGS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.GetNewArgsNode create() {
            return new GetNewArgsNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.GetNewArgsNode.class)
        static final class GetNewArgsNodeGen
        extends IntBuiltins.GetNewArgsNode {
            private static final InlineSupport.StateField STATE_0_GetNewArgsNode_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyLongCopy INLINED_COPY_ = PyLongCopyNodeGen.inline(InlineSupport.InlineTarget.create(PyLongCopy.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_GetNewArgsNode_UPDATER.subUpdater(0, 10)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;

            private GetNewArgsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                GetNewArgsNodeGen inliningTarget__ = this;
                PythonLanguage language__ = PythonLanguage.get(this);
                return IntBuiltins.GetNewArgsNode.doI(arg0Value, inliningTarget__, language__, INLINED_COPY_);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.FloatNode.class)
    public static final class FloatNodeFactory
    implements NodeFactory<IntBuiltins.FloatNode> {
        private static final FloatNodeFactory FLOAT_NODE_FACTORY_INSTANCE = new FloatNodeFactory();

        private FloatNodeFactory() {
        }

        public Class<IntBuiltins.FloatNode> getNodeClass() {
            return IntBuiltins.FloatNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public IntBuiltins.FloatNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return FloatNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<IntBuiltins.FloatNode> getInstance() {
            return FLOAT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IntBuiltins.FloatNode create() {
            return new FloatNodeGen();
        }

        @GeneratedBy(value=IntBuiltins.FloatNode.class)
        public static final class FloatNodeGen
        extends IntBuiltins.FloatNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private FloatNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value) {
                if (((state_0 & 4) == 0 || (state_0 & 0x380) != 896) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                    return false;
                }
                return (state_0 & 8) != 0 || !(arg0Value instanceof PInt);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1F) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (Boolean)arg0Value;
                        return IntBuiltins.FloatNode.doBoolean(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x60) >>> 5, arg0Value)) {
                        int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x60) >>> 5, arg0Value);
                        return IntBuiltins.FloatNode.doInt(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x380) >>> 7, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x380) >>> 7, arg0Value);
                        return IntBuiltins.FloatNode.doLong(arg0Value_);
                    }
                    if ((state_0 & 8) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return this.doPInt(arg0Value_);
                    }
                    if ((state_0 & 0x10) != 0 && this.fallbackGuard_(state_0, arg0Value)) {
                        return IntBuiltins.FloatNode.doGeneric(arg0Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return IntBuiltins.FloatNode.doBoolean(arg0Value_);
                }
                int intCast0 = PythonIntegerTypesGen.specializeImplicitInteger(arg0Value);
                if (intCast0 != 0) {
                    int arg0Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast0, arg0Value);
                    state_0 |= intCast0 << 5;
                    this.state_0_ = state_0 |= 2;
                    return IntBuiltins.FloatNode.doInt(arg0Value_);
                }
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 7;
                    this.state_0_ = state_0 |= 4;
                    return IntBuiltins.FloatNode.doLong(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 8;
                    return this.doPInt(arg0Value_);
                }
                this.state_0_ = state_0 |= 0x10;
                return IntBuiltins.FloatNode.doGeneric(arg0Value);
            }
        }
    }

    @GeneratedBy(value=IntBuiltins.RichCompareHelperNode.class)
    static final class RichCompareHelperNodeGen {
        private static final InlineSupport.StateField VOID_PTR_RICH_COMPARE_HELPER_NODE_VOID_PTR_STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)VoidPtrData.lookup_(), (String)"voidPtr_state_0_");
        private static final CExtNodes.PointerCompareNode INLINED_VOID_PTR_POINTER_COMPARE_NODE_ = CExtNodesFactory.PointerCompareNodeGen.inline(InlineSupport.InlineTarget.create(CExtNodes.PointerCompareNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{VOID_PTR_RICH_COMPARE_HELPER_NODE_VOID_PTR_STATE_0_UPDATER.subUpdater(0, 13), InlineSupport.ReferenceField.create((MethodHandles.Lookup)VoidPtrData.lookup_(), (String)"voidPtr_pointerCompareNode__field1_", Node.class)}));

        RichCompareHelperNodeGen() {
        }

        @NeverDefault
        public static IntBuiltins.RichCompareHelperNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=28, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=5, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Object.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=IntBuiltins.RichCompareHelperNode.class)
        @DenyReplace
        private static final class Inlined
        extends IntBuiltins.RichCompareHelperNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final InlineSupport.ReferenceField<Object> getClass_field1_;
            private final InlineSupport.ReferenceField<Node> getClass_field2_;
            private final InlineSupport.ReferenceField<Node> getClass_field3_;
            private final InlineSupport.ReferenceField<IsSubtypeNode> isSubtype;
            private final InlineSupport.ReferenceField<CExtNodes.FromNativeSubclassNode> nativeRight;
            private final InlineSupport.ReferenceField<CExtNodes.FromNativeSubclassNode> nativeLeft;
            private final InlineSupport.ReferenceField<VoidPtrData> voidPtr_cache;
            private final GetClassNode.GetPythonObjectClassNode getClass;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(IntBuiltins.RichCompareHelperNode.class));
                this.state_0_ = target.getState(0, 28);
                this.state_1_ = target.getState(1, 5);
                this.getClass_field1_ = target.getReference(2, Object.class);
                this.getClass_field2_ = target.getReference(3, Node.class);
                this.getClass_field3_ = target.getReference(4, Node.class);
                this.isSubtype = target.getReference(5, IsSubtypeNode.class);
                this.nativeRight = target.getReference(6, CExtNodes.FromNativeSubclassNode.class);
                this.nativeLeft = target.getReference(7, CExtNodes.FromNativeSubclassNode.class);
                this.voidPtr_cache = target.getReference(8, VoidPtrData.class);
                this.getClass = GetClassNodeGen.GetPythonObjectClassNodeGen.inline(InlineSupport.InlineTarget.create(GetClassNode.GetPythonObjectClassNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{this.state_1_.subUpdater(0, 5), this.getClass_field1_, this.getClass_field2_, this.getClass_field3_}));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, Object arg1Value, Object arg2Value, RichCmpOp arg3Value) {
                PythonAbstractNativeObject arg1Value_;
                if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                    if (((state_0 & 2) == 0 || (state_0 & 0xFC00000) != 0xFC00000) && PythonIntegerTypesGen.isImplicitLong(arg2Value)) {
                        return false;
                    }
                    if (((state_0 & 0x10) == 0 || (state_0 & 0x1C00000) != 0x1C00000) && arg2Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg1Value instanceof PInt) {
                    if (((state_0 & 0x80) == 0 || (state_0 & 0xE000000) != 0xE000000) && PythonIntegerTypesGen.isImplicitLong(arg2Value)) {
                        return false;
                    }
                    if ((state_0 & 0x100) == 0 && arg2Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg2Value instanceof PythonAbstractNativeObject) {
                    if (PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        PythonAbstractNativeObject arg2Value_ = (PythonAbstractNativeObject)arg2Value;
                        GetClassNode.GetPythonObjectClassNode getClass_ = this.getClass;
                        IsSubtypeNode isSubtype_ = (IsSubtypeNode)((Object)this.isSubtype.get(arg0Value));
                        if ((state_0 & 0x400) == 0 || getClass_ == null || isSubtype_ == null || CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, getClass_, isSubtype_)) {
                            return false;
                        }
                    }
                    if (arg1Value instanceof PythonAbstractNativeObject) {
                        arg1Value_ = (PythonAbstractNativeObject)arg1Value;
                        GetClassNode.GetPythonObjectClassNode getClass_1 = this.getClass;
                        IsSubtypeNode isSubtype_1 = (IsSubtypeNode)((Object)this.isSubtype.get(arg0Value));
                        if ((state_0 & 0x1000) == 0 || getClass_1 == null || isSubtype_1 == null || CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, getClass_1, isSubtype_1)) {
                            PythonAbstractNativeObject arg2Value_ = (PythonAbstractNativeObject)arg2Value;
                            if ((state_0 & 0x2000) == 0 || getClass_1 == null || isSubtype_1 == null || CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, getClass_1, isSubtype_1)) {
                                return false;
                            }
                        }
                    }
                }
                if (arg1Value instanceof PythonAbstractNativeObject && arg2Value instanceof Double) {
                    arg1Value_ = (PythonAbstractNativeObject)arg1Value;
                    GetClassNode.GetPythonObjectClassNode getClass_2 = this.getClass;
                    IsSubtypeNode isSubtype_2 = (IsSubtypeNode)((Object)this.isSubtype.get(arg0Value));
                    if ((state_0 & 0x8000) == 0 || getClass_2 == null || isSubtype_2 == null || CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, getClass_2, isSubtype_2)) {
                        return false;
                    }
                }
                return (state_0 & 0x10000) != 0 || !IntBuiltins.RichCompareHelperNode.someIsNativePtr(arg1Value, arg2Value);
            }

            @Override
            Object execute(VirtualFrame frameValue, Node arg0Value, Object arg1Value, Object arg2Value, RichCmpOp arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x34BB7) != 0) {
                    if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitInteger((state_0 & 0xC0000) >>> 18, arg1Value)) {
                        int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0xC0000) >>> 18, arg1Value);
                        if (PythonIntegerTypesGen.isImplicitInteger((state_0 & 0x300000) >>> 20, arg2Value)) {
                            int arg2Value_ = PythonIntegerTypesGen.asImplicitInteger((state_0 & 0x300000) >>> 20, arg2Value);
                            return IntBuiltins.RichCompareHelperNode.doII(arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                    if ((state_0 & 6) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value);
                        if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE000000) >>> 25, arg2Value)) {
                            long arg2Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE000000) >>> 25, arg2Value);
                            return IntBuiltins.RichCompareHelperNode.doLL(arg1Value_, arg2Value_, arg3Value);
                        }
                        if ((state_0 & 4) != 0 && arg2Value instanceof PInt) {
                            PInt arg2Value_ = (PInt)arg2Value;
                            try {
                                return IntBuiltins.RichCompareHelperNode.doLPExact(arg1Value_, arg2Value_, arg3Value);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_.get(arg0Value);
                                state_0 &= 0xFFFFFFFB;
                                this.state_0_.set(arg0Value, state_0 |= 8);
                                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value);
                            }
                        }
                    }
                    if ((state_0 & 0x20) != 0 && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        if (PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE000000) >>> 25, arg2Value)) {
                            long arg2Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE000000) >>> 25, arg2Value);
                            try {
                                return IntBuiltins.RichCompareHelperNode.doPLExact(arg1Value_, arg2Value_, arg3Value);
                            }
                            catch (OverflowException ex) {
                                CompilerDirectives.transferToInterpreterAndInvalidate();
                                state_0 = this.state_0_.get(arg0Value);
                                state_0 &= 0xFFFFFFDF;
                                this.state_0_.set(arg0Value, state_0 |= 0x40);
                                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value);
                            }
                        }
                    }
                    if ((state_0 & 0x10) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value)) {
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value);
                        if (arg2Value instanceof PInt) {
                            PInt arg2Value_ = (PInt)arg2Value;
                            return IntBuiltins.RichCompareHelperNode.doLP(arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                    if ((state_0 & 0x180) != 0 && arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt)arg1Value;
                        if ((state_0 & 0x80) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE000000) >>> 25, arg2Value)) {
                            long arg2Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE000000) >>> 25, arg2Value);
                            return IntBuiltins.RichCompareHelperNode.doPL(arg1Value_, arg2Value_, arg3Value);
                        }
                        if ((state_0 & 0x100) != 0 && arg2Value instanceof PInt) {
                            PInt arg2Value_ = (PInt)arg2Value;
                            return IntBuiltins.RichCompareHelperNode.doPP(arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                    if ((state_0 & 0xA00) != 0 && arg2Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg2Value_ = (PythonAbstractNativeObject)arg2Value;
                        if ((state_0 & 0x200) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value)) {
                            CExtNodes.FromNativeSubclassNode nativeRight_;
                            long arg1Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x1C00000) >>> 22, arg1Value);
                            IsSubtypeNode isSubtype_ = (IsSubtypeNode)((Object)this.isSubtype.get(arg0Value));
                            if (isSubtype_ != null && (nativeRight_ = (CExtNodes.FromNativeSubclassNode)((Object)this.nativeRight.get(arg0Value))) != null && CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, this.getClass, isSubtype_)) {
                                return IntBuiltins.RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_, nativeRight_);
                            }
                        }
                        if ((state_0 & 0x800) != 0 && arg1Value instanceof PythonAbstractNativeObject) {
                            CExtNodes.FromNativeSubclassNode nativeRight_1;
                            CExtNodes.FromNativeSubclassNode nativeLeft_;
                            PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject)arg1Value;
                            IsSubtypeNode isSubtype_1 = (IsSubtypeNode)((Object)this.isSubtype.get(arg0Value));
                            if (isSubtype_1 != null && (nativeLeft_ = (CExtNodes.FromNativeSubclassNode)((Object)this.nativeLeft.get(arg0Value))) != null && (nativeRight_1 = (CExtNodes.FromNativeSubclassNode)((Object)this.nativeRight.get(arg0Value))) != null && CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, this.getClass, isSubtype_1) && CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, this.getClass, isSubtype_1)) {
                                return IntBuiltins.RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_1, nativeLeft_, nativeRight_1);
                            }
                        }
                    }
                    if ((state_0 & 0x4000) != 0 && arg1Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject)arg1Value;
                        if (arg2Value instanceof Double) {
                            CExtNodes.FromNativeSubclassNode nativeLeft_1;
                            double arg2Value_ = (Double)arg2Value;
                            IsSubtypeNode isSubtype_2 = (IsSubtypeNode)((Object)this.isSubtype.get(arg0Value));
                            if (isSubtype_2 != null && (nativeLeft_1 = (CExtNodes.FromNativeSubclassNode)((Object)this.nativeLeft.get(arg0Value))) != null && CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, this.getClass, isSubtype_2)) {
                                return IntBuiltins.RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_2, nativeLeft_1);
                            }
                        }
                    }
                    if ((state_0 & 0x30000) != 0) {
                        VoidPtrData s10_;
                        if ((state_0 & 0x10000) != 0 && (s10_ = (VoidPtrData)((Object)this.voidPtr_cache.get(arg0Value))) != null && IntBuiltins.RichCompareHelperNode.someIsNativePtr(arg1Value, arg2Value)) {
                            return IntBuiltins.RichCompareHelperNode.doVoidPtr(frameValue, s10_, arg1Value, arg2Value, arg3Value, INLINED_VOID_PTR_POINTER_COMPARE_NODE_, s10_.pointerEqNode_);
                        }
                        if ((state_0 & 0x20000) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value)) {
                            return IntBuiltins.RichCompareHelperNode.doGeneric(arg1Value, arg2Value, arg3Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Node arg0Value, Object arg1Value, Object arg2Value, RichCmpOp arg3Value) {
                int longCast1;
                int longCast12;
                int state_0 = this.state_0_.get(arg0Value);
                int intCast1 = PythonIntegerTypesGen.specializeImplicitInteger(arg1Value);
                if (intCast1 != 0) {
                    int arg1Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast1, arg1Value);
                    int intCast2 = PythonIntegerTypesGen.specializeImplicitInteger(arg2Value);
                    if (intCast2 != 0) {
                        int arg2Value_ = PythonIntegerTypesGen.asImplicitInteger(intCast2, arg2Value);
                        state_0 |= intCast1 << 18;
                        state_0 |= intCast2 << 20;
                        this.state_0_.set(arg0Value, state_0 |= 1);
                        return IntBuiltins.RichCompareHelperNode.doII(arg1Value_, arg2Value_, arg3Value);
                    }
                }
                if ((longCast12 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast12, arg1Value);
                    int longCast2 = PythonIntegerTypesGen.specializeImplicitLong(arg2Value);
                    if (longCast2 != 0) {
                        long arg2Value_ = PythonIntegerTypesGen.asImplicitLong(longCast2, arg2Value);
                        state_0 |= longCast12 << 22;
                        state_0 |= longCast2 << 25;
                        this.state_0_.set(arg0Value, state_0 |= 2);
                        return IntBuiltins.RichCompareHelperNode.doLL(arg1Value_, arg2Value_, arg3Value);
                    }
                    if ((state_0 & 0x10) == 0 && (state_0 & 8) == 0 && arg2Value instanceof PInt) {
                        PInt arg2Value_ = (PInt)arg2Value;
                        state_0 |= longCast12 << 22;
                        this.state_0_.set(arg0Value, state_0 |= 4);
                        try {
                            return IntBuiltins.RichCompareHelperNode.doLPExact(arg1Value_, arg2Value_, arg3Value);
                        }
                        catch (OverflowException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_.get(arg0Value);
                            state_0 &= 0xFFFFFFFB;
                            this.state_0_.set(arg0Value, state_0 |= 8);
                            return this.executeAndSpecialize(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                }
                if ((state_0 & 0x80) == 0 && (state_0 & 0x40) == 0 && arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt)arg1Value;
                    int longCast2 = PythonIntegerTypesGen.specializeImplicitLong(arg2Value);
                    if (longCast2 != 0) {
                        long arg2Value_ = PythonIntegerTypesGen.asImplicitLong(longCast2, arg2Value);
                        state_0 |= longCast2 << 25;
                        this.state_0_.set(arg0Value, state_0 |= 0x20);
                        try {
                            return IntBuiltins.RichCompareHelperNode.doPLExact(arg1Value_, arg2Value_, arg3Value);
                        }
                        catch (OverflowException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_.get(arg0Value);
                            state_0 &= 0xFFFFFFDF;
                            this.state_0_.set(arg0Value, state_0 |= 0x40);
                            return this.executeAndSpecialize(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value);
                        }
                    }
                }
                if ((longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                    if (arg2Value instanceof PInt) {
                        PInt arg2Value_ = (PInt)arg2Value;
                        state_0 &= 0xFFFFFFFB;
                        state_0 |= longCast1 << 22;
                        this.state_0_.set(arg0Value, state_0 |= 0x10);
                        return IntBuiltins.RichCompareHelperNode.doLP(arg1Value_, arg2Value_, arg3Value);
                    }
                }
                if (arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt)arg1Value;
                    int longCast2 = PythonIntegerTypesGen.specializeImplicitLong(arg2Value);
                    if (longCast2 != 0) {
                        long arg2Value_ = PythonIntegerTypesGen.asImplicitLong(longCast2, arg2Value);
                        state_0 &= 0xFFFFFFDF;
                        state_0 |= longCast2 << 25;
                        this.state_0_.set(arg0Value, state_0 |= 0x80);
                        return IntBuiltins.RichCompareHelperNode.doPL(arg1Value_, arg2Value_, arg3Value);
                    }
                    if (arg2Value instanceof PInt) {
                        PInt arg2Value_ = (PInt)arg2Value;
                        this.state_0_.set(arg0Value, state_0 |= 0x100);
                        return IntBuiltins.RichCompareHelperNode.doPP(arg1Value_, arg2Value_, arg3Value);
                    }
                }
                if (arg2Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arg2Value_ = (PythonAbstractNativeObject)arg2Value;
                    int longCast13 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast13 != 0) {
                        IsSubtypeNode isSubtype_;
                        long arg1Value_ = PythonIntegerTypesGen.asImplicitLong(longCast13, arg1Value);
                        IsSubtypeNode isSubtype__shared = (IsSubtypeNode)((Object)this.isSubtype.get(arg0Value));
                        if (isSubtype__shared != null) {
                            isSubtype_ = isSubtype__shared;
                        } else {
                            isSubtype_ = (IsSubtypeNode)arg0Value.insert((Node)IsSubtypeNode.create());
                            if (isSubtype_ == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((state_0 & 0x400) == 0) {
                            if (this.isSubtype.get(arg0Value) == null) {
                                VarHandle.storeStoreFence();
                                this.isSubtype.set(arg0Value, (Object)isSubtype_);
                            }
                            state_0 |= 0x400;
                        }
                        if (CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, this.getClass, isSubtype_)) {
                            CExtNodes.FromNativeSubclassNode nativeRight_;
                            CExtNodes.FromNativeSubclassNode nativeRight__shared;
                            if (this.isSubtype.get(arg0Value) == null) {
                                VarHandle.storeStoreFence();
                                this.isSubtype.set(arg0Value, (Object)isSubtype_);
                            }
                            if ((nativeRight__shared = (CExtNodes.FromNativeSubclassNode)((Object)this.nativeRight.get(arg0Value))) != null) {
                                nativeRight_ = nativeRight__shared;
                            } else {
                                nativeRight_ = (CExtNodes.FromNativeSubclassNode)arg0Value.insert((Node)CExtNodes.FromNativeSubclassNode.create());
                                if (nativeRight_ == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.nativeRight.get(arg0Value) == null) {
                                VarHandle.storeStoreFence();
                                this.nativeRight.set(arg0Value, (Object)nativeRight_);
                            }
                            state_0 |= longCast13 << 22;
                            this.state_0_.set(arg0Value, state_0 |= 0x200);
                            return IntBuiltins.RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_, nativeRight_);
                        }
                    }
                    if (arg1Value instanceof PythonAbstractNativeObject) {
                        IsSubtypeNode isSubtype_1;
                        PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject)arg1Value;
                        IsSubtypeNode isSubtype_1_shared = (IsSubtypeNode)((Object)this.isSubtype.get(arg0Value));
                        if (isSubtype_1_shared != null) {
                            isSubtype_1 = isSubtype_1_shared;
                        } else {
                            isSubtype_1 = (IsSubtypeNode)arg0Value.insert((Node)IsSubtypeNode.create());
                            if (isSubtype_1 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((state_0 & 0x1000) == 0) {
                            if (this.isSubtype.get(arg0Value) == null) {
                                VarHandle.storeStoreFence();
                                this.isSubtype.set(arg0Value, (Object)isSubtype_1);
                            }
                            state_0 |= 0x1000;
                        }
                        if (CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, this.getClass, isSubtype_1)) {
                            if ((state_0 & 0x2000) == 0) {
                                if (this.isSubtype.get(arg0Value) == null) {
                                    VarHandle.storeStoreFence();
                                    this.isSubtype.set(arg0Value, (Object)isSubtype_1);
                                }
                                state_0 |= 0x2000;
                            }
                            if (CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg2Value_, this.getClass, isSubtype_1)) {
                                CExtNodes.FromNativeSubclassNode nativeRight_1;
                                CExtNodes.FromNativeSubclassNode nativeRight_1_shared;
                                CExtNodes.FromNativeSubclassNode nativeLeft_;
                                CExtNodes.FromNativeSubclassNode nativeLeft__shared;
                                if (this.isSubtype.get(arg0Value) == null) {
                                    VarHandle.storeStoreFence();
                                    this.isSubtype.set(arg0Value, (Object)isSubtype_1);
                                }
                                if ((nativeLeft__shared = (CExtNodes.FromNativeSubclassNode)((Object)this.nativeLeft.get(arg0Value))) != null) {
                                    nativeLeft_ = nativeLeft__shared;
                                } else {
                                    nativeLeft_ = (CExtNodes.FromNativeSubclassNode)arg0Value.insert((Node)CExtNodes.FromNativeSubclassNode.create());
                                    if (nativeLeft_ == null) {
                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                    }
                                }
                                if (this.nativeLeft.get(arg0Value) == null) {
                                    VarHandle.storeStoreFence();
                                    this.nativeLeft.set(arg0Value, (Object)nativeLeft_);
                                }
                                if ((nativeRight_1_shared = (CExtNodes.FromNativeSubclassNode)((Object)this.nativeRight.get(arg0Value))) != null) {
                                    nativeRight_1 = nativeRight_1_shared;
                                } else {
                                    nativeRight_1 = (CExtNodes.FromNativeSubclassNode)arg0Value.insert((Node)CExtNodes.FromNativeSubclassNode.create());
                                    if (nativeRight_1 == null) {
                                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                    }
                                }
                                if (this.nativeRight.get(arg0Value) == null) {
                                    VarHandle.storeStoreFence();
                                    this.nativeRight.set(arg0Value, (Object)nativeRight_1);
                                }
                                this.state_0_.set(arg0Value, state_0 |= 0x800);
                                return IntBuiltins.RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_1, nativeLeft_, nativeRight_1);
                            }
                        }
                    }
                }
                if (arg1Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject)arg1Value;
                    if (arg2Value instanceof Double) {
                        IsSubtypeNode isSubtype_2;
                        double arg2Value_ = (Double)arg2Value;
                        IsSubtypeNode isSubtype_2_shared = (IsSubtypeNode)((Object)this.isSubtype.get(arg0Value));
                        if (isSubtype_2_shared != null) {
                            isSubtype_2 = isSubtype_2_shared;
                        } else {
                            isSubtype_2 = (IsSubtypeNode)arg0Value.insert((Node)IsSubtypeNode.create());
                            if (isSubtype_2 == null) {
                                throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((state_0 & 0x8000) == 0) {
                            if (this.isSubtype.get(arg0Value) == null) {
                                VarHandle.storeStoreFence();
                                this.isSubtype.set(arg0Value, (Object)isSubtype_2);
                            }
                            state_0 |= 0x8000;
                        }
                        if (CExtNodes.FromNativeSubclassNode.isFloatSubtype(arg0Value, arg1Value_, this.getClass, isSubtype_2)) {
                            CExtNodes.FromNativeSubclassNode nativeLeft_1;
                            CExtNodes.FromNativeSubclassNode nativeLeft_1_shared;
                            if (this.isSubtype.get(arg0Value) == null) {
                                VarHandle.storeStoreFence();
                                this.isSubtype.set(arg0Value, (Object)isSubtype_2);
                            }
                            if ((nativeLeft_1_shared = (CExtNodes.FromNativeSubclassNode)((Object)this.nativeLeft.get(arg0Value))) != null) {
                                nativeLeft_1 = nativeLeft_1_shared;
                            } else {
                                nativeLeft_1 = (CExtNodes.FromNativeSubclassNode)arg0Value.insert((Node)CExtNodes.FromNativeSubclassNode.create());
                                if (nativeLeft_1 == null) {
                                    throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                                }
                            }
                            if (this.nativeLeft.get(arg0Value) == null) {
                                VarHandle.storeStoreFence();
                                this.nativeLeft.set(arg0Value, (Object)nativeLeft_1);
                            }
                            this.state_0_.set(arg0Value, state_0 |= 0x4000);
                            return IntBuiltins.RichCompareHelperNode.doDN(frameValue, arg0Value, arg1Value_, arg2Value_, arg3Value, this.getClass, isSubtype_2, nativeLeft_1);
                        }
                    }
                }
                if (IntBuiltins.RichCompareHelperNode.someIsNativePtr(arg1Value, arg2Value)) {
                    VoidPtrData s10_ = (VoidPtrData)arg0Value.insert((Node)new VoidPtrData());
                    IntBuiltins.RichCompareHelperNode.EqNodeNativePtr pointerEqNode__ = (IntBuiltins.RichCompareHelperNode.EqNodeNativePtr)s10_.insert(EqNodeNativePtrNodeGen.create());
                    Objects.requireNonNull(pointerEqNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s10_.pointerEqNode_ = pointerEqNode__;
                    VarHandle.storeStoreFence();
                    this.voidPtr_cache.set(arg0Value, (Object)s10_);
                    this.state_0_.set(arg0Value, state_0 |= 0x10000);
                    return IntBuiltins.RichCompareHelperNode.doVoidPtr(frameValue, s10_, arg1Value, arg2Value, arg3Value, INLINED_VOID_PTR_POINTER_COMPARE_NODE_, pointerEqNode__);
                }
                this.state_0_.set(arg0Value, state_0 |= 0x20000);
                return IntBuiltins.RichCompareHelperNode.doGeneric(arg1Value, arg2Value, arg3Value);
            }
        }

        @GeneratedBy(value=IntBuiltins.RichCompareHelperNode.class)
        @DenyReplace
        private static final class VoidPtrData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int voidPtr_state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node voidPtr_pointerCompareNode__field1_;
            @Node.Child
            IntBuiltins.RichCompareHelperNode.EqNodeNativePtr pointerEqNode_;

            VoidPtrData() {
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }

        @GeneratedBy(value=IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.class)
        static final class EqNodeNativePtrNodeGen
        extends IntBuiltins.RichCompareHelperNode.EqNodeNativePtr {
            private static final InlineSupport.StateField STATE_0_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_0_");
            private static final PyObjectHashNode INLINED_H = PyObjectHashNodeGen.inline(InlineSupport.InlineTarget.create(PyObjectHashNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_0_UPDATER.subUpdater(15, 7), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field1_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field2_", Node.class), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"h_field3_", Node.class)}));
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_0_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field1_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field2_;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node h_field3_;

            private EqNodeNativePtrNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (arg1Value instanceof PythonNativeVoidPtr) {
                    if (((state_0 & 1) == 0 || (state_0 & 0x7000) != 28672) && PythonIntegerTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if ((state_0 & 2) == 0 && arg0Value instanceof PInt) {
                        return false;
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    if ((state_0 & 4) == 0 && PythonIntegerTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (arg1Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg1Value_;
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (arg0Value_.isNativePointer() && (arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                            return false;
                        }
                        arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (arg0Value_.isNativePointer() && !(arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                            return false;
                        }
                        arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (!arg0Value_.isNativePointer() && (arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                            return false;
                        }
                        arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if (!arg0Value_.isNativePointer() && !(arg1Value_ = (PythonNativeVoidPtr)arg1Value).isNativePointer()) {
                            return false;
                        }
                    }
                    if ((state_0 & 0x80) == 0 && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0x1FF) != 0) {
                    if ((state_0 & 3) != 0 && arg1Value instanceof PythonNativeVoidPtr) {
                        PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                        if ((state_0 & 1) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0xE00) >>> 9, arg0Value)) {
                            long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0xE00) >>> 9, arg0Value);
                            EqNodeNativePtrNodeGen inliningTarget__ = this;
                            return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.eqLongVoidPtr(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                        }
                        if ((state_0 & 2) != 0 && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt)arg0Value;
                            return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.eqPIntVoidPtr(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0xFC) != 0 && arg0Value instanceof PythonNativeVoidPtr) {
                        PythonAbstractObject arg1Value_;
                        PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                        if ((state_0 & 4) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x7000) >>> 12, arg1Value)) {
                            long arg1Value_2 = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x7000) >>> 12, arg1Value);
                            EqNodeNativePtrNodeGen inliningTarget__1 = this;
                            return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrLong(frameValue, arg0Value_, arg1Value_2, inliningTarget__1, INLINED_H);
                        }
                        if ((state_0 & 0x78) != 0 && arg1Value instanceof PythonNativeVoidPtr) {
                            arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                            if ((state_0 & 8) != 0 && arg0Value_.isNativePointer() && ((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.voidPtrsNative(arg0Value_, (PythonNativeVoidPtr)arg1Value_);
                            }
                            if ((state_0 & 0x10) != 0 && arg0Value_.isNativePointer() && !((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                EqNodeNativePtrNodeGen inliningTarget__2 = this;
                                return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.voidPtrsANative(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__2, INLINED_H);
                            }
                            if ((state_0 & 0x20) != 0 && !arg0Value_.isNativePointer() && ((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                EqNodeNativePtrNodeGen inliningTarget__3 = this;
                                return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.voidPtrsBNative(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__3, INLINED_H);
                            }
                            if ((state_0 & 0x40) != 0 && !arg0Value_.isNativePointer() && !((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                                EqNodeNativePtrNodeGen inliningTarget__4 = this;
                                return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.voidPtrsManaged(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__4, INLINED_H);
                            }
                        }
                        if ((state_0 & 0x80) != 0 && arg1Value instanceof PInt) {
                            arg1Value_ = (PInt)arg1Value;
                            return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrPInt(arg0Value_, (PInt)arg1Value_);
                        }
                    }
                    if ((state_0 & 0x100) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof PythonNativeVoidPtr) {
                    PythonNativeVoidPtr arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                    EqNodeNativePtrNodeGen inliningTarget__ = null;
                    int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                    if (longCast0 != 0) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                        inliningTarget__ = this;
                        state_0 |= longCast0 << 9;
                        this.state_0_ = state_0 |= 1;
                        return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.eqLongVoidPtr(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_H);
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        this.state_0_ = state_0 |= 2;
                        return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.eqPIntVoidPtr(arg0Value_, arg1Value_);
                    }
                }
                if (arg0Value instanceof PythonNativeVoidPtr) {
                    PythonAbstractObject arg1Value_;
                    PythonNativeVoidPtr arg0Value_ = (PythonNativeVoidPtr)arg0Value;
                    EqNodeNativePtrNodeGen inliningTarget__1 = null;
                    int longCast1 = PythonIntegerTypesGen.specializeImplicitLong(arg1Value);
                    if (longCast1 != 0) {
                        long arg1Value_2 = PythonIntegerTypesGen.asImplicitLong(longCast1, arg1Value);
                        inliningTarget__1 = this;
                        state_0 |= longCast1 << 12;
                        this.state_0_ = state_0 |= 4;
                        return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrLong(frameValue, arg0Value_, arg1Value_2, inliningTarget__1, INLINED_H);
                    }
                    if (arg1Value instanceof PythonNativeVoidPtr) {
                        arg1Value_ = (PythonNativeVoidPtr)arg1Value;
                        if (arg0Value_.isNativePointer() && ((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                            this.state_0_ = state_0 |= 8;
                            return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.voidPtrsNative(arg0Value_, (PythonNativeVoidPtr)arg1Value_);
                        }
                        EqNodeNativePtrNodeGen inliningTarget__2 = null;
                        if (arg0Value_.isNativePointer() && !((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                            inliningTarget__2 = this;
                            this.state_0_ = state_0 |= 0x10;
                            return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.voidPtrsANative(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__2, INLINED_H);
                        }
                        EqNodeNativePtrNodeGen inliningTarget__3 = null;
                        if (!arg0Value_.isNativePointer() && ((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                            inliningTarget__3 = this;
                            this.state_0_ = state_0 |= 0x20;
                            return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.voidPtrsBNative(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__3, INLINED_H);
                        }
                        EqNodeNativePtrNodeGen inliningTarget__4 = null;
                        if (!arg0Value_.isNativePointer() && !((PythonNativeVoidPtr)arg1Value_).isNativePointer()) {
                            inliningTarget__4 = this;
                            this.state_0_ = state_0 |= 0x40;
                            return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.voidPtrsManaged(frameValue, arg0Value_, (PythonNativeVoidPtr)arg1Value_, inliningTarget__4, INLINED_H);
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        arg1Value_ = (PInt)arg1Value;
                        this.state_0_ = state_0 |= 0x80;
                        return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.eqVoidPtrPInt(arg0Value_, (PInt)arg1Value_);
                    }
                }
                this.state_0_ = state_0 |= 0x100;
                return IntBuiltins.RichCompareHelperNode.EqNodeNativePtr.doGeneric(arg0Value, arg1Value);
            }

            @NeverDefault
            public static IntBuiltins.RichCompareHelperNode.EqNodeNativePtr create() {
                return new EqNodeNativePtrNodeGen();
            }
        }
    }
}

