/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM StyleSheetRemovedEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "StyleSheetRemovedEvent.h"
#include "StyleSheetRemovedEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/StyleSheet.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/StyleSheetRemovedEvent.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(StyleSheetRemovedEvent)

NS_IMPL_ADDREF_INHERITED(StyleSheetRemovedEvent, Event)
NS_IMPL_RELEASE_INHERITED(StyleSheetRemovedEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(StyleSheetRemovedEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mStylesheet)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(StyleSheetRemovedEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(StyleSheetRemovedEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mStylesheet)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(StyleSheetRemovedEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

StyleSheetRemovedEvent::StyleSheetRemovedEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

StyleSheetRemovedEvent::~StyleSheetRemovedEvent()
{
}

StyleSheetRemovedEvent*
StyleSheetRemovedEvent::AsStyleSheetRemovedEvent()
{
  return this;
}

JSObject*
StyleSheetRemovedEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return StyleSheetRemovedEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<StyleSheetRemovedEvent>
StyleSheetRemovedEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const StyleSheetRemovedEventInit& aEventInitDict)
{
  RefPtr<StyleSheetRemovedEvent> e = new StyleSheetRemovedEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mStylesheet = aEventInitDict.mStylesheet;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<StyleSheetRemovedEvent>
StyleSheetRemovedEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const StyleSheetRemovedEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

StyleSheet*
StyleSheetRemovedEvent::GetStylesheet() const
{
  return mStylesheet;
}


} // namespace mozilla::dom
