/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-telink-dfu-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_struct_telink_dfu_end_check_ref: (skip):
 **/
FuStructTelinkDfuEndCheck *
fu_struct_telink_dfu_end_check_ref(FuStructTelinkDfuEndCheck *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_telink_dfu_end_check_unref: (skip):
 **/
void
fu_struct_telink_dfu_end_check_unref(FuStructTelinkDfuEndCheck *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructTelinkDfuEndCheck refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructTelinkDfuEndCheck *
fu_struct_telink_dfu_end_check_new_internal(void)
{
    FuStructTelinkDfuEndCheck *st = g_new0(FuStructTelinkDfuEndCheck, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_telink_dfu_end_check_get_pkt_index: (skip):
 **/
guint16
fu_struct_telink_dfu_end_check_get_pkt_index(const FuStructTelinkDfuEndCheck *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_end_check_get_inverted_pkt_index: (skip):
 **/
guint16
fu_struct_telink_dfu_end_check_get_inverted_pkt_index(const FuStructTelinkDfuEndCheck *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_telink_dfu_end_check_set_pkt_index: (skip):
 **/
void
fu_struct_telink_dfu_end_check_set_pkt_index(FuStructTelinkDfuEndCheck *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_end_check_set_inverted_pkt_index: (skip):
 **/
void
fu_struct_telink_dfu_end_check_set_inverted_pkt_index(FuStructTelinkDfuEndCheck *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_end_check_new: (skip):
 **/
FuStructTelinkDfuEndCheck *
fu_struct_telink_dfu_end_check_new(void)
{
    FuStructTelinkDfuEndCheck *st = fu_struct_telink_dfu_end_check_new_internal();
    st->buf = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st->buf, 4, 0x0);
    return st;
}
/**
 * fu_struct_telink_dfu_ble_pkt_ref: (skip):
 **/
FuStructTelinkDfuBlePkt *
fu_struct_telink_dfu_ble_pkt_ref(FuStructTelinkDfuBlePkt *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_telink_dfu_ble_pkt_unref: (skip):
 **/
void
fu_struct_telink_dfu_ble_pkt_unref(FuStructTelinkDfuBlePkt *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructTelinkDfuBlePkt refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructTelinkDfuBlePkt *
fu_struct_telink_dfu_ble_pkt_new_internal(void)
{
    FuStructTelinkDfuBlePkt *st = g_new0(FuStructTelinkDfuBlePkt, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_telink_dfu_ble_pkt_get_preamble: (skip):
 **/
guint16
fu_struct_telink_dfu_ble_pkt_get_preamble(const FuStructTelinkDfuBlePkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_ble_pkt_get_payload: (skip):
 **/
const guint8 *
fu_struct_telink_dfu_ble_pkt_get_payload(const FuStructTelinkDfuBlePkt *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 16;
    return st->buf->data + 2;
}
/**
 * fu_struct_telink_dfu_ble_pkt_get_crc: (skip):
 **/
guint16
fu_struct_telink_dfu_ble_pkt_get_crc(const FuStructTelinkDfuBlePkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 18, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_telink_dfu_ble_pkt_set_preamble: (skip):
 **/
void
fu_struct_telink_dfu_ble_pkt_set_preamble(FuStructTelinkDfuBlePkt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_ble_pkt_set_payload: (skip):
 **/
gboolean
fu_struct_telink_dfu_ble_pkt_set_payload(FuStructTelinkDfuBlePkt *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_telink_dfu_ble_pkt_set_crc: (skip):
 **/
void
fu_struct_telink_dfu_ble_pkt_set_crc(FuStructTelinkDfuBlePkt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 18, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_ble_pkt_new: (skip):
 **/
FuStructTelinkDfuBlePkt *
fu_struct_telink_dfu_ble_pkt_new(void)
{
    FuStructTelinkDfuBlePkt *st = fu_struct_telink_dfu_ble_pkt_new_internal();
    st->buf = g_byte_array_sized_new(20);
    fu_byte_array_set_size(st->buf, 20, 0x0);
    memcpy(st->buf->data + 0x2, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 16); /* nocheck:blocked */
    return st;
}
/**
 * fu_struct_telink_dfu_hid_pkt_payload_ref: (skip):
 **/
FuStructTelinkDfuHidPktPayload *
fu_struct_telink_dfu_hid_pkt_payload_ref(FuStructTelinkDfuHidPktPayload *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_telink_dfu_hid_pkt_payload_unref: (skip):
 **/
void
fu_struct_telink_dfu_hid_pkt_payload_unref(FuStructTelinkDfuHidPktPayload *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructTelinkDfuHidPktPayload refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructTelinkDfuHidPktPayload *
fu_struct_telink_dfu_hid_pkt_payload_new_internal(void)
{
    FuStructTelinkDfuHidPktPayload *st = g_new0(FuStructTelinkDfuHidPktPayload, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_telink_dfu_hid_pkt_payload_get_ota_cmd: (skip):
 **/
guint16
fu_struct_telink_dfu_hid_pkt_payload_get_ota_cmd(const FuStructTelinkDfuHidPktPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_hid_pkt_payload_get_ota_data: (skip):
 **/
const guint8 *
fu_struct_telink_dfu_hid_pkt_payload_get_ota_data(const FuStructTelinkDfuHidPktPayload *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 16;
    return st->buf->data + 2;
}
/**
 * fu_struct_telink_dfu_hid_pkt_payload_get_crc: (skip):
 **/
guint16
fu_struct_telink_dfu_hid_pkt_payload_get_crc(const FuStructTelinkDfuHidPktPayload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 18, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_telink_dfu_hid_pkt_payload_set_ota_cmd: (skip):
 **/
void
fu_struct_telink_dfu_hid_pkt_payload_set_ota_cmd(FuStructTelinkDfuHidPktPayload *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_hid_pkt_payload_set_ota_data: (skip):
 **/
gboolean
fu_struct_telink_dfu_hid_pkt_payload_set_ota_data(FuStructTelinkDfuHidPktPayload *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_telink_dfu_hid_pkt_payload_set_crc: (skip):
 **/
void
fu_struct_telink_dfu_hid_pkt_payload_set_crc(FuStructTelinkDfuHidPktPayload *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 18, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_hid_pkt_payload_new: (skip):
 **/
FuStructTelinkDfuHidPktPayload *
fu_struct_telink_dfu_hid_pkt_payload_new(void)
{
    FuStructTelinkDfuHidPktPayload *st = fu_struct_telink_dfu_hid_pkt_payload_new_internal();
    st->buf = g_byte_array_sized_new(20);
    fu_byte_array_set_size(st->buf, 20, 0x0);
    fu_struct_telink_dfu_hid_pkt_payload_set_ota_cmd(st, 0xFFFF);
    memcpy(st->buf->data + 0x2, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 16); /* nocheck:blocked */
    fu_struct_telink_dfu_hid_pkt_payload_set_crc(st, 0xFFFF);
    return st;
}
/**
 * fu_struct_telink_dfu_hid_pkt_ref: (skip):
 **/
FuStructTelinkDfuHidPkt *
fu_struct_telink_dfu_hid_pkt_ref(FuStructTelinkDfuHidPkt *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_telink_dfu_hid_pkt_unref: (skip):
 **/
void
fu_struct_telink_dfu_hid_pkt_unref(FuStructTelinkDfuHidPkt *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructTelinkDfuHidPkt refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructTelinkDfuHidPkt *
fu_struct_telink_dfu_hid_pkt_new_internal(void)
{
    FuStructTelinkDfuHidPkt *st = g_new0(FuStructTelinkDfuHidPkt, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_telink_dfu_hid_pkt_get_op_code: (skip):
 **/
guint8
fu_struct_telink_dfu_hid_pkt_get_op_code(const FuStructTelinkDfuHidPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_telink_dfu_hid_pkt_get_ota_data_len: (skip):
 **/
guint16
fu_struct_telink_dfu_hid_pkt_get_ota_data_len(const FuStructTelinkDfuHidPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 1, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_hid_pkt_get_payload: (skip):
 **/
FuStructTelinkDfuHidPktPayload *
fu_struct_telink_dfu_hid_pkt_get_payload(const FuStructTelinkDfuHidPkt *st)
{
    g_autoptr(FuStructTelinkDfuHidPktPayload) st_tmp = fu_struct_telink_dfu_hid_pkt_payload_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_TELINK_DFU_HID_PKT_OFFSET_PAYLOAD, 20);
    return g_steal_pointer(&st_tmp);
}

/* setters */
/**
 * fu_struct_telink_dfu_hid_pkt_set_op_code: (skip):
 **/
void
fu_struct_telink_dfu_hid_pkt_set_op_code(FuStructTelinkDfuHidPkt *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_telink_dfu_hid_pkt_set_ota_data_len: (skip):
 **/
void
fu_struct_telink_dfu_hid_pkt_set_ota_data_len(FuStructTelinkDfuHidPkt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 1, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_hid_pkt_set_payload: (skip):
 **/
gboolean
fu_struct_telink_dfu_hid_pkt_set_payload(FuStructTelinkDfuHidPkt *st, const FuStructTelinkDfuHidPktPayload *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_TELINK_DFU_HID_PKT_PAYLOAD_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructTelinkDfuHidPktPayload' (0x%x bytes) does not fit in "
                    "FuStructTelinkDfuHidPkt.payload (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_TELINK_DFU_HID_PKT_PAYLOAD_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_TELINK_DFU_HID_PKT_OFFSET_PAYLOAD, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_telink_dfu_hid_pkt_new: (skip):
 **/
FuStructTelinkDfuHidPkt *
fu_struct_telink_dfu_hid_pkt_new(void)
{
    FuStructTelinkDfuHidPkt *st = fu_struct_telink_dfu_hid_pkt_new_internal();
    st->buf = g_byte_array_sized_new(23);
    fu_byte_array_set_size(st->buf, 23, 0x0);
    {
        g_autoptr(FuStructTelinkDfuHidPktPayload) st_donor = fu_struct_telink_dfu_hid_pkt_payload_new();
        memcpy(st->buf->data + 0x3, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    fu_struct_telink_dfu_hid_pkt_set_op_code(st, 0x02);
    return st;
}
/**
 * fu_struct_telink_dfu_hid_long_pkt_ref: (skip):
 **/
FuStructTelinkDfuHidLongPkt *
fu_struct_telink_dfu_hid_long_pkt_ref(FuStructTelinkDfuHidLongPkt *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_telink_dfu_hid_long_pkt_unref: (skip):
 **/
void
fu_struct_telink_dfu_hid_long_pkt_unref(FuStructTelinkDfuHidLongPkt *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructTelinkDfuHidLongPkt refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructTelinkDfuHidLongPkt *
fu_struct_telink_dfu_hid_long_pkt_new_internal(void)
{
    FuStructTelinkDfuHidLongPkt *st = g_new0(FuStructTelinkDfuHidLongPkt, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_telink_dfu_hid_long_pkt_get_op_code: (skip):
 **/
guint8
fu_struct_telink_dfu_hid_long_pkt_get_op_code(const FuStructTelinkDfuHidLongPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_telink_dfu_hid_long_pkt_get_ota_data_len: (skip):
 **/
guint16
fu_struct_telink_dfu_hid_long_pkt_get_ota_data_len(const FuStructTelinkDfuHidLongPkt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 1, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_hid_long_pkt_get_payload_1: (skip):
 **/
FuStructTelinkDfuHidPktPayload *
fu_struct_telink_dfu_hid_long_pkt_get_payload_1(const FuStructTelinkDfuHidLongPkt *st)
{
    g_autoptr(FuStructTelinkDfuHidPktPayload) st_tmp = fu_struct_telink_dfu_hid_pkt_payload_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_TELINK_DFU_HID_LONG_PKT_OFFSET_PAYLOAD_1, 20);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_telink_dfu_hid_long_pkt_get_payload_2: (skip):
 **/
FuStructTelinkDfuHidPktPayload *
fu_struct_telink_dfu_hid_long_pkt_get_payload_2(const FuStructTelinkDfuHidLongPkt *st)
{
    g_autoptr(FuStructTelinkDfuHidPktPayload) st_tmp = fu_struct_telink_dfu_hid_pkt_payload_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_TELINK_DFU_HID_LONG_PKT_OFFSET_PAYLOAD_2, 20);
    return g_steal_pointer(&st_tmp);
}
/**
 * fu_struct_telink_dfu_hid_long_pkt_get_payload_3: (skip):
 **/
FuStructTelinkDfuHidPktPayload *
fu_struct_telink_dfu_hid_long_pkt_get_payload_3(const FuStructTelinkDfuHidLongPkt *st)
{
    g_autoptr(FuStructTelinkDfuHidPktPayload) st_tmp = fu_struct_telink_dfu_hid_pkt_payload_new_internal();
    g_return_val_if_fail(st != NULL, NULL);
    st_tmp->buf = g_byte_array_new();
    g_byte_array_append(st_tmp->buf, st->buf->data + FU_STRUCT_TELINK_DFU_HID_LONG_PKT_OFFSET_PAYLOAD_3, 20);
    return g_steal_pointer(&st_tmp);
}

/* setters */
/**
 * fu_struct_telink_dfu_hid_long_pkt_set_op_code: (skip):
 **/
void
fu_struct_telink_dfu_hid_long_pkt_set_op_code(FuStructTelinkDfuHidLongPkt *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_telink_dfu_hid_long_pkt_set_ota_data_len: (skip):
 **/
void
fu_struct_telink_dfu_hid_long_pkt_set_ota_data_len(FuStructTelinkDfuHidLongPkt *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 1, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_telink_dfu_hid_long_pkt_set_payload_1: (skip):
 **/
gboolean
fu_struct_telink_dfu_hid_long_pkt_set_payload_1(FuStructTelinkDfuHidLongPkt *st, const FuStructTelinkDfuHidPktPayload *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_TELINK_DFU_HID_PKT_PAYLOAD_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructTelinkDfuHidPktPayload' (0x%x bytes) does not fit in "
                    "FuStructTelinkDfuHidLongPkt.payload_1 (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_TELINK_DFU_HID_PKT_PAYLOAD_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_TELINK_DFU_HID_LONG_PKT_OFFSET_PAYLOAD_1, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_telink_dfu_hid_long_pkt_set_payload_2: (skip):
 **/
gboolean
fu_struct_telink_dfu_hid_long_pkt_set_payload_2(FuStructTelinkDfuHidLongPkt *st, const FuStructTelinkDfuHidPktPayload *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_TELINK_DFU_HID_PKT_PAYLOAD_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructTelinkDfuHidPktPayload' (0x%x bytes) does not fit in "
                    "FuStructTelinkDfuHidLongPkt.payload_2 (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_TELINK_DFU_HID_PKT_PAYLOAD_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_TELINK_DFU_HID_LONG_PKT_OFFSET_PAYLOAD_2, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_telink_dfu_hid_long_pkt_set_payload_3: (skip):
 **/
gboolean
fu_struct_telink_dfu_hid_long_pkt_set_payload_3(FuStructTelinkDfuHidLongPkt *st, const FuStructTelinkDfuHidPktPayload *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);

    if (st_donor->buf->len > FU_STRUCT_TELINK_DFU_HID_PKT_PAYLOAD_SIZE) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "donor 'FuStructTelinkDfuHidPktPayload' (0x%x bytes) does not fit in "
                    "FuStructTelinkDfuHidLongPkt.payload_3 (0x%x bytes)",
                    (guint) st_donor->buf->len,
                    (guint) FU_STRUCT_TELINK_DFU_HID_PKT_PAYLOAD_SIZE);
        return FALSE;
    }
    memcpy(st->buf->data + FU_STRUCT_TELINK_DFU_HID_LONG_PKT_OFFSET_PAYLOAD_3, st_donor->buf->data, st_donor->buf->len);
    return TRUE;
}
/**
 * fu_struct_telink_dfu_hid_long_pkt_new: (skip):
 **/
FuStructTelinkDfuHidLongPkt *
fu_struct_telink_dfu_hid_long_pkt_new(void)
{
    FuStructTelinkDfuHidLongPkt *st = fu_struct_telink_dfu_hid_long_pkt_new_internal();
    st->buf = g_byte_array_sized_new(63);
    fu_byte_array_set_size(st->buf, 63, 0x0);
    {
        g_autoptr(FuStructTelinkDfuHidPktPayload) st_donor = fu_struct_telink_dfu_hid_pkt_payload_new();
        memcpy(st->buf->data + 0x3, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    {
        g_autoptr(FuStructTelinkDfuHidPktPayload) st_donor = fu_struct_telink_dfu_hid_pkt_payload_new();
        memcpy(st->buf->data + 0x17, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    {
        g_autoptr(FuStructTelinkDfuHidPktPayload) st_donor = fu_struct_telink_dfu_hid_pkt_payload_new();
        memcpy(st->buf->data + 0x2B, st_donor->buf->data, st_donor->buf->len); /* nocheck:blocked */
    }
    fu_struct_telink_dfu_hid_long_pkt_set_op_code(st, 0x02);
    return st;
}
