/* smtp-client-session.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from smtp-client-session.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEARY_SMTP_TYPE_CLIENT_CONNECTION (geary_smtp_client_connection_get_type ())
#define GEARY_SMTP_CLIENT_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_SMTP_TYPE_CLIENT_CONNECTION, GearySmtpClientConnection))
#define GEARY_SMTP_CLIENT_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_SMTP_TYPE_CLIENT_CONNECTION, GearySmtpClientConnectionClass))
#define GEARY_SMTP_IS_CLIENT_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_SMTP_TYPE_CLIENT_CONNECTION))
#define GEARY_SMTP_IS_CLIENT_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_SMTP_TYPE_CLIENT_CONNECTION))
#define GEARY_SMTP_CLIENT_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_SMTP_TYPE_CLIENT_CONNECTION, GearySmtpClientConnectionClass))

typedef struct _GearySmtpClientConnection GearySmtpClientConnection;
typedef struct _GearySmtpClientConnectionClass GearySmtpClientConnectionClass;
enum  {
	GEARY_SMTP_CLIENT_SESSION_0_PROPERTY,
	GEARY_SMTP_CLIENT_SESSION_LOGGING_PARENT_PROPERTY,
	GEARY_SMTP_CLIENT_SESSION_NUM_PROPERTIES
};
static GParamSpec* geary_smtp_client_session_properties[GEARY_SMTP_CLIENT_SESSION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _geary_smtp_response_unref0(var) ((var == NULL) ? NULL : (var = (geary_smtp_response_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearySmtpClientSessionLoginAsyncData GearySmtpClientSessionLoginAsyncData;
typedef struct _GearySmtpClientSessionAttemptAuthenticationAsyncData GearySmtpClientSessionAttemptAuthenticationAsyncData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearySmtpClientSessionLogoutAsyncData GearySmtpClientSessionLogoutAsyncData;
#define _geary_smtp_request_unref0(var) ((var == NULL) ? NULL : (var = (geary_smtp_request_unref (var), NULL)))
typedef struct _GearySmtpClientSessionSendEmailAsyncData GearySmtpClientSessionSendEmailAsyncData;
typedef struct _GearySmtpClientSessionSendRcptsAsyncData GearySmtpClientSessionSendRcptsAsyncData;
enum  {
	GEARY_SMTP_CLIENT_SESSION_CONNECTED_SIGNAL,
	GEARY_SMTP_CLIENT_SESSION_AUTHENTICATED_SIGNAL,
	GEARY_SMTP_CLIENT_SESSION_DISCONNECTED_SIGNAL,
	GEARY_SMTP_CLIENT_SESSION_NUM_SIGNALS
};
static guint geary_smtp_client_session_signals[GEARY_SMTP_CLIENT_SESSION_NUM_SIGNALS] = {0};

struct _GearySmtpClientSessionPrivate {
	GearyLoggingSource* _logging_parent;
	GearySmtpClientConnection* cx;
	gboolean rset_required;
};

struct _GearySmtpClientSessionLoginAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientSession* self;
	GearyCredentials* creds;
	GCancellable* cancellable;
	GearySmtpGreeting* result;
	GearySmtpClientConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GearySmtpGreeting* greeting;
	GearySmtpClientConnection* _tmp5_;
	GearySmtpGreeting* _tmp6_;
	GearySmtpGreeting* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GearySmtpClientConnection* _tmp12_;
	GearySmtpResponse* _tmp13_;
	GearySmtpResponse* _tmp14_;
	GearySmtpGreeting* _tmp15_;
	GearySmtpAuthenticator* _tmp16_;
	GearySmtpAuthenticator* _tmp17_;
	GError* _inner_error0_;
};

struct _GearySmtpClientSessionAttemptAuthenticationAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientSession* self;
	GearyCredentials* creds;
	GCancellable* cancellable;
	GearySmtpAuthenticator* result;
	GeeArrayList* auth_order;
	GeeArrayList* _tmp0_;
	GearyCredentialsMethod _tmp1_;
	GearyCredentialsMethod _tmp2_;
	GearySmtpClientConnection* _tmp3_;
	GearySmtpCapabilities* _tmp4_;
	GearySmtpCapabilities* _tmp5_;
	GearySmtpClientConnection* _tmp6_;
	GearySmtpCapabilities* _tmp7_;
	GearySmtpCapabilities* _tmp8_;
	GeeArrayList* _tmp9_;
	GearySmtpClientConnection* _tmp10_;
	GearySmtpCapabilities* _tmp11_;
	GearySmtpCapabilities* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GError* _tmp23_;
	GError* _tmp24_;
	gboolean _tmp25_;
	GearySmtpClientConnection* _tmp26_;
	GearySmtpCapabilities* _tmp27_;
	GearySmtpCapabilities* _tmp28_;
	GearySmtpClientConnection* _tmp29_;
	GearySmtpCapabilities* _tmp30_;
	GearySmtpCapabilities* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GError* _tmp34_;
	GError* _tmp35_;
	GeeArrayList* _tmp36_;
	GearyCredentialsMethod _tmp37_;
	GearyCredentialsMethod _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GError* _tmp41_;
	GError* _tmp42_;
	gboolean _tmp43_;
	GeeArrayList* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	GearySmtpAuthenticator* authenticator;
	GeeArrayList* _tmp47_;
	gpointer _tmp48_;
	gchar* _tmp49_;
	GQuark _tmp51_;
	GearySmtpPlainAuthenticator* _tmp52_;
	GearySmtpLoginAuthenticator* _tmp53_;
	GearySmtpOAuth2Authenticator* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	GearySmtpAuthenticator* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	GearySmtpResponse* response;
	GearySmtpClientConnection* _tmp60_;
	GearySmtpAuthenticator* _tmp61_;
	GearySmtpResponse* _tmp62_;
	GearySmtpResponse* _tmp63_;
	GearySmtpResponseCode* _tmp64_;
	GearySmtpResponseCode* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	GError* _tmp68_;
	GError* _tmp69_;
	GError* _inner_error0_;
};

struct _GearySmtpClientSessionLogoutAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientSession* self;
	gboolean force;
	GCancellable* cancellable;
	GearySmtpResponse* result;
	GearySmtpResponse* response;
	GearySmtpResponse* _tmp0_;
	GearySmtpClientConnection* _tmp1_;
	GearySmtpResponse* _tmp2_;
	GearySmtpResponse* _tmp3_;
	GError* err;
	GError* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	GearySmtpClientConnection* _tmp7_;
	GError* err2;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _inner_error0_;
};

struct _GearySmtpClientSessionSendEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientSession* self;
	GearyRFC822MailboxAddress* reverse_path;
	GearyRFC822Message* email;
	GCancellable* cancellable;
	GearySmtpClientConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GearySmtpResponse* rset_response;
	GearySmtpClientConnection* _tmp5_;
	GearySmtpRequest* _tmp6_;
	GearySmtpRequest* _tmp7_;
	GearySmtpResponse* _tmp8_;
	GearySmtpResponse* _tmp9_;
	GearySmtpResponse* _tmp10_;
	GearySmtpResponseCode* _tmp11_;
	GearySmtpResponseCode* _tmp12_;
	GearySmtpResponse* _tmp13_;
	GearySmtpMailRequest* mail_request;
	GearySmtpMailRequest* _tmp14_;
	GearySmtpResponse* response;
	GearySmtpClientConnection* _tmp15_;
	GearySmtpMailRequest* _tmp16_;
	GearySmtpResponse* _tmp17_;
	GearySmtpResponse* _tmp18_;
	GearySmtpResponseCode* _tmp19_;
	GearySmtpResponseCode* _tmp20_;
	GearySmtpResponse* _tmp21_;
	GearySmtpMailRequest* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GeeList* addrlist;
	GeeList* _tmp27_;
	gboolean _tmp28_;
	GeeList* _tmp29_;
	GeeList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	GError* _tmp33_;
	GeeList* _tmp34_;
	GearyMemoryBuffer* _tmp35_;
	GearyMemoryBuffer* _tmp36_;
	GearySmtpResponse* _tmp37_;
	GearySmtpClientConnection* _tmp38_;
	GearySmtpResponse* _tmp39_;
	GearySmtpResponse* _tmp40_;
	GearySmtpResponse* _tmp41_;
	GearySmtpResponseCode* _tmp42_;
	GearySmtpResponseCode* _tmp43_;
	GearySmtpResponse* _tmp44_;
	GError* _inner_error0_;
};

struct _GearySmtpClientSessionSendRcptsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientSession* self;
	GeeList* addrlist;
	GCancellable* cancellable;
	GeeList* _mailbox_list;
	gint _mailbox_size;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _mailbox_index;
	gint _tmp3_;
	gint _tmp4_;
	GearyRFC822MailboxAddress* mailbox;
	GeeList* _tmp5_;
	gpointer _tmp6_;
	GearySmtpRcptRequest* rcpt_request;
	GearyRFC822MailboxAddress* _tmp7_;
	GearySmtpRcptRequest* _tmp8_;
	GearySmtpResponse* response;
	GearySmtpClientConnection* _tmp9_;
	GearySmtpRcptRequest* _tmp10_;
	GearySmtpResponse* _tmp11_;
	GearySmtpResponse* _tmp12_;
	GearySmtpResponseCode* _tmp13_;
	GearySmtpResponseCode* _tmp14_;
	GearySmtpResponse* _tmp15_;
	GearySmtpResponseCode* _tmp16_;
	GearySmtpResponseCode* _tmp17_;
	GearySmtpResponse* _tmp18_;
	GearySmtpRcptRequest* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GearySmtpResponse* _tmp24_;
	GearySmtpRcptRequest* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GError* _inner_error0_;
};

static gint GearySmtpClientSession_private_offset;
static gpointer geary_smtp_client_session_parent_class = NULL;
static GearyLoggingSourceIface * geary_smtp_client_session_geary_logging_source_parent_iface = NULL;

VALA_EXTERN GType geary_smtp_client_connection_get_type (void) G_GNUC_CONST ;
static void geary_smtp_client_session_real_connected (GearySmtpClientSession* self,
                                               GearySmtpGreeting* greeting);
static void g_cclosure_user_marshal_VOID__GEARY_SMTP_RESPONSE (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data);
static void geary_smtp_client_session_real_authenticated (GearySmtpClientSession* self,
                                                   GearySmtpAuthenticator* authenticator);
static void geary_smtp_client_session_real_disconnected (GearySmtpClientSession* self);
VALA_EXTERN GearySmtpClientConnection* geary_smtp_client_connection_new (GearyEndpoint* endpoint);
VALA_EXTERN GearySmtpClientConnection* geary_smtp_client_connection_construct (GType object_type,
                                                                   GearyEndpoint* endpoint);
VALA_EXTERN void geary_smtp_client_connection_set_logging_parent (GearySmtpClientConnection* self,
                                                      GearyLoggingSource* parent);
static void geary_smtp_client_session_real_notify_connected (GearySmtpClientSession* self,
                                                      GearySmtpGreeting* greeting);
static void geary_smtp_client_session_real_notify_authenticated (GearySmtpClientSession* self,
                                                          GearySmtpAuthenticator* authenticator);
static void geary_smtp_client_session_real_notify_disconnected (GearySmtpClientSession* self);
static void geary_smtp_client_session_login_async_data_free (gpointer _data);
static gboolean geary_smtp_client_session_login_async_co (GearySmtpClientSessionLoginAsyncData* _data_);
VALA_EXTERN gboolean geary_smtp_client_connection_is_connected (GearySmtpClientConnection* self);
VALA_EXTERN void geary_smtp_client_connection_connect_async (GearySmtpClientConnection* self,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN GearySmtpGreeting* geary_smtp_client_connection_connect_finish (GearySmtpClientConnection* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static void geary_smtp_client_session_login_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
VALA_EXTERN void geary_smtp_client_connection_establish_connection_async (GearySmtpClientConnection* self,
                                                              GCancellable* cancellable,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_establish_connection_finish (GearySmtpClientConnection* self,
                                                                             GAsyncResult* _res_,
                                                                             GError** error);
static void geary_smtp_client_session_attempt_authentication_async (GearySmtpClientSession* self,
                                                             GearyCredentials* creds,
                                                             GCancellable* cancellable,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static GearySmtpAuthenticator* geary_smtp_client_session_attempt_authentication_finish (GearySmtpClientSession* self,
                                                                                 GAsyncResult* _res_,
                                                                                 GError** error);
static void geary_smtp_client_session_attempt_authentication_async_data_free (gpointer _data);
static gboolean geary_smtp_client_session_attempt_authentication_async_co (GearySmtpClientSessionAttemptAuthenticationAsyncData* _data_);
static gboolean _geary_string_stri_equal_gee_equal_data_func (gconstpointer a,
                                                       gconstpointer b,
                                                       gpointer self);
VALA_EXTERN GearySmtpCapabilities* geary_smtp_client_connection_get_capabilities (GearySmtpClientConnection* self);
VALA_EXTERN void geary_smtp_client_connection_authenticate_async (GearySmtpClientConnection* self,
                                                      GearySmtpAuthenticator* authenticator,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_authenticate_finish (GearySmtpClientConnection* self,
                                                                     GAsyncResult* _res_,
                                                                     GError** error);
static void geary_smtp_client_session_attempt_authentication_async_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void geary_smtp_client_session_logout_async_data_free (gpointer _data);
static gboolean geary_smtp_client_session_logout_async_co (GearySmtpClientSessionLogoutAsyncData* _data_);
VALA_EXTERN void geary_smtp_client_connection_quit_async (GearySmtpClientConnection* self,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_quit_finish (GearySmtpClientConnection* self,
                                                             GAsyncResult* _res_,
                                                             GError** error);
static void geary_smtp_client_session_logout_async_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
VALA_EXTERN void geary_smtp_client_connection_disconnect_async (GearySmtpClientConnection* self,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN gboolean geary_smtp_client_connection_disconnect_finish (GearySmtpClientConnection* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static void geary_smtp_client_session_send_email_async_data_free (gpointer _data);
static gboolean geary_smtp_client_session_send_email_async_co (GearySmtpClientSessionSendEmailAsyncData* _data_);
VALA_EXTERN void geary_smtp_client_connection_transaction_async (GearySmtpClientConnection* self,
                                                     GearySmtpRequest* request,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_transaction_finish (GearySmtpClientConnection* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error);
static void geary_smtp_client_session_send_email_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void geary_smtp_client_session_send_rcpts_async (GearySmtpClientSession* self,
                                                 GeeList* addrlist,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void geary_smtp_client_session_send_rcpts_finish (GearySmtpClientSession* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
VALA_EXTERN void geary_smtp_client_connection_send_data_async (GearySmtpClientConnection* self,
                                                   GearyMemoryBuffer* data,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_send_data_finish (GearySmtpClientConnection* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static void geary_smtp_client_session_send_rcpts_async_data_free (gpointer _data);
static gboolean geary_smtp_client_session_send_rcpts_async_co (GearySmtpClientSessionSendRcptsAsyncData* _data_);
static void geary_smtp_client_session_send_rcpts_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static GearyLoggingState* geary_smtp_client_session_real_to_logging_state (GearySmtpClientSession* self);
VALA_EXTERN void geary_smtp_client_session_set_logging_parent (GearySmtpClientSession* self,
                                                   GearyLoggingSource* parent);
static void geary_smtp_client_session_finalize (GObject * obj);
static GType geary_smtp_client_session_get_type_once (void);
static void _vala_geary_smtp_client_session_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
geary_smtp_client_session_get_instance_private (GearySmtpClientSession* self)
{
	return G_STRUCT_MEMBER_P (self, GearySmtpClientSession_private_offset);
}

static const gchar*
geary_smtp_client_session_real_get_logging_domain (GearyLoggingSource* base)
{
	const gchar* result;
	GearySmtpClientSession* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_CLIENT_SESSION, GearySmtpClientSession);
	result = GEARY_SMTP_CLIENT_SERVICE_LOGGING_DOMAIN;
	return result;
}

static GearyLoggingSource*
geary_smtp_client_session_real_get_logging_parent (GearyLoggingSource* base)
{
	GearyLoggingSource* result;
	GearySmtpClientSession* self;
	GearyLoggingSource* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_CLIENT_SESSION, GearySmtpClientSession);
	_tmp0_ = self->priv->_logging_parent;
	result = _tmp0_;
	return result;
}

static void
geary_smtp_client_session_real_connected (GearySmtpClientSession* self,
                                          GearySmtpGreeting* greeting)
{
	g_return_if_fail (GEARY_SMTP_IS_GREETING (greeting));
}

static void
g_cclosure_user_marshal_VOID__GEARY_SMTP_RESPONSE (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__GEARY_SMTP_RESPONSE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__GEARY_SMTP_RESPONSE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__GEARY_SMTP_RESPONSE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, geary_smtp_value_get_response (param_values + 1), data2);
}

static void
geary_smtp_client_session_real_authenticated (GearySmtpClientSession* self,
                                              GearySmtpAuthenticator* authenticator)
{
	g_return_if_fail (GEARY_SMTP_IS_AUTHENTICATOR (authenticator));
}

static void
geary_smtp_client_session_real_disconnected (GearySmtpClientSession* self)
{
}

GearySmtpClientSession*
geary_smtp_client_session_construct (GType object_type,
                                     GearyEndpoint* endpoint)
{
	GearySmtpClientSession * self = NULL;
	GearySmtpClientConnection* _tmp0_;
	GearySmtpClientConnection* _tmp1_;
	g_return_val_if_fail (GEARY_IS_ENDPOINT (endpoint), NULL);
	self = (GearySmtpClientSession*) geary_base_object_construct (object_type);
	_tmp0_ = geary_smtp_client_connection_new (endpoint);
	_g_object_unref0 (self->priv->cx);
	self->priv->cx = _tmp0_;
	_tmp1_ = self->priv->cx;
	geary_smtp_client_connection_set_logging_parent (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	return self;
}

GearySmtpClientSession*
geary_smtp_client_session_new (GearyEndpoint* endpoint)
{
	return geary_smtp_client_session_construct (GEARY_SMTP_TYPE_CLIENT_SESSION, endpoint);
}

static void
geary_smtp_client_session_real_notify_connected (GearySmtpClientSession* self,
                                                 GearySmtpGreeting* greeting)
{
	g_return_if_fail (GEARY_SMTP_IS_GREETING (greeting));
	g_signal_emit (self, geary_smtp_client_session_signals[GEARY_SMTP_CLIENT_SESSION_CONNECTED_SIGNAL], 0, greeting);
}

void
geary_smtp_client_session_notify_connected (GearySmtpClientSession* self,
                                            GearySmtpGreeting* greeting)
{
	GearySmtpClientSessionClass* _klass_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SESSION (self));
	_klass_ = GEARY_SMTP_CLIENT_SESSION_GET_CLASS (self);
	if (_klass_->notify_connected) {
		_klass_->notify_connected (self, greeting);
	}
}

static void
geary_smtp_client_session_real_notify_authenticated (GearySmtpClientSession* self,
                                                     GearySmtpAuthenticator* authenticator)
{
	g_return_if_fail (GEARY_SMTP_IS_AUTHENTICATOR (authenticator));
	g_signal_emit (self, geary_smtp_client_session_signals[GEARY_SMTP_CLIENT_SESSION_AUTHENTICATED_SIGNAL], 0, authenticator);
}

void
geary_smtp_client_session_notify_authenticated (GearySmtpClientSession* self,
                                                GearySmtpAuthenticator* authenticator)
{
	GearySmtpClientSessionClass* _klass_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SESSION (self));
	_klass_ = GEARY_SMTP_CLIENT_SESSION_GET_CLASS (self);
	if (_klass_->notify_authenticated) {
		_klass_->notify_authenticated (self, authenticator);
	}
}

static void
geary_smtp_client_session_real_notify_disconnected (GearySmtpClientSession* self)
{
	g_signal_emit (self, geary_smtp_client_session_signals[GEARY_SMTP_CLIENT_SESSION_DISCONNECTED_SIGNAL], 0);
}

void
geary_smtp_client_session_notify_disconnected (GearySmtpClientSession* self)
{
	GearySmtpClientSessionClass* _klass_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SESSION (self));
	_klass_ = GEARY_SMTP_CLIENT_SESSION_GET_CLASS (self);
	if (_klass_->notify_disconnected) {
		_klass_->notify_disconnected (self);
	}
}

static void
geary_smtp_client_session_login_async_data_free (gpointer _data)
{
	GearySmtpClientSessionLoginAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->creds);
	_g_object_unref0 (_data_->cancellable);
	_geary_smtp_response_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientSessionLoginAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_smtp_client_session_login_async (GearySmtpClientSession* self,
                                       GearyCredentials* creds,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	GearySmtpClientSessionLoginAsyncData* _data_;
	GearySmtpClientSession* _tmp0_;
	GearyCredentials* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SESSION (self));
	g_return_if_fail ((creds == NULL) || GEARY_IS_CREDENTIALS (creds));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientSessionLoginAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_session_login_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (creds);
	_g_object_unref0 (_data_->creds);
	_data_->creds = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_session_login_async_co (_data_);
}

GearySmtpGreeting*
geary_smtp_client_session_login_finish (GearySmtpClientSession* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GearySmtpGreeting* result;
	GearySmtpClientSessionLoginAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_smtp_client_session_login_async_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	GearySmtpClientSessionLoginAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_session_login_async_co (_data_);
}

static gboolean
geary_smtp_client_session_login_async_co (GearySmtpClientSessionLoginAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cx;
	if (geary_smtp_client_connection_is_connected (_data_->_tmp0_)) {
		_data_->_tmp1_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_ALREADY_CONNECTED, "Connection to %s already exists", _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_g_free0 (_data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->cx;
	_data_->_state_ = 1;
	geary_smtp_client_connection_connect_async (_data_->_tmp5_, _data_->cancellable, geary_smtp_client_session_login_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = geary_smtp_client_connection_connect_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
	_data_->greeting = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->greeting;
	if (_data_->_tmp7_ == NULL) {
		_data_->_tmp8_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_ALREADY_CONNECTED, "Connection to %s already exists", _data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_g_free0 (_data_->_tmp9_);
		_data_->_inner_error0_ = _data_->_tmp11_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_geary_smtp_response_unref0 (_data_->greeting);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->self->priv->cx;
	_data_->_state_ = 2;
	geary_smtp_client_connection_establish_connection_async (_data_->_tmp12_, _data_->cancellable, geary_smtp_client_session_login_async_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp13_ = geary_smtp_client_connection_establish_connection_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp14_ = _data_->_tmp13_;
	_geary_smtp_response_unref0 (_data_->_tmp14_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_geary_smtp_response_unref0 (_data_->greeting);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->greeting;
	geary_smtp_client_session_notify_connected (_data_->self, _data_->_tmp15_);
	if (_data_->creds != NULL) {
		_data_->_state_ = 3;
		geary_smtp_client_session_attempt_authentication_async (_data_->self, _data_->creds, _data_->cancellable, geary_smtp_client_session_login_async_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp17_ = geary_smtp_client_session_attempt_authentication_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp16_ = _data_->_tmp17_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->greeting);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		geary_smtp_client_session_notify_authenticated (_data_->self, _data_->_tmp16_);
		_g_object_unref0 (_data_->_tmp16_);
	}
	_data_->result = _data_->greeting;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_session_attempt_authentication_async_data_free (gpointer _data)
{
	GearySmtpClientSessionAttemptAuthenticationAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->creds);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientSessionAttemptAuthenticationAsyncData, _data_);
}

static void
geary_smtp_client_session_attempt_authentication_async (GearySmtpClientSession* self,
                                                        GearyCredentials* creds,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GearySmtpClientSessionAttemptAuthenticationAsyncData* _data_;
	GearySmtpClientSession* _tmp0_;
	GearyCredentials* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SESSION (self));
	g_return_if_fail (GEARY_IS_CREDENTIALS (creds));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientSessionAttemptAuthenticationAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_session_attempt_authentication_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (creds);
	_g_object_unref0 (_data_->creds);
	_data_->creds = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_session_attempt_authentication_async_co (_data_);
}

static GearySmtpAuthenticator*
geary_smtp_client_session_attempt_authentication_finish (GearySmtpClientSession* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	GearySmtpAuthenticator* result;
	GearySmtpClientSessionAttemptAuthenticationAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
_geary_string_stri_equal_gee_equal_data_func (gconstpointer a,
                                              gconstpointer b,
                                              gpointer self)
{
	gboolean result;
	result = geary_string_stri_equal ((const gchar*) a, (const gchar*) b);
	return result;
}

static void
geary_smtp_client_session_attempt_authentication_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	GearySmtpClientSessionAttemptAuthenticationAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_session_attempt_authentication_async_co (_data_);
}

static gboolean
geary_smtp_client_session_attempt_authentication_async_co (GearySmtpClientSessionAttemptAuthenticationAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _geary_string_stri_equal_gee_equal_data_func, NULL, NULL);
	_data_->auth_order = _data_->_tmp0_;
	_data_->_tmp1_ = geary_credentials_get_supported_method (_data_->creds);
	_data_->_tmp2_ = _data_->_tmp1_;
	switch (_data_->_tmp2_) {
		case GEARY_CREDENTIALS_METHOD_PASSWORD:
		{
			_data_->_tmp3_ = _data_->self->priv->cx;
			_data_->_tmp4_ = geary_smtp_client_connection_get_capabilities (_data_->_tmp3_);
			_data_->_tmp5_ = _data_->_tmp4_;
			if (_data_->_tmp5_ != NULL) {
				_data_->_tmp6_ = _data_->self->priv->cx;
				_data_->_tmp7_ = geary_smtp_client_connection_get_capabilities (_data_->_tmp6_);
				_data_->_tmp8_ = _data_->_tmp7_;
				if (geary_generic_capabilities_has_setting (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities), GEARY_SMTP_CAPABILITIES_AUTH, GEARY_SMTP_CAPABILITIES_AUTH_PLAIN)) {
					_data_->_tmp9_ = _data_->auth_order;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), GEARY_SMTP_CAPABILITIES_AUTH_PLAIN);
				}
				_data_->_tmp10_ = _data_->self->priv->cx;
				_data_->_tmp11_ = geary_smtp_client_connection_get_capabilities (_data_->_tmp10_);
				_data_->_tmp12_ = _data_->_tmp11_;
				if (geary_generic_capabilities_has_setting (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities), GEARY_SMTP_CAPABILITIES_AUTH, GEARY_SMTP_CAPABILITIES_AUTH_LOGIN)) {
					_data_->_tmp13_ = _data_->auth_order;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), GEARY_SMTP_CAPABILITIES_AUTH_LOGIN);
				}
			}
			_data_->_tmp14_ = _data_->auth_order;
			if (!gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), GEARY_SMTP_CAPABILITIES_AUTH_PLAIN)) {
				_data_->_tmp15_ = _data_->auth_order;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), GEARY_SMTP_CAPABILITIES_AUTH_PLAIN);
			}
			_data_->_tmp16_ = _data_->auth_order;
			if (!gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), GEARY_SMTP_CAPABILITIES_AUTH_LOGIN)) {
				_data_->_tmp17_ = _data_->auth_order;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), GEARY_SMTP_CAPABILITIES_AUTH_LOGIN);
			}
			_data_->_tmp18_ = _data_->auth_order;
			_data_->_tmp19_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
			_data_->_tmp20_ = _data_->_tmp19_;
			if (_data_->_tmp20_) {
				_data_->_tmp21_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
				_data_->_tmp22_ = _data_->_tmp21_;
				_data_->_tmp23_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_AUTHENTICATION_FAILED, "Unable to authenticate using PASSWORD credentials against %s", _data_->_tmp22_);
				_data_->_tmp24_ = _data_->_tmp23_;
				_g_free0 (_data_->_tmp22_);
				_data_->_inner_error0_ = _data_->_tmp24_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->auth_order);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			break;
		}
		case GEARY_CREDENTIALS_METHOD_OAUTH2:
		{
			_data_->_tmp26_ = _data_->self->priv->cx;
			_data_->_tmp27_ = geary_smtp_client_connection_get_capabilities (_data_->_tmp26_);
			_data_->_tmp28_ = _data_->_tmp27_;
			if (_data_->_tmp28_ != NULL) {
				_data_->_tmp29_ = _data_->self->priv->cx;
				_data_->_tmp30_ = geary_smtp_client_connection_get_capabilities (_data_->_tmp29_);
				_data_->_tmp31_ = _data_->_tmp30_;
				_data_->_tmp25_ = !geary_generic_capabilities_has_setting (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities), GEARY_SMTP_CAPABILITIES_AUTH, GEARY_SMTP_CAPABILITIES_AUTH_OAUTH2);
			} else {
				_data_->_tmp25_ = FALSE;
			}
			if (_data_->_tmp25_) {
				_data_->_tmp32_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
				_data_->_tmp33_ = _data_->_tmp32_;
				_data_->_tmp34_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_AUTHENTICATION_FAILED, "Unable to authenticate using OAUTH2 credentials against %s", _data_->_tmp33_);
				_data_->_tmp35_ = _data_->_tmp34_;
				_g_free0 (_data_->_tmp33_);
				_data_->_inner_error0_ = _data_->_tmp35_;
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->auth_order);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp36_ = _data_->auth_order;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp36_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), GEARY_SMTP_CAPABILITIES_AUTH_OAUTH2);
			break;
		}
		default:
		{
			_data_->_tmp37_ = geary_credentials_get_supported_method (_data_->creds);
			_data_->_tmp38_ = _data_->_tmp37_;
			_data_->_tmp39_ = geary_credentials_method_to_string (_data_->_tmp38_);
			_data_->_tmp40_ = _data_->_tmp39_;
			_data_->_tmp41_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_AUTHENTICATION_FAILED, "Unsupported auth method: %s", _data_->_tmp40_);
			_data_->_tmp42_ = _data_->_tmp41_;
			_g_free0 (_data_->_tmp40_);
			_data_->_inner_error0_ = _data_->_tmp42_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->auth_order);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	{
		_data_->_tmp43_ = TRUE;
		while (TRUE) {
			static GQuark _tmp50_label0 = 0;
			static GQuark _tmp50_label1 = 0;
			static GQuark _tmp50_label2 = 0;
			if (!_data_->_tmp43_) {
				_data_->_tmp44_ = _data_->auth_order;
				_data_->_tmp45_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp44_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
				_data_->_tmp46_ = _data_->_tmp45_;
				if (!(_data_->_tmp46_ > 0)) {
					break;
				}
			}
			_data_->_tmp43_ = FALSE;
			_data_->_tmp47_ = _data_->auth_order;
			_data_->_tmp48_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp47_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0);
			_data_->_tmp51_ = 0U;
			_data_->_tmp49_ = (gchar*) _data_->_tmp48_;
			_data_->_tmp51_ = (NULL == _data_->_tmp49_) ? 0 : g_quark_from_string (_data_->_tmp49_);
			g_free (_data_->_tmp49_);
			if (_data_->_tmp51_ == ((0 != _tmp50_label0) ? _tmp50_label0 : (_tmp50_label0 = g_quark_from_static_string (GEARY_SMTP_CAPABILITIES_AUTH_PLAIN)))) {
				switch (0) {
					default:
					{
						_data_->_tmp52_ = geary_smtp_plain_authenticator_new (_data_->creds);
						_g_object_unref0 (_data_->authenticator);
						_data_->authenticator = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp52_, GEARY_SMTP_TYPE_AUTHENTICATOR, GearySmtpAuthenticator);
						break;
					}
				}
			} else if (_data_->_tmp51_ == ((0 != _tmp50_label1) ? _tmp50_label1 : (_tmp50_label1 = g_quark_from_static_string (GEARY_SMTP_CAPABILITIES_AUTH_LOGIN)))) {
				switch (0) {
					default:
					{
						_data_->_tmp53_ = geary_smtp_login_authenticator_new (_data_->creds);
						_g_object_unref0 (_data_->authenticator);
						_data_->authenticator = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp53_, GEARY_SMTP_TYPE_AUTHENTICATOR, GearySmtpAuthenticator);
						break;
					}
				}
			} else if (_data_->_tmp51_ == ((0 != _tmp50_label2) ? _tmp50_label2 : (_tmp50_label2 = g_quark_from_static_string (GEARY_SMTP_CAPABILITIES_AUTH_OAUTH2)))) {
				switch (0) {
					default:
					{
						_data_->_tmp54_ = geary_smtp_oauth2_authenticator_new (_data_->creds);
						_g_object_unref0 (_data_->authenticator);
						_data_->authenticator = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp54_, GEARY_SMTP_TYPE_AUTHENTICATOR, GearySmtpAuthenticator);
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						g_assert_not_reached ();
					}
				}
			}
			_data_->_tmp55_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
			_data_->_tmp56_ = _data_->_tmp55_;
			_data_->_tmp57_ = _data_->authenticator;
			_data_->_tmp58_ = geary_smtp_authenticator_to_string (_data_->_tmp57_);
			_data_->_tmp59_ = _data_->_tmp58_;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "[%s] Attempting %s authenticator", _data_->_tmp56_, _data_->_tmp59_);
			_g_free0 (_data_->_tmp59_);
			_g_free0 (_data_->_tmp56_);
			_data_->_tmp60_ = _data_->self->priv->cx;
			_data_->_tmp61_ = _data_->authenticator;
			_data_->_state_ = 1;
			geary_smtp_client_connection_authenticate_async (_data_->_tmp60_, _data_->_tmp61_, _data_->cancellable, geary_smtp_client_session_attempt_authentication_async_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp62_ = geary_smtp_client_connection_authenticate_finish (_data_->_tmp60_, _data_->_res_, &_data_->_inner_error0_);
			_data_->response = _data_->_tmp62_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->authenticator);
				_g_object_unref0 (_data_->auth_order);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp63_ = _data_->response;
			_data_->_tmp64_ = geary_smtp_response_get_code (_data_->_tmp63_);
			_data_->_tmp65_ = _data_->_tmp64_;
			if (geary_smtp_response_code_is_success_completed (_data_->_tmp65_)) {
				_data_->result = _data_->authenticator;
				_geary_smtp_response_unref0 (_data_->response);
				_g_object_unref0 (_data_->auth_order);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_geary_smtp_response_unref0 (_data_->response);
			_g_object_unref0 (_data_->authenticator);
		}
	}
	_data_->_tmp66_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp67_ = _data_->_tmp66_;
	_data_->_tmp68_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_AUTHENTICATION_FAILED, "Unable to authenticate with %s", _data_->_tmp67_);
	_data_->_tmp69_ = _data_->_tmp68_;
	_g_free0 (_data_->_tmp67_);
	_data_->_inner_error0_ = _data_->_tmp69_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	_g_object_unref0 (_data_->auth_order);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_session_logout_async_data_free (gpointer _data)
{
	GearySmtpClientSessionLogoutAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_smtp_response_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientSessionLogoutAsyncData, _data_);
}

void
geary_smtp_client_session_logout_async (GearySmtpClientSession* self,
                                        gboolean force,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GearySmtpClientSessionLogoutAsyncData* _data_;
	GearySmtpClientSession* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SESSION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientSessionLogoutAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_session_logout_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->force = force;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_session_logout_async_co (_data_);
}

GearySmtpResponse*
geary_smtp_client_session_logout_finish (GearySmtpClientSession* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	GearySmtpResponse* result;
	GearySmtpClientSessionLogoutAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_smtp_client_session_logout_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GearySmtpClientSessionLogoutAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_session_logout_async_co (_data_);
}

static gboolean
geary_smtp_client_session_logout_async_co (GearySmtpClientSessionLogoutAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->response = NULL;
	{
		if (!_data_->force) {
			_data_->_tmp1_ = _data_->self->priv->cx;
			_data_->_state_ = 1;
			geary_smtp_client_connection_quit_async (_data_->_tmp1_, _data_->cancellable, geary_smtp_client_session_logout_async_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp2_ = geary_smtp_client_connection_quit_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp0_ = _data_->_tmp2_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp3_ = _data_->_tmp0_;
			_data_->_tmp0_ = NULL;
			_geary_smtp_response_unref0 (_data_->response);
			_data_->response = _data_->_tmp3_;
			_geary_smtp_response_unref0 (_data_->_tmp0_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		geary_logging_source_message (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Unable to QUIT: %s", _data_->_tmp5_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_geary_smtp_response_unref0 (_data_->response);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp7_ = _data_->self->priv->cx;
		_data_->_state_ = 2;
		geary_smtp_client_connection_disconnect_async (_data_->_tmp7_, _data_->cancellable, geary_smtp_client_session_logout_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = geary_smtp_client_connection_disconnect_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		if (_data_->_tmp6_) {
			g_signal_emit (_data_->self, geary_smtp_client_session_signals[GEARY_SMTP_CLIENT_SESSION_DISCONNECTED_SIGNAL], 0);
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->err2 = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->err2;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		geary_logging_source_message (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Unable to disconnect: %s", _data_->_tmp9_);
		_g_error_free0 (_data_->err2);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_geary_smtp_response_unref0 (_data_->response);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->rset_required = FALSE;
	_data_->result = _data_->response;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_session_send_email_async_data_free (gpointer _data)
{
	GearySmtpClientSessionSendEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->reverse_path);
	_g_object_unref0 (_data_->email);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientSessionSendEmailAsyncData, _data_);
}

void
geary_smtp_client_session_send_email_async (GearySmtpClientSession* self,
                                            GearyRFC822MailboxAddress* reverse_path,
                                            GearyRFC822Message* email,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearySmtpClientSessionSendEmailAsyncData* _data_;
	GearySmtpClientSession* _tmp0_;
	GearyRFC822MailboxAddress* _tmp1_;
	GearyRFC822Message* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SESSION (self));
	g_return_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (reverse_path));
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (email));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientSessionSendEmailAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_session_send_email_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (reverse_path);
	_g_object_unref0 (_data_->reverse_path);
	_data_->reverse_path = _tmp1_;
	_tmp2_ = _g_object_ref0 (email);
	_g_object_unref0 (_data_->email);
	_data_->email = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_smtp_client_session_send_email_async_co (_data_);
}

void
geary_smtp_client_session_send_email_finish (GearySmtpClientSession* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GearySmtpClientSessionSendEmailAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_smtp_client_session_send_email_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	GearySmtpClientSessionSendEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_session_send_email_async_co (_data_);
}

static gboolean
geary_smtp_client_session_send_email_async_co (GearySmtpClientSessionSendEmailAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cx;
	if (!geary_smtp_client_connection_is_connected (_data_->_tmp0_)) {
		_data_->_tmp1_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_NOT_CONNECTED, "Not connected to %s", _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_g_free0 (_data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->self->priv->rset_required) {
		_data_->_tmp5_ = _data_->self->priv->cx;
		_data_->_tmp6_ = geary_smtp_request_new (GEARY_SMTP_COMMAND_RSET, NULL, 0);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_state_ = 1;
		geary_smtp_client_connection_transaction_async (_data_->_tmp5_, _data_->_tmp7_, _data_->cancellable, geary_smtp_client_session_send_email_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = geary_smtp_client_connection_transaction_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_geary_smtp_request_unref0 (_data_->_tmp7_);
		_data_->rset_response = _data_->_tmp9_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp10_ = _data_->rset_response;
		_data_->_tmp11_ = geary_smtp_response_get_code (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		if (!geary_smtp_response_code_is_success_completed (_data_->_tmp12_)) {
			_data_->_tmp13_ = _data_->rset_response;
			geary_smtp_response_throw_error (_data_->_tmp13_, "Unable to RSET", &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_geary_smtp_response_unref0 (_data_->rset_response);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->self->priv->rset_required = FALSE;
		_geary_smtp_response_unref0 (_data_->rset_response);
	}
	_data_->_tmp14_ = geary_smtp_mail_request_new (_data_->reverse_path);
	_data_->mail_request = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->self->priv->cx;
	_data_->_tmp16_ = _data_->mail_request;
	_data_->_state_ = 2;
	geary_smtp_client_connection_transaction_async (_data_->_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEARY_SMTP_TYPE_REQUEST, GearySmtpRequest), _data_->cancellable, geary_smtp_client_session_send_email_async_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp17_ = geary_smtp_client_connection_transaction_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
	_data_->response = _data_->_tmp17_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_geary_smtp_request_unref0 (_data_->mail_request);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->response;
	_data_->_tmp19_ = geary_smtp_response_get_code (_data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	if (!geary_smtp_response_code_is_success_completed (_data_->_tmp20_)) {
		_data_->_tmp21_ = _data_->response;
		_data_->_tmp22_ = _data_->mail_request;
		_data_->_tmp23_ = geary_smtp_request_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, GEARY_SMTP_TYPE_REQUEST, GearySmtpRequest));
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = g_strdup_printf ("\"%s\" failed", _data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		geary_smtp_response_throw_error (_data_->_tmp21_, _data_->_tmp26_, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp26_);
		_g_free0 (_data_->_tmp24_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->response);
			_geary_smtp_request_unref0 (_data_->mail_request);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->self->priv->rset_required = TRUE;
	_data_->_tmp27_ = geary_rf_c822_message_get_recipients (_data_->email);
	_data_->addrlist = _data_->_tmp27_;
	_data_->_tmp29_ = _data_->addrlist;
	if (_data_->_tmp29_ == NULL) {
		_data_->_tmp28_ = TRUE;
	} else {
		_data_->_tmp30_ = _data_->addrlist;
		_data_->_tmp31_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp30_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp28_ = _data_->_tmp32_ == 0;
	}
	if (_data_->_tmp28_) {
		_data_->_tmp33_ = g_error_new_literal (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_REQUIRED_FIELD, "No recipients in message");
		_data_->_inner_error0_ = _data_->_tmp33_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->addrlist);
		_geary_smtp_response_unref0 (_data_->response);
		_geary_smtp_request_unref0 (_data_->mail_request);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp34_ = _data_->addrlist;
	_data_->_state_ = 3;
	geary_smtp_client_session_send_rcpts_async (_data_->self, _data_->_tmp34_, _data_->cancellable, geary_smtp_client_session_send_email_async_ready, _data_);
	return FALSE;
	_state_3:
	geary_smtp_client_session_send_rcpts_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->addrlist);
		_geary_smtp_response_unref0 (_data_->response);
		_geary_smtp_request_unref0 (_data_->mail_request);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp36_ = geary_rf_c822_message_get_rfc822_buffer (_data_->email, GEARY_RF_C822_MESSAGE_RF_C822_FORMAT_OPTIONS_SMTP_FORMAT, &_data_->_inner_error0_);
	_data_->_tmp35_ = _data_->_tmp36_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->addrlist);
		_geary_smtp_response_unref0 (_data_->response);
		_geary_smtp_request_unref0 (_data_->mail_request);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp38_ = _data_->self->priv->cx;
	_data_->_state_ = 4;
	geary_smtp_client_connection_send_data_async (_data_->_tmp38_, _data_->_tmp35_, _data_->cancellable, geary_smtp_client_session_send_email_async_ready, _data_);
	return FALSE;
	_state_4:
	_data_->_tmp39_ = geary_smtp_client_connection_send_data_finish (_data_->_tmp38_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp37_ = _data_->_tmp39_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp35_);
		_g_object_unref0 (_data_->addrlist);
		_geary_smtp_response_unref0 (_data_->response);
		_geary_smtp_request_unref0 (_data_->mail_request);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp40_ = _data_->_tmp37_;
	_data_->_tmp37_ = NULL;
	_geary_smtp_response_unref0 (_data_->response);
	_data_->response = _data_->_tmp40_;
	_data_->_tmp41_ = _data_->response;
	_data_->_tmp42_ = geary_smtp_response_get_code (_data_->_tmp41_);
	_data_->_tmp43_ = _data_->_tmp42_;
	if (!geary_smtp_response_code_is_success_completed (_data_->_tmp43_)) {
		_data_->_tmp44_ = _data_->response;
		geary_smtp_response_throw_error (_data_->_tmp44_, "Unable to send message", &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->_tmp37_);
			_g_object_unref0 (_data_->_tmp35_);
			_g_object_unref0 (_data_->addrlist);
			_geary_smtp_response_unref0 (_data_->response);
			_geary_smtp_request_unref0 (_data_->mail_request);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->self->priv->rset_required = FALSE;
	_geary_smtp_response_unref0 (_data_->_tmp37_);
	_g_object_unref0 (_data_->_tmp35_);
	_g_object_unref0 (_data_->addrlist);
	_geary_smtp_response_unref0 (_data_->response);
	_geary_smtp_request_unref0 (_data_->mail_request);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_session_send_rcpts_async_data_free (gpointer _data)
{
	GearySmtpClientSessionSendRcptsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->addrlist);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientSessionSendRcptsAsyncData, _data_);
}

static void
geary_smtp_client_session_send_rcpts_async (GearySmtpClientSession* self,
                                            GeeList* addrlist,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearySmtpClientSessionSendRcptsAsyncData* _data_;
	GearySmtpClientSession* _tmp0_;
	GeeList* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SESSION (self));
	g_return_if_fail ((addrlist == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (addrlist, GEE_TYPE_LIST));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientSessionSendRcptsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_session_send_rcpts_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (addrlist);
	_g_object_unref0 (_data_->addrlist);
	_data_->addrlist = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_session_send_rcpts_async_co (_data_);
}

static void
geary_smtp_client_session_send_rcpts_finish (GearySmtpClientSession* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GearySmtpClientSessionSendRcptsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_smtp_client_session_send_rcpts_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	GearySmtpClientSessionSendRcptsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_session_send_rcpts_async_co (_data_);
}

static gboolean
geary_smtp_client_session_send_rcpts_async_co (GearySmtpClientSessionSendRcptsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->addrlist == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_mailbox_list = _data_->addrlist;
		_data_->_tmp0_ = _data_->_mailbox_list;
		_data_->_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_mailbox_size = _data_->_tmp2_;
		_data_->_mailbox_index = -1;
		while (TRUE) {
			_data_->_mailbox_index = _data_->_mailbox_index + 1;
			_data_->_tmp3_ = _data_->_mailbox_index;
			_data_->_tmp4_ = _data_->_mailbox_size;
			if (!(_data_->_tmp3_ < _data_->_tmp4_)) {
				break;
			}
			_data_->_tmp5_ = _data_->_mailbox_list;
			_data_->_tmp6_ = gee_list_get (_data_->_tmp5_, _data_->_mailbox_index);
			_data_->mailbox = (GearyRFC822MailboxAddress*) _data_->_tmp6_;
			_data_->_tmp7_ = _data_->mailbox;
			_data_->_tmp8_ = geary_smtp_rcpt_request_new (_data_->_tmp7_);
			_data_->rcpt_request = _data_->_tmp8_;
			_data_->_tmp9_ = _data_->self->priv->cx;
			_data_->_tmp10_ = _data_->rcpt_request;
			_data_->_state_ = 1;
			geary_smtp_client_connection_transaction_async (_data_->_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEARY_SMTP_TYPE_REQUEST, GearySmtpRequest), _data_->cancellable, geary_smtp_client_session_send_rcpts_async_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp11_ = geary_smtp_client_connection_transaction_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
			_data_->response = _data_->_tmp11_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_geary_smtp_request_unref0 (_data_->rcpt_request);
				_g_object_unref0 (_data_->mailbox);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp12_ = _data_->response;
			_data_->_tmp13_ = geary_smtp_response_get_code (_data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			if (!geary_smtp_response_code_is_success_completed (_data_->_tmp14_)) {
				_data_->_tmp15_ = _data_->response;
				_data_->_tmp16_ = geary_smtp_response_get_code (_data_->_tmp15_);
				_data_->_tmp17_ = _data_->_tmp16_;
				if (geary_smtp_response_code_is_denied (_data_->_tmp17_)) {
					_data_->_tmp18_ = _data_->response;
					_data_->_tmp19_ = _data_->rcpt_request;
					_data_->_tmp20_ = geary_smtp_request_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, GEARY_SMTP_TYPE_REQUEST, GearySmtpRequest));
					_data_->_tmp21_ = _data_->_tmp20_;
					_data_->_tmp22_ = g_strdup_printf ("recipient \"%s\" denied by smtp server", _data_->_tmp21_);
					_data_->_tmp23_ = _data_->_tmp22_;
					geary_smtp_response_throw_error (_data_->_tmp18_, _data_->_tmp23_, &_data_->_inner_error0_);
					_g_free0 (_data_->_tmp23_);
					_g_free0 (_data_->_tmp21_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_geary_smtp_response_unref0 (_data_->response);
						_geary_smtp_request_unref0 (_data_->rcpt_request);
						_g_object_unref0 (_data_->mailbox);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				} else {
					_data_->_tmp24_ = _data_->response;
					_data_->_tmp25_ = _data_->rcpt_request;
					_data_->_tmp26_ = geary_smtp_request_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp25_, GEARY_SMTP_TYPE_REQUEST, GearySmtpRequest));
					_data_->_tmp27_ = _data_->_tmp26_;
					_data_->_tmp28_ = g_strdup_printf ("\"%s\" failed", _data_->_tmp27_);
					_data_->_tmp29_ = _data_->_tmp28_;
					geary_smtp_response_throw_error (_data_->_tmp24_, _data_->_tmp29_, &_data_->_inner_error0_);
					_g_free0 (_data_->_tmp29_);
					_g_free0 (_data_->_tmp27_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_geary_smtp_response_unref0 (_data_->response);
						_geary_smtp_request_unref0 (_data_->rcpt_request);
						_g_object_unref0 (_data_->mailbox);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
			}
			_geary_smtp_response_unref0 (_data_->response);
			_geary_smtp_request_unref0 (_data_->rcpt_request);
			_g_object_unref0 (_data_->mailbox);
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_smtp_client_session_real_to_logging_state (GearySmtpClientSession* self)
{
	GearySmtpClientConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyLoggingState* _tmp3_;
	GearyLoggingState* _tmp4_;
	GearyLoggingState* result;
	_tmp0_ = self->priv->cx;
	_tmp1_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

GearyLoggingState*
geary_smtp_client_session_to_logging_state (GearySmtpClientSession* self)
{
	GearySmtpClientSessionClass* _klass_;
	g_return_val_if_fail (GEARY_SMTP_IS_CLIENT_SESSION (self), NULL);
	_klass_ = GEARY_SMTP_CLIENT_SESSION_GET_CLASS (self);
	if (_klass_->to_logging_state) {
		return _klass_->to_logging_state (self);
	}
	return NULL;
}

/** Sets the service's logging parent. */
void
geary_smtp_client_session_set_logging_parent (GearySmtpClientSession* self,
                                              GearyLoggingSource* parent)
{
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SESSION (self));
	g_return_if_fail (GEARY_LOGGING_IS_SOURCE (parent));
	self->priv->_logging_parent = parent;
}

static void
geary_smtp_client_session_class_init (GearySmtpClientSessionClass * klass,
                                      gpointer klass_data)
{
	geary_smtp_client_session_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearySmtpClientSession_private_offset);
	((GearySmtpClientSessionClass *) klass)->notify_connected = (void (*) (GearySmtpClientSession*, GearySmtpGreeting*)) geary_smtp_client_session_real_notify_connected;
	((GearySmtpClientSessionClass *) klass)->notify_authenticated = (void (*) (GearySmtpClientSession*, GearySmtpAuthenticator*)) geary_smtp_client_session_real_notify_authenticated;
	((GearySmtpClientSessionClass *) klass)->notify_disconnected = (void (*) (GearySmtpClientSession*)) geary_smtp_client_session_real_notify_disconnected;
	((GearySmtpClientSessionClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearySmtpClientSession*)) geary_smtp_client_session_real_to_logging_state;
	((GearySmtpClientSessionClass *) klass)->connected = geary_smtp_client_session_real_connected;
	((GearySmtpClientSessionClass *) klass)->authenticated = geary_smtp_client_session_real_authenticated;
	((GearySmtpClientSessionClass *) klass)->disconnected = geary_smtp_client_session_real_disconnected;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_smtp_client_session_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_smtp_client_session_finalize;
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SMTP_CLIENT_SESSION_LOGGING_PARENT_PROPERTY, geary_smtp_client_session_properties[GEARY_SMTP_CLIENT_SESSION_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	geary_smtp_client_session_signals[GEARY_SMTP_CLIENT_SESSION_CONNECTED_SIGNAL] = g_signal_new ("connected", GEARY_SMTP_TYPE_CLIENT_SESSION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GearySmtpClientSessionClass, connected), NULL, NULL, g_cclosure_user_marshal_VOID__GEARY_SMTP_RESPONSE, G_TYPE_NONE, 1, GEARY_SMTP_TYPE_GREETING);
	geary_smtp_client_session_signals[GEARY_SMTP_CLIENT_SESSION_AUTHENTICATED_SIGNAL] = g_signal_new ("authenticated", GEARY_SMTP_TYPE_CLIENT_SESSION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GearySmtpClientSessionClass, authenticated), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_SMTP_TYPE_AUTHENTICATOR);
	geary_smtp_client_session_signals[GEARY_SMTP_CLIENT_SESSION_DISCONNECTED_SIGNAL] = g_signal_new ("disconnected", GEARY_SMTP_TYPE_CLIENT_SESSION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (GearySmtpClientSessionClass, disconnected), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
geary_smtp_client_session_geary_logging_source_interface_init (GearyLoggingSourceIface * iface,
                                                               gpointer iface_data)
{
	geary_smtp_client_session_geary_logging_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_logging_state = (GearyLoggingState* (*) (GearyLoggingSource*)) geary_smtp_client_session_to_logging_state;
	iface->get_logging_domain = geary_smtp_client_session_real_get_logging_domain;
	iface->get_logging_parent = geary_smtp_client_session_real_get_logging_parent;
}

static void
geary_smtp_client_session_instance_init (GearySmtpClientSession * self,
                                         gpointer klass)
{
	self->priv = geary_smtp_client_session_get_instance_private (self);
	self->priv->_logging_parent = NULL;
	self->priv->rset_required = FALSE;
}

static void
geary_smtp_client_session_finalize (GObject * obj)
{
	GearySmtpClientSession * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SMTP_TYPE_CLIENT_SESSION, GearySmtpClientSession);
	_g_object_unref0 (self->priv->cx);
	G_OBJECT_CLASS (geary_smtp_client_session_parent_class)->finalize (obj);
}

/** A client connection to a SMTP service. */
 G_GNUC_NO_INLINE static GType
geary_smtp_client_session_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpClientSessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_client_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpClientSession), 0, (GInstanceInitFunc) geary_smtp_client_session_instance_init, NULL };
	static const GInterfaceInfo geary_logging_source_info = { (GInterfaceInitFunc) geary_smtp_client_session_geary_logging_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_smtp_client_session_type_id;
	geary_smtp_client_session_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearySmtpClientSession", &g_define_type_info, 0);
	g_type_add_interface_static (geary_smtp_client_session_type_id, GEARY_LOGGING_TYPE_SOURCE, &geary_logging_source_info);
	GearySmtpClientSession_private_offset = g_type_add_instance_private (geary_smtp_client_session_type_id, sizeof (GearySmtpClientSessionPrivate));
	return geary_smtp_client_session_type_id;
}

GType
geary_smtp_client_session_get_type (void)
{
	static gsize geary_smtp_client_session_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_client_session_type_id__once)) {
		GType geary_smtp_client_session_type_id;
		geary_smtp_client_session_type_id = geary_smtp_client_session_get_type_once ();
		g_once_init_leave (&geary_smtp_client_session_type_id__once, geary_smtp_client_session_type_id);
	}
	return geary_smtp_client_session_type_id__once;
}

static void
_vala_geary_smtp_client_session_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GearySmtpClientSession * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SMTP_TYPE_CLIENT_SESSION, GearySmtpClientSession);
	switch (property_id) {
		case GEARY_SMTP_CLIENT_SESSION_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_logging_source_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

