{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated during touchpad swipe gestures.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventTouchpadPinch
    ( 

-- * Exported types
    EventTouchpadPinch(..)                  ,
    newZeroEventTouchpadPinch               ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventTouchpadPinchMethod         ,
#endif



 -- * Properties


-- ** angleDelta #attr:angleDelta#
-- | The angle change in radians, negative angles
--   denote counter-clockwise movements

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_angleDelta           ,
#endif
    getEventTouchpadPinchAngleDelta         ,
    setEventTouchpadPinchAngleDelta         ,


-- ** dx #attr:dx#
-- | Movement delta in the X axis of the swipe focal point

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_dx                   ,
#endif
    getEventTouchpadPinchDx                 ,
    setEventTouchpadPinchDx                 ,


-- ** dy #attr:dy#
-- | Movement delta in the Y axis of the swipe focal point

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_dy                   ,
#endif
    getEventTouchpadPinchDy                 ,
    setEventTouchpadPinchDy                 ,


-- ** nFingers #attr:nFingers#
-- | The number of fingers triggering the pinch

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_nFingers             ,
#endif
    getEventTouchpadPinchNFingers           ,
    setEventTouchpadPinchNFingers           ,


-- ** phase #attr:phase#
-- | the current phase of the gesture

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_phase                ,
#endif
    getEventTouchpadPinchPhase              ,
    setEventTouchpadPinchPhase              ,


-- ** scale #attr:scale#
-- | The current scale, relative to that at the time of
--   the corresponding 'GI.Gdk.Enums.TouchpadGesturePhaseBegin' event

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_scale                ,
#endif
    getEventTouchpadPinchScale              ,
    setEventTouchpadPinchScale              ,


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_sendEvent            ,
#endif
    getEventTouchpadPinchSendEvent          ,
    setEventTouchpadPinchSendEvent          ,


-- ** state #attr:state#
-- | a bit-mask representing the state of
--   the modifier keys (e.g. Control, Shift and Alt) and the pointer
--   buttons. See t'GI.Gdk.Flags.ModifierType'.

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_state                ,
#endif
    getEventTouchpadPinchState              ,
    setEventTouchpadPinchState              ,


-- ** time #attr:time#
-- | the time of the event in milliseconds

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_time                 ,
#endif
    getEventTouchpadPinchTime               ,
    setEventTouchpadPinchTime               ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeTouchpadPinch')

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_type                 ,
#endif
    getEventTouchpadPinchType               ,
    setEventTouchpadPinchType               ,


-- ** window #attr:window#
-- | the window which received the event

    clearEventTouchpadPinchWindow           ,
#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_window               ,
#endif
    getEventTouchpadPinchWindow             ,
    setEventTouchpadPinchWindow             ,


-- ** x #attr:x#
-- | The X coordinate of the pointer

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_x                    ,
#endif
    getEventTouchpadPinchX                  ,
    setEventTouchpadPinchX                  ,


-- ** xRoot #attr:xRoot#
-- | The X coordinate of the pointer, relative to the
--   root of the screen.

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_xRoot                ,
#endif
    getEventTouchpadPinchXRoot              ,
    setEventTouchpadPinchXRoot              ,


-- ** y #attr:y#
-- | The Y coordinate of the pointer

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_y                    ,
#endif
    getEventTouchpadPinchY                  ,
    setEventTouchpadPinchY                  ,


-- ** yRoot #attr:yRoot#
-- | The Y coordinate of the pointer, relative to the
--   root of the screen.

#if defined(ENABLE_OVERLOADING)
    eventTouchpadPinch_yRoot                ,
#endif
    getEventTouchpadPinchYRoot              ,
    setEventTouchpadPinchYRoot              ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventTouchpadPinch = EventTouchpadPinch (SP.ManagedPtr EventTouchpadPinch)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventTouchpadPinch where
    toManagedPtr (EventTouchpadPinch p) = p

instance BoxedPtr EventTouchpadPinch where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 96 >=> B.ManagedPtr.wrapPtr EventTouchpadPinch)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventTouchpadPinch where
    boxedPtrCalloc = callocBytes 96


-- | Construct a t'EventTouchpadPinch' struct initialized to zero.
newZeroEventTouchpadPinch :: MonadIO m => m EventTouchpadPinch
newZeroEventTouchpadPinch = liftIO $ boxedPtrCalloc >>= wrapPtr EventTouchpadPinch

instance tag ~ 'AttrSet => Constructible EventTouchpadPinch tag where
    new _ attrs = do
        o <- newZeroEventTouchpadPinch
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #type
-- @
getEventTouchpadPinchType :: MonadIO m => EventTouchpadPinch -> m Gdk.Enums.EventType
getEventTouchpadPinchType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchType :: MonadIO m => EventTouchpadPinch -> Gdk.Enums.EventType -> m ()
setEventTouchpadPinchType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchTypeFieldInfo
instance AttrInfo EventTouchpadPinchTypeFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchTypeFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventTouchpadPinchTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventTouchpadPinchTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventTouchpadPinchTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventTouchpadPinchTypeFieldInfo = "type"
    type AttrOrigin EventTouchpadPinchTypeFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchType
    attrSet = setEventTouchpadPinchType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:type"
        })

eventTouchpadPinch_type :: AttrLabelProxy "type"
eventTouchpadPinch_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #window
-- @
getEventTouchpadPinchWindow :: MonadIO m => EventTouchpadPinch -> m (Maybe Gdk.Window.Window)
getEventTouchpadPinchWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchWindow :: MonadIO m => EventTouchpadPinch -> Ptr Gdk.Window.Window -> m ()
setEventTouchpadPinchWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventTouchpadPinchWindow :: MonadIO m => EventTouchpadPinch -> m ()
clearEventTouchpadPinchWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchWindowFieldInfo
instance AttrInfo EventTouchpadPinchWindowFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchWindowFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventTouchpadPinchWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventTouchpadPinchWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventTouchpadPinchWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventTouchpadPinchWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventTouchpadPinchWindowFieldInfo = "window"
    type AttrOrigin EventTouchpadPinchWindowFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchWindow
    attrSet = setEventTouchpadPinchWindow
    attrConstruct = undefined
    attrClear = clearEventTouchpadPinchWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:window"
        })

eventTouchpadPinch_window :: AttrLabelProxy "window"
eventTouchpadPinch_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #sendEvent
-- @
getEventTouchpadPinchSendEvent :: MonadIO m => EventTouchpadPinch -> m Int8
getEventTouchpadPinchSendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchSendEvent :: MonadIO m => EventTouchpadPinch -> Int8 -> m ()
setEventTouchpadPinchSendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchSendEventFieldInfo
instance AttrInfo EventTouchpadPinchSendEventFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchSendEventFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchSendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchSendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventTouchpadPinchSendEventFieldInfo = (~)Int8
    type AttrTransferType EventTouchpadPinchSendEventFieldInfo = Int8
    type AttrGetType EventTouchpadPinchSendEventFieldInfo = Int8
    type AttrLabel EventTouchpadPinchSendEventFieldInfo = "send_event"
    type AttrOrigin EventTouchpadPinchSendEventFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchSendEvent
    attrSet = setEventTouchpadPinchSendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:sendEvent"
        })

eventTouchpadPinch_sendEvent :: AttrLabelProxy "sendEvent"
eventTouchpadPinch_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@phase@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #phase
-- @
getEventTouchpadPinchPhase :: MonadIO m => EventTouchpadPinch -> m Int8
getEventTouchpadPinchPhase s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 17) :: IO Int8
    return val

-- | Set the value of the “@phase@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #phase 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchPhase :: MonadIO m => EventTouchpadPinch -> Int8 -> m ()
setEventTouchpadPinchPhase s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 17) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchPhaseFieldInfo
instance AttrInfo EventTouchpadPinchPhaseFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchPhaseFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchPhaseFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchPhaseFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventTouchpadPinchPhaseFieldInfo = (~)Int8
    type AttrTransferType EventTouchpadPinchPhaseFieldInfo = Int8
    type AttrGetType EventTouchpadPinchPhaseFieldInfo = Int8
    type AttrLabel EventTouchpadPinchPhaseFieldInfo = "phase"
    type AttrOrigin EventTouchpadPinchPhaseFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchPhase
    attrSet = setEventTouchpadPinchPhase
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.phase"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:phase"
        })

eventTouchpadPinch_phase :: AttrLabelProxy "phase"
eventTouchpadPinch_phase = AttrLabelProxy

#endif


-- | Get the value of the “@n_fingers@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #nFingers
-- @
getEventTouchpadPinchNFingers :: MonadIO m => EventTouchpadPinch -> m Int8
getEventTouchpadPinchNFingers s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 18) :: IO Int8
    return val

-- | Set the value of the “@n_fingers@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #nFingers 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchNFingers :: MonadIO m => EventTouchpadPinch -> Int8 -> m ()
setEventTouchpadPinchNFingers s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 18) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchNFingersFieldInfo
instance AttrInfo EventTouchpadPinchNFingersFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchNFingersFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchNFingersFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchNFingersFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventTouchpadPinchNFingersFieldInfo = (~)Int8
    type AttrTransferType EventTouchpadPinchNFingersFieldInfo = Int8
    type AttrGetType EventTouchpadPinchNFingersFieldInfo = Int8
    type AttrLabel EventTouchpadPinchNFingersFieldInfo = "n_fingers"
    type AttrOrigin EventTouchpadPinchNFingersFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchNFingers
    attrSet = setEventTouchpadPinchNFingers
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.nFingers"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:nFingers"
        })

eventTouchpadPinch_nFingers :: AttrLabelProxy "nFingers"
eventTouchpadPinch_nFingers = AttrLabelProxy

#endif


-- | Get the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #time
-- @
getEventTouchpadPinchTime :: MonadIO m => EventTouchpadPinch -> m Word32
getEventTouchpadPinchTime s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO Word32
    return val

-- | Set the value of the “@time@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #time 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchTime :: MonadIO m => EventTouchpadPinch -> Word32 -> m ()
setEventTouchpadPinchTime s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 20) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchTimeFieldInfo
instance AttrInfo EventTouchpadPinchTimeFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchTimeFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchTimeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchTimeFieldInfo = (~) Word32
    type AttrTransferTypeConstraint EventTouchpadPinchTimeFieldInfo = (~)Word32
    type AttrTransferType EventTouchpadPinchTimeFieldInfo = Word32
    type AttrGetType EventTouchpadPinchTimeFieldInfo = Word32
    type AttrLabel EventTouchpadPinchTimeFieldInfo = "time"
    type AttrOrigin EventTouchpadPinchTimeFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchTime
    attrSet = setEventTouchpadPinchTime
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.time"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:time"
        })

eventTouchpadPinch_time :: AttrLabelProxy "time"
eventTouchpadPinch_time = AttrLabelProxy

#endif


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #x
-- @
getEventTouchpadPinchX :: MonadIO m => EventTouchpadPinch -> m Double
getEventTouchpadPinchX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchX :: MonadIO m => EventTouchpadPinch -> Double -> m ()
setEventTouchpadPinchX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 24) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchXFieldInfo
instance AttrInfo EventTouchpadPinchXFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchXFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchXFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadPinchXFieldInfo = (~)Double
    type AttrTransferType EventTouchpadPinchXFieldInfo = Double
    type AttrGetType EventTouchpadPinchXFieldInfo = Double
    type AttrLabel EventTouchpadPinchXFieldInfo = "x"
    type AttrOrigin EventTouchpadPinchXFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchX
    attrSet = setEventTouchpadPinchX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:x"
        })

eventTouchpadPinch_x :: AttrLabelProxy "x"
eventTouchpadPinch_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #y
-- @
getEventTouchpadPinchY :: MonadIO m => EventTouchpadPinch -> m Double
getEventTouchpadPinchY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchY :: MonadIO m => EventTouchpadPinch -> Double -> m ()
setEventTouchpadPinchY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 32) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchYFieldInfo
instance AttrInfo EventTouchpadPinchYFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchYFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchYFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadPinchYFieldInfo = (~)Double
    type AttrTransferType EventTouchpadPinchYFieldInfo = Double
    type AttrGetType EventTouchpadPinchYFieldInfo = Double
    type AttrLabel EventTouchpadPinchYFieldInfo = "y"
    type AttrOrigin EventTouchpadPinchYFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchY
    attrSet = setEventTouchpadPinchY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:y"
        })

eventTouchpadPinch_y :: AttrLabelProxy "y"
eventTouchpadPinch_y = AttrLabelProxy

#endif


-- | Get the value of the “@dx@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #dx
-- @
getEventTouchpadPinchDx :: MonadIO m => EventTouchpadPinch -> m Double
getEventTouchpadPinchDx s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 40) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@dx@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #dx 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchDx :: MonadIO m => EventTouchpadPinch -> Double -> m ()
setEventTouchpadPinchDx s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 40) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchDxFieldInfo
instance AttrInfo EventTouchpadPinchDxFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchDxFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchDxFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchDxFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadPinchDxFieldInfo = (~)Double
    type AttrTransferType EventTouchpadPinchDxFieldInfo = Double
    type AttrGetType EventTouchpadPinchDxFieldInfo = Double
    type AttrLabel EventTouchpadPinchDxFieldInfo = "dx"
    type AttrOrigin EventTouchpadPinchDxFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchDx
    attrSet = setEventTouchpadPinchDx
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.dx"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:dx"
        })

eventTouchpadPinch_dx :: AttrLabelProxy "dx"
eventTouchpadPinch_dx = AttrLabelProxy

#endif


-- | Get the value of the “@dy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #dy
-- @
getEventTouchpadPinchDy :: MonadIO m => EventTouchpadPinch -> m Double
getEventTouchpadPinchDy s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 48) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@dy@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #dy 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchDy :: MonadIO m => EventTouchpadPinch -> Double -> m ()
setEventTouchpadPinchDy s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 48) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchDyFieldInfo
instance AttrInfo EventTouchpadPinchDyFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchDyFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchDyFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchDyFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadPinchDyFieldInfo = (~)Double
    type AttrTransferType EventTouchpadPinchDyFieldInfo = Double
    type AttrGetType EventTouchpadPinchDyFieldInfo = Double
    type AttrLabel EventTouchpadPinchDyFieldInfo = "dy"
    type AttrOrigin EventTouchpadPinchDyFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchDy
    attrSet = setEventTouchpadPinchDy
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.dy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:dy"
        })

eventTouchpadPinch_dy :: AttrLabelProxy "dy"
eventTouchpadPinch_dy = AttrLabelProxy

#endif


-- | Get the value of the “@angle_delta@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #angleDelta
-- @
getEventTouchpadPinchAngleDelta :: MonadIO m => EventTouchpadPinch -> m Double
getEventTouchpadPinchAngleDelta s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 56) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@angle_delta@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #angleDelta 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchAngleDelta :: MonadIO m => EventTouchpadPinch -> Double -> m ()
setEventTouchpadPinchAngleDelta s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 56) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchAngleDeltaFieldInfo
instance AttrInfo EventTouchpadPinchAngleDeltaFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchAngleDeltaFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchAngleDeltaFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchAngleDeltaFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadPinchAngleDeltaFieldInfo = (~)Double
    type AttrTransferType EventTouchpadPinchAngleDeltaFieldInfo = Double
    type AttrGetType EventTouchpadPinchAngleDeltaFieldInfo = Double
    type AttrLabel EventTouchpadPinchAngleDeltaFieldInfo = "angle_delta"
    type AttrOrigin EventTouchpadPinchAngleDeltaFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchAngleDelta
    attrSet = setEventTouchpadPinchAngleDelta
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.angleDelta"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:angleDelta"
        })

eventTouchpadPinch_angleDelta :: AttrLabelProxy "angleDelta"
eventTouchpadPinch_angleDelta = AttrLabelProxy

#endif


-- | Get the value of the “@scale@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #scale
-- @
getEventTouchpadPinchScale :: MonadIO m => EventTouchpadPinch -> m Double
getEventTouchpadPinchScale s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 64) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@scale@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #scale 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchScale :: MonadIO m => EventTouchpadPinch -> Double -> m ()
setEventTouchpadPinchScale s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 64) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchScaleFieldInfo
instance AttrInfo EventTouchpadPinchScaleFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchScaleFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchScaleFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchScaleFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadPinchScaleFieldInfo = (~)Double
    type AttrTransferType EventTouchpadPinchScaleFieldInfo = Double
    type AttrGetType EventTouchpadPinchScaleFieldInfo = Double
    type AttrLabel EventTouchpadPinchScaleFieldInfo = "scale"
    type AttrOrigin EventTouchpadPinchScaleFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchScale
    attrSet = setEventTouchpadPinchScale
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.scale"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:scale"
        })

eventTouchpadPinch_scale :: AttrLabelProxy "scale"
eventTouchpadPinch_scale = AttrLabelProxy

#endif


-- | Get the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #xRoot
-- @
getEventTouchpadPinchXRoot :: MonadIO m => EventTouchpadPinch -> m Double
getEventTouchpadPinchXRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 72) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #xRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchXRoot :: MonadIO m => EventTouchpadPinch -> Double -> m ()
setEventTouchpadPinchXRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 72) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchXRootFieldInfo
instance AttrInfo EventTouchpadPinchXRootFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchXRootFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchXRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchXRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadPinchXRootFieldInfo = (~)Double
    type AttrTransferType EventTouchpadPinchXRootFieldInfo = Double
    type AttrGetType EventTouchpadPinchXRootFieldInfo = Double
    type AttrLabel EventTouchpadPinchXRootFieldInfo = "x_root"
    type AttrOrigin EventTouchpadPinchXRootFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchXRoot
    attrSet = setEventTouchpadPinchXRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.xRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:xRoot"
        })

eventTouchpadPinch_xRoot :: AttrLabelProxy "xRoot"
eventTouchpadPinch_xRoot = AttrLabelProxy

#endif


-- | Get the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #yRoot
-- @
getEventTouchpadPinchYRoot :: MonadIO m => EventTouchpadPinch -> m Double
getEventTouchpadPinchYRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 80) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y_root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #yRoot 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchYRoot :: MonadIO m => EventTouchpadPinch -> Double -> m ()
setEventTouchpadPinchYRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 80) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchYRootFieldInfo
instance AttrInfo EventTouchpadPinchYRootFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchYRootFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchYRootFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchYRootFieldInfo = (~) Double
    type AttrTransferTypeConstraint EventTouchpadPinchYRootFieldInfo = (~)Double
    type AttrTransferType EventTouchpadPinchYRootFieldInfo = Double
    type AttrGetType EventTouchpadPinchYRootFieldInfo = Double
    type AttrLabel EventTouchpadPinchYRootFieldInfo = "y_root"
    type AttrOrigin EventTouchpadPinchYRootFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchYRoot
    attrSet = setEventTouchpadPinchYRoot
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.yRoot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:yRoot"
        })

eventTouchpadPinch_yRoot :: AttrLabelProxy "yRoot"
eventTouchpadPinch_yRoot = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventTouchpadPinch #state
-- @
getEventTouchpadPinchState :: MonadIO m => EventTouchpadPinch -> m [Gdk.Flags.ModifierType]
getEventTouchpadPinchState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 88) :: IO CUInt
    let val' = wordToGFlags val
    return val'

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventTouchpadPinch [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventTouchpadPinchState :: MonadIO m => EventTouchpadPinch -> [Gdk.Flags.ModifierType] -> m ()
setEventTouchpadPinchState s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = gflagsToWord val
    poke (ptr `plusPtr` 88) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventTouchpadPinchStateFieldInfo
instance AttrInfo EventTouchpadPinchStateFieldInfo where
    type AttrBaseTypeConstraint EventTouchpadPinchStateFieldInfo = (~) EventTouchpadPinch
    type AttrAllowedOps EventTouchpadPinchStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventTouchpadPinchStateFieldInfo = (~) [Gdk.Flags.ModifierType]
    type AttrTransferTypeConstraint EventTouchpadPinchStateFieldInfo = (~)[Gdk.Flags.ModifierType]
    type AttrTransferType EventTouchpadPinchStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrGetType EventTouchpadPinchStateFieldInfo = [Gdk.Flags.ModifierType]
    type AttrLabel EventTouchpadPinchStateFieldInfo = "state"
    type AttrOrigin EventTouchpadPinchStateFieldInfo = EventTouchpadPinch
    attrGet = getEventTouchpadPinchState
    attrSet = setEventTouchpadPinchState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventTouchpadPinch.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventTouchpadPinch.html#g:attr:state"
        })

eventTouchpadPinch_state :: AttrLabelProxy "state"
eventTouchpadPinch_state = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventTouchpadPinch
type instance O.AttributeList EventTouchpadPinch = EventTouchpadPinchAttributeList
type EventTouchpadPinchAttributeList = ('[ '("type", EventTouchpadPinchTypeFieldInfo), '("window", EventTouchpadPinchWindowFieldInfo), '("sendEvent", EventTouchpadPinchSendEventFieldInfo), '("phase", EventTouchpadPinchPhaseFieldInfo), '("nFingers", EventTouchpadPinchNFingersFieldInfo), '("time", EventTouchpadPinchTimeFieldInfo), '("x", EventTouchpadPinchXFieldInfo), '("y", EventTouchpadPinchYFieldInfo), '("dx", EventTouchpadPinchDxFieldInfo), '("dy", EventTouchpadPinchDyFieldInfo), '("angleDelta", EventTouchpadPinchAngleDeltaFieldInfo), '("scale", EventTouchpadPinchScaleFieldInfo), '("xRoot", EventTouchpadPinchXRootFieldInfo), '("yRoot", EventTouchpadPinchYRootFieldInfo), '("state", EventTouchpadPinchStateFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventTouchpadPinchMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventTouchpadPinchMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventTouchpadPinchMethod t EventTouchpadPinch, O.OverloadedMethod info EventTouchpadPinch p) => OL.IsLabel t (EventTouchpadPinch -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventTouchpadPinchMethod t EventTouchpadPinch, O.OverloadedMethod info EventTouchpadPinch p, R.HasField t EventTouchpadPinch p) => R.HasField t EventTouchpadPinch p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventTouchpadPinchMethod t EventTouchpadPinch, O.OverloadedMethodInfo info EventTouchpadPinch) => OL.IsLabel t (O.MethodProxy info EventTouchpadPinch) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


