{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A color stop in a gradient node.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Structs.ColorStop
    ( 

-- * Exported types
    ColorStop(..)                           ,
    newZeroColorStop                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveColorStopMethod                  ,
#endif



 -- * Properties


-- ** color #attr:color#
-- | the color at the given offset

#if defined(ENABLE_OVERLOADING)
    colorStop_color                         ,
#endif
    getColorStopColor                       ,


-- ** offset #attr:offset#
-- | the offset of the color stop

#if defined(ENABLE_OVERLOADING)
    colorStop_offset                        ,
#endif
    getColorStopOffset                      ,
    setColorStopOffset                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA

#else
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA

#endif

-- | Memory-managed wrapper type.
newtype ColorStop = ColorStop (SP.ManagedPtr ColorStop)
    deriving (Eq)

instance SP.ManagedPtrNewtype ColorStop where
    toManagedPtr (ColorStop p) = p

instance BoxedPtr ColorStop where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 20 >=> B.ManagedPtr.wrapPtr ColorStop)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr ColorStop where
    boxedPtrCalloc = callocBytes 20


-- | Construct a t'ColorStop' struct initialized to zero.
newZeroColorStop :: MonadIO m => m ColorStop
newZeroColorStop = liftIO $ boxedPtrCalloc >>= wrapPtr ColorStop

instance tag ~ 'AttrSet => Constructible ColorStop tag where
    new _ attrs = do
        o <- newZeroColorStop
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorStop #offset
-- @
getColorStopOffset :: MonadIO m => ColorStop -> m Float
getColorStopOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' colorStop [ #offset 'Data.GI.Base.Attributes.:=' value ]
-- @
setColorStopOffset :: MonadIO m => ColorStop -> Float -> m ()
setColorStopOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 0) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data ColorStopOffsetFieldInfo
instance AttrInfo ColorStopOffsetFieldInfo where
    type AttrBaseTypeConstraint ColorStopOffsetFieldInfo = (~) ColorStop
    type AttrAllowedOps ColorStopOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ColorStopOffsetFieldInfo = (~) Float
    type AttrTransferTypeConstraint ColorStopOffsetFieldInfo = (~)Float
    type AttrTransferType ColorStopOffsetFieldInfo = Float
    type AttrGetType ColorStopOffsetFieldInfo = Float
    type AttrLabel ColorStopOffsetFieldInfo = "offset"
    type AttrOrigin ColorStopOffsetFieldInfo = ColorStop
    attrGet = getColorStopOffset
    attrSet = setColorStopOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ColorStop.offset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ColorStop.html#g:attr:offset"
        })

colorStop_offset :: AttrLabelProxy "offset"
colorStop_offset = AttrLabelProxy

#endif


-- | Get the value of the “@color@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' colorStop #color
-- @
getColorStopColor :: MonadIO m => ColorStop -> m Gdk.RGBA.RGBA
getColorStopColor s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 4 :: (Ptr Gdk.RGBA.RGBA)
    val' <- (newBoxed Gdk.RGBA.RGBA) val
    return val'

#if defined(ENABLE_OVERLOADING)
data ColorStopColorFieldInfo
instance AttrInfo ColorStopColorFieldInfo where
    type AttrBaseTypeConstraint ColorStopColorFieldInfo = (~) ColorStop
    type AttrAllowedOps ColorStopColorFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint ColorStopColorFieldInfo = (~) (Ptr Gdk.RGBA.RGBA)
    type AttrTransferTypeConstraint ColorStopColorFieldInfo = (~)(Ptr Gdk.RGBA.RGBA)
    type AttrTransferType ColorStopColorFieldInfo = (Ptr Gdk.RGBA.RGBA)
    type AttrGetType ColorStopColorFieldInfo = Gdk.RGBA.RGBA
    type AttrLabel ColorStopColorFieldInfo = "color"
    type AttrOrigin ColorStopColorFieldInfo = ColorStop
    attrGet = getColorStopColor
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ColorStop.color"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ColorStop.html#g:attr:color"
        })

colorStop_color :: AttrLabelProxy "color"
colorStop_color = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ColorStop
type instance O.AttributeList ColorStop = ColorStopAttributeList
type ColorStopAttributeList = ('[ '("offset", ColorStopOffsetFieldInfo), '("color", ColorStopColorFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveColorStopMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveColorStopMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveColorStopMethod t ColorStop, O.OverloadedMethod info ColorStop p) => OL.IsLabel t (ColorStop -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveColorStopMethod t ColorStop, O.OverloadedMethod info ColorStop p, R.HasField t ColorStop p) => R.HasField t ColorStop p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveColorStopMethod t ColorStop, O.OverloadedMethodInfo info ColorStop) => OL.IsLabel t (O.MethodProxy info ColorStop) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


