#ifndef INCLUDED_OFFICECFG_SETUP_HXX
#define INCLUDED_OFFICECFG_SETUP_HXX

#include "sal/config.h"

#include <optional>
#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Setup {

struct Product: public comphelper::ConfigurationGroup< Product> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product"_ustr); return PATH; }

struct ooName: public comphelper::ConfigurationProperty<ooName, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product/ooName"_ustr); return PATH; }
private:
    ooName(); // not defined
    ~ooName(); // not defined
};

struct ooSetupVersion: public comphelper::ConfigurationProperty<ooSetupVersion, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product/ooSetupVersion"_ustr); return PATH; }
private:
    ooSetupVersion(); // not defined
    ~ooSetupVersion(); // not defined
};

struct ooSetupLastVersion: public comphelper::ConfigurationProperty<ooSetupLastVersion, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product/ooSetupLastVersion"_ustr); return PATH; }
private:
    ooSetupLastVersion(); // not defined
    ~ooSetupLastVersion(); // not defined
};

struct ooSetupVersionAboutBox: public comphelper::ConfigurationProperty<ooSetupVersionAboutBox, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product/ooSetupVersionAboutBox"_ustr); return PATH; }
private:
    ooSetupVersionAboutBox(); // not defined
    ~ooSetupVersionAboutBox(); // not defined
};

struct ooSetupVersionAboutBoxSuffix: public comphelper::ConfigurationProperty<ooSetupVersionAboutBoxSuffix, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product/ooSetupVersionAboutBoxSuffix"_ustr); return PATH; }
private:
    ooSetupVersionAboutBoxSuffix(); // not defined
    ~ooSetupVersionAboutBoxSuffix(); // not defined
};

struct ooVendor: public comphelper::ConfigurationProperty<ooVendor, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product/ooVendor"_ustr); return PATH; }
private:
    ooVendor(); // not defined
    ~ooVendor(); // not defined
};

struct ooSetupExtension: public comphelper::ConfigurationProperty<ooSetupExtension, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product/ooSetupExtension"_ustr); return PATH; }
private:
    ooSetupExtension(); // not defined
    ~ooSetupExtension(); // not defined
};

struct LastTimeGetInvolvedShown: public comphelper::ConfigurationProperty<LastTimeGetInvolvedShown, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product/LastTimeGetInvolvedShown"_ustr); return PATH; }
private:
    LastTimeGetInvolvedShown(); // not defined
    ~LastTimeGetInvolvedShown(); // not defined
};

struct LastTimeDonateShown: public comphelper::ConfigurationProperty<LastTimeDonateShown, sal_Int64> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product/LastTimeDonateShown"_ustr); return PATH; }
private:
    LastTimeDonateShown(); // not defined
    ~LastTimeDonateShown(); // not defined
};

struct WhatsNew: public comphelper::ConfigurationProperty<WhatsNew, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product/WhatsNew"_ustr); return PATH; }
private:
    WhatsNew(); // not defined
    ~WhatsNew(); // not defined
};

struct WhatsNewDialog: public comphelper::ConfigurationProperty<WhatsNewDialog, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Product/WhatsNewDialog"_ustr); return PATH; }
private:
    WhatsNewDialog(); // not defined
    ~WhatsNewDialog(); // not defined
};

private:
    Product(); // not defined
    ~Product(); // not defined
};

struct Office: public comphelper::ConfigurationGroup< Office> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Office"_ustr); return PATH; }

struct ooSetupInstCompleted: public comphelper::ConfigurationProperty<ooSetupInstCompleted, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Office/ooSetupInstCompleted"_ustr); return PATH; }
private:
    ooSetupInstCompleted(); // not defined
    ~ooSetupInstCompleted(); // not defined
};

struct InstalledLocales: public comphelper::ConfigurationSet< InstalledLocales> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Office/InstalledLocales"_ustr); return PATH; }
private:
    InstalledLocales(); // not defined
    ~InstalledLocales(); // not defined
};

struct ooSetupConnectionURL: public comphelper::ConfigurationProperty<ooSetupConnectionURL, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Office/ooSetupConnectionURL"_ustr); return PATH; }
private:
    ooSetupConnectionURL(); // not defined
    ~ooSetupConnectionURL(); // not defined
};

struct MigrationCompleted: public comphelper::ConfigurationProperty<MigrationCompleted, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Office/MigrationCompleted"_ustr); return PATH; }
private:
    MigrationCompleted(); // not defined
    ~MigrationCompleted(); // not defined
};

struct LastCompatibilityCheckID: public comphelper::ConfigurationProperty<LastCompatibilityCheckID, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Office/LastCompatibilityCheckID"_ustr); return PATH; }
private:
    LastCompatibilityCheckID(); // not defined
    ~LastCompatibilityCheckID(); // not defined
};

struct Factories: public comphelper::ConfigurationSet< Factories> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Office/Factories"_ustr); return PATH; }
private:
    Factories(); // not defined
    ~Factories(); // not defined
};

struct OfficeRestartInProgress: public comphelper::ConfigurationProperty<OfficeRestartInProgress, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Office/OfficeRestartInProgress"_ustr); return PATH; }
private:
    OfficeRestartInProgress(); // not defined
    ~OfficeRestartInProgress(); // not defined
};

private:
    Office(); // not defined
    ~Office(); // not defined
};

struct L10N: public comphelper::ConfigurationGroup< L10N> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/L10N"_ustr); return PATH; }

struct ooLocale: public comphelper::ConfigurationProperty<ooLocale, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/L10N/ooLocale"_ustr); return PATH; }
private:
    ooLocale(); // not defined
    ~ooLocale(); // not defined
};

struct ooSetupSystemLocale: public comphelper::ConfigurationProperty<ooSetupSystemLocale, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/L10N/ooSetupSystemLocale"_ustr); return PATH; }
private:
    ooSetupSystemLocale(); // not defined
    ~ooSetupSystemLocale(); // not defined
};

struct ooSetupCurrency: public comphelper::ConfigurationProperty<ooSetupCurrency, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/L10N/ooSetupCurrency"_ustr); return PATH; }
private:
    ooSetupCurrency(); // not defined
    ~ooSetupCurrency(); // not defined
};

struct DecimalSeparatorAsLocale: public comphelper::ConfigurationProperty<DecimalSeparatorAsLocale, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/L10N/DecimalSeparatorAsLocale"_ustr); return PATH; }
private:
    DecimalSeparatorAsLocale(); // not defined
    ~DecimalSeparatorAsLocale(); // not defined
};

struct IgnoreLanguageChange: public comphelper::ConfigurationProperty<IgnoreLanguageChange, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/L10N/IgnoreLanguageChange"_ustr); return PATH; }
private:
    IgnoreLanguageChange(); // not defined
    ~IgnoreLanguageChange(); // not defined
};

struct DateAcceptancePatterns: public comphelper::ConfigurationProperty<DateAcceptancePatterns, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/L10N/DateAcceptancePatterns"_ustr); return PATH; }
private:
    DateAcceptancePatterns(); // not defined
    ~DateAcceptancePatterns(); // not defined
};

private:
    L10N(); // not defined
    ~L10N(); // not defined
};

struct Migration: public comphelper::ConfigurationGroup< Migration> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Migration"_ustr); return PATH; }

struct SupportedVersions: public comphelper::ConfigurationSet< SupportedVersions> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Setup/Migration/SupportedVersions"_ustr); return PATH; }
private:
    SupportedVersions(); // not defined
    ~SupportedVersions(); // not defined
};

private:
    Migration(); // not defined
    ~Migration(); // not defined
};

} }

#endif
