/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "notify-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__UINT_UINT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintUintFunc)
       (void *data1,
        guint arg_id,
        guint arg_reason,
        void *data2);
  _GDbusCodegenMarshalVoid_UintUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_VOID__UINT_STRING (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_UintStringFunc)
       (void *data1,
        guint arg_id,
        const gchar *arg_action_key,
        void *data2);
  _GDbusCodegenMarshalVoid_UintStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_UintStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_uint (param_values + 1),
            g_marshal_value_peek_string (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT_STRING_STRING_STRING_BOXED_VARIANT_INT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringUintStringStringStringBoxedVariantIntFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_app_name,
        guint arg_replaces_id,
        const gchar *arg_app_icon,
        const gchar *arg_summary,
        const gchar *arg_body,
        const gchar *const *arg_actions,
        GVariant *arg_hints,
        gint arg_expire_timeout,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringUintStringStringStringBoxedVariantIntFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 10);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringUintStringStringStringBoxedVariantIntFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              g_marshal_value_peek_string (param_values + 4),
              g_marshal_value_peek_string (param_values + 5),
              g_marshal_value_peek_string (param_values + 6),
              g_marshal_value_peek_boxed (param_values + 7),
              g_marshal_value_peek_variant (param_values + 8),
              g_marshal_value_peek_int (param_values + 9),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_id,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.Notifications
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:PhoshNotifyDBusNotifications
 * @title: PhoshNotifyDBusNotifications
 * @short_description: Generated C code for the org.freedesktop.Notifications D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-Notifications.top_of_page">org.freedesktop.Notifications</link> D-Bus interface in C.
 */

enum
{
  PHOSH_NOTIFY_DBUS__NOTIFICATIONS_NOTIFICATION_CLOSED,
  PHOSH_NOTIFY_DBUS__NOTIFICATIONS_ACTION_INVOKED,
};

static unsigned PHOSH_NOTIFY_DBUS__NOTIFICATIONS_SIGNALS[2] = { 0 };

/* ---- Introspection data for org.freedesktop.Notifications ---- */

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_get_capabilities_OUT_ARG_capabilities =
{
  {
    -1,
    (gchar *) "capabilities",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_notify_dbus_notifications_method_info_get_capabilities_OUT_ARG_pointers[] =
{
  &_phosh_notify_dbus_notifications_method_info_get_capabilities_OUT_ARG_capabilities.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_notify_dbus_notifications_method_info_get_capabilities =
{
  {
    -1,
    (gchar *) "GetCapabilities",
    NULL,
    (GDBusArgInfo **) &_phosh_notify_dbus_notifications_method_info_get_capabilities_OUT_ARG_pointers,
    NULL
  },
  "handle-get-capabilities",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_notify_IN_ARG_app_name =
{
  {
    -1,
    (gchar *) "app_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_notify_IN_ARG_replaces_id =
{
  {
    -1,
    (gchar *) "replaces_id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_notify_IN_ARG_app_icon =
{
  {
    -1,
    (gchar *) "app_icon",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_notify_IN_ARG_summary =
{
  {
    -1,
    (gchar *) "summary",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_notify_IN_ARG_body =
{
  {
    -1,
    (gchar *) "body",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_notify_IN_ARG_actions =
{
  {
    -1,
    (gchar *) "actions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_notify_IN_ARG_hints =
{
  {
    -1,
    (gchar *) "hints",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_notify_IN_ARG_expire_timeout =
{
  {
    -1,
    (gchar *) "expire_timeout",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_notify_dbus_notifications_method_info_notify_IN_ARG_pointers[] =
{
  &_phosh_notify_dbus_notifications_method_info_notify_IN_ARG_app_name.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_notify_IN_ARG_replaces_id.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_notify_IN_ARG_app_icon.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_notify_IN_ARG_summary.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_notify_IN_ARG_body.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_notify_IN_ARG_actions.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_notify_IN_ARG_hints.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_notify_IN_ARG_expire_timeout.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_notify_OUT_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_notify_dbus_notifications_method_info_notify_OUT_ARG_pointers[] =
{
  &_phosh_notify_dbus_notifications_method_info_notify_OUT_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_notify_dbus_notifications_method_info_notify =
{
  {
    -1,
    (gchar *) "Notify",
    (GDBusArgInfo **) &_phosh_notify_dbus_notifications_method_info_notify_IN_ARG_pointers,
    (GDBusArgInfo **) &_phosh_notify_dbus_notifications_method_info_notify_OUT_ARG_pointers,
    NULL
  },
  "handle-notify",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_close_notification_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_notify_dbus_notifications_method_info_close_notification_IN_ARG_pointers[] =
{
  &_phosh_notify_dbus_notifications_method_info_close_notification_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_notify_dbus_notifications_method_info_close_notification =
{
  {
    -1,
    (gchar *) "CloseNotification",
    (GDBusArgInfo **) &_phosh_notify_dbus_notifications_method_info_close_notification_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-close-notification",
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_get_server_information_OUT_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_get_server_information_OUT_ARG_vendor =
{
  {
    -1,
    (gchar *) "vendor",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_get_server_information_OUT_ARG_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_method_info_get_server_information_OUT_ARG_spec_version =
{
  {
    -1,
    (gchar *) "spec_version",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_notify_dbus_notifications_method_info_get_server_information_OUT_ARG_pointers[] =
{
  &_phosh_notify_dbus_notifications_method_info_get_server_information_OUT_ARG_name.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_get_server_information_OUT_ARG_vendor.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_get_server_information_OUT_ARG_version.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_get_server_information_OUT_ARG_spec_version.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _phosh_notify_dbus_notifications_method_info_get_server_information =
{
  {
    -1,
    (gchar *) "GetServerInformation",
    NULL,
    (GDBusArgInfo **) &_phosh_notify_dbus_notifications_method_info_get_server_information_OUT_ARG_pointers,
    NULL
  },
  "handle-get-server-information",
  FALSE
};

static const GDBusMethodInfo * const _phosh_notify_dbus_notifications_method_info_pointers[] =
{
  &_phosh_notify_dbus_notifications_method_info_get_capabilities.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_notify.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_close_notification.parent_struct,
  &_phosh_notify_dbus_notifications_method_info_get_server_information.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_signal_info_notification_closed_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_signal_info_notification_closed_ARG_reason =
{
  {
    -1,
    (gchar *) "reason",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_notify_dbus_notifications_signal_info_notification_closed_ARG_pointers[] =
{
  &_phosh_notify_dbus_notifications_signal_info_notification_closed_ARG_id.parent_struct,
  &_phosh_notify_dbus_notifications_signal_info_notification_closed_ARG_reason.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _phosh_notify_dbus_notifications_signal_info_notification_closed =
{
  {
    -1,
    (gchar *) "NotificationClosed",
    (GDBusArgInfo **) &_phosh_notify_dbus_notifications_signal_info_notification_closed_ARG_pointers,
    NULL
  },
  "notification-closed"
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_signal_info_action_invoked_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _phosh_notify_dbus_notifications_signal_info_action_invoked_ARG_action_key =
{
  {
    -1,
    (gchar *) "action_key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _phosh_notify_dbus_notifications_signal_info_action_invoked_ARG_pointers[] =
{
  &_phosh_notify_dbus_notifications_signal_info_action_invoked_ARG_id.parent_struct,
  &_phosh_notify_dbus_notifications_signal_info_action_invoked_ARG_action_key.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _phosh_notify_dbus_notifications_signal_info_action_invoked =
{
  {
    -1,
    (gchar *) "ActionInvoked",
    (GDBusArgInfo **) &_phosh_notify_dbus_notifications_signal_info_action_invoked_ARG_pointers,
    NULL
  },
  "action-invoked"
};

static const GDBusSignalInfo * const _phosh_notify_dbus_notifications_signal_info_pointers[] =
{
  &_phosh_notify_dbus_notifications_signal_info_notification_closed.parent_struct,
  &_phosh_notify_dbus_notifications_signal_info_action_invoked.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _phosh_notify_dbus_notifications_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.Notifications",
    (GDBusMethodInfo **) &_phosh_notify_dbus_notifications_method_info_pointers,
    (GDBusSignalInfo **) &_phosh_notify_dbus_notifications_signal_info_pointers,
    NULL,
    NULL
  },
  "notifications",
};


/**
 * phosh_notify_dbus_notifications_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-Notifications.top_of_page">org.freedesktop.Notifications</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
phosh_notify_dbus_notifications_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_phosh_notify_dbus_notifications_interface_info.parent_struct;
}

/**
 * phosh_notify_dbus_notifications_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #PhoshNotifyDBusNotifications interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
phosh_notify_dbus_notifications_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
phosh_notify_dbus_notifications_signal_marshal_notification_closed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_notify_dbus_notifications_signal_marshal_action_invoked (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__UINT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_notify_dbus_notifications_method_marshal_get_capabilities (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_notify_dbus_notifications_method_marshal_notify (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT_STRING_STRING_STRING_BOXED_VARIANT_INT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_notify_dbus_notifications_method_marshal_close_notification (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
phosh_notify_dbus_notifications_method_marshal_get_server_information (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * PhoshNotifyDBusNotifications:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Notifications.top_of_page">org.freedesktop.Notifications</link>.
 */

/**
 * PhoshNotifyDBusNotificationsIface:
 * @parent_iface: The parent interface.
 * @handle_close_notification: Handler for the #PhoshNotifyDBusNotifications::handle-close-notification signal.
 * @handle_get_capabilities: Handler for the #PhoshNotifyDBusNotifications::handle-get-capabilities signal.
 * @handle_get_server_information: Handler for the #PhoshNotifyDBusNotifications::handle-get-server-information signal.
 * @handle_notify: Handler for the #PhoshNotifyDBusNotifications::handle-notify signal.
 * @action_invoked: Handler for the #PhoshNotifyDBusNotifications::action-invoked signal.
 * @notification_closed: Handler for the #PhoshNotifyDBusNotifications::notification-closed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Notifications.top_of_page">org.freedesktop.Notifications</link>.
 */

typedef PhoshNotifyDBusNotificationsIface PhoshNotifyDBusNotificationsInterface;
G_DEFINE_INTERFACE (PhoshNotifyDBusNotifications, phosh_notify_dbus_notifications, G_TYPE_OBJECT)

static void
phosh_notify_dbus_notifications_default_init (PhoshNotifyDBusNotificationsIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * PhoshNotifyDBusNotifications::handle-get-capabilities:
   * @object: A #PhoshNotifyDBusNotifications.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Notifications.GetCapabilities">GetCapabilities()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_notify_dbus_notifications_complete_get_capabilities() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-capabilities",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshNotifyDBusNotificationsIface, handle_get_capabilities),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_notify_dbus_notifications_method_marshal_get_capabilities,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * PhoshNotifyDBusNotifications::handle-notify:
   * @object: A #PhoshNotifyDBusNotifications.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_name: Argument passed by remote caller.
   * @arg_replaces_id: Argument passed by remote caller.
   * @arg_app_icon: Argument passed by remote caller.
   * @arg_summary: Argument passed by remote caller.
   * @arg_body: Argument passed by remote caller.
   * @arg_actions: Argument passed by remote caller.
   * @arg_hints: Argument passed by remote caller.
   * @arg_expire_timeout: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Notifications.Notify">Notify()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_notify_dbus_notifications_complete_notify() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshNotifyDBusNotificationsIface, handle_notify),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_notify_dbus_notifications_method_marshal_notify,
    G_TYPE_BOOLEAN,
    9,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_VARIANT, G_TYPE_INT);

  /**
   * PhoshNotifyDBusNotifications::handle-close-notification:
   * @object: A #PhoshNotifyDBusNotifications.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Notifications.CloseNotification">CloseNotification()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_notify_dbus_notifications_complete_close_notification() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close-notification",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshNotifyDBusNotificationsIface, handle_close_notification),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_notify_dbus_notifications_method_marshal_close_notification,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * PhoshNotifyDBusNotifications::handle-get-server-information:
   * @object: A #PhoshNotifyDBusNotifications.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-Notifications.GetServerInformation">GetServerInformation()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call phosh_notify_dbus_notifications_complete_get_server_information() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-server-information",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (PhoshNotifyDBusNotificationsIface, handle_get_server_information),
    g_signal_accumulator_true_handled,
    NULL,
      phosh_notify_dbus_notifications_method_marshal_get_server_information,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * PhoshNotifyDBusNotifications::notification-closed:
   * @object: A #PhoshNotifyDBusNotifications.
   * @arg_id: Argument.
   * @arg_reason: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Notifications.NotificationClosed">"NotificationClosed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_NOTIFY_DBUS__NOTIFICATIONS_SIGNALS[PHOSH_NOTIFY_DBUS__NOTIFICATIONS_NOTIFICATION_CLOSED] =
    g_signal_new ("notification-closed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshNotifyDBusNotificationsIface, notification_closed),
      NULL,
      NULL,
      phosh_notify_dbus_notifications_signal_marshal_notification_closed,
      G_TYPE_NONE,
      2, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * PhoshNotifyDBusNotifications::action-invoked:
   * @object: A #PhoshNotifyDBusNotifications.
   * @arg_id: Argument.
   * @arg_action_key: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-Notifications.ActionInvoked">"ActionInvoked"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  PHOSH_NOTIFY_DBUS__NOTIFICATIONS_SIGNALS[PHOSH_NOTIFY_DBUS__NOTIFICATIONS_ACTION_INVOKED] =
    g_signal_new ("action-invoked",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (PhoshNotifyDBusNotificationsIface, action_invoked),
      NULL,
      NULL,
      phosh_notify_dbus_notifications_signal_marshal_action_invoked,
      G_TYPE_NONE,
      2, G_TYPE_UINT, G_TYPE_STRING);

}

/**
 * phosh_notify_dbus_notifications_emit_notification_closed:
 * @object: A #PhoshNotifyDBusNotifications.
 * @arg_id: Argument to pass with the signal.
 * @arg_reason: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Notifications.NotificationClosed">"NotificationClosed"</link> D-Bus signal.
 */
void
phosh_notify_dbus_notifications_emit_notification_closed (
    PhoshNotifyDBusNotifications *object,
    guint arg_id,
    guint arg_reason)
{
  g_signal_emit (object, PHOSH_NOTIFY_DBUS__NOTIFICATIONS_SIGNALS[PHOSH_NOTIFY_DBUS__NOTIFICATIONS_NOTIFICATION_CLOSED], 0, arg_id, arg_reason);
}

/**
 * phosh_notify_dbus_notifications_emit_action_invoked:
 * @object: A #PhoshNotifyDBusNotifications.
 * @arg_id: Argument to pass with the signal.
 * @arg_action_key: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-Notifications.ActionInvoked">"ActionInvoked"</link> D-Bus signal.
 */
void
phosh_notify_dbus_notifications_emit_action_invoked (
    PhoshNotifyDBusNotifications *object,
    guint arg_id,
    const gchar *arg_action_key)
{
  g_signal_emit (object, PHOSH_NOTIFY_DBUS__NOTIFICATIONS_SIGNALS[PHOSH_NOTIFY_DBUS__NOTIFICATIONS_ACTION_INVOKED], 0, arg_id, arg_action_key);
}

/**
 * phosh_notify_dbus_notifications_call_get_capabilities:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Notifications.GetCapabilities">GetCapabilities()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_notify_dbus_notifications_call_get_capabilities_finish() to get the result of the operation.
 *
 * See phosh_notify_dbus_notifications_call_get_capabilities_sync() for the synchronous, blocking version of this method.
 */
void
phosh_notify_dbus_notifications_call_get_capabilities (
    PhoshNotifyDBusNotifications *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetCapabilities",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_notify_dbus_notifications_call_get_capabilities_finish:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @out_capabilities: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_notify_dbus_notifications_call_get_capabilities().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_notify_dbus_notifications_call_get_capabilities().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_notify_dbus_notifications_call_get_capabilities_finish (
    PhoshNotifyDBusNotifications *proxy,
    gchar ***out_capabilities,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_capabilities);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_notify_dbus_notifications_call_get_capabilities_sync:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @out_capabilities: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Notifications.GetCapabilities">GetCapabilities()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_notify_dbus_notifications_call_get_capabilities() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_notify_dbus_notifications_call_get_capabilities_sync (
    PhoshNotifyDBusNotifications *proxy,
    gchar ***out_capabilities,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetCapabilities",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_capabilities);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_notify_dbus_notifications_call_notify:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @arg_app_name: Argument to pass with the method invocation.
 * @arg_replaces_id: Argument to pass with the method invocation.
 * @arg_app_icon: Argument to pass with the method invocation.
 * @arg_summary: Argument to pass with the method invocation.
 * @arg_body: Argument to pass with the method invocation.
 * @arg_actions: Argument to pass with the method invocation.
 * @arg_hints: Argument to pass with the method invocation.
 * @arg_expire_timeout: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Notifications.Notify">Notify()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_notify_dbus_notifications_call_notify_finish() to get the result of the operation.
 *
 * See phosh_notify_dbus_notifications_call_notify_sync() for the synchronous, blocking version of this method.
 */
void
phosh_notify_dbus_notifications_call_notify (
    PhoshNotifyDBusNotifications *proxy,
    const gchar *arg_app_name,
    guint arg_replaces_id,
    const gchar *arg_app_icon,
    const gchar *arg_summary,
    const gchar *arg_body,
    const gchar *const *arg_actions,
    GVariant *arg_hints,
    gint arg_expire_timeout,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Notify",
    g_variant_new ("(susss^as@a{sv}i)",
                   arg_app_name,
                   arg_replaces_id,
                   arg_app_icon,
                   arg_summary,
                   arg_body,
                   arg_actions,
                   arg_hints,
                   arg_expire_timeout),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_notify_dbus_notifications_call_notify_finish:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @out_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_notify_dbus_notifications_call_notify().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_notify_dbus_notifications_call_notify().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_notify_dbus_notifications_call_notify_finish (
    PhoshNotifyDBusNotifications *proxy,
    guint *out_id,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_notify_dbus_notifications_call_notify_sync:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @arg_app_name: Argument to pass with the method invocation.
 * @arg_replaces_id: Argument to pass with the method invocation.
 * @arg_app_icon: Argument to pass with the method invocation.
 * @arg_summary: Argument to pass with the method invocation.
 * @arg_body: Argument to pass with the method invocation.
 * @arg_actions: Argument to pass with the method invocation.
 * @arg_hints: Argument to pass with the method invocation.
 * @arg_expire_timeout: Argument to pass with the method invocation.
 * @out_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Notifications.Notify">Notify()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_notify_dbus_notifications_call_notify() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_notify_dbus_notifications_call_notify_sync (
    PhoshNotifyDBusNotifications *proxy,
    const gchar *arg_app_name,
    guint arg_replaces_id,
    const gchar *arg_app_icon,
    const gchar *arg_summary,
    const gchar *arg_body,
    const gchar *const *arg_actions,
    GVariant *arg_hints,
    gint arg_expire_timeout,
    guint *out_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Notify",
    g_variant_new ("(susss^as@a{sv}i)",
                   arg_app_name,
                   arg_replaces_id,
                   arg_app_icon,
                   arg_summary,
                   arg_body,
                   arg_actions,
                   arg_hints,
                   arg_expire_timeout),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_notify_dbus_notifications_call_close_notification:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Notifications.CloseNotification">CloseNotification()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_notify_dbus_notifications_call_close_notification_finish() to get the result of the operation.
 *
 * See phosh_notify_dbus_notifications_call_close_notification_sync() for the synchronous, blocking version of this method.
 */
void
phosh_notify_dbus_notifications_call_close_notification (
    PhoshNotifyDBusNotifications *proxy,
    guint arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CloseNotification",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_notify_dbus_notifications_call_close_notification_finish:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_notify_dbus_notifications_call_close_notification().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_notify_dbus_notifications_call_close_notification().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_notify_dbus_notifications_call_close_notification_finish (
    PhoshNotifyDBusNotifications *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_notify_dbus_notifications_call_close_notification_sync:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Notifications.CloseNotification">CloseNotification()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_notify_dbus_notifications_call_close_notification() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_notify_dbus_notifications_call_close_notification_sync (
    PhoshNotifyDBusNotifications *proxy,
    guint arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CloseNotification",
    g_variant_new ("(u)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_notify_dbus_notifications_call_get_server_information:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-Notifications.GetServerInformation">GetServerInformation()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_notify_dbus_notifications_call_get_server_information_finish() to get the result of the operation.
 *
 * See phosh_notify_dbus_notifications_call_get_server_information_sync() for the synchronous, blocking version of this method.
 */
void
phosh_notify_dbus_notifications_call_get_server_information (
    PhoshNotifyDBusNotifications *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetServerInformation",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * phosh_notify_dbus_notifications_call_get_server_information_finish:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_vendor: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_version: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_spec_version: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_notify_dbus_notifications_call_get_server_information().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with phosh_notify_dbus_notifications_call_get_server_information().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_notify_dbus_notifications_call_get_server_information_finish (
    PhoshNotifyDBusNotifications *proxy,
    gchar **out_name,
    gchar **out_vendor,
    gchar **out_version,
    gchar **out_spec_version,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ssss)",
                 out_name,
                 out_vendor,
                 out_version,
                 out_spec_version);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_notify_dbus_notifications_call_get_server_information_sync:
 * @proxy: A #PhoshNotifyDBusNotificationsProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_vendor: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_version: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_spec_version: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-Notifications.GetServerInformation">GetServerInformation()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See phosh_notify_dbus_notifications_call_get_server_information() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
phosh_notify_dbus_notifications_call_get_server_information_sync (
    PhoshNotifyDBusNotifications *proxy,
    gchar **out_name,
    gchar **out_vendor,
    gchar **out_version,
    gchar **out_spec_version,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetServerInformation",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ssss)",
                 out_name,
                 out_vendor,
                 out_version,
                 out_spec_version);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * phosh_notify_dbus_notifications_complete_get_capabilities:
 * @object: A #PhoshNotifyDBusNotifications.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @capabilities: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Notifications.GetCapabilities">GetCapabilities()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_notify_dbus_notifications_complete_get_capabilities (
    PhoshNotifyDBusNotifications *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *capabilities)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   capabilities));
}

/**
 * phosh_notify_dbus_notifications_complete_notify:
 * @object: A #PhoshNotifyDBusNotifications.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Notifications.Notify">Notify()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_notify_dbus_notifications_complete_notify (
    PhoshNotifyDBusNotifications *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint id)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   id));
}

/**
 * phosh_notify_dbus_notifications_complete_close_notification:
 * @object: A #PhoshNotifyDBusNotifications.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Notifications.CloseNotification">CloseNotification()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_notify_dbus_notifications_complete_close_notification (
    PhoshNotifyDBusNotifications *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * phosh_notify_dbus_notifications_complete_get_server_information:
 * @object: A #PhoshNotifyDBusNotifications.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @name: Parameter to return.
 * @vendor: Parameter to return.
 * @version: Parameter to return.
 * @spec_version: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-Notifications.GetServerInformation">GetServerInformation()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
phosh_notify_dbus_notifications_complete_get_server_information (
    PhoshNotifyDBusNotifications *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *name,
    const gchar *vendor,
    const gchar *version,
    const gchar *spec_version)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(ssss)",
                   name,
                   vendor,
                   version,
                   spec_version));
}

/* ------------------------------------------------------------------------ */

/**
 * PhoshNotifyDBusNotificationsProxy:
 *
 * The #PhoshNotifyDBusNotificationsProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshNotifyDBusNotificationsProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshNotifyDBusNotificationsProxy.
 */

struct _PhoshNotifyDBusNotificationsProxyPrivate
{
  GData *qdata;
};

static void phosh_notify_dbus_notifications_proxy_iface_init (PhoshNotifyDBusNotificationsIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshNotifyDBusNotificationsProxy, phosh_notify_dbus_notifications_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (PhoshNotifyDBusNotificationsProxy)
                         G_IMPLEMENT_INTERFACE (PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS, phosh_notify_dbus_notifications_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshNotifyDBusNotificationsProxy, phosh_notify_dbus_notifications_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS, phosh_notify_dbus_notifications_proxy_iface_init))

#endif
static void
phosh_notify_dbus_notifications_proxy_finalize (GObject *object)
{
  PhoshNotifyDBusNotificationsProxy *proxy = PHOSH_NOTIFY_DBUS_NOTIFICATIONS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (phosh_notify_dbus_notifications_proxy_parent_class)->finalize (object);
}

static void
phosh_notify_dbus_notifications_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_notify_dbus_notifications_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
phosh_notify_dbus_notifications_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_phosh_notify_dbus_notifications_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
phosh_notify_dbus_notifications_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  PhoshNotifyDBusNotificationsProxy *proxy = PHOSH_NOTIFY_DBUS_NOTIFICATIONS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_notify_dbus_notifications_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_notify_dbus_notifications_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
phosh_notify_dbus_notifications_proxy_init (PhoshNotifyDBusNotificationsProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = phosh_notify_dbus_notifications_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS_PROXY, PhoshNotifyDBusNotificationsProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), phosh_notify_dbus_notifications_interface_info ());
}

static void
phosh_notify_dbus_notifications_proxy_class_init (PhoshNotifyDBusNotificationsProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = phosh_notify_dbus_notifications_proxy_finalize;
  gobject_class->get_property = phosh_notify_dbus_notifications_proxy_get_property;
  gobject_class->set_property = phosh_notify_dbus_notifications_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = phosh_notify_dbus_notifications_proxy_g_signal;
  proxy_class->g_properties_changed = phosh_notify_dbus_notifications_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshNotifyDBusNotificationsProxyPrivate));
#endif
}

static void
phosh_notify_dbus_notifications_proxy_iface_init (PhoshNotifyDBusNotificationsIface *iface G_GNUC_UNUSED)
{
}

/**
 * phosh_notify_dbus_notifications_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Notifications.top_of_page">org.freedesktop.Notifications</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_notify_dbus_notifications_proxy_new_finish() to get the result of the operation.
 *
 * See phosh_notify_dbus_notifications_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_notify_dbus_notifications_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Notifications", NULL);
}

/**
 * phosh_notify_dbus_notifications_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_notify_dbus_notifications_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_notify_dbus_notifications_proxy_new().
 *
 * Returns: (transfer full) (type PhoshNotifyDBusNotificationsProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshNotifyDBusNotifications *
phosh_notify_dbus_notifications_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_NOTIFY_DBUS_NOTIFICATIONS (ret);
  else
    return NULL;
}

/**
 * phosh_notify_dbus_notifications_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Notifications.top_of_page">org.freedesktop.Notifications</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_notify_dbus_notifications_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshNotifyDBusNotificationsProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshNotifyDBusNotifications *
phosh_notify_dbus_notifications_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Notifications", NULL);
  if (ret != NULL)
    return PHOSH_NOTIFY_DBUS_NOTIFICATIONS (ret);
  else
    return NULL;
}


/**
 * phosh_notify_dbus_notifications_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like phosh_notify_dbus_notifications_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call phosh_notify_dbus_notifications_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See phosh_notify_dbus_notifications_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
phosh_notify_dbus_notifications_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Notifications", NULL);
}

/**
 * phosh_notify_dbus_notifications_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to phosh_notify_dbus_notifications_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with phosh_notify_dbus_notifications_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type PhoshNotifyDBusNotificationsProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshNotifyDBusNotifications *
phosh_notify_dbus_notifications_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return PHOSH_NOTIFY_DBUS_NOTIFICATIONS (ret);
  else
    return NULL;
}

/**
 * phosh_notify_dbus_notifications_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like phosh_notify_dbus_notifications_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See phosh_notify_dbus_notifications_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type PhoshNotifyDBusNotificationsProxy): The constructed proxy object or %NULL if @error is set.
 */
PhoshNotifyDBusNotifications *
phosh_notify_dbus_notifications_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.Notifications", NULL);
  if (ret != NULL)
    return PHOSH_NOTIFY_DBUS_NOTIFICATIONS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * PhoshNotifyDBusNotificationsSkeleton:
 *
 * The #PhoshNotifyDBusNotificationsSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * PhoshNotifyDBusNotificationsSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #PhoshNotifyDBusNotificationsSkeleton.
 */

struct _PhoshNotifyDBusNotificationsSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_phosh_notify_dbus_notifications_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  PhoshNotifyDBusNotificationsSkeleton *skeleton = PHOSH_NOTIFY_DBUS_NOTIFICATIONS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_phosh_notify_dbus_notifications_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  PhoshNotifyDBusNotificationsSkeleton *skeleton = PHOSH_NOTIFY_DBUS_NOTIFICATIONS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_notify_dbus_notifications_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_phosh_notify_dbus_notifications_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  PhoshNotifyDBusNotificationsSkeleton *skeleton = PHOSH_NOTIFY_DBUS_NOTIFICATIONS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_phosh_notify_dbus_notifications_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _phosh_notify_dbus_notifications_skeleton_vtable =
{
  _phosh_notify_dbus_notifications_skeleton_handle_method_call,
  _phosh_notify_dbus_notifications_skeleton_handle_get_property,
  _phosh_notify_dbus_notifications_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
phosh_notify_dbus_notifications_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return phosh_notify_dbus_notifications_interface_info ();
}

static GDBusInterfaceVTable *
phosh_notify_dbus_notifications_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_phosh_notify_dbus_notifications_skeleton_vtable;
}

static GVariant *
phosh_notify_dbus_notifications_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  PhoshNotifyDBusNotificationsSkeleton *skeleton = PHOSH_NOTIFY_DBUS_NOTIFICATIONS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_phosh_notify_dbus_notifications_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _phosh_notify_dbus_notifications_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _phosh_notify_dbus_notifications_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _phosh_notify_dbus_notifications_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Notifications", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
phosh_notify_dbus_notifications_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_phosh_notify_dbus_notifications_on_signal_notification_closed (
    PhoshNotifyDBusNotifications *object,
    guint arg_id,
    guint arg_reason)
{
  PhoshNotifyDBusNotificationsSkeleton *skeleton = PHOSH_NOTIFY_DBUS_NOTIFICATIONS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu)",
                   arg_id,
                   arg_reason));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Notifications", "NotificationClosed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_phosh_notify_dbus_notifications_on_signal_action_invoked (
    PhoshNotifyDBusNotifications *object,
    guint arg_id,
    const gchar *arg_action_key)
{
  PhoshNotifyDBusNotificationsSkeleton *skeleton = PHOSH_NOTIFY_DBUS_NOTIFICATIONS_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(us)",
                   arg_id,
                   arg_action_key));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.Notifications", "ActionInvoked",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void phosh_notify_dbus_notifications_skeleton_iface_init (PhoshNotifyDBusNotificationsIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (PhoshNotifyDBusNotificationsSkeleton, phosh_notify_dbus_notifications_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (PhoshNotifyDBusNotificationsSkeleton)
                         G_IMPLEMENT_INTERFACE (PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS, phosh_notify_dbus_notifications_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (PhoshNotifyDBusNotificationsSkeleton, phosh_notify_dbus_notifications_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS, phosh_notify_dbus_notifications_skeleton_iface_init))

#endif
static void
phosh_notify_dbus_notifications_skeleton_finalize (GObject *object)
{
  PhoshNotifyDBusNotificationsSkeleton *skeleton = PHOSH_NOTIFY_DBUS_NOTIFICATIONS_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (phosh_notify_dbus_notifications_skeleton_parent_class)->finalize (object);
}

static void
phosh_notify_dbus_notifications_skeleton_init (PhoshNotifyDBusNotificationsSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = phosh_notify_dbus_notifications_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS_SKELETON, PhoshNotifyDBusNotificationsSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
phosh_notify_dbus_notifications_skeleton_class_init (PhoshNotifyDBusNotificationsSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = phosh_notify_dbus_notifications_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = phosh_notify_dbus_notifications_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = phosh_notify_dbus_notifications_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = phosh_notify_dbus_notifications_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = phosh_notify_dbus_notifications_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (PhoshNotifyDBusNotificationsSkeletonPrivate));
#endif
}

static void
phosh_notify_dbus_notifications_skeleton_iface_init (PhoshNotifyDBusNotificationsIface *iface)
{
  iface->notification_closed = _phosh_notify_dbus_notifications_on_signal_notification_closed;
  iface->action_invoked = _phosh_notify_dbus_notifications_on_signal_action_invoked;
}

/**
 * phosh_notify_dbus_notifications_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-Notifications.top_of_page">org.freedesktop.Notifications</link>.
 *
 * Returns: (transfer full) (type PhoshNotifyDBusNotificationsSkeleton): The skeleton object.
 */
PhoshNotifyDBusNotifications *
phosh_notify_dbus_notifications_skeleton_new (void)
{
  return PHOSH_NOTIFY_DBUS_NOTIFICATIONS (g_object_new (PHOSH_NOTIFY_DBUS_TYPE_NOTIFICATIONS_SKELETON, NULL));
}

