// cc/mojom/paint_flags.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CC_MOJOM_PAINT_FLAGS_MOJOM_SHARED_H_
#define CC_MOJOM_PAINT_FLAGS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "cc/mojom/paint_flags.mojom-shared-internal.h"







namespace cc::mojom {
class DynamicRangeLimitDataView;



}  // cc::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::cc::mojom::DynamicRangeLimitDataView> {
  using Data = ::cc::mojom::internal::DynamicRangeLimit_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace cc::mojom {


enum class FilterQuality : int32_t {
  
  kNone = 0,
  
  kLow = 1,
  
  kMedium = 2,
  
  kHigh = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, FilterQuality value);
inline bool IsKnownEnumValue(FilterQuality value) {
  return internal::FilterQuality_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DynamicRangeLimitDataView {
 public:
  DynamicRangeLimitDataView() = default;

  DynamicRangeLimitDataView(
      internal::DynamicRangeLimit_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  float standard_mix() const {
    return data_->standard_mix;
  }
  float constrained_high_mix() const {
    return data_->constrained_high_mix;
  }
 private:
  internal::DynamicRangeLimit_Data* data_ = nullptr;
};


}  // cc::mojom

namespace std {

template <>
struct hash<::cc::mojom::FilterQuality>
    : public mojo::internal::EnumHashImpl<::cc::mojom::FilterQuality> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cc::mojom::FilterQuality, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::cc::mojom::FilterQuality, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::cc::mojom::FilterQuality>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cc::mojom::DynamicRangeLimitDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cc::mojom::DynamicRangeLimitDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cc::mojom::internal::DynamicRangeLimit_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->standard_mix = Traits::standard_mix(input);
    fragment->constrained_high_mix = Traits::constrained_high_mix(input);
  }

  static bool Deserialize(::cc::mojom::internal::DynamicRangeLimit_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cc::mojom::DynamicRangeLimitDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace cc::mojom {




}  // cc::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::cc::mojom::FilterQuality> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::cc::mojom::FilterQuality value);
};

} // namespace perfetto

#endif  // CC_MOJOM_PAINT_FLAGS_MOJOM_SHARED_H_