// media/mojo/mojom/audio_logging.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/audio_logging.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_logging.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* AudioLogComponentToStringHelper(AudioLogComponent value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AudioLogComponent::kInputController:
      return "kInputController";
    case AudioLogComponent::kOutputController:
      return "kOutputController";
    case AudioLogComponent::kOutputStream:
      return "kOutputStream";
    default:
      return nullptr;
  }
}

std::string AudioLogComponentToString(AudioLogComponent value) {
  const char *str = AudioLogComponentToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AudioLogComponent value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AudioLogComponent value) {
  return os << AudioLogComponentToString(value);
}

namespace internal {


// static
bool AudioLog_OnCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioLog_OnCreated_Params_Data* object =
      static_cast<const AudioLog_OnCreated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& device_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->device_id, validation_context,
                                         &device_id_validate_params)) {
    return false;
  }

  return true;
}

AudioLog_OnCreated_Params_Data::AudioLog_OnCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioLog_OnStarted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioLog_OnStarted_Params_Data* object =
      static_cast<const AudioLog_OnStarted_Params_Data*>(data);

  return true;
}

AudioLog_OnStarted_Params_Data::AudioLog_OnStarted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioLog_OnStopped_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioLog_OnStopped_Params_Data* object =
      static_cast<const AudioLog_OnStopped_Params_Data*>(data);

  return true;
}

AudioLog_OnStopped_Params_Data::AudioLog_OnStopped_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioLog_OnClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioLog_OnClosed_Params_Data* object =
      static_cast<const AudioLog_OnClosed_Params_Data*>(data);

  return true;
}

AudioLog_OnClosed_Params_Data::AudioLog_OnClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioLog_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioLog_OnError_Params_Data* object =
      static_cast<const AudioLog_OnError_Params_Data*>(data);

  return true;
}

AudioLog_OnError_Params_Data::AudioLog_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioLog_OnSetVolume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioLog_OnSetVolume_Params_Data* object =
      static_cast<const AudioLog_OnSetVolume_Params_Data*>(data);

  return true;
}

AudioLog_OnSetVolume_Params_Data::AudioLog_OnSetVolume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioLog_OnProcessingStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioLog_OnProcessingStateChanged_Params_Data* object =
      static_cast<const AudioLog_OnProcessingStateChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

AudioLog_OnProcessingStateChanged_Params_Data::AudioLog_OnProcessingStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioLog_OnLogMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioLog_OnLogMessage_Params_Data* object =
      static_cast<const AudioLog_OnLogMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

AudioLog_OnLogMessage_Params_Data::AudioLog_OnLogMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioLogFactory_CreateAudioLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioLogFactory_CreateAudioLog_Params_Data* object =
      static_cast<const AudioLogFactory_CreateAudioLog_Params_Data*>(data);


  if (!::media::mojom::internal::AudioLogComponent_Data
        ::Validate(object->component, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->audio_log_receiver, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->audio_log_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AudioLogFactory_CreateAudioLog_Params_Data::AudioLogFactory_CreateAudioLog_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::AudioLogComponent>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::AudioLogComponent value) {
  return std::move(context).WriteString(::media::mojom::AudioLogComponentToString(value));
}

} // namespace perfetto