// services/network/public/mojom/cross_origin_embedder_policy.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_EMBEDDER_POLICY_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_EMBEDDER_POLICY_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-blink-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom-blink.h"
#include "services/network/public/mojom/fetch_api.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/network/public/cpp/cross_origin_embedder_policy_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class CrossOriginEmbedderPolicyReporterProxy;

template <typename ImplRefTraits>
class CrossOriginEmbedderPolicyReporterStub;

class CrossOriginEmbedderPolicyReporterRequestValidator;


class BLINK_PLATFORM_EXPORT CrossOriginEmbedderPolicyReporter
    : public CrossOriginEmbedderPolicyReporterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CrossOriginEmbedderPolicyReporterInterfaceBase;
  using Proxy_ = CrossOriginEmbedderPolicyReporterProxy;

  template <typename ImplRefTraits>
  using Stub_ = CrossOriginEmbedderPolicyReporterStub<ImplRefTraits>;

  using RequestValidator_ = CrossOriginEmbedderPolicyReporterRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kQueueCorpViolationReportMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct QueueCorpViolationReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CrossOriginEmbedderPolicyReporter() = default;

  
  virtual void QueueCorpViolationReport(const ::blink::KURL& blocked_url, ::network::mojom::blink::RequestDestination destination, bool report_only) = 0;

  
  virtual void Clone(::mojo::PendingReceiver<CrossOriginEmbedderPolicyReporter> receiver) = 0;
};



class BLINK_PLATFORM_EXPORT CrossOriginEmbedderPolicyReporterProxy
    : public CrossOriginEmbedderPolicyReporter {
 public:
  using InterfaceType = CrossOriginEmbedderPolicyReporter;

  explicit CrossOriginEmbedderPolicyReporterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void QueueCorpViolationReport(const ::blink::KURL& blocked_url, ::network::mojom::blink::RequestDestination destination, bool report_only) final;
  
  void Clone(::mojo::PendingReceiver<CrossOriginEmbedderPolicyReporter> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT CrossOriginEmbedderPolicyReporterStubDispatch {
 public:
  static bool Accept(CrossOriginEmbedderPolicyReporter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CrossOriginEmbedderPolicyReporter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CrossOriginEmbedderPolicyReporter>>
class CrossOriginEmbedderPolicyReporterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CrossOriginEmbedderPolicyReporterStub() = default;
  ~CrossOriginEmbedderPolicyReporterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CrossOriginEmbedderPolicyReporterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CrossOriginEmbedderPolicyReporterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CrossOriginEmbedderPolicyReporterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_PLATFORM_EXPORT CrossOriginEmbedderPolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CrossOriginEmbedderPolicy, T>::value>;
  using DataView = CrossOriginEmbedderPolicyDataView;
  using Data_ = internal::CrossOriginEmbedderPolicy_Data;

  template <typename... Args>
  static CrossOriginEmbedderPolicyPtr New(Args&&... args) {
    return CrossOriginEmbedderPolicyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CrossOriginEmbedderPolicyPtr From(const U& u) {
    return mojo::TypeConverter<CrossOriginEmbedderPolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CrossOriginEmbedderPolicy>::Convert(*this);
  }


  CrossOriginEmbedderPolicy();

  CrossOriginEmbedderPolicy(
      CrossOriginEmbedderPolicyValue value,
      const WTF::String& reporting_endpoint,
      CrossOriginEmbedderPolicyValue report_only_value,
      const WTF::String& report_only_reporting_endpoint);


  ~CrossOriginEmbedderPolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CrossOriginEmbedderPolicyPtr>
  CrossOriginEmbedderPolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CrossOriginEmbedderPolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CrossOriginEmbedderPolicy::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CrossOriginEmbedderPolicy::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CrossOriginEmbedderPolicy::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CrossOriginEmbedderPolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CrossOriginEmbedderPolicy_UnserializedMessageContext<
            UserType, CrossOriginEmbedderPolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CrossOriginEmbedderPolicy::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CrossOriginEmbedderPolicy::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CrossOriginEmbedderPolicy_UnserializedMessageContext<
            UserType, CrossOriginEmbedderPolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CrossOriginEmbedderPolicy::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CrossOriginEmbedderPolicyValue value;
  
  WTF::String reporting_endpoint;
  
  CrossOriginEmbedderPolicyValue report_only_value;
  
  WTF::String report_only_reporting_endpoint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CrossOriginEmbedderPolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CrossOriginEmbedderPolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CrossOriginEmbedderPolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CrossOriginEmbedderPolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
CrossOriginEmbedderPolicyPtr CrossOriginEmbedderPolicy::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(reporting_endpoint),
      mojo::Clone(report_only_value),
      mojo::Clone(report_only_reporting_endpoint)
  );
}

template <typename T, CrossOriginEmbedderPolicy::EnableIfSame<T>*>
bool CrossOriginEmbedderPolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->reporting_endpoint, other_struct.reporting_endpoint))
    return false;
  if (!mojo::Equals(this->report_only_value, other_struct.report_only_value))
    return false;
  if (!mojo::Equals(this->report_only_reporting_endpoint, other_struct.report_only_reporting_endpoint))
    return false;
  return true;
}

template <typename T, CrossOriginEmbedderPolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  if (lhs.reporting_endpoint < rhs.reporting_endpoint)
    return true;
  if (rhs.reporting_endpoint < lhs.reporting_endpoint)
    return false;
  if (lhs.report_only_value < rhs.report_only_value)
    return true;
  if (rhs.report_only_value < lhs.report_only_value)
    return false;
  if (lhs.report_only_reporting_endpoint < rhs.report_only_reporting_endpoint)
    return true;
  if (rhs.report_only_reporting_endpoint < lhs.report_only_reporting_endpoint)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CrossOriginEmbedderPolicy::DataView,
                                         ::network::mojom::blink::CrossOriginEmbedderPolicyPtr> {
  static bool IsNull(const ::network::mojom::blink::CrossOriginEmbedderPolicyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CrossOriginEmbedderPolicyPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::CrossOriginEmbedderPolicy::value) value(
      const ::network::mojom::blink::CrossOriginEmbedderPolicyPtr& input) {
    return input->value;
  }

  static const decltype(::network::mojom::blink::CrossOriginEmbedderPolicy::reporting_endpoint)& reporting_endpoint(
      const ::network::mojom::blink::CrossOriginEmbedderPolicyPtr& input) {
    return input->reporting_endpoint;
  }

  static decltype(::network::mojom::blink::CrossOriginEmbedderPolicy::report_only_value) report_only_value(
      const ::network::mojom::blink::CrossOriginEmbedderPolicyPtr& input) {
    return input->report_only_value;
  }

  static const decltype(::network::mojom::blink::CrossOriginEmbedderPolicy::report_only_reporting_endpoint)& report_only_reporting_endpoint(
      const ::network::mojom::blink::CrossOriginEmbedderPolicyPtr& input) {
    return input->report_only_reporting_endpoint;
  }

  static bool Read(::network::mojom::blink::CrossOriginEmbedderPolicy::DataView input, ::network::mojom::blink::CrossOriginEmbedderPolicyPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_EMBEDDER_POLICY_MOJOM_BLINK_H_