// services/tracing/public/mojom/traced_process.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_TRACING_PUBLIC_MOJOM_TRACED_PROCESS_MOJOM_SHARED_H_
#define SERVICES_TRACING_PUBLIC_MOJOM_TRACED_PROCESS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/tracing/public/mojom/traced_process.mojom-shared-internal.h"
#include "services/tracing/public/mojom/perfetto_service.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace tracing::mojom {
class ConnectToTracingRequestDataView;



}  // tracing::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tracing::mojom::ConnectToTracingRequestDataView> {
  using Data = ::tracing::mojom::internal::ConnectToTracingRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace tracing::mojom {
// Interface base classes. They are used for type safety check.
class TracedProcessInterfaceBase {};

using TracedProcessPtrDataView =
    mojo::InterfacePtrDataView<TracedProcessInterfaceBase>;
using TracedProcessRequestDataView =
    mojo::InterfaceRequestDataView<TracedProcessInterfaceBase>;
using TracedProcessAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TracedProcessInterfaceBase>;
using TracedProcessAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TracedProcessInterfaceBase>;


class ConnectToTracingRequestDataView {
 public:
  ConnectToTracingRequestDataView() = default;

  ConnectToTracingRequestDataView(
      internal::ConnectToTracingRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePerfettoService() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::tracing::mojom::PerfettoServiceInterfaceBase>>(
            &data_->perfetto_service, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ConnectToTracingRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // tracing::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tracing::mojom::ConnectToTracingRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tracing::mojom::ConnectToTracingRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tracing::mojom::internal::ConnectToTracingRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::perfetto_service(input)) in_perfetto_service = Traits::perfetto_service(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::tracing::mojom::PerfettoServiceInterfaceBase>>(
        in_perfetto_service, &fragment->perfetto_service, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->perfetto_service),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid perfetto_service in ConnectToTracingRequest struct");
  }

  static bool Deserialize(::tracing::mojom::internal::ConnectToTracingRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tracing::mojom::ConnectToTracingRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tracing::mojom {




}  // tracing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_TRACING_PUBLIC_MOJOM_TRACED_PROCESS_MOJOM_SHARED_H_