// ui/base/ime/mojom/text_input_state.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_SHARED_INTERNAL_H_
#define UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared-internal.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared-internal.h"
#include "ui/base/ime/mojom/virtual_keyboard_types.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "ui/gfx/range/mojom/range.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace ui::mojom {
namespace internal {
class ImeTextSpanInfo_Data;
class TextInputState_Data;

#pragma pack(push, 1)
class  ImeTextSpanInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::ui::mojom::internal::ImeTextSpan_Data> span;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> bounds;

 private:
  friend class mojo::internal::MessageFragment<ImeTextSpanInfo_Data>;

  ImeTextSpanInfo_Data();
  ~ImeTextSpanInfo_Data() = delete;
};
static_assert(sizeof(ImeTextSpanInfo_Data) == 24,
              "Bad sizeof(ImeTextSpanInfo_Data)");
// Used by ImeTextSpanInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ImeTextSpanInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ImeTextSpanInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ImeTextSpanInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ImeTextSpanInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ImeTextSpanInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  TextInputState_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t node_id;
  int32_t type;
  int32_t mode;
  int32_t action;
  uint32_t flags;
  uint8_t can_compose_inline : 1;
  uint8_t show_ime_if_needed : 1;
  uint8_t always_hide_ime : 1;
  uint8_t reply_to_request : 1;
  uint8_t pad8_[3];
  mojo::internal::Pointer<::mojo_base::mojom::internal::BigString16_Data> value;
  mojo::internal::Pointer<::gfx::mojom::internal::Range_Data> selection;
  mojo::internal::Pointer<::gfx::mojom::internal::Range_Data> composition;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> edit_context_control_bounds;
  mojo::internal::Pointer<::gfx::mojom::internal::Rect_Data> edit_context_selection_bounds;
  int32_t vk_policy;
  int32_t last_vk_visibility_request;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ImeTextSpanInfo_Data>>> ime_text_spans_info;

 private:
  friend class mojo::internal::MessageFragment<TextInputState_Data>;

  TextInputState_Data();
  ~TextInputState_Data() = delete;
};
static_assert(sizeof(TextInputState_Data) == 88,
              "Bad sizeof(TextInputState_Data)");
// Used by TextInputState::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TextInputState_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TextInputState_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TextInputState_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TextInputState_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TextInputState_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // ui::mojom

#endif  // UI_BASE_IME_MOJOM_TEXT_INPUT_STATE_MOJOM_SHARED_INTERNAL_H_