const char metrics_tarantool_event_loop_lua[] =
"local utils = require('metrics.utils')\n"
"local fiber = require('fiber')\n"
"local clock = require('clock')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"local ev_now_64 = function() return 1e3*fiber.time64() end\n"
"\n"
"local function evloop_time()\n"
"\tfiber.sleep(0) -- setups watcher to the start of next ev_run\n"
"\n"
"\tlocal e0, w0 = ev_now_64(), clock.time64()\n"
"\tfiber.sleep(0) -- rotates single loop\n"
"\tlocal e1, w1 = ev_now_64(), clock.time64()\n"
"\n"
"\t-- e0 <= w0 <= e1 <= w1 (if ntp is ok)\n"
"    local ev_loop_time, ev_prolog, ev_epilog\n"
"    if e1 <= w1 then\n"
"        -- lag from the start of the loop till current fiber (must be as little as possible)\n"
"        ev_prolog = w1-e1\n"
"    else\n"
"        ev_prolog = 0\n"
"    end\n"
"    if w0 <= e1 then\n"
"        -- the epilog of previous ev_once\n"
"        ev_epilog = e1-w0\n"
"    else\n"
"        ev_epilog = 0\n"
"    end\n"
"\n"
"    if e0 < e1 then\n"
"        -- diff between 2 neighbour ev_once's\n"
"        ev_loop_time = e1-e0\n"
"    else\n"
"        ev_loop_time = 0\n"
"    end\n"
"\n"
"    -- convert to double to get seconds precision\n"
"\treturn tonumber(ev_loop_time/1e3)/1e3, tonumber(ev_prolog/1e3)/1e3, tonumber(ev_epilog/1e3)/1e3\n"
"end\n"
"\n"
"\n"
"local function update_info_metrics()\n"
"    local ev_once_time, ev_prolog, ev_epilog = evloop_time()\n"
"    collectors_list.ev_loop_time = utils.set_gauge('ev_loop_time', 'Event loop time (ms)',\n"
"        ev_once_time, nil, nil, {default = true})\n"
"    collectors_list.ev_prolog_time = utils.set_gauge('ev_loop_prolog_time', 'Event loop prolog time (ms)',\n"
"        ev_prolog, nil, nil, {default = true})\n"
"    collectors_list.ev_epilog_time = utils.set_gauge('ev_loop_epilog_time', 'Event loop epilog time (ms)',\n"
"        ev_epilog, nil, nil, {default = true})\n"
"end\n"
"\n"
"return {\n"
"    update = update_info_metrics,\n"
"    list = collectors_list,\n"
"}\n"
""
;
