/** @file
 * VirtualBox API class wrapper code for IAudioAdapter.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_AUDIOADAPTER

#include "AudioAdapterWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(AudioAdapterWrap)

//
// IAudioAdapter properties
//

STDMETHODIMP AudioAdapterWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "AudioAdapter::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "AudioAdapter::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "AudioAdapter::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "AudioAdapter::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(EnabledIn)(BOOL *aEnabledIn)
{
    LogRelFlow(("{%p} %s: enter aEnabledIn=%p\n", this, "AudioAdapter::getEnabledIn", aEnabledIn));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabledIn);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLEDIN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabledIn(aEnabledIn);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLEDIN_RETURN(this, hrc, 0 /*normal*/,*aEnabledIn != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLEDIN_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabledIn != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLEDIN_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabledIn != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabledIn=%RTbool hrc=%Rhrc\n", this, "AudioAdapter::getEnabledIn", *aEnabledIn, hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMSETTER(EnabledIn)(BOOL aEnabledIn)
{
    LogRelFlow(("{%p} %s: enter aEnabledIn=%RTbool\n", this, "AudioAdapter::setEnabledIn", aEnabledIn));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLEDIN_ENTER(this, aEnabledIn != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabledIn(aEnabledIn != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLEDIN_RETURN(this, hrc, 0 /*normal*/,aEnabledIn != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLEDIN_RETURN(this, hrc, 1 /*hrc exception*/,aEnabledIn != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLEDIN_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabledIn != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "AudioAdapter::setEnabledIn", hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(EnabledOut)(BOOL *aEnabledOut)
{
    LogRelFlow(("{%p} %s: enter aEnabledOut=%p\n", this, "AudioAdapter::getEnabledOut", aEnabledOut));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabledOut);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLEDOUT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabledOut(aEnabledOut);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLEDOUT_RETURN(this, hrc, 0 /*normal*/,*aEnabledOut != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLEDOUT_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabledOut != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_ENABLEDOUT_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabledOut != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabledOut=%RTbool hrc=%Rhrc\n", this, "AudioAdapter::getEnabledOut", *aEnabledOut, hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMSETTER(EnabledOut)(BOOL aEnabledOut)
{
    LogRelFlow(("{%p} %s: enter aEnabledOut=%RTbool\n", this, "AudioAdapter::setEnabledOut", aEnabledOut));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLEDOUT_ENTER(this, aEnabledOut != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabledOut(aEnabledOut != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLEDOUT_RETURN(this, hrc, 0 /*normal*/,aEnabledOut != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLEDOUT_RETURN(this, hrc, 1 /*hrc exception*/,aEnabledOut != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_ENABLEDOUT_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabledOut != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "AudioAdapter::setEnabledOut", hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(AudioController)(AudioControllerType_T *aAudioController)
{
    LogRelFlow(("{%p} %s: enter aAudioController=%p\n", this, "AudioAdapter::getAudioController", aAudioController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAudioController);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIOCONTROLLER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAudioController(aAudioController);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIOCONTROLLER_RETURN(this, hrc, 0 /*normal*/,*aAudioController);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIOCONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/,*aAudioController);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIOCONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/,*aAudioController);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAudioController=%RU32 hrc=%Rhrc\n", this, "AudioAdapter::getAudioController", *aAudioController, hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMSETTER(AudioController)(AudioControllerType_T aAudioController)
{
    LogRelFlow(("{%p} %s: enter aAudioController=%RU32\n", this, "AudioAdapter::setAudioController", aAudioController));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIOCONTROLLER_ENTER(this, aAudioController);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAudioController(aAudioController);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIOCONTROLLER_RETURN(this, hrc, 0 /*normal*/,aAudioController);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIOCONTROLLER_RETURN(this, hrc, 1 /*hrc exception*/,aAudioController);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIOCONTROLLER_RETURN(this, hrc, 9 /*unhandled exception*/,aAudioController);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "AudioAdapter::setAudioController", hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(AudioCodec)(AudioCodecType_T *aAudioCodec)
{
    LogRelFlow(("{%p} %s: enter aAudioCodec=%p\n", this, "AudioAdapter::getAudioCodec", aAudioCodec));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAudioCodec);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIOCODEC_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAudioCodec(aAudioCodec);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIOCODEC_RETURN(this, hrc, 0 /*normal*/,*aAudioCodec);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIOCODEC_RETURN(this, hrc, 1 /*hrc exception*/,*aAudioCodec);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIOCODEC_RETURN(this, hrc, 9 /*unhandled exception*/,*aAudioCodec);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAudioCodec=%RU32 hrc=%Rhrc\n", this, "AudioAdapter::getAudioCodec", *aAudioCodec, hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMSETTER(AudioCodec)(AudioCodecType_T aAudioCodec)
{
    LogRelFlow(("{%p} %s: enter aAudioCodec=%RU32\n", this, "AudioAdapter::setAudioCodec", aAudioCodec));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIOCODEC_ENTER(this, aAudioCodec);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAudioCodec(aAudioCodec);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIOCODEC_RETURN(this, hrc, 0 /*normal*/,aAudioCodec);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIOCODEC_RETURN(this, hrc, 1 /*hrc exception*/,aAudioCodec);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIOCODEC_RETURN(this, hrc, 9 /*unhandled exception*/,aAudioCodec);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "AudioAdapter::setAudioCodec", hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(AudioDriver)(AudioDriverType_T *aAudioDriver)
{
    LogRelFlow(("{%p} %s: enter aAudioDriver=%p\n", this, "AudioAdapter::getAudioDriver", aAudioDriver));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAudioDriver);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIODRIVER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAudioDriver(aAudioDriver);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIODRIVER_RETURN(this, hrc, 0 /*normal*/,*aAudioDriver);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIODRIVER_RETURN(this, hrc, 1 /*hrc exception*/,*aAudioDriver);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_AUDIODRIVER_RETURN(this, hrc, 9 /*unhandled exception*/,*aAudioDriver);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAudioDriver=%RU32 hrc=%Rhrc\n", this, "AudioAdapter::getAudioDriver", *aAudioDriver, hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMSETTER(AudioDriver)(AudioDriverType_T aAudioDriver)
{
    LogRelFlow(("{%p} %s: enter aAudioDriver=%RU32\n", this, "AudioAdapter::setAudioDriver", aAudioDriver));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIODRIVER_ENTER(this, aAudioDriver);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAudioDriver(aAudioDriver);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIODRIVER_RETURN(this, hrc, 0 /*normal*/,aAudioDriver);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIODRIVER_RETURN(this, hrc, 1 /*hrc exception*/,aAudioDriver);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SET_AUDIODRIVER_RETURN(this, hrc, 9 /*unhandled exception*/,aAudioDriver);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "AudioAdapter::setAudioDriver", hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(PropertiesList)(ComSafeArrayOut(BSTR, aPropertiesList))
{
    LogRelFlow(("{%p} %s: enter aPropertiesList=%p\n", this, "AudioAdapter::getPropertiesList", aPropertiesList));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPropertiesList);
        ArrayBSTROutConverter TmpPropertiesList(ComSafeArrayOutArg(aPropertiesList));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_PROPERTIESLIST_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPropertiesList(TmpPropertiesList.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_PROPERTIESLIST_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpPropertiesList.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_PROPERTIESLIST_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GET_PROPERTIESLIST_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPropertiesList=%zu hrc=%Rhrc\n", this, "AudioAdapter::getPropertiesList", ComSafeArraySize(*aPropertiesList), hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(InternalAndReservedAttribute1IAudioAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(InternalAndReservedAttribute2IAudioAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(InternalAndReservedAttribute3IAudioAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(InternalAndReservedAttribute4IAudioAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(InternalAndReservedAttribute5IAudioAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(InternalAndReservedAttribute6IAudioAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(InternalAndReservedAttribute7IAudioAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP AudioAdapterWrap::COMGETTER(InternalAndReservedAttribute8IAudioAdapter)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IAudioAdapter methods
//

STDMETHODIMP AudioAdapterWrap::SetProperty(IN_BSTR aKey,
                                           IN_BSTR aValue)
{
    LogRelFlow(("{%p} %s: enter aKey=%ls aValue=%ls\n", this, "AudioAdapter::setProperty", aKey, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpKey(aKey);
        BSTRInConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SETPROPERTY_ENTER(this, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setProperty(TmpKey.str(),
                              TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SETPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SETPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_SETPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "AudioAdapter::setProperty", hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::GetProperty(IN_BSTR aKey,
                                           BSTR *aValue)
{
    LogRelFlow(("{%p} %s: enter aKey=%ls aValue=%p\n", this, "AudioAdapter::getProperty", aKey, aValue));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValue);


        BSTRInConverter TmpKey(aKey);
        BSTROutConverter TmpValue(aValue);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GETPROPERTY_ENTER(this, TmpKey.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProperty(TmpKey.str(),
                              TmpValue.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GETPROPERTY_RETURN(this, hrc, 0 /*normal*/, TmpKey.str().c_str(), TmpValue.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GETPROPERTY_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_AUDIOADAPTER_GETPROPERTY_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aValue=%ls hrc=%Rhrc\n", this, "AudioAdapter::getProperty", *aValue, hrc));
    return hrc;
}

STDMETHODIMP AudioAdapterWrap::InternalAndReservedMethod1IAudioAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP AudioAdapterWrap::InternalAndReservedMethod2IAudioAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP AudioAdapterWrap::InternalAndReservedMethod3IAudioAdapter()
{
    return E_NOTIMPL;
}

STDMETHODIMP AudioAdapterWrap::InternalAndReservedMethod4IAudioAdapter()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(AudioAdapterWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(AudioAdapterWrap, IAudioAdapter)
#endif // VBOX_WITH_XPCOM
