/** @file
 * VirtualBox API class wrapper code for IHost.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_HOST

#include "HostWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(HostWrap)

//
// IHost properties
//

STDMETHODIMP HostWrap::COMGETTER(Architecture)(PlatformArchitecture_T *aArchitecture)
{
    LogRelFlow(("{%p} %s: enter aArchitecture=%p\n", this, "Host::getArchitecture", aArchitecture));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aArchitecture);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_ARCHITECTURE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getArchitecture(aArchitecture);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_ARCHITECTURE_RETURN(this, hrc, 0 /*normal*/,*aArchitecture);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_ARCHITECTURE_RETURN(this, hrc, 1 /*hrc exception*/,*aArchitecture);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_ARCHITECTURE_RETURN(this, hrc, 9 /*unhandled exception*/,*aArchitecture);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aArchitecture=%RU32 hrc=%Rhrc\n", this, "Host::getArchitecture", *aArchitecture, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(X86)(IHostX86 **aX86)
{
    LogRelFlow(("{%p} %s: enter aX86=%p\n", this, "Host::getX86", aX86));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aX86);
        ComTypeOutConverter<IHostX86> TmpX86(aX86);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_X86_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getX86(TmpX86.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_X86_RETURN(this, hrc, 0 /*normal*/,(void *)TmpX86.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_X86_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_X86_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aX86=%p hrc=%Rhrc\n", this, "Host::getX86", *aX86, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(DVDDrives)(ComSafeArrayOut(IMedium *, aDVDDrives))
{
    LogRelFlow(("{%p} %s: enter aDVDDrives=%p\n", this, "Host::getDVDDrives", aDVDDrives));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDVDDrives);
        ArrayComTypeOutConverter<IMedium> TmpDVDDrives(ComSafeArrayOutArg(aDVDDrives));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_DVDDRIVES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDVDDrives(TmpDVDDrives.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_DVDDRIVES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpDVDDrives.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_DVDDRIVES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_DVDDRIVES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDVDDrives=%zu hrc=%Rhrc\n", this, "Host::getDVDDrives", ComSafeArraySize(*aDVDDrives), hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(FloppyDrives)(ComSafeArrayOut(IMedium *, aFloppyDrives))
{
    LogRelFlow(("{%p} %s: enter aFloppyDrives=%p\n", this, "Host::getFloppyDrives", aFloppyDrives));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFloppyDrives);
        ArrayComTypeOutConverter<IMedium> TmpFloppyDrives(ComSafeArrayOutArg(aFloppyDrives));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_FLOPPYDRIVES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFloppyDrives(TmpFloppyDrives.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_FLOPPYDRIVES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpFloppyDrives.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_FLOPPYDRIVES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_FLOPPYDRIVES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFloppyDrives=%zu hrc=%Rhrc\n", this, "Host::getFloppyDrives", ComSafeArraySize(*aFloppyDrives), hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(AudioDevices)(ComSafeArrayOut(IHostAudioDevice *, aAudioDevices))
{
    LogRelFlow(("{%p} %s: enter aAudioDevices=%p\n", this, "Host::getAudioDevices", aAudioDevices));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAudioDevices);
        ArrayComTypeOutConverter<IHostAudioDevice> TmpAudioDevices(ComSafeArrayOutArg(aAudioDevices));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_AUDIODEVICES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAudioDevices(TmpAudioDevices.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_AUDIODEVICES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpAudioDevices.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_AUDIODEVICES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_AUDIODEVICES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAudioDevices=%zu hrc=%Rhrc\n", this, "Host::getAudioDevices", ComSafeArraySize(*aAudioDevices), hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(USBDevices)(ComSafeArrayOut(IHostUSBDevice *, aUSBDevices))
{
    LogRelFlow(("{%p} %s: enter aUSBDevices=%p\n", this, "Host::getUSBDevices", aUSBDevices));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUSBDevices);
        ArrayComTypeOutConverter<IHostUSBDevice> TmpUSBDevices(ComSafeArrayOutArg(aUSBDevices));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_USBDEVICES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUSBDevices(TmpUSBDevices.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_USBDEVICES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpUSBDevices.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_USBDEVICES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_USBDEVICES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUSBDevices=%zu hrc=%Rhrc\n", this, "Host::getUSBDevices", ComSafeArraySize(*aUSBDevices), hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(USBDeviceFilters)(ComSafeArrayOut(IHostUSBDeviceFilter *, aUSBDeviceFilters))
{
    LogRelFlow(("{%p} %s: enter aUSBDeviceFilters=%p\n", this, "Host::getUSBDeviceFilters", aUSBDeviceFilters));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUSBDeviceFilters);
        ArrayComTypeOutConverter<IHostUSBDeviceFilter> TmpUSBDeviceFilters(ComSafeArrayOutArg(aUSBDeviceFilters));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_USBDEVICEFILTERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUSBDeviceFilters(TmpUSBDeviceFilters.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_USBDEVICEFILTERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpUSBDeviceFilters.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_USBDEVICEFILTERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_USBDEVICEFILTERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUSBDeviceFilters=%zu hrc=%Rhrc\n", this, "Host::getUSBDeviceFilters", ComSafeArraySize(*aUSBDeviceFilters), hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(NetworkInterfaces)(ComSafeArrayOut(IHostNetworkInterface *, aNetworkInterfaces))
{
    LogRelFlow(("{%p} %s: enter aNetworkInterfaces=%p\n", this, "Host::getNetworkInterfaces", aNetworkInterfaces));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkInterfaces);
        ArrayComTypeOutConverter<IHostNetworkInterface> TmpNetworkInterfaces(ComSafeArrayOutArg(aNetworkInterfaces));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_NETWORKINTERFACES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetworkInterfaces(TmpNetworkInterfaces.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_NETWORKINTERFACES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpNetworkInterfaces.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_NETWORKINTERFACES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_NETWORKINTERFACES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNetworkInterfaces=%zu hrc=%Rhrc\n", this, "Host::getNetworkInterfaces", ComSafeArraySize(*aNetworkInterfaces), hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(NameServers)(ComSafeArrayOut(BSTR, aNameServers))
{
    LogRelFlow(("{%p} %s: enter aNameServers=%p\n", this, "Host::getNameServers", aNameServers));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNameServers);
        ArrayBSTROutConverter TmpNameServers(ComSafeArrayOutArg(aNameServers));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_NAMESERVERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNameServers(TmpNameServers.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_NAMESERVERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpNameServers.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_NAMESERVERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_NAMESERVERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNameServers=%zu hrc=%Rhrc\n", this, "Host::getNameServers", ComSafeArraySize(*aNameServers), hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(DomainName)(BSTR *aDomainName)
{
    LogRelFlow(("{%p} %s: enter aDomainName=%p\n", this, "Host::getDomainName", aDomainName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDomainName);
        BSTROutConverter TmpDomainName(aDomainName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_DOMAINNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDomainName(TmpDomainName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_DOMAINNAME_RETURN(this, hrc, 0 /*normal*/,TmpDomainName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_DOMAINNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_DOMAINNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDomainName=%ls hrc=%Rhrc\n", this, "Host::getDomainName", *aDomainName, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(SearchStrings)(ComSafeArrayOut(BSTR, aSearchStrings))
{
    LogRelFlow(("{%p} %s: enter aSearchStrings=%p\n", this, "Host::getSearchStrings", aSearchStrings));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSearchStrings);
        ArrayBSTROutConverter TmpSearchStrings(ComSafeArrayOutArg(aSearchStrings));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_SEARCHSTRINGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSearchStrings(TmpSearchStrings.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_SEARCHSTRINGS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSearchStrings.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_SEARCHSTRINGS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_SEARCHSTRINGS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSearchStrings=%zu hrc=%Rhrc\n", this, "Host::getSearchStrings", ComSafeArraySize(*aSearchStrings), hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(ProcessorCount)(ULONG *aProcessorCount)
{
    LogRelFlow(("{%p} %s: enter aProcessorCount=%p\n", this, "Host::getProcessorCount", aProcessorCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProcessorCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProcessorCount(aProcessorCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORCOUNT_RETURN(this, hrc, 0 /*normal*/,*aProcessorCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aProcessorCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aProcessorCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProcessorCount=%RU32 hrc=%Rhrc\n", this, "Host::getProcessorCount", *aProcessorCount, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(ProcessorOnlineCount)(ULONG *aProcessorOnlineCount)
{
    LogRelFlow(("{%p} %s: enter aProcessorOnlineCount=%p\n", this, "Host::getProcessorOnlineCount", aProcessorOnlineCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProcessorOnlineCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORONLINECOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProcessorOnlineCount(aProcessorOnlineCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORONLINECOUNT_RETURN(this, hrc, 0 /*normal*/,*aProcessorOnlineCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORONLINECOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aProcessorOnlineCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORONLINECOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aProcessorOnlineCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProcessorOnlineCount=%RU32 hrc=%Rhrc\n", this, "Host::getProcessorOnlineCount", *aProcessorOnlineCount, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(ProcessorCoreCount)(ULONG *aProcessorCoreCount)
{
    LogRelFlow(("{%p} %s: enter aProcessorCoreCount=%p\n", this, "Host::getProcessorCoreCount", aProcessorCoreCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProcessorCoreCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORCORECOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProcessorCoreCount(aProcessorCoreCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORCORECOUNT_RETURN(this, hrc, 0 /*normal*/,*aProcessorCoreCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORCORECOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aProcessorCoreCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORCORECOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aProcessorCoreCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProcessorCoreCount=%RU32 hrc=%Rhrc\n", this, "Host::getProcessorCoreCount", *aProcessorCoreCount, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(ProcessorOnlineCoreCount)(ULONG *aProcessorOnlineCoreCount)
{
    LogRelFlow(("{%p} %s: enter aProcessorOnlineCoreCount=%p\n", this, "Host::getProcessorOnlineCoreCount", aProcessorOnlineCoreCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProcessorOnlineCoreCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORONLINECORECOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProcessorOnlineCoreCount(aProcessorOnlineCoreCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORONLINECORECOUNT_RETURN(this, hrc, 0 /*normal*/,*aProcessorOnlineCoreCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORONLINECORECOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aProcessorOnlineCoreCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_PROCESSORONLINECORECOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aProcessorOnlineCoreCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aProcessorOnlineCoreCount=%RU32 hrc=%Rhrc\n", this, "Host::getProcessorOnlineCoreCount", *aProcessorOnlineCoreCount, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(HostDrives)(ComSafeArrayOut(IHostDrive *, aHostDrives))
{
    LogRelFlow(("{%p} %s: enter aHostDrives=%p\n", this, "Host::getHostDrives", aHostDrives));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHostDrives);
        ArrayComTypeOutConverter<IHostDrive> TmpHostDrives(ComSafeArrayOutArg(aHostDrives));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_HOSTDRIVES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHostDrives(TmpHostDrives.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_HOSTDRIVES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpHostDrives.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_HOSTDRIVES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_HOSTDRIVES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHostDrives=%zu hrc=%Rhrc\n", this, "Host::getHostDrives", ComSafeArraySize(*aHostDrives), hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(MemorySize)(ULONG *aMemorySize)
{
    LogRelFlow(("{%p} %s: enter aMemorySize=%p\n", this, "Host::getMemorySize", aMemorySize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMemorySize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_MEMORYSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMemorySize(aMemorySize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_MEMORYSIZE_RETURN(this, hrc, 0 /*normal*/,*aMemorySize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_MEMORYSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aMemorySize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_MEMORYSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aMemorySize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMemorySize=%RU32 hrc=%Rhrc\n", this, "Host::getMemorySize", *aMemorySize, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(MemoryAvailable)(ULONG *aMemoryAvailable)
{
    LogRelFlow(("{%p} %s: enter aMemoryAvailable=%p\n", this, "Host::getMemoryAvailable", aMemoryAvailable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMemoryAvailable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_MEMORYAVAILABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMemoryAvailable(aMemoryAvailable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_MEMORYAVAILABLE_RETURN(this, hrc, 0 /*normal*/,*aMemoryAvailable);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_MEMORYAVAILABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aMemoryAvailable);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_MEMORYAVAILABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aMemoryAvailable);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMemoryAvailable=%RU32 hrc=%Rhrc\n", this, "Host::getMemoryAvailable", *aMemoryAvailable, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(OperatingSystem)(BSTR *aOperatingSystem)
{
    LogRelFlow(("{%p} %s: enter aOperatingSystem=%p\n", this, "Host::getOperatingSystem", aOperatingSystem));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOperatingSystem);
        BSTROutConverter TmpOperatingSystem(aOperatingSystem);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_OPERATINGSYSTEM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOperatingSystem(TmpOperatingSystem.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_OPERATINGSYSTEM_RETURN(this, hrc, 0 /*normal*/,TmpOperatingSystem.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_OPERATINGSYSTEM_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_OPERATINGSYSTEM_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOperatingSystem=%ls hrc=%Rhrc\n", this, "Host::getOperatingSystem", *aOperatingSystem, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(OSVersion)(BSTR *aOSVersion)
{
    LogRelFlow(("{%p} %s: enter aOSVersion=%p\n", this, "Host::getOSVersion", aOSVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOSVersion);
        BSTROutConverter TmpOSVersion(aOSVersion);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_OSVERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOSVersion(TmpOSVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_OSVERSION_RETURN(this, hrc, 0 /*normal*/,TmpOSVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_OSVERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_OSVERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOSVersion=%ls hrc=%Rhrc\n", this, "Host::getOSVersion", *aOSVersion, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(UTCTime)(LONG64 *aUTCTime)
{
    LogRelFlow(("{%p} %s: enter aUTCTime=%p\n", this, "Host::getUTCTime", aUTCTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUTCTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UTCTIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUTCTime(aUTCTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UTCTIME_RETURN(this, hrc, 0 /*normal*/,*aUTCTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UTCTIME_RETURN(this, hrc, 1 /*hrc exception*/,*aUTCTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UTCTIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aUTCTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUTCTime=%RI64 hrc=%Rhrc\n", this, "Host::getUTCTime", *aUTCTime, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(VideoInputDevices)(ComSafeArrayOut(IHostVideoInputDevice *, aVideoInputDevices))
{
    LogRelFlow(("{%p} %s: enter aVideoInputDevices=%p\n", this, "Host::getVideoInputDevices", aVideoInputDevices));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVideoInputDevices);
        ArrayComTypeOutConverter<IHostVideoInputDevice> TmpVideoInputDevices(ComSafeArrayOutArg(aVideoInputDevices));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_VIDEOINPUTDEVICES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVideoInputDevices(TmpVideoInputDevices.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_VIDEOINPUTDEVICES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpVideoInputDevices.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_VIDEOINPUTDEVICES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_VIDEOINPUTDEVICES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVideoInputDevices=%zu hrc=%Rhrc\n", this, "Host::getVideoInputDevices", ComSafeArraySize(*aVideoInputDevices), hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(UpdateHost)(IUpdateAgent **aUpdateHost)
{
    LogRelFlow(("{%p} %s: enter aUpdateHost=%p\n", this, "Host::getUpdateHost", aUpdateHost));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUpdateHost);
        ComTypeOutConverter<IUpdateAgent> TmpUpdateHost(aUpdateHost);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEHOST_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUpdateHost(TmpUpdateHost.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEHOST_RETURN(this, hrc, 0 /*normal*/,(void *)TmpUpdateHost.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEHOST_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEHOST_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUpdateHost=%p hrc=%Rhrc\n", this, "Host::getUpdateHost", *aUpdateHost, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(UpdateExtPack)(IUpdateAgent **aUpdateExtPack)
{
    LogRelFlow(("{%p} %s: enter aUpdateExtPack=%p\n", this, "Host::getUpdateExtPack", aUpdateExtPack));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUpdateExtPack);
        ComTypeOutConverter<IUpdateAgent> TmpUpdateExtPack(aUpdateExtPack);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEEXTPACK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUpdateExtPack(TmpUpdateExtPack.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEEXTPACK_RETURN(this, hrc, 0 /*normal*/,(void *)TmpUpdateExtPack.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEEXTPACK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEEXTPACK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUpdateExtPack=%p hrc=%Rhrc\n", this, "Host::getUpdateExtPack", *aUpdateExtPack, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(UpdateGuestAdditions)(IUpdateAgent **aUpdateGuestAdditions)
{
    LogRelFlow(("{%p} %s: enter aUpdateGuestAdditions=%p\n", this, "Host::getUpdateGuestAdditions", aUpdateGuestAdditions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUpdateGuestAdditions);
        ComTypeOutConverter<IUpdateAgent> TmpUpdateGuestAdditions(aUpdateGuestAdditions);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEGUESTADDITIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUpdateGuestAdditions(TmpUpdateGuestAdditions.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEGUESTADDITIONS_RETURN(this, hrc, 0 /*normal*/,(void *)TmpUpdateGuestAdditions.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEGUESTADDITIONS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GET_UPDATEGUESTADDITIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUpdateGuestAdditions=%p hrc=%Rhrc\n", this, "Host::getUpdateGuestAdditions", *aUpdateGuestAdditions, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute1IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute2IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute3IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute4IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute5IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute6IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute7IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute8IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute9IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute10IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute11IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::COMGETTER(InternalAndReservedAttribute12IHost)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IHost methods
//

STDMETHODIMP HostWrap::GetProcessorSpeed(ULONG aCpuId,
                                         ULONG *aSpeed)
{
    LogRelFlow(("{%p} %s: enter aCpuId=%RU32 aSpeed=%p\n", this, "Host::getProcessorSpeed", aCpuId, aSpeed));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSpeed);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORSPEED_ENTER(this, aCpuId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProcessorSpeed(aCpuId,
                                    aSpeed);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORSPEED_RETURN(this, hrc, 0 /*normal*/, aCpuId, *aSpeed);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORSPEED_RETURN(this, hrc, 1 /*hrc exception*/, aCpuId, *aSpeed);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORSPEED_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuId, *aSpeed);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSpeed=%RU32 hrc=%Rhrc\n", this, "Host::getProcessorSpeed", *aSpeed, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::GetProcessorFeature(ProcessorFeature_T aFeature,
                                           BOOL *aSupported)
{
    LogRelFlow(("{%p} %s: enter aFeature=%RU32 aSupported=%p\n", this, "Host::getProcessorFeature", aFeature, aSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupported);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORFEATURE_ENTER(this, aFeature);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProcessorFeature(aFeature,
                                      aSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORFEATURE_RETURN(this, hrc, 0 /*normal*/, aFeature, *aSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORFEATURE_RETURN(this, hrc, 1 /*hrc exception*/, aFeature, *aSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORFEATURE_RETURN(this, hrc, 9 /*unhandled exception*/, aFeature, *aSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSupported=%RTbool hrc=%Rhrc\n", this, "Host::getProcessorFeature", *aSupported, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::GetProcessorDescription(ULONG aCpuId,
                                               BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aCpuId=%RU32 aDescription=%p\n", this, "Host::getProcessorDescription", aCpuId, aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);


        
        BSTROutConverter TmpDescription(aDescription);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORDESCRIPTION_ENTER(this, aCpuId);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getProcessorDescription(aCpuId,
                                          TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORDESCRIPTION_RETURN(this, hrc, 0 /*normal*/, aCpuId, TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORDESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/, aCpuId, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GETPROCESSORDESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuId, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDescription=%ls hrc=%Rhrc\n", this, "Host::getProcessorDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::CreateHostOnlyNetworkInterface(IHostNetworkInterface **aHostInterface,
                                                      IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aHostInterface=%p aProgress=%p\n", this, "Host::createHostOnlyNetworkInterface", aHostInterface, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHostInterface);
        CheckComArgOutPointerValidThrow(aProgress);


        ComTypeOutConverter<IHostNetworkInterface> TmpHostInterface(aHostInterface);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_CREATEHOSTONLYNETWORKINTERFACE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createHostOnlyNetworkInterface(TmpHostInterface.ptr(),
                                                 TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_CREATEHOSTONLYNETWORKINTERFACE_RETURN(this, hrc, 0 /*normal*/, (void *)TmpHostInterface.ptr(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_CREATEHOSTONLYNETWORKINTERFACE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_CREATEHOSTONLYNETWORKINTERFACE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHostInterface=%p aProgress=%p hrc=%Rhrc\n", this, "Host::createHostOnlyNetworkInterface", *aHostInterface, *aProgress, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::RemoveHostOnlyNetworkInterface(IN_BSTR aId,
                                                      IProgress **aProgress)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aProgress=%p\n", this, "Host::removeHostOnlyNetworkInterface", aId, aProgress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aProgress);


        UuidInConverter TmpId(aId);
        ComTypeOutConverter<IProgress> TmpProgress(aProgress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEHOSTONLYNETWORKINTERFACE_ENTER(this, TmpId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeHostOnlyNetworkInterface(TmpId.uuid(),
                                                 TmpProgress.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEHOSTONLYNETWORKINTERFACE_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), (void *)TmpProgress.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEHOSTONLYNETWORKINTERFACE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEHOSTONLYNETWORKINTERFACE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aProgress=%p hrc=%Rhrc\n", this, "Host::removeHostOnlyNetworkInterface", *aProgress, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::CreateUSBDeviceFilter(IN_BSTR aName,
                                             IHostUSBDeviceFilter **aFilter)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aFilter=%p\n", this, "Host::createUSBDeviceFilter", aName, aFilter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFilter);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IHostUSBDeviceFilter> TmpFilter(aFilter);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_CREATEUSBDEVICEFILTER_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createUSBDeviceFilter(TmpName.str(),
                                        TmpFilter.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_CREATEUSBDEVICEFILTER_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpFilter.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_CREATEUSBDEVICEFILTER_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_CREATEUSBDEVICEFILTER_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aFilter=%p hrc=%Rhrc\n", this, "Host::createUSBDeviceFilter", *aFilter, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::InsertUSBDeviceFilter(ULONG aPosition,
                                             IHostUSBDeviceFilter *aFilter)
{
    LogRelFlow(("{%p} %s: enter aPosition=%RU32 aFilter=%p\n", this, "Host::insertUSBDeviceFilter", aPosition, aFilter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        ComTypeInConverter<IHostUSBDeviceFilter> TmpFilter(aFilter);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_INSERTUSBDEVICEFILTER_ENTER(this, aPosition, (void *)TmpFilter.ptr());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = insertUSBDeviceFilter(aPosition,
                                        TmpFilter.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_INSERTUSBDEVICEFILTER_RETURN(this, hrc, 0 /*normal*/, aPosition, (void *)TmpFilter.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_INSERTUSBDEVICEFILTER_RETURN(this, hrc, 1 /*hrc exception*/, aPosition, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_INSERTUSBDEVICEFILTER_RETURN(this, hrc, 9 /*unhandled exception*/, aPosition, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Host::insertUSBDeviceFilter", hrc));
    return hrc;
}

STDMETHODIMP HostWrap::RemoveUSBDeviceFilter(ULONG aPosition)
{
    LogRelFlow(("{%p} %s: enter aPosition=%RU32\n", this, "Host::removeUSBDeviceFilter", aPosition));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEUSBDEVICEFILTER_ENTER(this, aPosition);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeUSBDeviceFilter(aPosition);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEUSBDEVICEFILTER_RETURN(this, hrc, 0 /*normal*/, aPosition);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEUSBDEVICEFILTER_RETURN(this, hrc, 1 /*hrc exception*/, aPosition);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEUSBDEVICEFILTER_RETURN(this, hrc, 9 /*unhandled exception*/, aPosition);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Host::removeUSBDeviceFilter", hrc));
    return hrc;
}

STDMETHODIMP HostWrap::FindHostDVDDrive(IN_BSTR aName,
                                        IMedium **aDrive)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aDrive=%p\n", this, "Host::findHostDVDDrive", aName, aDrive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDrive);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IMedium> TmpDrive(aDrive);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTDVDDRIVE_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findHostDVDDrive(TmpName.str(),
                                   TmpDrive.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTDVDDRIVE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpDrive.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTDVDDRIVE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTDVDDRIVE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDrive=%p hrc=%Rhrc\n", this, "Host::findHostDVDDrive", *aDrive, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::FindHostFloppyDrive(IN_BSTR aName,
                                           IMedium **aDrive)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aDrive=%p\n", this, "Host::findHostFloppyDrive", aName, aDrive));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDrive);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IMedium> TmpDrive(aDrive);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTFLOPPYDRIVE_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findHostFloppyDrive(TmpName.str(),
                                      TmpDrive.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTFLOPPYDRIVE_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpDrive.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTFLOPPYDRIVE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTFLOPPYDRIVE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDrive=%p hrc=%Rhrc\n", this, "Host::findHostFloppyDrive", *aDrive, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::FindHostNetworkInterfaceByName(IN_BSTR aName,
                                                      IHostNetworkInterface **aNetworkInterface)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aNetworkInterface=%p\n", this, "Host::findHostNetworkInterfaceByName", aName, aNetworkInterface));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkInterface);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IHostNetworkInterface> TmpNetworkInterface(aNetworkInterface);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACEBYNAME_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findHostNetworkInterfaceByName(TmpName.str(),
                                                 TmpNetworkInterface.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACEBYNAME_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpNetworkInterface.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACEBYNAME_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACEBYNAME_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNetworkInterface=%p hrc=%Rhrc\n", this, "Host::findHostNetworkInterfaceByName", *aNetworkInterface, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::FindHostNetworkInterfaceById(IN_BSTR aId,
                                                    IHostNetworkInterface **aNetworkInterface)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aNetworkInterface=%p\n", this, "Host::findHostNetworkInterfaceById", aId, aNetworkInterface));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkInterface);


        UuidInConverter TmpId(aId);
        ComTypeOutConverter<IHostNetworkInterface> TmpNetworkInterface(aNetworkInterface);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACEBYID_ENTER(this, TmpId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findHostNetworkInterfaceById(TmpId.uuid(),
                                               TmpNetworkInterface.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACEBYID_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), (void *)TmpNetworkInterface.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACEBYID_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACEBYID_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNetworkInterface=%p hrc=%Rhrc\n", this, "Host::findHostNetworkInterfaceById", *aNetworkInterface, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::FindHostNetworkInterfacesOfType(HostNetworkInterfaceType_T aType,
                                                       ComSafeArrayOut(IHostNetworkInterface *, aNetworkInterfaces))
{
    LogRelFlow(("{%p} %s: enter aType=%RU32 aNetworkInterfaces=%p\n", this, "Host::findHostNetworkInterfacesOfType", aType, aNetworkInterfaces));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetworkInterfaces);


        
        ArrayComTypeOutConverter<IHostNetworkInterface> TmpNetworkInterfaces(ComSafeArrayOutArg(aNetworkInterfaces));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACESOFTYPE_ENTER(this, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findHostNetworkInterfacesOfType(aType,
                                                  TmpNetworkInterfaces.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACESOFTYPE_RETURN(this, hrc, 0 /*normal*/, aType, (uint32_t)TmpNetworkInterfaces.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACESOFTYPE_RETURN(this, hrc, 1 /*hrc exception*/, aType, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDHOSTNETWORKINTERFACESOFTYPE_RETURN(this, hrc, 9 /*unhandled exception*/, aType, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNetworkInterfaces=%zu hrc=%Rhrc\n", this, "Host::findHostNetworkInterfacesOfType", ComSafeArraySize(*aNetworkInterfaces), hrc));
    return hrc;
}

STDMETHODIMP HostWrap::FindUSBDeviceById(IN_BSTR aId,
                                         IHostUSBDevice **aDevice)
{
    LogRelFlow(("{%p} %s: enter aId=%ls aDevice=%p\n", this, "Host::findUSBDeviceById", aId, aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDevice);


        UuidInConverter TmpId(aId);
        ComTypeOutConverter<IHostUSBDevice> TmpDevice(aDevice);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDUSBDEVICEBYID_ENTER(this, TmpId.uuid().toStringCurly().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findUSBDeviceById(TmpId.uuid(),
                                    TmpDevice.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDUSBDEVICEBYID_RETURN(this, hrc, 0 /*normal*/, TmpId.uuid().toStringCurly().c_str(), (void *)TmpDevice.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDUSBDEVICEBYID_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDUSBDEVICEBYID_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDevice=%p hrc=%Rhrc\n", this, "Host::findUSBDeviceById", *aDevice, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::FindUSBDeviceByAddress(IN_BSTR aName,
                                              IHostUSBDevice **aDevice)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aDevice=%p\n", this, "Host::findUSBDeviceByAddress", aName, aDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDevice);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IHostUSBDevice> TmpDevice(aDevice);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDUSBDEVICEBYADDRESS_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = findUSBDeviceByAddress(TmpName.str(),
                                         TmpDevice.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDUSBDEVICEBYADDRESS_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpDevice.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDUSBDEVICEBYADDRESS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_FINDUSBDEVICEBYADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDevice=%p hrc=%Rhrc\n", this, "Host::findUSBDeviceByAddress", *aDevice, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::GenerateMACAddress(BSTR *aAddress)
{
    LogRelFlow(("{%p} %s: enter aAddress=%p\n", this, "Host::generateMACAddress", aAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAddress);


        BSTROutConverter TmpAddress(aAddress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GENERATEMACADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = generateMACAddress(TmpAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GENERATEMACADDRESS_RETURN(this, hrc, 0 /*normal*/, TmpAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GENERATEMACADDRESS_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_GENERATEMACADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aAddress=%ls hrc=%Rhrc\n", this, "Host::generateMACAddress", *aAddress, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::AddUSBDeviceSource(IN_BSTR aBackend,
                                          IN_BSTR aId,
                                          IN_BSTR aAddress,
                                          ComSafeArrayIn(IN_BSTR, aPropertyNames),
                                          ComSafeArrayIn(IN_BSTR, aPropertyValues))
{
    LogRelFlow(("{%p} %s: enter aBackend=%ls aId=%ls aAddress=%ls aPropertyNames=%zu aPropertyValues=%zu\n", this, "Host::addUSBDeviceSource", aBackend, aId, aAddress, aPropertyNames, aPropertyValues));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpBackend(aBackend);
        BSTRInConverter TmpId(aId);
        BSTRInConverter TmpAddress(aAddress);
        ArrayBSTRInConverter TmpPropertyNames(ComSafeArrayInArg(aPropertyNames));
        ArrayBSTRInConverter TmpPropertyValues(ComSafeArrayInArg(aPropertyValues));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_ADDUSBDEVICESOURCE_ENTER(this, TmpBackend.str().c_str(), TmpId.str().c_str(), TmpAddress.str().c_str(), (uint32_t)TmpPropertyNames.array().size(), NULL /*for now*/, (uint32_t)TmpPropertyValues.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addUSBDeviceSource(TmpBackend.str(),
                                     TmpId.str(),
                                     TmpAddress.str(),
                                     TmpPropertyNames.array(),
                                     TmpPropertyValues.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_ADDUSBDEVICESOURCE_RETURN(this, hrc, 0 /*normal*/, TmpBackend.str().c_str(), TmpId.str().c_str(), TmpAddress.str().c_str(), (uint32_t)TmpPropertyNames.array().size(), NULL /*for now*/, (uint32_t)TmpPropertyValues.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_ADDUSBDEVICESOURCE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_ADDUSBDEVICESOURCE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Host::addUSBDeviceSource", hrc));
    return hrc;
}

STDMETHODIMP HostWrap::RemoveUSBDeviceSource(IN_BSTR aId)
{
    LogRelFlow(("{%p} %s: enter aId=%ls\n", this, "Host::removeUSBDeviceSource", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpId(aId);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEUSBDEVICESOURCE_ENTER(this, TmpId.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeUSBDeviceSource(TmpId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEUSBDEVICESOURCE_RETURN(this, hrc, 0 /*normal*/, TmpId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEUSBDEVICESOURCE_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_REMOVEUSBDEVICESOURCE_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "Host::removeUSBDeviceSource", hrc));
    return hrc;
}

STDMETHODIMP HostWrap::IsExecutionEngineSupported(CPUArchitecture_T aCpuArchitecture,
                                                  VMExecutionEngine_T aExecutionEngine,
                                                  BOOL *aIsSupported)
{
    LogRelFlow(("{%p} %s: enter aCpuArchitecture=%RU32 aExecutionEngine=%RU32 aIsSupported=%p\n", this, "Host::isExecutionEngineSupported", aCpuArchitecture, aExecutionEngine, aIsSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIsSupported);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_ISEXECUTIONENGINESUPPORTED_ENTER(this, aCpuArchitecture, aExecutionEngine);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = isExecutionEngineSupported(aCpuArchitecture,
                                             aExecutionEngine,
                                             aIsSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_ISEXECUTIONENGINESUPPORTED_RETURN(this, hrc, 0 /*normal*/, aCpuArchitecture, aExecutionEngine, *aIsSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_ISEXECUTIONENGINESUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/, aCpuArchitecture, aExecutionEngine, *aIsSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_HOST_ISEXECUTIONENGINESUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/, aCpuArchitecture, aExecutionEngine, *aIsSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aIsSupported=%RTbool hrc=%Rhrc\n", this, "Host::isExecutionEngineSupported", *aIsSupported, hrc));
    return hrc;
}

STDMETHODIMP HostWrap::InternalAndReservedMethod1IHost()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::InternalAndReservedMethod2IHost()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::InternalAndReservedMethod3IHost()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::InternalAndReservedMethod4IHost()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::InternalAndReservedMethod5IHost()
{
    return E_NOTIMPL;
}

STDMETHODIMP HostWrap::InternalAndReservedMethod6IHost()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(HostWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(HostWrap, IHost)
#endif // VBOX_WITH_XPCOM
