﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/Action.h>
#include <aws/glue/model/EventBatchingCondition.h>
#include <aws/glue/model/Predicate.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {

/**
 * <p>A structure used to provide information used to update a trigger. This object
 * updates the previous trigger definition by overwriting it
 * completely.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/TriggerUpdate">AWS
 * API Reference</a></p>
 */
class TriggerUpdate {
 public:
  AWS_GLUE_API TriggerUpdate() = default;
  AWS_GLUE_API TriggerUpdate(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API TriggerUpdate& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GLUE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Reserved for future use.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  TriggerUpdate& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of this trigger.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  TriggerUpdate& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A <code>cron</code> expression used to specify the schedule (see <a
   * href="https://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html">Time-Based
   * Schedules for Jobs and Crawlers</a>. For example, to run something every day at
   * 12:15 UTC, you would specify: <code>cron(15 12 * * ? *)</code>.</p>
   */
  inline const Aws::String& GetSchedule() const { return m_schedule; }
  inline bool ScheduleHasBeenSet() const { return m_scheduleHasBeenSet; }
  template <typename ScheduleT = Aws::String>
  void SetSchedule(ScheduleT&& value) {
    m_scheduleHasBeenSet = true;
    m_schedule = std::forward<ScheduleT>(value);
  }
  template <typename ScheduleT = Aws::String>
  TriggerUpdate& WithSchedule(ScheduleT&& value) {
    SetSchedule(std::forward<ScheduleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The actions initiated by this trigger.</p>
   */
  inline const Aws::Vector<Action>& GetActions() const { return m_actions; }
  inline bool ActionsHasBeenSet() const { return m_actionsHasBeenSet; }
  template <typename ActionsT = Aws::Vector<Action>>
  void SetActions(ActionsT&& value) {
    m_actionsHasBeenSet = true;
    m_actions = std::forward<ActionsT>(value);
  }
  template <typename ActionsT = Aws::Vector<Action>>
  TriggerUpdate& WithActions(ActionsT&& value) {
    SetActions(std::forward<ActionsT>(value));
    return *this;
  }
  template <typename ActionsT = Action>
  TriggerUpdate& AddActions(ActionsT&& value) {
    m_actionsHasBeenSet = true;
    m_actions.emplace_back(std::forward<ActionsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The predicate of this trigger, which defines when it will fire.</p>
   */
  inline const Predicate& GetPredicate() const { return m_predicate; }
  inline bool PredicateHasBeenSet() const { return m_predicateHasBeenSet; }
  template <typename PredicateT = Predicate>
  void SetPredicate(PredicateT&& value) {
    m_predicateHasBeenSet = true;
    m_predicate = std::forward<PredicateT>(value);
  }
  template <typename PredicateT = Predicate>
  TriggerUpdate& WithPredicate(PredicateT&& value) {
    SetPredicate(std::forward<PredicateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Batch condition that must be met (specified number of events received or
   * batch time window expired) before EventBridge event trigger fires.</p>
   */
  inline const EventBatchingCondition& GetEventBatchingCondition() const { return m_eventBatchingCondition; }
  inline bool EventBatchingConditionHasBeenSet() const { return m_eventBatchingConditionHasBeenSet; }
  template <typename EventBatchingConditionT = EventBatchingCondition>
  void SetEventBatchingCondition(EventBatchingConditionT&& value) {
    m_eventBatchingConditionHasBeenSet = true;
    m_eventBatchingCondition = std::forward<EventBatchingConditionT>(value);
  }
  template <typename EventBatchingConditionT = EventBatchingCondition>
  TriggerUpdate& WithEventBatchingCondition(EventBatchingConditionT&& value) {
    SetEventBatchingCondition(std::forward<EventBatchingConditionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  Aws::String m_description;

  Aws::String m_schedule;

  Aws::Vector<Action> m_actions;

  Predicate m_predicate;

  EventBatchingCondition m_eventBatchingCondition;
  bool m_nameHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_scheduleHasBeenSet = false;
  bool m_actionsHasBeenSet = false;
  bool m_predicateHasBeenSet = false;
  bool m_eventBatchingConditionHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
