/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.view;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.exec.DBCMessageException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.resultset.AbstractPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetCopySettings;
import org.jkiss.dbeaver.ui.controls.resultset.view.ErrorDetailsPart;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ErrorPresentation
extends AbstractPresentation {
    private static final String SETTINGS_SECTION_ERROR_PANEL = ErrorPresentation.class.getSimpleName();
    private static final String PROP_ERROR_WIDTH = "errorWidth";
    private static final boolean REMEBER_SASH_RATIO = false;
    private final String sqlText;
    private final IStatus status;
    private final IResultSetContainer resultSetContainer;
    private StyledText textWidget;
    private Object editorPanel;

    public ErrorPresentation(String sqlText, IStatus status, @NotNull IResultSetContainer resultSetContainer) {
        this.sqlText = sqlText;
        this.status = status;
        this.resultSetContainer = resultSetContainer;
    }

    @Override
    public void createPresentation(@NotNull IResultSetController controller, @NotNull Composite parent) {
        super.createPresentation(controller, parent);
        Throwable exception = this.status.getException();
        DBCMessageException messageException = (DBCMessageException)GeneralUtils.findNestedException((Throwable)exception, DBCMessageException.class);
        if (messageException != null) {
            this.createMessagePanel(controller, parent, messageException);
        } else {
            this.createErrorPanel(controller, parent);
        }
        ErrorPresentation.enableHostEditingFor(controller, parent);
    }

    private static void enableHostEditingFor(@NotNull IResultSetController controller, @NotNull Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Text || child instanceof StyledText) {
                TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)controller.getSite(), (Control)child);
            } else if (child instanceof Composite) {
                Composite composite = (Composite)child;
                ErrorPresentation.enableHostEditingFor(controller, composite);
            }
            ++n2;
        }
    }

    private void createErrorPanel(@NotNull IResultSetController controller, @NotNull Composite parent) {
        CustomSashForm partDivider = UIUtils.createPartDivider((IWorkbenchPart)controller.getSite().getPart(), (Composite)parent, (int)256);
        partDivider.setLayoutData((Object)new GridData(1808));
        Composite errorComposite = UIUtils.createComposite((Composite)partDivider, (int)1);
        errorComposite.setLayoutData((Object)new GridData(1808));
        new ErrorDetailsPart(errorComposite, this.status, this.resultSetContainer);
        Composite sqlPanel = UIUtils.createComposite((Composite)partDivider, (int)1);
        sqlPanel.setLayout((Layout)new FillLayout());
        UIServiceSQL serviceSQL = (UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class);
        if (serviceSQL != null) {
            try {
                this.editorPanel = serviceSQL.createSQLPanel((Object)controller.getSite(), (Object)sqlPanel, (DBPContextProvider)controller, "SQL", true, this.sqlText);
                if (this.editorPanel instanceof TextViewer) {
                    this.textWidget = ((TextViewer)this.editorPanel).getTextWidget();
                }
            }
            catch (DBException dBException) {
                this.textWidget = new StyledText(sqlPanel, 2056);
                this.textWidget.setText(this.sqlText);
            }
        }
    }

    private void createMessagePanel(@NotNull IResultSetController controller, @NotNull Composite parent, @NotNull DBCMessageException messageException) {
        Composite msgComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        msgComposite.setLayout((Layout)layout);
        msgComposite.setLayoutData((Object)new GridData(1808));
        Label imageLabel = new Label(msgComposite, 0);
        imageLabel.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_INFO));
        imageLabel.setLayoutData((Object)new GridData(66));
        this.textWidget = new StyledText(msgComposite, 2122);
        this.textWidget.setMargins(5, 5, 5, 5);
        this.textWidget.setText(CommonUtils.toString((Object)messageException.getMessage(), (String)"N/A"));
        this.textWidget.setLayoutData((Object)new GridData(1808));
    }

    @Override
    public Control getControl() {
        return this.textWidget;
    }

    @Override
    public void refreshData(boolean refreshMetadata, boolean append, boolean keepState) {
    }

    @Override
    public void formatData(boolean refreshData) {
    }

    @Override
    public void clearMetaData() {
    }

    @Override
    public void updateValueView() {
    }

    @Override
    public void changeMode(boolean recordMode) {
    }

    @Override
    @Nullable
    public DBDAttributeBinding getCurrentAttribute() {
        return null;
    }

    @Override
    @NotNull
    public Map<Transfer, Object> copySelection(ResultSetCopySettings settings) {
        return Collections.singletonMap(TextTransfer.getInstance(), CommonUtils.notEmpty((String)this.status.getMessage()));
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

