/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the minimum and the maximum intensity values of an image.


It is templated over input image type only.

This filter is automatically multi-threaded and can stream its input
when NumberOfStreamDivisions is set to more than
The extrema are independently computed for each streamed and threaded
region then merged.

See:
 StatisticsImageFilter

 itk::MinimumMaximumImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkMinimumMaximumImageFilter.h
*/
public class MinimumMaximumImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected MinimumMaximumImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.MinimumMaximumImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MinimumMaximumImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MinimumMaximumImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::MinimumMaximumImageFilter::~MinimumMaximumImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_MinimumMaximumImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::MinimumMaximumImageFilter::MinimumMaximumImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  MinimumMaximumImageFilter() {
    this(SimpleITKJNI.new_MinimumMaximumImageFilter(), true);
  }

  /**
double itk::simple::MinimumMaximumImageFilter::GetMinimum() const

Return the computed Minimum.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getMinimum() {
    return SimpleITKJNI.MinimumMaximumImageFilter_getMinimum(swigCPtr, this);
  }

  /**
double itk::simple::MinimumMaximumImageFilter::GetMaximum() const

Return the computed Maximum.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getMaximum() {
    return SimpleITKJNI.MinimumMaximumImageFilter_getMaximum(swigCPtr, this);
  }

  /**
std::string itk::simple::MinimumMaximumImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.MinimumMaximumImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::MinimumMaximumImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.MinimumMaximumImageFilter_toString(swigCPtr, this);
  }

  /**
void itk::simple::MinimumMaximumImageFilter::Execute(const Image &amp;image)

Execute the filter on the input image

*/
public  void execute(Image image) {
    SimpleITKJNI.MinimumMaximumImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image);
  }

}
