Clazz.declarePackage("J.adapter.readers.xml");
Clazz.load(["J.adapter.readers.xml.XmlReader"], "J.adapter.readers.xml.XmlArgusReader", ["J.adapter.smarter.Atom"], function(){
var c$ = Clazz.decorateAsClass(function(){
this.atomName1 = null;
this.atomName2 = null;
this.bondOrder = 0;
this.elementContext = 0;
this.trans = null;
this.ptTrans = 0;
Clazz.instantialize(this, arguments);}, J.adapter.readers.xml, "XmlArgusReader", J.adapter.readers.xml.XmlReader);
Clazz.makeConstructor(c$, 
function(){
Clazz.superConstructor (this, J.adapter.readers.xml.XmlArgusReader, []);
});
Clazz.overrideMethod(c$, "processStartElement", 
function(localName, nodeName){
for (var i = J.adapter.readers.xml.XmlArgusReader.keepCharsList.length; --i >= 0; ) if (J.adapter.readers.xml.XmlArgusReader.keepCharsList[i].equals(localName)) {
this.setKeepChars(true);
break;
}
if ("molecule".equals(localName)) {
this.asc.newAtomSet();
return;
}if ("atom".equals(localName)) {
this.elementContext = 2;
this.thisAtom =  new J.adapter.smarter.Atom();
return;
}if ("bond".equals(localName)) {
this.elementContext = 3;
this.atomName1 = null;
this.atomName2 = null;
this.bondOrder = this.parseBondToken(this.atts.get("order"));
return;
}if ("transformmat".equals(localName)) {
this.elementContext = 4;
this.trans =  Clazz.newFloatArray (16, 0);
return;
}}, "~S,~S");
Clazz.defineMethod(c$, "parseBondToken", 
function(str){
var floatOrder = this.parseFloatStr(str);
if (Float.isNaN(floatOrder) && str.length >= 1) {
str = str.toUpperCase();
switch ((str.charAt(0)).charCodeAt(0)) {
case 83:
return 1;
case 68:
return 2;
case 84:
return 3;
case 65:
return 515;
}
return this.parseIntStr(str);
}if (floatOrder == 1.5) return 515;
if (floatOrder == 2) return 2;
if (floatOrder == 3) return 3;
return 1;
}, "~S");
Clazz.overrideMethod(c$, "processEndElement", 
function(localName){
var n = this.chars.length();
if (n > 0 && this.chars.charAt(n - 1) == '\n') this.chars.setLength(n - 1);
if ("molecule".equals(localName)) {
this.elementContext = 0;
return;
}if ("atom".equals(localName)) {
if (this.thisAtom.elementSymbol != null && !Float.isNaN(this.thisAtom.z)) {
this.parent.setAtomCoord(this.thisAtom);
this.asc.addAtomWithMappedName(this.thisAtom);
}this.thisAtom = null;
this.elementContext = 0;
return;
}if ("bond".equals(localName)) {
if (this.atomName2 != null) this.asc.addNewBondFromNames(this.atomName1, this.atomName2, this.bondOrder);
this.elementContext = 0;
return;
}if ("transformmat".equals(localName)) {
this.elementContext = 0;
this.parent.setTransform(this.trans[0], this.trans[1], this.trans[2], this.trans[4], this.trans[5], this.trans[6], this.trans[8], this.trans[9], this.trans[10]);
return;
}if (this.elementContext == 1) {
if ("name".equals(localName)) {
this.asc.setAtomSetName(this.chars.toString());
this.setKeepChars(false);
}return;
}if (this.thisAtom != null && this.elementContext == 2) {
if ("x".equals(localName)) {
this.thisAtom.x = this.parseFloatStr(this.chars.toString());
} else if ("y".equals(localName)) {
this.thisAtom.y = this.parseFloatStr(this.chars.toString());
return;
} else if ("z".equals(localName)) {
this.thisAtom.z = this.parseFloatStr(this.chars.toString());
return;
} else if ("atsym".equals(localName)) {
this.thisAtom.elementSymbol = this.chars.toString();
return;
} else if ("formalchg".equals(localName)) {
this.thisAtom.formalCharge = this.parseIntStr(this.chars.toString());
} else if ("atomkey".equals(localName)) {
this.thisAtom.atomName = this.chars.toString();
}this.setKeepChars(false);
return;
}if (this.elementContext == 3) {
if ("atomkey".equals(localName)) {
if (this.atomName1 == null) this.atomName1 = this.chars.toString();
 else this.atomName2 = this.chars.toString();
this.setKeepChars(false);
}return;
}if (this.elementContext == 4) {
this.trans[this.ptTrans++] = this.parseFloatStr(this.chars.toString());
this.setKeepChars(false);
return;
}}, "~S");
c$.keepCharsList =  Clazz.newArray(-1, ["name", "x", "y", "z", "formalchg", "atomkey", "atsym", "e00", "e01", "e02", "e03", "e10", "e11", "e12", "e13", "e20", "e21", "e22", "e23", "e30", "e31", "e32", "e33"]);
});
;//5.0.1-v7 Tue Jan 27 20:35:35 CST 2026
