/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ShareGroupHeartbeatRequestData
implements ApiMessage {
    String groupId;
    String memberId;
    int memberEpoch;
    String rackId;
    List<String> subscribedTopicNames;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_1 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group identifier."), new Field("member_id", Type.COMPACT_STRING, "The member id generated by the consumer. The member id must be kept during the entire lifetime of the consumer process."), new Field("member_epoch", Type.INT32, "The current member epoch; 0 to join the group; -1 to leave the group."), new Field("rack_id", Type.COMPACT_NULLABLE_STRING, "null if not provided or if it didn't change since the last heartbeat; the rack ID of consumer otherwise."), new Field("subscribed_topic_names", CompactArrayOf.nullable(Type.COMPACT_STRING), "null if it didn't change since the last heartbeat; the subscribed topic names otherwise."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 1;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public ShareGroupHeartbeatRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ShareGroupHeartbeatRequestData() {
        this.groupId = "";
        this.memberId = "";
        this.memberEpoch = 0;
        this.rackId = null;
        this.subscribedTopicNames = null;
    }

    @Override
    public short apiKey() {
        return 76;
    }

    @Override
    public short lowestSupportedVersion() {
        return 1;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field memberId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field memberId had invalid length " + length);
        }
        this.memberId = _readable.readString(length);
        this.memberEpoch = _readable.readInt();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.rackId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field rackId had invalid length " + length);
            }
            this.rackId = _readable.readString(length);
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            this.subscribedTopicNames = null;
        } else {
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<String> newCollection = new ArrayList<String>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                int length2 = _readable.readUnsignedVarint() - 1;
                if (length2 < 0) {
                    throw new RuntimeException("non-nullable field subscribedTopicNames element was serialized as null");
                }
                if (length2 > Short.MAX_VALUE) {
                    throw new RuntimeException("string field subscribedTopicNames element had invalid length " + length2);
                }
                newCollection.add(_readable.readString(length2));
            }
            this.subscribedTopicNames = newCollection;
        }
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue(this.groupId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _stringBytes = _cache.getSerializedValue(this.memberId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.memberEpoch);
        if (this.rackId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.rackId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.subscribedTopicNames == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _writable.writeUnsignedVarint(this.subscribedTopicNames.size() + 1);
            _stringBytes = this.subscribedTopicNames.iterator();
            while (_stringBytes.hasNext()) {
                String subscribedTopicNamesElement = (String)_stringBytes.next();
                byte[] _stringBytes2 = _cache.getSerializedValue(subscribedTopicNamesElement);
                _writable.writeUnsignedVarint(_stringBytes2.length + 1);
                _writable.writeByteArray(_stringBytes2);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'memberId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.memberId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        _size.addBytes(4);
        if (this.rackId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.rackId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'rackId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.rackId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.subscribedTopicNames == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.subscribedTopicNames.size() + 1));
            for (String subscribedTopicNamesElement : this.subscribedTopicNames) {
                byte[] _stringBytes2 = subscribedTopicNamesElement.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes2.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'subscribedTopicNamesElement' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(subscribedTopicNamesElement, _stringBytes2);
                _size.addBytes(_stringBytes2.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes2.length + 1));
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShareGroupHeartbeatRequestData)) {
            return false;
        }
        ShareGroupHeartbeatRequestData other = (ShareGroupHeartbeatRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.memberEpoch != other.memberEpoch) {
            return false;
        }
        if (this.rackId == null ? other.rackId != null : !this.rackId.equals(other.rackId)) {
            return false;
        }
        if (this.subscribedTopicNames == null ? other.subscribedTopicNames != null : !this.subscribedTopicNames.equals(other.subscribedTopicNames)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + this.memberEpoch;
        hashCode = 31 * hashCode + (this.rackId == null ? 0 : this.rackId.hashCode());
        hashCode = 31 * hashCode + (this.subscribedTopicNames == null ? 0 : this.subscribedTopicNames.hashCode());
        return hashCode;
    }

    @Override
    public ShareGroupHeartbeatRequestData duplicate() {
        ShareGroupHeartbeatRequestData _duplicate = new ShareGroupHeartbeatRequestData();
        _duplicate.groupId = this.groupId;
        _duplicate.memberId = this.memberId;
        _duplicate.memberEpoch = this.memberEpoch;
        _duplicate.rackId = this.rackId == null ? null : this.rackId;
        if (this.subscribedTopicNames == null) {
            _duplicate.subscribedTopicNames = null;
        } else {
            ArrayList<String> newSubscribedTopicNames = new ArrayList<String>(this.subscribedTopicNames.size());
            for (String _element : this.subscribedTopicNames) {
                newSubscribedTopicNames.add(_element);
            }
            _duplicate.subscribedTopicNames = newSubscribedTopicNames;
        }
        return _duplicate;
    }

    public String toString() {
        return "ShareGroupHeartbeatRequestData(groupId=" + (String)(this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", memberId=" + (String)(this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", memberEpoch=" + this.memberEpoch + ", rackId=" + (String)(this.rackId == null ? "null" : "'" + this.rackId.toString() + "'") + ", subscribedTopicNames=" + (this.subscribedTopicNames == null ? "null" : MessageUtil.deepToString(this.subscribedTopicNames.iterator())) + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public String memberId() {
        return this.memberId;
    }

    public int memberEpoch() {
        return this.memberEpoch;
    }

    public String rackId() {
        return this.rackId;
    }

    public List<String> subscribedTopicNames() {
        return this.subscribedTopicNames;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ShareGroupHeartbeatRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public ShareGroupHeartbeatRequestData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public ShareGroupHeartbeatRequestData setMemberEpoch(int v) {
        this.memberEpoch = v;
        return this;
    }

    public ShareGroupHeartbeatRequestData setRackId(String v) {
        this.rackId = v;
        return this;
    }

    public ShareGroupHeartbeatRequestData setSubscribedTopicNames(List<String> v) {
        this.subscribedTopicNames = v;
        return this;
    }
}

