/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.hibernate.internal.util.StringHelper;

public final class SimpleTypeInterpretation
extends Enum<SimpleTypeInterpretation> {
    public static final /* enum */ SimpleTypeInterpretation BOOLEAN = new SimpleTypeInterpretation(Boolean.class);
    public static final /* enum */ SimpleTypeInterpretation BYTE = new SimpleTypeInterpretation(Byte.class);
    public static final /* enum */ SimpleTypeInterpretation SHORT = new SimpleTypeInterpretation(Short.class);
    public static final /* enum */ SimpleTypeInterpretation INTEGER = new SimpleTypeInterpretation(Integer.class);
    public static final /* enum */ SimpleTypeInterpretation LONG = new SimpleTypeInterpretation(Long.class);
    public static final /* enum */ SimpleTypeInterpretation DOUBLE = new SimpleTypeInterpretation(Double.class);
    public static final /* enum */ SimpleTypeInterpretation FLOAT = new SimpleTypeInterpretation(Float.class);
    public static final /* enum */ SimpleTypeInterpretation BIG_INTEGER = new SimpleTypeInterpretation(BigInteger.class);
    public static final /* enum */ SimpleTypeInterpretation BIG_DECIMAL = new SimpleTypeInterpretation(BigDecimal.class);
    public static final /* enum */ SimpleTypeInterpretation CHARACTER = new SimpleTypeInterpretation(Character.class);
    public static final /* enum */ SimpleTypeInterpretation STRING = new SimpleTypeInterpretation(String.class);
    public static final /* enum */ SimpleTypeInterpretation INSTANT = new SimpleTypeInterpretation(Instant.class);
    public static final /* enum */ SimpleTypeInterpretation DURATION = new SimpleTypeInterpretation(Duration.class);
    public static final /* enum */ SimpleTypeInterpretation YEAR = new SimpleTypeInterpretation(Year.class);
    public static final /* enum */ SimpleTypeInterpretation LOCAL_DATE_TIME = new SimpleTypeInterpretation(LocalDateTime.class);
    public static final /* enum */ SimpleTypeInterpretation LOCAL_DATE = new SimpleTypeInterpretation(LocalDate.class);
    public static final /* enum */ SimpleTypeInterpretation LOCAL_TIME = new SimpleTypeInterpretation(LocalTime.class);
    public static final /* enum */ SimpleTypeInterpretation OFFSET_DATE_TIME = new SimpleTypeInterpretation(OffsetDateTime.class);
    public static final /* enum */ SimpleTypeInterpretation OFFSET_TIME = new SimpleTypeInterpretation(OffsetTime.class);
    public static final /* enum */ SimpleTypeInterpretation ZONED_DATE_TIME = new SimpleTypeInterpretation(ZonedDateTime.class);
    public static final /* enum */ SimpleTypeInterpretation ZONE_ID = new SimpleTypeInterpretation(ZoneId.class);
    public static final /* enum */ SimpleTypeInterpretation ZONE_OFFSET = new SimpleTypeInterpretation(ZoneOffset.class);
    public static final /* enum */ SimpleTypeInterpretation UUID = new SimpleTypeInterpretation(UUID.class);
    public static final /* enum */ SimpleTypeInterpretation URL = new SimpleTypeInterpretation(URL.class);
    public static final /* enum */ SimpleTypeInterpretation INET_ADDRESS = new SimpleTypeInterpretation(InetAddress.class);
    public static final /* enum */ SimpleTypeInterpretation CURRENCY = new SimpleTypeInterpretation(Currency.class);
    public static final /* enum */ SimpleTypeInterpretation LOCALE = new SimpleTypeInterpretation(Locale.class);
    public static final /* enum */ SimpleTypeInterpretation CLASS = new SimpleTypeInterpretation(Class.class);
    public static final /* enum */ SimpleTypeInterpretation BLOB = new SimpleTypeInterpretation(Blob.class);
    public static final /* enum */ SimpleTypeInterpretation CLOB = new SimpleTypeInterpretation(Clob.class);
    public static final /* enum */ SimpleTypeInterpretation NCLOB = new SimpleTypeInterpretation(NClob.class);
    public static final /* enum */ SimpleTypeInterpretation JDBC_TIMESTAMP = new SimpleTypeInterpretation(Timestamp.class);
    public static final /* enum */ SimpleTypeInterpretation JDBC_DATE = new SimpleTypeInterpretation(Date.class);
    public static final /* enum */ SimpleTypeInterpretation JDBC_TIME = new SimpleTypeInterpretation(Time.class);
    public static final /* enum */ SimpleTypeInterpretation CALENDAR = new SimpleTypeInterpretation(Calendar.class);
    public static final /* enum */ SimpleTypeInterpretation TIME_ZONE = new SimpleTypeInterpretation(TimeZone.class);
    public static final /* enum */ SimpleTypeInterpretation SERIALIZABLE = new SimpleTypeInterpretation(Serializable.class);
    public static final /* enum */ SimpleTypeInterpretation PRIMITIVE_BOOLEAN = new SimpleTypeInterpretation(Boolean.TYPE, BOOLEAN);
    public static final /* enum */ SimpleTypeInterpretation PRIMITIVE_BYTE = new SimpleTypeInterpretation(Byte.TYPE, BYTE);
    public static final /* enum */ SimpleTypeInterpretation PRIMITIVE_SHORT = new SimpleTypeInterpretation(Short.TYPE, SHORT);
    public static final /* enum */ SimpleTypeInterpretation PRIMITIVE_INTEGER = new SimpleTypeInterpretation(Integer.TYPE, INTEGER);
    public static final /* enum */ SimpleTypeInterpretation PRIMITIVE_LONG = new SimpleTypeInterpretation(Long.TYPE, LONG);
    public static final /* enum */ SimpleTypeInterpretation PRIMITIVE_DOUBLE = new SimpleTypeInterpretation(Double.TYPE, DOUBLE);
    public static final /* enum */ SimpleTypeInterpretation PRIMITIVE_FLOAT = new SimpleTypeInterpretation(Float.TYPE, FLOAT);
    public static final /* enum */ SimpleTypeInterpretation PRIMITIVE_CHARACTER = new SimpleTypeInterpretation(Character.TYPE, CHARACTER);
    private final Class<?> javaType;
    private final SimpleTypeInterpretation objectForm;
    private static final /* synthetic */ SimpleTypeInterpretation[] $VALUES;

    public static SimpleTypeInterpretation[] values() {
        return (SimpleTypeInterpretation[])$VALUES.clone();
    }

    public static SimpleTypeInterpretation valueOf(String name) {
        return Enum.valueOf(SimpleTypeInterpretation.class, name);
    }

    private SimpleTypeInterpretation(Class<?> javaType) {
        this.javaType = javaType;
        this.objectForm = this;
    }

    private SimpleTypeInterpretation(Class<?> javaType, SimpleTypeInterpretation objectForm) {
        this.javaType = javaType;
        this.objectForm = objectForm;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public SimpleTypeInterpretation getObjectForm() {
        return this.objectForm;
    }

    public static SimpleTypeInterpretation interpret(String name) {
        assert (StringHelper.isNotEmpty(name));
        if (Boolean.TYPE.getName().equals(name)) {
            return PRIMITIVE_BOOLEAN;
        }
        if (Byte.TYPE.getName().equals(name)) {
            return PRIMITIVE_BYTE;
        }
        if (Short.TYPE.getName().equals(name)) {
            return PRIMITIVE_SHORT;
        }
        if (Integer.TYPE.getName().equals(name)) {
            return PRIMITIVE_INTEGER;
        }
        if (Long.TYPE.getName().equals(name)) {
            return PRIMITIVE_LONG;
        }
        if (Double.TYPE.getName().equals(name)) {
            return PRIMITIVE_DOUBLE;
        }
        if (Float.TYPE.getName().equals(name)) {
            return PRIMITIVE_FLOAT;
        }
        if (Character.TYPE.getName().equals(name)) {
            return PRIMITIVE_CHARACTER;
        }
        if (Boolean.class.getName().equals(name) || Boolean.class.getSimpleName().equals(name)) {
            return BOOLEAN;
        }
        if (Byte.class.getName().equals(name) || Byte.class.getSimpleName().equals(name)) {
            return BYTE;
        }
        if (Short.class.getName().equals(name) || Short.class.getSimpleName().equals(name)) {
            return SHORT;
        }
        if (Integer.class.getName().equals(name) || Integer.class.getSimpleName().equals(name)) {
            return INTEGER;
        }
        if (Long.class.getName().equals(name) || Long.class.getSimpleName().equals(name)) {
            return LONG;
        }
        if (Double.class.getName().equals(name) || Double.class.getSimpleName().equals(name)) {
            return DOUBLE;
        }
        if (Float.class.getName().equals(name) || Float.class.getSimpleName().equals(name)) {
            return FLOAT;
        }
        if (BigInteger.class.getName().equals(name) || BigInteger.class.getSimpleName().equals(name)) {
            return BIG_INTEGER;
        }
        if (BigDecimal.class.getName().equals(name) || BigDecimal.class.getSimpleName().equals(name)) {
            return BIG_DECIMAL;
        }
        if (String.class.getName().equals(name) || String.class.getSimpleName().equals(name)) {
            return STRING;
        }
        if (Character.class.getName().equals(name) || Character.class.getSimpleName().equals(name)) {
            return CHARACTER;
        }
        if (UUID.class.getName().equals(name) || UUID.class.getSimpleName().equals(name)) {
            return UUID;
        }
        if (URL.class.getName().equals(name) || URL.class.getSimpleName().equals(name)) {
            return URL;
        }
        if (InetAddress.class.getName().equals(name) || InetAddress.class.getSimpleName().equals(name)) {
            return INET_ADDRESS;
        }
        if (Blob.class.getName().equals(name) || Blob.class.getSimpleName().equals(name)) {
            return BLOB;
        }
        if (Clob.class.getName().equals(name) || Clob.class.getSimpleName().equals(name)) {
            return CLOB;
        }
        if (NClob.class.getName().equals(name) || NClob.class.getSimpleName().equals(name)) {
            return NCLOB;
        }
        if (Instant.class.getName().equals(name) || Instant.class.getSimpleName().equals(name)) {
            return INSTANT;
        }
        if (LocalDate.class.getName().equals(name) || LocalDate.class.getSimpleName().equals(name)) {
            return LOCAL_DATE;
        }
        if (LocalTime.class.getName().equals(name) || LocalTime.class.getSimpleName().equals(name)) {
            return LOCAL_TIME;
        }
        if (LocalDateTime.class.getName().equals(name) || LocalDateTime.class.getSimpleName().equals(name)) {
            return LOCAL_DATE_TIME;
        }
        if (ZonedDateTime.class.getName().equals(name) || ZonedDateTime.class.getSimpleName().equals(name)) {
            return ZONED_DATE_TIME;
        }
        if (OffsetTime.class.getName().equals(name) || OffsetTime.class.getSimpleName().equals(name)) {
            return OFFSET_TIME;
        }
        if (OffsetDateTime.class.getName().equals(name) || OffsetDateTime.class.getSimpleName().equals(name)) {
            return OFFSET_DATE_TIME;
        }
        if (ZoneId.class.getName().equals(name) || ZoneId.class.getSimpleName().equals(name)) {
            return ZONE_ID;
        }
        if (ZoneOffset.class.getName().equals(name) || ZoneOffset.class.getSimpleName().equals(name)) {
            return ZONE_OFFSET;
        }
        if (Duration.class.getName().equals(name) || Duration.class.getSimpleName().equals(name)) {
            return DURATION;
        }
        if (Year.class.getName().equals(name) || Year.class.getSimpleName().equals(name)) {
            return YEAR;
        }
        if (Timestamp.class.getName().equals(name) || Timestamp.class.getSimpleName().equals(name)) {
            return JDBC_TIMESTAMP;
        }
        if (Date.class.getName().equals(name) || Date.class.getSimpleName().equals(name)) {
            return JDBC_DATE;
        }
        if (Time.class.getName().equals(name) || Time.class.getSimpleName().equals(name)) {
            return JDBC_TIME;
        }
        if (Calendar.class.getName().equals(name) || Calendar.class.getSimpleName().equals(name) || GregorianCalendar.class.getName().equals(name) || GregorianCalendar.class.getSimpleName().equals(name)) {
            return CALENDAR;
        }
        if (TimeZone.class.getName().equals(name) || TimeZone.class.getSimpleName().equals(name)) {
            return TIME_ZONE;
        }
        if (Currency.class.getName().equals(name) || Currency.class.getSimpleName().equals(name)) {
            return CURRENCY;
        }
        if (Locale.class.getName().equals(name) || Locale.class.getSimpleName().equals(name)) {
            return LOCALE;
        }
        if (Class.class.getName().equals(name) || Class.class.getSimpleName().equals(name)) {
            return CLASS;
        }
        return null;
    }

    private static /* synthetic */ SimpleTypeInterpretation[] $values() {
        return new SimpleTypeInterpretation[]{BOOLEAN, BYTE, SHORT, INTEGER, LONG, DOUBLE, FLOAT, BIG_INTEGER, BIG_DECIMAL, CHARACTER, STRING, INSTANT, DURATION, YEAR, LOCAL_DATE_TIME, LOCAL_DATE, LOCAL_TIME, OFFSET_DATE_TIME, OFFSET_TIME, ZONED_DATE_TIME, ZONE_ID, ZONE_OFFSET, UUID, URL, INET_ADDRESS, CURRENCY, LOCALE, CLASS, BLOB, CLOB, NCLOB, JDBC_TIMESTAMP, JDBC_DATE, JDBC_TIME, CALENDAR, TIME_ZONE, SERIALIZABLE, PRIMITIVE_BOOLEAN, PRIMITIVE_BYTE, PRIMITIVE_SHORT, PRIMITIVE_INTEGER, PRIMITIVE_LONG, PRIMITIVE_DOUBLE, PRIMITIVE_FLOAT, PRIMITIVE_CHARACTER};
    }

    static {
        $VALUES = SimpleTypeInterpretation.$values();
    }
}

