/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt.stubs;

import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kapt.base.stubs.KotlinPosition;
import org.jetbrains.kotlin.kapt.stubs.MemberData;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0012\u0012\u0004\u0012\u0002H\u00010\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0003B%\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/kapt/stubs/MembersPositionComparator;", "T", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "classSource", "Lorg/jetbrains/kotlin/kapt/base/stubs/KotlinPosition;", "memberData", "", "Lorg/jetbrains/kotlin/kapt/stubs/MemberData;", "<init>", "(Lorg/jetbrains/kotlin/kapt/base/stubs/KotlinPosition;Ljava/util/Map;)V", "getClassSource", "()Lorg/jetbrains/kotlin/kapt/base/stubs/KotlinPosition;", "getMemberData", "()Ljava/util/Map;", "compare", "", "o1", "o2", "(Ljava/lang/Object;Ljava/lang/Object;)I", "compareDescriptors", "m1", "m2", "kotlin-annotation-processing"})
public final class MembersPositionComparator<T>
implements Comparator<T> {
    @Nullable
    private final KotlinPosition classSource;
    @NotNull
    private final Map<T, MemberData> memberData;

    public MembersPositionComparator(@Nullable KotlinPosition classSource, @NotNull Map<T, MemberData> memberData) {
        Intrinsics.checkNotNullParameter(memberData, (String)"memberData");
        this.classSource = classSource;
        this.memberData = memberData;
    }

    @Nullable
    public final KotlinPosition getClassSource() {
        return this.classSource;
    }

    @NotNull
    public final Map<T, MemberData> getMemberData() {
        return this.memberData;
    }

    @Override
    public int compare(T o1, T o2) {
        int positionCompare;
        MemberData data1 = (MemberData)MapsKt.getValue(this.memberData, o1);
        MemberData data2 = (MemberData)MapsKt.getValue(this.memberData, o2);
        if (this.classSource == null) {
            return this.compareDescriptors(data1, data2);
        }
        KotlinPosition position1 = data1.getPosition();
        KotlinPosition position2 = data2.getPosition();
        int n = position1 != null && Intrinsics.areEqual((Object)position1.getPath(), (Object)this.classSource.getPath()) ? (position2 != null && Intrinsics.areEqual((Object)position2.getPath(), (Object)this.classSource.getPath()) ? ((positionCompare = Intrinsics.compare((int)position1.getPos(), (int)position2.getPos())) != 0 ? positionCompare : this.compareDescriptors(data1, data2)) : -1) : (position2 != null && Intrinsics.areEqual((Object)position2.getPath(), (Object)this.classSource.getPath()) ? 1 : this.compareDescriptors(data1, data2));
        return n;
    }

    private final int compareDescriptors(MemberData m1, MemberData m2) {
        int nameComparison = m1.getName().compareTo(m2.getName());
        if (nameComparison != 0) {
            return nameComparison;
        }
        return m1.getDescriptor().compareTo(m2.getDescriptor());
    }
}

