/* SPDX-FileCopyrightText: 2010 - Jesse van den Kieboom
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>
#include <gtksourceview/gtksourcetypes.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_GUTTER_RENDERER			(gtk_source_gutter_renderer_get_type ())
#define GTK_SOURCE_GUTTER_RENDERER(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_GUTTER_RENDERER, GtkSourceGutterRenderer))
#define GTK_SOURCE_GUTTER_RENDERER_CONST(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_GUTTER_RENDERER, GtkSourceGutterRenderer const))
#define GTK_SOURCE_GUTTER_RENDERER_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_SOURCE_TYPE_GUTTER_RENDERER, GtkSourceGutterRendererClass))
#define GTK_SOURCE_IS_GUTTER_RENDERER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_SOURCE_TYPE_GUTTER_RENDERER))
#define GTK_SOURCE_IS_GUTTER_RENDERER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_GUTTER_RENDERER))
#define GTK_SOURCE_GUTTER_RENDERER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_SOURCE_TYPE_GUTTER_RENDERER, GtkSourceGutterRendererClass))

typedef struct _GtkSourceGutterRenderer         GtkSourceGutterRenderer;
typedef struct _GtkSourceGutterRendererClass    GtkSourceGutterRendererClass;
typedef struct _GtkSourceGutterRendererPrivate  GtkSourceGutterRendererPrivate;

/**
 * GtkSourceGutterRendererState:
 * @GTK_SOURCE_GUTTER_RENDERER_STATE_NORMAL: normal state
 * @GTK_SOURCE_GUTTER_RENDERER_STATE_CURSOR: area in the renderer represents the
 * line on which the insert cursor is currently positioned
 * @GTK_SOURCE_GUTTER_RENDERER_STATE_PRELIT: the mouse pointer is currently
 * over the activatable area of the renderer
 * @GTK_SOURCE_GUTTER_RENDERER_STATE_SELECTED: area in the renderer represents
 * a line in the buffer which contains part of the selection
 **/
typedef enum _GtkSourceGutterRendererState
{
	GTK_SOURCE_GUTTER_RENDERER_STATE_NORMAL = 0,
	GTK_SOURCE_GUTTER_RENDERER_STATE_CURSOR = 1 << 0,
	GTK_SOURCE_GUTTER_RENDERER_STATE_PRELIT = 1 << 1,
	GTK_SOURCE_GUTTER_RENDERER_STATE_SELECTED = 1 << 2
} GtkSourceGutterRendererState;

/**
 * GtkSourceGutterRendererAlignmentMode:
 * @GTK_SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_CELL: The full cell.
 * @GTK_SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_FIRST: The first line.
 * @GTK_SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_LAST: The last line.
 *
 * The alignment mode of the renderer, when a cell spans multiple lines (due to
 * text wrapping).
 **/
typedef enum _GtkSourceGutterRendererAlignmentMode
{
	GTK_SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_CELL,
	GTK_SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_FIRST,
	GTK_SOURCE_GUTTER_RENDERER_ALIGNMENT_MODE_LAST
} GtkSourceGutterRendererAlignmentMode;

struct _GtkSourceGutterRenderer
{
	GInitiallyUnowned parent;

	/*< private >*/
	GtkSourceGutterRendererPrivate *priv;
};

struct _GtkSourceGutterRendererClass
{
	GInitiallyUnownedClass parent_class;

	/*< public >*/
	void (*begin)               (GtkSourceGutterRenderer     *renderer,
	                             cairo_t                     *cr,
	                             GdkRectangle                *background_area,
	                             GdkRectangle                *cell_area,
	                             GtkTextIter                 *start,
	                             GtkTextIter                 *end);

	void (*draw)                (GtkSourceGutterRenderer      *renderer,
	                             cairo_t                      *cr,
	                             GdkRectangle                 *background_area,
	                             GdkRectangle                 *cell_area,
	                             GtkTextIter                  *start,
	                             GtkTextIter                  *end,
	                             GtkSourceGutterRendererState  state);

	void (*end)                 (GtkSourceGutterRenderer      *renderer);

	/**
	 * GtkSourceGutterRendererClass::change_view:
	 * @renderer: a #GtkSourceGutterRenderer.
	 * @old_view: (nullable): the old #GtkTextView.
	 *
	 * This is called when the text view changes for @renderer.
	 */
	void (*change_view)         (GtkSourceGutterRenderer      *renderer,
	                             GtkTextView                  *old_view);

	/**
	 * GtkSourceGutterRendererClass::change_buffer:
	 * @renderer: a #GtkSourceGutterRenderer.
	 * @old_buffer: (nullable): the old #GtkTextBuffer.
	 *
	 * This is called when the text buffer changes for @renderer.
	 */
	void (*change_buffer)       (GtkSourceGutterRenderer      *renderer,
	                             GtkTextBuffer                *old_buffer);

	/* Signal handlers */
	gboolean (*query_activatable) (GtkSourceGutterRenderer      *renderer,
	                               GtkTextIter                  *iter,
	                               GdkRectangle                 *area,
	                               GdkEvent                     *event);

	void (*activate)            (GtkSourceGutterRenderer      *renderer,
	                             GtkTextIter                  *iter,
	                             GdkRectangle                 *area,
	                             GdkEvent                     *event);

	void (*queue_draw)          (GtkSourceGutterRenderer      *renderer);

	gboolean (*query_tooltip)   (GtkSourceGutterRenderer      *renderer,
	                             GtkTextIter                  *iter,
	                             GdkRectangle                 *area,
	                             gint                          x,
	                             gint                          y,
	                             GtkTooltip                   *tooltip);

	void (*query_data)          (GtkSourceGutterRenderer      *renderer,
	                             GtkTextIter                  *start,
	                             GtkTextIter                  *end,
	                             GtkSourceGutterRendererState  state);

	gpointer padding[1];
};

G_MODULE_EXPORT
GType    gtk_source_gutter_renderer_get_type (void) G_GNUC_CONST;

G_MODULE_EXPORT
void     gtk_source_gutter_renderer_begin           (GtkSourceGutterRenderer      *renderer,
                                                     cairo_t                      *cr,
                                                     GdkRectangle                 *background_area,
                                                     GdkRectangle                 *cell_area,
                                                     GtkTextIter                  *start,
                                                     GtkTextIter                  *end);

G_MODULE_EXPORT
void     gtk_source_gutter_renderer_draw            (GtkSourceGutterRenderer      *renderer,
                                                     cairo_t                      *cr,
                                                     GdkRectangle                 *background_area,
                                                     GdkRectangle                 *cell_area,
                                                     GtkTextIter                  *start,
                                                     GtkTextIter                  *end,
                                                     GtkSourceGutterRendererState  state);

G_MODULE_EXPORT
void     gtk_source_gutter_renderer_end             (GtkSourceGutterRenderer      *renderer);

G_MODULE_EXPORT
gint     gtk_source_gutter_renderer_get_size        (GtkSourceGutterRenderer      *renderer);

G_MODULE_EXPORT
void    gtk_source_gutter_renderer_set_size         (GtkSourceGutterRenderer      *renderer,
                                                     gint                          size);

G_MODULE_EXPORT
void     gtk_source_gutter_renderer_set_visible     (GtkSourceGutterRenderer      *renderer,
                                                     gboolean                      visible);

G_MODULE_EXPORT
gboolean gtk_source_gutter_renderer_get_visible     (GtkSourceGutterRenderer      *renderer);

G_MODULE_EXPORT
void     gtk_source_gutter_renderer_get_padding     (GtkSourceGutterRenderer      *renderer,
                                                     gint                         *xpad,
                                                     gint                         *ypad);

G_MODULE_EXPORT
void     gtk_source_gutter_renderer_set_padding     (GtkSourceGutterRenderer      *renderer,
                                                     gint                          xpad,
                                                     gint                          ypad);

G_MODULE_EXPORT
void     gtk_source_gutter_renderer_get_alignment   (GtkSourceGutterRenderer      *renderer,
                                                     gfloat                       *xalign,
                                                     gfloat                       *yalign);

G_MODULE_EXPORT
void     gtk_source_gutter_renderer_set_alignment   (GtkSourceGutterRenderer      *renderer,
                                                     gfloat                        xalign,
                                                     gfloat                        yalign);

G_MODULE_EXPORT
void     gtk_source_gutter_renderer_set_alignment_mode (GtkSourceGutterRenderer              *renderer,
                                                        GtkSourceGutterRendererAlignmentMode  mode);

G_MODULE_EXPORT
GtkTextWindowType
	gtk_source_gutter_renderer_get_window_type  (GtkSourceGutterRenderer      *renderer);

G_MODULE_EXPORT
GtkTextView *gtk_source_gutter_renderer_get_view    (GtkSourceGutterRenderer      *renderer);

G_MODULE_EXPORT
GtkSourceGutterRendererAlignmentMode
	gtk_source_gutter_renderer_get_alignment_mode (GtkSourceGutterRenderer    *renderer);

G_MODULE_EXPORT
gboolean gtk_source_gutter_renderer_get_background  (GtkSourceGutterRenderer      *renderer,
                                                     GdkRGBA                      *color);

G_MODULE_EXPORT
void     gtk_source_gutter_renderer_set_background  (GtkSourceGutterRenderer      *renderer,
                                                     const GdkRGBA                *color);

/* Emits the 'activate' signal */
G_MODULE_EXPORT
void     gtk_source_gutter_renderer_activate        (GtkSourceGutterRenderer      *renderer,
                                                     GtkTextIter                  *iter,
                                                     GdkRectangle                 *area,
                                                     GdkEvent                     *event);

/* Emits the 'query-activatable' signal */
G_MODULE_EXPORT
gboolean gtk_source_gutter_renderer_query_activatable (GtkSourceGutterRenderer      *renderer,
                                                       GtkTextIter                  *iter,
                                                       GdkRectangle                 *area,
                                                       GdkEvent                     *event);

/* Emits the 'queue-draw' signal */
G_MODULE_EXPORT
void     gtk_source_gutter_renderer_queue_draw      (GtkSourceGutterRenderer      *renderer);

/* Emits the 'query-tooltip' signal */
G_MODULE_EXPORT
gboolean gtk_source_gutter_renderer_query_tooltip   (GtkSourceGutterRenderer      *renderer,
                                                     GtkTextIter                  *iter,
                                                     GdkRectangle                 *area,
                                                     gint                          x,
                                                     gint                          y,
                                                     GtkTooltip                   *tooltip);

/* Emits the 'query-data' signal */
G_MODULE_EXPORT
void     gtk_source_gutter_renderer_query_data      (GtkSourceGutterRenderer      *renderer,
                                                     GtkTextIter                  *start,
                                                     GtkTextIter                  *end,
                                                     GtkSourceGutterRendererState  state);

G_END_DECLS
